/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.codegen;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.WarningFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.generator.GeneratorImpl;
import com.ibm.db2.cmx.tools.internal.generator.HandlerInfo;
import com.ibm.db2.cmx.tools.internal.generator.jdt.TypeHelper;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MetaDataInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import java.util.List;
import java.util.Map;

public class RowHandlerGenerator {
    private StringBuilder stringBuffer_;
    private ClassInfo classInfo_;
    private GeneratorImpl generatorImpl_;

    public RowHandlerGenerator(ClassInfo classInfo, StringBuilder stringBuilder, GeneratorImpl generatorImpl) {
        this.stringBuffer_ = stringBuilder;
        this.classInfo_ = classInfo;
        this.generatorImpl_ = generatorImpl;
    }

    public void generateRowHandler(MethodInfo methodInfo, TypeInfo typeInfo, HandlerInfo handlerInfo) {
        if (handlerInfo != null) {
            StringBuilder stringBuilder = this.stringBuffer_;
            this.stringBuffer_ = new StringBuilder();
            if (handlerInfo.getJavaPackageName() == null) {
                handlerInfo.setJavaPackageName(this.classInfo_.getPackageName());
            }
            if (handlerInfo.getHandlerClassName() == null) {
                handlerInfo.setHandlerClassName(methodInfo.getRowHandlerClassNameForStatementDescriptor(""));
            }
            if (null != handlerInfo.getJavaPackageName() && !"".equals(handlerInfo.getJavaPackageName())) {
                this.stringBuffer_.append("package " + handlerInfo.getJavaPackageName() + ";\n");
            }
            this.stringBuffer_.append("import java.sql.SQLException;\n");
            this.stringBuffer_.append("import com.ibm.db2.cmx.runtime.generator.BaseRowHandler;\n");
            TypeInfo typeInfo2 = methodInfo.getReturnType();
            this.stringBuffer_.append("import " + typeInfo2.getTypeNameToImport() + ";\n");
            List<TypeInfo> list = typeInfo2.getParameterizedType();
            if (list != null) {
                for (TypeInfo typeInfo3 : list) {
                    this.stringBuffer_.append("import " + typeInfo3.getTypeNameToImport() + ";\n");
                }
            }
            this.stringBuffer_.append("\n");
            this.generateRowHandler(methodInfo, typeInfo, "", null);
            Object object = this.stringBuffer_.toString();
            object = ((String)object).replaceFirst("public static class ", "public class ");
            handlerInfo.setGeneratedHandlerCode((String)object);
            this.stringBuffer_ = stringBuilder;
        }
    }

    public void generateRowHandler(MethodInfo methodInfo, TypeInfo typeInfo, String string, String[] stringArray) {
        TypeInfo typeInfo2 = typeInfo.getBaseType();
        if (typeInfo2 == null) {
            typeInfo2 = typeInfo;
        }
        String string2 = TypeHelper.getTypeNameForGenerics(typeInfo2);
        this.generateRowHandlerHeader(methodInfo, string2, string);
        JavaType javaType = typeInfo2.getJavaType();
        switch (javaType) {
            case MAP: {
                this.generateCodeToCreateAndPopulateMap(methodInfo, typeInfo2, stringArray);
                break;
            }
            case DERIVEDLIST: 
            case COLLECTION: {
                this.generateCodeToCreateReturnCollation(methodInfo, typeInfo2, stringArray);
                break;
            }
            default: {
                this.generateCodeToCreateAndPopulateObject(methodInfo, typeInfo2, stringArray);
            }
        }
        this.generateRowHandlerFooter();
    }

    public void generateGeneratedKeyRowHandler(MethodInfo methodInfo, List<TypeInfo> list) {
        if (methodInfo.hasAutoGeneratedKeys() && (methodInfo.getSqlStatementType() == SqlStatementType.UPDATE || methodInfo.getSqlStatementType() == SqlStatementType.INSERT || methodInfo.getSqlStatementType() == SqlStatementType.MERGE)) {
            TypeInfo typeInfo = list.get(0);
            BeanInformation beanInformation = methodInfo.getInputBeanInfo().get(0);
            String string = typeInfo.getTypeName();
            List<String> list2 = methodInfo.getInputBeanInfo().get(0).getAutoGeneratedKeys();
            if (list2 != null) {
                this.generateRowHandlerHeader(methodInfo, string, "");
                this.generateCodeToSetValueUsingSetterMethodsAndFields(beanInformation, list2, methodInfo);
                this.stringBuffer_.append("    }\n");
                this.stringBuffer_.append("  }\n\n");
            }
        }
    }

    private void generateCodeToCreateReturnCollation(MethodInfo methodInfo, TypeInfo typeInfo, String[] stringArray) {
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (methodInfo.getResultMetaDataInfo() != null) {
            stringArray2 = methodInfo.getResultMetaDataInfo().getFieldNames();
            stringArray3 = methodInfo.getResultMetaDataInfo().getTableNames();
        }
        if (stringArray2 != null && stringArray2.length == 1 && stringArray2[0].equalsIgnoreCase("this")) {
            if (JavaType.TIMESTAMPTZ.equals((Object)typeInfo.getJavaType())) {
                this.stringBuffer_.append("      returnObject = (" + typeInfo.getTypeName() + ") this.getDBTimestamp (rs, 1);\n");
            } else {
                this.stringBuffer_.append("      returnObject = (" + typeInfo.getTypeName() + ") rs.getObject (1);\n");
            }
        } else {
            this.stringBuffer_.append("      returnObject = new " + typeInfo.getTypeName() + " ();\n\n");
        }
        List<TypeInfo> list = typeInfo.getParameterizedType();
        int n2 = 0;
        for (TypeInfo typeInfo2 : list) {
            this.generateCodeToCreateAndPopulateBean(methodInfo, typeInfo2, stringArray2, stringArray3, "returnObject" + ++n2, true, stringArray);
            this.stringBuffer_.append("      returnObject.add (returnObject" + n2 + ");\n\n");
        }
    }

    private void generateCodeToCreateAndPopulateBean(MethodInfo methodInfo, TypeInfo typeInfo, String[] stringArray, String[] stringArray2, String string, boolean bl2, String[] stringArray3) {
        if (stringArray != null) {
            if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("THIS")) {
                if (bl2) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_QOC_MULTBEAN", methodInfo.getMethodName()), null, 10220, null, methodInfo);
                }
                if (JavaType.TIMESTAMPTZ.equals((Object)typeInfo.getJavaType())) {
                    this.stringBuffer_.append("      returnObject = (" + typeInfo.getTypeName() + ") this.getDBTimestamp (rs, 1);\n");
                } else {
                    this.stringBuffer_.append("      returnObject = (" + typeInfo.getTypeName() + ") rs.getObject (1);\n");
                }
                if (stringArray3 != null) {
                    stringArray3[0] = typeInfo.getTypeName();
                }
            } else {
                if (bl2) {
                    this.stringBuffer_.append("      " + typeInfo.getTypeName() + " " + string + " = new " + typeInfo.getTypeName() + " ();\n");
                } else {
                    this.stringBuffer_.append("      " + string + " = new " + typeInfo.getTypeName() + " ();\n");
                }
                String string2 = typeInfo.getQualifiedName();
                if (null == string2 || string2.trim().equals("")) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RET_TYPE", methodInfo.getMethodName()), null, 10221, null, methodInfo);
                }
                Map<String, String> map = null;
                Map<Integer, String> map2 = null;
                Map<Integer, String> map3 = null;
                if (null != methodInfo.getPatternContainer()) {
                    map = methodInfo.getPatternContainer().getTablePattern();
                    map2 = methodInfo.getPatternContainer().getBeanMappingForRSM();
                    map3 = methodInfo.getPatternContainer().getPropertyMappingForRSM();
                }
                if (null != map && (null != map2 || null != map3)) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_TABLE_MAP", methodInfo.getMethodName()), null, 10222, null, methodInfo);
                }
                boolean bl3 = null == map && null == map2 && null == map3;
                BeanInformation beanInformation = methodInfo.getOutputBeanInfo(typeInfo);
                beanInformation.checkBeanValidityAndThrowExceptionIfNeeded(methodInfo);
                Map<Integer, BeanPropertyInformation> map4 = beanInformation.getHqbIdOverrideMap();
                boolean bl4 = map4 != null && map4.size() > 0;
                Map<String, BeanPropertyInformation> map5 = beanInformation.getHqbIdExcludeMap();
                boolean bl5 = map5 != null && map5.size() > 0;
                String string3 = beanInformation.getParameterWrapperForSetMethod();
                for (int i10 = 0; i10 < stringArray.length; ++i10) {
                    int n2;
                    Object object;
                    Object object2;
                    String string4;
                    Object object3;
                    String string5 = null;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    String string6 = null;
                    if (null != map && null != (object3 = methodInfo.getResultMetaDataInfo().getTableNames()[i10]) && !((String)object3).trim().equals("") && null != (string6 = map.get(string4 = ((String)object3).toLowerCase() + "=>" + string2.toLowerCase()))) {
                        bl6 = true;
                    }
                    if (null != map2 && !map2.equals("")) {
                        string5 = map2.get(i10 + 1);
                    }
                    bl7 = string2.equals(string5);
                    if (!bl3 && !bl6 && !bl7) continue;
                    object3 = null;
                    string4 = null;
                    if (null != map3 && !map3.equals("")) {
                        string4 = map3.get(i10 + 1);
                    }
                    TypeInfo typeInfo2 = null;
                    if (null != string4) {
                        object3 = beanInformation.getPropertyUsingCaseInSensitiveName(string4, null, true);
                        typeInfo2 = RowHandlerGenerator.getTypeInfo((BeanPropertyInformation)object3);
                    } else {
                        object3 = beanInformation.getPropertyUsingCaseInSensitiveName(stringArray[i10], stringArray2[i10], false);
                        typeInfo2 = RowHandlerGenerator.getTypeInfo((BeanPropertyInformation)object3);
                    }
                    boolean bl8 = false;
                    boolean bl9 = false;
                    if (methodInfo.isNestedBean()) {
                        if (bl4 && (object2 = beanInformation.getHqbIdOverrideMap().get(i10)) != null) {
                            object3 = object2;
                            typeInfo2 = RowHandlerGenerator.getTypeInfo((BeanPropertyInformation)object3);
                            bl9 = true;
                        }
                        if (null != typeInfo2 && !bl9) {
                            if (typeInfo2.getJavaType() == JavaType.LIST) {
                                bl8 = true;
                            } else if (typeInfo2.getJavaType() == JavaType.BEAN) {
                                object2 = typeInfo2.getFullyQualifiedName();
                                object = null;
                                object = methodInfo.getNestedBeansInfoMap().get(object2);
                                if (!(object == null && (object = methodInfo.getOutputBeanInfoMap().get(object2)) == null || ((BeanInformation)object).isIdLessBean())) {
                                    bl8 = true;
                                }
                            }
                        }
                        if (!bl8 && !bl9 && bl5 && (object2 = beanInformation.getHqbExcludePropertyUsingCaseInSensitiveName(stringArray[i10], stringArray2[i10])) != null) {
                            object3 = null;
                            typeInfo2 = null;
                        }
                    }
                    object2 = null;
                    if (bl8) continue;
                    if (null != typeInfo2) {
                        methodInfo.indicateResultSetColumnUsed(i10, methodInfo.getCurrHandlerName());
                        object2 = RowHandlerGenerator.generateGetterMethodString(typeInfo2.getJavaType(), i10 + 1, methodInfo, typeInfo2.getQualifiedName());
                    } else if (beanInformation.hasGenericSetWithParamsMethod()) {
                        methodInfo.indicateResultSetColumnUsed(i10, methodInfo.getCurrHandlerName());
                        object2 = RowHandlerGenerator.generateGetterMethodString(JavaType.OBJECT, i10 + 1, methodInfo, null);
                    } else if (null != string3) {
                        methodInfo.indicateResultSetColumnUsed(i10, methodInfo.getCurrHandlerName());
                        object2 = RowHandlerGenerator.generateGetterMethodString(JavaType.OBJECT, i10 + 1, methodInfo, null);
                    }
                    object = null;
                    String string7 = null;
                    String string8 = null;
                    if (null != object3 && null != (object = ((BeanPropertyInformation)object3).getWriteMethod())) {
                        this.checkAndThrowExceptionForPropertyNotFound(methodInfo, stringArray, i10, (String)object2);
                        string8 = ((BeanPropertyInformation)object3).getFormatterClassQualifiedName();
                        if (string8 != null) {
                            String string9 = "pdqFieldFormatter" + String.valueOf(i10 + 1);
                            this.stringBuffer_.append("      " + string8 + " " + string9 + " = new " + string8 + "(\"" + ((BeanPropertyInformation)object3).getFormattingOptions() + "\"); \n");
                            this.stringBuffer_.append("      " + string + "." + (String)object + "(" + string9 + ".format(getObject (rs, " + (i10 + 1) + "))); \n");
                        } else {
                            this.stringBuffer_.append("      " + string + "." + (String)object + "(" + (String)object2 + "); \n");
                        }
                        if (stringArray3 == null) continue;
                        stringArray3[i10] = object;
                        continue;
                    }
                    if (null != object3 && null != (string7 = ((BeanPropertyInformation)object3).getField())) {
                        this.checkAndThrowExceptionForPropertyNotFound(methodInfo, stringArray, i10, (String)object2);
                        this.stringBuffer_.append("      " + string + "." + string7 + " = " + (String)object2 + "; \n");
                        if (stringArray3 == null) continue;
                        stringArray3[i10] = string7;
                        continue;
                    }
                    if (beanInformation.hasGenericSetWithParamsMethod()) {
                        this.stringBuffer_.append("      ");
                        this.stringBuffer_.append(string);
                        this.stringBuffer_.append(".");
                        int n3 = this.stringBuffer_.length();
                        this.stringBuffer_.append("set( \"");
                        this.stringBuffer_.append(stringArray[i10].toLowerCase());
                        this.stringBuffer_.append("\" , \"");
                        this.stringBuffer_.append(stringArray2[i10].toLowerCase());
                        this.stringBuffer_.append("\" , ");
                        this.stringBuffer_.append(i10 + 1);
                        this.stringBuffer_.append(", ");
                        this.stringBuffer_.append((String)object2);
                        this.stringBuffer_.append(")");
                        n2 = this.stringBuffer_.length();
                        this.stringBuffer_.append("; \n");
                        if (stringArray3 == null) continue;
                        stringArray3[i10] = this.stringBuffer_.substring(n3, n2);
                        continue;
                    }
                    if (null != string3) {
                        this.checkAndThrowExceptionForPropertyNotFound(methodInfo, stringArray, i10, (String)object2);
                        this.stringBuffer_.append("      ");
                        this.stringBuffer_.append(string);
                        this.stringBuffer_.append(".");
                        int n4 = this.stringBuffer_.length();
                        this.stringBuffer_.append(string3);
                        this.stringBuffer_.append("( \"");
                        this.stringBuffer_.append(stringArray[i10].toLowerCase());
                        this.stringBuffer_.append("\" , ");
                        this.stringBuffer_.append((String)object2);
                        this.stringBuffer_.append(")");
                        n2 = this.stringBuffer_.length();
                        this.stringBuffer_.append("; \n");
                        if (stringArray3 == null) continue;
                        stringArray3[i10] = this.stringBuffer_.substring(n4, n2);
                        continue;
                    }
                    if (methodInfo.isNestedBean()) continue;
                    WarningFactory.createPureQueryWarningForGeneratorOnly(Messages.getText("WARN_BEAN_UPD_GEN", typeInfo.getQualifiedName(), stringArray[i10]), 10290, this.generatorImpl_, null, methodInfo, this.getClass(), "generateCodeToCreateAndPopulateBean (MethodInfo, TypeInfo, String[], String[], String, boolean)");
                }
            }
        } else {
            if (bl2) {
                this.stringBuffer_.append("      " + typeInfo.getTypeName() + " " + string + " = new " + typeInfo.getTypeName() + " ();\n");
            } else {
                this.stringBuffer_.append("      " + string + " = new " + typeInfo.getTypeName() + " ();\n");
            }
            this.stringBuffer_.append("      " + string + " = getBeanRowHandler(" + typeInfo.getTypeName() + ".class).handle(rs, " + string + ");\n");
        }
    }

    private void checkAndThrowExceptionForPropertyNotFound(MethodInfo methodInfo, String[] stringArray, int n2, String string) {
        if (string == null) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_METH_COLNAME", methodInfo.getMethodName(), stringArray[n2 + 1]), null, 10223, null, methodInfo);
        }
    }

    private void generateCodeToCreateAndPopulateObject(MethodInfo methodInfo, TypeInfo typeInfo, String[] stringArray) {
        String[] stringArray2 = methodInfo.getFieldNamesModifedToRemoveColumnPrefix();
        if (stringArray2 == null) {
            stringArray2 = methodInfo.getResultMetaDataInfo().getFieldNames();
        }
        String[] stringArray3 = methodInfo.getResultMetaDataInfo().getTableNames();
        if (typeInfo.isBeanType()) {
            this.generateCodeToCreateAndPopulateBean(methodInfo, typeInfo, stringArray2, stringArray3, "returnObject", false, stringArray);
        } else if (stringArray2.length == 1) {
            this.generateCodetoReturnConstantType(typeInfo, methodInfo);
        } else {
            String string = typeInfo.getTypeName();
            if (methodInfo.getReturnType().isArrayType()) {
                string = string + " []";
            }
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INVALID_RETURNTYPE_FOR_QUERY", methodInfo.getMethodName(), string), null, 10224, null, methodInfo);
        }
    }

    private void generateCodetoReturnConstantType(TypeInfo typeInfo, MethodInfo methodInfo) {
        JavaType javaType = typeInfo.getJavaType();
        this.stringBuffer_.append("      returnObject = " + RowHandlerGenerator.generateGetterMethodString(javaType, 1, methodInfo, typeInfo.getFullyQualifiedName()) + ";\n");
    }

    private void generateRowHandlerFooter() {
        this.stringBuffer_.append("    \n");
        this.stringBuffer_.append("      return returnObject;\n");
        this.stringBuffer_.append("    }\n");
        this.stringBuffer_.append("  }\n\n");
    }

    private void generateCodeToCreateAndPopulateMap(MethodInfo methodInfo, TypeInfo typeInfo, String[] stringArray) {
        this.stringBuffer_.append("      returnObject = new java.util.HashMap<String, Object>();\n");
        MetaDataInfo metaDataInfo = methodInfo.getResultMetaDataInfo();
        for (int i10 = 0; i10 < metaDataInfo.getColumnCount(); ++i10) {
            if ("TIMESTAMP WITH TIME ZONE".equals(metaDataInfo.getParameterTypeName()[i10])) {
                this.stringBuffer_.append("      returnObject.put (\"" + metaDataInfo.getFieldNames()[i10] + "\", getDBTimestamp (rs, " + (i10 + 1) + "));\n");
            } else {
                this.stringBuffer_.append("      returnObject.put (\"" + metaDataInfo.getFieldNames()[i10] + "\", rs.getObject (" + (i10 + 1) + "));\n");
            }
            if (stringArray == null) continue;
            stringArray[i10] = metaDataInfo.getFieldNames()[i10];
        }
    }

    private void generateRowHandlerHeader(MethodInfo methodInfo, String string, String string2) {
        String string3 = methodInfo.getRowHandlerClassNameForStatementDescriptor(string2);
        methodInfo.setCurrHandlerName(string3);
        this.generateComments("  ");
        this.stringBuffer_.append("  public static class " + string3 + " extends BaseRowHandler<" + string + ">\n");
        this.stringBuffer_.append("  {\n");
        this.generateComments("    ");
        this.stringBuffer_.append("    public " + string + " handle (java.sql.ResultSet rs, " + string + " returnObject) throws java.sql.SQLException\n");
        this.stringBuffer_.append("    {\n");
    }

    private void generateComments(String string) {
        this.stringBuffer_.append(string + "/**\n");
        this.stringBuffer_.append(string + " * @generated\n");
        this.stringBuffer_.append(string + " */");
        this.stringBuffer_.append("\n");
    }

    protected static String generateGetterMethodString(JavaType javaType, Object object, MethodInfo methodInfo, String string) {
        switch (javaType) {
            case BIGDECIMAL: {
                return "getBigDecimal (rs, " + object + ")";
            }
            case BLOB: {
                return "getBlob (rs, " + object + ")";
            }
            case SIMPLE_BOOLEAN: {
                return "getBoolean (rs, " + object + ")";
            }
            case BOOLEAN: {
                return "getBooleanObject (rs , " + object + ")";
            }
            case SIMPLE_BYTE: {
                return "getByte (rs," + object + ")";
            }
            case BYTE: {
                return "getByteObject (rs, " + object + ")";
            }
            case SIMPLE_BYTE_ARRAY: 
            case BYTE_ARRAY: {
                return "getBytes (rs, " + object + ")";
            }
            case CLOB: {
                return "getClob (rs," + object + ")";
            }
            case SIMPLE_DOUBLE: {
                return "getDouble (rs, " + object + ")";
            }
            case DOUBLE: {
                return "getDoubleObject (rs, " + object + ")";
            }
            case DATE: {
                return "getDate (rs, " + object + ")";
            }
            case TIME: {
                return "getTime (rs, " + object + ")";
            }
            case TIMESTAMP: {
                return "getTimestamp (rs, " + object + ")";
            }
            case TIMESTAMPTZ: {
                return "getDBTimestamp (rs, " + object + ")";
            }
            case SIMPLE_FLOAT: {
                return "getFloat (rs, " + object + ")";
            }
            case FLOAT: {
                return "getFloatObject (rs, " + object + ")";
            }
            case SIMPLE_INTEGER: {
                return "getInt (rs, " + object + ")";
            }
            case INTEGER: {
                return "getIntObject (rs, " + object + ")";
            }
            case SIMPLE_LONG: {
                return "getLong (rs, " + object + ")";
            }
            case LONG: {
                return "getLongObject (rs, " + object + ")";
            }
            case SIMPLE_SHORT: {
                return "getShort (rs, " + object + ")";
            }
            case SHORT: {
                return "getShortObject (rs," + object + ")";
            }
            case STRING: {
                return "getString (rs, " + object + ")";
            }
            case INPUTSTREAM: {
                return "getBinaryStream (rs, " + object + ")";
            }
            case READER: {
                return "getCharacterStream (rs, " + object + ")";
            }
            case OBJECT: {
                return "getObject (rs, " + object + ")";
            }
            case SQLXML: 
            case ROWID: 
            case BEAN: {
                return "( " + string + " ) getObject (rs, " + object + ")";
            }
        }
        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_TYPE_NOTSUP", new Object[]{javaType}), null, 10226, null, methodInfo);
    }

    protected static TypeInfo getTypeInfo(BeanPropertyInformation beanPropertyInformation) {
        if (beanPropertyInformation != null) {
            return beanPropertyInformation.getPropertyTypeInfo();
        }
        return null;
    }

    private void generateCodeToSetValueUsingSetterMethodsAndFields(BeanInformation beanInformation, List<String> list, MethodInfo methodInfo) {
        int n2 = 1;
        for (String string : list) {
            String string2 = null;
            BeanPropertyInformation beanPropertyInformation = beanInformation.getPropertyUsingCaseInSensitiveName(string, null, false);
            if (beanPropertyInformation != null) {
                TypeInfo typeInfo = null;
                typeInfo = beanPropertyInformation.getPropertyTypeInfo();
                string2 = beanPropertyInformation.getWriteMethod();
                if (string2 != null) {
                    this.stringBuffer_.append("      returnObject." + string2 + " (" + RowHandlerGenerator.generateGetterMethodString(typeInfo.getJavaType(), n2, methodInfo, typeInfo.getFullyQualifiedName()) + "); \n");
                } else {
                    this.stringBuffer_.append("      returnObject." + beanPropertyInformation.getField() + " = " + RowHandlerGenerator.generateGetterMethodString(typeInfo.getJavaType(), n2, methodInfo, typeInfo.getFullyQualifiedName()) + "; \n");
                }
                ++n2;
                continue;
            }
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_SET_FIELD", beanPropertyInformation.getCaseSensitivePropertyName()), null, 10227, null, methodInfo);
        }
        this.stringBuffer_.append("      return returnObject; \n");
    }
}

