/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public enum Native {

    private static boolean loaded = false;

    private static String arch() {
        return System.getProperty("os.arch");
    }

    private static OS os() {
        String string = System.getProperty("os.name");
        if (string.contains("Linux")) {
            return OS.LINUX;
        }
        if (string.contains("Mac")) {
            return OS.MAC;
        }
        if (string.contains("Windows")) {
            return OS.WINDOWS;
        }
        if (string.contains("Solaris") || string.contains("SunOS")) {
            return OS.SOLARIS;
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + string);
    }

    private static String resourceName() {
        OS oS = Native.os();
        String string = Native.class.getPackage().getName().replace('.', '/');
        return "/" + string + "/" + oS.name + "/" + Native.arch() + "/liblz4-java." + oS.libExtension;
    }

    public static synchronized boolean isLoaded() {
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void load() {
        if (loaded) {
            return;
        }
        try {
            System.loadLibrary("lz4-java");
            loaded = true;
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = Native.resourceName();
            InputStream inputStream = Native.class.getResourceAsStream(string);
            if (inputStream == null) {
                throw new UnsupportedOperationException("Unsupported OS/arch, cannot find " + string + ". Please try building from source.");
            }
            try {
                File file = File.createTempFile("liblz4-java", "." + Native.os().libExtension);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    int n2;
                    byte[] byArray = new byte[4096];
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n2);
                    }
                    try {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    System.load(file.getAbsolutePath());
                    loaded = true;
                }
                finally {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    if (file != null && file.exists()) {
                        if (!loaded) {
                            file.delete();
                        } else {
                            file.deleteOnExit();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new ExceptionInInitializerError("Cannot unpack liblz4-java");
            }
            return;
        }
    }

    private static enum OS {
        WINDOWS("win32", "so"),
        LINUX("linux", "so"),
        MAC("darwin", "dylib"),
        SOLARIS("solaris", "so");

        public final String name;
        public final String libExtension;

        private OS(String string2, String string3) {
            this.name = string2;
            this.libExtension = string3;
        }
    }
}

