/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.connector.OracleConnectionRequestInfo;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_MANAGEMENT})
public class OracleManagedConnectionFactory
implements ManagedConnectionFactory {
    private XADataSource xaDataSource;
    private String xaDataSourceName;
    private static final String RAERR_MCF_SET_XADS = "invalid xads";
    private static final String RAERR_MCF_GET_PCRED = "no password credential";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public OracleManagedConnectionFactory() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$10, null, new Object[0]);
            }
            this.xaDataSource = null;
            this.xaDataSourceName = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleManagedConnectionFactory(XADataSource xads) throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$11, null, xads);
            }
            this.xaDataSource = null;
            this.xaDataSourceName = null;
            this.xaDataSource = xads;
            this.xaDataSourceName = "XADataSource";
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setXADataSourceName(String string) {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xadsName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$0, this, string);
            }
            this.xaDataSourceName = xadsName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getXADataSourceName() {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$1, this, new Object[0]);
            }
            String string = this.xaDataSourceName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$1, this, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$1, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$2, this, connectionManager);
            }
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            DataSource dataSource = (DataSource)((Object)this.xaDataSource);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$2, this, dataSource);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$2, this, null);
            }
            return dataSource;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public Object createConnectionFactory() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$3, this, new Object[0]);
            }
            Object object = this.createConnectionFactory(null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$3, this, object);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$3, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleManagedConnection oracleManagedConnection;
            block8: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$4, this, subject, connectionRequestInfo);
                }
                try {
                    void cxRequestInfo;
                    void subject2;
                    if (this.xaDataSource == null) {
                        this.setupXADataSource();
                    }
                    XAConnection xaconn = null;
                    PasswordCredential pcred = this.getPasswordCredential((Subject)subject2, (ConnectionRequestInfo)cxRequestInfo);
                    xaconn = pcred == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(pcred.getUserName(), new String(pcred.getPassword()));
                    OracleManagedConnection omc = new OracleManagedConnection(xaconn);
                    omc.setPasswordCredential(pcred);
                    omc.setLogWriter(this.getLogWriter());
                    oracleManagedConnection = omc;
                    if (!bl) break block8;
                }
                catch (SQLException exc) {
                    EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                    rexc.setLinkedException((Exception)exc);
                    EISSystemException eISSystemException = rexc;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$4, this, (Throwable)eISSystemException);
                    }
                    throw eISSystemException;
                }
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$4, this, oracleManagedConnection);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$4, this, null);
            }
            return oracleManagedConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            void connectionSet;
            void cxRequestInfo;
            void subject2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$5, this, set, subject, connectionRequestInfo);
            }
            PasswordCredential pcred = this.getPasswordCredential((Subject)subject2, (ConnectionRequestInfo)cxRequestInfo);
            for (Object obj : connectionSet) {
                OracleManagedConnection omc;
                if (!(obj instanceof OracleManagedConnection) || !(omc = (OracleManagedConnection)obj).getPasswordCredential().equals((Object)pcred)) continue;
                OracleManagedConnection oracleManagedConnection = omc;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$5, this, oracleManagedConnection);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$5, this, null);
                }
                return oracleManagedConnection;
            }
            ManagedConnection managedConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$5, this, managedConnection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$5, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$6, this, printWriter);
            }
            try {
                void out;
                if (this.xaDataSource == null) {
                    this.setupXADataSource();
                }
                this.xaDataSource.setLogWriter((PrintWriter)out);
            }
            catch (SQLException exc) {
                EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                rexc.setLinkedException((Exception)exc);
                EISSystemException eISSystemException = rexc;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$6, this, (Throwable)eISSystemException);
                }
                throw eISSystemException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            PrintWriter printWriter;
            block8: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$7, this, new Object[0]);
                }
                try {
                    if (this.xaDataSource == null) {
                        this.setupXADataSource();
                    }
                    printWriter = this.xaDataSource.getLogWriter();
                    if (!bl) break block8;
                }
                catch (SQLException exc) {
                    EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                    rexc.setLinkedException((Exception)exc);
                    EISSystemException eISSystemException = rexc;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$7, this, (Throwable)eISSystemException);
                    }
                    throw eISSystemException;
                }
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$7, this, printWriter);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$7, this, null);
            }
            return printWriter;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    private void setupXADataSource() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$8, this, new Object[0]);
            }
            try {
                XADataSource xads;
                InitialContext ic = null;
                try {
                    Properties props = System.getProperties();
                    ic = new InitialContext(props);
                }
                catch (java.lang.SecurityException props) {
                    // empty catch block
                }
                if (ic == null) {
                    ic = new InitialContext();
                }
                if ((xads = (XADataSource)ic.lookup(this.xaDataSourceName)) == null) {
                    ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Invalid XADataSource object");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$8, this, (Throwable)resourceAdapterInternalException);
                    }
                    throw resourceAdapterInternalException;
                }
                this.xaDataSource = xads;
            }
            catch (NamingException exc) {
                ResourceException rexc = new ResourceException("NamingException: " + exc.getMessage());
                rexc.setLinkedException((Exception)exc);
                ResourceException resourceException = rexc;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$8, this, (Throwable)resourceException);
                }
                throw resourceException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private PasswordCredential getPasswordCredential(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cxRequestInfo;
            void subject2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$9, this, subject, connectionRequestInfo);
            }
            if (subject2 != null) {
                Set<PasswordCredential> creds = subject2.getPrivateCredentials(PasswordCredential.class);
                for (PasswordCredential pcred : creds) {
                    if (!pcred.getManagedConnectionFactory().equals((Object)this)) continue;
                    PasswordCredential passwordCredential = pcred;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$9, this, passwordCredential);
                        ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$9, this, null);
                    }
                    return passwordCredential;
                }
                SecurityException securityException = new SecurityException("Can not find user/password information", RAERR_MCF_GET_PCRED);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$9, this, (Throwable)securityException);
                }
                throw securityException;
            }
            if (cxRequestInfo == null) {
                PasswordCredential passwordCredential = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$9, this, passwordCredential);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$9, this, null);
                }
                return null;
            }
            OracleConnectionRequestInfo info = (OracleConnectionRequestInfo)cxRequestInfo;
            PasswordCredential pcred = new PasswordCredential(info.getUser(), info.getPassword().toCharArray());
            pcred.setManagedConnectionFactory((ManagedConnectionFactory)this);
            PasswordCredential passwordCredential = pcred;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$9, this, passwordCredential);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$9, this, null);
            }
            return passwordCredential;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleManagedConnectionFactory.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$11 = OracleManagedConnectionFactory.class.getDeclaredConstructor(XADataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleManagedConnectionFactory.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleManagedConnectionFactory.class.getDeclaredMethod("getPasswordCredential", Subject.class, ConnectionRequestInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleManagedConnectionFactory.class.getDeclaredMethod("setupXADataSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleManagedConnectionFactory.class.getDeclaredMethod("getLogWriter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleManagedConnectionFactory.class.getDeclaredMethod("setLogWriter", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleManagedConnectionFactory.class.getDeclaredMethod("matchManagedConnections", Set.class, Subject.class, ConnectionRequestInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleManagedConnectionFactory.class.getDeclaredMethod("createManagedConnection", Subject.class, ConnectionRequestInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleManagedConnectionFactory.class.getDeclaredMethod("createConnectionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleManagedConnectionFactory.class.getDeclaredMethod("createConnectionFactory", ConnectionManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleManagedConnectionFactory.class.getDeclaredMethod("getXADataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleManagedConnectionFactory.class.getDeclaredMethod("setXADataSourceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

