/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

class MessageFormatUtils {
    private static final int bytesPerLine = 8;
    private static final String DIVIDER = "     |";
    private static final String BLANK_SPACE = "   ";
    private static final String[] toHex;
    private static final char[] toChar;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    private MessageFormatUtils() {
    }

    public static Object formatLogParam(Object paramObj) {
        Object returnVal = paramObj instanceof byte[] ? MessageFormatUtils.formatPacket((byte[])paramObj, 0, ((byte[])paramObj).length) : (paramObj instanceof ByteBuffer ? MessageFormatUtils.formatPacket((ByteBuffer)paramObj, 0, ((ByteBuffer)paramObj).remaining()) : paramObj);
        return returnVal;
    }

    public static Object[] formatLogParams(Object[] paramObjs) {
        Object[] returnVals = new Object[paramObjs.length];
        for (int i2 = 0; i2 < paramObjs.length; ++i2) {
            returnVals[i2] = paramObjs[i2] instanceof byte[] ? MessageFormatUtils.formatPacket((byte[])paramObjs[i2], 0, ((byte[])paramObjs[i2]).length) : (paramObjs[i2] instanceof ByteBuffer ? MessageFormatUtils.formatPacket((ByteBuffer)paramObjs[i2], 0, ((ByteBuffer)paramObjs[i2]).remaining()) : paramObjs[i2]);
        }
        return returnVals;
    }

    public static String formatPacket(byte[] buffer, int offset, int packetLength) {
        return MessageFormatUtils.formatPacket(ByteBuffer.wrap(buffer, offset, packetLength), 0, packetLength);
    }

    public static String formatPacket(ByteBuffer buffer, int offset, int packetLength) {
        StringBuilder sb = new StringBuilder(16384);
        StringBuilder tmpBuf = new StringBuilder(80);
        if (buffer == null) {
            return "NULL";
        }
        int position = buffer.position();
        int limit = buffer.limit();
        buffer.position(offset);
        buffer.limit(packetLength);
        sb.delete(0, sb.length());
        tmpBuf.delete(0, tmpBuf.length());
        int bytesThisLine = 0;
        while (buffer.hasRemaining()) {
            int x2 = buffer.get() & 0xFF;
            sb.append(toHex[x2]);
            tmpBuf.append(toChar[x2]);
            if (++bytesThisLine != 8) continue;
            sb.append(DIVIDER);
            sb.append(tmpBuf.substring(0, tmpBuf.length()));
            sb.append("|\n");
            tmpBuf.delete(0, tmpBuf.length());
            bytesThisLine = 0;
        }
        if (bytesThisLine > 0) {
            int j2;
            int spaces = 8 - bytesThisLine - 1;
            for (j2 = 0; j2 <= spaces; ++j2) {
                sb.append(BLANK_SPACE);
            }
            sb.append(DIVIDER);
            sb.append(tmpBuf.substring(0, tmpBuf.length()));
            for (j2 = 0; j2 <= spaces; ++j2) {
                sb.append(" ");
            }
            sb.append("|\n");
            tmpBuf.delete(0, tmpBuf.length());
        }
        buffer.rewind();
        if (limit >= 0) {
            buffer.limit(limit);
        }
        if (position >= 0 && position <= limit) {
            buffer.position(position);
        }
        return sb.substring(0, sb.length());
    }

    static {
        try {
            $$$methodRef$$$4 = MessageFormatUtils.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = MessageFormatUtils.class.getDeclaredMethod("formatPacket", ByteBuffer.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = MessageFormatUtils.class.getDeclaredMethod("formatPacket", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = MessageFormatUtils.class.getDeclaredMethod("formatLogParams", Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = MessageFormatUtils.class.getDeclaredMethod("formatLogParam", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        toHex = new String[]{" 00", " 01", " 02", " 03", " 04", " 05", " 06", " 07", " 08", " 09", " 0A", " 0B", " 0C", " 0D", " 0E", " 0F", " 10", " 11", " 12", " 13", " 14", " 15", " 16", " 17", " 18", " 19", " 1A", " 1B", " 1C", " 1D", " 1E", " 1F", " 20", " 21", " 22", " 23", " 24", " 25", " 26", " 27", " 28", " 29", " 2A", " 2B", " 2C", " 2D", " 2E", " 2F", " 30", " 31", " 32", " 33", " 34", " 35", " 36", " 37", " 38", " 39", " 3A", " 3B", " 3C", " 3D", " 3E", " 3F", " 40", " 41", " 42", " 43", " 44", " 45", " 46", " 47", " 48", " 49", " 4A", " 4B", " 4C", " 4D", " 4E", " 4F", " 50", " 51", " 52", " 53", " 54", " 55", " 56", " 57", " 58", " 59", " 5A", " 5B", " 5C", " 5D", " 5E", " 5F", " 60", " 61", " 62", " 63", " 64", " 65", " 66", " 67", " 68", " 69", " 6A", " 6B", " 6C", " 6D", " 6E", " 6F", " 70", " 71", " 72", " 73", " 74", " 75", " 76", " 77", " 78", " 79", " 7A", " 7B", " 7C", " 7D", " 7E", " 7F", " 80", " 81", " 82", " 83", " 84", " 85", " 86", " 87", " 88", " 89", " 8A", " 8B", " 8C", " 8D", " 8E", " 8F", " 90", " 91", " 92", " 93", " 94", " 95", " 96", " 97", " 98", " 99", " 9A", " 9B", " 9C", " 9D", " 9E", " 9F", " A0", " A1", " A2", " A3", " A4", " A5", " A6", " A7", " A8", " A9", " AA", " AB", " AC", " AD", " AE", " AF", " B0", " B1", " B2", " B3", " B4", " B5", " B6", " B7", " B8", " B9", " BA", " BB", " BC", " BD", " BE", " BF", " C0", " C1", " C2", " C3", " C4", " C5", " C6", " C7", " C8", " C9", " CA", " CB", " CC", " CD", " CE", " CF", " D0", " D1", " D2", " D3", " D4", " D5", " D6", " D7", " D8", " D9", " DA", " DB", " DC", " DD", " DE", " DF", " E0", " E1", " E2", " E3", " E4", " E5", " E6", " E7", " E8", " E9", " EA", " EB", " EC", " ED", " EE", " EF", " F0", " F1", " F2", " F3", " F4", " F5", " F6", " F7", " F8", " F9", " FA", " FB", " FC", " FD", " FE", " FF"};
        toChar = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    }
}

