/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSetLCFixed
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterLCFixed";
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    CharacterSetLCFixed(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$3, null, oracleId, charConverter);
            }
            this.m_leadingCodes = charConverter.getLeadingCodes();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static CharacterSetLCFixed getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void charConverter;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$0, null, n2, jdbcCharacterConverters);
            }
            if (charConverter.getGroupId() == 3) {
                int oracleId;
                CharacterSetLCFixed characterSetLCFixed = new CharacterSetLCFixed(oracleId, (JdbcCharacterConverters)charConverter);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$0, null, characterSetLCFixed);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$0, null, null);
                }
                return characterSetLCFixed;
            }
            CharacterSetLCFixed characterSetLCFixed = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$0, null, characterSetLCFixed);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$0, null, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void walker;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$1, this, characterWalker);
            }
            if (walker.bytes.length - walker.next < 4) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            int leadingCode = walker.bytes[walker.next] << 8 | walker.bytes[walker.next + 1];
            for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                if (leadingCode != this.m_leadingCodes[i2]) continue;
                int c2 = 0;
                for (int j2 = 0; j2 < 4; ++j2) {
                    c2 = c2 << 8 | walker.bytes[walker.next++];
                }
                int n2 = c2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$1, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$1, this, null);
                }
                return n2;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 181, "Leading code invalid").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$1, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void c2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$2, this, characterBuffer, n2);
            }
            void leadingCode = c2 >> 16;
            for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                void buffer;
                if (leadingCode != this.m_leadingCodes[i2]) continue;
                CharacterSetLCFixed.need((CharacterBuffer)buffer, 4);
                for (int j2 = 3; j2 >= 0; --j2) {
                    buffer.bytes[buffer.next++] = (byte)(c2 >> 8 * j2 & 0xFF);
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$2, this);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$2, this, null);
                }
                return;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 181, "Leading code invalid").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$2, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetLCFixed.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$3 = CharacterSetLCFixed.class.getDeclaredConstructor(Integer.TYPE, JdbcCharacterConverters.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CharacterSetLCFixed.class.getDeclaredMethod("encode", CharacterBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterSetLCFixed.class.getDeclaredMethod("decode", CharacterWalker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterSetLCFixed.class.getDeclaredMethod("getInstance", Integer.TYPE, JdbcCharacterConverters.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

