/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.depend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.Dependency;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.depend.BasicDependency;
import org.apache.derby.impl.sql.depend.BasicProviderInfo;

public class BasicDependencyManager
implements DependencyManager {
    private final DataDictionary dd;
    private final Map<UUID, List<Dependency>> dependents = new HashMap<UUID, List<Dependency>>();
    private final Map<UUID, List<Dependency>> providers = new HashMap<UUID, List<Dependency>>();
    private static final ProviderInfo[] EMPTY_PROVIDER_INFO = new ProviderInfo[0];

    @Override
    public void addDependency(Dependent dependent, Provider provider, ContextManager contextManager) throws StandardException {
        this.addDependency(dependent, provider, contextManager, null);
    }

    private void addDependency(Dependent dependent, Provider provider, ContextManager contextManager, TransactionController transactionController) throws StandardException {
        if (!dependent.isPersistent() || !provider.isPersistent()) {
            this.addInMemoryDependency(dependent, provider, contextManager);
        } else {
            this.addStoredDependency(dependent, provider, contextManager, transactionController);
        }
    }

    private synchronized void addInMemoryDependency(Dependent dependent, Provider provider, ContextManager contextManager) throws StandardException {
        BasicDependency basicDependency = new BasicDependency(dependent, provider);
        boolean bl = false;
        boolean bl2 = this.addDependencyToTable(this.dependents, dependent.getObjectID(), basicDependency);
        if (bl2) {
            bl = this.addDependencyToTable(this.providers, provider.getObjectID(), basicDependency);
        }
        StatementContext statementContext = (StatementContext)contextManager.getContext("StatementContext");
        statementContext.addDependency(basicDependency);
    }

    private void addStoredDependency(Dependent dependent, Provider provider, ContextManager contextManager, TransactionController transactionController) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext(contextManager);
        TransactionController transactionController2 = transactionController == null ? languageConnectionContext.getTransactionExecute() : transactionController;
        this.dd.addDescriptor(new DependencyDescriptor(dependent, provider), null, 6, true, transactionController2);
    }

    private void dropDependency(LanguageConnectionContext languageConnectionContext, Dependent dependent, Provider provider) throws StandardException {
        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(dependent, provider);
        this.dd.dropStoredDependency(dependencyDescriptor, languageConnectionContext.getTransactionExecute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateFor(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (provider.isPersistent()) {
            this.coreInvalidateFor(provider, n, languageConnectionContext);
        } else {
            BasicDependencyManager basicDependencyManager = this;
            synchronized (basicDependencyManager) {
                this.coreInvalidateFor(provider, n, languageConnectionContext);
            }
        }
    }

    private void coreInvalidateFor(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        List<Dependency> list = this.getDependents(provider);
        if (list.isEmpty()) {
            return;
        }
        FormatableBitSet formatableBitSet = null;
        FormatableBitSet formatableBitSet2 = null;
        if (provider instanceof TableDescriptor && (formatableBitSet = ((TableDescriptor)provider).getReferencedColumnMap()) != null) {
            formatableBitSet2 = new FormatableBitSet(formatableBitSet.getLength());
        }
        StandardException standardException = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i >= list.size()) continue;
            Dependency dependency = list.get(i);
            Dependent dependent = dependency.getDependent();
            if (formatableBitSet != null) {
                TableDescriptor tableDescriptor = (TableDescriptor)dependency.getProvider();
                FormatableBitSet formatableBitSet3 = tableDescriptor.getReferencedColumnMap();
                if (formatableBitSet3 == null) {
                    if (!(dependent instanceof ViewDescriptor)) {
                        ((TableDescriptor)provider).setReferencedColumnMap(null);
                    }
                } else {
                    formatableBitSet2.copyFrom(formatableBitSet);
                    formatableBitSet2.and(formatableBitSet3);
                    if (formatableBitSet2.anySetBit() == -1) continue;
                    ((TableDescriptor)provider).setReferencedColumnMap(formatableBitSet2);
                }
            }
            try {
                dependent.prepareToInvalidate(provider, n, languageConnectionContext);
            }
            catch (StandardException standardException2) {
                if (standardException == null) {
                    standardException = standardException2;
                }
                try {
                    standardException2.initCause(standardException);
                    standardException = standardException2;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (standardException != null) continue;
            if (formatableBitSet != null) {
                ((TableDescriptor)provider).setReferencedColumnMap(formatableBitSet);
            }
            dependent.makeInvalid(n, languageConnectionContext);
        }
        if (standardException != null) {
            throw standardException;
        }
    }

    @Override
    public void clearDependencies(LanguageConnectionContext languageConnectionContext, Dependent dependent) throws StandardException {
        this.clearDependencies(languageConnectionContext, dependent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDependencies(LanguageConnectionContext languageConnectionContext, Dependent dependent, TransactionController transactionController) throws StandardException {
        UUID uUID = dependent.getObjectID();
        if (dependent.isPersistent()) {
            boolean bl = transactionController == null;
            this.dd.dropDependentsStoredDependencies(uUID, bl ? languageConnectionContext.getTransactionExecute() : transactionController, bl);
        }
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            List<Dependency> list = this.dependents.get(uUID);
            if (list != null) {
                for (Dependency dependency : list) {
                    this.clearProviderDependency(dependency.getProviderKey(), dependency);
                }
                this.dependents.remove(uUID);
            }
        }
    }

    @Override
    public synchronized void clearInMemoryDependency(Dependency dependency) {
        UUID uUID = dependency.getDependent().getObjectID();
        UUID uUID2 = dependency.getProviderKey();
        List<Dependency> list = this.dependents.get(uUID);
        if (list == null) {
            return;
        }
        List<Dependency> list2 = this.providers.get(uUID2);
        if (list2 == null) {
            return;
        }
        list.remove(dependency);
        if (list.isEmpty()) {
            this.dependents.remove(uUID);
        }
        list2.remove(dependency);
        if (list2.isEmpty()) {
            this.providers.remove(uUID2);
        }
    }

    @Override
    public ProviderInfo[] getPersistentProviderInfos(Dependent dependent) throws StandardException {
        List<Provider> list = this.getProviders(dependent);
        if (list.isEmpty()) {
            return EMPTY_PROVIDER_INFO;
        }
        ArrayList<BasicProviderInfo> arrayList = new ArrayList<BasicProviderInfo>();
        for (Provider provider : list) {
            if (!provider.isPersistent()) continue;
            arrayList.add(new BasicProviderInfo(provider.getObjectID(), provider.getDependableFinder(), provider.getObjectName()));
        }
        return arrayList.toArray(EMPTY_PROVIDER_INFO);
    }

    @Override
    public ProviderInfo[] getPersistentProviderInfos(ProviderList providerList) throws StandardException {
        Enumeration enumeration = providerList.elements();
        int n = 0;
        while (enumeration != null && enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!provider.isPersistent()) continue;
            ++n;
        }
        enumeration = providerList.elements();
        ProviderInfo[] providerInfoArray = new ProviderInfo[n];
        int n2 = 0;
        while (enumeration != null && enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!provider.isPersistent()) continue;
            providerInfoArray[n2++] = new BasicProviderInfo(provider.getObjectID(), provider.getDependableFinder(), provider.getObjectName());
        }
        return providerInfoArray;
    }

    @Override
    public void clearColumnInfoInProviders(ProviderList providerList) throws StandardException {
        Enumeration enumeration = providerList.elements();
        while (enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!(provider instanceof TableDescriptor)) continue;
            ((TableDescriptor)provider).setReferencedColumnMap(null);
        }
    }

    @Override
    public void copyDependencies(Dependent dependent, Dependent dependent2, boolean bl, ContextManager contextManager) throws StandardException {
        this.copyDependencies(dependent, dependent2, bl, contextManager, null);
    }

    @Override
    public void copyDependencies(Dependent dependent, Dependent dependent2, boolean bl, ContextManager contextManager, TransactionController transactionController) throws StandardException {
        List<Provider> list = this.getProviders(dependent);
        for (Provider provider : list) {
            if (bl && !provider.isPersistent()) continue;
            this.addDependency(dependent2, provider, contextManager, transactionController);
        }
    }

    @Override
    public String getActionString(int n) {
        switch (n) {
            case 12: {
                return "ALTER TABLE";
            }
            case 34: {
                return "RENAME";
            }
            case 41: {
                return "RENAME INDEX";
            }
            case 0: {
                return "COMPILE FAILED";
            }
            case 1: {
                return "DROP TABLE";
            }
            case 2: {
                return "DROP INDEX";
            }
            case 9: {
                return "DROP VIEW";
            }
            case 3: {
                return "CREATE INDEX";
            }
            case 4: {
                return "ROLLBACK";
            }
            case 5: {
                return "CHANGED CURSOR";
            }
            case 22: {
                return "CREATE CONSTRAINT";
            }
            case 19: {
                return "DROP CONSTRAINT";
            }
            case 6: {
                return "DROP ROUTINE";
            }
            case 11: {
                return "PREPARED STATEMENT RELEASE";
            }
            case 13: {
                return "DROP STORED PREPARED STATEMENT";
            }
            case 14: {
                return "USER REQUESTED INVALIDATION";
            }
            case 15: {
                return "BULK INSERT";
            }
            case 10: {
                return "CREATE_VIEW";
            }
            case 17: {
                return "DROP_JAR";
            }
            case 18: {
                return "REPLACE_JAR";
            }
            case 20: {
                return "SET_CONSTRAINTS_ENABLE";
            }
            case 21: {
                return "SET_CONSTRAINTS_DISABLE";
            }
            case 23: {
                return "INTERNAL RECOMPILE REQUEST";
            }
            case 28: {
                return "CREATE TRIGGER";
            }
            case 27: {
                return "DROP TRIGGER";
            }
            case 29: {
                return "SET TRIGGERS ENABLED";
            }
            case 30: {
                return "SET TRIGGERS DISABLED";
            }
            case 31: {
                return "MODIFY COLUMN DEFAULT";
            }
            case 33: {
                return "COMPRESS TABLE";
            }
            case 37: {
                return "DROP COLUMN";
            }
            case 46: {
                return "DROP COLUMN RESTRICT";
            }
            case 39: {
                return "DROP STATISTICS";
            }
            case 40: {
                return "UPDATE STATISTICS";
            }
            case 42: {
                return "TRUNCATE TABLE";
            }
            case 43: {
                return "DROP SYNONYM";
            }
            case 44: {
                return "REVOKE PRIVILEGE";
            }
            case 45: {
                return "REVOKE PRIVILEGE RESTRICT";
            }
            case 47: {
                return "REVOKE ROLE";
            }
            case 48: {
                return "RECHECK PRIVILEGES";
            }
            case 49: {
                return "DROP SEQUENCE";
            }
            case 50: {
                return "DROP TYPE";
            }
            case 51: {
                return "DROP DERBY AGGREGATE";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countDependencies() throws StandardException {
        List<TupleDescriptor> list = this.dd.getAllDependencyDescriptorsList();
        int n = list.size();
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            Iterator<List<Dependency>> iterator = this.dependents.values().iterator();
            Iterator<List<Dependency>> iterator2 = this.providers.values().iterator();
            while (iterator.hasNext()) {
                n += iterator.next().size();
            }
            while (iterator2.hasNext()) {
                n += iterator2.next().size();
            }
        }
        return n;
    }

    public BasicDependencyManager(DataDictionary dataDictionary) {
        this.dd = dataDictionary;
    }

    private boolean addDependencyToTable(Map<UUID, List<Dependency>> map, UUID uUID, Dependency dependency) {
        List<Dependency> list = map.get(uUID);
        if (list == null) {
            list = new ArrayList<Dependency>();
            list.add(dependency);
            map.put(uUID, list);
        } else {
            UUID uUID2 = dependency.getProvider().getObjectID();
            UUID uUID3 = dependency.getDependent().getObjectID();
            ListIterator<Dependency> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Dependency dependency2 = listIterator.next();
                if (dependency2.getProvider().getObjectID() == null || !dependency2.getProvider().getObjectID().equals(uUID2) || !dependency2.getDependent().getObjectID().equals(uUID3)) continue;
                return false;
            }
            list.add(dependency);
        }
        return true;
    }

    private void clearProviderDependency(UUID uUID, Dependency dependency) {
        List<Dependency> list = this.providers.get(uUID);
        if (list == null) {
            return;
        }
        list.remove(dependency);
        if (list.isEmpty()) {
            this.providers.remove(uUID);
        }
    }

    private List<Dependency> getDependencyDescriptorList(List<DependencyDescriptor> list, Provider provider) throws StandardException {
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        if (!list.isEmpty()) {
            for (DependencyDescriptor dependencyDescriptor : list) {
                Provider provider2;
                DependableFinder dependableFinder = dependencyDescriptor.getDependentFinder();
                Dependent dependent = (Dependent)dependableFinder.getDependable(this.dd, dependencyDescriptor.getUUID());
                if (provider != null) {
                    provider2 = provider;
                } else {
                    dependableFinder = dependencyDescriptor.getProviderFinder();
                    provider2 = (Provider)dependableFinder.getDependable(this.dd, dependencyDescriptor.getProviderID());
                }
                arrayList.add(new BasicDependency(dependent, provider2));
            }
        }
        return arrayList;
    }

    private LanguageConnectionContext getLanguageConnectionContext(ContextManager contextManager) {
        return (LanguageConnectionContext)contextManager.getContext("LanguageConnectionContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Provider> getProviders(Dependent dependent) throws StandardException {
        Object object;
        ArrayList<Provider> arrayList = new ArrayList<Provider>();
        Object object2 = this;
        synchronized (object2) {
            object = this.dependents.get(dependent.getObjectID());
            if (object != null) {
                Iterator<Dependency> iterator = object.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next().getProvider());
                }
            }
        }
        if (dependent.isPersistent()) {
            object2 = this.getDependencyDescriptorList(this.dd.getDependentsDescriptorList(dependent.getObjectID().toString()), null);
            object = object2.iterator();
            while (object.hasNext()) {
                arrayList.add(((Dependency)object.next()).getProvider());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dependency> getDependents(Provider provider) throws StandardException {
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        Object object = this;
        synchronized (object) {
            List<Dependency> list = this.providers.get(provider.getObjectID());
            if (list != null) {
                arrayList.addAll(list);
            }
        }
        if (provider.isPersistent()) {
            object = this.getDependencyDescriptorList(this.dd.getProvidersDescriptorList(provider.getObjectID().toString()), provider);
            arrayList.addAll((Collection<Dependency>)object);
        }
        return arrayList;
    }
}

