/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxDistinctInput;
import com.informix.jdbc.IfxDistinctOutput;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxUDT;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class IfxDistinct
extends IfxObject {
    IfxObject data = null;
    private static final short NO_SCALE = -1;
    private IfxDistinctInput inputStream = null;
    private IfxDistinctOutput outputStream = null;

    IfxDistinct() throws SQLException {
    }

    @Override
    public void fromObject(Object obj) throws SQLException {
        this.fromObject(obj, -1);
    }

    @Override
    public void fromObject(Object obj, int scale) throws SQLException {
        this.checkObject();
        if (obj == null || this.data == null) {
            this.nullify();
        } else {
            if (this.typeMap != null) {
                this.data.setTypeMap(this.typeMap);
            }
            if (this.outputStream == null) {
                this.outputStream = new IfxDistinctOutput(this.data, this.conn);
            } else {
                this.outputStream.reset();
            }
            if (!(obj instanceof SQLData)) {
                if (scale == -1) {
                    this.data.fromObject(obj);
                } else {
                    this.data.fromObject(obj, scale);
                }
            } else {
                ((SQLData)obj).writeSQL(this.outputStream);
                String ename = ((SQLData)obj).getSQLTypeName();
                if (ename != null) {
                    this.setExtendedTypeName(ename);
                }
            }
            this.unnullify();
        }
    }

    @Override
    public Object toObject() throws SQLException {
        return this.toObject(false);
    }

    @Override
    public Object toObject(boolean fromComplex) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (this.data instanceof IfxObject) {
            Class cls;
            if (this.typeMap == null || (cls = (Class)this.typeMap.get(this.extendedName)) == null) {
                if (fromComplex && (this.data instanceof IfxUDT || this.data instanceof IfxDistinct)) {
                    return this.data.toObject(fromComplex);
                }
                return this.data.toObject();
            }
            SQLData obj = null;
            try {
                obj = (SQLData)cls.newInstance();
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
            this.data.setTypeMap(this.typeMap);
            this.inputStream = new IfxDistinctInput(this.data, this.conn);
            obj.readSQL(this.inputStream, this.extendedName);
            return obj;
        }
        throw IfxErrMsg.getSQLException(-79716, this.conn);
    }

    @Override
    public void fromIfx(byte[] b) throws SQLException {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) throws SQLException {
        this.checkObject();
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 22 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        this.data.fromIfx(b, offset, length);
        this.checkNull();
    }

    @Override
    public void fromIfx(byte[] b, short prec) throws SQLException {
        this.fromIfx(b, 0, b.length, prec);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length, short prec) throws SQLException {
        this.checkObject();
        this.data = IfxValue.makeInstanceFromIfxType(this.conn, this.ifxType);
        this.data.fromIfx(b, offset, length, prec);
        this.checkNull();
    }

    @Override
    public byte[] toIfx() throws SQLException {
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        return this.data.toIfx();
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        return this.data.toIfxTuple();
    }

    private void checkNull() {
        if (this.data == null || this.data.isNull()) {
            this.writeTrace(99, "IfxDistinct: data is null");
            this.nullify();
        } else {
            this.writeTrace(99, "IfxDistinct: data is not null");
            this.unnullify();
        }
    }

    private void checkObject() throws SQLException {
        if (this.data == null) {
            IfxColumnInfo colinfo = new IfxColumnInfo();
            colinfo.SQLtype = this.ifxType;
            colinfo.ExtendedOwner = this.extendedOwner;
            colinfo.ExtendedId = this.sourceType;
            colinfo.ExtendedName = this.ifxType == 40 || this.ifxType == 41 || this.ifxType == 44 || this.ifxType == 19 || this.ifxType == 20 || this.ifxType == 21 || this.ifxType == 22 ? this.conn.getXnameByXid(colinfo.ExtendedId) : this.extendedName;
            this.data = IfxValue.makeInstance(this.conn, colinfo);
            if (this.data == null) {
                throw IfxErrMsg.getSQLException(-79728, this.conn);
            }
            this.setIfxType(this.data.getIfxType());
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toInt();
    }

    @Override
    public void fromInt(int x) throws SQLException {
        this.checkObject();
        this.data.fromInt(x);
        this.checkNull();
    }

    @Override
    public short toShort() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toShort();
    }

    @Override
    public void fromShort(short x) throws SQLException {
        this.checkObject();
        this.data.fromShort(x);
        this.checkNull();
    }

    @Override
    public String toString() {
        if (this.data == null) {
            return null;
        }
        return this.data.toString();
    }

    @Override
    public void fromString(String x) throws SQLException {
        this.checkObject();
        this.data.fromString(x);
        this.checkNull();
    }

    @Override
    public long toLong() throws SQLException {
        if (this.data == null) {
            return 0L;
        }
        return this.data.toLong();
    }

    @Override
    public void fromLong(long x) throws SQLException {
        this.checkObject();
        this.data.fromLong(x);
        this.checkNull();
    }

    @Override
    public void fromLong(Long x) throws SQLException {
        this.checkObject();
        this.data.fromLong(x);
        this.checkNull();
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toDecimal();
    }

    @Override
    public void fromDecimal(BigDecimal x) throws SQLException {
        this.checkObject();
        this.data.fromDecimal(x);
        this.checkNull();
    }

    @Override
    public void fromDecimal(BigDecimal x, int scale) throws SQLException {
        this.checkObject();
        this.data.fromDecimal(x, scale);
        this.checkNull();
    }

    @Override
    public byte toByte() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toByte();
    }

    @Override
    public void fromByte(Byte x) throws SQLException {
        this.checkObject();
        this.data.fromByte(x);
        this.checkNull();
    }

    @Override
    public void fromByte(byte x) throws SQLException {
        this.checkObject();
        this.data.fromByte(x);
        this.checkNull();
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.data == null) {
            return 0.0f;
        }
        return this.data.toFloat();
    }

    @Override
    public void fromFloat(Float x) throws SQLException {
        this.checkObject();
        this.data.fromFloat(x);
        this.checkNull();
    }

    @Override
    public void fromFloat(float x) throws SQLException {
        this.checkObject();
        this.data.fromFloat(x);
        this.checkNull();
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.data == null) {
            return 0.0;
        }
        return this.data.toDouble();
    }

    @Override
    public void fromDouble(Double x) throws SQLException {
        this.checkObject();
        this.data.fromDouble(x);
        this.checkNull();
    }

    @Override
    public void fromDouble(double x) throws SQLException {
        this.checkObject();
        this.data.fromDouble(x);
        this.checkNull();
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.data == null) {
            return false;
        }
        return this.data.toBoolean();
    }

    @Override
    public void fromBoolean(Boolean x) throws SQLException {
        this.checkObject();
        this.data.fromBoolean(x);
        this.checkNull();
    }

    @Override
    public void fromBoolean(boolean x) throws SQLException {
        this.checkObject();
        this.data.fromBoolean(x);
        this.checkNull();
    }

    @Override
    public Time toTime() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toTime();
    }

    @Override
    public void fromTime(Time x) throws SQLException {
        this.checkObject();
        this.data.fromTime(x);
        this.checkNull();
    }

    @Override
    public Timestamp toTimestamp() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toTimestamp();
    }

    @Override
    public void fromTimestamp(Timestamp x) throws SQLException {
        this.checkObject();
        this.data.fromTimestamp(x);
        this.checkNull();
    }

    @Override
    public Date toDate() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toDate();
    }

    @Override
    public void fromDate(Date x) throws SQLException {
        this.checkObject();
        this.data.fromDate(x);
        this.checkNull();
    }

    @Override
    public InputStream toInputStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toInputStream();
    }

    @Override
    public void fromInputStream(InputStream x, int length) throws SQLException {
        this.checkObject();
        this.data.fromInputStream(x, length);
        this.checkNull();
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toAsciiStream();
    }

    @Override
    public void fromAsciiStream(InputStream x, int length) throws SQLException {
        this.checkObject();
        this.data.fromAsciiStream(x, length);
        this.checkNull();
    }

    @Override
    public InputStream toBinaryStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toBinaryStream();
    }

    @Override
    public void fromBinaryStream(InputStream x, int length) throws SQLException {
        this.checkObject();
        this.data.fromBinaryStream(x, length);
        this.checkNull();
    }

    @Override
    public IntervalYM toIntervalYM() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toIntervalYM();
    }

    @Override
    public void fromIntervalYM(IntervalYM x) throws SQLException {
        this.checkObject();
        this.data.fromIntervalYM(x);
        this.checkNull();
    }

    @Override
    public IntervalDF toIntervalDF() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toIntervalDF();
    }

    @Override
    public void fromIntervalDF(IntervalDF x) throws SQLException {
        this.checkObject();
        this.data.fromIntervalDF(x);
        this.checkNull();
    }

    @Override
    public Clob toClob() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toClob();
    }

    @Override
    public void fromClob(Clob x) throws SQLException {
        this.checkObject();
        this.data.fromClob(x);
        this.checkNull();
    }

    @Override
    public Blob toBlob() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toBlob();
    }

    @Override
    public void fromBlob(Blob x) throws SQLException {
        this.checkObject();
        this.data.fromBlob(x);
        this.checkNull();
    }
}

