/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.endpointdiscovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.endpointdiscovery.EndpointDiscoveryProvider;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;

public class EndpointDiscoveryProviderChain
implements EndpointDiscoveryProvider {
    private static final Log LOG = LogFactory.getLog(EndpointDiscoveryProviderChain.class);
    private final List<EndpointDiscoveryProvider> providers;

    public EndpointDiscoveryProviderChain(EndpointDiscoveryProvider ... providers) {
        this.providers = new ArrayList<EndpointDiscoveryProvider>(providers.length);
        Collections.addAll(this.providers, providers);
    }

    @Override
    public boolean endpointDiscoveryEnabled() {
        for (EndpointDiscoveryProvider provider : this.providers) {
            try {
                return provider.endpointDiscoveryEnabled();
            }
            catch (Exception e) {
                LOG.debug("Unable to discover endpoint discovery setting " + provider.toString() + ": " + e.getMessage());
            }
        }
        return false;
    }
}

