/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.client.auth.oauth2;

import java.util.Collection;
import net.snowflake.client.jdbc.internal.google.api.client.auth.oauth2.TokenRequest;
import net.snowflake.client.jdbc.internal.google.api.client.auth.oauth2.TokenResponse;
import net.snowflake.client.jdbc.internal.google.api.client.http.GenericUrl;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpExecuteInterceptor;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpRequestInitializer;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpTransport;
import net.snowflake.client.jdbc.internal.google.api.client.json.JsonFactory;
import net.snowflake.client.jdbc.internal.google.api.client.util.Key;
import net.snowflake.client.jdbc.internal.google.api.client.util.Preconditions;

public class AuthorizationCodeTokenRequest
extends TokenRequest {
    @Key
    private String code;
    @Key(value="redirect_uri")
    private String redirectUri;

    public AuthorizationCodeTokenRequest(HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, String code) {
        super(transport, jsonFactory, tokenServerUrl, "authorization_code");
        this.setCode(code);
    }

    @Override
    public AuthorizationCodeTokenRequest setRequestInitializer(HttpRequestInitializer requestInitializer) {
        return (AuthorizationCodeTokenRequest)super.setRequestInitializer(requestInitializer);
    }

    @Override
    public AuthorizationCodeTokenRequest setTokenServerUrl(GenericUrl tokenServerUrl) {
        return (AuthorizationCodeTokenRequest)super.setTokenServerUrl(tokenServerUrl);
    }

    @Override
    public AuthorizationCodeTokenRequest setScopes(Collection<String> scopes) {
        return (AuthorizationCodeTokenRequest)super.setScopes(scopes);
    }

    @Override
    public AuthorizationCodeTokenRequest setGrantType(String grantType) {
        return (AuthorizationCodeTokenRequest)super.setGrantType(grantType);
    }

    @Override
    public AuthorizationCodeTokenRequest setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
        return (AuthorizationCodeTokenRequest)super.setClientAuthentication(clientAuthentication);
    }

    @Override
    public AuthorizationCodeTokenRequest setResponseClass(Class<? extends TokenResponse> responseClass) {
        return (AuthorizationCodeTokenRequest)super.setResponseClass(responseClass);
    }

    public final String getCode() {
        return this.code;
    }

    public AuthorizationCodeTokenRequest setCode(String code) {
        this.code = Preconditions.checkNotNull(code);
        return this;
    }

    public final String getRedirectUri() {
        return this.redirectUri;
    }

    public AuthorizationCodeTokenRequest setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @Override
    public AuthorizationCodeTokenRequest set(String fieldName, Object value) {
        return (AuthorizationCodeTokenRequest)super.set(fieldName, value);
    }
}

