/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.ApiMessage;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.AutoValue_ApiMessageHttpResponseParser;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpResponseParser;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.RestSerializationException;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.gson.Gson;
import net.snowflake.client.jdbc.internal.google.gson.GsonBuilder;
import net.snowflake.client.jdbc.internal.google.gson.JsonIOException;
import net.snowflake.client.jdbc.internal.google.gson.JsonSyntaxException;
import net.snowflake.client.jdbc.internal.google.gson.TypeAdapter;
import net.snowflake.client.jdbc.internal.google.gson.stream.JsonReader;
import net.snowflake.client.jdbc.internal.google.gson.stream.JsonWriter;
import net.snowflake.client.jdbc.internal.google.protobuf.TypeRegistry;

@AutoValue
public abstract class ApiMessageHttpResponseParser<ResponseT extends ApiMessage>
implements HttpResponseParser<ResponseT> {
    public abstract ResponseT getResponseInstance();

    protected abstract Gson getResponseMarshaller();

    private static <ResponseT extends ApiMessage> ApiMessageHttpResponseParser<ResponseT> create(final ResponseT responseInstance) {
        final Gson baseGson = new GsonBuilder().create();
        Gson responseMarshaller = null;
        if (responseInstance != null) {
            TypeAdapter responseTypeAdapter = new TypeAdapter<ResponseT>(){

                @Override
                public void write(JsonWriter out, ResponseT value) {
                    baseGson.toJson(value, responseInstance.getClass(), out);
                }

                @Override
                public ResponseT read(JsonReader in) {
                    return (ApiMessage)baseGson.fromJson(in, responseInstance.getClass());
                }
            };
            responseMarshaller = new GsonBuilder().registerTypeAdapter(responseInstance.getClass(), responseTypeAdapter).create();
        }
        return new AutoValue_ApiMessageHttpResponseParser<ResponseT>(responseInstance, responseMarshaller);
    }

    public static <ResponseT extends ApiMessage> Builder<ResponseT> newBuilder() {
        return new Builder();
    }

    @Override
    public ResponseT parse(InputStream httpResponseBody) {
        return (ResponseT)this.parse(httpResponseBody, null);
    }

    @Override
    public ResponseT parse(InputStream httpResponseBody, TypeRegistry registry) {
        return (ResponseT)this.parse(new InputStreamReader(httpResponseBody, StandardCharsets.UTF_8), registry);
    }

    @Override
    public ResponseT parse(Reader httpResponseBody, TypeRegistry registry) {
        if (this.getResponseInstance() == null) {
            return null;
        }
        Class<?> responseType = this.getResponseInstance().getClass();
        try {
            return (ResponseT)((ApiMessage)this.getResponseMarshaller().fromJson(httpResponseBody, (Type)responseType));
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new RestSerializationException(e);
        }
    }

    @Override
    public String serialize(ResponseT response) {
        return this.getResponseMarshaller().toJson(response);
    }

    public static class Builder<ResponseT extends ApiMessage> {
        private ResponseT responseInstance;

        private Builder() {
        }

        public Builder<ResponseT> setResponseInstance(ResponseT responseInstance) {
            this.responseInstance = responseInstance;
            return this;
        }

        public ApiMessageHttpResponseParser<ResponseT> build() {
            return ApiMessageHttpResponseParser.create(this.responseInstance);
        }
    }
}

