/* This testcase is part of GDB, the GNU debugger.

   Copyright 2020-2022 Free Software Foundation, Inc.
   Copyright (C) 2020-2022 Intel Corporation

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#ifdef __GNUC__
# define ATTR __attribute__((gnu_inline)) __attribute__((always_inline))
#else
# define ATTR
#endif

/* The function is defined static here, so that the compiler can omit
   emitting its code.  In the assembly file we manually flag it as
   DW_AT_external in the debug info.  */
static inline ATTR int
func ()
{
  return 42;
}

int
main ()
{
  int a = func ();

  return 0;
}
