/*******************************************************************************
 * Copyright (c) 2015 - 2020 Intel Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Implementation for Function Call History View
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.mi.service.command.commands;

import org.eclipse.cdt.dsf.iss.mi.service.command.output.MIFunctionRecordInfoInfo;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

/**
 *
 * -function-call-history [function index begin] [function index end] /ilc
 *
 * Reports information about the function call history
 *
 * @since 1.1
 *
 */
public class MIFunctionRecordInfo extends MICommand<MIFunctionRecordInfoInfo> {
	public MIFunctionRecordInfo(IMIExecutionDMContext execDmc) {
		super(execDmc, "-function-call-history" , new String[] { "/ilc"}); //$NON-NLS-1$ //$NON-NLS-2$
    }

	public MIFunctionRecordInfo(IMIExecutionDMContext execDmc, int funcBegin,int funcEnd) {
		super(execDmc, "-function-call-history" , new String[] {"/ilc" , Integer.toString(funcBegin) , Integer.toString(funcEnd)}); //$NON-NLS-1$ //$NON-NLS-2$
    }

    @Override
    public MIFunctionRecordInfoInfo getResult(MIOutput out) {
        return new MIFunctionRecordInfoInfo(out);
    }
}
