//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.8
//
// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceStorm_IceStorm_h__
#define __IceStorm_IceStorm_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/Identity.h>
#include <Ice/SliceChecksumDict.h>
#include <IceStorm/Metrics.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceStorm/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 8
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICESTORM_API
#   if defined(ICE_STATIC_LIBS)
#       define ICESTORM_API /**/
#   elif defined(ICESTORM_API_EXPORTS)
#       define ICESTORM_API ICE_DECLSPEC_EXPORT
#   else
#       define ICESTORM_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceStorm
{

class Topic;
class TopicPrx;
class TopicManager;
class TopicManagerPrx;
class Finder;
class FinderPrx;

}

namespace IceStorm
{

/**
 * Information on the topic links.
 * \headerfile IceStorm/IceStorm.h
 */
struct LinkInfo
{
    /**
     * The linked topic.
     */
    ::std::shared_ptr<::IceStorm::TopicPrx> theTopic;
    /**
     * The name of the linked topic.
     */
    ::std::string name;
    /**
     * The cost of traversing this link.
     */
    int cost;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::shared_ptr<::IceStorm::TopicPrx>&, const ::std::string&, const int&> ice_tuple() const
    {
        return std::tie(theTopic, name, cost);
    }
};

/**
 * A sequence of {@link LinkInfo} objects.
 */
using LinkInfoSeq = ::std::vector<LinkInfo>;

/**
 * This dictionary represents quality of service parameters.
 * @see Topic#subscribeAndGetPublisher
 */
using QoS = ::std::map<::std::string, ::std::string>;

/**
 * This exception indicates that an attempt was made to create a link
 * that already exists.
 * \headerfile IceStorm/IceStorm.h
 */
class ICE_CLASS(ICESTORM_API) LinkExists : public ::Ice::UserExceptionHelper<LinkExists, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~LinkExists();

    LinkExists(const LinkExists&) = default;

    LinkExists() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the linked topic.
     */
    LinkExists(const ::std::string& name) :
        name(name)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    /**
     * The name of the linked topic.
     */
    ::std::string name;
};

/// \cond INTERNAL
static LinkExists _iceS_LinkExists_init;
/// \endcond

/**
 * This exception indicates that an attempt was made to remove a
 * link that does not exist.
 * \headerfile IceStorm/IceStorm.h
 */
class ICE_CLASS(ICESTORM_API) NoSuchLink : public ::Ice::UserExceptionHelper<NoSuchLink, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~NoSuchLink();

    NoSuchLink(const NoSuchLink&) = default;

    NoSuchLink() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the link that does not exist.
     */
    NoSuchLink(const ::std::string& name) :
        name(name)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    /**
     * The name of the link that does not exist.
     */
    ::std::string name;
};

/**
 * This exception indicates that an attempt was made to subscribe
 * a proxy for which a subscription already exists.
 * \headerfile IceStorm/IceStorm.h
 */
class ICE_CLASS(ICESTORM_API) AlreadySubscribed : public ::Ice::UserExceptionHelper<AlreadySubscribed, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~AlreadySubscribed();

    AlreadySubscribed(const AlreadySubscribed&) = default;

    AlreadySubscribed() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();
};

/**
 * This exception indicates that an attempt was made to subscribe
 * a proxy that is null.
 * \headerfile IceStorm/IceStorm.h
 */
class ICE_CLASS(ICESTORM_API) InvalidSubscriber : public ::Ice::UserExceptionHelper<InvalidSubscriber, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~InvalidSubscriber();

    InvalidSubscriber(const InvalidSubscriber&) = default;

    InvalidSubscriber() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the failure.
     */
    InvalidSubscriber(const ::std::string& reason) :
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    /**
     * The reason for the failure.
     */
    ::std::string reason;
};

/**
 * This exception indicates that a subscription failed due to an
 * invalid QoS.
 * \headerfile IceStorm/IceStorm.h
 */
class ICE_CLASS(ICESTORM_API) BadQoS : public ::Ice::UserExceptionHelper<BadQoS, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~BadQoS();

    BadQoS(const BadQoS&) = default;

    BadQoS() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the failure.
     */
    BadQoS(const ::std::string& reason) :
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    /**
     * The reason for the failure.
     */
    ::std::string reason;
};

/**
 * Mapping of topic name to topic proxy.
 */
using TopicDict = ::std::map<::std::string, ::std::shared_ptr<TopicPrx>>;

/**
 * This exception indicates that an attempt was made to create a topic
 * that already exists.
 * \headerfile IceStorm/IceStorm.h
 */
class ICE_CLASS(ICESTORM_API) TopicExists : public ::Ice::UserExceptionHelper<TopicExists, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~TopicExists();

    TopicExists(const TopicExists&) = default;

    TopicExists() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the topic that already exists.
     */
    TopicExists(const ::std::string& name) :
        name(name)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    /**
     * The name of the topic that already exists.
     */
    ::std::string name;
};

/**
 * This exception indicates that an attempt was made to retrieve a
 * topic that does not exist.
 * \headerfile IceStorm/IceStorm.h
 */
class ICE_CLASS(ICESTORM_API) NoSuchTopic : public ::Ice::UserExceptionHelper<NoSuchTopic, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~NoSuchTopic();

    NoSuchTopic(const NoSuchTopic&) = default;

    NoSuchTopic() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the topic that does not exist.
     */
    NoSuchTopic(const ::std::string& name) :
        name(name)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    /**
     * The name of the topic that does not exist.
     */
    ::std::string name;
};

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace IceStorm
{

/**
 * Publishers publish information on a particular topic. A topic
 * logically represents a type.
 * @see TopicManager
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API Topic : public virtual ::Ice::Object
{
public:

    using ProxyType = TopicPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the name of this topic.
     * @param current The Current object for the invocation.
     * @return The name of the topic.
     * @see TopicManager#create
     */
    virtual ::std::string getName(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getName(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param current The Current object for the invocation.
     * @return A proxy to publish data on this topic.
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> getPublisher(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getPublisher(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param current The Current object for the invocation.
     * @return A proxy to publish data on this topic.
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> getNonReplicatedPublisher(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNonReplicatedPublisher(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param current The Current object for the invocation.
     * @return The per-subscriber publisher object.
     * @throws IceStorm::AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     * @throws IceStorm::BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     * @throws IceStorm::InvalidSubscriber Raised if the subscriber object is null.
     * @see #unsubscribe
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> subscribeAndGetPublisher(QoS theQoS, ::std::shared_ptr<::Ice::ObjectPrx> subscriber, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_subscribeAndGetPublisher(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param current The Current object for the invocation.
     * @see #subscribeAndGetPublisher
     */
    virtual void unsubscribe(::std::shared_ptr<::Ice::ObjectPrx> subscriber, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_unsubscribe(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param current The Current object for the invocation.
     * @throws IceStorm::LinkExists Raised if a link to the same topic already
     * exists.
     */
    virtual void link(::std::shared_ptr<TopicPrx> linkTo, int cost, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_link(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param current The Current object for the invocation.
     * @throws IceStorm::NoSuchLink Raised if a link to the topic does not exist.
     */
    virtual void unlink(::std::shared_ptr<TopicPrx> linkTo, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_unlink(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Retrieve information on the current links.
     * @param current The Current object for the invocation.
     * @return A sequence of LinkInfo objects.
     */
    virtual LinkInfoSeq getLinkInfoSeq(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLinkInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Retrieve the list of subscribers for this topic.
     * @param current The Current object for the invocation.
     * @return The sequence of Ice identities for the subscriber objects.
     */
    virtual ::Ice::IdentitySeq getSubscribers(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSubscribers(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Destroy the topic.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * A topic manager manages topics, and subscribers to topics.
 * @see Topic
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API TopicManager : public virtual ::Ice::Object
{
public:

    using ProxyType = TopicManagerPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param current The Current object for the invocation.
     * @return A proxy to the topic instance.
     * @throws IceStorm::TopicExists Raised if a topic with the same name already
     * exists.
     */
    virtual ::std::shared_ptr<TopicPrx> create(::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param current The Current object for the invocation.
     * @return A proxy to the topic instance.
     * @throws IceStorm::NoSuchTopic Raised if the topic does not exist.
     */
    virtual ::std::shared_ptr<TopicPrx> retrieve(::std::string name, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_retrieve(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Retrieve all topics managed by this topic manager.
     * @param current The Current object for the invocation.
     * @return A dictionary of string, topic proxy pairs.
     */
    virtual TopicDict retrieveAll(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_retrieveAll(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param current The Current object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * This inferface is advertised by the IceStorm service through the
 * Ice object with the identity `IceStorm/Finder'. This allows clients
 * to retrieve the topic manager with just the endpoint information of
 * the IceStorm service.
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API Finder : public virtual ::Ice::Object
{
public:

    using ProxyType = FinderPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the topic manager proxy. The proxy might point to several
     * replicas.
     * @param current The Current object for the invocation.
     * @return The topic manager proxy.
     */
    virtual ::std::shared_ptr<TopicManagerPrx> getTopicManager(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getTopicManager(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceStorm
{

/**
 * Publishers publish information on a particular topic. A topic
 * logically represents a type.
 * @see TopicManager
 * \headerfile IceStorm/IceStorm.h
 */
class ICE_CLASS(ICESTORM_API) TopicPrx : public virtual ::Ice::Proxy<TopicPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Get the name of this topic.
     * @param context The Context map to send with the invocation.
     * @return The name of the topic.
     * @see TopicManager#create
     */
    ::std::string getName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &TopicPrx::_iceI_getName, context).get();
    }

    /**
     * Get the name of this topic.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see TopicManager#create
     */
    template<template<typename> class P = ::std::promise>
    auto getNameAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &TopicPrx::_iceI_getName, context);
    }

    /**
     * Get the name of this topic.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see TopicManager#create
     */
    ::std::function<void()>
    getNameAsync(::std::function<void(::std::string)> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicPrx::_iceI_getName, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_getName(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> getPublisher(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &TopicPrx::_iceI_getPublisher, context).get();
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getPublisherAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &TopicPrx::_iceI_getPublisher, context);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getPublisherAsync(::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicPrx::_iceI_getPublisher, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_getPublisher(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> getNonReplicatedPublisher(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &TopicPrx::_iceI_getNonReplicatedPublisher, context).get();
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getNonReplicatedPublisherAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &TopicPrx::_iceI_getNonReplicatedPublisher, context);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getNonReplicatedPublisherAsync(::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                   ::std::function<void(bool)> sent = nullptr,
                                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicPrx::_iceI_getNonReplicatedPublisher, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_getNonReplicatedPublisher(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param context The Context map to send with the invocation.
     * @return The per-subscriber publisher object.
     * @throws IceStorm::AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     * @throws IceStorm::BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     * @throws IceStorm::InvalidSubscriber Raised if the subscriber object is null.
     * @see #unsubscribe
     */
    ::std::shared_ptr<::Ice::ObjectPrx> subscribeAndGetPublisher(const QoS& theQoS, const ::std::shared_ptr<::Ice::ObjectPrx>& subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &TopicPrx::_iceI_subscribeAndGetPublisher, theQoS, subscriber, context).get();
    }

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see #unsubscribe
     */
    template<template<typename> class P = ::std::promise>
    auto subscribeAndGetPublisherAsync(const QoS& theQoS, const ::std::shared_ptr<::Ice::ObjectPrx>& subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &TopicPrx::_iceI_subscribeAndGetPublisher, theQoS, subscriber, context);
    }

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see #unsubscribe
     */
    ::std::function<void()>
    subscribeAndGetPublisherAsync(const QoS& theQoS, const ::std::shared_ptr<::Ice::ObjectPrx>& subscriber,
                                  ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                  ::std::function<void(bool)> sent = nullptr,
                                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicPrx::_iceI_subscribeAndGetPublisher, theQoS, subscriber, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_subscribeAndGetPublisher(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const QoS&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param context The Context map to send with the invocation.
     * @see #subscribeAndGetPublisher
     */
    void unsubscribe(const ::std::shared_ptr<::Ice::ObjectPrx>& subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &TopicPrx::_iceI_unsubscribe, subscriber, context).get();
    }

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see #subscribeAndGetPublisher
     */
    template<template<typename> class P = ::std::promise>
    auto unsubscribeAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &TopicPrx::_iceI_unsubscribe, subscriber, context);
    }

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see #subscribeAndGetPublisher
     */
    ::std::function<void()>
    unsubscribeAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& subscriber,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicPrx::_iceI_unsubscribe, subscriber, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_unsubscribe(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param context The Context map to send with the invocation.
     * @throws IceStorm::LinkExists Raised if a link to the same topic already
     * exists.
     */
    void link(const ::std::shared_ptr<TopicPrx>& linkTo, int cost, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &TopicPrx::_iceI_link, linkTo, cost, context).get();
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto linkAsync(const ::std::shared_ptr<TopicPrx>& linkTo, int cost, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &TopicPrx::_iceI_link, linkTo, cost, context);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    linkAsync(const ::std::shared_ptr<TopicPrx>& linkTo, int cost,
              ::std::function<void()> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicPrx::_iceI_link, linkTo, cost, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_link(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<TopicPrx>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param context The Context map to send with the invocation.
     * @throws IceStorm::NoSuchLink Raised if a link to the topic does not exist.
     */
    void unlink(const ::std::shared_ptr<TopicPrx>& linkTo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &TopicPrx::_iceI_unlink, linkTo, context).get();
    }

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto unlinkAsync(const ::std::shared_ptr<TopicPrx>& linkTo, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &TopicPrx::_iceI_unlink, linkTo, context);
    }

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    unlinkAsync(const ::std::shared_ptr<TopicPrx>& linkTo,
                ::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicPrx::_iceI_unlink, linkTo, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_unlink(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<TopicPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Retrieve information on the current links.
     * @param context The Context map to send with the invocation.
     * @return A sequence of LinkInfo objects.
     */
    LinkInfoSeq getLinkInfoSeq(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceStorm::LinkInfoSeq>(true, this, &TopicPrx::_iceI_getLinkInfoSeq, context).get();
    }

    /**
     * Retrieve information on the current links.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getLinkInfoSeqAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceStorm::LinkInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceStorm::LinkInfoSeq, P>(false, this, &TopicPrx::_iceI_getLinkInfoSeq, context);
    }

    /**
     * Retrieve information on the current links.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getLinkInfoSeqAsync(::std::function<void(::IceStorm::LinkInfoSeq)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceStorm::LinkInfoSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicPrx::_iceI_getLinkInfoSeq, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_getLinkInfoSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceStorm::LinkInfoSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Retrieve the list of subscribers for this topic.
     * @param context The Context map to send with the invocation.
     * @return The sequence of Ice identities for the subscriber objects.
     */
    ::Ice::IdentitySeq getSubscribers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::IdentitySeq>(true, this, &TopicPrx::_iceI_getSubscribers, context).get();
    }

    /**
     * Retrieve the list of subscribers for this topic.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getSubscribersAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::IdentitySeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::IdentitySeq, P>(false, this, &TopicPrx::_iceI_getSubscribers, context);
    }

    /**
     * Retrieve the list of subscribers for this topic.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getSubscribersAsync(::std::function<void(::Ice::IdentitySeq)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::IdentitySeq>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicPrx::_iceI_getSubscribers, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_getSubscribers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::IdentitySeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Destroy the topic.
     * @param context The Context map to send with the invocation.
     */
    void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &TopicPrx::_iceI_destroy, context).get();
    }

    /**
     * Destroy the topic.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto destroyAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &TopicPrx::_iceI_destroy, context);
    }

    /**
     * Destroy the topic.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    destroyAsync(::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicPrx::_iceI_destroy, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    TopicPrx() = default;
    friend ::std::shared_ptr<TopicPrx> IceInternal::createProxy<TopicPrx>();

    ICE_MEMBER(ICESTORM_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * A topic manager manages topics, and subscribers to topics.
 * @see Topic
 * \headerfile IceStorm/IceStorm.h
 */
class ICE_CLASS(ICESTORM_API) TopicManagerPrx : public virtual ::Ice::Proxy<TopicManagerPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     * @throws IceStorm::TopicExists Raised if a topic with the same name already
     * exists.
     */
    ::std::shared_ptr<TopicPrx> create(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>>(true, this, &TopicManagerPrx::_iceI_create, name, context).get();
    }

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto createAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceStorm::TopicPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>, P>(false, this, &TopicManagerPrx::_iceI_create, name, context);
    }

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    createAsync(const ::std::string& name,
                ::std::function<void(::std::shared_ptr<::IceStorm::TopicPrx>)> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicManagerPrx::_iceI_create, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_create(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStorm::TopicPrx>>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     * @throws IceStorm::NoSuchTopic Raised if the topic does not exist.
     */
    ::std::shared_ptr<TopicPrx> retrieve(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>>(true, this, &TopicManagerPrx::_iceI_retrieve, name, context).get();
    }

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto retrieveAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceStorm::TopicPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>, P>(false, this, &TopicManagerPrx::_iceI_retrieve, name, context);
    }

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    retrieveAsync(const ::std::string& name,
                  ::std::function<void(::std::shared_ptr<::IceStorm::TopicPrx>)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicManagerPrx::_iceI_retrieve, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_retrieve(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStorm::TopicPrx>>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Retrieve all topics managed by this topic manager.
     * @param context The Context map to send with the invocation.
     * @return A dictionary of string, topic proxy pairs.
     */
    TopicDict retrieveAll(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceStorm::TopicDict>(true, this, &TopicManagerPrx::_iceI_retrieveAll, context).get();
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto retrieveAllAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceStorm::TopicDict>>().get_future())
    {
        return _makePromiseOutgoing<::IceStorm::TopicDict, P>(false, this, &TopicManagerPrx::_iceI_retrieveAll, context);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    retrieveAllAsync(::std::function<void(::IceStorm::TopicDict)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceStorm::TopicDict>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicManagerPrx::_iceI_retrieveAll, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_retrieveAll(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceStorm::TopicDict>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict>(true, this, &TopicManagerPrx::_iceI_getSliceChecksums, context).get();
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getSliceChecksumsAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::SliceChecksumDict>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict, P>(false, this, &TopicManagerPrx::_iceI_getSliceChecksums, context);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getSliceChecksumsAsync(::std::function<void(::Ice::SliceChecksumDict)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::SliceChecksumDict>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicManagerPrx::_iceI_getSliceChecksums, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_getSliceChecksums(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::SliceChecksumDict>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    TopicManagerPrx() = default;
    friend ::std::shared_ptr<TopicManagerPrx> IceInternal::createProxy<TopicManagerPrx>();

    ICE_MEMBER(ICESTORM_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * This inferface is advertised by the IceStorm service through the
 * Ice object with the identity `IceStorm/Finder'. This allows clients
 * to retrieve the topic manager with just the endpoint information of
 * the IceStorm service.
 * \headerfile IceStorm/IceStorm.h
 */
class ICE_CLASS(ICESTORM_API) FinderPrx : public virtual ::Ice::Proxy<FinderPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Get the topic manager proxy. The proxy might point to several
     * replicas.
     * @param context The Context map to send with the invocation.
     * @return The topic manager proxy.
     */
    ::std::shared_ptr<TopicManagerPrx> getTopicManager(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicManagerPrx>>(true, this, &FinderPrx::_iceI_getTopicManager, context).get();
    }

    /**
     * Get the topic manager proxy. The proxy might point to several
     * replicas.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getTopicManagerAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceStorm::TopicManagerPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicManagerPrx>, P>(false, this, &FinderPrx::_iceI_getTopicManager, context);
    }

    /**
     * Get the topic manager proxy. The proxy might point to several
     * replicas.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getTopicManagerAsync(::std::function<void(::std::shared_ptr<::IceStorm::TopicManagerPrx>)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceStorm::TopicManagerPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::FinderPrx::_iceI_getTopicManager, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICESTORM_API) void _iceI_getTopicManager(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStorm::TopicManagerPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    FinderPrx() = default;
    friend ::std::shared_ptr<FinderPrx> IceInternal::createProxy<FinderPrx>();

    ICE_MEMBER(ICESTORM_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits<::IceStorm::LinkInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceStorm::LinkInfo, S>
{
    static void read(S* istr, ::IceStorm::LinkInfo& v)
    {
        istr->readAll(v.theTopic, v.name, v.cost);
    }
};

template<typename S>
struct StreamReader<::IceStorm::LinkExists, S>
{
    static void read(S* istr, ::IceStorm::LinkExists& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceStorm::NoSuchLink, S>
{
    static void read(S* istr, ::IceStorm::NoSuchLink& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceStorm::InvalidSubscriber, S>
{
    static void read(S* istr, ::IceStorm::InvalidSubscriber& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamReader<::IceStorm::BadQoS, S>
{
    static void read(S* istr, ::IceStorm::BadQoS& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamReader<::IceStorm::TopicExists, S>
{
    static void read(S* istr, ::IceStorm::TopicExists& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceStorm::NoSuchTopic, S>
{
    static void read(S* istr, ::IceStorm::NoSuchTopic& v)
    {
        istr->readAll(v.name);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace IceStorm
{

using TopicPtr = ::std::shared_ptr<Topic>;
using TopicPrxPtr = ::std::shared_ptr<TopicPrx>;

using TopicManagerPtr = ::std::shared_ptr<TopicManager>;
using TopicManagerPrxPtr = ::std::shared_ptr<TopicManagerPrx>;

using FinderPtr = ::std::shared_ptr<Finder>;
using FinderPrxPtr = ::std::shared_ptr<FinderPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceStorm
{

class Topic;
/// \cond INTERNAL
ICESTORM_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Topic>&);
ICESTORM_API ::IceProxy::Ice::Object* upCast(Topic*);
/// \endcond

class TopicManager;
/// \cond INTERNAL
ICESTORM_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< TopicManager>&);
ICESTORM_API ::IceProxy::Ice::Object* upCast(TopicManager*);
/// \endcond

class Finder;
/// \cond INTERNAL
ICESTORM_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Finder>&);
ICESTORM_API ::IceProxy::Ice::Object* upCast(Finder*);
/// \endcond

}

}

namespace IceStorm
{

class Topic;
/// \cond INTERNAL
ICESTORM_API ::Ice::Object* upCast(Topic*);
/// \endcond
typedef ::IceInternal::Handle< Topic> TopicPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::Topic> TopicPrx;
typedef TopicPrx TopicPrxPtr;
/// \cond INTERNAL
ICESTORM_API void _icePatchObjectPtr(TopicPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class TopicManager;
/// \cond INTERNAL
ICESTORM_API ::Ice::Object* upCast(TopicManager*);
/// \endcond
typedef ::IceInternal::Handle< TopicManager> TopicManagerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::TopicManager> TopicManagerPrx;
typedef TopicManagerPrx TopicManagerPrxPtr;
/// \cond INTERNAL
ICESTORM_API void _icePatchObjectPtr(TopicManagerPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class Finder;
/// \cond INTERNAL
ICESTORM_API ::Ice::Object* upCast(Finder*);
/// \endcond
typedef ::IceInternal::Handle< Finder> FinderPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::Finder> FinderPrx;
typedef FinderPrx FinderPrxPtr;
/// \cond INTERNAL
ICESTORM_API void _icePatchObjectPtr(FinderPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceStorm
{

/**
 * Information on the topic links.
 * \headerfile IceStorm/IceStorm.h
 */
struct LinkInfo
{
    /**
     * The linked topic.
     */
    ::IceStorm::TopicPrx theTopic;
    /**
     * The name of the linked topic.
     */
    ::std::string name;
    /**
     * The cost of traversing this link.
     */
    ::Ice::Int cost;
};

/**
 * A sequence of {@link LinkInfo} objects.
 */
typedef ::std::vector<LinkInfo> LinkInfoSeq;

/**
 * This dictionary represents quality of service parameters.
 * @see Topic#subscribeAndGetPublisher
 */
typedef ::std::map< ::std::string, ::std::string> QoS;

/**
 * This exception indicates that an attempt was made to create a link
 * that already exists.
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API LinkExists : public ::Ice::UserException
{
public:

    LinkExists() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the linked topic.
     */
    explicit LinkExists(const ::std::string& name);

#ifdef ICE_CPP11_COMPILER
    LinkExists(const LinkExists&) = default;
    virtual ~LinkExists();
#else
    virtual ~LinkExists() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual LinkExists* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The name of the linked topic.
     */
    ::std::string name;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static LinkExists _iceS_LinkExists_init;
/// \endcond

/**
 * This exception indicates that an attempt was made to remove a
 * link that does not exist.
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API NoSuchLink : public ::Ice::UserException
{
public:

    NoSuchLink() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the link that does not exist.
     */
    explicit NoSuchLink(const ::std::string& name);

#ifdef ICE_CPP11_COMPILER
    NoSuchLink(const NoSuchLink&) = default;
    virtual ~NoSuchLink();
#else
    virtual ~NoSuchLink() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual NoSuchLink* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The name of the link that does not exist.
     */
    ::std::string name;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception indicates that an attempt was made to subscribe
 * a proxy for which a subscription already exists.
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API AlreadySubscribed : public ::Ice::UserException
{
public:

    AlreadySubscribed() {}

#ifdef ICE_CPP11_COMPILER
    AlreadySubscribed(const AlreadySubscribed&) = default;
    virtual ~AlreadySubscribed();
#else
    virtual ~AlreadySubscribed() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AlreadySubscribed* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception indicates that an attempt was made to subscribe
 * a proxy that is null.
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API InvalidSubscriber : public ::Ice::UserException
{
public:

    InvalidSubscriber() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the failure.
     */
    explicit InvalidSubscriber(const ::std::string& reason);

#ifdef ICE_CPP11_COMPILER
    InvalidSubscriber(const InvalidSubscriber&) = default;
    virtual ~InvalidSubscriber();
#else
    virtual ~InvalidSubscriber() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual InvalidSubscriber* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reason for the failure.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception indicates that a subscription failed due to an
 * invalid QoS.
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API BadQoS : public ::Ice::UserException
{
public:

    BadQoS() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the failure.
     */
    explicit BadQoS(const ::std::string& reason);

#ifdef ICE_CPP11_COMPILER
    BadQoS(const BadQoS&) = default;
    virtual ~BadQoS();
#else
    virtual ~BadQoS() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual BadQoS* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reason for the failure.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * Mapping of topic name to topic proxy.
 */
typedef ::std::map< ::std::string, TopicPrx> TopicDict;

/**
 * This exception indicates that an attempt was made to create a topic
 * that already exists.
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API TopicExists : public ::Ice::UserException
{
public:

    TopicExists() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the topic that already exists.
     */
    explicit TopicExists(const ::std::string& name);

#ifdef ICE_CPP11_COMPILER
    TopicExists(const TopicExists&) = default;
    virtual ~TopicExists();
#else
    virtual ~TopicExists() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual TopicExists* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The name of the topic that already exists.
     */
    ::std::string name;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception indicates that an attempt was made to retrieve a
 * topic that does not exist.
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API NoSuchTopic : public ::Ice::UserException
{
public:

    NoSuchTopic() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the topic that does not exist.
     */
    explicit NoSuchTopic(const ::std::string& name);

#ifdef ICE_CPP11_COMPILER
    NoSuchTopic(const NoSuchTopic&) = default;
    virtual ~NoSuchTopic();
#else
    virtual ~NoSuchTopic() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual NoSuchTopic* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The name of the topic that does not exist.
     */
    ::std::string name;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

}

namespace IceStorm
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::Topic::begin_getName.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getName.
 */
class Callback_Topic_getName_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_getName_Base> Callback_Topic_getNamePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::Topic::begin_getPublisher.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getPublisher.
 */
class Callback_Topic_getPublisher_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_getPublisher_Base> Callback_Topic_getPublisherPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::Topic::begin_getNonReplicatedPublisher.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getNonReplicatedPublisher.
 */
class Callback_Topic_getNonReplicatedPublisher_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_getNonReplicatedPublisher_Base> Callback_Topic_getNonReplicatedPublisherPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::Topic::begin_subscribeAndGetPublisher.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_subscribeAndGetPublisher.
 */
class Callback_Topic_subscribeAndGetPublisher_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_subscribeAndGetPublisher_Base> Callback_Topic_subscribeAndGetPublisherPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::Topic::begin_unsubscribe.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_unsubscribe.
 */
class Callback_Topic_unsubscribe_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_unsubscribe_Base> Callback_Topic_unsubscribePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::Topic::begin_link.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_link.
 */
class Callback_Topic_link_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_link_Base> Callback_Topic_linkPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::Topic::begin_unlink.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_unlink.
 */
class Callback_Topic_unlink_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_unlink_Base> Callback_Topic_unlinkPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::Topic::begin_getLinkInfoSeq.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getLinkInfoSeq.
 */
class Callback_Topic_getLinkInfoSeq_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_getLinkInfoSeq_Base> Callback_Topic_getLinkInfoSeqPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::Topic::begin_getSubscribers.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getSubscribers.
 */
class Callback_Topic_getSubscribers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_getSubscribers_Base> Callback_Topic_getSubscribersPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::Topic::begin_destroy.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_destroy.
 */
class Callback_Topic_destroy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_destroy_Base> Callback_Topic_destroyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::TopicManager::begin_create.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_create.
 */
class Callback_TopicManager_create_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicManager_create_Base> Callback_TopicManager_createPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::TopicManager::begin_retrieve.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_retrieve.
 */
class Callback_TopicManager_retrieve_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicManager_retrieve_Base> Callback_TopicManager_retrievePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::TopicManager::begin_retrieveAll.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_retrieveAll.
 */
class Callback_TopicManager_retrieveAll_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicManager_retrieveAll_Base> Callback_TopicManager_retrieveAllPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::TopicManager::begin_getSliceChecksums.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_getSliceChecksums.
 */
class Callback_TopicManager_getSliceChecksums_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicManager_getSliceChecksums_Base> Callback_TopicManager_getSliceChecksumsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::Finder::begin_getTopicManager.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Finder_getTopicManager.
 */
class Callback_Finder_getTopicManager_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Finder_getTopicManager_Base> Callback_Finder_getTopicManagerPtr;

}

namespace IceProxy
{

namespace IceStorm
{

class ICE_CLASS(ICESTORM_API) Topic : public virtual ::Ice::Proxy<Topic, ::IceProxy::Ice::Object>
{
public:

    /**
     * Get the name of this topic.
     * @param context The Context map to send with the invocation.
     * @return The name of the topic.
     * @see TopicManager#create
     */
    ICE_MEMBER(ICESTORM_API) ::std::string getName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getName(_iceI_begin_getName(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the name of this topic.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see TopicManager#create
     */
    ::Ice::AsyncResultPtr begin_getName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getName(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the name of this topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see TopicManager#create
     */
    ::Ice::AsyncResultPtr begin_getName(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the name of this topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see TopicManager#create
     */
    ::Ice::AsyncResultPtr begin_getName(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(context, cb, cookie);
    }

    /**
     * Get the name of this topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see TopicManager#create
     */
    ::Ice::AsyncResultPtr begin_getName(const ::IceStorm::Callback_Topic_getNamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the name of this topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see TopicManager#create
     */
    ::Ice::AsyncResultPtr begin_getName(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_getNamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getName.
     * @param result The asynchronous result object for the invocation.
     * @return The name of the topic.
     */
    ICE_MEMBER(ICESTORM_API) ::std::string end_getName(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getName(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     */
    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx getPublisher(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getPublisher(_iceI_begin_getPublisher(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPublisher(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getPublisher(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPublisher(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPublisher(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPublisher(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPublisher(context, cb, cookie);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPublisher(const ::IceStorm::Callback_Topic_getPublisherPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPublisher(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPublisher(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_getPublisherPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPublisher(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getPublisher.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy to publish data on this topic.
     */
    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx end_getPublisher(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getPublisher(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     */
    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx getNonReplicatedPublisher(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNonReplicatedPublisher(_iceI_begin_getNonReplicatedPublisher(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNonReplicatedPublisher(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNonReplicatedPublisher(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNonReplicatedPublisher(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNonReplicatedPublisher(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNonReplicatedPublisher(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNonReplicatedPublisher(context, cb, cookie);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNonReplicatedPublisher(const ::IceStorm::Callback_Topic_getNonReplicatedPublisherPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNonReplicatedPublisher(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNonReplicatedPublisher(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_getNonReplicatedPublisherPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNonReplicatedPublisher(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getNonReplicatedPublisher.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy to publish data on this topic.
     */
    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx end_getNonReplicatedPublisher(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getNonReplicatedPublisher(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param context The Context map to send with the invocation.
     * @return The per-subscriber publisher object.
     * @throws IceStorm::AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     * @throws IceStorm::BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     * @throws IceStorm::InvalidSubscriber Raised if the subscriber object is null.
     * @see #unsubscribe
     */
    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx subscribeAndGetPublisher(const ::IceStorm::QoS& theQoS, const ::Ice::ObjectPrx& subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_subscribeAndGetPublisher(_iceI_begin_subscribeAndGetPublisher(theQoS, subscriber, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #unsubscribe
     */
    ::Ice::AsyncResultPtr begin_subscribeAndGetPublisher(const ::IceStorm::QoS& theQoS, const ::Ice::ObjectPrx& subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_subscribeAndGetPublisher(theQoS, subscriber, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #unsubscribe
     */
    ::Ice::AsyncResultPtr begin_subscribeAndGetPublisher(const ::IceStorm::QoS& theQoS, const ::Ice::ObjectPrx& subscriber, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_subscribeAndGetPublisher(theQoS, subscriber, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #unsubscribe
     */
    ::Ice::AsyncResultPtr begin_subscribeAndGetPublisher(const ::IceStorm::QoS& theQoS, const ::Ice::ObjectPrx& subscriber, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_subscribeAndGetPublisher(theQoS, subscriber, context, cb, cookie);
    }

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #unsubscribe
     */
    ::Ice::AsyncResultPtr begin_subscribeAndGetPublisher(const ::IceStorm::QoS& theQoS, const ::Ice::ObjectPrx& subscriber, const ::IceStorm::Callback_Topic_subscribeAndGetPublisherPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_subscribeAndGetPublisher(theQoS, subscriber, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #unsubscribe
     */
    ::Ice::AsyncResultPtr begin_subscribeAndGetPublisher(const ::IceStorm::QoS& theQoS, const ::Ice::ObjectPrx& subscriber, const ::Ice::Context& context, const ::IceStorm::Callback_Topic_subscribeAndGetPublisherPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_subscribeAndGetPublisher(theQoS, subscriber, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_subscribeAndGetPublisher.
     * @param result The asynchronous result object for the invocation.
     * @return The per-subscriber publisher object.
     * @throws IceStorm::AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     * @throws IceStorm::BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     * @throws IceStorm::InvalidSubscriber Raised if the subscriber object is null.
     */
    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx end_subscribeAndGetPublisher(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_subscribeAndGetPublisher(const ::IceStorm::QoS&, const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param context The Context map to send with the invocation.
     * @see #subscribeAndGetPublisher
     */
    ICE_MEMBER(ICESTORM_API) void unsubscribe(const ::Ice::ObjectPrx& subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_unsubscribe(_iceI_begin_unsubscribe(subscriber, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #subscribeAndGetPublisher
     */
    ::Ice::AsyncResultPtr begin_unsubscribe(const ::Ice::ObjectPrx& subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_unsubscribe(subscriber, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #subscribeAndGetPublisher
     */
    ::Ice::AsyncResultPtr begin_unsubscribe(const ::Ice::ObjectPrx& subscriber, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unsubscribe(subscriber, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #subscribeAndGetPublisher
     */
    ::Ice::AsyncResultPtr begin_unsubscribe(const ::Ice::ObjectPrx& subscriber, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unsubscribe(subscriber, context, cb, cookie);
    }

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #subscribeAndGetPublisher
     */
    ::Ice::AsyncResultPtr begin_unsubscribe(const ::Ice::ObjectPrx& subscriber, const ::IceStorm::Callback_Topic_unsubscribePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unsubscribe(subscriber, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #subscribeAndGetPublisher
     */
    ::Ice::AsyncResultPtr begin_unsubscribe(const ::Ice::ObjectPrx& subscriber, const ::Ice::Context& context, const ::IceStorm::Callback_Topic_unsubscribePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unsubscribe(subscriber, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_unsubscribe.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICESTORM_API) void end_unsubscribe(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_unsubscribe(const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param context The Context map to send with the invocation.
     * @throws IceStorm::LinkExists Raised if a link to the same topic already
     * exists.
     */
    ICE_MEMBER(ICESTORM_API) void link(const ::IceStorm::TopicPrx& linkTo, ::Ice::Int cost, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_link(_iceI_begin_link(linkTo, cost, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_link(const ::IceStorm::TopicPrx& linkTo, ::Ice::Int cost, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_link(linkTo, cost, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_link(const ::IceStorm::TopicPrx& linkTo, ::Ice::Int cost, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_link(linkTo, cost, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_link(const ::IceStorm::TopicPrx& linkTo, ::Ice::Int cost, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_link(linkTo, cost, context, cb, cookie);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_link(const ::IceStorm::TopicPrx& linkTo, ::Ice::Int cost, const ::IceStorm::Callback_Topic_linkPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_link(linkTo, cost, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_link(const ::IceStorm::TopicPrx& linkTo, ::Ice::Int cost, const ::Ice::Context& context, const ::IceStorm::Callback_Topic_linkPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_link(linkTo, cost, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_link.
     * @param result The asynchronous result object for the invocation.
     * @throws IceStorm::LinkExists Raised if a link to the same topic already
     * exists.
     */
    ICE_MEMBER(ICESTORM_API) void end_link(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_link(const ::IceStorm::TopicPrx&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param context The Context map to send with the invocation.
     * @throws IceStorm::NoSuchLink Raised if a link to the topic does not exist.
     */
    ICE_MEMBER(ICESTORM_API) void unlink(const ::IceStorm::TopicPrx& linkTo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_unlink(_iceI_begin_unlink(linkTo, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unlink(const ::IceStorm::TopicPrx& linkTo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_unlink(linkTo, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unlink(const ::IceStorm::TopicPrx& linkTo, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unlink(linkTo, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unlink(const ::IceStorm::TopicPrx& linkTo, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unlink(linkTo, context, cb, cookie);
    }

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unlink(const ::IceStorm::TopicPrx& linkTo, const ::IceStorm::Callback_Topic_unlinkPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unlink(linkTo, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unlink(const ::IceStorm::TopicPrx& linkTo, const ::Ice::Context& context, const ::IceStorm::Callback_Topic_unlinkPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unlink(linkTo, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_unlink.
     * @param result The asynchronous result object for the invocation.
     * @throws IceStorm::NoSuchLink Raised if a link to the topic does not exist.
     */
    ICE_MEMBER(ICESTORM_API) void end_unlink(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_unlink(const ::IceStorm::TopicPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Retrieve information on the current links.
     * @param context The Context map to send with the invocation.
     * @return A sequence of LinkInfo objects.
     */
    ICE_MEMBER(ICESTORM_API) ::IceStorm::LinkInfoSeq getLinkInfoSeq(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLinkInfoSeq(_iceI_begin_getLinkInfoSeq(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Retrieve information on the current links.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLinkInfoSeq(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLinkInfoSeq(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Retrieve information on the current links.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLinkInfoSeq(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkInfoSeq(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve information on the current links.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLinkInfoSeq(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkInfoSeq(context, cb, cookie);
    }

    /**
     * Retrieve information on the current links.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLinkInfoSeq(const ::IceStorm::Callback_Topic_getLinkInfoSeqPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkInfoSeq(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve information on the current links.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLinkInfoSeq(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_getLinkInfoSeqPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkInfoSeq(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getLinkInfoSeq.
     * @param result The asynchronous result object for the invocation.
     * @return A sequence of LinkInfo objects.
     */
    ICE_MEMBER(ICESTORM_API) ::IceStorm::LinkInfoSeq end_getLinkInfoSeq(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getLinkInfoSeq(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Retrieve the list of subscribers for this topic.
     * @param context The Context map to send with the invocation.
     * @return The sequence of Ice identities for the subscriber objects.
     */
    ICE_MEMBER(ICESTORM_API) ::Ice::IdentitySeq getSubscribers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSubscribers(_iceI_begin_getSubscribers(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Retrieve the list of subscribers for this topic.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSubscribers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSubscribers(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Retrieve the list of subscribers for this topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSubscribers(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSubscribers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve the list of subscribers for this topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSubscribers(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSubscribers(context, cb, cookie);
    }

    /**
     * Retrieve the list of subscribers for this topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSubscribers(const ::IceStorm::Callback_Topic_getSubscribersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSubscribers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve the list of subscribers for this topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSubscribers(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_getSubscribersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSubscribers(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getSubscribers.
     * @param result The asynchronous result object for the invocation.
     * @return The sequence of Ice identities for the subscriber objects.
     */
    ICE_MEMBER(ICESTORM_API) ::Ice::IdentitySeq end_getSubscribers(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getSubscribers(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Destroy the topic.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICESTORM_API) void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroy(_iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Destroy the topic.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Destroy the topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Destroy the topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::IceStorm::Callback_Topic_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_destroy.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICESTORM_API) void end_destroy(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_destroy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICESTORM_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICESTORM_API) TopicManager : public virtual ::Ice::Proxy<TopicManager, ::IceProxy::Ice::Object>
{
public:

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     * @throws IceStorm::TopicExists Raised if a topic with the same name already
     * exists.
     */
    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicPrx create(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_create(_iceI_begin_create(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_create(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(name, context, cb, cookie);
    }

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::std::string& name, const ::IceStorm::Callback_TopicManager_createPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::std::string& name, const ::Ice::Context& context, const ::IceStorm::Callback_TopicManager_createPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_create.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy to the topic instance.
     * @throws IceStorm::TopicExists Raised if a topic with the same name already
     * exists.
     */
    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicPrx end_create(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_create(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     * @throws IceStorm::NoSuchTopic Raised if the topic does not exist.
     */
    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicPrx retrieve(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_retrieve(_iceI_begin_retrieve(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_retrieve(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_retrieve(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_retrieve(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieve(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_retrieve(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieve(name, context, cb, cookie);
    }

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_retrieve(const ::std::string& name, const ::IceStorm::Callback_TopicManager_retrievePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieve(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_retrieve(const ::std::string& name, const ::Ice::Context& context, const ::IceStorm::Callback_TopicManager_retrievePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieve(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_retrieve.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy to the topic instance.
     * @throws IceStorm::NoSuchTopic Raised if the topic does not exist.
     */
    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicPrx end_retrieve(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_retrieve(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Retrieve all topics managed by this topic manager.
     * @param context The Context map to send with the invocation.
     * @return A dictionary of string, topic proxy pairs.
     */
    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicDict retrieveAll(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_retrieveAll(_iceI_begin_retrieveAll(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_retrieveAll(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_retrieveAll(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_retrieveAll(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieveAll(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_retrieveAll(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieveAll(context, cb, cookie);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_retrieveAll(const ::IceStorm::Callback_TopicManager_retrieveAllPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieveAll(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_retrieveAll(const ::Ice::Context& context, const ::IceStorm::Callback_TopicManager_retrieveAllPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieveAll(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_retrieveAll.
     * @param result The asynchronous result object for the invocation.
     * @return A dictionary of string, topic proxy pairs.
     */
    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicDict end_retrieveAll(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_retrieveAll(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    ICE_MEMBER(ICESTORM_API) ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSliceChecksums(_iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, cb, cookie);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::IceStorm::Callback_TopicManager_getSliceChecksumsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::IceStorm::Callback_TopicManager_getSliceChecksumsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getSliceChecksums.
     * @param result The asynchronous result object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    ICE_MEMBER(ICESTORM_API) ::Ice::SliceChecksumDict end_getSliceChecksums(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getSliceChecksums(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICESTORM_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICESTORM_API) Finder : public virtual ::Ice::Proxy<Finder, ::IceProxy::Ice::Object>
{
public:

    /**
     * Get the topic manager proxy. The proxy might point to several
     * replicas.
     * @param context The Context map to send with the invocation.
     * @return The topic manager proxy.
     */
    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicManagerPrx getTopicManager(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getTopicManager(_iceI_begin_getTopicManager(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the topic manager proxy. The proxy might point to several
     * replicas.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTopicManager(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getTopicManager(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the topic manager proxy. The proxy might point to several
     * replicas.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTopicManager(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTopicManager(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the topic manager proxy. The proxy might point to several
     * replicas.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTopicManager(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTopicManager(context, cb, cookie);
    }

    /**
     * Get the topic manager proxy. The proxy might point to several
     * replicas.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTopicManager(const ::IceStorm::Callback_Finder_getTopicManagerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTopicManager(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the topic manager proxy. The proxy might point to several
     * replicas.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTopicManager(const ::Ice::Context& context, const ::IceStorm::Callback_Finder_getTopicManagerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTopicManager(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getTopicManager.
     * @param result The asynchronous result object for the invocation.
     * @return The topic manager proxy.
     */
    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicManagerPrx end_getTopicManager(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getTopicManager(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICESTORM_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceStorm
{

/**
 * Publishers publish information on a particular topic. A topic
 * logically represents a type.
 * @see TopicManager
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API Topic : public virtual ::Ice::Object
{
public:

    typedef TopicPrx ProxyType;
    typedef TopicPtr PointerType;

    virtual ~Topic();

#ifdef ICE_CPP11_COMPILER
    Topic() = default;
    Topic(const Topic&) = default;
    Topic& operator=(const Topic&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the name of this topic.
     * @param current The Current object for the invocation.
     * @return The name of the topic.
     * @see TopicManager#create
     */
    virtual ::std::string getName(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getName(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param current The Current object for the invocation.
     * @return A proxy to publish data on this topic.
     */
    virtual ::Ice::ObjectPrx getPublisher(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getPublisher(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param current The Current object for the invocation.
     * @return A proxy to publish data on this topic.
     */
    virtual ::Ice::ObjectPrx getNonReplicatedPublisher(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNonReplicatedPublisher(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param current The Current object for the invocation.
     * @return The per-subscriber publisher object.
     * @throws IceStorm::AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     * @throws IceStorm::BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     * @throws IceStorm::InvalidSubscriber Raised if the subscriber object is null.
     * @see #unsubscribe
     */
    virtual ::Ice::ObjectPrx subscribeAndGetPublisher(const QoS& theQoS, const ::Ice::ObjectPrx& subscriber, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_subscribeAndGetPublisher(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param current The Current object for the invocation.
     * @see #subscribeAndGetPublisher
     */
    virtual void unsubscribe(const ::Ice::ObjectPrx& subscriber, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_unsubscribe(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param current The Current object for the invocation.
     * @throws IceStorm::LinkExists Raised if a link to the same topic already
     * exists.
     */
    virtual void link(const TopicPrx& linkTo, ::Ice::Int cost, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_link(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param current The Current object for the invocation.
     * @throws IceStorm::NoSuchLink Raised if a link to the topic does not exist.
     */
    virtual void unlink(const TopicPrx& linkTo, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_unlink(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Retrieve information on the current links.
     * @param current The Current object for the invocation.
     * @return A sequence of LinkInfo objects.
     */
    virtual LinkInfoSeq getLinkInfoSeq(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLinkInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Retrieve the list of subscribers for this topic.
     * @param current The Current object for the invocation.
     * @return The sequence of Ice identities for the subscriber objects.
     */
    virtual ::Ice::IdentitySeq getSubscribers(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSubscribers(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Destroy the topic.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Topic& lhs, const Topic& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Topic& lhs, const Topic& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * A topic manager manages topics, and subscribers to topics.
 * @see Topic
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API TopicManager : public virtual ::Ice::Object
{
public:

    typedef TopicManagerPrx ProxyType;
    typedef TopicManagerPtr PointerType;

    virtual ~TopicManager();

#ifdef ICE_CPP11_COMPILER
    TopicManager() = default;
    TopicManager(const TopicManager&) = default;
    TopicManager& operator=(const TopicManager&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param current The Current object for the invocation.
     * @return A proxy to the topic instance.
     * @throws IceStorm::TopicExists Raised if a topic with the same name already
     * exists.
     */
    virtual TopicPrx create(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param current The Current object for the invocation.
     * @return A proxy to the topic instance.
     * @throws IceStorm::NoSuchTopic Raised if the topic does not exist.
     */
    virtual TopicPrx retrieve(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_retrieve(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Retrieve all topics managed by this topic manager.
     * @param current The Current object for the invocation.
     * @return A dictionary of string, topic proxy pairs.
     */
    virtual TopicDict retrieveAll(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_retrieveAll(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param current The Current object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const TopicManager& lhs, const TopicManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const TopicManager& lhs, const TopicManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * This inferface is advertised by the IceStorm service through the
 * Ice object with the identity `IceStorm/Finder'. This allows clients
 * to retrieve the topic manager with just the endpoint information of
 * the IceStorm service.
 * \headerfile IceStorm/IceStorm.h
 */
class ICESTORM_API Finder : public virtual ::Ice::Object
{
public:

    typedef FinderPrx ProxyType;
    typedef FinderPtr PointerType;

    virtual ~Finder();

#ifdef ICE_CPP11_COMPILER
    Finder() = default;
    Finder(const Finder&) = default;
    Finder& operator=(const Finder&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the topic manager proxy. The proxy might point to several
     * replicas.
     * @param current The Current object for the invocation.
     * @return The topic manager proxy.
     */
    virtual TopicManagerPrx getTopicManager(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getTopicManager(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Finder& lhs, const Finder& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Finder& lhs, const Finder& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceStorm::LinkInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceStorm::LinkInfo, S>
{
    static void write(S* ostr, const ::IceStorm::LinkInfo& v)
    {
        ostr->write(v.theTopic);
        ostr->write(v.name);
        ostr->write(v.cost);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::LinkInfo, S>
{
    static void read(S* istr, ::IceStorm::LinkInfo& v)
    {
        istr->read(v.theTopic);
        istr->read(v.name);
        istr->read(v.cost);
    }
};

template<>
struct StreamableTraits< ::IceStorm::LinkExists>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::LinkExists, S>
{
    static void write(S* ostr, const ::IceStorm::LinkExists& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::LinkExists, S>
{
    static void read(S* istr, ::IceStorm::LinkExists& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceStorm::NoSuchLink>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::NoSuchLink, S>
{
    static void write(S* ostr, const ::IceStorm::NoSuchLink& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::NoSuchLink, S>
{
    static void read(S* istr, ::IceStorm::NoSuchLink& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceStorm::AlreadySubscribed>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IceStorm::InvalidSubscriber>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::InvalidSubscriber, S>
{
    static void write(S* ostr, const ::IceStorm::InvalidSubscriber& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::InvalidSubscriber, S>
{
    static void read(S* istr, ::IceStorm::InvalidSubscriber& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceStorm::BadQoS>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::BadQoS, S>
{
    static void write(S* ostr, const ::IceStorm::BadQoS& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::BadQoS, S>
{
    static void read(S* istr, ::IceStorm::BadQoS& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceStorm::TopicExists>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::TopicExists, S>
{
    static void write(S* ostr, const ::IceStorm::TopicExists& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::TopicExists, S>
{
    static void read(S* istr, ::IceStorm::TopicExists& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceStorm::NoSuchTopic>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::NoSuchTopic, S>
{
    static void write(S* ostr, const ::IceStorm::NoSuchTopic& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::NoSuchTopic, S>
{
    static void read(S* istr, ::IceStorm::NoSuchTopic& v)
    {
        istr->read(v.name);
    }
};

}
/// \endcond

namespace IceStorm
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::Topic::begin_getName.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getName.
 */
template<class T>
class CallbackNC_Topic_getName : public Callback_Topic_getName_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_Topic_getName(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getName(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getName.
 */
template<class T> Callback_Topic_getNamePtr
newCallback_Topic_getName(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getName<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getName.
 */
template<class T> Callback_Topic_getNamePtr
newCallback_Topic_getName(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getName<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::Topic::begin_getName.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getName.
 */
template<class T, typename CT>
class Callback_Topic_getName : public Callback_Topic_getName_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_Topic_getName(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getName(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getName.
 */
template<class T, typename CT> Callback_Topic_getNamePtr
newCallback_Topic_getName(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getName<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getName.
 */
template<class T, typename CT> Callback_Topic_getNamePtr
newCallback_Topic_getName(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getName<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::Topic::begin_getPublisher.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getPublisher.
 */
template<class T>
class CallbackNC_Topic_getPublisher : public Callback_Topic_getPublisher_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Topic_getPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getPublisher.
 */
template<class T> Callback_Topic_getPublisherPtr
newCallback_Topic_getPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getPublisher<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getPublisher.
 */
template<class T> Callback_Topic_getPublisherPtr
newCallback_Topic_getPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getPublisher<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::Topic::begin_getPublisher.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getPublisher.
 */
template<class T, typename CT>
class Callback_Topic_getPublisher : public Callback_Topic_getPublisher_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Topic_getPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getPublisher.
 */
template<class T, typename CT> Callback_Topic_getPublisherPtr
newCallback_Topic_getPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getPublisher<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getPublisher.
 */
template<class T, typename CT> Callback_Topic_getPublisherPtr
newCallback_Topic_getPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getPublisher<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::Topic::begin_getNonReplicatedPublisher.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getNonReplicatedPublisher.
 */
template<class T>
class CallbackNC_Topic_getNonReplicatedPublisher : public Callback_Topic_getNonReplicatedPublisher_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Topic_getNonReplicatedPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getNonReplicatedPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getNonReplicatedPublisher.
 */
template<class T> Callback_Topic_getNonReplicatedPublisherPtr
newCallback_Topic_getNonReplicatedPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getNonReplicatedPublisher<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getNonReplicatedPublisher.
 */
template<class T> Callback_Topic_getNonReplicatedPublisherPtr
newCallback_Topic_getNonReplicatedPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getNonReplicatedPublisher<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::Topic::begin_getNonReplicatedPublisher.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getNonReplicatedPublisher.
 */
template<class T, typename CT>
class Callback_Topic_getNonReplicatedPublisher : public Callback_Topic_getNonReplicatedPublisher_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Topic_getNonReplicatedPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getNonReplicatedPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getNonReplicatedPublisher.
 */
template<class T, typename CT> Callback_Topic_getNonReplicatedPublisherPtr
newCallback_Topic_getNonReplicatedPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getNonReplicatedPublisher<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getNonReplicatedPublisher.
 */
template<class T, typename CT> Callback_Topic_getNonReplicatedPublisherPtr
newCallback_Topic_getNonReplicatedPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getNonReplicatedPublisher<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::Topic::begin_subscribeAndGetPublisher.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_subscribeAndGetPublisher.
 */
template<class T>
class CallbackNC_Topic_subscribeAndGetPublisher : public Callback_Topic_subscribeAndGetPublisher_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Topic_subscribeAndGetPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_subscribeAndGetPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_subscribeAndGetPublisher.
 */
template<class T> Callback_Topic_subscribeAndGetPublisherPtr
newCallback_Topic_subscribeAndGetPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_subscribeAndGetPublisher<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_subscribeAndGetPublisher.
 */
template<class T> Callback_Topic_subscribeAndGetPublisherPtr
newCallback_Topic_subscribeAndGetPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_subscribeAndGetPublisher<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::Topic::begin_subscribeAndGetPublisher.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_subscribeAndGetPublisher.
 */
template<class T, typename CT>
class Callback_Topic_subscribeAndGetPublisher : public Callback_Topic_subscribeAndGetPublisher_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Topic_subscribeAndGetPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_subscribeAndGetPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_subscribeAndGetPublisher.
 */
template<class T, typename CT> Callback_Topic_subscribeAndGetPublisherPtr
newCallback_Topic_subscribeAndGetPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_subscribeAndGetPublisher<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_subscribeAndGetPublisher.
 */
template<class T, typename CT> Callback_Topic_subscribeAndGetPublisherPtr
newCallback_Topic_subscribeAndGetPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_subscribeAndGetPublisher<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::Topic::begin_unsubscribe.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_unsubscribe.
 */
template<class T>
class CallbackNC_Topic_unsubscribe : public Callback_Topic_unsubscribe_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Topic_unsubscribe(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unsubscribe.
 */
template<class T> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unsubscribe<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unsubscribe.
 */
template<class T> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unsubscribe<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unsubscribe.
 */
template<class T> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unsubscribe<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unsubscribe.
 */
template<class T> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unsubscribe<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::Topic::begin_unsubscribe.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_unsubscribe.
 */
template<class T, typename CT>
class Callback_Topic_unsubscribe : public Callback_Topic_unsubscribe_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Topic_unsubscribe(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unsubscribe.
 */
template<class T, typename CT> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unsubscribe<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unsubscribe.
 */
template<class T, typename CT> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unsubscribe<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unsubscribe.
 */
template<class T, typename CT> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unsubscribe<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unsubscribe.
 */
template<class T, typename CT> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unsubscribe<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::Topic::begin_link.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_link.
 */
template<class T>
class CallbackNC_Topic_link : public Callback_Topic_link_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Topic_link(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_link(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_link.
 */
template<class T> Callback_Topic_linkPtr
newCallback_Topic_link(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_link<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_link.
 */
template<class T> Callback_Topic_linkPtr
newCallback_Topic_link(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_link<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_link.
 */
template<class T> Callback_Topic_linkPtr
newCallback_Topic_link(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_link<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_link.
 */
template<class T> Callback_Topic_linkPtr
newCallback_Topic_link(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_link<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::Topic::begin_link.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_link.
 */
template<class T, typename CT>
class Callback_Topic_link : public Callback_Topic_link_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Topic_link(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_link(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_link.
 */
template<class T, typename CT> Callback_Topic_linkPtr
newCallback_Topic_link(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_link<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_link.
 */
template<class T, typename CT> Callback_Topic_linkPtr
newCallback_Topic_link(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_link<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_link.
 */
template<class T, typename CT> Callback_Topic_linkPtr
newCallback_Topic_link(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_link<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_link.
 */
template<class T, typename CT> Callback_Topic_linkPtr
newCallback_Topic_link(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_link<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::Topic::begin_unlink.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_unlink.
 */
template<class T>
class CallbackNC_Topic_unlink : public Callback_Topic_unlink_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Topic_unlink(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_unlink(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unlink.
 */
template<class T> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unlink<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unlink.
 */
template<class T> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unlink<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unlink.
 */
template<class T> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unlink<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unlink.
 */
template<class T> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unlink<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::Topic::begin_unlink.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_unlink.
 */
template<class T, typename CT>
class Callback_Topic_unlink : public Callback_Topic_unlink_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Topic_unlink(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_unlink(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unlink.
 */
template<class T, typename CT> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unlink<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unlink.
 */
template<class T, typename CT> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unlink<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unlink.
 */
template<class T, typename CT> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unlink<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_unlink.
 */
template<class T, typename CT> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unlink<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::Topic::begin_getLinkInfoSeq.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getLinkInfoSeq.
 */
template<class T>
class CallbackNC_Topic_getLinkInfoSeq : public Callback_Topic_getLinkInfoSeq_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const LinkInfoSeq&);

    CallbackNC_Topic_getLinkInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        LinkInfoSeq ret;
        try
        {
            ret = proxy->end_getLinkInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getLinkInfoSeq.
 */
template<class T> Callback_Topic_getLinkInfoSeqPtr
newCallback_Topic_getLinkInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const LinkInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getLinkInfoSeq<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getLinkInfoSeq.
 */
template<class T> Callback_Topic_getLinkInfoSeqPtr
newCallback_Topic_getLinkInfoSeq(T* instance, void (T::*cb)(const LinkInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getLinkInfoSeq<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::Topic::begin_getLinkInfoSeq.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getLinkInfoSeq.
 */
template<class T, typename CT>
class Callback_Topic_getLinkInfoSeq : public Callback_Topic_getLinkInfoSeq_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const LinkInfoSeq&, const CT&);

    Callback_Topic_getLinkInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        LinkInfoSeq ret;
        try
        {
            ret = proxy->end_getLinkInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getLinkInfoSeq.
 */
template<class T, typename CT> Callback_Topic_getLinkInfoSeqPtr
newCallback_Topic_getLinkInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const LinkInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getLinkInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getLinkInfoSeq.
 */
template<class T, typename CT> Callback_Topic_getLinkInfoSeqPtr
newCallback_Topic_getLinkInfoSeq(T* instance, void (T::*cb)(const LinkInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getLinkInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::Topic::begin_getSubscribers.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getSubscribers.
 */
template<class T>
class CallbackNC_Topic_getSubscribers : public Callback_Topic_getSubscribers_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::IdentitySeq&);

    CallbackNC_Topic_getSubscribers(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::IdentitySeq ret;
        try
        {
            ret = proxy->end_getSubscribers(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getSubscribers.
 */
template<class T> Callback_Topic_getSubscribersPtr
newCallback_Topic_getSubscribers(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::IdentitySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getSubscribers<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getSubscribers.
 */
template<class T> Callback_Topic_getSubscribersPtr
newCallback_Topic_getSubscribers(T* instance, void (T::*cb)(const ::Ice::IdentitySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getSubscribers<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::Topic::begin_getSubscribers.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_getSubscribers.
 */
template<class T, typename CT>
class Callback_Topic_getSubscribers : public Callback_Topic_getSubscribers_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::IdentitySeq&, const CT&);

    Callback_Topic_getSubscribers(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicPrx proxy = TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::IdentitySeq ret;
        try
        {
            ret = proxy->end_getSubscribers(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getSubscribers.
 */
template<class T, typename CT> Callback_Topic_getSubscribersPtr
newCallback_Topic_getSubscribers(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::IdentitySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getSubscribers<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_getSubscribers.
 */
template<class T, typename CT> Callback_Topic_getSubscribersPtr
newCallback_Topic_getSubscribers(T* instance, void (T::*cb)(const ::Ice::IdentitySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getSubscribers<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::Topic::begin_destroy.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_destroy.
 */
template<class T>
class CallbackNC_Topic_destroy : public Callback_Topic_destroy_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Topic_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_destroy.
 */
template<class T> Callback_Topic_destroyPtr
newCallback_Topic_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_destroy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_destroy.
 */
template<class T> Callback_Topic_destroyPtr
newCallback_Topic_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_destroy<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_destroy.
 */
template<class T> Callback_Topic_destroyPtr
newCallback_Topic_destroy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_destroy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_destroy.
 */
template<class T> Callback_Topic_destroyPtr
newCallback_Topic_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_destroy<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::Topic::begin_destroy.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Topic_destroy.
 */
template<class T, typename CT>
class Callback_Topic_destroy : public Callback_Topic_destroy_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Topic_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_destroy.
 */
template<class T, typename CT> Callback_Topic_destroyPtr
newCallback_Topic_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_destroy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_destroy.
 */
template<class T, typename CT> Callback_Topic_destroyPtr
newCallback_Topic_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_destroy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_destroy.
 */
template<class T, typename CT> Callback_Topic_destroyPtr
newCallback_Topic_destroy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_destroy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Topic::begin_destroy.
 */
template<class T, typename CT> Callback_Topic_destroyPtr
newCallback_Topic_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_destroy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::TopicManager::begin_create.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_create.
 */
template<class T>
class CallbackNC_TopicManager_create : public Callback_TopicManager_create_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const TopicPrx&);

    CallbackNC_TopicManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerPrx proxy = TopicManagerPrx::uncheckedCast(result->getProxy());
        TopicPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_create.
 */
template<class T> Callback_TopicManager_createPtr
newCallback_TopicManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const TopicPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_create<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_create.
 */
template<class T> Callback_TopicManager_createPtr
newCallback_TopicManager_create(T* instance, void (T::*cb)(const TopicPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_create<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::TopicManager::begin_create.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_create.
 */
template<class T, typename CT>
class Callback_TopicManager_create : public Callback_TopicManager_create_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const TopicPrx&, const CT&);

    Callback_TopicManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerPrx proxy = TopicManagerPrx::uncheckedCast(result->getProxy());
        TopicPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_create.
 */
template<class T, typename CT> Callback_TopicManager_createPtr
newCallback_TopicManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const TopicPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_create<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_create.
 */
template<class T, typename CT> Callback_TopicManager_createPtr
newCallback_TopicManager_create(T* instance, void (T::*cb)(const TopicPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_create<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::TopicManager::begin_retrieve.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_retrieve.
 */
template<class T>
class CallbackNC_TopicManager_retrieve : public Callback_TopicManager_retrieve_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const TopicPrx&);

    CallbackNC_TopicManager_retrieve(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerPrx proxy = TopicManagerPrx::uncheckedCast(result->getProxy());
        TopicPrx ret;
        try
        {
            ret = proxy->end_retrieve(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_retrieve.
 */
template<class T> Callback_TopicManager_retrievePtr
newCallback_TopicManager_retrieve(const IceUtil::Handle<T>& instance, void (T::*cb)(const TopicPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_retrieve<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_retrieve.
 */
template<class T> Callback_TopicManager_retrievePtr
newCallback_TopicManager_retrieve(T* instance, void (T::*cb)(const TopicPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_retrieve<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::TopicManager::begin_retrieve.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_retrieve.
 */
template<class T, typename CT>
class Callback_TopicManager_retrieve : public Callback_TopicManager_retrieve_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const TopicPrx&, const CT&);

    Callback_TopicManager_retrieve(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerPrx proxy = TopicManagerPrx::uncheckedCast(result->getProxy());
        TopicPrx ret;
        try
        {
            ret = proxy->end_retrieve(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_retrieve.
 */
template<class T, typename CT> Callback_TopicManager_retrievePtr
newCallback_TopicManager_retrieve(const IceUtil::Handle<T>& instance, void (T::*cb)(const TopicPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_retrieve<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_retrieve.
 */
template<class T, typename CT> Callback_TopicManager_retrievePtr
newCallback_TopicManager_retrieve(T* instance, void (T::*cb)(const TopicPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_retrieve<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::TopicManager::begin_retrieveAll.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_retrieveAll.
 */
template<class T>
class CallbackNC_TopicManager_retrieveAll : public Callback_TopicManager_retrieveAll_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const TopicDict&);

    CallbackNC_TopicManager_retrieveAll(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerPrx proxy = TopicManagerPrx::uncheckedCast(result->getProxy());
        TopicDict ret;
        try
        {
            ret = proxy->end_retrieveAll(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_retrieveAll.
 */
template<class T> Callback_TopicManager_retrieveAllPtr
newCallback_TopicManager_retrieveAll(const IceUtil::Handle<T>& instance, void (T::*cb)(const TopicDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_retrieveAll<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_retrieveAll.
 */
template<class T> Callback_TopicManager_retrieveAllPtr
newCallback_TopicManager_retrieveAll(T* instance, void (T::*cb)(const TopicDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_retrieveAll<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::TopicManager::begin_retrieveAll.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_retrieveAll.
 */
template<class T, typename CT>
class Callback_TopicManager_retrieveAll : public Callback_TopicManager_retrieveAll_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const TopicDict&, const CT&);

    Callback_TopicManager_retrieveAll(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerPrx proxy = TopicManagerPrx::uncheckedCast(result->getProxy());
        TopicDict ret;
        try
        {
            ret = proxy->end_retrieveAll(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_retrieveAll.
 */
template<class T, typename CT> Callback_TopicManager_retrieveAllPtr
newCallback_TopicManager_retrieveAll(const IceUtil::Handle<T>& instance, void (T::*cb)(const TopicDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_retrieveAll<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_retrieveAll.
 */
template<class T, typename CT> Callback_TopicManager_retrieveAllPtr
newCallback_TopicManager_retrieveAll(T* instance, void (T::*cb)(const TopicDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_retrieveAll<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::TopicManager::begin_getSliceChecksums.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_getSliceChecksums.
 */
template<class T>
class CallbackNC_TopicManager_getSliceChecksums : public Callback_TopicManager_getSliceChecksums_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::SliceChecksumDict&);

    CallbackNC_TopicManager_getSliceChecksums(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerPrx proxy = TopicManagerPrx::uncheckedCast(result->getProxy());
        ::Ice::SliceChecksumDict ret;
        try
        {
            ret = proxy->end_getSliceChecksums(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_getSliceChecksums.
 */
template<class T> Callback_TopicManager_getSliceChecksumsPtr
newCallback_TopicManager_getSliceChecksums(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::SliceChecksumDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_getSliceChecksums<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_getSliceChecksums.
 */
template<class T> Callback_TopicManager_getSliceChecksumsPtr
newCallback_TopicManager_getSliceChecksums(T* instance, void (T::*cb)(const ::Ice::SliceChecksumDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_getSliceChecksums<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::TopicManager::begin_getSliceChecksums.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManager_getSliceChecksums.
 */
template<class T, typename CT>
class Callback_TopicManager_getSliceChecksums : public Callback_TopicManager_getSliceChecksums_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::SliceChecksumDict&, const CT&);

    Callback_TopicManager_getSliceChecksums(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerPrx proxy = TopicManagerPrx::uncheckedCast(result->getProxy());
        ::Ice::SliceChecksumDict ret;
        try
        {
            ret = proxy->end_getSliceChecksums(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_getSliceChecksums.
 */
template<class T, typename CT> Callback_TopicManager_getSliceChecksumsPtr
newCallback_TopicManager_getSliceChecksums(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::SliceChecksumDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_getSliceChecksums<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManager::begin_getSliceChecksums.
 */
template<class T, typename CT> Callback_TopicManager_getSliceChecksumsPtr
newCallback_TopicManager_getSliceChecksums(T* instance, void (T::*cb)(const ::Ice::SliceChecksumDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_getSliceChecksums<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::Finder::begin_getTopicManager.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Finder_getTopicManager.
 */
template<class T>
class CallbackNC_Finder_getTopicManager : public Callback_Finder_getTopicManager_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const TopicManagerPrx&);

    CallbackNC_Finder_getTopicManager(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FinderPrx proxy = FinderPrx::uncheckedCast(result->getProxy());
        TopicManagerPrx ret;
        try
        {
            ret = proxy->end_getTopicManager(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Finder::begin_getTopicManager.
 */
template<class T> Callback_Finder_getTopicManagerPtr
newCallback_Finder_getTopicManager(const IceUtil::Handle<T>& instance, void (T::*cb)(const TopicManagerPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Finder_getTopicManager<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Finder::begin_getTopicManager.
 */
template<class T> Callback_Finder_getTopicManagerPtr
newCallback_Finder_getTopicManager(T* instance, void (T::*cb)(const TopicManagerPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Finder_getTopicManager<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::Finder::begin_getTopicManager.
 * Create a wrapper instance by calling ::IceStorm::newCallback_Finder_getTopicManager.
 */
template<class T, typename CT>
class Callback_Finder_getTopicManager : public Callback_Finder_getTopicManager_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const TopicManagerPrx&, const CT&);

    Callback_Finder_getTopicManager(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FinderPrx proxy = FinderPrx::uncheckedCast(result->getProxy());
        TopicManagerPrx ret;
        try
        {
            ret = proxy->end_getTopicManager(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Finder::begin_getTopicManager.
 */
template<class T, typename CT> Callback_Finder_getTopicManagerPtr
newCallback_Finder_getTopicManager(const IceUtil::Handle<T>& instance, void (T::*cb)(const TopicManagerPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Finder_getTopicManager<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::Finder::begin_getTopicManager.
 */
template<class T, typename CT> Callback_Finder_getTopicManagerPtr
newCallback_Finder_getTopicManager(T* instance, void (T::*cb)(const TopicManagerPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Finder_getTopicManager<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
