/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.coyote.http2.AbstractStream;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.StreamStateMachine;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

abstract class AbstractNonZeroStream
extends AbstractStream {
    private static final Log log = LogFactory.getLog(AbstractNonZeroStream.class);
    private static final StringManager sm = StringManager.getManager(AbstractNonZeroStream.class);
    protected static final ByteBuffer ZERO_LENGTH_BYTEBUFFER = ByteBuffer.allocate(0);
    protected final StreamStateMachine state;
    private volatile int weight = 16;

    AbstractNonZeroStream(String string, Integer n) {
        super(n);
        this.state = new StreamStateMachine(string, this.getIdAsString());
    }

    AbstractNonZeroStream(Integer n, StreamStateMachine streamStateMachine) {
        super(n);
        this.state = streamStateMachine;
    }

    @Override
    final int getWeight() {
        return this.weight;
    }

    final void rePrioritise(AbstractStream abstractStream, boolean bl, int n) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reprioritisation.debug", new Object[]{this.getConnectionId(), this.getIdAsString(), Boolean.toString(bl), abstractStream.getIdAsString(), Integer.toString(n)}));
        }
        if (this.isDescendant(abstractStream)) {
            abstractStream.detachFromParent();
            this.getParentStream().addChild((AbstractNonZeroStream)abstractStream);
        }
        if (bl) {
            Iterator<AbstractNonZeroStream> iterator = abstractStream.getChildStreams().iterator();
            while (iterator.hasNext()) {
                AbstractNonZeroStream abstractNonZeroStream = iterator.next();
                iterator.remove();
                this.addChild(abstractNonZeroStream);
            }
        }
        this.detachFromParent();
        abstractStream.addChild(this);
        this.weight = n;
    }

    final void rePrioritise(AbstractStream abstractStream, int n) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reprioritisation.debug", new Object[]{this.getConnectionId(), this.getIdAsString(), Boolean.FALSE, abstractStream.getIdAsString(), Integer.toString(n)}));
        }
        abstractStream.addChild(this);
        this.weight = n;
    }

    void replaceStream(AbstractNonZeroStream abstractNonZeroStream) {
        this.getParentStream().addChild(abstractNonZeroStream);
        this.detachFromParent();
        for (AbstractNonZeroStream abstractNonZeroStream2 : this.getChildStreams()) {
            abstractNonZeroStream.addChild(abstractNonZeroStream2);
        }
        this.getChildStreams().clear();
        abstractNonZeroStream.weight = this.weight;
    }

    final boolean isClosedFinal() {
        return this.state.isClosedFinal();
    }

    final void checkState(FrameType frameType) throws Http2Exception {
        this.state.checkFrameType(frameType);
    }

    abstract ByteBuffer getInputByteBuffer();

    abstract void receivedData(int var1) throws Http2Exception;
}

