/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "shell-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Accounts.User
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgFreedesktopAccountsUser
 * @title: OrgFreedesktopAccountsUser
 * @short_description: Generated C code for the org.freedesktop.Accounts.User D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Accounts-User.top_of_page">org.freedesktop.Accounts.User</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.Accounts.User ---- */

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_user_name_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_user_name_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_user_name_IN_ARG_name.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_user_name_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_user_name_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_user_name_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_user_name =
{
  {
    -1,
    (gchar *) "SetUserName",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_user_name_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_user_name_annotation_info_pointers
  },
  "handle-set-user-name",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_real_name_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_real_name_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_real_name_IN_ARG_name.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_real_name_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_real_name_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_real_name_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_real_name =
{
  {
    -1,
    (gchar *) "SetRealName",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_real_name_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_real_name_annotation_info_pointers
  },
  "handle-set-real-name",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_email_IN_ARG_email =
{
  {
    -1,
    (gchar *) "email",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_email_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_email_IN_ARG_email.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_email_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_email_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_email_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_email =
{
  {
    -1,
    (gchar *) "SetEmail",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_email_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_email_annotation_info_pointers
  },
  "handle-set-email",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_language_IN_ARG_language =
{
  {
    -1,
    (gchar *) "language",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_language_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_language_IN_ARG_language.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_language_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_language_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_language_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_language =
{
  {
    -1,
    (gchar *) "SetLanguage",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_language_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_language_annotation_info_pointers
  },
  "handle-set-language",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_xsession_IN_ARG_x_session =
{
  {
    -1,
    (gchar *) "x_session",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_xsession_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_xsession_IN_ARG_x_session.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_xsession_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_xsession_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "user_set_x_session",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_xsession_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_xsession_annotation_info_0,
  &_org_freedesktop_accounts_user_method_set_xsession_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_xsession =
{
  {
    -1,
    (gchar *) "SetXSession",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_xsession_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_xsession_annotation_info_pointers
  },
  "handle-set-xsession",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_location_IN_ARG_location =
{
  {
    -1,
    (gchar *) "location",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_location_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_location_IN_ARG_location.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_location_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_location_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_location_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_location =
{
  {
    -1,
    (gchar *) "SetLocation",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_location_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_location_annotation_info_pointers
  },
  "handle-set-location",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_home_directory_IN_ARG_homedir =
{
  {
    -1,
    (gchar *) "homedir",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_home_directory_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_home_directory_IN_ARG_homedir.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_home_directory_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_home_directory_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_home_directory_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_home_directory =
{
  {
    -1,
    (gchar *) "SetHomeDirectory",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_home_directory_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_home_directory_annotation_info_pointers
  },
  "handle-set-home-directory",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_shell_IN_ARG_shell =
{
  {
    -1,
    (gchar *) "shell",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_shell_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_shell_IN_ARG_shell.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_shell_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_shell_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_shell_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_shell =
{
  {
    -1,
    (gchar *) "SetShell",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_shell_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_shell_annotation_info_pointers
  },
  "handle-set-shell",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_icon_file_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_icon_file_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_icon_file_IN_ARG_filename.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_icon_file_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_icon_file_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_icon_file_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_icon_file =
{
  {
    -1,
    (gchar *) "SetIconFile",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_icon_file_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_icon_file_annotation_info_pointers
  },
  "handle-set-icon-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_locked_IN_ARG_locked =
{
  {
    -1,
    (gchar *) "locked",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_locked_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_locked_IN_ARG_locked.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_locked_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_locked_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_locked_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_locked =
{
  {
    -1,
    (gchar *) "SetLocked",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_locked_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_locked_annotation_info_pointers
  },
  "handle-set-locked",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_account_type_IN_ARG_accountType =
{
  {
    -1,
    (gchar *) "accountType",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_account_type_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_account_type_IN_ARG_accountType.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_account_type_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_account_type_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_account_type_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_account_type =
{
  {
    -1,
    (gchar *) "SetAccountType",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_account_type_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_account_type_annotation_info_pointers
  },
  "handle-set-account-type",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_password_mode_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_password_mode_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_password_mode_IN_ARG_mode.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_password_mode_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_password_mode_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_password_mode_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_password_mode =
{
  {
    -1,
    (gchar *) "SetPasswordMode",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_password_mode_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_password_mode_annotation_info_pointers
  },
  "handle-set-password-mode",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_password_IN_ARG_password =
{
  {
    -1,
    (gchar *) "password",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_password_IN_ARG_hint =
{
  {
    -1,
    (gchar *) "hint",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_password_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_password_IN_ARG_password.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_password_IN_ARG_hint.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_password_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_password_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_password_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_password =
{
  {
    -1,
    (gchar *) "SetPassword",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_password_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_password_annotation_info_pointers
  },
  "handle-set-password",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_password_hint_IN_ARG_hint =
{
  {
    -1,
    (gchar *) "hint",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_password_hint_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_password_hint_IN_ARG_hint.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_password_hint_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_password_hint_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_password_hint_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_password_hint =
{
  {
    -1,
    (gchar *) "SetPasswordHint",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_password_hint_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_password_hint_annotation_info_pointers
  },
  "handle-set-password-hint",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_user_method_info_set_automatic_login_IN_ARG_enabled =
{
  {
    -1,
    (gchar *) "enabled",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_user_method_info_set_automatic_login_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_automatic_login_IN_ARG_enabled.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_user_method_set_automatic_login_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_user_method_set_automatic_login_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_set_automatic_login_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_user_method_info_set_automatic_login =
{
  {
    -1,
    (gchar *) "SetAutomaticLogin",
    (GDBusArgInfo **) &_org_freedesktop_accounts_user_method_info_set_automatic_login_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_user_method_set_automatic_login_annotation_info_pointers
  },
  "handle-set-automatic-login",
  FALSE
};

static const GDBusMethodInfo * const _org_freedesktop_accounts_user_method_info_pointers[] =
{
  &_org_freedesktop_accounts_user_method_info_set_user_name.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_real_name.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_email.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_language.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_xsession.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_location.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_home_directory.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_shell.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_icon_file.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_locked.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_account_type.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_password_mode.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_password.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_password_hint.parent_struct,
  &_org_freedesktop_accounts_user_method_info_set_automatic_login.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_freedesktop_accounts_user_signal_info_changed =
{
  {
    -1,
    (gchar *) "Changed",
    NULL,
    NULL
  },
  "changed"
};

static const GDBusSignalInfo * const _org_freedesktop_accounts_user_signal_info_pointers[] =
{
  &_org_freedesktop_accounts_user_signal_info_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_uid =
{
  {
    -1,
    (gchar *) "Uid",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "uid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_user_name =
{
  {
    -1,
    (gchar *) "UserName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "user-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_real_name =
{
  {
    -1,
    (gchar *) "RealName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "real-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_account_type =
{
  {
    -1,
    (gchar *) "AccountType",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "account-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_home_directory =
{
  {
    -1,
    (gchar *) "HomeDirectory",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "home-directory",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_shell =
{
  {
    -1,
    (gchar *) "Shell",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "shell",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_email =
{
  {
    -1,
    (gchar *) "Email",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "email",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_language =
{
  {
    -1,
    (gchar *) "Language",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "language",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_xsession =
{
  {
    -1,
    (gchar *) "XSession",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "xsession",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_location =
{
  {
    -1,
    (gchar *) "Location",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "location",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_login_frequency =
{
  {
    -1,
    (gchar *) "LoginFrequency",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "login-frequency",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_login_time =
{
  {
    -1,
    (gchar *) "LoginTime",
    (gchar *) "x",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "login-time",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_login_history =
{
  {
    -1,
    (gchar *) "LoginHistory",
    (gchar *) "a(xxa{sv})",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "login-history",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_icon_file =
{
  {
    -1,
    (gchar *) "IconFile",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "icon-file",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_locked =
{
  {
    -1,
    (gchar *) "Locked",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "locked",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_password_mode =
{
  {
    -1,
    (gchar *) "PasswordMode",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "password-mode",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_password_hint =
{
  {
    -1,
    (gchar *) "PasswordHint",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "password-hint",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_automatic_login =
{
  {
    -1,
    (gchar *) "AutomaticLogin",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "automatic-login",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_system_account =
{
  {
    -1,
    (gchar *) "SystemAccount",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "system-account",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_user_property_info_local_account =
{
  {
    -1,
    (gchar *) "LocalAccount",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "local-account",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _org_freedesktop_accounts_user_property_info_pointers[] =
{
  &_org_freedesktop_accounts_user_property_info_uid.parent_struct,
  &_org_freedesktop_accounts_user_property_info_user_name.parent_struct,
  &_org_freedesktop_accounts_user_property_info_real_name.parent_struct,
  &_org_freedesktop_accounts_user_property_info_account_type.parent_struct,
  &_org_freedesktop_accounts_user_property_info_home_directory.parent_struct,
  &_org_freedesktop_accounts_user_property_info_shell.parent_struct,
  &_org_freedesktop_accounts_user_property_info_email.parent_struct,
  &_org_freedesktop_accounts_user_property_info_language.parent_struct,
  &_org_freedesktop_accounts_user_property_info_xsession.parent_struct,
  &_org_freedesktop_accounts_user_property_info_location.parent_struct,
  &_org_freedesktop_accounts_user_property_info_login_frequency.parent_struct,
  &_org_freedesktop_accounts_user_property_info_login_time.parent_struct,
  &_org_freedesktop_accounts_user_property_info_login_history.parent_struct,
  &_org_freedesktop_accounts_user_property_info_icon_file.parent_struct,
  &_org_freedesktop_accounts_user_property_info_locked.parent_struct,
  &_org_freedesktop_accounts_user_property_info_password_mode.parent_struct,
  &_org_freedesktop_accounts_user_property_info_password_hint.parent_struct,
  &_org_freedesktop_accounts_user_property_info_automatic_login.parent_struct,
  &_org_freedesktop_accounts_user_property_info_system_account.parent_struct,
  &_org_freedesktop_accounts_user_property_info_local_account.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_freedesktop_accounts_user_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Accounts.User",
    (GDBusMethodInfo **) &_org_freedesktop_accounts_user_method_info_pointers,
    (GDBusSignalInfo **) &_org_freedesktop_accounts_user_signal_info_pointers,
    (GDBusPropertyInfo **) &_org_freedesktop_accounts_user_property_info_pointers,
    NULL
  },
  "org-freedesktop-accounts-user",
};


/**
 * org_freedesktop_accounts_user_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Accounts-User.top_of_page">org.freedesktop.Accounts.User</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_freedesktop_accounts_user_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_freedesktop_accounts_user_interface_info.parent_struct;
}

/**
 * org_freedesktop_accounts_user_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgFreedesktopAccountsUser interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_freedesktop_accounts_user_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "uid");
  g_object_class_override_property (klass, property_id_begin++, "user-name");
  g_object_class_override_property (klass, property_id_begin++, "real-name");
  g_object_class_override_property (klass, property_id_begin++, "account-type");
  g_object_class_override_property (klass, property_id_begin++, "home-directory");
  g_object_class_override_property (klass, property_id_begin++, "shell");
  g_object_class_override_property (klass, property_id_begin++, "email");
  g_object_class_override_property (klass, property_id_begin++, "language");
  g_object_class_override_property (klass, property_id_begin++, "xsession");
  g_object_class_override_property (klass, property_id_begin++, "location");
  g_object_class_override_property (klass, property_id_begin++, "login-frequency");
  g_object_class_override_property (klass, property_id_begin++, "login-time");
  g_object_class_override_property (klass, property_id_begin++, "login-history");
  g_object_class_override_property (klass, property_id_begin++, "icon-file");
  g_object_class_override_property (klass, property_id_begin++, "locked");
  g_object_class_override_property (klass, property_id_begin++, "password-mode");
  g_object_class_override_property (klass, property_id_begin++, "password-hint");
  g_object_class_override_property (klass, property_id_begin++, "automatic-login");
  g_object_class_override_property (klass, property_id_begin++, "system-account");
  g_object_class_override_property (klass, property_id_begin++, "local-account");
  return property_id_begin - 1;
}



/**
 * OrgFreedesktopAccountsUser:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Accounts-User.top_of_page">org.freedesktop.Accounts.User</link>.
 */

/**
 * OrgFreedesktopAccountsUserIface:
 * @parent_iface: The parent interface.
 * @handle_set_account_type: Handler for the #OrgFreedesktopAccountsUser::handle-set-account-type signal.
 * @handle_set_automatic_login: Handler for the #OrgFreedesktopAccountsUser::handle-set-automatic-login signal.
 * @handle_set_email: Handler for the #OrgFreedesktopAccountsUser::handle-set-email signal.
 * @handle_set_home_directory: Handler for the #OrgFreedesktopAccountsUser::handle-set-home-directory signal.
 * @handle_set_icon_file: Handler for the #OrgFreedesktopAccountsUser::handle-set-icon-file signal.
 * @handle_set_language: Handler for the #OrgFreedesktopAccountsUser::handle-set-language signal.
 * @handle_set_location: Handler for the #OrgFreedesktopAccountsUser::handle-set-location signal.
 * @handle_set_locked: Handler for the #OrgFreedesktopAccountsUser::handle-set-locked signal.
 * @handle_set_password: Handler for the #OrgFreedesktopAccountsUser::handle-set-password signal.
 * @handle_set_password_hint: Handler for the #OrgFreedesktopAccountsUser::handle-set-password-hint signal.
 * @handle_set_password_mode: Handler for the #OrgFreedesktopAccountsUser::handle-set-password-mode signal.
 * @handle_set_real_name: Handler for the #OrgFreedesktopAccountsUser::handle-set-real-name signal.
 * @handle_set_shell: Handler for the #OrgFreedesktopAccountsUser::handle-set-shell signal.
 * @handle_set_user_name: Handler for the #OrgFreedesktopAccountsUser::handle-set-user-name signal.
 * @handle_set_xsession: Handler for the #OrgFreedesktopAccountsUser::handle-set-xsession signal.
 * @get_account_type: Getter for the #OrgFreedesktopAccountsUser:account-type property.
 * @get_automatic_login: Getter for the #OrgFreedesktopAccountsUser:automatic-login property.
 * @get_email: Getter for the #OrgFreedesktopAccountsUser:email property.
 * @get_home_directory: Getter for the #OrgFreedesktopAccountsUser:home-directory property.
 * @get_icon_file: Getter for the #OrgFreedesktopAccountsUser:icon-file property.
 * @get_language: Getter for the #OrgFreedesktopAccountsUser:language property.
 * @get_local_account: Getter for the #OrgFreedesktopAccountsUser:local-account property.
 * @get_location: Getter for the #OrgFreedesktopAccountsUser:location property.
 * @get_locked: Getter for the #OrgFreedesktopAccountsUser:locked property.
 * @get_login_frequency: Getter for the #OrgFreedesktopAccountsUser:login-frequency property.
 * @get_login_history: Getter for the #OrgFreedesktopAccountsUser:login-history property.
 * @get_login_time: Getter for the #OrgFreedesktopAccountsUser:login-time property.
 * @get_password_hint: Getter for the #OrgFreedesktopAccountsUser:password-hint property.
 * @get_password_mode: Getter for the #OrgFreedesktopAccountsUser:password-mode property.
 * @get_real_name: Getter for the #OrgFreedesktopAccountsUser:real-name property.
 * @get_shell: Getter for the #OrgFreedesktopAccountsUser:shell property.
 * @get_system_account: Getter for the #OrgFreedesktopAccountsUser:system-account property.
 * @get_uid: Getter for the #OrgFreedesktopAccountsUser:uid property.
 * @get_user_name: Getter for the #OrgFreedesktopAccountsUser:user-name property.
 * @get_xsession: Getter for the #OrgFreedesktopAccountsUser:xsession property.
 * @changed: Handler for the #OrgFreedesktopAccountsUser::changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Accounts-User.top_of_page">org.freedesktop.Accounts.User</link>.
 */

typedef OrgFreedesktopAccountsUserIface OrgFreedesktopAccountsUserInterface;
G_DEFINE_INTERFACE (OrgFreedesktopAccountsUser, org_freedesktop_accounts_user, G_TYPE_OBJECT)

static void
org_freedesktop_accounts_user_default_init (OrgFreedesktopAccountsUserIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgFreedesktopAccountsUser::handle-set-user-name:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetUserName">SetUserName()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_user_name() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-user-name",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_user_name),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccountsUser::handle-set-real-name:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetRealName">SetRealName()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_real_name() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-real-name",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_real_name),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccountsUser::handle-set-email:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_email: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetEmail">SetEmail()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_email() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-email",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_email),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccountsUser::handle-set-language:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_language: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLanguage">SetLanguage()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_language() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-language",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_language),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccountsUser::handle-set-xsession:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x_session: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetXSession">SetXSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_xsession() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-xsession",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_xsession),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccountsUser::handle-set-location:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_location: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLocation">SetLocation()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_location() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-location",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_location),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccountsUser::handle-set-home-directory:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_homedir: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetHomeDirectory">SetHomeDirectory()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_home_directory() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-home-directory",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_home_directory),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccountsUser::handle-set-shell:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_shell: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetShell">SetShell()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_shell() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-shell",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_shell),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccountsUser::handle-set-icon-file:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetIconFile">SetIconFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_icon_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-icon-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_icon_file),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccountsUser::handle-set-locked:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_locked: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLocked">SetLocked()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_locked() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-locked",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_locked),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * OrgFreedesktopAccountsUser::handle-set-account-type:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_accountType: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetAccountType">SetAccountType()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_account_type() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-account-type",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_account_type),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * OrgFreedesktopAccountsUser::handle-set-password-mode:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPasswordMode">SetPasswordMode()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_password_mode() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-password-mode",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_password_mode),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * OrgFreedesktopAccountsUser::handle-set-password:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_password: Argument passed by remote caller.
   * @arg_hint: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPassword">SetPassword()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_password() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-password",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_password),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccountsUser::handle-set-password-hint:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_hint: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPasswordHint">SetPasswordHint()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_password_hint() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-password-hint",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_password_hint),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccountsUser::handle-set-automatic-login:
   * @object: A #OrgFreedesktopAccountsUser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_enabled: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetAutomaticLogin">SetAutomaticLogin()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_user_complete_set_automatic_login() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-automatic-login",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, handle_set_automatic_login),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgFreedesktopAccountsUser::changed:
   * @object: A #OrgFreedesktopAccountsUser.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Accounts-User.Changed">"Changed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsUserIface, changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /* GObject properties for D-Bus properties: */
  /**
   * OrgFreedesktopAccountsUser:uid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.Uid">"Uid"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("uid", "Uid", "Uid", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:user-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.UserName">"UserName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("user-name", "UserName", "UserName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:real-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.RealName">"RealName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("real-name", "RealName", "RealName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:account-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.AccountType">"AccountType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("account-type", "AccountType", "AccountType", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:home-directory:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.HomeDirectory">"HomeDirectory"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("home-directory", "HomeDirectory", "HomeDirectory", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:shell:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.Shell">"Shell"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("shell", "Shell", "Shell", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:email:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.Email">"Email"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("email", "Email", "Email", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:language:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.Language">"Language"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("language", "Language", "Language", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:xsession:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.XSession">"XSession"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("xsession", "XSession", "XSession", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:location:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.Location">"Location"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("location", "Location", "Location", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:login-frequency:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.LoginFrequency">"LoginFrequency"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("login-frequency", "LoginFrequency", "LoginFrequency", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:login-time:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.LoginTime">"LoginTime"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int64 ("login-time", "LoginTime", "LoginTime", G_MININT64, G_MAXINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:login-history:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.LoginHistory">"LoginHistory"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("login-history", "LoginHistory", "LoginHistory", G_VARIANT_TYPE ("a(xxa{sv})"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:icon-file:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.IconFile">"IconFile"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("icon-file", "IconFile", "IconFile", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:locked:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.Locked">"Locked"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("locked", "Locked", "Locked", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:password-mode:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.PasswordMode">"PasswordMode"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("password-mode", "PasswordMode", "PasswordMode", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:password-hint:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.PasswordHint">"PasswordHint"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("password-hint", "PasswordHint", "PasswordHint", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:automatic-login:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.AutomaticLogin">"AutomaticLogin"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("automatic-login", "AutomaticLogin", "AutomaticLogin", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:system-account:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.SystemAccount">"SystemAccount"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("system-account", "SystemAccount", "SystemAccount", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgFreedesktopAccountsUser:local-account:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts-User.LocalAccount">"LocalAccount"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("local-account", "LocalAccount", "LocalAccount", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * org_freedesktop_accounts_user_get_uid: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Uid">"Uid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
org_freedesktop_accounts_user_get_uid (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_uid (object);
}

/**
 * org_freedesktop_accounts_user_set_uid: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Uid">"Uid"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_uid (OrgFreedesktopAccountsUser *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "uid", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_user_name: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.UserName">"UserName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_user_dup_user_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_freedesktop_accounts_user_get_user_name (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_user_name (object);
}

/**
 * org_freedesktop_accounts_user_dup_user_name: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.UserName">"UserName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_freedesktop_accounts_user_dup_user_name (OrgFreedesktopAccountsUser *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "user-name", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_user_set_user_name: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.UserName">"UserName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_user_name (OrgFreedesktopAccountsUser *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "user-name", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_real_name: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.RealName">"RealName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_user_dup_real_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_freedesktop_accounts_user_get_real_name (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_real_name (object);
}

/**
 * org_freedesktop_accounts_user_dup_real_name: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.RealName">"RealName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_freedesktop_accounts_user_dup_real_name (OrgFreedesktopAccountsUser *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "real-name", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_user_set_real_name: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.RealName">"RealName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_real_name (OrgFreedesktopAccountsUser *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "real-name", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_account_type: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.AccountType">"AccountType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
org_freedesktop_accounts_user_get_account_type (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_account_type (object);
}

/**
 * org_freedesktop_accounts_user_set_account_type: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.AccountType">"AccountType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_account_type (OrgFreedesktopAccountsUser *object, gint value)
{
  g_object_set (G_OBJECT (object), "account-type", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_home_directory: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.HomeDirectory">"HomeDirectory"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_user_dup_home_directory() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_freedesktop_accounts_user_get_home_directory (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_home_directory (object);
}

/**
 * org_freedesktop_accounts_user_dup_home_directory: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.HomeDirectory">"HomeDirectory"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_freedesktop_accounts_user_dup_home_directory (OrgFreedesktopAccountsUser *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "home-directory", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_user_set_home_directory: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.HomeDirectory">"HomeDirectory"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_home_directory (OrgFreedesktopAccountsUser *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "home-directory", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_shell: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Shell">"Shell"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_user_dup_shell() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_freedesktop_accounts_user_get_shell (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_shell (object);
}

/**
 * org_freedesktop_accounts_user_dup_shell: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Shell">"Shell"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_freedesktop_accounts_user_dup_shell (OrgFreedesktopAccountsUser *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "shell", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_user_set_shell: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Shell">"Shell"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_shell (OrgFreedesktopAccountsUser *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "shell", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_email: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Email">"Email"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_user_dup_email() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_freedesktop_accounts_user_get_email (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_email (object);
}

/**
 * org_freedesktop_accounts_user_dup_email: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Email">"Email"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_freedesktop_accounts_user_dup_email (OrgFreedesktopAccountsUser *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "email", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_user_set_email: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Email">"Email"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_email (OrgFreedesktopAccountsUser *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "email", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_language: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Language">"Language"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_user_dup_language() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_freedesktop_accounts_user_get_language (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_language (object);
}

/**
 * org_freedesktop_accounts_user_dup_language: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Language">"Language"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_freedesktop_accounts_user_dup_language (OrgFreedesktopAccountsUser *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "language", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_user_set_language: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Language">"Language"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_language (OrgFreedesktopAccountsUser *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "language", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_xsession: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.XSession">"XSession"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_user_dup_xsession() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_freedesktop_accounts_user_get_xsession (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_xsession (object);
}

/**
 * org_freedesktop_accounts_user_dup_xsession: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.XSession">"XSession"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_freedesktop_accounts_user_dup_xsession (OrgFreedesktopAccountsUser *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "xsession", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_user_set_xsession: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.XSession">"XSession"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_xsession (OrgFreedesktopAccountsUser *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "xsession", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_location: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Location">"Location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_user_dup_location() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_freedesktop_accounts_user_get_location (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_location (object);
}

/**
 * org_freedesktop_accounts_user_dup_location: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Location">"Location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_freedesktop_accounts_user_dup_location (OrgFreedesktopAccountsUser *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "location", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_user_set_location: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Location">"Location"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_location (OrgFreedesktopAccountsUser *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "location", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_login_frequency: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.LoginFrequency">"LoginFrequency"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
org_freedesktop_accounts_user_get_login_frequency (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_login_frequency (object);
}

/**
 * org_freedesktop_accounts_user_set_login_frequency: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.LoginFrequency">"LoginFrequency"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_login_frequency (OrgFreedesktopAccountsUser *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "login-frequency", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_login_time: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.LoginTime">"LoginTime"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint64 
org_freedesktop_accounts_user_get_login_time (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_login_time (object);
}

/**
 * org_freedesktop_accounts_user_set_login_time: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.LoginTime">"LoginTime"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_login_time (OrgFreedesktopAccountsUser *object, gint64 value)
{
  g_object_set (G_OBJECT (object), "login-time", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_login_history: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.LoginHistory">"LoginHistory"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_user_dup_login_history() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
org_freedesktop_accounts_user_get_login_history (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_login_history (object);
}

/**
 * org_freedesktop_accounts_user_dup_login_history: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.LoginHistory">"LoginHistory"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
org_freedesktop_accounts_user_dup_login_history (OrgFreedesktopAccountsUser *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "login-history", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_user_set_login_history: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.LoginHistory">"LoginHistory"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_login_history (OrgFreedesktopAccountsUser *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "login-history", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_icon_file: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.IconFile">"IconFile"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_user_dup_icon_file() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_freedesktop_accounts_user_get_icon_file (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_icon_file (object);
}

/**
 * org_freedesktop_accounts_user_dup_icon_file: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.IconFile">"IconFile"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_freedesktop_accounts_user_dup_icon_file (OrgFreedesktopAccountsUser *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "icon-file", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_user_set_icon_file: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.IconFile">"IconFile"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_icon_file (OrgFreedesktopAccountsUser *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "icon-file", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_locked: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Locked">"Locked"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
org_freedesktop_accounts_user_get_locked (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_locked (object);
}

/**
 * org_freedesktop_accounts_user_set_locked: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.Locked">"Locked"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_locked (OrgFreedesktopAccountsUser *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "locked", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_password_mode: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.PasswordMode">"PasswordMode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
org_freedesktop_accounts_user_get_password_mode (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_password_mode (object);
}

/**
 * org_freedesktop_accounts_user_set_password_mode: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.PasswordMode">"PasswordMode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_password_mode (OrgFreedesktopAccountsUser *object, gint value)
{
  g_object_set (G_OBJECT (object), "password-mode", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_password_hint: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.PasswordHint">"PasswordHint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_user_dup_password_hint() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_freedesktop_accounts_user_get_password_hint (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_password_hint (object);
}

/**
 * org_freedesktop_accounts_user_dup_password_hint: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.PasswordHint">"PasswordHint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_freedesktop_accounts_user_dup_password_hint (OrgFreedesktopAccountsUser *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "password-hint", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_user_set_password_hint: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.PasswordHint">"PasswordHint"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_password_hint (OrgFreedesktopAccountsUser *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "password-hint", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_automatic_login: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.AutomaticLogin">"AutomaticLogin"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
org_freedesktop_accounts_user_get_automatic_login (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_automatic_login (object);
}

/**
 * org_freedesktop_accounts_user_set_automatic_login: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.AutomaticLogin">"AutomaticLogin"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_automatic_login (OrgFreedesktopAccountsUser *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "automatic-login", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_system_account: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.SystemAccount">"SystemAccount"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
org_freedesktop_accounts_user_get_system_account (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_system_account (object);
}

/**
 * org_freedesktop_accounts_user_set_system_account: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.SystemAccount">"SystemAccount"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_system_account (OrgFreedesktopAccountsUser *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "system-account", value, NULL);
}

/**
 * org_freedesktop_accounts_user_get_local_account: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts-User.LocalAccount">"LocalAccount"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
org_freedesktop_accounts_user_get_local_account (OrgFreedesktopAccountsUser *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER_GET_IFACE (object)->get_local_account (object);
}

/**
 * org_freedesktop_accounts_user_set_local_account: (skip)
 * @object: A #OrgFreedesktopAccountsUser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts-User.LocalAccount">"LocalAccount"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_user_set_local_account (OrgFreedesktopAccountsUser *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "local-account", value, NULL);
}

/**
 * org_freedesktop_accounts_user_emit_changed:
 * @object: A #OrgFreedesktopAccountsUser.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Accounts-User.Changed">"Changed"</link> D-Bus signal.
 */
void
org_freedesktop_accounts_user_emit_changed (
    OrgFreedesktopAccountsUser *object)
{
  g_signal_emit_by_name (object, "changed");
}

/**
 * org_freedesktop_accounts_user_call_set_user_name:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetUserName">SetUserName()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_user_name_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_user_name_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_user_name (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetUserName",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_user_name_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_user_name().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_user_name().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_user_name_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_user_name_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetUserName">SetUserName()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_user_name() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_user_name_sync (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetUserName",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_real_name:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetRealName">SetRealName()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_real_name_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_real_name_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_real_name (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetRealName",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_real_name_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_real_name().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_real_name().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_real_name_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_real_name_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetRealName">SetRealName()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_real_name() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_real_name_sync (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetRealName",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_email:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_email: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetEmail">SetEmail()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_email_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_email_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_email (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_email,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetEmail",
    g_variant_new ("(s)",
                   arg_email),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_email_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_email().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_email().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_email_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_email_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_email: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetEmail">SetEmail()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_email() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_email_sync (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_email,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetEmail",
    g_variant_new ("(s)",
                   arg_email),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_language:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_language: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLanguage">SetLanguage()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_language_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_language_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_language (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_language,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetLanguage",
    g_variant_new ("(s)",
                   arg_language),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_language_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_language().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_language().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_language_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_language_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_language: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLanguage">SetLanguage()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_language() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_language_sync (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_language,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetLanguage",
    g_variant_new ("(s)",
                   arg_language),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_xsession:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_x_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetXSession">SetXSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_xsession_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_xsession_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_xsession (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_x_session,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetXSession",
    g_variant_new ("(s)",
                   arg_x_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_xsession_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_xsession().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_xsession().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_xsession_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_xsession_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_x_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetXSession">SetXSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_xsession() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_xsession_sync (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_x_session,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetXSession",
    g_variant_new ("(s)",
                   arg_x_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_location:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_location: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLocation">SetLocation()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_location_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_location_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_location (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_location,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetLocation",
    g_variant_new ("(s)",
                   arg_location),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_location_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_location().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_location().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_location_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_location_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_location: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLocation">SetLocation()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_location() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_location_sync (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_location,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetLocation",
    g_variant_new ("(s)",
                   arg_location),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_home_directory:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_homedir: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetHomeDirectory">SetHomeDirectory()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_home_directory_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_home_directory_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_home_directory (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_homedir,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetHomeDirectory",
    g_variant_new ("(s)",
                   arg_homedir),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_home_directory_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_home_directory().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_home_directory().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_home_directory_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_home_directory_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_homedir: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetHomeDirectory">SetHomeDirectory()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_home_directory() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_home_directory_sync (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_homedir,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetHomeDirectory",
    g_variant_new ("(s)",
                   arg_homedir),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_shell:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_shell: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetShell">SetShell()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_shell_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_shell_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_shell (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_shell,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetShell",
    g_variant_new ("(s)",
                   arg_shell),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_shell_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_shell().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_shell().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_shell_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_shell_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_shell: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetShell">SetShell()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_shell() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_shell_sync (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_shell,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetShell",
    g_variant_new ("(s)",
                   arg_shell),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_icon_file:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetIconFile">SetIconFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_icon_file_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_icon_file_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_icon_file (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetIconFile",
    g_variant_new ("(s)",
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_icon_file_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_icon_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_icon_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_icon_file_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_icon_file_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetIconFile">SetIconFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_icon_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_icon_file_sync (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetIconFile",
    g_variant_new ("(s)",
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_locked:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_locked: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLocked">SetLocked()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_locked_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_locked_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_locked (
    OrgFreedesktopAccountsUser *proxy,
    gboolean arg_locked,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetLocked",
    g_variant_new ("(b)",
                   arg_locked),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_locked_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_locked().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_locked().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_locked_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_locked_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_locked: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLocked">SetLocked()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_locked() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_locked_sync (
    OrgFreedesktopAccountsUser *proxy,
    gboolean arg_locked,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetLocked",
    g_variant_new ("(b)",
                   arg_locked),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_account_type:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_accountType: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetAccountType">SetAccountType()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_account_type_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_account_type_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_account_type (
    OrgFreedesktopAccountsUser *proxy,
    gint arg_accountType,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetAccountType",
    g_variant_new ("(i)",
                   arg_accountType),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_account_type_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_account_type().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_account_type().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_account_type_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_account_type_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_accountType: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetAccountType">SetAccountType()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_account_type() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_account_type_sync (
    OrgFreedesktopAccountsUser *proxy,
    gint arg_accountType,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetAccountType",
    g_variant_new ("(i)",
                   arg_accountType),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_password_mode:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPasswordMode">SetPasswordMode()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_password_mode_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_password_mode_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_password_mode (
    OrgFreedesktopAccountsUser *proxy,
    gint arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPasswordMode",
    g_variant_new ("(i)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_password_mode_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_password_mode().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_password_mode().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_password_mode_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_password_mode_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPasswordMode">SetPasswordMode()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_password_mode() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_password_mode_sync (
    OrgFreedesktopAccountsUser *proxy,
    gint arg_mode,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPasswordMode",
    g_variant_new ("(i)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_password:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_password: Argument to pass with the method invocation.
 * @arg_hint: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPassword">SetPassword()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_password_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_password_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_password (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_password,
    const gchar *arg_hint,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPassword",
    g_variant_new ("(ss)",
                   arg_password,
                   arg_hint),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_password_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_password().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_password().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_password_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_password_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_password: Argument to pass with the method invocation.
 * @arg_hint: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPassword">SetPassword()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_password() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_password_sync (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_password,
    const gchar *arg_hint,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPassword",
    g_variant_new ("(ss)",
                   arg_password,
                   arg_hint),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_password_hint:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_hint: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPasswordHint">SetPasswordHint()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_password_hint_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_password_hint_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_password_hint (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_hint,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPasswordHint",
    g_variant_new ("(s)",
                   arg_hint),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_password_hint_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_password_hint().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_password_hint().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_password_hint_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_password_hint_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_hint: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPasswordHint">SetPasswordHint()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_password_hint() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_password_hint_sync (
    OrgFreedesktopAccountsUser *proxy,
    const gchar *arg_hint,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPasswordHint",
    g_variant_new ("(s)",
                   arg_hint),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_automatic_login:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_enabled: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetAutomaticLogin">SetAutomaticLogin()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_call_set_automatic_login_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_call_set_automatic_login_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_user_call_set_automatic_login (
    OrgFreedesktopAccountsUser *proxy,
    gboolean arg_enabled,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetAutomaticLogin",
    g_variant_new ("(b)",
                   arg_enabled),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_user_call_set_automatic_login_finish:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_call_set_automatic_login().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_user_call_set_automatic_login().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_automatic_login_finish (
    OrgFreedesktopAccountsUser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_call_set_automatic_login_sync:
 * @proxy: A #OrgFreedesktopAccountsUserProxy.
 * @arg_enabled: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetAutomaticLogin">SetAutomaticLogin()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_call_set_automatic_login() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_user_call_set_automatic_login_sync (
    OrgFreedesktopAccountsUser *proxy,
    gboolean arg_enabled,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetAutomaticLogin",
    g_variant_new ("(b)",
                   arg_enabled),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_user_complete_set_user_name:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetUserName">SetUserName()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_user_name (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_real_name:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetRealName">SetRealName()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_real_name (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_email:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetEmail">SetEmail()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_email (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_language:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLanguage">SetLanguage()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_language (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_xsession:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetXSession">SetXSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_xsession (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_location:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLocation">SetLocation()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_location (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_home_directory:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetHomeDirectory">SetHomeDirectory()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_home_directory (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_shell:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetShell">SetShell()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_shell (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_icon_file:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetIconFile">SetIconFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_icon_file (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_locked:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetLocked">SetLocked()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_locked (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_account_type:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetAccountType">SetAccountType()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_account_type (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_password_mode:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPasswordMode">SetPasswordMode()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_password_mode (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_password:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPassword">SetPassword()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_password (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_password_hint:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetPasswordHint">SetPasswordHint()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_password_hint (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_user_complete_set_automatic_login:
 * @object: A #OrgFreedesktopAccountsUser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts-User.SetAutomaticLogin">SetAutomaticLogin()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_user_complete_set_automatic_login (
    OrgFreedesktopAccountsUser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopAccountsUserProxy:
 *
 * The #OrgFreedesktopAccountsUserProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopAccountsUserProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopAccountsUserProxy.
 */

struct _OrgFreedesktopAccountsUserProxyPrivate
{
  GData *qdata;
};

static void org_freedesktop_accounts_user_proxy_iface_init (OrgFreedesktopAccountsUserIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopAccountsUserProxy, org_freedesktop_accounts_user_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgFreedesktopAccountsUserProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER, org_freedesktop_accounts_user_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopAccountsUserProxy, org_freedesktop_accounts_user_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER, org_freedesktop_accounts_user_proxy_iface_init))

#endif
static void
org_freedesktop_accounts_user_proxy_finalize (GObject *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_freedesktop_accounts_user_proxy_parent_class)->finalize (object);
}

static void
org_freedesktop_accounts_user_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 20);
  info = (const _ExtendedGDBusPropertyInfo *) _org_freedesktop_accounts_user_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
org_freedesktop_accounts_user_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.Accounts.User: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
org_freedesktop_accounts_user_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 20);
  info = (const _ExtendedGDBusPropertyInfo *) _org_freedesktop_accounts_user_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.Accounts.User", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) org_freedesktop_accounts_user_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
org_freedesktop_accounts_user_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_freedesktop_accounts_user_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_freedesktop_accounts_user_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_accounts_user_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_accounts_user_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint64 
org_freedesktop_accounts_user_proxy_get_uid (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Uid");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
org_freedesktop_accounts_user_proxy_get_user_name (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UserName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
org_freedesktop_accounts_user_proxy_get_real_name (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RealName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
org_freedesktop_accounts_user_proxy_get_account_type (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AccountType");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
org_freedesktop_accounts_user_proxy_get_home_directory (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HomeDirectory");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
org_freedesktop_accounts_user_proxy_get_shell (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Shell");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
org_freedesktop_accounts_user_proxy_get_email (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Email");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
org_freedesktop_accounts_user_proxy_get_language (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Language");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
org_freedesktop_accounts_user_proxy_get_xsession (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "XSession");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
org_freedesktop_accounts_user_proxy_get_location (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Location");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
org_freedesktop_accounts_user_proxy_get_login_frequency (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoginFrequency");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint64 
org_freedesktop_accounts_user_proxy_get_login_time (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  gint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoginTime");
  if (variant != NULL)
    {
      value = g_variant_get_int64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
org_freedesktop_accounts_user_proxy_get_login_history (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoginHistory");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
org_freedesktop_accounts_user_proxy_get_icon_file (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IconFile");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
org_freedesktop_accounts_user_proxy_get_locked (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Locked");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
org_freedesktop_accounts_user_proxy_get_password_mode (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PasswordMode");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
org_freedesktop_accounts_user_proxy_get_password_hint (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PasswordHint");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
org_freedesktop_accounts_user_proxy_get_automatic_login (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AutomaticLogin");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
org_freedesktop_accounts_user_proxy_get_system_account (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SystemAccount");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
org_freedesktop_accounts_user_proxy_get_local_account (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LocalAccount");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
org_freedesktop_accounts_user_proxy_init (OrgFreedesktopAccountsUserProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_freedesktop_accounts_user_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY, OrgFreedesktopAccountsUserProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_freedesktop_accounts_user_interface_info ());
}

static void
org_freedesktop_accounts_user_proxy_class_init (OrgFreedesktopAccountsUserProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_freedesktop_accounts_user_proxy_finalize;
  gobject_class->get_property = org_freedesktop_accounts_user_proxy_get_property;
  gobject_class->set_property = org_freedesktop_accounts_user_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_freedesktop_accounts_user_proxy_g_signal;
  proxy_class->g_properties_changed = org_freedesktop_accounts_user_proxy_g_properties_changed;

  org_freedesktop_accounts_user_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopAccountsUserProxyPrivate));
#endif
}

static void
org_freedesktop_accounts_user_proxy_iface_init (OrgFreedesktopAccountsUserIface *iface)
{
  iface->get_uid = org_freedesktop_accounts_user_proxy_get_uid;
  iface->get_user_name = org_freedesktop_accounts_user_proxy_get_user_name;
  iface->get_real_name = org_freedesktop_accounts_user_proxy_get_real_name;
  iface->get_account_type = org_freedesktop_accounts_user_proxy_get_account_type;
  iface->get_home_directory = org_freedesktop_accounts_user_proxy_get_home_directory;
  iface->get_shell = org_freedesktop_accounts_user_proxy_get_shell;
  iface->get_email = org_freedesktop_accounts_user_proxy_get_email;
  iface->get_language = org_freedesktop_accounts_user_proxy_get_language;
  iface->get_xsession = org_freedesktop_accounts_user_proxy_get_xsession;
  iface->get_location = org_freedesktop_accounts_user_proxy_get_location;
  iface->get_login_frequency = org_freedesktop_accounts_user_proxy_get_login_frequency;
  iface->get_login_time = org_freedesktop_accounts_user_proxy_get_login_time;
  iface->get_login_history = org_freedesktop_accounts_user_proxy_get_login_history;
  iface->get_icon_file = org_freedesktop_accounts_user_proxy_get_icon_file;
  iface->get_locked = org_freedesktop_accounts_user_proxy_get_locked;
  iface->get_password_mode = org_freedesktop_accounts_user_proxy_get_password_mode;
  iface->get_password_hint = org_freedesktop_accounts_user_proxy_get_password_hint;
  iface->get_automatic_login = org_freedesktop_accounts_user_proxy_get_automatic_login;
  iface->get_system_account = org_freedesktop_accounts_user_proxy_get_system_account;
  iface->get_local_account = org_freedesktop_accounts_user_proxy_get_local_account;
}

/**
 * org_freedesktop_accounts_user_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Accounts-User.top_of_page">org.freedesktop.Accounts.User</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_proxy_new_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_accounts_user_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Accounts.User", NULL);
}

/**
 * org_freedesktop_accounts_user_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_accounts_user_proxy_new().
 *
 * Returns: (transfer full) (type OrgFreedesktopAccountsUserProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopAccountsUser *
org_freedesktop_accounts_user_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_ACCOUNTS_USER (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_accounts_user_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Accounts-User.top_of_page">org.freedesktop.Accounts.User</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopAccountsUserProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopAccountsUser *
org_freedesktop_accounts_user_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Accounts.User", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_ACCOUNTS_USER (ret);
  else
    return NULL;
}


/**
 * org_freedesktop_accounts_user_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_freedesktop_accounts_user_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_user_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_user_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_accounts_user_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Accounts.User", NULL);
}

/**
 * org_freedesktop_accounts_user_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_user_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_accounts_user_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgFreedesktopAccountsUserProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopAccountsUser *
org_freedesktop_accounts_user_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_ACCOUNTS_USER (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_accounts_user_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_freedesktop_accounts_user_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_user_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopAccountsUserProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopAccountsUser *
org_freedesktop_accounts_user_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Accounts.User", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_ACCOUNTS_USER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopAccountsUserSkeleton:
 *
 * The #OrgFreedesktopAccountsUserSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopAccountsUserSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopAccountsUserSkeleton.
 */

struct _OrgFreedesktopAccountsUserSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_freedesktop_accounts_user_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_freedesktop_accounts_user_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_accounts_user_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_freedesktop_accounts_user_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_accounts_user_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_freedesktop_accounts_user_skeleton_vtable =
{
  _org_freedesktop_accounts_user_skeleton_handle_method_call,
  _org_freedesktop_accounts_user_skeleton_handle_get_property,
  _org_freedesktop_accounts_user_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_freedesktop_accounts_user_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_freedesktop_accounts_user_interface_info ();
}

static GDBusInterfaceVTable *
org_freedesktop_accounts_user_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_freedesktop_accounts_user_skeleton_vtable;
}

static GVariant *
org_freedesktop_accounts_user_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_freedesktop_accounts_user_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_freedesktop_accounts_user_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_freedesktop_accounts_user_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_freedesktop_accounts_user_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Accounts.User", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _org_freedesktop_accounts_user_emit_changed (gpointer user_data);

static void
org_freedesktop_accounts_user_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _org_freedesktop_accounts_user_emit_changed (skeleton);
}

static void
_org_freedesktop_accounts_user_on_signal_changed (
    OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Accounts.User", "Changed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_freedesktop_accounts_user_skeleton_iface_init (OrgFreedesktopAccountsUserIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopAccountsUserSkeleton, org_freedesktop_accounts_user_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgFreedesktopAccountsUserSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER, org_freedesktop_accounts_user_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopAccountsUserSkeleton, org_freedesktop_accounts_user_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER, org_freedesktop_accounts_user_skeleton_iface_init))

#endif
static void
org_freedesktop_accounts_user_skeleton_finalize (GObject *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  guint n;
  for (n = 0; n < 20; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_freedesktop_accounts_user_skeleton_parent_class)->finalize (object);
}

static void
org_freedesktop_accounts_user_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 20);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_org_freedesktop_accounts_user_emit_changed (gpointer user_data)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.Accounts.User",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_org_freedesktop_accounts_user_schedule_emit_changed (OrgFreedesktopAccountsUserSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
org_freedesktop_accounts_user_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _org_freedesktop_accounts_user_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _org_freedesktop_accounts_user_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
org_freedesktop_accounts_user_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 20);
  info = (const _ExtendedGDBusPropertyInfo *) _org_freedesktop_accounts_user_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _org_freedesktop_accounts_user_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
org_freedesktop_accounts_user_skeleton_init (OrgFreedesktopAccountsUserSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_freedesktop_accounts_user_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON, OrgFreedesktopAccountsUserSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 20);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_INT64);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[16], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[17], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[18], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[19], G_TYPE_BOOLEAN);
}

static guint64 
org_freedesktop_accounts_user_skeleton_get_uid (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
org_freedesktop_accounts_user_skeleton_get_user_name (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
org_freedesktop_accounts_user_skeleton_get_real_name (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
org_freedesktop_accounts_user_skeleton_get_account_type (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
org_freedesktop_accounts_user_skeleton_get_home_directory (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
org_freedesktop_accounts_user_skeleton_get_shell (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
org_freedesktop_accounts_user_skeleton_get_email (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
org_freedesktop_accounts_user_skeleton_get_language (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
org_freedesktop_accounts_user_skeleton_get_xsession (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
org_freedesktop_accounts_user_skeleton_get_location (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
org_freedesktop_accounts_user_skeleton_get_login_frequency (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint64 
org_freedesktop_accounts_user_skeleton_get_login_time (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  gint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int64 (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
org_freedesktop_accounts_user_skeleton_get_login_history (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
org_freedesktop_accounts_user_skeleton_get_icon_file (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
org_freedesktop_accounts_user_skeleton_get_locked (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
org_freedesktop_accounts_user_skeleton_get_password_mode (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[15]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
org_freedesktop_accounts_user_skeleton_get_password_hint (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[16]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
org_freedesktop_accounts_user_skeleton_get_automatic_login (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[17]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
org_freedesktop_accounts_user_skeleton_get_system_account (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[18]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
org_freedesktop_accounts_user_skeleton_get_local_account (OrgFreedesktopAccountsUser *object)
{
  OrgFreedesktopAccountsUserSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[19]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
org_freedesktop_accounts_user_skeleton_class_init (OrgFreedesktopAccountsUserSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_freedesktop_accounts_user_skeleton_finalize;
  gobject_class->get_property = org_freedesktop_accounts_user_skeleton_get_property;
  gobject_class->set_property = org_freedesktop_accounts_user_skeleton_set_property;
  gobject_class->notify       = org_freedesktop_accounts_user_skeleton_notify;


  org_freedesktop_accounts_user_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_freedesktop_accounts_user_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_freedesktop_accounts_user_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_freedesktop_accounts_user_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_freedesktop_accounts_user_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopAccountsUserSkeletonPrivate));
#endif
}

static void
org_freedesktop_accounts_user_skeleton_iface_init (OrgFreedesktopAccountsUserIface *iface)
{
  iface->changed = _org_freedesktop_accounts_user_on_signal_changed;
  iface->get_uid = org_freedesktop_accounts_user_skeleton_get_uid;
  iface->get_user_name = org_freedesktop_accounts_user_skeleton_get_user_name;
  iface->get_real_name = org_freedesktop_accounts_user_skeleton_get_real_name;
  iface->get_account_type = org_freedesktop_accounts_user_skeleton_get_account_type;
  iface->get_home_directory = org_freedesktop_accounts_user_skeleton_get_home_directory;
  iface->get_shell = org_freedesktop_accounts_user_skeleton_get_shell;
  iface->get_email = org_freedesktop_accounts_user_skeleton_get_email;
  iface->get_language = org_freedesktop_accounts_user_skeleton_get_language;
  iface->get_xsession = org_freedesktop_accounts_user_skeleton_get_xsession;
  iface->get_location = org_freedesktop_accounts_user_skeleton_get_location;
  iface->get_login_frequency = org_freedesktop_accounts_user_skeleton_get_login_frequency;
  iface->get_login_time = org_freedesktop_accounts_user_skeleton_get_login_time;
  iface->get_login_history = org_freedesktop_accounts_user_skeleton_get_login_history;
  iface->get_icon_file = org_freedesktop_accounts_user_skeleton_get_icon_file;
  iface->get_locked = org_freedesktop_accounts_user_skeleton_get_locked;
  iface->get_password_mode = org_freedesktop_accounts_user_skeleton_get_password_mode;
  iface->get_password_hint = org_freedesktop_accounts_user_skeleton_get_password_hint;
  iface->get_automatic_login = org_freedesktop_accounts_user_skeleton_get_automatic_login;
  iface->get_system_account = org_freedesktop_accounts_user_skeleton_get_system_account;
  iface->get_local_account = org_freedesktop_accounts_user_skeleton_get_local_account;
}

/**
 * org_freedesktop_accounts_user_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Accounts-User.top_of_page">org.freedesktop.Accounts.User</link>.
 *
 * Returns: (transfer full) (type OrgFreedesktopAccountsUserSkeleton): The skeleton object.
 */
OrgFreedesktopAccountsUser *
org_freedesktop_accounts_user_skeleton_new (void)
{
  return ORG_FREEDESKTOP_ACCOUNTS_USER (g_object_new (TYPE_ORG_FREEDESKTOP_ACCOUNTS_USER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Accounts
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgFreedesktopAccounts
 * @title: OrgFreedesktopAccounts
 * @short_description: Generated C code for the org.freedesktop.Accounts D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Accounts.top_of_page">org.freedesktop.Accounts</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.Accounts ---- */

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_list_cached_users_OUT_ARG_users =
{
  {
    -1,
    (gchar *) "users",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_method_info_list_cached_users_OUT_ARG_pointers[] =
{
  &_org_freedesktop_accounts_method_info_list_cached_users_OUT_ARG_users.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_method_list_cached_users_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_method_list_cached_users_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_method_list_cached_users_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_method_info_list_cached_users =
{
  {
    -1,
    (gchar *) "ListCachedUsers",
    NULL,
    (GDBusArgInfo **) &_org_freedesktop_accounts_method_info_list_cached_users_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_method_list_cached_users_annotation_info_pointers
  },
  "handle-list-cached-users",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_find_user_by_id_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_method_info_find_user_by_id_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_method_info_find_user_by_id_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_find_user_by_id_OUT_ARG_user =
{
  {
    -1,
    (gchar *) "user",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_method_info_find_user_by_id_OUT_ARG_pointers[] =
{
  &_org_freedesktop_accounts_method_info_find_user_by_id_OUT_ARG_user.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_method_find_user_by_id_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_method_find_user_by_id_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_method_find_user_by_id_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_method_info_find_user_by_id =
{
  {
    -1,
    (gchar *) "FindUserById",
    (GDBusArgInfo **) &_org_freedesktop_accounts_method_info_find_user_by_id_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_freedesktop_accounts_method_info_find_user_by_id_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_method_find_user_by_id_annotation_info_pointers
  },
  "handle-find-user-by-id",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_find_user_by_name_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_method_info_find_user_by_name_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_method_info_find_user_by_name_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_find_user_by_name_OUT_ARG_user =
{
  {
    -1,
    (gchar *) "user",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_method_info_find_user_by_name_OUT_ARG_pointers[] =
{
  &_org_freedesktop_accounts_method_info_find_user_by_name_OUT_ARG_user.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_method_find_user_by_name_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_method_find_user_by_name_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_method_find_user_by_name_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_method_info_find_user_by_name =
{
  {
    -1,
    (gchar *) "FindUserByName",
    (GDBusArgInfo **) &_org_freedesktop_accounts_method_info_find_user_by_name_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_freedesktop_accounts_method_info_find_user_by_name_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_method_find_user_by_name_annotation_info_pointers
  },
  "handle-find-user-by-name",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_create_user_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_create_user_IN_ARG_fullname =
{
  {
    -1,
    (gchar *) "fullname",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_create_user_IN_ARG_accountType =
{
  {
    -1,
    (gchar *) "accountType",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_method_info_create_user_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_method_info_create_user_IN_ARG_name.parent_struct,
  &_org_freedesktop_accounts_method_info_create_user_IN_ARG_fullname.parent_struct,
  &_org_freedesktop_accounts_method_info_create_user_IN_ARG_accountType.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_create_user_OUT_ARG_user =
{
  {
    -1,
    (gchar *) "user",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_method_info_create_user_OUT_ARG_pointers[] =
{
  &_org_freedesktop_accounts_method_info_create_user_OUT_ARG_user.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_method_create_user_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_method_create_user_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_method_create_user_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_method_create_user_annotation_info_0,
  &_org_freedesktop_accounts_method_create_user_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_method_info_create_user =
{
  {
    -1,
    (gchar *) "CreateUser",
    (GDBusArgInfo **) &_org_freedesktop_accounts_method_info_create_user_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_freedesktop_accounts_method_info_create_user_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_method_create_user_annotation_info_pointers
  },
  "handle-create-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_cache_user_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_method_info_cache_user_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_method_info_cache_user_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_cache_user_OUT_ARG_user =
{
  {
    -1,
    (gchar *) "user",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_method_info_cache_user_OUT_ARG_pointers[] =
{
  &_org_freedesktop_accounts_method_info_cache_user_OUT_ARG_user.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_method_cache_user_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_method_cache_user_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_method_cache_user_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_method_info_cache_user =
{
  {
    -1,
    (gchar *) "CacheUser",
    (GDBusArgInfo **) &_org_freedesktop_accounts_method_info_cache_user_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_freedesktop_accounts_method_info_cache_user_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_method_cache_user_annotation_info_pointers
  },
  "handle-cache-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_uncache_user_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_method_info_uncache_user_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_method_info_uncache_user_IN_ARG_name.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_method_uncache_user_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_method_uncache_user_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_method_uncache_user_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_method_info_uncache_user =
{
  {
    -1,
    (gchar *) "UncacheUser",
    (GDBusArgInfo **) &_org_freedesktop_accounts_method_info_uncache_user_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_method_uncache_user_annotation_info_pointers
  },
  "handle-uncache-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_delete_user_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_method_info_delete_user_IN_ARG_removeFiles =
{
  {
    -1,
    (gchar *) "removeFiles",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_method_info_delete_user_IN_ARG_pointers[] =
{
  &_org_freedesktop_accounts_method_info_delete_user_IN_ARG_id.parent_struct,
  &_org_freedesktop_accounts_method_info_delete_user_IN_ARG_removeFiles.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _org_freedesktop_accounts_method_delete_user_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _org_freedesktop_accounts_method_delete_user_annotation_info_pointers[] =
{
  &_org_freedesktop_accounts_method_delete_user_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_accounts_method_info_delete_user =
{
  {
    -1,
    (gchar *) "DeleteUser",
    (GDBusArgInfo **) &_org_freedesktop_accounts_method_info_delete_user_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_org_freedesktop_accounts_method_delete_user_annotation_info_pointers
  },
  "handle-delete-user",
  FALSE
};

static const GDBusMethodInfo * const _org_freedesktop_accounts_method_info_pointers[] =
{
  &_org_freedesktop_accounts_method_info_list_cached_users.parent_struct,
  &_org_freedesktop_accounts_method_info_find_user_by_id.parent_struct,
  &_org_freedesktop_accounts_method_info_find_user_by_name.parent_struct,
  &_org_freedesktop_accounts_method_info_create_user.parent_struct,
  &_org_freedesktop_accounts_method_info_cache_user.parent_struct,
  &_org_freedesktop_accounts_method_info_uncache_user.parent_struct,
  &_org_freedesktop_accounts_method_info_delete_user.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_signal_info_user_added_ARG_user =
{
  {
    -1,
    (gchar *) "user",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_signal_info_user_added_ARG_pointers[] =
{
  &_org_freedesktop_accounts_signal_info_user_added_ARG_user.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_freedesktop_accounts_signal_info_user_added =
{
  {
    -1,
    (gchar *) "UserAdded",
    (GDBusArgInfo **) &_org_freedesktop_accounts_signal_info_user_added_ARG_pointers,
    NULL
  },
  "user-added"
};

static const _ExtendedGDBusArgInfo _org_freedesktop_accounts_signal_info_user_deleted_ARG_user =
{
  {
    -1,
    (gchar *) "user",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_accounts_signal_info_user_deleted_ARG_pointers[] =
{
  &_org_freedesktop_accounts_signal_info_user_deleted_ARG_user.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_freedesktop_accounts_signal_info_user_deleted =
{
  {
    -1,
    (gchar *) "UserDeleted",
    (GDBusArgInfo **) &_org_freedesktop_accounts_signal_info_user_deleted_ARG_pointers,
    NULL
  },
  "user-deleted"
};

static const GDBusSignalInfo * const _org_freedesktop_accounts_signal_info_pointers[] =
{
  &_org_freedesktop_accounts_signal_info_user_added.parent_struct,
  &_org_freedesktop_accounts_signal_info_user_deleted.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _org_freedesktop_accounts_property_info_daemon_version =
{
  {
    -1,
    (gchar *) "DaemonVersion",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "daemon-version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _org_freedesktop_accounts_property_info_pointers[] =
{
  &_org_freedesktop_accounts_property_info_daemon_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_freedesktop_accounts_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Accounts",
    (GDBusMethodInfo **) &_org_freedesktop_accounts_method_info_pointers,
    (GDBusSignalInfo **) &_org_freedesktop_accounts_signal_info_pointers,
    (GDBusPropertyInfo **) &_org_freedesktop_accounts_property_info_pointers,
    NULL
  },
  "org-freedesktop-accounts",
};


/**
 * org_freedesktop_accounts_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Accounts.top_of_page">org.freedesktop.Accounts</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_freedesktop_accounts_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_freedesktop_accounts_interface_info.parent_struct;
}

/**
 * org_freedesktop_accounts_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgFreedesktopAccounts interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_freedesktop_accounts_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "daemon-version");
  return property_id_begin - 1;
}



/**
 * OrgFreedesktopAccounts:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Accounts.top_of_page">org.freedesktop.Accounts</link>.
 */

/**
 * OrgFreedesktopAccountsIface:
 * @parent_iface: The parent interface.
 * @handle_cache_user: Handler for the #OrgFreedesktopAccounts::handle-cache-user signal.
 * @handle_create_user: Handler for the #OrgFreedesktopAccounts::handle-create-user signal.
 * @handle_delete_user: Handler for the #OrgFreedesktopAccounts::handle-delete-user signal.
 * @handle_find_user_by_id: Handler for the #OrgFreedesktopAccounts::handle-find-user-by-id signal.
 * @handle_find_user_by_name: Handler for the #OrgFreedesktopAccounts::handle-find-user-by-name signal.
 * @handle_list_cached_users: Handler for the #OrgFreedesktopAccounts::handle-list-cached-users signal.
 * @handle_uncache_user: Handler for the #OrgFreedesktopAccounts::handle-uncache-user signal.
 * @get_daemon_version: Getter for the #OrgFreedesktopAccounts:daemon-version property.
 * @user_added: Handler for the #OrgFreedesktopAccounts::user-added signal.
 * @user_deleted: Handler for the #OrgFreedesktopAccounts::user-deleted signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Accounts.top_of_page">org.freedesktop.Accounts</link>.
 */

typedef OrgFreedesktopAccountsIface OrgFreedesktopAccountsInterface;
G_DEFINE_INTERFACE (OrgFreedesktopAccounts, org_freedesktop_accounts, G_TYPE_OBJECT)

static void
org_freedesktop_accounts_default_init (OrgFreedesktopAccountsIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgFreedesktopAccounts::handle-list-cached-users:
   * @object: A #OrgFreedesktopAccounts.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts.ListCachedUsers">ListCachedUsers()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_complete_list_cached_users() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-cached-users",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsIface, handle_list_cached_users),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgFreedesktopAccounts::handle-find-user-by-id:
   * @object: A #OrgFreedesktopAccounts.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts.FindUserById">FindUserById()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_complete_find_user_by_id() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-find-user-by-id",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsIface, handle_find_user_by_id),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT64);

  /**
   * OrgFreedesktopAccounts::handle-find-user-by-name:
   * @object: A #OrgFreedesktopAccounts.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts.FindUserByName">FindUserByName()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_complete_find_user_by_name() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-find-user-by-name",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsIface, handle_find_user_by_name),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccounts::handle-create-user:
   * @object: A #OrgFreedesktopAccounts.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_fullname: Argument passed by remote caller.
   * @arg_accountType: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts.CreateUser">CreateUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_complete_create_user() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsIface, handle_create_user),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT);

  /**
   * OrgFreedesktopAccounts::handle-cache-user:
   * @object: A #OrgFreedesktopAccounts.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts.CacheUser">CacheUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_complete_cache_user() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cache-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsIface, handle_cache_user),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccounts::handle-uncache-user:
   * @object: A #OrgFreedesktopAccounts.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts.UncacheUser">UncacheUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_complete_uncache_user() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-uncache-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsIface, handle_uncache_user),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccounts::handle-delete-user:
   * @object: A #OrgFreedesktopAccounts.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_removeFiles: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Accounts.DeleteUser">DeleteUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_accounts_complete_delete_user() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsIface, handle_delete_user),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT64, G_TYPE_BOOLEAN);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgFreedesktopAccounts::user-added:
   * @object: A #OrgFreedesktopAccounts.
   * @arg_user: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Accounts.UserAdded">"UserAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("user-added",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsIface, user_added),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * OrgFreedesktopAccounts::user-deleted:
   * @object: A #OrgFreedesktopAccounts.
   * @arg_user: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Accounts.UserDeleted">"UserDeleted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("user-deleted",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopAccountsIface, user_deleted),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * OrgFreedesktopAccounts:daemon-version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Accounts.DaemonVersion">"DaemonVersion"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("daemon-version", "DaemonVersion", "DaemonVersion", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * org_freedesktop_accounts_get_daemon_version: (skip)
 * @object: A #OrgFreedesktopAccounts.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Accounts.DaemonVersion">"DaemonVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_freedesktop_accounts_dup_daemon_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_freedesktop_accounts_get_daemon_version (OrgFreedesktopAccounts *object)
{
  return ORG_FREEDESKTOP_ACCOUNTS_GET_IFACE (object)->get_daemon_version (object);
}

/**
 * org_freedesktop_accounts_dup_daemon_version: (skip)
 * @object: A #OrgFreedesktopAccounts.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Accounts.DaemonVersion">"DaemonVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_freedesktop_accounts_dup_daemon_version (OrgFreedesktopAccounts *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "daemon-version", &value, NULL);
  return value;
}

/**
 * org_freedesktop_accounts_set_daemon_version: (skip)
 * @object: A #OrgFreedesktopAccounts.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Accounts.DaemonVersion">"DaemonVersion"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_freedesktop_accounts_set_daemon_version (OrgFreedesktopAccounts *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "daemon-version", value, NULL);
}

/**
 * org_freedesktop_accounts_emit_user_added:
 * @object: A #OrgFreedesktopAccounts.
 * @arg_user: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Accounts.UserAdded">"UserAdded"</link> D-Bus signal.
 */
void
org_freedesktop_accounts_emit_user_added (
    OrgFreedesktopAccounts *object,
    const gchar *arg_user)
{
  g_signal_emit_by_name (object, "user-added", arg_user);
}

/**
 * org_freedesktop_accounts_emit_user_deleted:
 * @object: A #OrgFreedesktopAccounts.
 * @arg_user: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Accounts.UserDeleted">"UserDeleted"</link> D-Bus signal.
 */
void
org_freedesktop_accounts_emit_user_deleted (
    OrgFreedesktopAccounts *object,
    const gchar *arg_user)
{
  g_signal_emit_by_name (object, "user-deleted", arg_user);
}

/**
 * org_freedesktop_accounts_call_list_cached_users:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.ListCachedUsers">ListCachedUsers()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_call_list_cached_users_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_call_list_cached_users_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_call_list_cached_users (
    OrgFreedesktopAccounts *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListCachedUsers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_call_list_cached_users_finish:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @out_users: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_call_list_cached_users().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_call_list_cached_users().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_list_cached_users_finish (
    OrgFreedesktopAccounts *proxy,
    gchar ***out_users,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_users);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_list_cached_users_sync:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @out_users: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.ListCachedUsers">ListCachedUsers()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_call_list_cached_users() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_list_cached_users_sync (
    OrgFreedesktopAccounts *proxy,
    gchar ***out_users,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListCachedUsers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_users);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_find_user_by_id:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.FindUserById">FindUserById()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_call_find_user_by_id_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_call_find_user_by_id_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_call_find_user_by_id (
    OrgFreedesktopAccounts *proxy,
    gint64 arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FindUserById",
    g_variant_new ("(x)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_call_find_user_by_id_finish:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @out_user: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_call_find_user_by_id().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_call_find_user_by_id().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_find_user_by_id_finish (
    OrgFreedesktopAccounts *proxy,
    gchar **out_user,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_user);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_find_user_by_id_sync:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @out_user: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.FindUserById">FindUserById()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_call_find_user_by_id() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_find_user_by_id_sync (
    OrgFreedesktopAccounts *proxy,
    gint64 arg_id,
    gchar **out_user,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FindUserById",
    g_variant_new ("(x)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_user);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_find_user_by_name:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.FindUserByName">FindUserByName()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_call_find_user_by_name_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_call_find_user_by_name_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_call_find_user_by_name (
    OrgFreedesktopAccounts *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FindUserByName",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_call_find_user_by_name_finish:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @out_user: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_call_find_user_by_name().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_call_find_user_by_name().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_find_user_by_name_finish (
    OrgFreedesktopAccounts *proxy,
    gchar **out_user,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_user);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_find_user_by_name_sync:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @out_user: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.FindUserByName">FindUserByName()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_call_find_user_by_name() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_find_user_by_name_sync (
    OrgFreedesktopAccounts *proxy,
    const gchar *arg_name,
    gchar **out_user,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FindUserByName",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_user);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_create_user:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_fullname: Argument to pass with the method invocation.
 * @arg_accountType: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.CreateUser">CreateUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_call_create_user_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_call_create_user_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_call_create_user (
    OrgFreedesktopAccounts *proxy,
    const gchar *arg_name,
    const gchar *arg_fullname,
    gint arg_accountType,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateUser",
    g_variant_new ("(ssi)",
                   arg_name,
                   arg_fullname,
                   arg_accountType),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_call_create_user_finish:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @out_user: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_call_create_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_call_create_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_create_user_finish (
    OrgFreedesktopAccounts *proxy,
    gchar **out_user,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_user);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_create_user_sync:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_fullname: Argument to pass with the method invocation.
 * @arg_accountType: Argument to pass with the method invocation.
 * @out_user: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.CreateUser">CreateUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_call_create_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_create_user_sync (
    OrgFreedesktopAccounts *proxy,
    const gchar *arg_name,
    const gchar *arg_fullname,
    gint arg_accountType,
    gchar **out_user,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateUser",
    g_variant_new ("(ssi)",
                   arg_name,
                   arg_fullname,
                   arg_accountType),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_user);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_cache_user:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.CacheUser">CacheUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_call_cache_user_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_call_cache_user_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_call_cache_user (
    OrgFreedesktopAccounts *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CacheUser",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_call_cache_user_finish:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @out_user: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_call_cache_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_call_cache_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_cache_user_finish (
    OrgFreedesktopAccounts *proxy,
    gchar **out_user,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_user);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_cache_user_sync:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @out_user: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.CacheUser">CacheUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_call_cache_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_cache_user_sync (
    OrgFreedesktopAccounts *proxy,
    const gchar *arg_name,
    gchar **out_user,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CacheUser",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_user);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_uncache_user:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.UncacheUser">UncacheUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_call_uncache_user_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_call_uncache_user_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_call_uncache_user (
    OrgFreedesktopAccounts *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UncacheUser",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_call_uncache_user_finish:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_call_uncache_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_call_uncache_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_uncache_user_finish (
    OrgFreedesktopAccounts *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_uncache_user_sync:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.UncacheUser">UncacheUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_call_uncache_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_uncache_user_sync (
    OrgFreedesktopAccounts *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UncacheUser",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_delete_user:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_removeFiles: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.DeleteUser">DeleteUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_call_delete_user_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_call_delete_user_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_accounts_call_delete_user (
    OrgFreedesktopAccounts *proxy,
    gint64 arg_id,
    gboolean arg_removeFiles,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeleteUser",
    g_variant_new ("(xb)",
                   arg_id,
                   arg_removeFiles),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_accounts_call_delete_user_finish:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_call_delete_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_accounts_call_delete_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_delete_user_finish (
    OrgFreedesktopAccounts *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_call_delete_user_sync:
 * @proxy: A #OrgFreedesktopAccountsProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_removeFiles: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Accounts.DeleteUser">DeleteUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_call_delete_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_accounts_call_delete_user_sync (
    OrgFreedesktopAccounts *proxy,
    gint64 arg_id,
    gboolean arg_removeFiles,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeleteUser",
    g_variant_new ("(xb)",
                   arg_id,
                   arg_removeFiles),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_accounts_complete_list_cached_users:
 * @object: A #OrgFreedesktopAccounts.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @users: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts.ListCachedUsers">ListCachedUsers()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_complete_list_cached_users (
    OrgFreedesktopAccounts *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *users)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   users));
}

/**
 * org_freedesktop_accounts_complete_find_user_by_id:
 * @object: A #OrgFreedesktopAccounts.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @user: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts.FindUserById">FindUserById()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_complete_find_user_by_id (
    OrgFreedesktopAccounts *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *user)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   user));
}

/**
 * org_freedesktop_accounts_complete_find_user_by_name:
 * @object: A #OrgFreedesktopAccounts.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @user: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts.FindUserByName">FindUserByName()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_complete_find_user_by_name (
    OrgFreedesktopAccounts *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *user)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   user));
}

/**
 * org_freedesktop_accounts_complete_create_user:
 * @object: A #OrgFreedesktopAccounts.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @user: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts.CreateUser">CreateUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_complete_create_user (
    OrgFreedesktopAccounts *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *user)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   user));
}

/**
 * org_freedesktop_accounts_complete_cache_user:
 * @object: A #OrgFreedesktopAccounts.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @user: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts.CacheUser">CacheUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_complete_cache_user (
    OrgFreedesktopAccounts *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *user)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   user));
}

/**
 * org_freedesktop_accounts_complete_uncache_user:
 * @object: A #OrgFreedesktopAccounts.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts.UncacheUser">UncacheUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_complete_uncache_user (
    OrgFreedesktopAccounts *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_accounts_complete_delete_user:
 * @object: A #OrgFreedesktopAccounts.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Accounts.DeleteUser">DeleteUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_accounts_complete_delete_user (
    OrgFreedesktopAccounts *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopAccountsProxy:
 *
 * The #OrgFreedesktopAccountsProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopAccountsProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopAccountsProxy.
 */

struct _OrgFreedesktopAccountsProxyPrivate
{
  GData *qdata;
};

static void org_freedesktop_accounts_proxy_iface_init (OrgFreedesktopAccountsIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopAccountsProxy, org_freedesktop_accounts_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgFreedesktopAccountsProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_ACCOUNTS, org_freedesktop_accounts_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopAccountsProxy, org_freedesktop_accounts_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_ACCOUNTS, org_freedesktop_accounts_proxy_iface_init))

#endif
static void
org_freedesktop_accounts_proxy_finalize (GObject *object)
{
  OrgFreedesktopAccountsProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_freedesktop_accounts_proxy_parent_class)->finalize (object);
}

static void
org_freedesktop_accounts_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_freedesktop_accounts_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
org_freedesktop_accounts_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.Accounts: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
org_freedesktop_accounts_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_freedesktop_accounts_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.Accounts", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) org_freedesktop_accounts_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
org_freedesktop_accounts_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_freedesktop_accounts_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_FREEDESKTOP_ACCOUNTS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_ACCOUNTS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_freedesktop_accounts_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgFreedesktopAccountsProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_accounts_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_accounts_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
org_freedesktop_accounts_proxy_get_daemon_version (OrgFreedesktopAccounts *object)
{
  OrgFreedesktopAccountsProxy *proxy = ORG_FREEDESKTOP_ACCOUNTS_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DaemonVersion");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
org_freedesktop_accounts_proxy_init (OrgFreedesktopAccountsProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_freedesktop_accounts_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_FREEDESKTOP_ACCOUNTS_PROXY, OrgFreedesktopAccountsProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_freedesktop_accounts_interface_info ());
}

static void
org_freedesktop_accounts_proxy_class_init (OrgFreedesktopAccountsProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_freedesktop_accounts_proxy_finalize;
  gobject_class->get_property = org_freedesktop_accounts_proxy_get_property;
  gobject_class->set_property = org_freedesktop_accounts_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_freedesktop_accounts_proxy_g_signal;
  proxy_class->g_properties_changed = org_freedesktop_accounts_proxy_g_properties_changed;

  org_freedesktop_accounts_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopAccountsProxyPrivate));
#endif
}

static void
org_freedesktop_accounts_proxy_iface_init (OrgFreedesktopAccountsIface *iface)
{
  iface->get_daemon_version = org_freedesktop_accounts_proxy_get_daemon_version;
}

/**
 * org_freedesktop_accounts_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Accounts.top_of_page">org.freedesktop.Accounts</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_proxy_new_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_accounts_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_ACCOUNTS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Accounts", NULL);
}

/**
 * org_freedesktop_accounts_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_accounts_proxy_new().
 *
 * Returns: (transfer full) (type OrgFreedesktopAccountsProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopAccounts *
org_freedesktop_accounts_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_ACCOUNTS (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_accounts_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Accounts.top_of_page">org.freedesktop.Accounts</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopAccountsProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopAccounts *
org_freedesktop_accounts_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_ACCOUNTS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Accounts", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_ACCOUNTS (ret);
  else
    return NULL;
}


/**
 * org_freedesktop_accounts_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_freedesktop_accounts_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_accounts_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_freedesktop_accounts_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_accounts_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_ACCOUNTS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Accounts", NULL);
}

/**
 * org_freedesktop_accounts_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_accounts_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_accounts_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgFreedesktopAccountsProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopAccounts *
org_freedesktop_accounts_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_ACCOUNTS (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_accounts_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_freedesktop_accounts_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_accounts_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopAccountsProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopAccounts *
org_freedesktop_accounts_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_ACCOUNTS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Accounts", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_ACCOUNTS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopAccountsSkeleton:
 *
 * The #OrgFreedesktopAccountsSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopAccountsSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopAccountsSkeleton.
 */

struct _OrgFreedesktopAccountsSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_freedesktop_accounts_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_FREEDESKTOP_ACCOUNTS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_ACCOUNTS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_freedesktop_accounts_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_accounts_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_freedesktop_accounts_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_accounts_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_freedesktop_accounts_skeleton_vtable =
{
  _org_freedesktop_accounts_skeleton_handle_method_call,
  _org_freedesktop_accounts_skeleton_handle_get_property,
  _org_freedesktop_accounts_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_freedesktop_accounts_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_freedesktop_accounts_interface_info ();
}

static GDBusInterfaceVTable *
org_freedesktop_accounts_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_freedesktop_accounts_skeleton_vtable;
}

static GVariant *
org_freedesktop_accounts_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_freedesktop_accounts_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_freedesktop_accounts_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_freedesktop_accounts_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_freedesktop_accounts_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Accounts", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _org_freedesktop_accounts_emit_changed (gpointer user_data);

static void
org_freedesktop_accounts_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _org_freedesktop_accounts_emit_changed (skeleton);
}

static void
_org_freedesktop_accounts_on_signal_user_added (
    OrgFreedesktopAccounts *object,
    const gchar *arg_user)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_user));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Accounts", "UserAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_org_freedesktop_accounts_on_signal_user_deleted (
    OrgFreedesktopAccounts *object,
    const gchar *arg_user)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_user));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Accounts", "UserDeleted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_freedesktop_accounts_skeleton_iface_init (OrgFreedesktopAccountsIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopAccountsSkeleton, org_freedesktop_accounts_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgFreedesktopAccountsSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_ACCOUNTS, org_freedesktop_accounts_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopAccountsSkeleton, org_freedesktop_accounts_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_ACCOUNTS, org_freedesktop_accounts_skeleton_iface_init))

#endif
static void
org_freedesktop_accounts_skeleton_finalize (GObject *object)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_freedesktop_accounts_skeleton_parent_class)->finalize (object);
}

static void
org_freedesktop_accounts_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_org_freedesktop_accounts_emit_changed (gpointer user_data)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.Accounts",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_org_freedesktop_accounts_schedule_emit_changed (OrgFreedesktopAccountsSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
org_freedesktop_accounts_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _org_freedesktop_accounts_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _org_freedesktop_accounts_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
org_freedesktop_accounts_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_freedesktop_accounts_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _org_freedesktop_accounts_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
org_freedesktop_accounts_skeleton_init (OrgFreedesktopAccountsSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_freedesktop_accounts_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_FREEDESKTOP_ACCOUNTS_SKELETON, OrgFreedesktopAccountsSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
}

static const gchar *
org_freedesktop_accounts_skeleton_get_daemon_version (OrgFreedesktopAccounts *object)
{
  OrgFreedesktopAccountsSkeleton *skeleton = ORG_FREEDESKTOP_ACCOUNTS_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
org_freedesktop_accounts_skeleton_class_init (OrgFreedesktopAccountsSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_freedesktop_accounts_skeleton_finalize;
  gobject_class->get_property = org_freedesktop_accounts_skeleton_get_property;
  gobject_class->set_property = org_freedesktop_accounts_skeleton_set_property;
  gobject_class->notify       = org_freedesktop_accounts_skeleton_notify;


  org_freedesktop_accounts_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_freedesktop_accounts_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_freedesktop_accounts_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_freedesktop_accounts_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_freedesktop_accounts_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopAccountsSkeletonPrivate));
#endif
}

static void
org_freedesktop_accounts_skeleton_iface_init (OrgFreedesktopAccountsIface *iface)
{
  iface->user_added = _org_freedesktop_accounts_on_signal_user_added;
  iface->user_deleted = _org_freedesktop_accounts_on_signal_user_deleted;
  iface->get_daemon_version = org_freedesktop_accounts_skeleton_get_daemon_version;
}

/**
 * org_freedesktop_accounts_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Accounts.top_of_page">org.freedesktop.Accounts</link>.
 *
 * Returns: (transfer full) (type OrgFreedesktopAccountsSkeleton): The skeleton object.
 */
OrgFreedesktopAccounts *
org_freedesktop_accounts_skeleton_new (void)
{
  return ORG_FREEDESKTOP_ACCOUNTS (g_object_new (TYPE_ORG_FREEDESKTOP_ACCOUNTS_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.DisplayConfig
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgGnomeMutterDisplayConfig
 * @title: OrgGnomeMutterDisplayConfig
 * @short_description: Generated C code for the org.gnome.Mutter.DisplayConfig D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-DisplayConfig.top_of_page">org.gnome.Mutter.DisplayConfig</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.DisplayConfig ---- */

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_crtcs =
{
  {
    -1,
    (gchar *) "crtcs",
    (gchar *) "a(uxiiiiiuaua{sv})",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_outputs =
{
  {
    -1,
    (gchar *) "outputs",
    (gchar *) "a(uxiausauaua{sv})",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_modes =
{
  {
    -1,
    (gchar *) "modes",
    (gchar *) "a(uxuudu)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_max_screen_width =
{
  {
    -1,
    (gchar *) "max_screen_width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_max_screen_height =
{
  {
    -1,
    (gchar *) "max_screen_height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_pointers[] =
{
  &_org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_serial.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_crtcs.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_outputs.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_modes.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_max_screen_width.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_max_screen_height.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_display_config_method_info_get_resources =
{
  {
    -1,
    (gchar *) "GetResources",
    NULL,
    (GDBusArgInfo **) &_org_gnome_mutter_display_config_method_info_get_resources_OUT_ARG_pointers,
    NULL
  },
  "handle-get-resources",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_apply_configuration_IN_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_apply_configuration_IN_ARG_persistent =
{
  {
    -1,
    (gchar *) "persistent",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_apply_configuration_IN_ARG_crtcs =
{
  {
    -1,
    (gchar *) "crtcs",
    (gchar *) "a(uiiiuaua{sv})",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_apply_configuration_IN_ARG_outputs =
{
  {
    -1,
    (gchar *) "outputs",
    (gchar *) "a(ua{sv})",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_display_config_method_info_apply_configuration_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_display_config_method_info_apply_configuration_IN_ARG_serial.parent_struct,
  &_org_gnome_mutter_display_config_method_info_apply_configuration_IN_ARG_persistent.parent_struct,
  &_org_gnome_mutter_display_config_method_info_apply_configuration_IN_ARG_crtcs.parent_struct,
  &_org_gnome_mutter_display_config_method_info_apply_configuration_IN_ARG_outputs.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_display_config_method_info_apply_configuration =
{
  {
    -1,
    (gchar *) "ApplyConfiguration",
    (GDBusArgInfo **) &_org_gnome_mutter_display_config_method_info_apply_configuration_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-apply-configuration",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_change_backlight_IN_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_change_backlight_IN_ARG_output =
{
  {
    -1,
    (gchar *) "output",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_change_backlight_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_display_config_method_info_change_backlight_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_display_config_method_info_change_backlight_IN_ARG_serial.parent_struct,
  &_org_gnome_mutter_display_config_method_info_change_backlight_IN_ARG_output.parent_struct,
  &_org_gnome_mutter_display_config_method_info_change_backlight_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_change_backlight_OUT_ARG_new_value =
{
  {
    -1,
    (gchar *) "new_value",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_display_config_method_info_change_backlight_OUT_ARG_pointers[] =
{
  &_org_gnome_mutter_display_config_method_info_change_backlight_OUT_ARG_new_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_display_config_method_info_change_backlight =
{
  {
    -1,
    (gchar *) "ChangeBacklight",
    (GDBusArgInfo **) &_org_gnome_mutter_display_config_method_info_change_backlight_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_mutter_display_config_method_info_change_backlight_OUT_ARG_pointers,
    NULL
  },
  "handle-change-backlight",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_crtc_gamma_IN_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_crtc_gamma_IN_ARG_crtc =
{
  {
    -1,
    (gchar *) "crtc",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_display_config_method_info_get_crtc_gamma_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_display_config_method_info_get_crtc_gamma_IN_ARG_serial.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_crtc_gamma_IN_ARG_crtc.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_crtc_gamma_OUT_ARG_red =
{
  {
    -1,
    (gchar *) "red",
    (gchar *) "aq",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_crtc_gamma_OUT_ARG_green =
{
  {
    -1,
    (gchar *) "green",
    (gchar *) "aq",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_crtc_gamma_OUT_ARG_blue =
{
  {
    -1,
    (gchar *) "blue",
    (gchar *) "aq",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_display_config_method_info_get_crtc_gamma_OUT_ARG_pointers[] =
{
  &_org_gnome_mutter_display_config_method_info_get_crtc_gamma_OUT_ARG_red.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_crtc_gamma_OUT_ARG_green.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_crtc_gamma_OUT_ARG_blue.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_display_config_method_info_get_crtc_gamma =
{
  {
    -1,
    (gchar *) "GetCrtcGamma",
    (GDBusArgInfo **) &_org_gnome_mutter_display_config_method_info_get_crtc_gamma_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_mutter_display_config_method_info_get_crtc_gamma_OUT_ARG_pointers,
    NULL
  },
  "handle-get-crtc-gamma",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_crtc =
{
  {
    -1,
    (gchar *) "crtc",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_red =
{
  {
    -1,
    (gchar *) "red",
    (gchar *) "aq",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_green =
{
  {
    -1,
    (gchar *) "green",
    (gchar *) "aq",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_blue =
{
  {
    -1,
    (gchar *) "blue",
    (gchar *) "aq",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_serial.parent_struct,
  &_org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_crtc.parent_struct,
  &_org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_red.parent_struct,
  &_org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_green.parent_struct,
  &_org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_blue.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_display_config_method_info_set_crtc_gamma =
{
  {
    -1,
    (gchar *) "SetCrtcGamma",
    (GDBusArgInfo **) &_org_gnome_mutter_display_config_method_info_set_crtc_gamma_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-crtc-gamma",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_current_state_OUT_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_current_state_OUT_ARG_monitors =
{
  {
    -1,
    (gchar *) "monitors",
    (gchar *) "a((ssss)a(siiddada{sv})a{sv})",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_current_state_OUT_ARG_logical_monitors =
{
  {
    -1,
    (gchar *) "logical_monitors",
    (gchar *) "a(iiduba(ssss)a{sv})",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_get_current_state_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_display_config_method_info_get_current_state_OUT_ARG_pointers[] =
{
  &_org_gnome_mutter_display_config_method_info_get_current_state_OUT_ARG_serial.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_current_state_OUT_ARG_monitors.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_current_state_OUT_ARG_logical_monitors.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_current_state_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_display_config_method_info_get_current_state =
{
  {
    -1,
    (gchar *) "GetCurrentState",
    NULL,
    (GDBusArgInfo **) &_org_gnome_mutter_display_config_method_info_get_current_state_OUT_ARG_pointers,
    NULL
  },
  "handle-get-current-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_apply_monitors_config_IN_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_apply_monitors_config_IN_ARG_method =
{
  {
    -1,
    (gchar *) "method",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_apply_monitors_config_IN_ARG_logical_monitors =
{
  {
    -1,
    (gchar *) "logical_monitors",
    (gchar *) "a(iiduba(ssa{sv}))",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_display_config_method_info_apply_monitors_config_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_display_config_method_info_apply_monitors_config_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_display_config_method_info_apply_monitors_config_IN_ARG_serial.parent_struct,
  &_org_gnome_mutter_display_config_method_info_apply_monitors_config_IN_ARG_method.parent_struct,
  &_org_gnome_mutter_display_config_method_info_apply_monitors_config_IN_ARG_logical_monitors.parent_struct,
  &_org_gnome_mutter_display_config_method_info_apply_monitors_config_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_display_config_method_info_apply_monitors_config =
{
  {
    -1,
    (gchar *) "ApplyMonitorsConfig",
    (GDBusArgInfo **) &_org_gnome_mutter_display_config_method_info_apply_monitors_config_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-apply-monitors-config",
  FALSE
};

static const GDBusMethodInfo * const _org_gnome_mutter_display_config_method_info_pointers[] =
{
  &_org_gnome_mutter_display_config_method_info_get_resources.parent_struct,
  &_org_gnome_mutter_display_config_method_info_apply_configuration.parent_struct,
  &_org_gnome_mutter_display_config_method_info_change_backlight.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_crtc_gamma.parent_struct,
  &_org_gnome_mutter_display_config_method_info_set_crtc_gamma.parent_struct,
  &_org_gnome_mutter_display_config_method_info_get_current_state.parent_struct,
  &_org_gnome_mutter_display_config_method_info_apply_monitors_config.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_gnome_mutter_display_config_signal_info_monitors_changed =
{
  {
    -1,
    (gchar *) "MonitorsChanged",
    NULL,
    NULL
  },
  "monitors-changed"
};

static const GDBusSignalInfo * const _org_gnome_mutter_display_config_signal_info_pointers[] =
{
  &_org_gnome_mutter_display_config_signal_info_monitors_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _org_gnome_mutter_display_config_property_info_power_save_mode =
{
  {
    -1,
    (gchar *) "PowerSaveMode",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "power-save-mode",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _org_gnome_mutter_display_config_property_info_pointers[] =
{
  &_org_gnome_mutter_display_config_property_info_power_save_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_gnome_mutter_display_config_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.DisplayConfig",
    (GDBusMethodInfo **) &_org_gnome_mutter_display_config_method_info_pointers,
    (GDBusSignalInfo **) &_org_gnome_mutter_display_config_signal_info_pointers,
    (GDBusPropertyInfo **) &_org_gnome_mutter_display_config_property_info_pointers,
    NULL
  },
  "org-gnome-mutter-display-config",
};


/**
 * org_gnome_mutter_display_config_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-DisplayConfig.top_of_page">org.gnome.Mutter.DisplayConfig</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_gnome_mutter_display_config_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_gnome_mutter_display_config_interface_info.parent_struct;
}

/**
 * org_gnome_mutter_display_config_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgGnomeMutterDisplayConfig interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_gnome_mutter_display_config_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "power-save-mode");
  return property_id_begin - 1;
}



/**
 * OrgGnomeMutterDisplayConfig:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-DisplayConfig.top_of_page">org.gnome.Mutter.DisplayConfig</link>.
 */

/**
 * OrgGnomeMutterDisplayConfigIface:
 * @parent_iface: The parent interface.
 * @handle_apply_configuration: Handler for the #OrgGnomeMutterDisplayConfig::handle-apply-configuration signal.
 * @handle_apply_monitors_config: Handler for the #OrgGnomeMutterDisplayConfig::handle-apply-monitors-config signal.
 * @handle_change_backlight: Handler for the #OrgGnomeMutterDisplayConfig::handle-change-backlight signal.
 * @handle_get_crtc_gamma: Handler for the #OrgGnomeMutterDisplayConfig::handle-get-crtc-gamma signal.
 * @handle_get_current_state: Handler for the #OrgGnomeMutterDisplayConfig::handle-get-current-state signal.
 * @handle_get_resources: Handler for the #OrgGnomeMutterDisplayConfig::handle-get-resources signal.
 * @handle_set_crtc_gamma: Handler for the #OrgGnomeMutterDisplayConfig::handle-set-crtc-gamma signal.
 * @get_power_save_mode: Getter for the #OrgGnomeMutterDisplayConfig:power-save-mode property.
 * @monitors_changed: Handler for the #OrgGnomeMutterDisplayConfig::monitors-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-DisplayConfig.top_of_page">org.gnome.Mutter.DisplayConfig</link>.
 */

typedef OrgGnomeMutterDisplayConfigIface OrgGnomeMutterDisplayConfigInterface;
G_DEFINE_INTERFACE (OrgGnomeMutterDisplayConfig, org_gnome_mutter_display_config, G_TYPE_OBJECT)

static void
org_gnome_mutter_display_config_default_init (OrgGnomeMutterDisplayConfigIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgGnomeMutterDisplayConfig::handle-get-resources:
   * @object: A #OrgGnomeMutterDisplayConfig.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetResources">GetResources()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_display_config_complete_get_resources() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-resources",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterDisplayConfigIface, handle_get_resources),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeMutterDisplayConfig::handle-apply-configuration:
   * @object: A #OrgGnomeMutterDisplayConfig.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_serial: Argument passed by remote caller.
   * @arg_persistent: Argument passed by remote caller.
   * @arg_crtcs: Argument passed by remote caller.
   * @arg_outputs: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ApplyConfiguration">ApplyConfiguration()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_display_config_complete_apply_configuration() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-apply-configuration",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterDisplayConfigIface, handle_apply_configuration),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * OrgGnomeMutterDisplayConfig::handle-change-backlight:
   * @object: A #OrgGnomeMutterDisplayConfig.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_serial: Argument passed by remote caller.
   * @arg_output: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ChangeBacklight">ChangeBacklight()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_display_config_complete_change_backlight() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-change-backlight",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterDisplayConfigIface, handle_change_backlight),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INT);

  /**
   * OrgGnomeMutterDisplayConfig::handle-get-crtc-gamma:
   * @object: A #OrgGnomeMutterDisplayConfig.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_serial: Argument passed by remote caller.
   * @arg_crtc: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetCrtcGamma">GetCrtcGamma()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_display_config_complete_get_crtc_gamma() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-crtc-gamma",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterDisplayConfigIface, handle_get_crtc_gamma),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * OrgGnomeMutterDisplayConfig::handle-set-crtc-gamma:
   * @object: A #OrgGnomeMutterDisplayConfig.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_serial: Argument passed by remote caller.
   * @arg_crtc: Argument passed by remote caller.
   * @arg_red: Argument passed by remote caller.
   * @arg_green: Argument passed by remote caller.
   * @arg_blue: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.SetCrtcGamma">SetCrtcGamma()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_display_config_complete_set_crtc_gamma() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-crtc-gamma",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterDisplayConfigIface, handle_set_crtc_gamma),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_VARIANT, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * OrgGnomeMutterDisplayConfig::handle-get-current-state:
   * @object: A #OrgGnomeMutterDisplayConfig.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetCurrentState">GetCurrentState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_display_config_complete_get_current_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-current-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterDisplayConfigIface, handle_get_current_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeMutterDisplayConfig::handle-apply-monitors-config:
   * @object: A #OrgGnomeMutterDisplayConfig.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_serial: Argument passed by remote caller.
   * @arg_method: Argument passed by remote caller.
   * @arg_logical_monitors: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ApplyMonitorsConfig">ApplyMonitorsConfig()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_display_config_complete_apply_monitors_config() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-apply-monitors-config",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterDisplayConfigIface, handle_apply_monitors_config),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgGnomeMutterDisplayConfig::monitors-changed:
   * @object: A #OrgGnomeMutterDisplayConfig.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-DisplayConfig.MonitorsChanged">"MonitorsChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("monitors-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterDisplayConfigIface, monitors_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /* GObject properties for D-Bus properties: */
  /**
   * OrgGnomeMutterDisplayConfig:power-save-mode:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-DisplayConfig.PowerSaveMode">"PowerSaveMode"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("power-save-mode", "PowerSaveMode", "PowerSaveMode", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * org_gnome_mutter_display_config_get_power_save_mode: (skip)
 * @object: A #OrgGnomeMutterDisplayConfig.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-DisplayConfig.PowerSaveMode">"PowerSaveMode"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
org_gnome_mutter_display_config_get_power_save_mode (OrgGnomeMutterDisplayConfig *object)
{
  return ORG_GNOME_MUTTER_DISPLAY_CONFIG_GET_IFACE (object)->get_power_save_mode (object);
}

/**
 * org_gnome_mutter_display_config_set_power_save_mode: (skip)
 * @object: A #OrgGnomeMutterDisplayConfig.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-DisplayConfig.PowerSaveMode">"PowerSaveMode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
org_gnome_mutter_display_config_set_power_save_mode (OrgGnomeMutterDisplayConfig *object, gint value)
{
  g_object_set (G_OBJECT (object), "power-save-mode", value, NULL);
}

/**
 * org_gnome_mutter_display_config_emit_monitors_changed:
 * @object: A #OrgGnomeMutterDisplayConfig.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-DisplayConfig.MonitorsChanged">"MonitorsChanged"</link> D-Bus signal.
 */
void
org_gnome_mutter_display_config_emit_monitors_changed (
    OrgGnomeMutterDisplayConfig *object)
{
  g_signal_emit_by_name (object, "monitors-changed");
}

/**
 * org_gnome_mutter_display_config_call_get_resources:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetResources">GetResources()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_display_config_call_get_resources_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_display_config_call_get_resources_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_display_config_call_get_resources (
    OrgGnomeMutterDisplayConfig *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetResources",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_display_config_call_get_resources_finish:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @out_serial: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_crtcs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_outputs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_modes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_max_screen_width: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_max_screen_height: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_display_config_call_get_resources().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_display_config_call_get_resources().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_get_resources_finish (
    OrgGnomeMutterDisplayConfig *proxy,
    guint *out_serial,
    GVariant **out_crtcs,
    GVariant **out_outputs,
    GVariant **out_modes,
    gint *out_max_screen_width,
    gint *out_max_screen_height,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a(uxiiiiiuaua{sv})@a(uxiausauaua{sv})@a(uxuudu)ii)",
                 out_serial,
                 out_crtcs,
                 out_outputs,
                 out_modes,
                 out_max_screen_width,
                 out_max_screen_height);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_get_resources_sync:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @out_serial: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_crtcs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_outputs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_modes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_max_screen_width: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_max_screen_height: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetResources">GetResources()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_display_config_call_get_resources() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_get_resources_sync (
    OrgGnomeMutterDisplayConfig *proxy,
    guint *out_serial,
    GVariant **out_crtcs,
    GVariant **out_outputs,
    GVariant **out_modes,
    gint *out_max_screen_width,
    gint *out_max_screen_height,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetResources",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a(uxiiiiiuaua{sv})@a(uxiausauaua{sv})@a(uxuudu)ii)",
                 out_serial,
                 out_crtcs,
                 out_outputs,
                 out_modes,
                 out_max_screen_width,
                 out_max_screen_height);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_apply_configuration:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_persistent: Argument to pass with the method invocation.
 * @arg_crtcs: Argument to pass with the method invocation.
 * @arg_outputs: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ApplyConfiguration">ApplyConfiguration()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_display_config_call_apply_configuration_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_display_config_call_apply_configuration_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_display_config_call_apply_configuration (
    OrgGnomeMutterDisplayConfig *proxy,
    guint arg_serial,
    gboolean arg_persistent,
    GVariant *arg_crtcs,
    GVariant *arg_outputs,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ApplyConfiguration",
    g_variant_new ("(ub@a(uiiiuaua{sv})@a(ua{sv}))",
                   arg_serial,
                   arg_persistent,
                   arg_crtcs,
                   arg_outputs),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_display_config_call_apply_configuration_finish:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_display_config_call_apply_configuration().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_display_config_call_apply_configuration().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_apply_configuration_finish (
    OrgGnomeMutterDisplayConfig *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_apply_configuration_sync:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_persistent: Argument to pass with the method invocation.
 * @arg_crtcs: Argument to pass with the method invocation.
 * @arg_outputs: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ApplyConfiguration">ApplyConfiguration()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_display_config_call_apply_configuration() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_apply_configuration_sync (
    OrgGnomeMutterDisplayConfig *proxy,
    guint arg_serial,
    gboolean arg_persistent,
    GVariant *arg_crtcs,
    GVariant *arg_outputs,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ApplyConfiguration",
    g_variant_new ("(ub@a(uiiiuaua{sv})@a(ua{sv}))",
                   arg_serial,
                   arg_persistent,
                   arg_crtcs,
                   arg_outputs),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_change_backlight:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_output: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ChangeBacklight">ChangeBacklight()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_display_config_call_change_backlight_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_display_config_call_change_backlight_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_display_config_call_change_backlight (
    OrgGnomeMutterDisplayConfig *proxy,
    guint arg_serial,
    guint arg_output,
    gint arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ChangeBacklight",
    g_variant_new ("(uui)",
                   arg_serial,
                   arg_output,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_display_config_call_change_backlight_finish:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @out_new_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_display_config_call_change_backlight().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_display_config_call_change_backlight().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_change_backlight_finish (
    OrgGnomeMutterDisplayConfig *proxy,
    gint *out_new_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_new_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_change_backlight_sync:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_output: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @out_new_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ChangeBacklight">ChangeBacklight()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_display_config_call_change_backlight() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_change_backlight_sync (
    OrgGnomeMutterDisplayConfig *proxy,
    guint arg_serial,
    guint arg_output,
    gint arg_value,
    gint *out_new_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ChangeBacklight",
    g_variant_new ("(uui)",
                   arg_serial,
                   arg_output,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_new_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_get_crtc_gamma:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_crtc: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetCrtcGamma">GetCrtcGamma()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_display_config_call_get_crtc_gamma_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_display_config_call_get_crtc_gamma_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_display_config_call_get_crtc_gamma (
    OrgGnomeMutterDisplayConfig *proxy,
    guint arg_serial,
    guint arg_crtc,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetCrtcGamma",
    g_variant_new ("(uu)",
                   arg_serial,
                   arg_crtc),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_display_config_call_get_crtc_gamma_finish:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @out_red: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_green: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_blue: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_display_config_call_get_crtc_gamma().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_display_config_call_get_crtc_gamma().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_get_crtc_gamma_finish (
    OrgGnomeMutterDisplayConfig *proxy,
    GVariant **out_red,
    GVariant **out_green,
    GVariant **out_blue,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aq@aq@aq)",
                 out_red,
                 out_green,
                 out_blue);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_get_crtc_gamma_sync:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_crtc: Argument to pass with the method invocation.
 * @out_red: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_green: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_blue: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetCrtcGamma">GetCrtcGamma()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_display_config_call_get_crtc_gamma() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_get_crtc_gamma_sync (
    OrgGnomeMutterDisplayConfig *proxy,
    guint arg_serial,
    guint arg_crtc,
    GVariant **out_red,
    GVariant **out_green,
    GVariant **out_blue,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetCrtcGamma",
    g_variant_new ("(uu)",
                   arg_serial,
                   arg_crtc),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aq@aq@aq)",
                 out_red,
                 out_green,
                 out_blue);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_set_crtc_gamma:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_crtc: Argument to pass with the method invocation.
 * @arg_red: Argument to pass with the method invocation.
 * @arg_green: Argument to pass with the method invocation.
 * @arg_blue: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.SetCrtcGamma">SetCrtcGamma()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_display_config_call_set_crtc_gamma_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_display_config_call_set_crtc_gamma_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_display_config_call_set_crtc_gamma (
    OrgGnomeMutterDisplayConfig *proxy,
    guint arg_serial,
    guint arg_crtc,
    GVariant *arg_red,
    GVariant *arg_green,
    GVariant *arg_blue,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetCrtcGamma",
    g_variant_new ("(uu@aq@aq@aq)",
                   arg_serial,
                   arg_crtc,
                   arg_red,
                   arg_green,
                   arg_blue),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_display_config_call_set_crtc_gamma_finish:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_display_config_call_set_crtc_gamma().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_display_config_call_set_crtc_gamma().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_set_crtc_gamma_finish (
    OrgGnomeMutterDisplayConfig *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_set_crtc_gamma_sync:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_crtc: Argument to pass with the method invocation.
 * @arg_red: Argument to pass with the method invocation.
 * @arg_green: Argument to pass with the method invocation.
 * @arg_blue: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.SetCrtcGamma">SetCrtcGamma()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_display_config_call_set_crtc_gamma() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_set_crtc_gamma_sync (
    OrgGnomeMutterDisplayConfig *proxy,
    guint arg_serial,
    guint arg_crtc,
    GVariant *arg_red,
    GVariant *arg_green,
    GVariant *arg_blue,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetCrtcGamma",
    g_variant_new ("(uu@aq@aq@aq)",
                   arg_serial,
                   arg_crtc,
                   arg_red,
                   arg_green,
                   arg_blue),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_get_current_state:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetCurrentState">GetCurrentState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_display_config_call_get_current_state_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_display_config_call_get_current_state_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_display_config_call_get_current_state (
    OrgGnomeMutterDisplayConfig *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetCurrentState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_display_config_call_get_current_state_finish:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @out_serial: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_monitors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_logical_monitors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_display_config_call_get_current_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_display_config_call_get_current_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_get_current_state_finish (
    OrgGnomeMutterDisplayConfig *proxy,
    guint *out_serial,
    GVariant **out_monitors,
    GVariant **out_logical_monitors,
    GVariant **out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a((ssss)a(siiddada{sv})a{sv})@a(iiduba(ssss)a{sv})@a{sv})",
                 out_serial,
                 out_monitors,
                 out_logical_monitors,
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_get_current_state_sync:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @out_serial: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_monitors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_logical_monitors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetCurrentState">GetCurrentState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_display_config_call_get_current_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_get_current_state_sync (
    OrgGnomeMutterDisplayConfig *proxy,
    guint *out_serial,
    GVariant **out_monitors,
    GVariant **out_logical_monitors,
    GVariant **out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetCurrentState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a((ssss)a(siiddada{sv})a{sv})@a(iiduba(ssss)a{sv})@a{sv})",
                 out_serial,
                 out_monitors,
                 out_logical_monitors,
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_apply_monitors_config:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_method: Argument to pass with the method invocation.
 * @arg_logical_monitors: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ApplyMonitorsConfig">ApplyMonitorsConfig()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_display_config_call_apply_monitors_config_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_display_config_call_apply_monitors_config_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_display_config_call_apply_monitors_config (
    OrgGnomeMutterDisplayConfig *proxy,
    guint arg_serial,
    guint arg_method,
    GVariant *arg_logical_monitors,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ApplyMonitorsConfig",
    g_variant_new ("(uu@a(iiduba(ssa{sv}))@a{sv})",
                   arg_serial,
                   arg_method,
                   arg_logical_monitors,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_display_config_call_apply_monitors_config_finish:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_display_config_call_apply_monitors_config().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_display_config_call_apply_monitors_config().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_apply_monitors_config_finish (
    OrgGnomeMutterDisplayConfig *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_call_apply_monitors_config_sync:
 * @proxy: A #OrgGnomeMutterDisplayConfigProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_method: Argument to pass with the method invocation.
 * @arg_logical_monitors: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ApplyMonitorsConfig">ApplyMonitorsConfig()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_display_config_call_apply_monitors_config() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_display_config_call_apply_monitors_config_sync (
    OrgGnomeMutterDisplayConfig *proxy,
    guint arg_serial,
    guint arg_method,
    GVariant *arg_logical_monitors,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ApplyMonitorsConfig",
    g_variant_new ("(uu@a(iiduba(ssa{sv}))@a{sv})",
                   arg_serial,
                   arg_method,
                   arg_logical_monitors,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_display_config_complete_get_resources:
 * @object: A #OrgGnomeMutterDisplayConfig.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @serial: Parameter to return.
 * @crtcs: Parameter to return.
 * @outputs: Parameter to return.
 * @modes: Parameter to return.
 * @max_screen_width: Parameter to return.
 * @max_screen_height: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetResources">GetResources()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_display_config_complete_get_resources (
    OrgGnomeMutterDisplayConfig *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint serial,
    GVariant *crtcs,
    GVariant *outputs,
    GVariant *modes,
    gint max_screen_width,
    gint max_screen_height)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a(uxiiiiiuaua{sv})@a(uxiausauaua{sv})@a(uxuudu)ii)",
                   serial,
                   crtcs,
                   outputs,
                   modes,
                   max_screen_width,
                   max_screen_height));
}

/**
 * org_gnome_mutter_display_config_complete_apply_configuration:
 * @object: A #OrgGnomeMutterDisplayConfig.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ApplyConfiguration">ApplyConfiguration()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_display_config_complete_apply_configuration (
    OrgGnomeMutterDisplayConfig *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_display_config_complete_change_backlight:
 * @object: A #OrgGnomeMutterDisplayConfig.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @new_value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ChangeBacklight">ChangeBacklight()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_display_config_complete_change_backlight (
    OrgGnomeMutterDisplayConfig *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint new_value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   new_value));
}

/**
 * org_gnome_mutter_display_config_complete_get_crtc_gamma:
 * @object: A #OrgGnomeMutterDisplayConfig.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @red: Parameter to return.
 * @green: Parameter to return.
 * @blue: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetCrtcGamma">GetCrtcGamma()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_display_config_complete_get_crtc_gamma (
    OrgGnomeMutterDisplayConfig *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *red,
    GVariant *green,
    GVariant *blue)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@aq@aq@aq)",
                   red,
                   green,
                   blue));
}

/**
 * org_gnome_mutter_display_config_complete_set_crtc_gamma:
 * @object: A #OrgGnomeMutterDisplayConfig.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.SetCrtcGamma">SetCrtcGamma()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_display_config_complete_set_crtc_gamma (
    OrgGnomeMutterDisplayConfig *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_display_config_complete_get_current_state:
 * @object: A #OrgGnomeMutterDisplayConfig.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @serial: Parameter to return.
 * @monitors: Parameter to return.
 * @logical_monitors: Parameter to return.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.GetCurrentState">GetCurrentState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_display_config_complete_get_current_state (
    OrgGnomeMutterDisplayConfig *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint serial,
    GVariant *monitors,
    GVariant *logical_monitors,
    GVariant *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a((ssss)a(siiddada{sv})a{sv})@a(iiduba(ssss)a{sv})@a{sv})",
                   serial,
                   monitors,
                   logical_monitors,
                   properties));
}

/**
 * org_gnome_mutter_display_config_complete_apply_monitors_config:
 * @object: A #OrgGnomeMutterDisplayConfig.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-DisplayConfig.ApplyMonitorsConfig">ApplyMonitorsConfig()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_display_config_complete_apply_monitors_config (
    OrgGnomeMutterDisplayConfig *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterDisplayConfigProxy:
 *
 * The #OrgGnomeMutterDisplayConfigProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterDisplayConfigProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterDisplayConfigProxy.
 */

struct _OrgGnomeMutterDisplayConfigProxyPrivate
{
  GData *qdata;
};

static void org_gnome_mutter_display_config_proxy_iface_init (OrgGnomeMutterDisplayConfigIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterDisplayConfigProxy, org_gnome_mutter_display_config_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgGnomeMutterDisplayConfigProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG, org_gnome_mutter_display_config_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterDisplayConfigProxy, org_gnome_mutter_display_config_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG, org_gnome_mutter_display_config_proxy_iface_init))

#endif
static void
org_gnome_mutter_display_config_proxy_finalize (GObject *object)
{
  OrgGnomeMutterDisplayConfigProxy *proxy = ORG_GNOME_MUTTER_DISPLAY_CONFIG_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_gnome_mutter_display_config_proxy_parent_class)->finalize (object);
}

static void
org_gnome_mutter_display_config_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_display_config_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
org_gnome_mutter_display_config_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.DisplayConfig: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
org_gnome_mutter_display_config_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_display_config_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.DisplayConfig", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) org_gnome_mutter_display_config_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
org_gnome_mutter_display_config_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_gnome_mutter_display_config_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_gnome_mutter_display_config_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgGnomeMutterDisplayConfigProxy *proxy = ORG_GNOME_MUTTER_DISPLAY_CONFIG_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_display_config_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_display_config_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gint 
org_gnome_mutter_display_config_proxy_get_power_save_mode (OrgGnomeMutterDisplayConfig *object)
{
  OrgGnomeMutterDisplayConfigProxy *proxy = ORG_GNOME_MUTTER_DISPLAY_CONFIG_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PowerSaveMode");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
org_gnome_mutter_display_config_proxy_init (OrgGnomeMutterDisplayConfigProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_gnome_mutter_display_config_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG_PROXY, OrgGnomeMutterDisplayConfigProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_gnome_mutter_display_config_interface_info ());
}

static void
org_gnome_mutter_display_config_proxy_class_init (OrgGnomeMutterDisplayConfigProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_gnome_mutter_display_config_proxy_finalize;
  gobject_class->get_property = org_gnome_mutter_display_config_proxy_get_property;
  gobject_class->set_property = org_gnome_mutter_display_config_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_gnome_mutter_display_config_proxy_g_signal;
  proxy_class->g_properties_changed = org_gnome_mutter_display_config_proxy_g_properties_changed;

  org_gnome_mutter_display_config_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterDisplayConfigProxyPrivate));
#endif
}

static void
org_gnome_mutter_display_config_proxy_iface_init (OrgGnomeMutterDisplayConfigIface *iface)
{
  iface->get_power_save_mode = org_gnome_mutter_display_config_proxy_get_power_save_mode;
}

/**
 * org_gnome_mutter_display_config_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-DisplayConfig.top_of_page">org.gnome.Mutter.DisplayConfig</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_display_config_proxy_new_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_display_config_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_display_config_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.DisplayConfig", NULL);
}

/**
 * org_gnome_mutter_display_config_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_display_config_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_display_config_proxy_new().
 *
 * Returns: (transfer full) (type OrgGnomeMutterDisplayConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterDisplayConfig *
org_gnome_mutter_display_config_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_DISPLAY_CONFIG (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_display_config_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-DisplayConfig.top_of_page">org.gnome.Mutter.DisplayConfig</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_display_config_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterDisplayConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterDisplayConfig *
org_gnome_mutter_display_config_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.DisplayConfig", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_DISPLAY_CONFIG (ret);
  else
    return NULL;
}


/**
 * org_gnome_mutter_display_config_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_gnome_mutter_display_config_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_display_config_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_display_config_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_display_config_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.DisplayConfig", NULL);
}

/**
 * org_gnome_mutter_display_config_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_display_config_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_display_config_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgGnomeMutterDisplayConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterDisplayConfig *
org_gnome_mutter_display_config_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_DISPLAY_CONFIG (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_display_config_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_gnome_mutter_display_config_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_display_config_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterDisplayConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterDisplayConfig *
org_gnome_mutter_display_config_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.DisplayConfig", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_DISPLAY_CONFIG (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterDisplayConfigSkeleton:
 *
 * The #OrgGnomeMutterDisplayConfigSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterDisplayConfigSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterDisplayConfigSkeleton.
 */

struct _OrgGnomeMutterDisplayConfigSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_gnome_mutter_display_config_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_gnome_mutter_display_config_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_display_config_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_gnome_mutter_display_config_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_display_config_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_gnome_mutter_display_config_skeleton_vtable =
{
  _org_gnome_mutter_display_config_skeleton_handle_method_call,
  _org_gnome_mutter_display_config_skeleton_handle_get_property,
  _org_gnome_mutter_display_config_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_gnome_mutter_display_config_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_gnome_mutter_display_config_interface_info ();
}

static GDBusInterfaceVTable *
org_gnome_mutter_display_config_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_gnome_mutter_display_config_skeleton_vtable;
}

static GVariant *
org_gnome_mutter_display_config_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_gnome_mutter_display_config_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_gnome_mutter_display_config_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_gnome_mutter_display_config_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_gnome_mutter_display_config_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.DisplayConfig", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _org_gnome_mutter_display_config_emit_changed (gpointer user_data);

static void
org_gnome_mutter_display_config_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _org_gnome_mutter_display_config_emit_changed (skeleton);
}

static void
_org_gnome_mutter_display_config_on_signal_monitors_changed (
    OrgGnomeMutterDisplayConfig *object)
{
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.DisplayConfig", "MonitorsChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_gnome_mutter_display_config_skeleton_iface_init (OrgGnomeMutterDisplayConfigIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterDisplayConfigSkeleton, org_gnome_mutter_display_config_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgGnomeMutterDisplayConfigSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG, org_gnome_mutter_display_config_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterDisplayConfigSkeleton, org_gnome_mutter_display_config_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG, org_gnome_mutter_display_config_skeleton_iface_init))

#endif
static void
org_gnome_mutter_display_config_skeleton_finalize (GObject *object)
{
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_gnome_mutter_display_config_skeleton_parent_class)->finalize (object);
}

static void
org_gnome_mutter_display_config_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_org_gnome_mutter_display_config_emit_changed (gpointer user_data)
{
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.DisplayConfig",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_org_gnome_mutter_display_config_schedule_emit_changed (OrgGnomeMutterDisplayConfigSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
org_gnome_mutter_display_config_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _org_gnome_mutter_display_config_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _org_gnome_mutter_display_config_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
org_gnome_mutter_display_config_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_display_config_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _org_gnome_mutter_display_config_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
org_gnome_mutter_display_config_skeleton_init (OrgGnomeMutterDisplayConfigSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_gnome_mutter_display_config_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON, OrgGnomeMutterDisplayConfigSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_INT);
}

static gint 
org_gnome_mutter_display_config_skeleton_get_power_save_mode (OrgGnomeMutterDisplayConfig *object)
{
  OrgGnomeMutterDisplayConfigSkeleton *skeleton = ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
org_gnome_mutter_display_config_skeleton_class_init (OrgGnomeMutterDisplayConfigSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_gnome_mutter_display_config_skeleton_finalize;
  gobject_class->get_property = org_gnome_mutter_display_config_skeleton_get_property;
  gobject_class->set_property = org_gnome_mutter_display_config_skeleton_set_property;
  gobject_class->notify       = org_gnome_mutter_display_config_skeleton_notify;


  org_gnome_mutter_display_config_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_gnome_mutter_display_config_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_gnome_mutter_display_config_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_gnome_mutter_display_config_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_gnome_mutter_display_config_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterDisplayConfigSkeletonPrivate));
#endif
}

static void
org_gnome_mutter_display_config_skeleton_iface_init (OrgGnomeMutterDisplayConfigIface *iface)
{
  iface->monitors_changed = _org_gnome_mutter_display_config_on_signal_monitors_changed;
  iface->get_power_save_mode = org_gnome_mutter_display_config_skeleton_get_power_save_mode;
}

/**
 * org_gnome_mutter_display_config_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-DisplayConfig.top_of_page">org.gnome.Mutter.DisplayConfig</link>.
 *
 * Returns: (transfer full) (type OrgGnomeMutterDisplayConfigSkeleton): The skeleton object.
 */
OrgGnomeMutterDisplayConfig *
org_gnome_mutter_display_config_skeleton_new (void)
{
  return ORG_GNOME_MUTTER_DISPLAY_CONFIG (g_object_new (TYPE_ORG_GNOME_MUTTER_DISPLAY_CONFIG_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.RemoteDesktop
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgGnomeMutterRemoteDesktop
 * @title: OrgGnomeMutterRemoteDesktop
 * @short_description: Generated C code for the org.gnome.Mutter.RemoteDesktop D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.RemoteDesktop ---- */

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_method_info_create_session_OUT_ARG_session_path =
{
  {
    -1,
    (gchar *) "session_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_remote_desktop_method_info_create_session_OUT_ARG_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_method_info_create_session_OUT_ARG_session_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    NULL,
    (GDBusArgInfo **) &_org_gnome_mutter_remote_desktop_method_info_create_session_OUT_ARG_pointers,
    NULL
  },
  "handle-create-session",
  FALSE
};

static const GDBusMethodInfo * const _org_gnome_mutter_remote_desktop_method_info_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_method_info_create_session.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _org_gnome_mutter_remote_desktop_property_info_supported_device_types =
{
  {
    -1,
    (gchar *) "SupportedDeviceTypes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-device-types",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_gnome_mutter_remote_desktop_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _org_gnome_mutter_remote_desktop_property_info_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_property_info_supported_device_types.parent_struct,
  &_org_gnome_mutter_remote_desktop_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_gnome_mutter_remote_desktop_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.RemoteDesktop",
    (GDBusMethodInfo **) &_org_gnome_mutter_remote_desktop_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_org_gnome_mutter_remote_desktop_property_info_pointers,
    NULL
  },
  "org-gnome-mutter-remote-desktop",
};


/**
 * org_gnome_mutter_remote_desktop_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_gnome_mutter_remote_desktop_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_interface_info.parent_struct;
}

/**
 * org_gnome_mutter_remote_desktop_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgGnomeMutterRemoteDesktop interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_gnome_mutter_remote_desktop_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "supported-device-types");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * OrgGnomeMutterRemoteDesktop:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>.
 */

/**
 * OrgGnomeMutterRemoteDesktopIface:
 * @parent_iface: The parent interface.
 * @handle_create_session: Handler for the #OrgGnomeMutterRemoteDesktop::handle-create-session signal.
 * @get_supported_device_types: Getter for the #OrgGnomeMutterRemoteDesktop:supported-device-types property.
 * @get_version: Getter for the #OrgGnomeMutterRemoteDesktop:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>.
 */

typedef OrgGnomeMutterRemoteDesktopIface OrgGnomeMutterRemoteDesktopInterface;
G_DEFINE_INTERFACE (OrgGnomeMutterRemoteDesktop, org_gnome_mutter_remote_desktop, G_TYPE_OBJECT)

static void
org_gnome_mutter_remote_desktop_default_init (OrgGnomeMutterRemoteDesktopIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgGnomeMutterRemoteDesktop::handle-create-session:
   * @object: A #OrgGnomeMutterRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * OrgGnomeMutterRemoteDesktop:supported-device-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.SupportedDeviceTypes">"SupportedDeviceTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("supported-device-types", "SupportedDeviceTypes", "SupportedDeviceTypes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgGnomeMutterRemoteDesktop:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("version", "Version", "Version", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * org_gnome_mutter_remote_desktop_get_supported_device_types: (skip)
 * @object: A #OrgGnomeMutterRemoteDesktop.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.SupportedDeviceTypes">"SupportedDeviceTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
org_gnome_mutter_remote_desktop_get_supported_device_types (OrgGnomeMutterRemoteDesktop *object)
{
  return ORG_GNOME_MUTTER_REMOTE_DESKTOP_GET_IFACE (object)->get_supported_device_types (object);
}

/**
 * org_gnome_mutter_remote_desktop_set_supported_device_types: (skip)
 * @object: A #OrgGnomeMutterRemoteDesktop.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.SupportedDeviceTypes">"SupportedDeviceTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_gnome_mutter_remote_desktop_set_supported_device_types (OrgGnomeMutterRemoteDesktop *object, guint value)
{
  g_object_set (G_OBJECT (object), "supported-device-types", value, NULL);
}

/**
 * org_gnome_mutter_remote_desktop_get_version: (skip)
 * @object: A #OrgGnomeMutterRemoteDesktop.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
org_gnome_mutter_remote_desktop_get_version (OrgGnomeMutterRemoteDesktop *object)
{
  return ORG_GNOME_MUTTER_REMOTE_DESKTOP_GET_IFACE (object)->get_version (object);
}

/**
 * org_gnome_mutter_remote_desktop_set_version: (skip)
 * @object: A #OrgGnomeMutterRemoteDesktop.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_gnome_mutter_remote_desktop_set_version (OrgGnomeMutterRemoteDesktop *object, gint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * org_gnome_mutter_remote_desktop_call_create_session:
 * @proxy: A #OrgGnomeMutterRemoteDesktopProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_call_create_session_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_call_create_session (
    OrgGnomeMutterRemoteDesktop *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_call_create_session_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopProxy.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_call_create_session_finish (
    OrgGnomeMutterRemoteDesktop *proxy,
    gchar **out_session_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_call_create_session_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopProxy.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_call_create_session_sync (
    OrgGnomeMutterRemoteDesktop *proxy,
    gchar **out_session_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_complete_create_session:
 * @object: A #OrgGnomeMutterRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @session_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_complete_create_session (
    OrgGnomeMutterRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *session_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   session_path));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterRemoteDesktopProxy:
 *
 * The #OrgGnomeMutterRemoteDesktopProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterRemoteDesktopProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterRemoteDesktopProxy.
 */

struct _OrgGnomeMutterRemoteDesktopProxyPrivate
{
  GData *qdata;
};

static void org_gnome_mutter_remote_desktop_proxy_iface_init (OrgGnomeMutterRemoteDesktopIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterRemoteDesktopProxy, org_gnome_mutter_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgGnomeMutterRemoteDesktopProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP, org_gnome_mutter_remote_desktop_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterRemoteDesktopProxy, org_gnome_mutter_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP, org_gnome_mutter_remote_desktop_proxy_iface_init))

#endif
static void
org_gnome_mutter_remote_desktop_proxy_finalize (GObject *object)
{
  OrgGnomeMutterRemoteDesktopProxy *proxy = ORG_GNOME_MUTTER_REMOTE_DESKTOP_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_gnome_mutter_remote_desktop_proxy_parent_class)->finalize (object);
}

static void
org_gnome_mutter_remote_desktop_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
org_gnome_mutter_remote_desktop_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.RemoteDesktop: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
org_gnome_mutter_remote_desktop_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.RemoteDesktop", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) org_gnome_mutter_remote_desktop_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
org_gnome_mutter_remote_desktop_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_gnome_mutter_remote_desktop_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgGnomeMutterRemoteDesktopProxy *proxy = ORG_GNOME_MUTTER_REMOTE_DESKTOP_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
org_gnome_mutter_remote_desktop_proxy_get_supported_device_types (OrgGnomeMutterRemoteDesktop *object)
{
  OrgGnomeMutterRemoteDesktopProxy *proxy = ORG_GNOME_MUTTER_REMOTE_DESKTOP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedDeviceTypes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
org_gnome_mutter_remote_desktop_proxy_get_version (OrgGnomeMutterRemoteDesktop *object)
{
  OrgGnomeMutterRemoteDesktopProxy *proxy = ORG_GNOME_MUTTER_REMOTE_DESKTOP_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
org_gnome_mutter_remote_desktop_proxy_init (OrgGnomeMutterRemoteDesktopProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_gnome_mutter_remote_desktop_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_PROXY, OrgGnomeMutterRemoteDesktopProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_gnome_mutter_remote_desktop_interface_info ());
}

static void
org_gnome_mutter_remote_desktop_proxy_class_init (OrgGnomeMutterRemoteDesktopProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_gnome_mutter_remote_desktop_proxy_finalize;
  gobject_class->get_property = org_gnome_mutter_remote_desktop_proxy_get_property;
  gobject_class->set_property = org_gnome_mutter_remote_desktop_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_gnome_mutter_remote_desktop_proxy_g_signal;
  proxy_class->g_properties_changed = org_gnome_mutter_remote_desktop_proxy_g_properties_changed;

  org_gnome_mutter_remote_desktop_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterRemoteDesktopProxyPrivate));
#endif
}

static void
org_gnome_mutter_remote_desktop_proxy_iface_init (OrgGnomeMutterRemoteDesktopIface *iface)
{
  iface->get_supported_device_types = org_gnome_mutter_remote_desktop_proxy_get_supported_device_types;
  iface->get_version = org_gnome_mutter_remote_desktop_proxy_get_version;
}

/**
 * org_gnome_mutter_remote_desktop_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_proxy_new_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_remote_desktop_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
}

/**
 * org_gnome_mutter_remote_desktop_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_proxy_new().
 *
 * Returns: (transfer full) (type OrgGnomeMutterRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterRemoteDesktop *
org_gnome_mutter_remote_desktop_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_remote_desktop_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterRemoteDesktop *
org_gnome_mutter_remote_desktop_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/**
 * org_gnome_mutter_remote_desktop_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_gnome_mutter_remote_desktop_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_remote_desktop_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
}

/**
 * org_gnome_mutter_remote_desktop_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgGnomeMutterRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterRemoteDesktop *
org_gnome_mutter_remote_desktop_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_remote_desktop_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_gnome_mutter_remote_desktop_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterRemoteDesktop *
org_gnome_mutter_remote_desktop_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterRemoteDesktopSkeleton:
 *
 * The #OrgGnomeMutterRemoteDesktopSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterRemoteDesktopSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterRemoteDesktopSkeleton.
 */

struct _OrgGnomeMutterRemoteDesktopSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_gnome_mutter_remote_desktop_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_gnome_mutter_remote_desktop_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_gnome_mutter_remote_desktop_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_gnome_mutter_remote_desktop_skeleton_vtable =
{
  _org_gnome_mutter_remote_desktop_skeleton_handle_method_call,
  _org_gnome_mutter_remote_desktop_skeleton_handle_get_property,
  _org_gnome_mutter_remote_desktop_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_gnome_mutter_remote_desktop_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_gnome_mutter_remote_desktop_interface_info ();
}

static GDBusInterfaceVTable *
org_gnome_mutter_remote_desktop_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_gnome_mutter_remote_desktop_skeleton_vtable;
}

static GVariant *
org_gnome_mutter_remote_desktop_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_gnome_mutter_remote_desktop_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_gnome_mutter_remote_desktop_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_gnome_mutter_remote_desktop_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_gnome_mutter_remote_desktop_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _org_gnome_mutter_remote_desktop_emit_changed (gpointer user_data);

static void
org_gnome_mutter_remote_desktop_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _org_gnome_mutter_remote_desktop_emit_changed (skeleton);
}

static void org_gnome_mutter_remote_desktop_skeleton_iface_init (OrgGnomeMutterRemoteDesktopIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterRemoteDesktopSkeleton, org_gnome_mutter_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgGnomeMutterRemoteDesktopSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP, org_gnome_mutter_remote_desktop_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterRemoteDesktopSkeleton, org_gnome_mutter_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP, org_gnome_mutter_remote_desktop_skeleton_iface_init))

#endif
static void
org_gnome_mutter_remote_desktop_skeleton_finalize (GObject *object)
{
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_gnome_mutter_remote_desktop_skeleton_parent_class)->finalize (object);
}

static void
org_gnome_mutter_remote_desktop_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_org_gnome_mutter_remote_desktop_emit_changed (gpointer user_data)
{
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.RemoteDesktop",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_org_gnome_mutter_remote_desktop_schedule_emit_changed (OrgGnomeMutterRemoteDesktopSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
org_gnome_mutter_remote_desktop_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _org_gnome_mutter_remote_desktop_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _org_gnome_mutter_remote_desktop_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
org_gnome_mutter_remote_desktop_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_remote_desktop_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _org_gnome_mutter_remote_desktop_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
org_gnome_mutter_remote_desktop_skeleton_init (OrgGnomeMutterRemoteDesktopSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_gnome_mutter_remote_desktop_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON, OrgGnomeMutterRemoteDesktopSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_INT);
}

static guint 
org_gnome_mutter_remote_desktop_skeleton_get_supported_device_types (OrgGnomeMutterRemoteDesktop *object)
{
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
org_gnome_mutter_remote_desktop_skeleton_get_version (OrgGnomeMutterRemoteDesktop *object)
{
  OrgGnomeMutterRemoteDesktopSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
org_gnome_mutter_remote_desktop_skeleton_class_init (OrgGnomeMutterRemoteDesktopSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_gnome_mutter_remote_desktop_skeleton_finalize;
  gobject_class->get_property = org_gnome_mutter_remote_desktop_skeleton_get_property;
  gobject_class->set_property = org_gnome_mutter_remote_desktop_skeleton_set_property;
  gobject_class->notify       = org_gnome_mutter_remote_desktop_skeleton_notify;


  org_gnome_mutter_remote_desktop_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_gnome_mutter_remote_desktop_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_gnome_mutter_remote_desktop_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_gnome_mutter_remote_desktop_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_gnome_mutter_remote_desktop_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterRemoteDesktopSkeletonPrivate));
#endif
}

static void
org_gnome_mutter_remote_desktop_skeleton_iface_init (OrgGnomeMutterRemoteDesktopIface *iface)
{
  iface->get_supported_device_types = org_gnome_mutter_remote_desktop_skeleton_get_supported_device_types;
  iface->get_version = org_gnome_mutter_remote_desktop_skeleton_get_version;
}

/**
 * org_gnome_mutter_remote_desktop_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>.
 *
 * Returns: (transfer full) (type OrgGnomeMutterRemoteDesktopSkeleton): The skeleton object.
 */
OrgGnomeMutterRemoteDesktop *
org_gnome_mutter_remote_desktop_skeleton_new (void)
{
  return ORG_GNOME_MUTTER_REMOTE_DESKTOP (g_object_new (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.RemoteDesktop.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgGnomeMutterRemoteDesktopSession
 * @title: OrgGnomeMutterRemoteDesktopSession
 * @short_description: Generated C code for the org.gnome.Mutter.RemoteDesktop.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.RemoteDesktop.Session ---- */

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    NULL,
    NULL,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_keycode =
{
  {
    -1,
    (gchar *) "keycode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_keycode.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keycode =
{
  {
    -1,
    (gchar *) "NotifyKeyboardKeycode",
    (GDBusArgInfo **) &_org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-keyboard-keycode",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_keysym =
{
  {
    -1,
    (gchar *) "keysym",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_keysym.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keysym =
{
  {
    -1,
    (gchar *) "NotifyKeyboardKeysym",
    (GDBusArgInfo **) &_org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-keyboard-keysym",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_button =
{
  {
    -1,
    (gchar *) "button",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_button.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_button =
{
  {
    -1,
    (gchar *) "NotifyPointerButton",
    (GDBusArgInfo **) &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-button",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dx =
{
  {
    -1,
    (gchar *) "dx",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dy =
{
  {
    -1,
    (gchar *) "dy",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dx.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dy.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis =
{
  {
    -1,
    (gchar *) "NotifyPointerAxis",
    (GDBusArgInfo **) &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-axis",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_axis =
{
  {
    -1,
    (gchar *) "axis",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_steps =
{
  {
    -1,
    (gchar *) "steps",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_axis.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_steps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_discrete =
{
  {
    -1,
    (gchar *) "NotifyPointerAxisDiscrete",
    (GDBusArgInfo **) &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-axis-discrete",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dx =
{
  {
    -1,
    (gchar *) "dx",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dy =
{
  {
    -1,
    (gchar *) "dy",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dx.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dy.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_relative =
{
  {
    -1,
    (gchar *) "NotifyPointerMotionRelative",
    (GDBusArgInfo **) &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-motion-relative",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_stream.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_x.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_absolute =
{
  {
    -1,
    (gchar *) "NotifyPointerMotionAbsolute",
    (GDBusArgInfo **) &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-motion-absolute",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down_IN_ARG_stream.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down_IN_ARG_slot.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down_IN_ARG_x.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down =
{
  {
    -1,
    (gchar *) "NotifyTouchDown",
    (GDBusArgInfo **) &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-down",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_stream.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_slot.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_x.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion =
{
  {
    -1,
    (gchar *) "NotifyTouchMotion",
    (GDBusArgInfo **) &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-motion",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_up_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_up_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_up_IN_ARG_slot.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_remote_desktop_session_method_info_notify_touch_up =
{
  {
    -1,
    (gchar *) "NotifyTouchUp",
    (GDBusArgInfo **) &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_up_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-up",
  FALSE
};

static const GDBusMethodInfo * const _org_gnome_mutter_remote_desktop_session_method_info_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_method_info_start.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_stop.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keycode.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_keyboard_keysym.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_button.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_axis_discrete.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_relative.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_pointer_motion_absolute.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_down.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_motion.parent_struct,
  &_org_gnome_mutter_remote_desktop_session_method_info_notify_touch_up.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_gnome_mutter_remote_desktop_session_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const GDBusSignalInfo * const _org_gnome_mutter_remote_desktop_session_signal_info_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_signal_info_closed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _org_gnome_mutter_remote_desktop_session_property_info_session_id =
{
  {
    -1,
    (gchar *) "SessionId",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "session-id",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _org_gnome_mutter_remote_desktop_session_property_info_pointers[] =
{
  &_org_gnome_mutter_remote_desktop_session_property_info_session_id.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_gnome_mutter_remote_desktop_session_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.RemoteDesktop.Session",
    (GDBusMethodInfo **) &_org_gnome_mutter_remote_desktop_session_method_info_pointers,
    (GDBusSignalInfo **) &_org_gnome_mutter_remote_desktop_session_signal_info_pointers,
    (GDBusPropertyInfo **) &_org_gnome_mutter_remote_desktop_session_property_info_pointers,
    NULL
  },
  "org-gnome-mutter-remote-desktop-session",
};


/**
 * org_gnome_mutter_remote_desktop_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_gnome_mutter_remote_desktop_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_session_interface_info.parent_struct;
}

/**
 * org_gnome_mutter_remote_desktop_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgGnomeMutterRemoteDesktopSession interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_gnome_mutter_remote_desktop_session_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "session-id");
  return property_id_begin - 1;
}



/**
 * OrgGnomeMutterRemoteDesktopSession:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>.
 */

/**
 * OrgGnomeMutterRemoteDesktopSessionIface:
 * @parent_iface: The parent interface.
 * @handle_notify_keyboard_keycode: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-notify-keyboard-keycode signal.
 * @handle_notify_keyboard_keysym: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-notify-keyboard-keysym signal.
 * @handle_notify_pointer_axis: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-notify-pointer-axis signal.
 * @handle_notify_pointer_axis_discrete: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-notify-pointer-axis-discrete signal.
 * @handle_notify_pointer_button: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-notify-pointer-button signal.
 * @handle_notify_pointer_motion_absolute: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-notify-pointer-motion-absolute signal.
 * @handle_notify_pointer_motion_relative: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-notify-pointer-motion-relative signal.
 * @handle_notify_touch_down: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-notify-touch-down signal.
 * @handle_notify_touch_motion: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-notify-touch-motion signal.
 * @handle_notify_touch_up: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-notify-touch-up signal.
 * @handle_start: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-start signal.
 * @handle_stop: Handler for the #OrgGnomeMutterRemoteDesktopSession::handle-stop signal.
 * @get_session_id: Getter for the #OrgGnomeMutterRemoteDesktopSession:session-id property.
 * @closed: Handler for the #OrgGnomeMutterRemoteDesktopSession::closed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>.
 */

typedef OrgGnomeMutterRemoteDesktopSessionIface OrgGnomeMutterRemoteDesktopSessionInterface;
G_DEFINE_INTERFACE (OrgGnomeMutterRemoteDesktopSession, org_gnome_mutter_remote_desktop_session, G_TYPE_OBJECT)

static void
org_gnome_mutter_remote_desktop_session_default_init (OrgGnomeMutterRemoteDesktopSessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-start:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-stop:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-notify-keyboard-keycode:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_keycode: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_notify_keyboard_keycode() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-keyboard-keycode",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_notify_keyboard_keycode),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-notify-keyboard-keysym:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_keysym: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_notify_keyboard_keysym() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-keyboard-keysym",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_notify_keyboard_keysym),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-notify-pointer-button:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_button: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_notify_pointer_button() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-button",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_notify_pointer_button),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_BOOLEAN);

  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-notify-pointer-axis:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_dx: Argument passed by remote caller.
   * @arg_dy: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_notify_pointer_axis() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-axis",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_notify_pointer_axis),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_DOUBLE, G_TYPE_DOUBLE, G_TYPE_UINT);

  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-notify-pointer-axis-discrete:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_axis: Argument passed by remote caller.
   * @arg_steps: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_notify_pointer_axis_discrete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-axis-discrete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_notify_pointer_axis_discrete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_INT);

  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-notify-pointer-motion-relative:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_dx: Argument passed by remote caller.
   * @arg_dy: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_notify_pointer_motion_relative() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-motion-relative",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_notify_pointer_motion_relative),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-notify-pointer-motion-absolute:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_stream: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_notify_pointer_motion_absolute() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-motion-absolute",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_notify_pointer_motion_absolute),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-notify-touch-down:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_stream: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_notify_touch_down() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-down",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_notify_touch_down),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-notify-touch-motion:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_stream: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_notify_touch_motion() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-motion",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_notify_touch_motion),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * OrgGnomeMutterRemoteDesktopSession::handle-notify-touch-up:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_slot: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_remote_desktop_session_complete_notify_touch_up() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-up",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, handle_notify_touch_up),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgGnomeMutterRemoteDesktopSession::closed:
   * @object: A #OrgGnomeMutterRemoteDesktopSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("closed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterRemoteDesktopSessionIface, closed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /* GObject properties for D-Bus properties: */
  /**
   * OrgGnomeMutterRemoteDesktopSession:session-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("session-id", "SessionId", "SessionId", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * org_gnome_mutter_remote_desktop_session_get_session_id: (skip)
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_gnome_mutter_remote_desktop_session_dup_session_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
org_gnome_mutter_remote_desktop_session_get_session_id (OrgGnomeMutterRemoteDesktopSession *object)
{
  return ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_GET_IFACE (object)->get_session_id (object);
}

/**
 * org_gnome_mutter_remote_desktop_session_dup_session_id: (skip)
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
org_gnome_mutter_remote_desktop_session_dup_session_id (OrgGnomeMutterRemoteDesktopSession *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "session-id", &value, NULL);
  return value;
}

/**
 * org_gnome_mutter_remote_desktop_session_set_session_id: (skip)
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_gnome_mutter_remote_desktop_session_set_session_id (OrgGnomeMutterRemoteDesktopSession *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "session-id", value, NULL);
}

/**
 * org_gnome_mutter_remote_desktop_session_emit_closed:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.Closed">"Closed"</link> D-Bus signal.
 */
void
org_gnome_mutter_remote_desktop_session_emit_closed (
    OrgGnomeMutterRemoteDesktopSession *object)
{
  g_signal_emit_by_name (object, "closed");
}

/**
 * org_gnome_mutter_remote_desktop_session_call_start:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_start_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_start_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_start (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_start_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_start_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_start_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_start_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_stop:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_stop_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_stop (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_stop_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_stop_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_stop_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_stop_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keycode:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keycode_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keycode_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keycode (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    guint arg_keycode,
    gboolean arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeycode",
    g_variant_new ("(ub)",
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keycode_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keycode().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keycode().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keycode_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keycode_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keycode() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keycode_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    guint arg_keycode,
    gboolean arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeycode",
    g_variant_new ("(ub)",
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keysym:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_keysym: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keysym_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keysym_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keysym (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    guint arg_keysym,
    gboolean arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeysym",
    g_variant_new ("(ub)",
                   arg_keysym,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keysym_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keysym().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keysym().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keysym_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keysym_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_keysym: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keysym() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_keyboard_keysym_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    guint arg_keysym,
    gboolean arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeysym",
    g_variant_new ("(ub)",
                   arg_keysym,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_button:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_notify_pointer_button_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_pointer_button_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_notify_pointer_button (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    gint arg_button,
    gboolean arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerButton",
    g_variant_new ("(ib)",
                   arg_button,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_button_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_notify_pointer_button().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_notify_pointer_button().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_pointer_button_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_button_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_pointer_button() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_pointer_button_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    gint arg_button,
    gboolean arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerButton",
    g_variant_new ("(ib)",
                   arg_button,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerAxis",
    g_variant_new ("(ddu)",
                   arg_dx,
                   arg_dy,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    guint arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerAxis",
    g_variant_new ("(ddu)",
                   arg_dx,
                   arg_dy,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_discrete:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_axis: Argument to pass with the method invocation.
 * @arg_steps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_discrete_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_discrete_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_discrete (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    guint arg_axis,
    gint arg_steps,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerAxisDiscrete",
    g_variant_new ("(ui)",
                   arg_axis,
                   arg_steps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_discrete_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_discrete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_discrete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_discrete_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_discrete_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_axis: Argument to pass with the method invocation.
 * @arg_steps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_discrete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_pointer_axis_discrete_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    guint arg_axis,
    gint arg_steps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerAxisDiscrete",
    g_variant_new ("(ui)",
                   arg_axis,
                   arg_steps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_relative:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_relative_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_relative_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_relative (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionRelative",
    g_variant_new ("(dd)",
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_relative_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_relative().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_relative().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_relative_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_relative_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_relative() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_relative_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionRelative",
    g_variant_new ("(dd)",
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_absolute:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_absolute_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_absolute_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_absolute (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionAbsolute",
    g_variant_new ("(sdd)",
                   arg_stream,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_absolute_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_absolute().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_absolute().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_absolute_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_absolute_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_absolute() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_pointer_motion_absolute_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionAbsolute",
    g_variant_new ("(sdd)",
                   arg_stream,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_touch_down:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_notify_touch_down_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_touch_down_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_notify_touch_down (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchDown",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_touch_down_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_notify_touch_down().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_notify_touch_down().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_touch_down_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_touch_down_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_touch_down() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_touch_down_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchDown",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_touch_motion:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_notify_touch_motion_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_touch_motion_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_notify_touch_motion (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchMotion",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_touch_motion_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_notify_touch_motion().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_notify_touch_motion().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_touch_motion_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_touch_motion_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_touch_motion() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_touch_motion_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchMotion",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_touch_up:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_slot: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_call_notify_touch_up_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_touch_up_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_remote_desktop_session_call_notify_touch_up (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    guint arg_slot,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchUp",
    g_variant_new ("(u)",
                   arg_slot),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_touch_up_finish:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_call_notify_touch_up().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_call_notify_touch_up().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_touch_up_finish (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_call_notify_touch_up_sync:
 * @proxy: A #OrgGnomeMutterRemoteDesktopSessionProxy.
 * @arg_slot: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_call_notify_touch_up() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_remote_desktop_session_call_notify_touch_up_sync (
    OrgGnomeMutterRemoteDesktopSession *proxy,
    guint arg_slot,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchUp",
    g_variant_new ("(u)",
                   arg_slot),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_start:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_start (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_stop:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_stop (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_notify_keyboard_keycode:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_notify_keyboard_keycode (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_notify_keyboard_keysym:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_notify_keyboard_keysym (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_notify_pointer_button:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_notify_pointer_button (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_notify_pointer_axis:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_notify_pointer_axis (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_notify_pointer_axis_discrete:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_notify_pointer_axis_discrete (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_notify_pointer_motion_relative:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_notify_pointer_motion_relative (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_notify_pointer_motion_absolute:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_notify_pointer_motion_absolute (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_notify_touch_down:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_notify_touch_down (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_notify_touch_motion:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_notify_touch_motion (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_remote_desktop_session_complete_notify_touch_up:
 * @object: A #OrgGnomeMutterRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_remote_desktop_session_complete_notify_touch_up (
    OrgGnomeMutterRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterRemoteDesktopSessionProxy:
 *
 * The #OrgGnomeMutterRemoteDesktopSessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterRemoteDesktopSessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterRemoteDesktopSessionProxy.
 */

struct _OrgGnomeMutterRemoteDesktopSessionProxyPrivate
{
  GData *qdata;
};

static void org_gnome_mutter_remote_desktop_session_proxy_iface_init (OrgGnomeMutterRemoteDesktopSessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterRemoteDesktopSessionProxy, org_gnome_mutter_remote_desktop_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgGnomeMutterRemoteDesktopSessionProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION, org_gnome_mutter_remote_desktop_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterRemoteDesktopSessionProxy, org_gnome_mutter_remote_desktop_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION, org_gnome_mutter_remote_desktop_session_proxy_iface_init))

#endif
static void
org_gnome_mutter_remote_desktop_session_proxy_finalize (GObject *object)
{
  OrgGnomeMutterRemoteDesktopSessionProxy *proxy = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_gnome_mutter_remote_desktop_session_proxy_parent_class)->finalize (object);
}

static void
org_gnome_mutter_remote_desktop_session_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_remote_desktop_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
org_gnome_mutter_remote_desktop_session_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.RemoteDesktop.Session: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
org_gnome_mutter_remote_desktop_session_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_remote_desktop_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.RemoteDesktop.Session", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) org_gnome_mutter_remote_desktop_session_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
org_gnome_mutter_remote_desktop_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_gnome_mutter_remote_desktop_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgGnomeMutterRemoteDesktopSessionProxy *proxy = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
org_gnome_mutter_remote_desktop_session_proxy_get_session_id (OrgGnomeMutterRemoteDesktopSession *object)
{
  OrgGnomeMutterRemoteDesktopSessionProxy *proxy = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SessionId");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
org_gnome_mutter_remote_desktop_session_proxy_init (OrgGnomeMutterRemoteDesktopSessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_gnome_mutter_remote_desktop_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_PROXY, OrgGnomeMutterRemoteDesktopSessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_gnome_mutter_remote_desktop_session_interface_info ());
}

static void
org_gnome_mutter_remote_desktop_session_proxy_class_init (OrgGnomeMutterRemoteDesktopSessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_gnome_mutter_remote_desktop_session_proxy_finalize;
  gobject_class->get_property = org_gnome_mutter_remote_desktop_session_proxy_get_property;
  gobject_class->set_property = org_gnome_mutter_remote_desktop_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_gnome_mutter_remote_desktop_session_proxy_g_signal;
  proxy_class->g_properties_changed = org_gnome_mutter_remote_desktop_session_proxy_g_properties_changed;

  org_gnome_mutter_remote_desktop_session_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterRemoteDesktopSessionProxyPrivate));
#endif
}

static void
org_gnome_mutter_remote_desktop_session_proxy_iface_init (OrgGnomeMutterRemoteDesktopSessionIface *iface)
{
  iface->get_session_id = org_gnome_mutter_remote_desktop_session_proxy_get_session_id;
}

/**
 * org_gnome_mutter_remote_desktop_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_proxy_new_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_remote_desktop_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
}

/**
 * org_gnome_mutter_remote_desktop_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_proxy_new().
 *
 * Returns: (transfer full) (type OrgGnomeMutterRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterRemoteDesktopSession *
org_gnome_mutter_remote_desktop_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterRemoteDesktopSession *
org_gnome_mutter_remote_desktop_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}


/**
 * org_gnome_mutter_remote_desktop_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_gnome_mutter_remote_desktop_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_remote_desktop_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_remote_desktop_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_remote_desktop_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
}

/**
 * org_gnome_mutter_remote_desktop_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_remote_desktop_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_remote_desktop_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgGnomeMutterRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterRemoteDesktopSession *
org_gnome_mutter_remote_desktop_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_remote_desktop_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_gnome_mutter_remote_desktop_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_remote_desktop_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterRemoteDesktopSession *
org_gnome_mutter_remote_desktop_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterRemoteDesktopSessionSkeleton:
 *
 * The #OrgGnomeMutterRemoteDesktopSessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterRemoteDesktopSessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterRemoteDesktopSessionSkeleton.
 */

struct _OrgGnomeMutterRemoteDesktopSessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_gnome_mutter_remote_desktop_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_gnome_mutter_remote_desktop_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_gnome_mutter_remote_desktop_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_remote_desktop_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_gnome_mutter_remote_desktop_session_skeleton_vtable =
{
  _org_gnome_mutter_remote_desktop_session_skeleton_handle_method_call,
  _org_gnome_mutter_remote_desktop_session_skeleton_handle_get_property,
  _org_gnome_mutter_remote_desktop_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_gnome_mutter_remote_desktop_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_gnome_mutter_remote_desktop_session_interface_info ();
}

static GDBusInterfaceVTable *
org_gnome_mutter_remote_desktop_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_gnome_mutter_remote_desktop_session_skeleton_vtable;
}

static GVariant *
org_gnome_mutter_remote_desktop_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_gnome_mutter_remote_desktop_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_gnome_mutter_remote_desktop_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_gnome_mutter_remote_desktop_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_gnome_mutter_remote_desktop_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _org_gnome_mutter_remote_desktop_session_emit_changed (gpointer user_data);

static void
org_gnome_mutter_remote_desktop_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _org_gnome_mutter_remote_desktop_session_emit_changed (skeleton);
}

static void
_org_gnome_mutter_remote_desktop_session_on_signal_closed (
    OrgGnomeMutterRemoteDesktopSession *object)
{
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop.Session", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_gnome_mutter_remote_desktop_session_skeleton_iface_init (OrgGnomeMutterRemoteDesktopSessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterRemoteDesktopSessionSkeleton, org_gnome_mutter_remote_desktop_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgGnomeMutterRemoteDesktopSessionSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION, org_gnome_mutter_remote_desktop_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterRemoteDesktopSessionSkeleton, org_gnome_mutter_remote_desktop_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION, org_gnome_mutter_remote_desktop_session_skeleton_iface_init))

#endif
static void
org_gnome_mutter_remote_desktop_session_skeleton_finalize (GObject *object)
{
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_gnome_mutter_remote_desktop_session_skeleton_parent_class)->finalize (object);
}

static void
org_gnome_mutter_remote_desktop_session_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_org_gnome_mutter_remote_desktop_session_emit_changed (gpointer user_data)
{
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.RemoteDesktop.Session",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_org_gnome_mutter_remote_desktop_session_schedule_emit_changed (OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
org_gnome_mutter_remote_desktop_session_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _org_gnome_mutter_remote_desktop_session_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _org_gnome_mutter_remote_desktop_session_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
org_gnome_mutter_remote_desktop_session_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_remote_desktop_session_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _org_gnome_mutter_remote_desktop_session_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
org_gnome_mutter_remote_desktop_session_skeleton_init (OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_gnome_mutter_remote_desktop_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON, OrgGnomeMutterRemoteDesktopSessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
}

static const gchar *
org_gnome_mutter_remote_desktop_session_skeleton_get_session_id (OrgGnomeMutterRemoteDesktopSession *object)
{
  OrgGnomeMutterRemoteDesktopSessionSkeleton *skeleton = ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
org_gnome_mutter_remote_desktop_session_skeleton_class_init (OrgGnomeMutterRemoteDesktopSessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_gnome_mutter_remote_desktop_session_skeleton_finalize;
  gobject_class->get_property = org_gnome_mutter_remote_desktop_session_skeleton_get_property;
  gobject_class->set_property = org_gnome_mutter_remote_desktop_session_skeleton_set_property;
  gobject_class->notify       = org_gnome_mutter_remote_desktop_session_skeleton_notify;


  org_gnome_mutter_remote_desktop_session_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_gnome_mutter_remote_desktop_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_gnome_mutter_remote_desktop_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_gnome_mutter_remote_desktop_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_gnome_mutter_remote_desktop_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterRemoteDesktopSessionSkeletonPrivate));
#endif
}

static void
org_gnome_mutter_remote_desktop_session_skeleton_iface_init (OrgGnomeMutterRemoteDesktopSessionIface *iface)
{
  iface->closed = _org_gnome_mutter_remote_desktop_session_on_signal_closed;
  iface->get_session_id = org_gnome_mutter_remote_desktop_session_skeleton_get_session_id;
}

/**
 * org_gnome_mutter_remote_desktop_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>.
 *
 * Returns: (transfer full) (type OrgGnomeMutterRemoteDesktopSessionSkeleton): The skeleton object.
 */
OrgGnomeMutterRemoteDesktopSession *
org_gnome_mutter_remote_desktop_session_skeleton_new (void)
{
  return ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION (g_object_new (TYPE_ORG_GNOME_MUTTER_REMOTE_DESKTOP_SESSION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.ScreenCast
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgGnomeMutterScreenCast
 * @title: OrgGnomeMutterScreenCast
 * @short_description: Generated C code for the org.gnome.Mutter.ScreenCast D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.ScreenCast ---- */

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_method_info_create_session_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_screen_cast_method_info_create_session_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_screen_cast_method_info_create_session_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_method_info_create_session_OUT_ARG_session_path =
{
  {
    -1,
    (gchar *) "session_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_screen_cast_method_info_create_session_OUT_ARG_pointers[] =
{
  &_org_gnome_mutter_screen_cast_method_info_create_session_OUT_ARG_session_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_screen_cast_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    (GDBusArgInfo **) &_org_gnome_mutter_screen_cast_method_info_create_session_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_mutter_screen_cast_method_info_create_session_OUT_ARG_pointers,
    NULL
  },
  "handle-create-session",
  FALSE
};

static const GDBusMethodInfo * const _org_gnome_mutter_screen_cast_method_info_pointers[] =
{
  &_org_gnome_mutter_screen_cast_method_info_create_session.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _org_gnome_mutter_screen_cast_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _org_gnome_mutter_screen_cast_property_info_pointers[] =
{
  &_org_gnome_mutter_screen_cast_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_gnome_mutter_screen_cast_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.ScreenCast",
    (GDBusMethodInfo **) &_org_gnome_mutter_screen_cast_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_org_gnome_mutter_screen_cast_property_info_pointers,
    NULL
  },
  "org-gnome-mutter-screen-cast",
};


/**
 * org_gnome_mutter_screen_cast_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_gnome_mutter_screen_cast_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_interface_info.parent_struct;
}

/**
 * org_gnome_mutter_screen_cast_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgGnomeMutterScreenCast interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_gnome_mutter_screen_cast_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * OrgGnomeMutterScreenCast:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link>.
 */

/**
 * OrgGnomeMutterScreenCastIface:
 * @parent_iface: The parent interface.
 * @handle_create_session: Handler for the #OrgGnomeMutterScreenCast::handle-create-session signal.
 * @get_version: Getter for the #OrgGnomeMutterScreenCast:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link>.
 */

typedef OrgGnomeMutterScreenCastIface OrgGnomeMutterScreenCastInterface;
G_DEFINE_INTERFACE (OrgGnomeMutterScreenCast, org_gnome_mutter_screen_cast, G_TYPE_OBJECT)

static void
org_gnome_mutter_screen_cast_default_init (OrgGnomeMutterScreenCastIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgGnomeMutterScreenCast::handle-create-session:
   * @object: A #OrgGnomeMutterScreenCast.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_screen_cast_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterScreenCastIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * OrgGnomeMutterScreenCast:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("version", "Version", "Version", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * org_gnome_mutter_screen_cast_get_version: (skip)
 * @object: A #OrgGnomeMutterScreenCast.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
org_gnome_mutter_screen_cast_get_version (OrgGnomeMutterScreenCast *object)
{
  return ORG_GNOME_MUTTER_SCREEN_CAST_GET_IFACE (object)->get_version (object);
}

/**
 * org_gnome_mutter_screen_cast_set_version: (skip)
 * @object: A #OrgGnomeMutterScreenCast.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_gnome_mutter_screen_cast_set_version (OrgGnomeMutterScreenCast *object, gint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * org_gnome_mutter_screen_cast_call_create_session:
 * @proxy: A #OrgGnomeMutterScreenCastProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_call_create_session_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_screen_cast_call_create_session (
    OrgGnomeMutterScreenCast *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_screen_cast_call_create_session_finish:
 * @proxy: A #OrgGnomeMutterScreenCastProxy.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_call_create_session_finish (
    OrgGnomeMutterScreenCast *proxy,
    gchar **out_session_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_call_create_session_sync:
 * @proxy: A #OrgGnomeMutterScreenCastProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_call_create_session_sync (
    OrgGnomeMutterScreenCast *proxy,
    GVariant *arg_properties,
    gchar **out_session_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_complete_create_session:
 * @object: A #OrgGnomeMutterScreenCast.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @session_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_screen_cast_complete_create_session (
    OrgGnomeMutterScreenCast *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *session_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   session_path));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterScreenCastProxy:
 *
 * The #OrgGnomeMutterScreenCastProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterScreenCastProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterScreenCastProxy.
 */

struct _OrgGnomeMutterScreenCastProxyPrivate
{
  GData *qdata;
};

static void org_gnome_mutter_screen_cast_proxy_iface_init (OrgGnomeMutterScreenCastIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastProxy, org_gnome_mutter_screen_cast_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgGnomeMutterScreenCastProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST, org_gnome_mutter_screen_cast_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastProxy, org_gnome_mutter_screen_cast_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST, org_gnome_mutter_screen_cast_proxy_iface_init))

#endif
static void
org_gnome_mutter_screen_cast_proxy_finalize (GObject *object)
{
  OrgGnomeMutterScreenCastProxy *proxy = ORG_GNOME_MUTTER_SCREEN_CAST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_gnome_mutter_screen_cast_proxy_parent_class)->finalize (object);
}

static void
org_gnome_mutter_screen_cast_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_screen_cast_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
org_gnome_mutter_screen_cast_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.ScreenCast: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
org_gnome_mutter_screen_cast_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_screen_cast_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.ScreenCast", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) org_gnome_mutter_screen_cast_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
org_gnome_mutter_screen_cast_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_GNOME_MUTTER_SCREEN_CAST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_gnome_mutter_screen_cast_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgGnomeMutterScreenCastProxy *proxy = ORG_GNOME_MUTTER_SCREEN_CAST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gint 
org_gnome_mutter_screen_cast_proxy_get_version (OrgGnomeMutterScreenCast *object)
{
  OrgGnomeMutterScreenCastProxy *proxy = ORG_GNOME_MUTTER_SCREEN_CAST_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
org_gnome_mutter_screen_cast_proxy_init (OrgGnomeMutterScreenCastProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_gnome_mutter_screen_cast_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_PROXY, OrgGnomeMutterScreenCastProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_gnome_mutter_screen_cast_interface_info ());
}

static void
org_gnome_mutter_screen_cast_proxy_class_init (OrgGnomeMutterScreenCastProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_gnome_mutter_screen_cast_proxy_finalize;
  gobject_class->get_property = org_gnome_mutter_screen_cast_proxy_get_property;
  gobject_class->set_property = org_gnome_mutter_screen_cast_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_gnome_mutter_screen_cast_proxy_g_signal;
  proxy_class->g_properties_changed = org_gnome_mutter_screen_cast_proxy_g_properties_changed;

  org_gnome_mutter_screen_cast_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterScreenCastProxyPrivate));
#endif
}

static void
org_gnome_mutter_screen_cast_proxy_iface_init (OrgGnomeMutterScreenCastIface *iface)
{
  iface->get_version = org_gnome_mutter_screen_cast_proxy_get_version;
}

/**
 * org_gnome_mutter_screen_cast_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_proxy_new_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_screen_cast_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast", NULL);
}

/**
 * org_gnome_mutter_screen_cast_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_proxy_new().
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCast *
org_gnome_mutter_screen_cast_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_screen_cast_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCast *
org_gnome_mutter_screen_cast_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST (ret);
  else
    return NULL;
}


/**
 * org_gnome_mutter_screen_cast_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_gnome_mutter_screen_cast_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_screen_cast_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast", NULL);
}

/**
 * org_gnome_mutter_screen_cast_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCast *
org_gnome_mutter_screen_cast_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_screen_cast_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_gnome_mutter_screen_cast_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCast *
org_gnome_mutter_screen_cast_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterScreenCastSkeleton:
 *
 * The #OrgGnomeMutterScreenCastSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterScreenCastSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterScreenCastSkeleton.
 */

struct _OrgGnomeMutterScreenCastSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_gnome_mutter_screen_cast_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgGnomeMutterScreenCastSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_GNOME_MUTTER_SCREEN_CAST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_gnome_mutter_screen_cast_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterScreenCastSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_gnome_mutter_screen_cast_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterScreenCastSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_gnome_mutter_screen_cast_skeleton_vtable =
{
  _org_gnome_mutter_screen_cast_skeleton_handle_method_call,
  _org_gnome_mutter_screen_cast_skeleton_handle_get_property,
  _org_gnome_mutter_screen_cast_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_gnome_mutter_screen_cast_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_gnome_mutter_screen_cast_interface_info ();
}

static GDBusInterfaceVTable *
org_gnome_mutter_screen_cast_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_gnome_mutter_screen_cast_skeleton_vtable;
}

static GVariant *
org_gnome_mutter_screen_cast_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeMutterScreenCastSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_gnome_mutter_screen_cast_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_gnome_mutter_screen_cast_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_gnome_mutter_screen_cast_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_gnome_mutter_screen_cast_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ScreenCast", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _org_gnome_mutter_screen_cast_emit_changed (gpointer user_data);

static void
org_gnome_mutter_screen_cast_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeMutterScreenCastSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _org_gnome_mutter_screen_cast_emit_changed (skeleton);
}

static void org_gnome_mutter_screen_cast_skeleton_iface_init (OrgGnomeMutterScreenCastIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastSkeleton, org_gnome_mutter_screen_cast_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgGnomeMutterScreenCastSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST, org_gnome_mutter_screen_cast_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastSkeleton, org_gnome_mutter_screen_cast_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST, org_gnome_mutter_screen_cast_skeleton_iface_init))

#endif
static void
org_gnome_mutter_screen_cast_skeleton_finalize (GObject *object)
{
  OrgGnomeMutterScreenCastSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_gnome_mutter_screen_cast_skeleton_parent_class)->finalize (object);
}

static void
org_gnome_mutter_screen_cast_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  OrgGnomeMutterScreenCastSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_org_gnome_mutter_screen_cast_emit_changed (gpointer user_data)
{
  OrgGnomeMutterScreenCastSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.ScreenCast",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_org_gnome_mutter_screen_cast_schedule_emit_changed (OrgGnomeMutterScreenCastSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
org_gnome_mutter_screen_cast_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  OrgGnomeMutterScreenCastSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _org_gnome_mutter_screen_cast_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _org_gnome_mutter_screen_cast_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
org_gnome_mutter_screen_cast_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  OrgGnomeMutterScreenCastSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_screen_cast_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _org_gnome_mutter_screen_cast_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
org_gnome_mutter_screen_cast_skeleton_init (OrgGnomeMutterScreenCastSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_gnome_mutter_screen_cast_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON, OrgGnomeMutterScreenCastSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_INT);
}

static gint 
org_gnome_mutter_screen_cast_skeleton_get_version (OrgGnomeMutterScreenCast *object)
{
  OrgGnomeMutterScreenCastSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
org_gnome_mutter_screen_cast_skeleton_class_init (OrgGnomeMutterScreenCastSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_gnome_mutter_screen_cast_skeleton_finalize;
  gobject_class->get_property = org_gnome_mutter_screen_cast_skeleton_get_property;
  gobject_class->set_property = org_gnome_mutter_screen_cast_skeleton_set_property;
  gobject_class->notify       = org_gnome_mutter_screen_cast_skeleton_notify;


  org_gnome_mutter_screen_cast_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_gnome_mutter_screen_cast_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_gnome_mutter_screen_cast_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_gnome_mutter_screen_cast_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_gnome_mutter_screen_cast_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterScreenCastSkeletonPrivate));
#endif
}

static void
org_gnome_mutter_screen_cast_skeleton_iface_init (OrgGnomeMutterScreenCastIface *iface)
{
  iface->get_version = org_gnome_mutter_screen_cast_skeleton_get_version;
}

/**
 * org_gnome_mutter_screen_cast_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link>.
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastSkeleton): The skeleton object.
 */
OrgGnomeMutterScreenCast *
org_gnome_mutter_screen_cast_skeleton_new (void)
{
  return ORG_GNOME_MUTTER_SCREEN_CAST (g_object_new (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.ScreenCast.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgGnomeMutterScreenCastSession
 * @title: OrgGnomeMutterScreenCastSession
 * @short_description: Generated C code for the org.gnome.Mutter.ScreenCast.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.ScreenCast.Session ---- */

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_screen_cast_session_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    NULL,
    NULL,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_screen_cast_session_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_monitor_IN_ARG_connector =
{
  {
    -1,
    (gchar *) "connector",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_monitor_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_screen_cast_session_method_info_record_monitor_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_screen_cast_session_method_info_record_monitor_IN_ARG_connector.parent_struct,
  &_org_gnome_mutter_screen_cast_session_method_info_record_monitor_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_monitor_OUT_ARG_stream_path =
{
  {
    -1,
    (gchar *) "stream_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_screen_cast_session_method_info_record_monitor_OUT_ARG_pointers[] =
{
  &_org_gnome_mutter_screen_cast_session_method_info_record_monitor_OUT_ARG_stream_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_screen_cast_session_method_info_record_monitor =
{
  {
    -1,
    (gchar *) "RecordMonitor",
    (GDBusArgInfo **) &_org_gnome_mutter_screen_cast_session_method_info_record_monitor_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_mutter_screen_cast_session_method_info_record_monitor_OUT_ARG_pointers,
    NULL
  },
  "handle-record-monitor",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_window_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_screen_cast_session_method_info_record_window_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_screen_cast_session_method_info_record_window_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_window_OUT_ARG_stream_path =
{
  {
    -1,
    (gchar *) "stream_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_screen_cast_session_method_info_record_window_OUT_ARG_pointers[] =
{
  &_org_gnome_mutter_screen_cast_session_method_info_record_window_OUT_ARG_stream_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_screen_cast_session_method_info_record_window =
{
  {
    -1,
    (gchar *) "RecordWindow",
    (GDBusArgInfo **) &_org_gnome_mutter_screen_cast_session_method_info_record_window_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_mutter_screen_cast_session_method_info_record_window_OUT_ARG_pointers,
    NULL
  },
  "handle-record-window",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_x.parent_struct,
  &_org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_y.parent_struct,
  &_org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_width.parent_struct,
  &_org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_height.parent_struct,
  &_org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_area_OUT_ARG_stream_path =
{
  {
    -1,
    (gchar *) "stream_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_screen_cast_session_method_info_record_area_OUT_ARG_pointers[] =
{
  &_org_gnome_mutter_screen_cast_session_method_info_record_area_OUT_ARG_stream_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_screen_cast_session_method_info_record_area =
{
  {
    -1,
    (gchar *) "RecordArea",
    (GDBusArgInfo **) &_org_gnome_mutter_screen_cast_session_method_info_record_area_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_mutter_screen_cast_session_method_info_record_area_OUT_ARG_pointers,
    NULL
  },
  "handle-record-area",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_virtual_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_screen_cast_session_method_info_record_virtual_IN_ARG_pointers[] =
{
  &_org_gnome_mutter_screen_cast_session_method_info_record_virtual_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_session_method_info_record_virtual_OUT_ARG_stream_path =
{
  {
    -1,
    (gchar *) "stream_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_screen_cast_session_method_info_record_virtual_OUT_ARG_pointers[] =
{
  &_org_gnome_mutter_screen_cast_session_method_info_record_virtual_OUT_ARG_stream_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_mutter_screen_cast_session_method_info_record_virtual =
{
  {
    -1,
    (gchar *) "RecordVirtual",
    (GDBusArgInfo **) &_org_gnome_mutter_screen_cast_session_method_info_record_virtual_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_mutter_screen_cast_session_method_info_record_virtual_OUT_ARG_pointers,
    NULL
  },
  "handle-record-virtual",
  FALSE
};

static const GDBusMethodInfo * const _org_gnome_mutter_screen_cast_session_method_info_pointers[] =
{
  &_org_gnome_mutter_screen_cast_session_method_info_start.parent_struct,
  &_org_gnome_mutter_screen_cast_session_method_info_stop.parent_struct,
  &_org_gnome_mutter_screen_cast_session_method_info_record_monitor.parent_struct,
  &_org_gnome_mutter_screen_cast_session_method_info_record_window.parent_struct,
  &_org_gnome_mutter_screen_cast_session_method_info_record_area.parent_struct,
  &_org_gnome_mutter_screen_cast_session_method_info_record_virtual.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_gnome_mutter_screen_cast_session_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const GDBusSignalInfo * const _org_gnome_mutter_screen_cast_session_signal_info_pointers[] =
{
  &_org_gnome_mutter_screen_cast_session_signal_info_closed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_gnome_mutter_screen_cast_session_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.ScreenCast.Session",
    (GDBusMethodInfo **) &_org_gnome_mutter_screen_cast_session_method_info_pointers,
    (GDBusSignalInfo **) &_org_gnome_mutter_screen_cast_session_signal_info_pointers,
    NULL,
    NULL
  },
  "org-gnome-mutter-screen-cast-session",
};


/**
 * org_gnome_mutter_screen_cast_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_gnome_mutter_screen_cast_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_session_interface_info.parent_struct;
}

/**
 * org_gnome_mutter_screen_cast_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgGnomeMutterScreenCastSession interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_gnome_mutter_screen_cast_session_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * OrgGnomeMutterScreenCastSession:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link>.
 */

/**
 * OrgGnomeMutterScreenCastSessionIface:
 * @parent_iface: The parent interface.
 * @handle_record_area: Handler for the #OrgGnomeMutterScreenCastSession::handle-record-area signal.
 * @handle_record_monitor: Handler for the #OrgGnomeMutterScreenCastSession::handle-record-monitor signal.
 * @handle_record_virtual: Handler for the #OrgGnomeMutterScreenCastSession::handle-record-virtual signal.
 * @handle_record_window: Handler for the #OrgGnomeMutterScreenCastSession::handle-record-window signal.
 * @handle_start: Handler for the #OrgGnomeMutterScreenCastSession::handle-start signal.
 * @handle_stop: Handler for the #OrgGnomeMutterScreenCastSession::handle-stop signal.
 * @closed: Handler for the #OrgGnomeMutterScreenCastSession::closed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link>.
 */

typedef OrgGnomeMutterScreenCastSessionIface OrgGnomeMutterScreenCastSessionInterface;
G_DEFINE_INTERFACE (OrgGnomeMutterScreenCastSession, org_gnome_mutter_screen_cast_session, G_TYPE_OBJECT)

static void
org_gnome_mutter_screen_cast_session_default_init (OrgGnomeMutterScreenCastSessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgGnomeMutterScreenCastSession::handle-start:
   * @object: A #OrgGnomeMutterScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_screen_cast_session_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterScreenCastSessionIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeMutterScreenCastSession::handle-stop:
   * @object: A #OrgGnomeMutterScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_screen_cast_session_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterScreenCastSessionIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeMutterScreenCastSession::handle-record-monitor:
   * @object: A #OrgGnomeMutterScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_connector: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordMonitor">RecordMonitor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_screen_cast_session_complete_record_monitor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-record-monitor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterScreenCastSessionIface, handle_record_monitor),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * OrgGnomeMutterScreenCastSession::handle-record-window:
   * @object: A #OrgGnomeMutterScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordWindow">RecordWindow()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_screen_cast_session_complete_record_window() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-record-window",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterScreenCastSessionIface, handle_record_window),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * OrgGnomeMutterScreenCastSession::handle-record-area:
   * @object: A #OrgGnomeMutterScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordArea">RecordArea()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_screen_cast_session_complete_record_area() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-record-area",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterScreenCastSessionIface, handle_record_area),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_VARIANT);

  /**
   * OrgGnomeMutterScreenCastSession::handle-record-virtual:
   * @object: A #OrgGnomeMutterScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordVirtual">RecordVirtual()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_mutter_screen_cast_session_complete_record_virtual() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-record-virtual",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterScreenCastSessionIface, handle_record_virtual),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgGnomeMutterScreenCastSession::closed:
   * @object: A #OrgGnomeMutterScreenCastSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-ScreenCast-Session.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("closed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterScreenCastSessionIface, closed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

}

/**
 * org_gnome_mutter_screen_cast_session_emit_closed:
 * @object: A #OrgGnomeMutterScreenCastSession.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-ScreenCast-Session.Closed">"Closed"</link> D-Bus signal.
 */
void
org_gnome_mutter_screen_cast_session_emit_closed (
    OrgGnomeMutterScreenCastSession *object)
{
  g_signal_emit_by_name (object, "closed");
}

/**
 * org_gnome_mutter_screen_cast_session_call_start:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_session_call_start_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_session_call_start_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_screen_cast_session_call_start (
    OrgGnomeMutterScreenCastSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_screen_cast_session_call_start_finish:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_session_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_session_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_start_finish (
    OrgGnomeMutterScreenCastSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_call_start_sync:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_session_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_start_sync (
    OrgGnomeMutterScreenCastSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_call_stop:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_session_call_stop_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_session_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_screen_cast_session_call_stop (
    OrgGnomeMutterScreenCastSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_screen_cast_session_call_stop_finish:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_session_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_session_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_stop_finish (
    OrgGnomeMutterScreenCastSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_call_stop_sync:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_session_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_stop_sync (
    OrgGnomeMutterScreenCastSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_monitor:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @arg_connector: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordMonitor">RecordMonitor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_session_call_record_monitor_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_session_call_record_monitor_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_screen_cast_session_call_record_monitor (
    OrgGnomeMutterScreenCastSession *proxy,
    const gchar *arg_connector,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RecordMonitor",
    g_variant_new ("(s@a{sv})",
                   arg_connector,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_monitor_finish:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_session_call_record_monitor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_session_call_record_monitor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_record_monitor_finish (
    OrgGnomeMutterScreenCastSession *proxy,
    gchar **out_stream_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_monitor_sync:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @arg_connector: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordMonitor">RecordMonitor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_session_call_record_monitor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_record_monitor_sync (
    OrgGnomeMutterScreenCastSession *proxy,
    const gchar *arg_connector,
    GVariant *arg_properties,
    gchar **out_stream_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RecordMonitor",
    g_variant_new ("(s@a{sv})",
                   arg_connector,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_window:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordWindow">RecordWindow()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_session_call_record_window_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_session_call_record_window_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_screen_cast_session_call_record_window (
    OrgGnomeMutterScreenCastSession *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RecordWindow",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_window_finish:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_session_call_record_window().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_session_call_record_window().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_record_window_finish (
    OrgGnomeMutterScreenCastSession *proxy,
    gchar **out_stream_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_window_sync:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordWindow">RecordWindow()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_session_call_record_window() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_record_window_sync (
    OrgGnomeMutterScreenCastSession *proxy,
    GVariant *arg_properties,
    gchar **out_stream_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RecordWindow",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_area:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordArea">RecordArea()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_session_call_record_area_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_session_call_record_area_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_screen_cast_session_call_record_area (
    OrgGnomeMutterScreenCastSession *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RecordArea",
    g_variant_new ("(iiii@a{sv})",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_area_finish:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_session_call_record_area().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_session_call_record_area().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_record_area_finish (
    OrgGnomeMutterScreenCastSession *proxy,
    gchar **out_stream_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_area_sync:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordArea">RecordArea()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_session_call_record_area() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_record_area_sync (
    OrgGnomeMutterScreenCastSession *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GVariant *arg_properties,
    gchar **out_stream_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RecordArea",
    g_variant_new ("(iiii@a{sv})",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_virtual:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordVirtual">RecordVirtual()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_session_call_record_virtual_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_session_call_record_virtual_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_mutter_screen_cast_session_call_record_virtual (
    OrgGnomeMutterScreenCastSession *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RecordVirtual",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_virtual_finish:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_session_call_record_virtual().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_session_call_record_virtual().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_record_virtual_finish (
    OrgGnomeMutterScreenCastSession *proxy,
    gchar **out_stream_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_call_record_virtual_sync:
 * @proxy: A #OrgGnomeMutterScreenCastSessionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordVirtual">RecordVirtual()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_session_call_record_virtual() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_mutter_screen_cast_session_call_record_virtual_sync (
    OrgGnomeMutterScreenCastSession *proxy,
    GVariant *arg_properties,
    gchar **out_stream_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RecordVirtual",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_complete_start:
 * @object: A #OrgGnomeMutterScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_screen_cast_session_complete_start (
    OrgGnomeMutterScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_screen_cast_session_complete_stop:
 * @object: A #OrgGnomeMutterScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_screen_cast_session_complete_stop (
    OrgGnomeMutterScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_mutter_screen_cast_session_complete_record_monitor:
 * @object: A #OrgGnomeMutterScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @stream_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordMonitor">RecordMonitor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_screen_cast_session_complete_record_monitor (
    OrgGnomeMutterScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *stream_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   stream_path));
}

/**
 * org_gnome_mutter_screen_cast_session_complete_record_window:
 * @object: A #OrgGnomeMutterScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @stream_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordWindow">RecordWindow()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_screen_cast_session_complete_record_window (
    OrgGnomeMutterScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *stream_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   stream_path));
}

/**
 * org_gnome_mutter_screen_cast_session_complete_record_area:
 * @object: A #OrgGnomeMutterScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @stream_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordArea">RecordArea()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_screen_cast_session_complete_record_area (
    OrgGnomeMutterScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *stream_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   stream_path));
}

/**
 * org_gnome_mutter_screen_cast_session_complete_record_virtual:
 * @object: A #OrgGnomeMutterScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @stream_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordVirtual">RecordVirtual()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_mutter_screen_cast_session_complete_record_virtual (
    OrgGnomeMutterScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *stream_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   stream_path));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterScreenCastSessionProxy:
 *
 * The #OrgGnomeMutterScreenCastSessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterScreenCastSessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterScreenCastSessionProxy.
 */

struct _OrgGnomeMutterScreenCastSessionProxyPrivate
{
  GData *qdata;
};

static void org_gnome_mutter_screen_cast_session_proxy_iface_init (OrgGnomeMutterScreenCastSessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastSessionProxy, org_gnome_mutter_screen_cast_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgGnomeMutterScreenCastSessionProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION, org_gnome_mutter_screen_cast_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastSessionProxy, org_gnome_mutter_screen_cast_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION, org_gnome_mutter_screen_cast_session_proxy_iface_init))

#endif
static void
org_gnome_mutter_screen_cast_session_proxy_finalize (GObject *object)
{
  OrgGnomeMutterScreenCastSessionProxy *proxy = ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_gnome_mutter_screen_cast_session_proxy_parent_class)->finalize (object);
}

static void
org_gnome_mutter_screen_cast_session_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_gnome_mutter_screen_cast_session_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_gnome_mutter_screen_cast_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_gnome_mutter_screen_cast_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgGnomeMutterScreenCastSessionProxy *proxy = ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
org_gnome_mutter_screen_cast_session_proxy_init (OrgGnomeMutterScreenCastSessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_gnome_mutter_screen_cast_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_PROXY, OrgGnomeMutterScreenCastSessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_gnome_mutter_screen_cast_session_interface_info ());
}

static void
org_gnome_mutter_screen_cast_session_proxy_class_init (OrgGnomeMutterScreenCastSessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_gnome_mutter_screen_cast_session_proxy_finalize;
  gobject_class->get_property = org_gnome_mutter_screen_cast_session_proxy_get_property;
  gobject_class->set_property = org_gnome_mutter_screen_cast_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_gnome_mutter_screen_cast_session_proxy_g_signal;
  proxy_class->g_properties_changed = org_gnome_mutter_screen_cast_session_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterScreenCastSessionProxyPrivate));
#endif
}

static void
org_gnome_mutter_screen_cast_session_proxy_iface_init (OrgGnomeMutterScreenCastSessionIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_gnome_mutter_screen_cast_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_session_proxy_new_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_screen_cast_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Session", NULL);
}

/**
 * org_gnome_mutter_screen_cast_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_session_proxy_new().
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCastSession *
org_gnome_mutter_screen_cast_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST_SESSION (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCastSession *
org_gnome_mutter_screen_cast_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Session", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST_SESSION (ret);
  else
    return NULL;
}


/**
 * org_gnome_mutter_screen_cast_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_gnome_mutter_screen_cast_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_screen_cast_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Session", NULL);
}

/**
 * org_gnome_mutter_screen_cast_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCastSession *
org_gnome_mutter_screen_cast_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST_SESSION (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_screen_cast_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_gnome_mutter_screen_cast_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCastSession *
org_gnome_mutter_screen_cast_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Session", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterScreenCastSessionSkeleton:
 *
 * The #OrgGnomeMutterScreenCastSessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterScreenCastSessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterScreenCastSessionSkeleton.
 */

struct _OrgGnomeMutterScreenCastSessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_gnome_mutter_screen_cast_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgGnomeMutterScreenCastSessionSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_gnome_mutter_screen_cast_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterScreenCastSessionSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_gnome_mutter_screen_cast_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterScreenCastSessionSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_gnome_mutter_screen_cast_session_skeleton_vtable =
{
  _org_gnome_mutter_screen_cast_session_skeleton_handle_method_call,
  _org_gnome_mutter_screen_cast_session_skeleton_handle_get_property,
  _org_gnome_mutter_screen_cast_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_gnome_mutter_screen_cast_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_gnome_mutter_screen_cast_session_interface_info ();
}

static GDBusInterfaceVTable *
org_gnome_mutter_screen_cast_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_gnome_mutter_screen_cast_session_skeleton_vtable;
}

static GVariant *
org_gnome_mutter_screen_cast_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeMutterScreenCastSessionSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_gnome_mutter_screen_cast_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_gnome_mutter_screen_cast_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_gnome_mutter_screen_cast_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_gnome_mutter_screen_cast_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ScreenCast.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
org_gnome_mutter_screen_cast_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_org_gnome_mutter_screen_cast_session_on_signal_closed (
    OrgGnomeMutterScreenCastSession *object)
{
  OrgGnomeMutterScreenCastSessionSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ScreenCast.Session", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_gnome_mutter_screen_cast_session_skeleton_iface_init (OrgGnomeMutterScreenCastSessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastSessionSkeleton, org_gnome_mutter_screen_cast_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgGnomeMutterScreenCastSessionSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION, org_gnome_mutter_screen_cast_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastSessionSkeleton, org_gnome_mutter_screen_cast_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION, org_gnome_mutter_screen_cast_session_skeleton_iface_init))

#endif
static void
org_gnome_mutter_screen_cast_session_skeleton_finalize (GObject *object)
{
  OrgGnomeMutterScreenCastSessionSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_gnome_mutter_screen_cast_session_skeleton_parent_class)->finalize (object);
}

static void
org_gnome_mutter_screen_cast_session_skeleton_init (OrgGnomeMutterScreenCastSessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_gnome_mutter_screen_cast_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_SKELETON, OrgGnomeMutterScreenCastSessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
org_gnome_mutter_screen_cast_session_skeleton_class_init (OrgGnomeMutterScreenCastSessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_gnome_mutter_screen_cast_session_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_gnome_mutter_screen_cast_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_gnome_mutter_screen_cast_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_gnome_mutter_screen_cast_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_gnome_mutter_screen_cast_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterScreenCastSessionSkeletonPrivate));
#endif
}

static void
org_gnome_mutter_screen_cast_session_skeleton_iface_init (OrgGnomeMutterScreenCastSessionIface *iface)
{
  iface->closed = _org_gnome_mutter_screen_cast_session_on_signal_closed;
}

/**
 * org_gnome_mutter_screen_cast_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link>.
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastSessionSkeleton): The skeleton object.
 */
OrgGnomeMutterScreenCastSession *
org_gnome_mutter_screen_cast_session_skeleton_new (void)
{
  return ORG_GNOME_MUTTER_SCREEN_CAST_SESSION (g_object_new (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_SESSION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.ScreenCast.Stream
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgGnomeMutterScreenCastStream
 * @title: OrgGnomeMutterScreenCastStream
 * @short_description: Generated C code for the org.gnome.Mutter.ScreenCast.Stream D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.ScreenCast.Stream ---- */

static const _ExtendedGDBusArgInfo _org_gnome_mutter_screen_cast_stream_signal_info_pipewire_stream_added_ARG_node_id =
{
  {
    -1,
    (gchar *) "node_id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_mutter_screen_cast_stream_signal_info_pipewire_stream_added_ARG_pointers[] =
{
  &_org_gnome_mutter_screen_cast_stream_signal_info_pipewire_stream_added_ARG_node_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_gnome_mutter_screen_cast_stream_signal_info_pipewire_stream_added =
{
  {
    -1,
    (gchar *) "PipeWireStreamAdded",
    (GDBusArgInfo **) &_org_gnome_mutter_screen_cast_stream_signal_info_pipewire_stream_added_ARG_pointers,
    NULL
  },
  "pipewire-stream-added"
};

static const GDBusSignalInfo * const _org_gnome_mutter_screen_cast_stream_signal_info_pointers[] =
{
  &_org_gnome_mutter_screen_cast_stream_signal_info_pipewire_stream_added.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _org_gnome_mutter_screen_cast_stream_property_info_parameters =
{
  {
    -1,
    (gchar *) "Parameters",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "parameters",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _org_gnome_mutter_screen_cast_stream_property_info_pointers[] =
{
  &_org_gnome_mutter_screen_cast_stream_property_info_parameters.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_gnome_mutter_screen_cast_stream_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.ScreenCast.Stream",
    NULL,
    (GDBusSignalInfo **) &_org_gnome_mutter_screen_cast_stream_signal_info_pointers,
    (GDBusPropertyInfo **) &_org_gnome_mutter_screen_cast_stream_property_info_pointers,
    NULL
  },
  "org-gnome-mutter-screen-cast-stream",
};


/**
 * org_gnome_mutter_screen_cast_stream_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_gnome_mutter_screen_cast_stream_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_stream_interface_info.parent_struct;
}

/**
 * org_gnome_mutter_screen_cast_stream_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgGnomeMutterScreenCastStream interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_gnome_mutter_screen_cast_stream_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "parameters");
  return property_id_begin - 1;
}



/**
 * OrgGnomeMutterScreenCastStream:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link>.
 */

/**
 * OrgGnomeMutterScreenCastStreamIface:
 * @parent_iface: The parent interface.
 * @get_parameters: Getter for the #OrgGnomeMutterScreenCastStream:parameters property.
 * @pipewire_stream_added: Handler for the #OrgGnomeMutterScreenCastStream::pipewire-stream-added signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link>.
 */

typedef OrgGnomeMutterScreenCastStreamIface OrgGnomeMutterScreenCastStreamInterface;
G_DEFINE_INTERFACE (OrgGnomeMutterScreenCastStream, org_gnome_mutter_screen_cast_stream, G_TYPE_OBJECT)

static void
org_gnome_mutter_screen_cast_stream_default_init (OrgGnomeMutterScreenCastStreamIface *iface)
{
  /* GObject signals for received D-Bus signals: */
  /**
   * OrgGnomeMutterScreenCastStream::pipewire-stream-added:
   * @object: A #OrgGnomeMutterScreenCastStream.
   * @arg_node_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-ScreenCast-Stream.PipeWireStreamAdded">"PipeWireStreamAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("pipewire-stream-added",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeMutterScreenCastStreamIface, pipewire_stream_added),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * OrgGnomeMutterScreenCastStream:parameters:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast-Stream.Parameters">"Parameters"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("parameters", "Parameters", "Parameters", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * org_gnome_mutter_screen_cast_stream_get_parameters: (skip)
 * @object: A #OrgGnomeMutterScreenCastStream.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast-Stream.Parameters">"Parameters"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_gnome_mutter_screen_cast_stream_dup_parameters() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
org_gnome_mutter_screen_cast_stream_get_parameters (OrgGnomeMutterScreenCastStream *object)
{
  return ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_GET_IFACE (object)->get_parameters (object);
}

/**
 * org_gnome_mutter_screen_cast_stream_dup_parameters: (skip)
 * @object: A #OrgGnomeMutterScreenCastStream.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast-Stream.Parameters">"Parameters"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
org_gnome_mutter_screen_cast_stream_dup_parameters (OrgGnomeMutterScreenCastStream *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "parameters", &value, NULL);
  return value;
}

/**
 * org_gnome_mutter_screen_cast_stream_set_parameters: (skip)
 * @object: A #OrgGnomeMutterScreenCastStream.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast-Stream.Parameters">"Parameters"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_gnome_mutter_screen_cast_stream_set_parameters (OrgGnomeMutterScreenCastStream *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "parameters", value, NULL);
}

/**
 * org_gnome_mutter_screen_cast_stream_emit_pipewire_stream_added:
 * @object: A #OrgGnomeMutterScreenCastStream.
 * @arg_node_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-ScreenCast-Stream.PipeWireStreamAdded">"PipeWireStreamAdded"</link> D-Bus signal.
 */
void
org_gnome_mutter_screen_cast_stream_emit_pipewire_stream_added (
    OrgGnomeMutterScreenCastStream *object,
    guint arg_node_id)
{
  g_signal_emit_by_name (object, "pipewire-stream-added", arg_node_id);
}

/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterScreenCastStreamProxy:
 *
 * The #OrgGnomeMutterScreenCastStreamProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterScreenCastStreamProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterScreenCastStreamProxy.
 */

struct _OrgGnomeMutterScreenCastStreamProxyPrivate
{
  GData *qdata;
};

static void org_gnome_mutter_screen_cast_stream_proxy_iface_init (OrgGnomeMutterScreenCastStreamIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastStreamProxy, org_gnome_mutter_screen_cast_stream_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgGnomeMutterScreenCastStreamProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM, org_gnome_mutter_screen_cast_stream_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastStreamProxy, org_gnome_mutter_screen_cast_stream_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM, org_gnome_mutter_screen_cast_stream_proxy_iface_init))

#endif
static void
org_gnome_mutter_screen_cast_stream_proxy_finalize (GObject *object)
{
  OrgGnomeMutterScreenCastStreamProxy *proxy = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_gnome_mutter_screen_cast_stream_proxy_parent_class)->finalize (object);
}

static void
org_gnome_mutter_screen_cast_stream_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_screen_cast_stream_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
org_gnome_mutter_screen_cast_stream_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.ScreenCast.Stream: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
org_gnome_mutter_screen_cast_stream_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_screen_cast_stream_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.ScreenCast.Stream", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) org_gnome_mutter_screen_cast_stream_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
org_gnome_mutter_screen_cast_stream_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_stream_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_gnome_mutter_screen_cast_stream_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgGnomeMutterScreenCastStreamProxy *proxy = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_stream_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_stream_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static GVariant *
org_gnome_mutter_screen_cast_stream_proxy_get_parameters (OrgGnomeMutterScreenCastStream *object)
{
  OrgGnomeMutterScreenCastStreamProxy *proxy = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Parameters");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
org_gnome_mutter_screen_cast_stream_proxy_init (OrgGnomeMutterScreenCastStreamProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_gnome_mutter_screen_cast_stream_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_PROXY, OrgGnomeMutterScreenCastStreamProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_gnome_mutter_screen_cast_stream_interface_info ());
}

static void
org_gnome_mutter_screen_cast_stream_proxy_class_init (OrgGnomeMutterScreenCastStreamProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_gnome_mutter_screen_cast_stream_proxy_finalize;
  gobject_class->get_property = org_gnome_mutter_screen_cast_stream_proxy_get_property;
  gobject_class->set_property = org_gnome_mutter_screen_cast_stream_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_gnome_mutter_screen_cast_stream_proxy_g_signal;
  proxy_class->g_properties_changed = org_gnome_mutter_screen_cast_stream_proxy_g_properties_changed;

  org_gnome_mutter_screen_cast_stream_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterScreenCastStreamProxyPrivate));
#endif
}

static void
org_gnome_mutter_screen_cast_stream_proxy_iface_init (OrgGnomeMutterScreenCastStreamIface *iface)
{
  iface->get_parameters = org_gnome_mutter_screen_cast_stream_proxy_get_parameters;
}

/**
 * org_gnome_mutter_screen_cast_stream_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_stream_proxy_new_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_stream_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_screen_cast_stream_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Stream", NULL);
}

/**
 * org_gnome_mutter_screen_cast_stream_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_stream_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_stream_proxy_new().
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastStreamProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCastStream *
org_gnome_mutter_screen_cast_stream_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST_STREAM (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_screen_cast_stream_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_stream_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastStreamProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCastStream *
org_gnome_mutter_screen_cast_stream_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Stream", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST_STREAM (ret);
  else
    return NULL;
}


/**
 * org_gnome_mutter_screen_cast_stream_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_gnome_mutter_screen_cast_stream_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_mutter_screen_cast_stream_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_gnome_mutter_screen_cast_stream_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_mutter_screen_cast_stream_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Stream", NULL);
}

/**
 * org_gnome_mutter_screen_cast_stream_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_mutter_screen_cast_stream_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_mutter_screen_cast_stream_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastStreamProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCastStream *
org_gnome_mutter_screen_cast_stream_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST_STREAM (ret);
  else
    return NULL;
}

/**
 * org_gnome_mutter_screen_cast_stream_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_gnome_mutter_screen_cast_stream_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_mutter_screen_cast_stream_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastStreamProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeMutterScreenCastStream *
org_gnome_mutter_screen_cast_stream_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Stream", NULL);
  if (ret != NULL)
    return ORG_GNOME_MUTTER_SCREEN_CAST_STREAM (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeMutterScreenCastStreamSkeleton:
 *
 * The #OrgGnomeMutterScreenCastStreamSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeMutterScreenCastStreamSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeMutterScreenCastStreamSkeleton.
 */

struct _OrgGnomeMutterScreenCastStreamSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_gnome_mutter_screen_cast_stream_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_gnome_mutter_screen_cast_stream_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_stream_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_gnome_mutter_screen_cast_stream_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_mutter_screen_cast_stream_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_gnome_mutter_screen_cast_stream_skeleton_vtable =
{
  _org_gnome_mutter_screen_cast_stream_skeleton_handle_method_call,
  _org_gnome_mutter_screen_cast_stream_skeleton_handle_get_property,
  _org_gnome_mutter_screen_cast_stream_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_gnome_mutter_screen_cast_stream_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_gnome_mutter_screen_cast_stream_interface_info ();
}

static GDBusInterfaceVTable *
org_gnome_mutter_screen_cast_stream_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_gnome_mutter_screen_cast_stream_skeleton_vtable;
}

static GVariant *
org_gnome_mutter_screen_cast_stream_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_gnome_mutter_screen_cast_stream_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_gnome_mutter_screen_cast_stream_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_gnome_mutter_screen_cast_stream_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_gnome_mutter_screen_cast_stream_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ScreenCast.Stream", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _org_gnome_mutter_screen_cast_stream_emit_changed (gpointer user_data);

static void
org_gnome_mutter_screen_cast_stream_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _org_gnome_mutter_screen_cast_stream_emit_changed (skeleton);
}

static void
_org_gnome_mutter_screen_cast_stream_on_signal_pipewire_stream_added (
    OrgGnomeMutterScreenCastStream *object,
    guint arg_node_id)
{
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u)",
                   arg_node_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ScreenCast.Stream", "PipeWireStreamAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_gnome_mutter_screen_cast_stream_skeleton_iface_init (OrgGnomeMutterScreenCastStreamIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastStreamSkeleton, org_gnome_mutter_screen_cast_stream_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgGnomeMutterScreenCastStreamSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM, org_gnome_mutter_screen_cast_stream_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeMutterScreenCastStreamSkeleton, org_gnome_mutter_screen_cast_stream_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM, org_gnome_mutter_screen_cast_stream_skeleton_iface_init))

#endif
static void
org_gnome_mutter_screen_cast_stream_skeleton_finalize (GObject *object)
{
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_gnome_mutter_screen_cast_stream_skeleton_parent_class)->finalize (object);
}

static void
org_gnome_mutter_screen_cast_stream_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_org_gnome_mutter_screen_cast_stream_emit_changed (gpointer user_data)
{
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.ScreenCast.Stream",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_org_gnome_mutter_screen_cast_stream_schedule_emit_changed (OrgGnomeMutterScreenCastStreamSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
org_gnome_mutter_screen_cast_stream_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _org_gnome_mutter_screen_cast_stream_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _org_gnome_mutter_screen_cast_stream_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
org_gnome_mutter_screen_cast_stream_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_mutter_screen_cast_stream_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _org_gnome_mutter_screen_cast_stream_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
org_gnome_mutter_screen_cast_stream_skeleton_init (OrgGnomeMutterScreenCastStreamSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_gnome_mutter_screen_cast_stream_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON, OrgGnomeMutterScreenCastStreamSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_VARIANT);
}

static GVariant *
org_gnome_mutter_screen_cast_stream_skeleton_get_parameters (OrgGnomeMutterScreenCastStream *object)
{
  OrgGnomeMutterScreenCastStreamSkeleton *skeleton = ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
org_gnome_mutter_screen_cast_stream_skeleton_class_init (OrgGnomeMutterScreenCastStreamSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_gnome_mutter_screen_cast_stream_skeleton_finalize;
  gobject_class->get_property = org_gnome_mutter_screen_cast_stream_skeleton_get_property;
  gobject_class->set_property = org_gnome_mutter_screen_cast_stream_skeleton_set_property;
  gobject_class->notify       = org_gnome_mutter_screen_cast_stream_skeleton_notify;


  org_gnome_mutter_screen_cast_stream_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_gnome_mutter_screen_cast_stream_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_gnome_mutter_screen_cast_stream_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_gnome_mutter_screen_cast_stream_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_gnome_mutter_screen_cast_stream_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeMutterScreenCastStreamSkeletonPrivate));
#endif
}

static void
org_gnome_mutter_screen_cast_stream_skeleton_iface_init (OrgGnomeMutterScreenCastStreamIface *iface)
{
  iface->pipewire_stream_added = _org_gnome_mutter_screen_cast_stream_on_signal_pipewire_stream_added;
  iface->get_parameters = org_gnome_mutter_screen_cast_stream_skeleton_get_parameters;
}

/**
 * org_gnome_mutter_screen_cast_stream_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link>.
 *
 * Returns: (transfer full) (type OrgGnomeMutterScreenCastStreamSkeleton): The skeleton object.
 */
OrgGnomeMutterScreenCastStream *
org_gnome_mutter_screen_cast_stream_skeleton_new (void)
{
  return ORG_GNOME_MUTTER_SCREEN_CAST_STREAM (g_object_new (TYPE_ORG_GNOME_MUTTER_SCREEN_CAST_STREAM_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Shell.Introspect
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgGnomeShellIntrospect
 * @title: OrgGnomeShellIntrospect
 * @short_description: Generated C code for the org.gnome.Shell.Introspect D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Shell-Introspect.top_of_page">org.gnome.Shell.Introspect</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Shell.Introspect ---- */

static const _ExtendedGDBusArgInfo _org_gnome_shell_introspect_method_info_get_running_applications_OUT_ARG_apps =
{
  {
    -1,
    (gchar *) "apps",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_introspect_method_info_get_running_applications_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_introspect_method_info_get_running_applications_OUT_ARG_apps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_introspect_method_info_get_running_applications =
{
  {
    -1,
    (gchar *) "GetRunningApplications",
    NULL,
    (GDBusArgInfo **) &_org_gnome_shell_introspect_method_info_get_running_applications_OUT_ARG_pointers,
    NULL
  },
  "handle-get-running-applications",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_introspect_method_info_get_windows_OUT_ARG_windows =
{
  {
    -1,
    (gchar *) "windows",
    (gchar *) "a{ta{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_introspect_method_info_get_windows_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_introspect_method_info_get_windows_OUT_ARG_windows.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_introspect_method_info_get_windows =
{
  {
    -1,
    (gchar *) "GetWindows",
    NULL,
    (GDBusArgInfo **) &_org_gnome_shell_introspect_method_info_get_windows_OUT_ARG_pointers,
    NULL
  },
  "handle-get-windows",
  FALSE
};

static const GDBusMethodInfo * const _org_gnome_shell_introspect_method_info_pointers[] =
{
  &_org_gnome_shell_introspect_method_info_get_running_applications.parent_struct,
  &_org_gnome_shell_introspect_method_info_get_windows.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_gnome_shell_introspect_signal_info_running_applications_changed =
{
  {
    -1,
    (gchar *) "RunningApplicationsChanged",
    NULL,
    NULL
  },
  "running-applications-changed"
};

static const GDBusSignalInfo * const _org_gnome_shell_introspect_signal_info_pointers[] =
{
  &_org_gnome_shell_introspect_signal_info_running_applications_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _org_gnome_shell_introspect_property_info_animations_enabled =
{
  {
    -1,
    (gchar *) "AnimationsEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "animations-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _org_gnome_shell_introspect_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _org_gnome_shell_introspect_property_info_pointers[] =
{
  &_org_gnome_shell_introspect_property_info_animations_enabled.parent_struct,
  &_org_gnome_shell_introspect_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_gnome_shell_introspect_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Shell.Introspect",
    (GDBusMethodInfo **) &_org_gnome_shell_introspect_method_info_pointers,
    (GDBusSignalInfo **) &_org_gnome_shell_introspect_signal_info_pointers,
    (GDBusPropertyInfo **) &_org_gnome_shell_introspect_property_info_pointers,
    NULL
  },
  "org-gnome-shell-introspect",
};


/**
 * org_gnome_shell_introspect_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Shell-Introspect.top_of_page">org.gnome.Shell.Introspect</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_gnome_shell_introspect_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_gnome_shell_introspect_interface_info.parent_struct;
}

/**
 * org_gnome_shell_introspect_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgGnomeShellIntrospect interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_gnome_shell_introspect_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "animations-enabled");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * OrgGnomeShellIntrospect:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Introspect.top_of_page">org.gnome.Shell.Introspect</link>.
 */

/**
 * OrgGnomeShellIntrospectIface:
 * @parent_iface: The parent interface.
 * @handle_get_running_applications: Handler for the #OrgGnomeShellIntrospect::handle-get-running-applications signal.
 * @handle_get_windows: Handler for the #OrgGnomeShellIntrospect::handle-get-windows signal.
 * @get_animations_enabled: Getter for the #OrgGnomeShellIntrospect:animations-enabled property.
 * @get_version: Getter for the #OrgGnomeShellIntrospect:version property.
 * @running_applications_changed: Handler for the #OrgGnomeShellIntrospect::running-applications-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Introspect.top_of_page">org.gnome.Shell.Introspect</link>.
 */

typedef OrgGnomeShellIntrospectIface OrgGnomeShellIntrospectInterface;
G_DEFINE_INTERFACE (OrgGnomeShellIntrospect, org_gnome_shell_introspect, G_TYPE_OBJECT)

static void
org_gnome_shell_introspect_default_init (OrgGnomeShellIntrospectIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgGnomeShellIntrospect::handle-get-running-applications:
   * @object: A #OrgGnomeShellIntrospect.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Introspect.GetRunningApplications">GetRunningApplications()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_introspect_complete_get_running_applications() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-running-applications",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellIntrospectIface, handle_get_running_applications),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeShellIntrospect::handle-get-windows:
   * @object: A #OrgGnomeShellIntrospect.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Introspect.GetWindows">GetWindows()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_introspect_complete_get_windows() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-windows",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellIntrospectIface, handle_get_windows),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgGnomeShellIntrospect::running-applications-changed:
   * @object: A #OrgGnomeShellIntrospect.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Shell-Introspect.RunningApplicationsChanged">"RunningApplicationsChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("running-applications-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellIntrospectIface, running_applications_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /* GObject properties for D-Bus properties: */
  /**
   * OrgGnomeShellIntrospect:animations-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Shell-Introspect.AnimationsEnabled">"AnimationsEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("animations-enabled", "AnimationsEnabled", "AnimationsEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * OrgGnomeShellIntrospect:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Shell-Introspect.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * org_gnome_shell_introspect_get_animations_enabled: (skip)
 * @object: A #OrgGnomeShellIntrospect.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Shell-Introspect.AnimationsEnabled">"AnimationsEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
org_gnome_shell_introspect_get_animations_enabled (OrgGnomeShellIntrospect *object)
{
  return ORG_GNOME_SHELL_INTROSPECT_GET_IFACE (object)->get_animations_enabled (object);
}

/**
 * org_gnome_shell_introspect_set_animations_enabled: (skip)
 * @object: A #OrgGnomeShellIntrospect.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Shell-Introspect.AnimationsEnabled">"AnimationsEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_gnome_shell_introspect_set_animations_enabled (OrgGnomeShellIntrospect *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "animations-enabled", value, NULL);
}

/**
 * org_gnome_shell_introspect_get_version: (skip)
 * @object: A #OrgGnomeShellIntrospect.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Shell-Introspect.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
org_gnome_shell_introspect_get_version (OrgGnomeShellIntrospect *object)
{
  return ORG_GNOME_SHELL_INTROSPECT_GET_IFACE (object)->get_version (object);
}

/**
 * org_gnome_shell_introspect_set_version: (skip)
 * @object: A #OrgGnomeShellIntrospect.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Shell-Introspect.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_gnome_shell_introspect_set_version (OrgGnomeShellIntrospect *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * org_gnome_shell_introspect_emit_running_applications_changed:
 * @object: A #OrgGnomeShellIntrospect.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Shell-Introspect.RunningApplicationsChanged">"RunningApplicationsChanged"</link> D-Bus signal.
 */
void
org_gnome_shell_introspect_emit_running_applications_changed (
    OrgGnomeShellIntrospect *object)
{
  g_signal_emit_by_name (object, "running-applications-changed");
}

/**
 * org_gnome_shell_introspect_call_get_running_applications:
 * @proxy: A #OrgGnomeShellIntrospectProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Introspect.GetRunningApplications">GetRunningApplications()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_introspect_call_get_running_applications_finish() to get the result of the operation.
 *
 * See org_gnome_shell_introspect_call_get_running_applications_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_introspect_call_get_running_applications (
    OrgGnomeShellIntrospect *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetRunningApplications",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_introspect_call_get_running_applications_finish:
 * @proxy: A #OrgGnomeShellIntrospectProxy.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_introspect_call_get_running_applications().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_introspect_call_get_running_applications().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_introspect_call_get_running_applications_finish (
    OrgGnomeShellIntrospect *proxy,
    GVariant **out_apps,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_introspect_call_get_running_applications_sync:
 * @proxy: A #OrgGnomeShellIntrospectProxy.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Introspect.GetRunningApplications">GetRunningApplications()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_introspect_call_get_running_applications() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_introspect_call_get_running_applications_sync (
    OrgGnomeShellIntrospect *proxy,
    GVariant **out_apps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetRunningApplications",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_introspect_call_get_windows:
 * @proxy: A #OrgGnomeShellIntrospectProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Introspect.GetWindows">GetWindows()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_introspect_call_get_windows_finish() to get the result of the operation.
 *
 * See org_gnome_shell_introspect_call_get_windows_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_introspect_call_get_windows (
    OrgGnomeShellIntrospect *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetWindows",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_introspect_call_get_windows_finish:
 * @proxy: A #OrgGnomeShellIntrospectProxy.
 * @out_windows: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_introspect_call_get_windows().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_introspect_call_get_windows().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_introspect_call_get_windows_finish (
    OrgGnomeShellIntrospect *proxy,
    GVariant **out_windows,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{ta{sv}})",
                 out_windows);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_introspect_call_get_windows_sync:
 * @proxy: A #OrgGnomeShellIntrospectProxy.
 * @out_windows: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Introspect.GetWindows">GetWindows()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_introspect_call_get_windows() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_introspect_call_get_windows_sync (
    OrgGnomeShellIntrospect *proxy,
    GVariant **out_windows,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetWindows",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{ta{sv}})",
                 out_windows);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_introspect_complete_get_running_applications:
 * @object: A #OrgGnomeShellIntrospect.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @apps: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Introspect.GetRunningApplications">GetRunningApplications()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_introspect_complete_get_running_applications (
    OrgGnomeShellIntrospect *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *apps)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sa{sv}})",
                   apps));
}

/**
 * org_gnome_shell_introspect_complete_get_windows:
 * @object: A #OrgGnomeShellIntrospect.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @windows: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Introspect.GetWindows">GetWindows()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_introspect_complete_get_windows (
    OrgGnomeShellIntrospect *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *windows)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{ta{sv}})",
                   windows));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeShellIntrospectProxy:
 *
 * The #OrgGnomeShellIntrospectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeShellIntrospectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeShellIntrospectProxy.
 */

struct _OrgGnomeShellIntrospectProxyPrivate
{
  GData *qdata;
};

static void org_gnome_shell_introspect_proxy_iface_init (OrgGnomeShellIntrospectIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellIntrospectProxy, org_gnome_shell_introspect_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgGnomeShellIntrospectProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_INTROSPECT, org_gnome_shell_introspect_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellIntrospectProxy, org_gnome_shell_introspect_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_INTROSPECT, org_gnome_shell_introspect_proxy_iface_init))

#endif
static void
org_gnome_shell_introspect_proxy_finalize (GObject *object)
{
  OrgGnomeShellIntrospectProxy *proxy = ORG_GNOME_SHELL_INTROSPECT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_gnome_shell_introspect_proxy_parent_class)->finalize (object);
}

static void
org_gnome_shell_introspect_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_shell_introspect_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
org_gnome_shell_introspect_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Shell.Introspect: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
org_gnome_shell_introspect_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_shell_introspect_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Shell.Introspect", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) org_gnome_shell_introspect_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
org_gnome_shell_introspect_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_gnome_shell_introspect_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_GNOME_SHELL_INTROSPECT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_SHELL_INTROSPECT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_gnome_shell_introspect_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgGnomeShellIntrospectProxy *proxy = ORG_GNOME_SHELL_INTROSPECT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_introspect_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_introspect_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
org_gnome_shell_introspect_proxy_get_animations_enabled (OrgGnomeShellIntrospect *object)
{
  OrgGnomeShellIntrospectProxy *proxy = ORG_GNOME_SHELL_INTROSPECT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AnimationsEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
org_gnome_shell_introspect_proxy_get_version (OrgGnomeShellIntrospect *object)
{
  OrgGnomeShellIntrospectProxy *proxy = ORG_GNOME_SHELL_INTROSPECT_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
org_gnome_shell_introspect_proxy_init (OrgGnomeShellIntrospectProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_gnome_shell_introspect_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_GNOME_SHELL_INTROSPECT_PROXY, OrgGnomeShellIntrospectProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_gnome_shell_introspect_interface_info ());
}

static void
org_gnome_shell_introspect_proxy_class_init (OrgGnomeShellIntrospectProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_gnome_shell_introspect_proxy_finalize;
  gobject_class->get_property = org_gnome_shell_introspect_proxy_get_property;
  gobject_class->set_property = org_gnome_shell_introspect_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_gnome_shell_introspect_proxy_g_signal;
  proxy_class->g_properties_changed = org_gnome_shell_introspect_proxy_g_properties_changed;

  org_gnome_shell_introspect_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeShellIntrospectProxyPrivate));
#endif
}

static void
org_gnome_shell_introspect_proxy_iface_init (OrgGnomeShellIntrospectIface *iface)
{
  iface->get_animations_enabled = org_gnome_shell_introspect_proxy_get_animations_enabled;
  iface->get_version = org_gnome_shell_introspect_proxy_get_version;
}

/**
 * org_gnome_shell_introspect_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Introspect.top_of_page">org.gnome.Shell.Introspect</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_introspect_proxy_new_finish() to get the result of the operation.
 *
 * See org_gnome_shell_introspect_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_shell_introspect_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_SHELL_INTROSPECT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Introspect", NULL);
}

/**
 * org_gnome_shell_introspect_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_introspect_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_shell_introspect_proxy_new().
 *
 * Returns: (transfer full) (type OrgGnomeShellIntrospectProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellIntrospect *
org_gnome_shell_introspect_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_SHELL_INTROSPECT (ret);
  else
    return NULL;
}

/**
 * org_gnome_shell_introspect_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Introspect.top_of_page">org.gnome.Shell.Introspect</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_introspect_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeShellIntrospectProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellIntrospect *
org_gnome_shell_introspect_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_SHELL_INTROSPECT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Introspect", NULL);
  if (ret != NULL)
    return ORG_GNOME_SHELL_INTROSPECT (ret);
  else
    return NULL;
}


/**
 * org_gnome_shell_introspect_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_gnome_shell_introspect_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_introspect_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_gnome_shell_introspect_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_shell_introspect_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_SHELL_INTROSPECT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Introspect", NULL);
}

/**
 * org_gnome_shell_introspect_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_introspect_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_shell_introspect_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgGnomeShellIntrospectProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellIntrospect *
org_gnome_shell_introspect_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_SHELL_INTROSPECT (ret);
  else
    return NULL;
}

/**
 * org_gnome_shell_introspect_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_gnome_shell_introspect_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_introspect_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeShellIntrospectProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellIntrospect *
org_gnome_shell_introspect_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_SHELL_INTROSPECT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Introspect", NULL);
  if (ret != NULL)
    return ORG_GNOME_SHELL_INTROSPECT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeShellIntrospectSkeleton:
 *
 * The #OrgGnomeShellIntrospectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeShellIntrospectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeShellIntrospectSkeleton.
 */

struct _OrgGnomeShellIntrospectSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_gnome_shell_introspect_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_GNOME_SHELL_INTROSPECT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_SHELL_INTROSPECT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_gnome_shell_introspect_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_introspect_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_gnome_shell_introspect_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_introspect_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_gnome_shell_introspect_skeleton_vtable =
{
  _org_gnome_shell_introspect_skeleton_handle_method_call,
  _org_gnome_shell_introspect_skeleton_handle_get_property,
  _org_gnome_shell_introspect_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_gnome_shell_introspect_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_gnome_shell_introspect_interface_info ();
}

static GDBusInterfaceVTable *
org_gnome_shell_introspect_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_gnome_shell_introspect_skeleton_vtable;
}

static GVariant *
org_gnome_shell_introspect_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_gnome_shell_introspect_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_gnome_shell_introspect_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_gnome_shell_introspect_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_gnome_shell_introspect_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Shell.Introspect", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _org_gnome_shell_introspect_emit_changed (gpointer user_data);

static void
org_gnome_shell_introspect_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _org_gnome_shell_introspect_emit_changed (skeleton);
}

static void
_org_gnome_shell_introspect_on_signal_running_applications_changed (
    OrgGnomeShellIntrospect *object)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Shell.Introspect", "RunningApplicationsChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_gnome_shell_introspect_skeleton_iface_init (OrgGnomeShellIntrospectIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellIntrospectSkeleton, org_gnome_shell_introspect_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgGnomeShellIntrospectSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_INTROSPECT, org_gnome_shell_introspect_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellIntrospectSkeleton, org_gnome_shell_introspect_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_INTROSPECT, org_gnome_shell_introspect_skeleton_iface_init))

#endif
static void
org_gnome_shell_introspect_skeleton_finalize (GObject *object)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_gnome_shell_introspect_skeleton_parent_class)->finalize (object);
}

static void
org_gnome_shell_introspect_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_org_gnome_shell_introspect_emit_changed (gpointer user_data)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Shell.Introspect",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_org_gnome_shell_introspect_schedule_emit_changed (OrgGnomeShellIntrospectSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
org_gnome_shell_introspect_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _org_gnome_shell_introspect_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _org_gnome_shell_introspect_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
org_gnome_shell_introspect_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _org_gnome_shell_introspect_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _org_gnome_shell_introspect_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
org_gnome_shell_introspect_skeleton_init (OrgGnomeShellIntrospectSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_gnome_shell_introspect_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_GNOME_SHELL_INTROSPECT_SKELETON, OrgGnomeShellIntrospectSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static gboolean 
org_gnome_shell_introspect_skeleton_get_animations_enabled (OrgGnomeShellIntrospect *object)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
org_gnome_shell_introspect_skeleton_get_version (OrgGnomeShellIntrospect *object)
{
  OrgGnomeShellIntrospectSkeleton *skeleton = ORG_GNOME_SHELL_INTROSPECT_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
org_gnome_shell_introspect_skeleton_class_init (OrgGnomeShellIntrospectSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_gnome_shell_introspect_skeleton_finalize;
  gobject_class->get_property = org_gnome_shell_introspect_skeleton_get_property;
  gobject_class->set_property = org_gnome_shell_introspect_skeleton_set_property;
  gobject_class->notify       = org_gnome_shell_introspect_skeleton_notify;


  org_gnome_shell_introspect_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_gnome_shell_introspect_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_gnome_shell_introspect_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_gnome_shell_introspect_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_gnome_shell_introspect_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeShellIntrospectSkeletonPrivate));
#endif
}

static void
org_gnome_shell_introspect_skeleton_iface_init (OrgGnomeShellIntrospectIface *iface)
{
  iface->running_applications_changed = _org_gnome_shell_introspect_on_signal_running_applications_changed;
  iface->get_animations_enabled = org_gnome_shell_introspect_skeleton_get_animations_enabled;
  iface->get_version = org_gnome_shell_introspect_skeleton_get_version;
}

/**
 * org_gnome_shell_introspect_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Introspect.top_of_page">org.gnome.Shell.Introspect</link>.
 *
 * Returns: (transfer full) (type OrgGnomeShellIntrospectSkeleton): The skeleton object.
 */
OrgGnomeShellIntrospect *
org_gnome_shell_introspect_skeleton_new (void)
{
  return ORG_GNOME_SHELL_INTROSPECT (g_object_new (TYPE_ORG_GNOME_SHELL_INTROSPECT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Shell.Screenshot
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgGnomeShellScreenshot
 * @title: OrgGnomeShellScreenshot
 * @short_description: Generated C code for the org.gnome.Shell.Screenshot D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Shell.Screenshot ---- */

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_include_cursor =
{
  {
    -1,
    (gchar *) "include_cursor",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_flash =
{
  {
    -1,
    (gchar *) "flash",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_include_cursor.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_flash.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_filename_used =
{
  {
    -1,
    (gchar *) "filename_used",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_success.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_filename_used.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_screenshot =
{
  {
    -1,
    (gchar *) "Screenshot",
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_OUT_ARG_pointers,
    NULL
  },
  "handle-screenshot",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_include_frame =
{
  {
    -1,
    (gchar *) "include_frame",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_include_cursor =
{
  {
    -1,
    (gchar *) "include_cursor",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_flash =
{
  {
    -1,
    (gchar *) "flash",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_include_frame.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_include_cursor.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_flash.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_filename_used =
{
  {
    -1,
    (gchar *) "filename_used",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_success.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_filename_used.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_screenshot_window =
{
  {
    -1,
    (gchar *) "ScreenshotWindow",
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_window_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_window_OUT_ARG_pointers,
    NULL
  },
  "handle-screenshot-window",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_flash =
{
  {
    -1,
    (gchar *) "flash",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_x.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_y.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_width.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_height.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_flash.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_filename_used =
{
  {
    -1,
    (gchar *) "filename_used",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_success.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_filename_used.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_screenshot_area =
{
  {
    -1,
    (gchar *) "ScreenshotArea",
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_area_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_screenshot_area_OUT_ARG_pointers,
    NULL
  },
  "handle-screenshot-area",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_x.parent_struct,
  &_org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_y.parent_struct,
  &_org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_width.parent_struct,
  &_org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_height.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_flash_area =
{
  {
    -1,
    (gchar *) "FlashArea",
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_flash_area_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-flash-area",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_x.parent_struct,
  &_org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_y.parent_struct,
  &_org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_width.parent_struct,
  &_org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_height.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_select_area =
{
  {
    -1,
    (gchar *) "SelectArea",
    NULL,
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_select_area_OUT_ARG_pointers,
    NULL
  },
  "handle-select-area",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_gnome_shell_screenshot_method_info_pick_color_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_gnome_shell_screenshot_method_info_pick_color_OUT_ARG_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_pick_color_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_gnome_shell_screenshot_method_info_pick_color =
{
  {
    -1,
    (gchar *) "PickColor",
    NULL,
    (GDBusArgInfo **) &_org_gnome_shell_screenshot_method_info_pick_color_OUT_ARG_pointers,
    NULL
  },
  "handle-pick-color",
  FALSE
};

static const GDBusMethodInfo * const _org_gnome_shell_screenshot_method_info_pointers[] =
{
  &_org_gnome_shell_screenshot_method_info_screenshot.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_window.parent_struct,
  &_org_gnome_shell_screenshot_method_info_screenshot_area.parent_struct,
  &_org_gnome_shell_screenshot_method_info_flash_area.parent_struct,
  &_org_gnome_shell_screenshot_method_info_select_area.parent_struct,
  &_org_gnome_shell_screenshot_method_info_pick_color.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_gnome_shell_screenshot_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Shell.Screenshot",
    (GDBusMethodInfo **) &_org_gnome_shell_screenshot_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "org-gnome-shell-screenshot",
};


/**
 * org_gnome_shell_screenshot_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_gnome_shell_screenshot_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct;
}

/**
 * org_gnome_shell_screenshot_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgGnomeShellScreenshot interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_gnome_shell_screenshot_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * OrgGnomeShellScreenshot:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>.
 */

/**
 * OrgGnomeShellScreenshotIface:
 * @parent_iface: The parent interface.
 * @handle_flash_area: Handler for the #OrgGnomeShellScreenshot::handle-flash-area signal.
 * @handle_pick_color: Handler for the #OrgGnomeShellScreenshot::handle-pick-color signal.
 * @handle_screenshot: Handler for the #OrgGnomeShellScreenshot::handle-screenshot signal.
 * @handle_screenshot_area: Handler for the #OrgGnomeShellScreenshot::handle-screenshot-area signal.
 * @handle_screenshot_window: Handler for the #OrgGnomeShellScreenshot::handle-screenshot-window signal.
 * @handle_select_area: Handler for the #OrgGnomeShellScreenshot::handle-select-area signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>.
 */

typedef OrgGnomeShellScreenshotIface OrgGnomeShellScreenshotInterface;
G_DEFINE_INTERFACE (OrgGnomeShellScreenshot, org_gnome_shell_screenshot, G_TYPE_OBJECT)

static void
org_gnome_shell_screenshot_default_init (OrgGnomeShellScreenshotIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgGnomeShellScreenshot::handle-screenshot:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_include_cursor: Argument passed by remote caller.
   * @arg_flash: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_screenshot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_screenshot),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_STRING);

  /**
   * OrgGnomeShellScreenshot::handle-screenshot-window:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_include_frame: Argument passed by remote caller.
   * @arg_include_cursor: Argument passed by remote caller.
   * @arg_flash: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_screenshot_window() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot-window",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_screenshot_window),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_STRING);

  /**
   * OrgGnomeShellScreenshot::handle-screenshot-area:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   * @arg_flash: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_screenshot_area() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot-area",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_screenshot_area),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_BOOLEAN, G_TYPE_STRING);

  /**
   * OrgGnomeShellScreenshot::handle-flash-area:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_flash_area() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-flash-area",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_flash_area),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);

  /**
   * OrgGnomeShellScreenshot::handle-select-area:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_select_area() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-area",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_select_area),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgGnomeShellScreenshot::handle-pick-color:
   * @object: A #OrgGnomeShellScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_gnome_shell_screenshot_complete_pick_color() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pick-color",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgGnomeShellScreenshotIface, handle_pick_color),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * org_gnome_shell_screenshot_call_screenshot:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_screenshot_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_screenshot_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_screenshot (
    OrgGnomeShellScreenshot *proxy,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(bbs)",
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_screenshot_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_screenshot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_screenshot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_finish (
    OrgGnomeShellScreenshot *proxy,
    gboolean *out_success,
    gchar **out_filename_used,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_screenshot_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_screenshot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_sync (
    OrgGnomeShellScreenshot *proxy,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    gboolean *out_success,
    gchar **out_filename_used,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(bbs)",
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_screenshot_window:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_include_frame: Argument to pass with the method invocation.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_screenshot_window_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_screenshot_window_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_screenshot_window (
    OrgGnomeShellScreenshot *proxy,
    gboolean arg_include_frame,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ScreenshotWindow",
    g_variant_new ("(bbbs)",
                   arg_include_frame,
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_screenshot_window_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_screenshot_window().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_screenshot_window().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_window_finish (
    OrgGnomeShellScreenshot *proxy,
    gboolean *out_success,
    gchar **out_filename_used,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_screenshot_window_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_include_frame: Argument to pass with the method invocation.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_screenshot_window() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_window_sync (
    OrgGnomeShellScreenshot *proxy,
    gboolean arg_include_frame,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    gboolean *out_success,
    gchar **out_filename_used,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ScreenshotWindow",
    g_variant_new ("(bbbs)",
                   arg_include_frame,
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_screenshot_area:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_screenshot_area_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_screenshot_area_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_screenshot_area (
    OrgGnomeShellScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    gboolean arg_flash,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ScreenshotArea",
    g_variant_new ("(iiiibs)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_screenshot_area_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_screenshot_area().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_screenshot_area().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_area_finish (
    OrgGnomeShellScreenshot *proxy,
    gboolean *out_success,
    gchar **out_filename_used,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_screenshot_area_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_screenshot_area() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_screenshot_area_sync (
    OrgGnomeShellScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    gboolean arg_flash,
    const gchar *arg_filename,
    gboolean *out_success,
    gchar **out_filename_used,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ScreenshotArea",
    g_variant_new ("(iiiibs)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_flash_area:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_flash_area_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_flash_area_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_flash_area (
    OrgGnomeShellScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FlashArea",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_flash_area_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_flash_area().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_flash_area().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_flash_area_finish (
    OrgGnomeShellScreenshot *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_flash_area_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_flash_area() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_flash_area_sync (
    OrgGnomeShellScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FlashArea",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_select_area:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_select_area_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_select_area_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_select_area (
    OrgGnomeShellScreenshot *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectArea",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_select_area_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_x: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_y: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_width: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_height: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_select_area().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_select_area().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_select_area_finish (
    OrgGnomeShellScreenshot *proxy,
    gint *out_x,
    gint *out_y,
    gint *out_width,
    gint *out_height,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iiii)",
                 out_x,
                 out_y,
                 out_width,
                 out_height);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_select_area_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_x: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_y: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_width: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_height: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_select_area() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_select_area_sync (
    OrgGnomeShellScreenshot *proxy,
    gint *out_x,
    gint *out_y,
    gint *out_width,
    gint *out_height,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectArea",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iiii)",
                 out_x,
                 out_y,
                 out_width,
                 out_height);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_pick_color:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_call_pick_color_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_call_pick_color_sync() for the synchronous, blocking version of this method.
 */
void
org_gnome_shell_screenshot_call_pick_color (
    OrgGnomeShellScreenshot *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_gnome_shell_screenshot_call_pick_color_finish:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_call_pick_color().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_gnome_shell_screenshot_call_pick_color().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_pick_color_finish (
    OrgGnomeShellScreenshot *proxy,
    GVariant **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_call_pick_color_sync:
 * @proxy: A #OrgGnomeShellScreenshotProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_call_pick_color() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_gnome_shell_screenshot_call_pick_color_sync (
    OrgGnomeShellScreenshot *proxy,
    GVariant **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_gnome_shell_screenshot_complete_screenshot:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 * @filename_used: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_screenshot (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success,
    const gchar *filename_used)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bs)",
                   success,
                   filename_used));
}

/**
 * org_gnome_shell_screenshot_complete_screenshot_window:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 * @filename_used: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_screenshot_window (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success,
    const gchar *filename_used)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bs)",
                   success,
                   filename_used));
}

/**
 * org_gnome_shell_screenshot_complete_screenshot_area:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 * @filename_used: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_screenshot_area (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success,
    const gchar *filename_used)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bs)",
                   success,
                   filename_used));
}

/**
 * org_gnome_shell_screenshot_complete_flash_area:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_flash_area (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_gnome_shell_screenshot_complete_select_area:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @x: Parameter to return.
 * @y: Parameter to return.
 * @width: Parameter to return.
 * @height: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_select_area (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint x,
    gint y,
    gint width,
    gint height)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(iiii)",
                   x,
                   y,
                   width,
                   height));
}

/**
 * org_gnome_shell_screenshot_complete_pick_color:
 * @object: A #OrgGnomeShellScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_gnome_shell_screenshot_complete_pick_color (
    OrgGnomeShellScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   result));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeShellScreenshotProxy:
 *
 * The #OrgGnomeShellScreenshotProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeShellScreenshotProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeShellScreenshotProxy.
 */

struct _OrgGnomeShellScreenshotProxyPrivate
{
  GData *qdata;
};

static void org_gnome_shell_screenshot_proxy_iface_init (OrgGnomeShellScreenshotIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellScreenshotProxy, org_gnome_shell_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgGnomeShellScreenshotProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_SCREENSHOT, org_gnome_shell_screenshot_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellScreenshotProxy, org_gnome_shell_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_SCREENSHOT, org_gnome_shell_screenshot_proxy_iface_init))

#endif
static void
org_gnome_shell_screenshot_proxy_finalize (GObject *object)
{
  OrgGnomeShellScreenshotProxy *proxy = ORG_GNOME_SHELL_SCREENSHOT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_gnome_shell_screenshot_proxy_parent_class)->finalize (object);
}

static void
org_gnome_shell_screenshot_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_gnome_shell_screenshot_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_gnome_shell_screenshot_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_GNOME_SHELL_SCREENSHOT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_SHELL_SCREENSHOT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_gnome_shell_screenshot_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgGnomeShellScreenshotProxy *proxy = ORG_GNOME_SHELL_SCREENSHOT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
org_gnome_shell_screenshot_proxy_init (OrgGnomeShellScreenshotProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_gnome_shell_screenshot_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_GNOME_SHELL_SCREENSHOT_PROXY, OrgGnomeShellScreenshotProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_gnome_shell_screenshot_interface_info ());
}

static void
org_gnome_shell_screenshot_proxy_class_init (OrgGnomeShellScreenshotProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_gnome_shell_screenshot_proxy_finalize;
  gobject_class->get_property = org_gnome_shell_screenshot_proxy_get_property;
  gobject_class->set_property = org_gnome_shell_screenshot_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_gnome_shell_screenshot_proxy_g_signal;
  proxy_class->g_properties_changed = org_gnome_shell_screenshot_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeShellScreenshotProxyPrivate));
#endif
}

static void
org_gnome_shell_screenshot_proxy_iface_init (OrgGnomeShellScreenshotIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_gnome_shell_screenshot_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_proxy_new_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_shell_screenshot_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_SHELL_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
}

/**
 * org_gnome_shell_screenshot_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_shell_screenshot_proxy_new().
 *
 * Returns: (transfer full) (type OrgGnomeShellScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellScreenshot *
org_gnome_shell_screenshot_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_SHELL_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * org_gnome_shell_screenshot_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeShellScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellScreenshot *
org_gnome_shell_screenshot_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_SHELL_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
  if (ret != NULL)
    return ORG_GNOME_SHELL_SCREENSHOT (ret);
  else
    return NULL;
}


/**
 * org_gnome_shell_screenshot_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_gnome_shell_screenshot_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_gnome_shell_screenshot_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_gnome_shell_screenshot_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_gnome_shell_screenshot_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_GNOME_SHELL_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
}

/**
 * org_gnome_shell_screenshot_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_gnome_shell_screenshot_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_gnome_shell_screenshot_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgGnomeShellScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellScreenshot *
org_gnome_shell_screenshot_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_GNOME_SHELL_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * org_gnome_shell_screenshot_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_gnome_shell_screenshot_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_gnome_shell_screenshot_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgGnomeShellScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgGnomeShellScreenshot *
org_gnome_shell_screenshot_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_GNOME_SHELL_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
  if (ret != NULL)
    return ORG_GNOME_SHELL_SCREENSHOT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgGnomeShellScreenshotSkeleton:
 *
 * The #OrgGnomeShellScreenshotSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgGnomeShellScreenshotSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgGnomeShellScreenshotSkeleton.
 */

struct _OrgGnomeShellScreenshotSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_gnome_shell_screenshot_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgGnomeShellScreenshotSkeleton *skeleton = ORG_GNOME_SHELL_SCREENSHOT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_GNOME_SHELL_SCREENSHOT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_GNOME_SHELL_SCREENSHOT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_gnome_shell_screenshot_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgGnomeShellScreenshotSkeleton *skeleton = ORG_GNOME_SHELL_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_gnome_shell_screenshot_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgGnomeShellScreenshotSkeleton *skeleton = ORG_GNOME_SHELL_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_gnome_shell_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_gnome_shell_screenshot_skeleton_vtable =
{
  _org_gnome_shell_screenshot_skeleton_handle_method_call,
  _org_gnome_shell_screenshot_skeleton_handle_get_property,
  _org_gnome_shell_screenshot_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_gnome_shell_screenshot_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_gnome_shell_screenshot_interface_info ();
}

static GDBusInterfaceVTable *
org_gnome_shell_screenshot_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_gnome_shell_screenshot_skeleton_vtable;
}

static GVariant *
org_gnome_shell_screenshot_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgGnomeShellScreenshotSkeleton *skeleton = ORG_GNOME_SHELL_SCREENSHOT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_gnome_shell_screenshot_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_gnome_shell_screenshot_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_gnome_shell_screenshot_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_gnome_shell_screenshot_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Shell.Screenshot", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
org_gnome_shell_screenshot_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void org_gnome_shell_screenshot_skeleton_iface_init (OrgGnomeShellScreenshotIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellScreenshotSkeleton, org_gnome_shell_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgGnomeShellScreenshotSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_SCREENSHOT, org_gnome_shell_screenshot_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgGnomeShellScreenshotSkeleton, org_gnome_shell_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_GNOME_SHELL_SCREENSHOT, org_gnome_shell_screenshot_skeleton_iface_init))

#endif
static void
org_gnome_shell_screenshot_skeleton_finalize (GObject *object)
{
  OrgGnomeShellScreenshotSkeleton *skeleton = ORG_GNOME_SHELL_SCREENSHOT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_gnome_shell_screenshot_skeleton_parent_class)->finalize (object);
}

static void
org_gnome_shell_screenshot_skeleton_init (OrgGnomeShellScreenshotSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_gnome_shell_screenshot_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_GNOME_SHELL_SCREENSHOT_SKELETON, OrgGnomeShellScreenshotSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
org_gnome_shell_screenshot_skeleton_class_init (OrgGnomeShellScreenshotSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_gnome_shell_screenshot_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_gnome_shell_screenshot_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_gnome_shell_screenshot_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_gnome_shell_screenshot_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_gnome_shell_screenshot_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgGnomeShellScreenshotSkeletonPrivate));
#endif
}

static void
org_gnome_shell_screenshot_skeleton_iface_init (OrgGnomeShellScreenshotIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_gnome_shell_screenshot_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>.
 *
 * Returns: (transfer full) (type OrgGnomeShellScreenshotSkeleton): The skeleton object.
 */
OrgGnomeShellScreenshot *
org_gnome_shell_screenshot_skeleton_new (void)
{
  return ORG_GNOME_SHELL_SCREENSHOT (g_object_new (TYPE_ORG_GNOME_SHELL_SCREENSHOT_SKELETON, NULL));
}

