/* search-provider.c generated by valac 0.56.3, the Vala compiler
 * generated from search-provider.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2013 Giovanni Campagna <scampa.giovanni@gmail.com>
 * Copyright (C) 2018 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <gcr/gcr-base.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "seahorse-common.h"
#include <libsecret/secret.h>
#include <stdio.h>
#include <gtk/gtk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SEAHORSE_TYPE_SEARCH_PROVIDER (seahorse_search_provider_get_type ())
#define SEAHORSE_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_SEARCH_PROVIDER, SeahorseSearchProvider))
#define SEAHORSE_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_SEARCH_PROVIDER, SeahorseSearchProviderClass))
#define SEAHORSE_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_SEARCH_PROVIDER))
#define SEAHORSE_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_SEARCH_PROVIDER))
#define SEAHORSE_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_SEARCH_PROVIDER, SeahorseSearchProviderClass))

typedef struct _SeahorseSearchProvider SeahorseSearchProvider;
typedef struct _SeahorseSearchProviderClass SeahorseSearchProviderClass;
typedef struct _SeahorseSearchProviderPrivate SeahorseSearchProviderPrivate;
enum  {
	SEAHORSE_SEARCH_PROVIDER_0_PROPERTY,
	SEAHORSE_SEARCH_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* seahorse_search_provider_properties[SEAHORSE_SEARCH_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
typedef struct _SeahorseSearchProviderLoadData SeahorseSearchProviderLoadData;
typedef struct _seahorse_search_provider_GetInitialResultSetData seahorse_search_provider_GetInitialResultSetData;
typedef struct _seahorse_search_provider_GetSubsearchResultSetData seahorse_search_provider_GetSubsearchResultSetData;
typedef struct _seahorse_search_provider_GetResultMetasData seahorse_search_provider_GetResultMetasData;

#define SEAHORSE_TYPE_KEY_MANAGER (seahorse_key_manager_get_type ())
#define SEAHORSE_KEY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_KEY_MANAGER, SeahorseKeyManager))
#define SEAHORSE_KEY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_KEY_MANAGER, SeahorseKeyManagerClass))
#define SEAHORSE_IS_KEY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_KEY_MANAGER))
#define SEAHORSE_IS_KEY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_KEY_MANAGER))
#define SEAHORSE_KEY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_KEY_MANAGER, SeahorseKeyManagerClass))

typedef struct _SeahorseKeyManager SeahorseKeyManager;
typedef struct _SeahorseKeyManagerClass SeahorseKeyManagerClass;

#define SEAHORSE_TYPE_APPLICATION (seahorse_application_get_type ())
#define SEAHORSE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_APPLICATION, SeahorseApplication))
#define SEAHORSE_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_APPLICATION, SeahorseApplicationClass))
#define SEAHORSE_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_APPLICATION))
#define SEAHORSE_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_APPLICATION))
#define SEAHORSE_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_APPLICATION, SeahorseApplicationClass))

typedef struct _SeahorseApplication SeahorseApplication;
typedef struct _SeahorseApplicationClass SeahorseApplicationClass;
typedef struct _SeahorseSearchProviderLoadReadyData SeahorseSearchProviderLoadReadyData;
typedef struct _seahorse_search_provider_GetInitialResultSetReadyData seahorse_search_provider_GetInitialResultSetReadyData;
typedef struct _seahorse_search_provider_GetSubsearchResultSetReadyData seahorse_search_provider_GetSubsearchResultSetReadyData;
typedef struct _seahorse_search_provider_GetResultMetasReadyData seahorse_search_provider_GetResultMetasReadyData;

struct _SeahorseSearchProvider {
	GObject parent_instance;
	SeahorseSearchProviderPrivate * priv;
};

struct _SeahorseSearchProviderClass {
	GObjectClass parent_class;
};

struct _SeahorseSearchProviderPrivate {
	GcrUnionCollection* union_collection;
	GHashTable* handles;
	GcrFilterCollection* collection;
	GApplication* app;
	gint n_loading;
	GRWLock n_loading_lock;
	gboolean loaded;
};

struct _Block4Data {
	int _ref_count_;
	SeahorseSearchProvider* self;
	gpointer _async_data_;
};

struct _SeahorseSearchProviderLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSearchProvider* self;
	Block4Data* _data4_;
	gboolean _tmp0_;
	gulong wait;
	gulong _tmp1_;
	GList* backends;
	GList* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* backend_collection;
	GList* backend_it;
	SeahorseBackend* _tmp5_;
	SeahorseBackend* backend;
	SeahorseBackend* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	SeahorseBackend* _tmp9_;
	SeahorseBackend* _tmp10_;
	SeahorseBackend* _tmp11_;
	SeahorseBackend* _tmp12_;
	GList* _tmp13_;
	GList* place_collection;
	GList* place_it;
	GObject* _tmp14_;
	GObject* place;
	SeahorseBackend* _tmp15_;
	GObject* _tmp16_;
};

struct _seahorse_search_provider_GetInitialResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	GApplication* _tmp0_;
	gchar** results;
	gchar** _tmp1_;
	gint results_length1;
	gint _results_size_;
	GcrFilterCollection* _tmp2_;
	GList* _tmp3_;
	GList* obj_collection;
	GList* obj_it;
	GObject* obj;
	GObject* _tmp4_;
	gchar* str;
	GObject* _tmp5_;
	gchar* _tmp6_;
	GHashTable* _tmp7_;
	const gchar* _tmp8_;
	GHashTable* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GObject* _tmp12_;
	GObject* _tmp13_;
	gchar* _tmp14_;
	GApplication* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GError* _inner_error0_;
};

struct _seahorse_search_provider_GetSubsearchResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSearchProvider* self;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** new_terms;
	gint new_terms_length1;
	gchar** result;
	gint result_length1;
	GApplication* _tmp0_;
	gchar** results;
	gchar** _tmp1_;
	gint results_length1;
	gint _results_size_;
	gchar** previous_result_collection;
	gint previous_result_collection_length1;
	gint _previous_result_collection_size_;
	gint previous_result_it;
	gchar* _tmp2_;
	gchar* previous_result;
	GObject* object;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_;
	gboolean _tmp6_;
	GObject* _tmp7_;
	GcrFilterCollection* _tmp8_;
	GObject* _tmp9_;
	GObject* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GApplication* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
};

struct _seahorse_search_provider_GetResultMetasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSearchProvider* self;
	gchar** results;
	gint results_length1;
	GHashTable** result;
	gint result_length1;
	GApplication* _tmp0_;
	GHashTable** metas;
	GHashTable** _tmp1_;
	gint metas_length1;
	gint _metas_size_;
	gint good_results;
	gchar** result_collection;
	gint result_collection_length1;
	gint _result_collection_size_;
	gint result_it;
	const gchar* _result_;
	GObject* object;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_;
	gboolean _tmp5_;
	GObject* _tmp6_;
	GcrFilterCollection* _tmp7_;
	GObject* _tmp8_;
	GHashTable* meta;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	GVariant* _tmp15_;
	gchar* label;
	GObject* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	GHashTable* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	GVariant* _tmp22_;
	GIcon* icon;
	GObject* _tmp23_;
	GIcon* _tmp24_;
	GIcon* _tmp25_;
	GHashTable* _tmp26_;
	gchar* _tmp27_;
	GIcon* _tmp28_;
	GVariant* _tmp29_;
	gchar* description;
	GObject* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	GHashTable* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	GVariant* _tmp36_;
	GHashTable** _tmp37_;
	gint _tmp37__length1;
	GHashTable* _tmp38_;
	GHashTable* _tmp39_;
	gint _tmp40_;
	GApplication* _tmp41_;
	GHashTable** _tmp42_;
	gint _tmp42__length1;
	GHashTable** _tmp43_;
	gint _tmp43__length1;
	GHashTable** _tmp44_;
	gint _tmp44__length1;
};

struct _SeahorseSearchProviderLoadReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _seahorse_search_provider_GetInitialResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** terms;
	gint terms_length1;
};

struct _seahorse_search_provider_GetSubsearchResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** new_terms;
	gint new_terms_length1;
};

struct _seahorse_search_provider_GetResultMetasReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** results;
	gint results_length1;
};

static gint SeahorseSearchProvider_private_offset;
static gpointer seahorse_search_provider_parent_class = NULL;

VALA_EXTERN GType seahorse_search_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSearchProvider, g_object_unref)
VALA_EXTERN guint seahorse_search_provider_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
static void _seahorse_search_provider___lambda23_ (SeahorseSearchProvider* self,
                                            const gchar* __,
                                            GObject* obj);
static void seahorse_search_provider_on_object_gone (SeahorseSearchProvider* self,
                                              GObject* where_the_object_was);
static void _seahorse_search_provider_on_object_gone_gweak_notify (gpointer self,
                                                            GObject* object);
static void __seahorse_search_provider___lambda23__gh_func (gconstpointer key,
                                                     gconstpointer value,
                                                     gpointer self);
static void _g_free_gdestroy_notify (void* data);
VALA_EXTERN SeahorseSearchProvider* seahorse_search_provider_new (GApplication* app);
VALA_EXTERN SeahorseSearchProvider* seahorse_search_provider_construct (GType object_type,
                                                            GApplication* app);
static gboolean seahorse_search_provider_filter_objects (GObject* obj);
static gboolean _seahorse_search_provider_filter_objects_gcr_filter_collection_func (GObject* object,
                                                                              gpointer self);
static void seahorse_search_provider_load_data_free (gpointer _data);
VALA_EXTERN void seahorse_search_provider_load (SeahorseSearchProvider* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void seahorse_search_provider_load_finish (SeahorseSearchProvider* self,
                                           GAsyncResult* _res_,
                                           GError** error);
static gboolean seahorse_search_provider_load_co (SeahorseSearchProviderLoadData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gint seahorse_search_provider_get_n_loading (SeahorseSearchProvider* self);
static void ___lambda4_ (Block4Data* _data4_);
static void ____lambda4__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void _____lambda5_ (SeahorseSearchProvider* self);
static void seahorse_search_provider_change_n_loading (SeahorseSearchProvider* self,
                                                gint diff);
static void ______lambda5__g_object_notify (GObject* _sender,
                                     GParamSpec* pspec,
                                     gpointer self);
static void seahorse_search_provider_on_place_added (SeahorseSearchProvider* self,
                                              GcrCollection* places,
                                              GObject* object);
static void _seahorse_search_provider_on_place_added_gcr_collection_added (GcrCollection* _sender,
                                                                    GObject* object,
                                                                    gpointer self);
static void seahorse_search_provider_on_place_removed (SeahorseSearchProvider* self,
                                                GcrCollection* places,
                                                GObject* object);
static void _seahorse_search_provider_on_place_removed_gcr_collection_removed (GcrCollection* _sender,
                                                                        GObject* object,
                                                                        gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void seahorse_search_provider_GetInitialResultSet_data_free (gpointer _data);
VALA_EXTERN void seahorse_search_provider_GetInitialResultSet (SeahorseSearchProvider* self,
                                                   gchar** terms,
                                                   gint terms_length1,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN gchar** seahorse_search_provider_GetInitialResultSet_finish (SeahorseSearchProvider* self,
                                                             GAsyncResult* _res_,
                                                             gint* result_length1,
                                                             GError** error);
static gboolean seahorse_search_provider_GetInitialResultSet_co (seahorse_search_provider_GetInitialResultSetData* _data_);
static void seahorse_search_provider_GetInitialResultSet_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static gboolean seahorse_search_provider_object_matches_search (SeahorseSearchProvider* self,
                                                         GObject* object,
                                                         gchar** terms,
                                                         gint terms_length1);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void seahorse_search_provider_GetSubsearchResultSet_data_free (gpointer _data);
VALA_EXTERN void seahorse_search_provider_GetSubsearchResultSet (SeahorseSearchProvider* self,
                                                     gchar** previous_results,
                                                     gint previous_results_length1,
                                                     gchar** new_terms,
                                                     gint new_terms_length1,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN gchar** seahorse_search_provider_GetSubsearchResultSet_finish (SeahorseSearchProvider* self,
                                                               GAsyncResult* _res_,
                                                               gint* result_length1,
                                                               GError** error);
static gboolean seahorse_search_provider_GetSubsearchResultSet_co (seahorse_search_provider_GetSubsearchResultSetData* _data_);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void seahorse_search_provider_GetResultMetas_data_free (gpointer _data);
VALA_EXTERN void seahorse_search_provider_GetResultMetas (SeahorseSearchProvider* self,
                                              gchar** results,
                                              gint results_length1,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN GHashTable** seahorse_search_provider_GetResultMetas_finish (SeahorseSearchProvider* self,
                                                             GAsyncResult* _res_,
                                                             gint* result_length1,
                                                             GError** error);
static gboolean seahorse_search_provider_GetResultMetas_co (seahorse_search_provider_GetResultMetasData* _data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
static gchar* seahorse_search_provider_get_description_if_available (GObject* obj);
static GVariant* _variant_new4 (const gchar* value);
static GHashTable** _vala_array_dup1 (GHashTable** self,
                               gssize length);
VALA_EXTERN void seahorse_search_provider_ActivateResult (SeahorseSearchProvider* self,
                                              const gchar* identifier,
                                              gchar** terms,
                                              gint terms_length1,
                                              guint32 timestamp,
                                              GError** error);
VALA_EXTERN GType seahorse_key_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseKeyManager, g_object_unref)
VALA_EXTERN GType seahorse_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseApplication, g_object_unref)
VALA_EXTERN SeahorseKeyManager* seahorse_key_manager_new (SeahorseApplication* app);
VALA_EXTERN SeahorseKeyManager* seahorse_key_manager_construct (GType object_type,
                                                    SeahorseApplication* app);
VALA_EXTERN void seahorse_search_provider_LaunchSearch (SeahorseSearchProvider* self,
                                            gchar** terms,
                                            gint terms_length1,
                                            guint32 timestamp,
                                            GError** error);
static gboolean seahorse_search_provider_object_contains_filtered_text (SeahorseSearchProvider* self,
                                                                 GObject* object,
                                                                 const gchar* text);
static void seahorse_search_provider_finalize (GObject * obj);
static GType seahorse_search_provider_get_type_once (void);
static void _dbus_seahorse_search_provider_load (SeahorseSearchProvider* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_seahorse_search_provider_load_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_);
static void _dbus_seahorse_search_provider_GetInitialResultSet (SeahorseSearchProvider* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void _dbus_seahorse_search_provider_GetInitialResultSet_ready (GObject * source_object,
                                                               GAsyncResult * _res_,
                                                               gpointer _user_data_);
static void _dbus_seahorse_search_provider_GetSubsearchResultSet (SeahorseSearchProvider* self,
                                                           GVariant* _parameters_,
                                                           GDBusMethodInvocation* invocation);
static void _dbus_seahorse_search_provider_GetSubsearchResultSet_ready (GObject * source_object,
                                                                 GAsyncResult * _res_,
                                                                 gpointer _user_data_);
static void _dbus_seahorse_search_provider_GetResultMetas (SeahorseSearchProvider* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void _dbus_seahorse_search_provider_GetResultMetas_ready (GObject * source_object,
                                                          GAsyncResult * _res_,
                                                          gpointer _user_data_);
static void _dbus_seahorse_search_provider_ActivateResult (SeahorseSearchProvider* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void _dbus_seahorse_search_provider_LaunchSearch (SeahorseSearchProvider* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void seahorse_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* method_name,
                                                          GVariant* parameters,
                                                          GDBusMethodInvocation* invocation,
                                                          gpointer user_data);
static GVariant* seahorse_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GError** error,
                                                                gpointer user_data);
static gboolean seahorse_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GVariant* value,
                                                               GError** error,
                                                               gpointer user_data);
static void _seahorse_search_provider_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_load_in[] = {NULL};
static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_load_out[] = {NULL};
static const GDBusMethodInfo _seahorse_search_provider_dbus_method_info_load = {-1, "Load", (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_load_in), (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_load_out), NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_GetInitialResultSet_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_GetInitialResultSet_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_GetInitialResultSet_in[] = {&_seahorse_search_provider_dbus_arg_info_GetInitialResultSet_terms, NULL};
static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_GetInitialResultSet_out[] = {&_seahorse_search_provider_dbus_arg_info_GetInitialResultSet_result, NULL};
static const GDBusMethodInfo _seahorse_search_provider_dbus_method_info_GetInitialResultSet = {-1, "GetInitialResultSet", (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_GetInitialResultSet_in), (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_GetInitialResultSet_out), NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_GetSubsearchResultSet_previous_results = {-1, "previous_results", "as", NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_GetSubsearchResultSet_new_terms = {-1, "new_terms", "as", NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_GetSubsearchResultSet_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_GetSubsearchResultSet_in[] = {&_seahorse_search_provider_dbus_arg_info_GetSubsearchResultSet_previous_results, &_seahorse_search_provider_dbus_arg_info_GetSubsearchResultSet_new_terms, NULL};
static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_GetSubsearchResultSet_out[] = {&_seahorse_search_provider_dbus_arg_info_GetSubsearchResultSet_result, NULL};
static const GDBusMethodInfo _seahorse_search_provider_dbus_method_info_GetSubsearchResultSet = {-1, "GetSubsearchResultSet", (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_GetSubsearchResultSet_in), (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_GetSubsearchResultSet_out), NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_GetResultMetas_results = {-1, "results", "as", NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_GetResultMetas_result = {-1, "result", "aa{sv}", NULL};
static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_GetResultMetas_in[] = {&_seahorse_search_provider_dbus_arg_info_GetResultMetas_results, NULL};
static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_GetResultMetas_out[] = {&_seahorse_search_provider_dbus_arg_info_GetResultMetas_result, NULL};
static const GDBusMethodInfo _seahorse_search_provider_dbus_method_info_GetResultMetas = {-1, "GetResultMetas", (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_GetResultMetas_in), (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_GetResultMetas_out), NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_ActivateResult_identifier = {-1, "identifier", "s", NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_ActivateResult_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_ActivateResult_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_ActivateResult_in[] = {&_seahorse_search_provider_dbus_arg_info_ActivateResult_identifier, &_seahorse_search_provider_dbus_arg_info_ActivateResult_terms, &_seahorse_search_provider_dbus_arg_info_ActivateResult_timestamp, NULL};
static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_ActivateResult_out[] = {NULL};
static const GDBusMethodInfo _seahorse_search_provider_dbus_method_info_ActivateResult = {-1, "ActivateResult", (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_ActivateResult_in), (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_ActivateResult_out), NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_LaunchSearch_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _seahorse_search_provider_dbus_arg_info_LaunchSearch_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_LaunchSearch_in[] = {&_seahorse_search_provider_dbus_arg_info_LaunchSearch_terms, &_seahorse_search_provider_dbus_arg_info_LaunchSearch_timestamp, NULL};
static const GDBusArgInfo * const _seahorse_search_provider_dbus_arg_info_LaunchSearch_out[] = {NULL};
static const GDBusMethodInfo _seahorse_search_provider_dbus_method_info_LaunchSearch = {-1, "LaunchSearch", (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_LaunchSearch_in), (GDBusArgInfo **) (&_seahorse_search_provider_dbus_arg_info_LaunchSearch_out), NULL};
static const GDBusMethodInfo * const _seahorse_search_provider_dbus_method_info[] = {&_seahorse_search_provider_dbus_method_info_load, &_seahorse_search_provider_dbus_method_info_GetInitialResultSet, &_seahorse_search_provider_dbus_method_info_GetSubsearchResultSet, &_seahorse_search_provider_dbus_method_info_GetResultMetas, &_seahorse_search_provider_dbus_method_info_ActivateResult, &_seahorse_search_provider_dbus_method_info_LaunchSearch, NULL};
static const GDBusSignalInfo * const _seahorse_search_provider_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _seahorse_search_provider_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _seahorse_search_provider_dbus_interface_info = {-1, "org.gnome.Shell.SearchProvider2", (GDBusMethodInfo **) (&_seahorse_search_provider_dbus_method_info), (GDBusSignalInfo **) (&_seahorse_search_provider_dbus_signal_info), (GDBusPropertyInfo **) (&_seahorse_search_provider_dbus_property_info), NULL};
static const GDBusInterfaceVTable _seahorse_search_provider_dbus_interface_vtable = {seahorse_search_provider_dbus_interface_method_call, seahorse_search_provider_dbus_interface_get_property, seahorse_search_provider_dbus_interface_set_property};

static inline gpointer
seahorse_search_provider_get_instance_private (SeahorseSearchProvider* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSearchProvider_private_offset);
}

static void
_seahorse_search_provider_on_object_gone_gweak_notify (gpointer self,
                                                       GObject* object)
{
	seahorse_search_provider_on_object_gone ((SeahorseSearchProvider*) self, object);
}

static void
_seahorse_search_provider___lambda23_ (SeahorseSearchProvider* self,
                                       const gchar* __,
                                       GObject* obj)
{
	g_return_if_fail (__ != NULL);
	g_return_if_fail (obj != NULL);
	g_object_weak_unref (obj, _seahorse_search_provider_on_object_gone_gweak_notify, self);
}

static void
__seahorse_search_provider___lambda23__gh_func (gconstpointer key,
                                                gconstpointer value,
                                                gpointer self)
{
	_seahorse_search_provider___lambda23_ ((SeahorseSearchProvider*) self, (const gchar*) key, (GObject*) value);
}

static void
_g_free_gdestroy_notify (void* data)
{
	g_free (data);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_seahorse_search_provider_filter_objects_gcr_filter_collection_func (GObject* object,
                                                                     gpointer self)
{
	gboolean result;
	result = seahorse_search_provider_filter_objects (object);
	return result;
}

SeahorseSearchProvider*
seahorse_search_provider_construct (GType object_type,
                                    GApplication* app)
{
	SeahorseSearchProvider * self = NULL;
	GApplication* _tmp0_;
	GcrUnionCollection* _tmp1_;
	GcrFilterCollection* _tmp2_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (SeahorseSearchProvider*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (app);
	_g_object_unref0 (self->priv->app);
	self->priv->app = _tmp0_;
	_tmp1_ = self->priv->union_collection;
	_tmp2_ = (GcrFilterCollection*) gcr_filter_collection_new_with_callback ((GcrCollection*) _tmp1_, _seahorse_search_provider_filter_objects_gcr_filter_collection_func, NULL, NULL);
	_g_object_unref0 (self->priv->collection);
	self->priv->collection = _tmp2_;
	return self;
}

SeahorseSearchProvider*
seahorse_search_provider_new (GApplication* app)
{
	return seahorse_search_provider_construct (SEAHORSE_TYPE_SEARCH_PROVIDER, app);
}

static gboolean
seahorse_search_provider_filter_objects (GObject* obj)
{
	SeahorseObject* object = NULL;
	gboolean _tmp0_ = FALSE;
	SeahorseObject* _tmp1_;
	gboolean result;
	object = G_TYPE_CHECK_INSTANCE_TYPE (obj, SEAHORSE_TYPE_OBJECT) ? ((SeahorseObject*) obj) : NULL;
	_tmp1_ = object;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		SeahorseObject* _tmp2_;
		SeahorseFlags _tmp3_;
		SeahorseFlags _tmp4_;
		_tmp2_ = object;
		_tmp3_ = seahorse_object_get_object_flags (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !((_tmp4_ & SEAHORSE_FLAG_PERSONAL) == SEAHORSE_FLAG_PERSONAL);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (!G_TYPE_CHECK_INSTANCE_TYPE (obj, SEAHORSE_TYPE_VIEWABLE)) {
		result = FALSE;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (obj, secret_item_get_type ())) {
		gchar* schema_name = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = secret_item_get_schema_name (G_TYPE_CHECK_INSTANCE_CAST (obj, secret_item_get_type (), SecretItem));
		schema_name = _tmp5_;
		_tmp6_ = schema_name;
		if (g_strcmp0 (_tmp6_, "org.gnome.keyring.Note") != 0) {
			result = FALSE;
			_g_free0 (schema_name);
			return result;
		}
		_g_free0 (schema_name);
	}
	result = TRUE;
	return result;
}

static void
seahorse_search_provider_load_data_free (gpointer _data)
{
	SeahorseSearchProviderLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSearchProviderLoadData, _data_);
}

void
seahorse_search_provider_load (SeahorseSearchProvider* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	SeahorseSearchProviderLoadData* _data_;
	SeahorseSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SeahorseSearchProviderLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_search_provider_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	seahorse_search_provider_load_co (_data_);
}

void
seahorse_search_provider_load_finish (SeahorseSearchProvider* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	SeahorseSearchProviderLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SeahorseSearchProvider* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
___lambda4_ (Block4Data* _data4_)
{
	SeahorseSearchProvider* self;
	self = _data4_->self;
	seahorse_search_provider_load_co (_data4_->_async_data_);
}

static void
____lambda4__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	___lambda4_ (self);
}

static void
_____lambda5_ (SeahorseSearchProvider* self)
{
	seahorse_search_provider_change_n_loading (self, -1);
	if (seahorse_search_provider_get_n_loading (self) == 0) {
		self->priv->loaded = TRUE;
	}
}

static void
______lambda5__g_object_notify (GObject* _sender,
                                GParamSpec* pspec,
                                gpointer self)
{
	_____lambda5_ ((SeahorseSearchProvider*) self);
}

static void
_seahorse_search_provider_on_place_added_gcr_collection_added (GcrCollection* _sender,
                                                               GObject* object,
                                                               gpointer self)
{
	seahorse_search_provider_on_place_added ((SeahorseSearchProvider*) self, _sender, object);
}

static void
_seahorse_search_provider_on_place_removed_gcr_collection_removed (GcrCollection* _sender,
                                                                   GObject* object,
                                                                   gpointer self)
{
	seahorse_search_provider_on_place_removed ((SeahorseSearchProvider*) self, _sender, object);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
seahorse_search_provider_load_co (SeahorseSearchProviderLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_data4_->_async_data_ = _data_;
	while (TRUE) {
		if (!_data_->self->priv->loaded) {
			_data_->_tmp0_ = seahorse_search_provider_get_n_loading (_data_->self) > 0;
		} else {
			_data_->_tmp0_ = FALSE;
		}
		if (!_data_->_tmp0_) {
			break;
		}
		_data_->_tmp1_ = g_signal_connect_data ((GObject*) _data_->self, "notify::loaded", (GCallback) ____lambda4__g_object_notify, block4_data_ref (_data_->_data4_), (GClosureNotify) block4_data_unref, 0);
		_data_->wait = _data_->_tmp1_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		g_signal_handler_disconnect ((GObject*) _data_->self, _data_->wait);
		if (_data_->self->priv->loaded) {
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp2_ = seahorse_backend_get_registered ();
	_data_->backends = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->backends;
	_data_->self->priv->n_loading = (gint) g_list_length (_data_->_tmp3_);
	_data_->_tmp4_ = _data_->backends;
	{
		_data_->backend_collection = _data_->_tmp4_;
		for (_data_->backend_it = _data_->backend_collection; _data_->backend_it != NULL; _data_->backend_it = _data_->backend_it->next) {
			_data_->_tmp5_ = _g_object_ref0 ((SeahorseBackend*) _data_->backend_it->data);
			_data_->backend = _data_->_tmp5_;
			{
				_data_->_tmp6_ = _data_->backend;
				_data_->_tmp7_ = seahorse_backend_get_loaded (_data_->_tmp6_);
				_data_->_tmp8_ = _data_->_tmp7_;
				if (!_data_->_tmp8_) {
					_data_->_tmp9_ = _data_->backend;
					g_signal_connect_object ((GObject*) _data_->_tmp9_, "notify::loaded", (GCallback) ______lambda5__g_object_notify, _data_->self, 0);
				} else {
					seahorse_search_provider_change_n_loading (_data_->self, -1);
				}
				_data_->_tmp10_ = _data_->backend;
				g_signal_connect_object ((GcrCollection*) _data_->_tmp10_, "added", (GCallback) _seahorse_search_provider_on_place_added_gcr_collection_added, _data_->self, 0);
				_data_->_tmp11_ = _data_->backend;
				g_signal_connect_object ((GcrCollection*) _data_->_tmp11_, "removed", (GCallback) _seahorse_search_provider_on_place_removed_gcr_collection_removed, _data_->self, 0);
				_data_->_tmp12_ = _data_->backend;
				_data_->_tmp13_ = gcr_collection_get_objects ((GcrCollection*) _data_->_tmp12_);
				{
					_data_->place_collection = _data_->_tmp13_;
					for (_data_->place_it = _data_->place_collection; _data_->place_it != NULL; _data_->place_it = _data_->place_it->next) {
						_data_->_tmp14_ = _g_object_ref0 ((GObject*) _data_->place_it->data);
						_data_->place = _data_->_tmp14_;
						{
							_data_->_tmp15_ = _data_->backend;
							_data_->_tmp16_ = _data_->place;
							seahorse_search_provider_on_place_added (_data_->self, (GcrCollection*) _data_->_tmp15_, _data_->_tmp16_);
							_g_object_unref0 (_data_->place);
						}
					}
					(_data_->place_collection == NULL) ? NULL : (_data_->place_collection = (g_list_free (_data_->place_collection), NULL));
				}
				_g_object_unref0 (_data_->backend);
			}
		}
	}
	(_data_->backends == NULL) ? NULL : (_data_->backends = (_g_list_free__g_object_unref0_ (_data_->backends), NULL));
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
seahorse_search_provider_get_n_loading (SeahorseSearchProvider* self)
{
	gint retval = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_rw_lock_reader_lock (&self->priv->n_loading_lock);
	retval = self->priv->n_loading;
	g_rw_lock_reader_unlock (&self->priv->n_loading_lock);
	result = retval;
	return result;
}

static void
seahorse_search_provider_change_n_loading (SeahorseSearchProvider* self,
                                           gint diff)
{
	g_return_if_fail (self != NULL);
	g_rw_lock_writer_lock (&self->priv->n_loading_lock);
	self->priv->n_loading = self->priv->n_loading + diff;
	g_rw_lock_writer_unlock (&self->priv->n_loading_lock);
}

static void
seahorse_search_provider_GetInitialResultSet_data_free (gpointer _data)
{
	seahorse_search_provider_GetInitialResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (seahorse_search_provider_GetInitialResultSetData, _data_);
}

void
seahorse_search_provider_GetInitialResultSet (SeahorseSearchProvider* self,
                                              gchar** terms,
                                              gint terms_length1,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	seahorse_search_provider_GetInitialResultSetData* _data_;
	SeahorseSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (seahorse_search_provider_GetInitialResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_search_provider_GetInitialResultSet_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	seahorse_search_provider_GetInitialResultSet_co (_data_);
}

gchar**
seahorse_search_provider_GetInitialResultSet_finish (SeahorseSearchProvider* self,
                                                     GAsyncResult* _res_,
                                                     gint* result_length1,
                                                     GError** error)
{
	gchar** result;
	seahorse_search_provider_GetInitialResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
seahorse_search_provider_GetInitialResultSet_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	seahorse_search_provider_GetInitialResultSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_search_provider_GetInitialResultSet_co (_data_);
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
seahorse_search_provider_GetInitialResultSet_co (seahorse_search_provider_GetInitialResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->app;
	g_application_hold (_data_->_tmp0_);
	if (seahorse_search_provider_get_n_loading (_data_->self) >= 0) {
		_data_->_state_ = 1;
		seahorse_search_provider_load (_data_->self, seahorse_search_provider_GetInitialResultSet_ready, _data_);
		return FALSE;
		_state_1:
		seahorse_search_provider_load_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = g_new0 (gchar*, 0 + 1);
	_data_->results = _data_->_tmp1_;
	_data_->results_length1 = 0;
	_data_->_results_size_ = _data_->results_length1;
	_data_->_tmp2_ = _data_->self->priv->collection;
	_data_->_tmp3_ = gcr_collection_get_objects ((GcrCollection*) _data_->_tmp2_);
	{
		_data_->obj_collection = _data_->_tmp3_;
		for (_data_->obj_it = _data_->obj_collection; _data_->obj_it != NULL; _data_->obj_it = _data_->obj_it->next) {
			_data_->obj = (GObject*) _data_->obj_it->data;
			{
				_data_->_tmp4_ = _data_->obj;
				if (seahorse_search_provider_object_matches_search (_data_->self, _data_->_tmp4_, _data_->terms, (gint) _data_->terms_length1)) {
					_data_->_tmp5_ = _data_->obj;
					_data_->_tmp6_ = g_strdup_printf ("%p", _data_->_tmp5_);
					_data_->str = _data_->_tmp6_;
					_data_->_tmp7_ = _data_->self->priv->handles;
					_data_->_tmp8_ = _data_->str;
					if (!g_hash_table_contains (_data_->_tmp7_, _data_->_tmp8_)) {
						_data_->_tmp9_ = _data_->self->priv->handles;
						_data_->_tmp10_ = _data_->str;
						_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
						_data_->_tmp12_ = _data_->obj;
						g_hash_table_insert (_data_->_tmp9_, _data_->_tmp11_, _data_->_tmp12_);
						_data_->_tmp13_ = _data_->obj;
						g_object_weak_ref (_data_->_tmp13_, _seahorse_search_provider_on_object_gone_gweak_notify, _data_->self);
					}
					_data_->_tmp14_ = _data_->str;
					_data_->str = NULL;
					_vala_array_add2 (&_data_->results, &_data_->results_length1, &_data_->_results_size_, _data_->_tmp14_);
					_g_free0 (_data_->str);
				}
			}
		}
		(_data_->obj_collection == NULL) ? NULL : (_data_->obj_collection = (g_list_free (_data_->obj_collection), NULL));
	}
	_data_->_tmp15_ = _data_->self->priv->app;
	g_application_release (_data_->_tmp15_);
	_data_->_tmp16_ = _data_->results;
	_data_->_tmp16__length1 = _data_->results_length1;
	_data_->result_length1 = _data_->_tmp16__length1;
	_data_->result = _data_->_tmp16_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_search_provider_GetSubsearchResultSet_data_free (gpointer _data)
{
	seahorse_search_provider_GetSubsearchResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (seahorse_search_provider_GetSubsearchResultSetData, _data_);
}

void
seahorse_search_provider_GetSubsearchResultSet (SeahorseSearchProvider* self,
                                                gchar** previous_results,
                                                gint previous_results_length1,
                                                gchar** new_terms,
                                                gint new_terms_length1,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	seahorse_search_provider_GetSubsearchResultSetData* _data_;
	SeahorseSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (seahorse_search_provider_GetSubsearchResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_search_provider_GetSubsearchResultSet_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->previous_results = previous_results;
	_data_->previous_results_length1 = previous_results_length1;
	_data_->new_terms = new_terms;
	_data_->new_terms_length1 = new_terms_length1;
	seahorse_search_provider_GetSubsearchResultSet_co (_data_);
}

gchar**
seahorse_search_provider_GetSubsearchResultSet_finish (SeahorseSearchProvider* self,
                                                       GAsyncResult* _res_,
                                                       gint* result_length1,
                                                       GError** error)
{
	gchar** result;
	seahorse_search_provider_GetSubsearchResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
seahorse_search_provider_GetSubsearchResultSet_co (seahorse_search_provider_GetSubsearchResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->app;
	g_application_hold (_data_->_tmp0_);
	_data_->_tmp1_ = g_new0 (gchar*, 0 + 1);
	_data_->results = _data_->_tmp1_;
	_data_->results_length1 = 0;
	_data_->_results_size_ = _data_->results_length1;
	{
		_data_->previous_result_collection_length1 = 0;
		_data_->_previous_result_collection_size_ = 0;
		_data_->previous_result_collection = _data_->previous_results;
		_data_->previous_result_collection_length1 = _data_->previous_results_length1;
		for (_data_->previous_result_it = 0; _data_->previous_result_it < _data_->previous_result_collection_length1; _data_->previous_result_it = _data_->previous_result_it + 1) {
			_data_->_tmp2_ = g_strdup (_data_->previous_result_collection[_data_->previous_result_it]);
			_data_->previous_result = _data_->_tmp2_;
			{
				_data_->_tmp3_ = _data_->self->priv->handles;
				_data_->_tmp4_ = _data_->previous_result;
				_data_->_tmp5_ = g_hash_table_lookup (_data_->_tmp3_, _data_->_tmp4_);
				_data_->object = (GObject*) _data_->_tmp5_;
				_data_->_tmp7_ = _data_->object;
				if (_data_->_tmp7_ == NULL) {
					_data_->_tmp6_ = TRUE;
				} else {
					_data_->_tmp8_ = _data_->self->priv->collection;
					_data_->_tmp9_ = _data_->object;
					_data_->_tmp6_ = !gcr_collection_contains ((GcrCollection*) _data_->_tmp8_, _data_->_tmp9_);
				}
				if (_data_->_tmp6_) {
					_g_free0 (_data_->previous_result);
					continue;
				}
				_data_->_tmp10_ = _data_->object;
				if (seahorse_search_provider_object_matches_search (_data_->self, _data_->_tmp10_, _data_->new_terms, (gint) _data_->new_terms_length1)) {
					_data_->_tmp11_ = _data_->previous_result;
					_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
					_vala_array_add3 (&_data_->results, &_data_->results_length1, &_data_->_results_size_, _data_->_tmp12_);
				}
				_g_free0 (_data_->previous_result);
			}
		}
	}
	_data_->_tmp13_ = _data_->self->priv->app;
	g_application_release (_data_->_tmp13_);
	_data_->_tmp14_ = _data_->results;
	_data_->_tmp14__length1 = _data_->results_length1;
	_data_->result_length1 = _data_->_tmp14__length1;
	_data_->result = _data_->_tmp14_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_search_provider_GetResultMetas_data_free (gpointer _data)
{
	seahorse_search_provider_GetResultMetasData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (seahorse_search_provider_GetResultMetasData, _data_);
}

void
seahorse_search_provider_GetResultMetas (SeahorseSearchProvider* self,
                                         gchar** results,
                                         gint results_length1,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	seahorse_search_provider_GetResultMetasData* _data_;
	SeahorseSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (seahorse_search_provider_GetResultMetasData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_search_provider_GetResultMetas_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->results = results;
	_data_->results_length1 = results_length1;
	seahorse_search_provider_GetResultMetas_co (_data_);
}

GHashTable**
seahorse_search_provider_GetResultMetas_finish (SeahorseSearchProvider* self,
                                                GAsyncResult* _res_,
                                                gint* result_length1,
                                                GError** error)
{
	GHashTable** result;
	seahorse_search_provider_GetResultMetasData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new3 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new4 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static GHashTable**
_vala_array_dup1 (GHashTable** self,
                  gssize length)
{
	if (length >= 0) {
		GHashTable** result;
		gssize i;
		result = g_new0 (GHashTable*, length + 1);
		for (i = 0; i < length; i++) {
			GHashTable* _tmp0_;
			_tmp0_ = _g_hash_table_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
seahorse_search_provider_GetResultMetas_co (seahorse_search_provider_GetResultMetasData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->app;
	g_application_hold (_data_->_tmp0_);
	_data_->_tmp1_ = g_new0 (GHashTable*, _data_->results_length1 + 1);
	_data_->metas = _data_->_tmp1_;
	_data_->metas_length1 = _data_->results_length1;
	_data_->_metas_size_ = _data_->metas_length1;
	_data_->good_results = 0;
	{
		_data_->result_collection_length1 = 0;
		_data_->_result_collection_size_ = 0;
		_data_->result_collection = _data_->results;
		_data_->result_collection_length1 = _data_->results_length1;
		for (_data_->result_it = 0; _data_->result_it < _data_->result_collection_length1; _data_->result_it = _data_->result_it + 1) {
			_data_->_result_ = _data_->result_collection[_data_->result_it];
			{
				_data_->_tmp2_ = _data_->self->priv->handles;
				_data_->_tmp3_ = _data_->_result_;
				_data_->_tmp4_ = g_hash_table_lookup (_data_->_tmp2_, _data_->_tmp3_);
				_data_->object = (GObject*) _data_->_tmp4_;
				_data_->_tmp6_ = _data_->object;
				if (_data_->_tmp6_ == NULL) {
					_data_->_tmp5_ = TRUE;
				} else {
					_data_->_tmp7_ = _data_->self->priv->collection;
					_data_->_tmp8_ = _data_->object;
					_data_->_tmp5_ = !gcr_collection_contains ((GcrCollection*) _data_->_tmp7_, _data_->_tmp8_);
				}
				if (_data_->_tmp5_) {
					continue;
				}
				_data_->_tmp9_ = g_str_hash;
				_data_->_tmp10_ = g_str_equal;
				_data_->_tmp11_ = g_hash_table_new_full (_data_->_tmp9_, _data_->_tmp10_, _g_free0_, _g_variant_unref0_);
				_data_->meta = _data_->_tmp11_;
				_data_->_tmp12_ = _data_->meta;
				_data_->_tmp13_ = g_strdup ("id");
				_data_->_tmp14_ = _data_->_result_;
				_data_->_tmp15_ = _variant_new2 (_data_->_tmp14_);
				g_hash_table_insert (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp15_);
				_data_->label = NULL;
				_data_->_tmp16_ = _data_->object;
				_data_->_tmp17_ = NULL;
				g_object_get (_data_->_tmp16_, "label", &_data_->_tmp17_, NULL, NULL);
				_g_free0 (_data_->label);
				_data_->label = _data_->_tmp17_;
				_data_->_tmp18_ = _data_->label;
				if (_data_->_tmp18_ != NULL) {
					_data_->_tmp19_ = _data_->meta;
					_data_->_tmp20_ = g_strdup ("name");
					_data_->_tmp21_ = _data_->label;
					_data_->_tmp22_ = _variant_new3 (_data_->_tmp21_);
					g_hash_table_insert (_data_->_tmp19_, _data_->_tmp20_, _data_->_tmp22_);
				}
				_data_->icon = NULL;
				_data_->_tmp23_ = _data_->object;
				_data_->_tmp24_ = NULL;
				g_object_get (_data_->_tmp23_, "icon", &_data_->_tmp24_, NULL, NULL);
				_g_object_unref0 (_data_->icon);
				_data_->icon = _data_->_tmp24_;
				_data_->_tmp25_ = _data_->icon;
				if (_data_->_tmp25_ != NULL) {
					_data_->_tmp26_ = _data_->meta;
					_data_->_tmp27_ = g_strdup ("icon");
					_data_->_tmp28_ = _data_->icon;
					_data_->_tmp29_ = g_icon_serialize (_data_->_tmp28_);
					g_hash_table_insert (_data_->_tmp26_, _data_->_tmp27_, _data_->_tmp29_);
				}
				_data_->_tmp30_ = _data_->object;
				_data_->_tmp31_ = seahorse_search_provider_get_description_if_available (_data_->_tmp30_);
				_data_->description = _data_->_tmp31_;
				_data_->_tmp32_ = _data_->description;
				if (_data_->_tmp32_ != NULL) {
					_data_->_tmp33_ = _data_->meta;
					_data_->_tmp34_ = g_strdup ("description");
					_data_->_tmp35_ = _data_->description;
					_data_->_tmp36_ = _variant_new4 (_data_->_tmp35_);
					g_hash_table_insert (_data_->_tmp33_, _data_->_tmp34_, _data_->_tmp36_);
				}
				_data_->_tmp37_ = _data_->metas;
				_data_->_tmp37__length1 = _data_->metas_length1;
				_data_->_tmp38_ = _data_->meta;
				_data_->_tmp39_ = _g_hash_table_ref0 (_data_->_tmp38_);
				_g_hash_table_unref0 (_data_->_tmp37_[_data_->good_results]);
				_data_->_tmp37_[_data_->good_results] = _data_->_tmp39_;
				_data_->_tmp40_ = _data_->good_results;
				_data_->good_results = _data_->_tmp40_ + 1;
				_g_free0 (_data_->description);
				_g_object_unref0 (_data_->icon);
				_g_free0 (_data_->label);
				_g_hash_table_unref0 (_data_->meta);
			}
		}
	}
	_data_->_tmp41_ = _data_->self->priv->app;
	g_application_release (_data_->_tmp41_);
	_data_->_tmp42_ = _data_->metas;
	_data_->_tmp42__length1 = _data_->metas_length1;
	_data_->_tmp43_ = (_data_->_tmp42_ != NULL) ? _vala_array_dup1 (_data_->_tmp42_ + 0, _data_->good_results - 0) : _data_->_tmp42_;
	_data_->_tmp43__length1 = _data_->good_results - 0;
	_data_->_tmp44_ = _data_->_tmp43_;
	_data_->_tmp44__length1 = _data_->_tmp43__length1;
	_data_->result_length1 = _data_->_tmp44__length1;
	_data_->result = _data_->_tmp44_;
	_data_->metas = (_vala_array_free (_data_->metas, _data_->metas_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
seahorse_search_provider_ActivateResult (SeahorseSearchProvider* self,
                                         const gchar* identifier,
                                         gchar** terms,
                                         gint terms_length1,
                                         guint32 timestamp,
                                         GError** error)
{
	GApplication* _tmp0_;
	GObject* object = NULL;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GObject* _tmp5_;
	SeahorseKeyManager* key_manager = NULL;
	GApplication* _tmp9_;
	SeahorseKeyManager* _tmp10_;
	GObject* _tmp11_;
	SeahorseKeyManager* _tmp12_;
	GApplication* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (identifier != NULL);
	_tmp0_ = self->priv->app;
	g_application_hold (_tmp0_);
	object = NULL;
	sscanf (identifier, "%p", &object);
	_tmp1_ = self->priv->handles;
	_tmp2_ = g_hash_table_lookup (_tmp1_, identifier);
	object = (GObject*) _tmp2_;
	_tmp5_ = object;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		GcrFilterCollection* _tmp6_;
		GObject* _tmp7_;
		_tmp6_ = self->priv->collection;
		_tmp7_ = object;
		_tmp4_ = !gcr_collection_contains ((GcrCollection*) _tmp6_, _tmp7_);
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		GObject* _tmp8_;
		_tmp8_ = object;
		_tmp3_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, SEAHORSE_TYPE_VIEWABLE);
	}
	if (_tmp3_) {
		return;
	}
	_tmp9_ = g_application_get_default ();
	_tmp10_ = seahorse_key_manager_new (SEAHORSE_IS_APPLICATION (_tmp9_) ? ((SeahorseApplication*) _tmp9_) : NULL);
	g_object_ref_sink (_tmp10_);
	key_manager = _tmp10_;
	_tmp11_ = object;
	_tmp12_ = key_manager;
	seahorse_viewable_view (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_window_get_type (), GtkWindow));
	_tmp13_ = self->priv->app;
	g_application_release (_tmp13_);
	_g_object_unref0 (key_manager);
}

void
seahorse_search_provider_LaunchSearch (SeahorseSearchProvider* self,
                                       gchar** terms,
                                       gint terms_length1,
                                       guint32 timestamp,
                                       GError** error)
{
	g_return_if_fail (self != NULL);
}

static gboolean
seahorse_search_provider_object_matches_search (SeahorseSearchProvider* self,
                                                GObject* object,
                                                gchar** terms,
                                                gint terms_length1)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gchar** term_collection = NULL;
		gint term_collection_length1 = 0;
		gint _term_collection_size_ = 0;
		gint term_it = 0;
		term_collection = (gchar**) terms;
		term_collection_length1 = (terms_length1 * sizeof (gchar*)) / sizeof (gchar*);
		for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
			const gchar* term = NULL;
			term = term_collection[term_it];
			{
				const gchar* _tmp0_;
				_tmp0_ = term;
				if (!seahorse_search_provider_object_contains_filtered_text (self, object, _tmp0_)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
seahorse_search_provider_object_contains_filtered_text (SeahorseSearchProvider* self,
                                                        GObject* object,
                                                        const gchar* text)
{
	gchar* name = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* description = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	name = NULL;
	g_object_get (object, "label", &_tmp0_, NULL, NULL);
	_g_free0 (name);
	name = _tmp0_;
	_tmp2_ = name;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = name;
		_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
		_tmp5_ = _tmp4_;
		_tmp1_ = string_contains (_tmp5_, text);
		_g_free0 (_tmp5_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		_g_free0 (name);
		return result;
	}
	_tmp6_ = seahorse_search_provider_get_description_if_available (object);
	description = _tmp6_;
	_tmp8_ = description;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = description;
		_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
		_tmp11_ = _tmp10_;
		_tmp7_ = string_contains (_tmp11_, text);
		_g_free0 (_tmp11_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		result = TRUE;
		_g_free0 (description);
		_g_free0 (name);
		return result;
	}
	result = FALSE;
	_g_free0 (description);
	_g_free0 (name);
	return result;
}

static void
seahorse_search_provider_on_object_gone (SeahorseSearchProvider* self,
                                         GObject* where_the_object_was)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->handles;
	_tmp1_ = g_strdup_printf ("%p", where_the_object_was);
	_tmp2_ = _tmp1_;
	g_hash_table_remove (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
seahorse_search_provider_on_place_added (SeahorseSearchProvider* self,
                                         GcrCollection* places,
                                         GObject* object)
{
	SeahorsePlace* place = NULL;
	GcrUnionCollection* _tmp0_;
	SeahorsePlace* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (places != NULL);
	g_return_if_fail (object != NULL);
	place = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_PLACE, SeahorsePlace);
	_tmp0_ = self->priv->union_collection;
	_tmp1_ = place;
	if (!gcr_union_collection_have (_tmp0_, (GcrCollection*) _tmp1_)) {
		GcrUnionCollection* _tmp2_;
		SeahorsePlace* _tmp3_;
		_tmp2_ = self->priv->union_collection;
		_tmp3_ = place;
		gcr_union_collection_add (_tmp2_, (GcrCollection*) _tmp3_);
	}
}

static void
seahorse_search_provider_on_place_removed (SeahorseSearchProvider* self,
                                           GcrCollection* places,
                                           GObject* object)
{
	SeahorsePlace* place = NULL;
	GcrUnionCollection* _tmp0_;
	SeahorsePlace* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (places != NULL);
	g_return_if_fail (object != NULL);
	place = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_PLACE, SeahorsePlace);
	_tmp0_ = self->priv->union_collection;
	_tmp1_ = place;
	if (gcr_union_collection_have (_tmp0_, (GcrCollection*) _tmp1_)) {
		GcrUnionCollection* _tmp2_;
		SeahorsePlace* _tmp3_;
		_tmp2_ = self->priv->union_collection;
		_tmp3_ = place;
		gcr_union_collection_remove (_tmp2_, (GcrCollection*) _tmp3_);
	}
}

static gchar*
seahorse_search_provider_get_description_if_available (GObject* obj)
{
	GObjectClass* _tmp0_;
	GParamSpec* _tmp1_;
	gchar* description = NULL;
	gchar* _tmp2_ = NULL;
	gchar* result;
	if (obj == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = G_OBJECT_GET_CLASS (obj);
	_tmp1_ = g_object_class_find_property (_tmp0_, "description");
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	}
	description = NULL;
	g_object_get (obj, "description", &_tmp2_, NULL);
	_g_free0 (description);
	description = _tmp2_;
	result = description;
	return result;
}

static void
seahorse_search_provider_class_init (SeahorseSearchProviderClass * klass,
                                     gpointer klass_data)
{
	seahorse_search_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSearchProvider_private_offset);
	G_OBJECT_CLASS (klass)->finalize = seahorse_search_provider_finalize;
}

static void
seahorse_search_provider_instance_init (SeahorseSearchProvider * self,
                                        gpointer klass)
{
	GcrUnionCollection* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	self->priv = seahorse_search_provider_get_instance_private (self);
	_tmp0_ = (GcrUnionCollection*) gcr_union_collection_new ();
	self->priv->union_collection = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free_gdestroy_notify, NULL);
	self->priv->handles = _tmp3_;
	self->priv->n_loading = 0;
	g_rw_lock_init (&self->priv->n_loading_lock);
	self->priv->loaded = FALSE;
}

static void
seahorse_search_provider_finalize (GObject * obj)
{
	SeahorseSearchProvider * self;
	GHashTable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_SEARCH_PROVIDER, SeahorseSearchProvider);
	_tmp0_ = self->priv->handles;
	g_hash_table_foreach (_tmp0_, __seahorse_search_provider___lambda23__gh_func, self);
	_g_object_unref0 (self->priv->union_collection);
	_g_hash_table_unref0 (self->priv->handles);
	_g_object_unref0 (self->priv->collection);
	_g_object_unref0 (self->priv->app);
	_vala_clear_GRWLock (&self->priv->n_loading_lock);
	G_OBJECT_CLASS (seahorse_search_provider_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_search_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSearchProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_search_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSearchProvider), 0, (GInstanceInitFunc) seahorse_search_provider_instance_init, NULL };
	GType seahorse_search_provider_type_id;
	seahorse_search_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseSearchProvider", &g_define_type_info, 0);
	g_type_set_qdata (seahorse_search_provider_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) seahorse_search_provider_register_object);
	SeahorseSearchProvider_private_offset = g_type_add_instance_private (seahorse_search_provider_type_id, sizeof (SeahorseSearchProviderPrivate));
	return seahorse_search_provider_type_id;
}

GType
seahorse_search_provider_get_type (void)
{
	static volatile gsize seahorse_search_provider_type_id__once = 0;
	if (g_once_init_enter (&seahorse_search_provider_type_id__once)) {
		GType seahorse_search_provider_type_id;
		seahorse_search_provider_type_id = seahorse_search_provider_get_type_once ();
		g_once_init_leave (&seahorse_search_provider_type_id__once, seahorse_search_provider_type_id);
	}
	return seahorse_search_provider_type_id__once;
}

static void
_dbus_seahorse_search_provider_load (SeahorseSearchProvider* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SeahorseSearchProviderLoadReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SeahorseSearchProviderLoadReadyData);
	_ready_data->_invocation_ = invocation;
	seahorse_search_provider_load (self, (GAsyncReadyCallback) _dbus_seahorse_search_provider_load_ready, _ready_data);
}

static void
_dbus_seahorse_search_provider_load_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_)
{
	SeahorseSearchProviderLoadReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	seahorse_search_provider_load_finish ((SeahorseSearchProvider*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (SeahorseSearchProviderLoadReadyData, _ready_data);
}

static void
_dbus_seahorse_search_provider_GetInitialResultSet (SeahorseSearchProvider* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	seahorse_search_provider_GetInitialResultSetReadyData* _ready_data;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length;
	gint _tmp1__size;
	gint _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (seahorse_search_provider_GetInitialResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	_ready_data->terms_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_ready_data->terms = _tmp1_;
	g_variant_unref (_tmp0_);
	seahorse_search_provider_GetInitialResultSet (self, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_seahorse_search_provider_GetInitialResultSet_ready, _ready_data);
	_error:
	;
}

static void
_dbus_seahorse_search_provider_GetInitialResultSet_ready (GObject * source_object,
                                                          GAsyncResult * _res_,
                                                          gpointer _user_data_)
{
	seahorse_search_provider_GetInitialResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp4_;
	GVariantBuilder _tmp5_;
	gint _tmp6_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = seahorse_search_provider_GetInitialResultSet_finish ((SeahorseSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp4_ = result;
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("as"));
	for (_tmp6_ = 0; _tmp6_ < result_length1; _tmp6_++) {
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string (*_tmp4_));
		_tmp4_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp5_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (seahorse_search_provider_GetInitialResultSetReadyData, _ready_data);
}

static void
_dbus_seahorse_search_provider_GetSubsearchResultSet (SeahorseSearchProvider* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	seahorse_search_provider_GetSubsearchResultSetReadyData* _ready_data;
	GVariant* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length;
	gint _tmp8__size;
	gint _tmp8__length1;
	GVariantIter _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length;
	gint _tmp12__size;
	gint _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (seahorse_search_provider_GetSubsearchResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp8_ = g_new (gchar*, 5);
	_tmp8__length = 0;
	_tmp8__size = 4;
	_tmp8__length1 = 0;
	g_variant_iter_init (&_tmp9_, _tmp7_);
	for (; (_tmp10_ = g_variant_iter_next_value (&_tmp9_)) != NULL; _tmp8__length1++) {
		if (_tmp8__size == _tmp8__length) {
			_tmp8__size = 2 * _tmp8__size;
			_tmp8_ = g_renew (gchar*, _tmp8_, _tmp8__size + 1);
		}
		_tmp8_[_tmp8__length++] = g_variant_dup_string (_tmp10_, NULL);
		g_variant_unref (_tmp10_);
	}
	_ready_data->previous_results_length1 = _tmp8__length1;
	_tmp8_[_tmp8__length] = NULL;
	_ready_data->previous_results = _tmp8_;
	g_variant_unref (_tmp7_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp12_ = g_new (gchar*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		if (_tmp12__size == _tmp12__length) {
			_tmp12__size = 2 * _tmp12__size;
			_tmp12_ = g_renew (gchar*, _tmp12_, _tmp12__size + 1);
		}
		_tmp12_[_tmp12__length++] = g_variant_dup_string (_tmp14_, NULL);
		g_variant_unref (_tmp14_);
	}
	_ready_data->new_terms_length1 = _tmp12__length1;
	_tmp12_[_tmp12__length] = NULL;
	_ready_data->new_terms = _tmp12_;
	g_variant_unref (_tmp11_);
	seahorse_search_provider_GetSubsearchResultSet (self, _ready_data->previous_results, _ready_data->previous_results_length1, _ready_data->new_terms, _ready_data->new_terms_length1, (GAsyncReadyCallback) _dbus_seahorse_search_provider_GetSubsearchResultSet_ready, _ready_data);
	_error:
	;
}

static void
_dbus_seahorse_search_provider_GetSubsearchResultSet_ready (GObject * source_object,
                                                            GAsyncResult * _res_,
                                                            gpointer _user_data_)
{
	seahorse_search_provider_GetSubsearchResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp15_;
	GVariantBuilder _tmp16_;
	gint _tmp17_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = seahorse_search_provider_GetSubsearchResultSet_finish ((SeahorseSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp15_ = result;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("as"));
	for (_tmp17_ = 0; _tmp17_ < result_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_string (*_tmp15_));
		_tmp15_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp16_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->previous_results = (_vala_array_free (_ready_data->previous_results, _ready_data->previous_results_length1, (GDestroyNotify) g_free), NULL);
	_ready_data->new_terms = (_vala_array_free (_ready_data->new_terms, _ready_data->new_terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (seahorse_search_provider_GetSubsearchResultSetReadyData, _ready_data);
}

static void
_dbus_seahorse_search_provider_GetResultMetas (SeahorseSearchProvider* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	seahorse_search_provider_GetResultMetasReadyData* _ready_data;
	GVariant* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length;
	gint _tmp19__size;
	gint _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (seahorse_search_provider_GetResultMetasReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp19_ = g_new (gchar*, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (gchar*, _tmp19_, _tmp19__size + 1);
		}
		_tmp19_[_tmp19__length++] = g_variant_dup_string (_tmp21_, NULL);
		g_variant_unref (_tmp21_);
	}
	_ready_data->results_length1 = _tmp19__length1;
	_tmp19_[_tmp19__length] = NULL;
	_ready_data->results = _tmp19_;
	g_variant_unref (_tmp18_);
	seahorse_search_provider_GetResultMetas (self, _ready_data->results, _ready_data->results_length1, (GAsyncReadyCallback) _dbus_seahorse_search_provider_GetResultMetas_ready, _ready_data);
	_error:
	;
}

static void
_dbus_seahorse_search_provider_GetResultMetas_ready (GObject * source_object,
                                                     GAsyncResult * _res_,
                                                     gpointer _user_data_)
{
	seahorse_search_provider_GetResultMetasReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	gint result_length1 = 0;
	GHashTable** _tmp22_;
	GVariantBuilder _tmp23_;
	gint _tmp24_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = seahorse_search_provider_GetResultMetas_finish ((SeahorseSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp22_ = result;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		GVariantBuilder _tmp25_;
		GHashTableIter _tmp26_;
		gpointer _tmp27_;
		gpointer _tmp28_;
		g_hash_table_iter_init (&_tmp26_, *_tmp22_);
		g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp26_, &_tmp27_, &_tmp28_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp27_;
			_value = (GVariant*) _tmp28_;
			g_variant_builder_add (&_tmp25_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp23_, g_variant_builder_end (&_tmp25_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp23_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->results = (_vala_array_free (_ready_data->results, _ready_data->results_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (seahorse_search_provider_GetResultMetasReadyData, _ready_data);
}

static void
_dbus_seahorse_search_provider_ActivateResult (SeahorseSearchProvider* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* identifier = NULL;
	GVariant* _tmp29_;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length;
	gint _tmp31__size;
	gint _tmp31__length1;
	GVariantIter _tmp32_;
	GVariant* _tmp33_;
	guint32 timestamp = 0U;
	GVariant* _tmp34_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	identifier = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp31_ = g_new (gchar*, 5);
	_tmp31__length = 0;
	_tmp31__size = 4;
	_tmp31__length1 = 0;
	g_variant_iter_init (&_tmp32_, _tmp30_);
	for (; (_tmp33_ = g_variant_iter_next_value (&_tmp32_)) != NULL; _tmp31__length1++) {
		if (_tmp31__size == _tmp31__length) {
			_tmp31__size = 2 * _tmp31__size;
			_tmp31_ = g_renew (gchar*, _tmp31_, _tmp31__size + 1);
		}
		_tmp31_[_tmp31__length++] = g_variant_dup_string (_tmp33_, NULL);
		g_variant_unref (_tmp33_);
	}
	terms_length1 = _tmp31__length1;
	_tmp31_[_tmp31__length] = NULL;
	terms = _tmp31_;
	g_variant_unref (_tmp30_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp34_);
	g_variant_unref (_tmp34_);
	seahorse_search_provider_ActivateResult (self, identifier, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (identifier);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_seahorse_search_provider_LaunchSearch (SeahorseSearchProvider* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length;
	gint _tmp36__size;
	gint _tmp36__length1;
	GVariantIter _tmp37_;
	GVariant* _tmp38_;
	guint32 timestamp = 0U;
	GVariant* _tmp39_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp36_ = g_new (gchar*, 5);
	_tmp36__length = 0;
	_tmp36__size = 4;
	_tmp36__length1 = 0;
	g_variant_iter_init (&_tmp37_, _tmp35_);
	for (; (_tmp38_ = g_variant_iter_next_value (&_tmp37_)) != NULL; _tmp36__length1++) {
		if (_tmp36__size == _tmp36__length) {
			_tmp36__size = 2 * _tmp36__size;
			_tmp36_ = g_renew (gchar*, _tmp36_, _tmp36__size + 1);
		}
		_tmp36_[_tmp36__length++] = g_variant_dup_string (_tmp38_, NULL);
		g_variant_unref (_tmp38_);
	}
	terms_length1 = _tmp36__length1;
	_tmp36_[_tmp36__length] = NULL;
	terms = _tmp36_;
	g_variant_unref (_tmp35_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp39_);
	g_variant_unref (_tmp39_);
	seahorse_search_provider_LaunchSearch (self, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
seahorse_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Load") == 0) {
		_dbus_seahorse_search_provider_load (object, parameters, invocation);
	} else if (strcmp (method_name, "GetInitialResultSet") == 0) {
		_dbus_seahorse_search_provider_GetInitialResultSet (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSubsearchResultSet") == 0) {
		_dbus_seahorse_search_provider_GetSubsearchResultSet (object, parameters, invocation);
	} else if (strcmp (method_name, "GetResultMetas") == 0) {
		_dbus_seahorse_search_provider_GetResultMetas (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateResult") == 0) {
		_dbus_seahorse_search_provider_ActivateResult (object, parameters, invocation);
	} else if (strcmp (method_name, "LaunchSearch") == 0) {
		_dbus_seahorse_search_provider_LaunchSearch (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
seahorse_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
seahorse_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
seahorse_search_provider_register_object (gpointer object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_seahorse_search_provider_dbus_interface_info), &_seahorse_search_provider_dbus_interface_vtable, data, _seahorse_search_provider_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_seahorse_search_provider_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

