/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.adapter.readers.cif.Subsystem;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Modulation;
import org.jmol.util.ModulationSet;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;
import org.jmol.viewer.JC;

public class MSRdr
implements MSInterface {
    protected AtomSetCollectionReader cr;
    protected int modDim;
    protected String modAxes;
    protected boolean modAverage;
    protected boolean isCommensurate;
    protected int commensurateSection1;
    private boolean modPack;
    private boolean modVib;
    private String modType;
    private String modCell;
    private boolean modDebug;
    private int modSelected = -1;
    private boolean modLast;
    private Matrix sigma;
    private Map<String, double[]> htModulation;
    private Map<String, Lst<Modulation>> htAtomMods;
    private int iopLast = -1;
    private M3 gammaE;
    private int nOps;
    private boolean haveOccupancy;
    private Atom[] atoms;
    private int ac;
    private boolean haveAtomMods;
    boolean modCoord;
    private boolean finalized;
    private SymmetryInterface symmetry;
    private SymmetryInterface supercellSymmetry;
    private Lst<String> legendres;
    private String atModel = "@0";
    private Matrix[] modMatrices;
    private double[] qlist100;
    private static final String generic = "#*;*";
    private P3[] qs;
    private int modCount;
    private T3 modTUV;
    private static final String U_LIST = "U11U22U33U12U13U23UISO";
    Map<String, Subsystem> htSubsystems;
    private P3 minXYZ0;
    private P3 maxXYZ0;

    Matrix getSigma() {
        return this.sigma;
    }

    @Override
    public int initialize(AtomSetCollectionReader r, int modDim) throws Exception {
        this.cr = r;
        this.modCoord = r.checkFilterKey("MODCOORD");
        this.modDebug = r.checkFilterKey("MODDEBUG");
        this.modPack = !r.checkFilterKey("MODNOPACK");
        this.modLast = r.checkFilterKey("MODLAST");
        this.modAxes = r.getFilter("MODAXES=");
        this.modType = r.getFilter("MODTYPE=");
        this.modCell = r.getFilter("MODCELL=");
        this.modSelected = r.parseIntStr("" + r.getFilter("MOD="));
        this.modVib = r.checkFilterKey("MODVIB");
        this.modAverage = r.checkFilterKey("MODAVE");
        String smodTUV = r.getFilter("MODT=");
        if (smodTUV != null || (smodTUV = r.getFilter("MODTUV=")) != null) {
            this.modTUV = new P3();
            String[] tuv = (PT.replaceAllCharacters(smodTUV, "{}()", "") + ",0,0,0").split(",");
            this.modTUV.x = PT.parseFloatFraction(tuv[0]);
            this.modTUV.y = PT.parseFloatFraction(tuv[1]);
            this.modTUV.z = PT.parseFloatFraction(tuv[2]);
            if (Float.isNaN(this.modTUV.lengthSquared())) {
                Logger.error("MSRdr cannot read modTUV=" + smodTUV);
                this.modTUV = null;
            }
        }
        this.setModDim(modDim);
        return modDim;
    }

    private void setSubsystemOptions() {
        this.cr.forceSymmetry(this.modPack);
        if (this.modCell != null) {
            this.cr.addJmolScript("unitcell {%" + this.modCell + "}");
        }
    }

    protected void setModDim(int ndim) {
        this.htModulation = new Hashtable<String, double[]>();
        this.modDim = ndim;
        this.cr.appendLoadNote("Modulation dimension = " + this.modDim);
    }

    @Override
    public void addModulation(Map<String, double[]> map, String id, double[] pt, int iModel) {
        char ch = id.charAt(0);
        switch (ch) {
            case 'D': 
            case 'M': 
            case 'O': 
            case 'U': {
                if ((this.modType == null || this.modType.indexOf(ch) >= 0) && (this.modSelected <= 0 || this.modSelected == 1)) break;
                return;
            }
        }
        boolean isOK = false;
        int i = pt.length;
        while (--i >= 0) {
            if (this.modSelected > 0 && i + 1 != this.modSelected && id.contains("_coefs_")) {
                pt[i] = 0.0;
                continue;
            }
            if (pt[i] == 0.0) continue;
            isOK = true;
            break;
        }
        if (!isOK) {
            return;
        }
        if (map == null) {
            map = this.htModulation;
        }
        if (id.indexOf("@") < 0) {
            id = id + "@" + (iModel >= 0 ? iModel : this.cr.asc.iSet);
        }
        if (id.startsWith("D_L#") || id.startsWith("U_L")) {
            if (this.legendres == null) {
                this.legendres = new Lst();
            }
            this.legendres.addLast(id);
        }
        Logger.info("Adding " + id + " " + Escape.e(pt));
        map.put(id, pt);
    }

    @Override
    public void setModulation(boolean isPost, SymmetryInterface symmetry) throws Exception {
        if (this.modDim == 0 || this.htModulation == null) {
            return;
        }
        if (this.modDebug) {
            Logger.debuggingHigh = true;
            Logger.debugging = true;
        }
        this.cr.asc.setInfo(JC.getBoolName(9), Boolean.TRUE);
        this.symmetry = symmetry;
        this.setModulationForStructure(this.cr.asc.iSet, isPost);
        if (this.modDebug) {
            Logger.debuggingHigh = false;
            Logger.debugging = false;
        }
    }

    @Override
    public void finalizeModulation() {
        if (!this.finalized && this.modDim > 0 && !this.modVib) {
            if (this.modTUV != null) {
                this.cr.appendLoadNote("modTUV=" + this.modTUV);
            }
            this.cr.asc.setInfo("modulationOn", this.modTUV == null ? Boolean.TRUE : this.modTUV);
            this.cr.addJmolScript("set modulateOccupancy " + (this.haveOccupancy && !this.isCommensurate));
        }
        this.finalized = true;
    }

    private String checkKey(String key, boolean checkQ) {
        int pt = key.indexOf(this.atModel);
        return pt < 0 || key.indexOf("_pos#") >= 0 || key.indexOf("*;*") >= 0 || checkQ && key.indexOf("?") >= 0 ? null : key.substring(0, pt);
    }

    @Override
    public double[] getMod(String key) {
        return this.htModulation.get(key + this.atModel);
    }

    @Override
    public Map<String, double[]> getModulationMap() {
        return this.htModulation;
    }

    private void setModulationForStructure(int iModel, boolean isPost) throws Exception {
        int i0;
        this.atModel = "@" + iModel;
        if (this.htModulation.containsKey("X_" + this.atModel)) {
            return;
        }
        if (!isPost) {
            this.initModForStructure(iModel);
            return;
        }
        this.htModulation.put("X_" + this.atModel, new double[0]);
        this.cr.appendLoadNote(this.modCount + " modulations for " + this.ac + " modulated atoms");
        if (!this.haveAtomMods) {
            return;
        }
        int n = this.cr.asc.ac;
        this.atoms = this.cr.asc.atoms;
        if (this.symmetry != null) {
            this.nOps = this.symmetry.getSpaceGroupOperationCount();
        }
        this.supercellSymmetry = this.cr.asc.getXSymmetry().symmetry;
        if (this.supercellSymmetry == this.symmetry) {
            this.supercellSymmetry = null;
        }
        this.iopLast = -1;
        for (int i = i0 = this.cr.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
            this.modulateAtom(this.atoms[i]);
        }
        this.htAtomMods = null;
        if (this.minXYZ0 != null) {
            this.trimAtomSet();
        }
        this.htSubsystems = null;
    }

    private void initModForStructure(int iModel) throws Exception {
        String key;
        String k;
        double[] pt;
        if (this.legendres != null) {
            this.fixLegendre();
        }
        this.sigma = new Matrix(null, this.modDim, 3);
        this.qs = null;
        this.modMatrices = new Matrix[]{this.sigma, null};
        for (int i = 0; i < this.modDim; ++i) {
            pt = this.getMod("W_" + (i + 1));
            if (pt == null) {
                this.cr.appendLoadNote("NOTE!: Not enough cell wave vectors for d=" + this.modDim);
                return;
            }
            this.fixDoubleA(pt);
            this.cr.appendLoadNote("W_" + (i + 1) + " = " + Escape.e(pt));
            this.cr.appendUunitCellInfo("q" + (i + 1) + "=" + pt[0] + " " + pt[1] + " " + pt[2]);
            this.sigma.getArray()[i] = new double[]{pt[0], pt[1], pt[2]};
        }
        Hashtable<String, double[]> map = new Hashtable<String, double[]>();
        for (Map.Entry<String, double[]> e : this.htModulation.entrySet()) {
            k = e.getKey();
            key = this.checkKey(k, false);
            if (key == null) continue;
            pt = e.getValue();
            char ch = key.charAt(0);
            switch (ch) {
                case 'O': {
                    this.haveOccupancy = true;
                }
                case 'D': 
                case 'M': 
                case 'U': {
                    if (pt[2] != 1.0 || key.charAt(2) == 'S' || key.charAt(2) == 'T' || key.charAt(2) == 'L') break;
                    int ipt = key.indexOf("?");
                    if (ipt >= 0) {
                        k = key.substring(0, 2) + "_" + key.substring(ipt + 1) + generic;
                        pt = this.getMod(k);
                        if (pt == null) {
                            k = key.substring(0, 1) + "_" + key.substring(ipt + 1) + generic;
                            pt = this.getMod(k);
                        }
                        if (pt == null) break;
                        key = key.substring(0, ipt);
                        this.addModulation(map, key, pt, iModel);
                        break;
                    }
                    double a = pt[0];
                    double d = Math.PI * 2 * pt[1];
                    pt[0] = a * Math.cos(d);
                    pt[1] = a * Math.sin(-d);
                    pt[2] = 0.0;
                    Logger.info("msCIF setting " + key + " " + Escape.e(pt));
                    break;
                }
                case 'W': {
                    if (this.modDim > 1) break;
                }
                case 'F': {
                    if (key.indexOf("_coefs_") >= 0) {
                        this.cr.appendLoadNote("Wave vector " + key + "=" + Escape.eAD(pt));
                        break;
                    }
                    double[] ptHarmonic = this.calculateQCoefs(pt);
                    if (ptHarmonic == null) {
                        this.cr.appendLoadNote("Cannot match atom wave vector " + key + " " + Escape.eAD(pt) + " to a cell wave vector or its harmonic");
                        break;
                    }
                    String k2 = key + "_coefs_";
                    if (this.htModulation.containsKey(k2 + this.atModel)) break;
                    this.addModulation(map, k2, ptHarmonic, iModel);
                    if (!key.startsWith("F_")) break;
                    this.cr.appendLoadNote("atom wave vector " + key + " = " + Escape.e(pt) + " fn = " + Escape.e(ptHarmonic));
                }
            }
        }
        if (!map.isEmpty()) {
            this.htModulation.putAll(map);
        }
        if (this.htSubsystems == null) {
            this.haveAtomMods = false;
        } else {
            this.cr.strSupercell = null;
            this.haveAtomMods = true;
            this.htAtomMods = new Hashtable<String, Lst<Modulation>>();
        }
        for (Map.Entry<String, double[]> e : this.htModulation.entrySet()) {
            k = e.getKey();
            key = this.checkKey(k, true);
            if (key == null) continue;
            double[] params = e.getValue();
            String atomName = key.substring(key.indexOf(";") + 1);
            int pt_ = atomName.indexOf("#=");
            if (pt_ >= 0) {
                params = this.getMod(atomName.substring(pt_ + 2));
                atomName = atomName.substring(0, pt_);
            }
            if (Logger.debuggingHigh) {
                Logger.debug("SetModulation: " + key + " " + Escape.e(params));
            }
            char type = key.charAt(0);
            pt_ = key.indexOf("#") + 1;
            String utens = null;
            switch (type) {
                case 'U': {
                    utens = key.substring(pt_, key.indexOf(";"));
                }
                case 'D': 
                case 'M': 
                case 'O': {
                    if (this.modAverage) break;
                    char axis = key.charAt(pt_);
                    type = this.getModType(key);
                    if (this.htAtomMods == null) {
                        this.htAtomMods = new Hashtable<String, Lst<Modulation>>();
                    }
                    double[] p = new double[params.length];
                    int i = p.length;
                    while (--i >= 0) {
                        p[i] = params[i];
                    }
                    double[] qcoefs = this.getQCoefs(key);
                    if (qcoefs == null) {
                        System.err.println("Missing cell wave vector for atom wave vector for " + key + " " + Escape.e(params));
                        break;
                    }
                    this.addAtomModulation(atomName, axis, type, p, utens, qcoefs);
                    this.haveAtomMods = true;
                }
            }
        }
    }

    private void fixLegendre() {
        int i = this.legendres.size();
        while (--i >= 0) {
            String key = (String)this.legendres.get(i);
            double[] pt = this.htModulation.get(key);
            if (pt == null) continue;
            String key1 = "O_0#0" + key.substring(key.indexOf(";"));
            double[] pt1 = this.htModulation.get(key1);
            if (pt1 == null) {
                Logger.error("Crenel " + key1 + " not found for legendre modulation " + key);
                pt[2] = Double.NaN;
                continue;
            }
            this.htModulation.put(key, new double[]{pt1[0], pt1[1], pt[0], pt[1]});
        }
    }

    private void fixDoubleA(double[] pt) {
        if (this.cr.fixJavaFloat) {
            int i = pt.length;
            while (--i >= 0) {
                pt[i] = PT.fixDouble(pt[i], 100000.0);
            }
        }
    }

    @Override
    public double[] getQCoefs(String key) {
        int fn = Math.max(0, this.cr.parseIntAt(key, 2));
        if (fn == 0) {
            if (this.qlist100 == null) {
                this.qlist100 = new double[this.modDim];
                this.qlist100[0] = 1.0;
            }
            return this.qlist100;
        }
        double[] p = this.getMod("F_" + fn + "_coefs_");
        if (p == null) {
            p = this.getMod("F_coefs_" + fn);
        }
        return p;
    }

    @Override
    public char getModType(String key) {
        char type = key.charAt(0);
        char id = key.charAt(2);
        return (char)(id == 'S' ? 115 : (id == 'T' ? 116 : (id == 'L' ? (type == 'D' ? 108 : 76) : (id == '0' ? 99 : (type == 'D' ? 102 : (type == 'O' ? 111 : (type == 'M' ? 109 : (type == 'U' ? 117 : 63))))))));
    }

    private double[] calculateQCoefs(double[] p) {
        int i;
        if (this.qs == null) {
            this.qs = new P3[this.modDim];
            for (int i2 = 0; i2 < this.modDim; ++i2) {
                this.qs[i2] = this.toP3(this.getMod("W_" + (i2 + 1)));
            }
        }
        P3 pt = this.toP3(p);
        for (int i3 = 0; i3 < this.modDim; ++i3) {
            int ifn;
            if (this.qs[i3] == null || (ifn = this.approxInt(pt.dot(this.qs[i3]) / this.qs[i3].dot(this.qs[i3]))) == 0) continue;
            p = new double[this.modDim];
            p[i3] = ifn;
            return p;
        }
        P3 p3 = this.toP3(p);
        int jmin = this.modDim < 2 ? 0 : -3;
        int jmax = this.modDim < 2 ? 0 : 3;
        int kmin = this.modDim < 3 ? 0 : -3;
        int kmax = this.modDim < 3 ? 0 : 3;
        for (i = -4; i <= 4; ++i) {
            for (int j = jmin; j <= jmax; ++j) {
                for (int k = kmin; k <= kmax; ++k) {
                    pt.setT(this.qs[0]);
                    pt.scale(i);
                    if (this.modDim > 1 && this.qs[1] != null) {
                        pt.scaleAdd2(j, this.qs[1], pt);
                    }
                    if (this.modDim > 2 && this.qs[2] != null) {
                        pt.scaleAdd2(k, this.qs[2], pt);
                    }
                    if (pt.distanceSquared(p3) < 1.0E-4f) {
                        p = new double[this.modDim];
                        switch (this.modDim) {
                            default: {
                                p[2] = k;
                            }
                            case 2: {
                                p[1] = j;
                            }
                            case 1: 
                        }
                        p[0] = i;
                        return p;
                    }
                    pt.setT(this.qs[0]);
                    pt.scale(1.0f / (float)i);
                    if (this.modDim > 1 && this.qs[1] != null) {
                        pt.scaleAdd2(1.0f / (float)j, this.qs[1], pt);
                    }
                    if (this.modDim > 2 && this.qs[2] != null) {
                        pt.scaleAdd2(1.0f / (float)k, this.qs[2], pt);
                    }
                    if (!(pt.distanceSquared(p3) < 1.0E-4f)) continue;
                    p = new double[this.modDim];
                    switch (this.modDim) {
                        default: {
                            p[2] = 1.0f / (float)k;
                        }
                        case 2: {
                            p[1] = 1.0f / (float)j;
                        }
                        case 1: 
                    }
                    p[0] = 1.0f / (float)i;
                    return p;
                }
            }
        }
        pt = this.toP3(p);
        for (i = 0; i < this.modDim; ++i) {
            if (this.qs[i] == null) continue;
            p3 = this.qs[i];
            int ifn = 0;
            if (pt.x != 0.0f) {
                ifn = this.approxInt(pt.x / p3.x);
            }
            if (pt.y != 0.0f) {
                ifn = Math.max(this.approxInt(pt.y / p3.y), ifn);
            }
            if (ifn == 0 && pt.z != 0.0f) {
                ifn = Math.max(this.approxInt(pt.z / p3.z), ifn);
            }
            if (ifn == 0 || p3.x != 0.0f && this.approxInt(10.0f + p3.x * (float)ifn - pt.x) == 0 || p3.y != 0.0f && this.approxInt(10.0f + p3.y * (float)ifn - pt.y) == 0 || p3.z != 0.0f && this.approxInt(10.0f + p3.z * (float)ifn - pt.z) == 0) continue;
            p = new double[this.modDim];
            p[i] = ifn;
            return p;
        }
        return null;
    }

    private int approxInt(float fn) {
        int ifn = Math.round(fn);
        return Math.abs(fn - (float)ifn) < 0.001f ? ifn : 0;
    }

    private P3 toP3(double[] x) {
        return P3.new3((float)x[0], (float)x[1], (float)x[2]);
    }

    private void addAtomModulation(String atomName, char axis, char type, double[] params, String utens, double[] qcoefs) {
        Lst<Modulation> list = this.htAtomMods.get(atomName);
        if (list == null) {
            ++this.ac;
            list = new Lst();
            this.htAtomMods.put(atomName, list);
        }
        list.addLast(new Modulation(axis, type, params, utens, qcoefs));
        ++this.modCount;
    }

    @Override
    public void addSubsystem(String code, Matrix w) {
        if (code == null) {
            return;
        }
        Subsystem ss = new Subsystem(this, code, w);
        this.cr.appendLoadNote("subsystem " + code + "\n" + w);
        this.setSubsystem(code, ss);
    }

    private void addUStr(Atom atom, String id, float val) {
        int i = U_LIST.indexOf(id) / 3;
        if (Logger.debuggingHigh) {
            Logger.debug("MOD RDR adding " + id + " " + i + " " + val + " to " + atom.anisoBorU[i]);
        }
        this.cr.asc.setU(atom, i, val + atom.anisoBorU[i]);
    }

    private void modulateAtom(Atom a) {
        Lst<Modulation> list;
        if (this.modCoord && this.htSubsystems != null) {
            P3 ptc = P3.newP(a);
            SymmetryInterface spt = this.getSymmetry(a);
            spt.toCartesian(ptc, true);
        }
        if ((list = this.htAtomMods.get(a.atomName)) == null && a.altLoc != '\u0000' && this.htSubsystems != null) {
            list = new Lst();
        }
        if (list == null || this.symmetry == null || a.bsSymmetry == null) {
            return;
        }
        int iop = Math.max(a.bsSymmetry.nextSetBit(0), 0);
        if (this.modLast) {
            iop = Math.max((a.bsSymmetry.length() - 1) % this.nOps, iop);
        }
        if (Logger.debuggingHigh) {
            Logger.info("\nsetModulation: i=" + a.index + " " + a.atomName + " xyz=" + a + " occ=" + a.foccupancy);
        }
        if (iop != this.iopLast) {
            this.iopLast = iop;
            this.gammaE = new M3();
            this.getSymmetry(a).getSpaceGroupOperation(iop).getRotationScale(this.gammaE);
        }
        if (Logger.debugging) {
            Logger.debug("setModulation iop = " + iop + " " + this.symmetry.getSpaceGroupXyz(iop, false) + " " + a.bsSymmetry);
        }
        ModulationSet ms = new ModulationSet().setMod(a.index + " " + a.atomName, this.getAtomR0(this.cr.asc.atoms[a.atomSite]), this.getAtomR0(a), this.modDim, list, this.gammaE, this.getMatrices(a), this.getSymmetry(a), this.nOps, iop, a.vib instanceof Vibration ? (Vibration)a.vib : null, this.isCommensurate);
        ms.calculate(this.modTUV, false);
        if (!Float.isNaN(ms.vOcc)) {
            a.foccupancy = ms.setOccupancy(this.getMod("J_O#0;" + a.atomName), a.foccupancy, a.vib == null ? 0.0f : a.vib.x);
        }
        if (ms.htUij != null) {
            Tensor t;
            Tensor tensor = t = a.tensors == null ? null : (Tensor)a.tensors.get(0);
            if (t != null && t.parBorU != null) {
                a.anisoBorU = new float[8];
                for (int i = 0; i < 8; ++i) {
                    a.anisoBorU[i] = t.parBorU[i];
                }
                t.isUnmodulated = true;
            }
            if (a.anisoBorU == null) {
                Logger.error("MOD RDR cannot modulate nonexistent atom anisoBorU for atom " + a.atomName);
            } else {
                if (Logger.debuggingHigh) {
                    Logger.info("setModulation Uij(initial)=" + Escape.eAF(a.anisoBorU));
                    Logger.info("setModulation tensor=" + Escape.e(((Tensor)a.tensors.get(0)).getInfo("all")));
                }
                for (Map.Entry<String, Float> e : ms.htUij.entrySet()) {
                    this.addUStr(a, e.getKey(), e.getValue().floatValue());
                }
                SymmetryInterface sym = this.getAtomSymmetry(a, this.symmetry);
                t = this.cr.asc.getXSymmetry().addRotatedTensor(a, sym.getTensor(this.cr.vwr, a.anisoBorU), iop, false, sym);
                t.isModulated = true;
                t.id = Escape.e(a.anisoBorU);
                a.bfactor = a.anisoBorU[7] * 100.0f;
                a.anisoBorU = null;
                if (Logger.debuggingHigh) {
                    Logger.debug("setModulation Uij(final)=" + Escape.eAF(a.anisoBorU) + "\n");
                    Logger.debug("setModulation tensor=" + Escape.e(((Tensor)a.tensors.get(1)).getInfo("all")));
                }
            }
        }
        if (Float.isNaN(ms.x)) {
            ms.set(0.0f, 0.0f, 0.0f);
        }
        a.vib = ms;
    }

    private P3 getAtomR0(Atom atom) {
        P3 r0 = P3.newP(atom);
        if (this.supercellSymmetry != null) {
            this.supercellSymmetry.toCartesian(r0, true);
            this.symmetry.toFractional(r0, true);
        }
        return r0;
    }

    @Override
    public SymmetryInterface getAtomSymmetry(Atom a, SymmetryInterface defaultSymmetry) {
        Subsystem ss;
        return this.htSubsystems == null || (ss = this.getSubsystem(a)) == null ? defaultSymmetry : ss.getSymmetry();
    }

    private void setSubsystem(String code, Subsystem system) {
        if (this.htSubsystems == null) {
            this.htSubsystems = new Hashtable<String, Subsystem>();
        }
        this.htSubsystems.put(code, system);
        this.setSubsystemOptions();
    }

    private Matrix[] getMatrices(Atom a) {
        Subsystem ss = this.getSubsystem(a);
        return ss == null ? this.modMatrices : ss.getModMatrices();
    }

    private SymmetryInterface getSymmetry(Atom a) {
        Subsystem ss = this.getSubsystem(a);
        return ss == null ? this.symmetry : ss.getSymmetry();
    }

    private Subsystem getSubsystem(Atom a) {
        return this.htSubsystems == null ? null : this.htSubsystems.get("" + a.altLoc);
    }

    @Override
    public void setMinMax0(P3 minXYZ, P3 maxXYZ) {
        if (this.htSubsystems == null) {
            return;
        }
        SymmetryInterface symmetry = this.getDefaultUnitCell();
        this.minXYZ0 = P3.newP(minXYZ);
        this.maxXYZ0 = P3.newP(maxXYZ);
        P3 pt0 = P3.newP(minXYZ);
        P3 pt1 = P3.newP(maxXYZ);
        P3 pt = new P3();
        symmetry.toCartesian(pt0, true);
        symmetry.toCartesian(pt1, true);
        P3[] pts = BoxInfo.unitCubePoints;
        if (this.sigma == null) {
            Logger.error("Why are we in MSRdr.setMinMax0 without modulation init?");
            return;
        }
        for (Map.Entry<String, Subsystem> e : this.htSubsystems.entrySet()) {
            SymmetryInterface sym = e.getValue().getSymmetry();
            int i = 8;
            while (--i >= 0) {
                pt.x = pts[i].x == 0.0f ? pt0.x : pt1.x;
                pt.y = pts[i].y == 0.0f ? pt0.y : pt1.y;
                pt.z = pts[i].z == 0.0f ? pt0.z : pt1.z;
                this.expandMinMax(pt, sym, minXYZ, maxXYZ);
            }
        }
    }

    private void expandMinMax(P3 pt, SymmetryInterface sym, P3 minXYZ, P3 maxXYZ) {
        P3 pt2 = P3.newP(pt);
        float slop = 1.0E-4f;
        sym.toFractional(pt2, false);
        if (minXYZ.x > pt2.x + slop) {
            minXYZ.x = (int)Math.floor(pt2.x) - 1;
        }
        if (minXYZ.y > pt2.y + slop) {
            minXYZ.y = (int)Math.floor(pt2.y) - 1;
        }
        if (minXYZ.z > pt2.z + slop) {
            minXYZ.z = (int)Math.floor(pt2.z) - 1;
        }
        if (maxXYZ.x < pt2.x - slop) {
            maxXYZ.x = (int)Math.ceil(pt2.x) + 1;
        }
        if (maxXYZ.y < pt2.y - slop) {
            maxXYZ.y = (int)Math.ceil(pt2.y) + 1;
        }
        if (maxXYZ.z < pt2.z - slop) {
            maxXYZ.z = (int)Math.ceil(pt2.z) + 1;
        }
    }

    private void trimAtomSet() {
        if (!this.cr.doApplySymmetry) {
            return;
        }
        AtomSetCollection asc = this.cr.asc;
        SymmetryInterface sym = this.getDefaultUnitCell();
        Atom[] atoms = asc.atoms;
        P3 pt = new P3();
        BS bs = asc.getBSAtoms(-1);
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            boolean isOK;
            Atom a = atoms[i];
            boolean bl = isOK = !this.isCommensurate || this.modAverage || a.foccupancy >= 0.5f;
            if (isOK) {
                pt.setT(a);
                if (a.vib != null) {
                    pt.add(a.vib);
                }
                this.getSymmetry(a).toCartesian(pt, false);
                sym.toFractional(pt, false);
                if (this.cr.fixJavaFloat) {
                    PT.fixPtFloats(pt, 100000.0f);
                }
                isOK = asc.xtalSymmetry.isWithinCell(3, pt, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z, 0.001f);
            }
            if (isOK) {
                if (this.cr.fixJavaFloat) {
                    PT.fixPtFloats(a, 100000.0f);
                }
            } else {
                bs.clear(i);
            }
            i = bs.nextSetBit(i + 1);
        }
    }

    private SymmetryInterface getDefaultUnitCell() {
        return this.modCell != null && this.htSubsystems.containsKey(this.modCell) ? this.htSubsystems.get(this.modCell).getSymmetry() : this.cr.asc.getSymmetry();
    }

    @Override
    public SymmetryInterface getSymmetryFromCode(String code) {
        return this.htSubsystems.get(code).getSymmetry();
    }

    @Override
    public boolean addLatticeVector(Lst<float[]> lattvecs, String data) throws Exception {
        float[] a = null;
        char c = data.charAt(0);
        int dim = this.modDim + 3;
        switch (c) {
            case 'P': 
            case 'X': {
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'I': {
                a = new float[]{0.5f, 0.5f, 0.5f};
                if (c == 'I') break;
                a[c - 65] = 0.0f;
                break;
            }
            case 'F': {
                this.addLatticeVector(lattvecs, "A");
                this.addLatticeVector(lattvecs, "B");
                this.addLatticeVector(lattvecs, "C");
                break;
            }
            case 'M': {
                ++dim;
            }
            case '0': {
                if (data.indexOf(".") < 0) break;
                a = AtomSetCollectionReader.getTokensFloat(data, null, dim);
                break;
            }
            default: {
                return false;
            }
        }
        if (a != null) {
            lattvecs.addLast(a);
        }
        return true;
    }
}

