/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.DiscriminatingNameMapper$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.util.ChecksumUtils;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="discriminating")
public class DiscriminatingNameMapper
implements NameMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscriminatingNameMapper.class);
    private final NameMapper nameMapper;
    private final String hostname;

    @Inject
    public DiscriminatingNameMapper(@Named(value="gav") NameMapper nameMapper) {
        NameMapper nameMapper2 = nameMapper;
        nameMapper2.getClass();
        this.nameMapper = nameMapper2;
        this.hostname = this.getHostname();
    }

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        String discriminator;
        String string = discriminator = this.createDiscriminator(session);
        return this.nameMapper.nameLocks(session, artifacts, metadatas).stream().map(new DiscriminatingNameMapper$$Lambda$0(string)).collect(Collectors.toList());
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Failed to get hostname, using '{}'", (Object)"localhost", (Object)e);
            return "localhost";
        }
    }

    private String createDiscriminator(RepositorySystemSession session) {
        String discriminator = ConfigUtils.getString(session, null, "aether.syncContext.named.discriminating.discriminator");
        if (discriminator == null || discriminator.isEmpty()) {
            String hostname = ConfigUtils.getString(session, this.hostname, "aether.syncContext.named.discriminating.hostname");
            File basedir = session.getLocalRepository().getBasedir();
            discriminator = hostname + ":" + basedir;
            try {
                Map<String, Object> checksums = ChecksumUtils.calc(discriminator.getBytes(StandardCharsets.UTF_8), Collections.singletonList("SHA-1"));
                Object checksum = checksums.get("SHA-1");
                if (checksum instanceof Exception) {
                    throw (Exception)checksum;
                }
                return String.valueOf(checksum);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to calculate discriminator digest, using '{}'", (Object)"da39a3ee5e6b4b0d3255bfef95601890afd80709", (Object)e);
                return "da39a3ee5e6b4b0d3255bfef95601890afd80709";
            }
        }
        return discriminator;
    }

    private static /* synthetic */ String lambda$nameLocks$0(String discriminator, String s) {
        return discriminator + ":" + s;
    }

    static /* synthetic */ String accessor$DiscriminatingNameMapper$lambda0(String string, String string2) {
        return DiscriminatingNameMapper.lambda$nameLocks$0(string, string2);
    }
}

