/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshotExternalizer;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotBuildReporter;
import org.jetbrains.kotlin.incremental.classpathDiff.InMemoryCacheWithEviction;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/CachedClasspathSnapshotSerializer;", "", "()V", "cache", "Lorg/jetbrains/kotlin/incremental/classpathDiff/InMemoryCacheWithEviction;", "Ljava/io/File;", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathEntrySnapshot;", "load", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshot;", "classpathEntrySnapshotFiles", "", "reporter", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshotBuildReporter;", "incremental-compilation-impl"})
public final class CachedClasspathSnapshotSerializer {
    @NotNull
    public static final CachedClasspathSnapshotSerializer INSTANCE = new CachedClasspathSnapshotSerializer();
    @NotNull
    private static final InMemoryCacheWithEviction<File, ClasspathEntrySnapshot> cache = new InMemoryCacheWithEviction(20, 1000, 0.8, null, 8, null);

    private CachedClasspathSnapshotSerializer() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClasspathSnapshot load(@NotNull List<? extends File> classpathEntrySnapshotFiles, @NotNull ClasspathSnapshotBuildReporter reporter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(classpathEntrySnapshotFiles, "classpathEntrySnapshotFiles");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        cache.newTimePeriod();
        Ref.LongRef cacheMisses = new Ref.LongRef();
        Iterable $this$map$iv = classpathEntrySnapshotFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void snapshotFile;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(cache.computeIfAbsent((File)snapshotFile, new Function1<File, ClasspathEntrySnapshot>(cacheMisses){
                final /* synthetic */ Ref.LongRef $cacheMisses;
                {
                    this.$cacheMisses = $cacheMisses;
                    super(1);
                }

                @NotNull
                public final ClasspathEntrySnapshot invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    long l = this.$cacheMisses.element;
                    this.$cacheMisses.element = l + 1L;
                    return (ClasspathEntrySnapshot)ExternalizersKt.loadFromFile(ClasspathEntrySnapshotExternalizer.INSTANCE, it);
                }
            }));
        }
        List list2 = (List)destination$iv$iv;
        ClasspathSnapshot classpathSnapshot2 = new ClasspathSnapshot(list2);
        cache.evictEntries();
        reporter.addMetric(BuildPerformanceMetric.LOAD_CLASSPATH_SNAPSHOT_EXECUTION_COUNT, 1L);
        reporter.addMetric(BuildPerformanceMetric.LOAD_CLASSPATH_ENTRY_SNAPSHOT_CACHE_HITS, (long)classpathEntrySnapshotFiles.size() - cacheMisses.element);
        reporter.addMetric(BuildPerformanceMetric.LOAD_CLASSPATH_ENTRY_SNAPSHOT_CACHE_MISSES, cacheMisses.element);
        return classpathSnapshot2;
    }
}

