/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u0011\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0004*\u00020\u0004H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SimpleJsCodeInliner;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "replacements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "(Ljava/util/Map;)V", "temporaryNamesForExpressions", "", "visitNameRef", "", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "withTemporaryVariablesForExpressions", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "statements", "declareNewTemporaryFor", "expression", "getReplacement", "backend.js"})
final class SimpleJsCodeInliner
extends RecursiveJsVisitor {
    @NotNull
    private final Map<JsName, JsExpression> replacements;
    @NotNull
    private final Map<JsName, JsExpression> temporaryNamesForExpressions;

    public SimpleJsCodeInliner(@NotNull Map<JsName, ? extends JsExpression> replacements) {
        Intrinsics.checkNotNullParameter(replacements, "replacements");
        this.replacements = replacements;
        this.temporaryNamesForExpressions = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JsStatement> withTemporaryVariablesForExpressions(@NotNull List<? extends JsStatement> statements) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(statements, "statements");
        if (this.temporaryNamesForExpressions.isEmpty()) {
            return statements;
        }
        Map<JsName, JsExpression> $this$map$iv = this.temporaryNamesForExpressions;
        boolean $i$f$map = false;
        Map<JsName, JsExpression> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JsVars(new JsVars.JsVar((JsName)it.getKey(), (JsExpression)it.getValue())));
        }
        List variableDeclarations = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)variableDeclarations, (Iterable)statements);
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        Intrinsics.checkNotNullParameter(nameRef, "nameRef");
        super.visitNameRef(nameRef);
        if (nameRef.getQualifier() != null) {
            return;
        }
        JsName jsName = nameRef.getName();
        if (jsName == null || (jsName = this.getReplacement(jsName)) == null) {
            return;
        }
        nameRef.setName(jsName);
    }

    private final JsName declareNewTemporaryFor(JsName $this$declareNewTemporaryFor, JsExpression expression2) {
        JsName jsName;
        JsName it = jsName = new JsName($this$declareNewTemporaryFor.getIdent(), true);
        boolean bl = false;
        this.temporaryNamesForExpressions.put(it, expression2);
        return jsName;
    }

    private final JsName getReplacement(JsName $this$getReplacement) {
        JsName jsName;
        JsExpression jsExpression = this.replacements.get($this$getReplacement);
        if (jsExpression == null) {
            return null;
        }
        JsExpression expression2 = jsExpression;
        if (expression2 instanceof JsNameRef && ((JsNameRef)expression2).getQualifier() == null) {
            JsName jsName2 = ((JsNameRef)expression2).getName();
            jsName = jsName2;
            Intrinsics.checkNotNull(jsName2);
        } else {
            jsName = this.declareNewTemporaryFor($this$getReplacement, expression2);
        }
        return jsName;
    }
}

