"use strict";
// the simple recursive removal, where unlink and rmdir are atomic
// Note that this approach does NOT work on Windows!
// We rmdir before unlink even though that is arguably less efficient
// (since the average folder contains >1 file, it means more system
// calls), because sunos will let root unlink a directory, and some
// SUPER weird breakage happens as a result.
Object.defineProperty(exports, "__esModule", { value: true });
exports.rimrafPosixSync = exports.rimrafPosix = void 0;
const fs_js_1 = require("./fs.js");
const { rmdir, unlink } = fs_js_1.promises;
const path_1 = require("path");
const readdir_or_error_js_1 = require("./readdir-or-error.js");
const ignore_enoent_js_1 = require("./ignore-enoent.js");
const rimrafPosix = async (path, opt) => {
    if (opt?.signal?.aborted) {
        throw opt.signal.reason;
    }
    const entries = await (0, readdir_or_error_js_1.readdirOrError)(path);
    if (!Array.isArray(entries)) {
        if (entries.code === 'ENOENT') {
            return true;
        }
        if (entries.code !== 'ENOTDIR') {
            throw entries;
        }
        if (opt.filter && !(await opt.filter(path))) {
            return false;
        }
        await (0, ignore_enoent_js_1.ignoreENOENT)(unlink(path));
        return true;
    }
    const removedAll = (await Promise.all(entries.map(entry => (0, exports.rimrafPosix)((0, path_1.resolve)(path, entry), opt)))).reduce((a, b) => a && b, true);
    if (!removedAll) {
        return false;
    }
    // we don't ever ACTUALLY try to unlink /, because that can never work
    // but when preserveRoot is false, we could be operating on it.
    // No need to check if preserveRoot is not false.
    if (opt.preserveRoot === false && path === (0, path_1.parse)(path).root) {
        return false;
    }
    if (opt.filter && !(await opt.filter(path))) {
        return false;
    }
    await (0, ignore_enoent_js_1.ignoreENOENT)(rmdir(path));
    return true;
};
exports.rimrafPosix = rimrafPosix;
const rimrafPosixSync = (path, opt) => {
    if (opt?.signal?.aborted) {
        throw opt.signal.reason;
    }
    const entries = (0, readdir_or_error_js_1.readdirOrErrorSync)(path);
    if (!Array.isArray(entries)) {
        if (entries.code === 'ENOENT') {
            return true;
        }
        if (entries.code !== 'ENOTDIR') {
            throw entries;
        }
        if (opt.filter && !opt.filter(path)) {
            return false;
        }
        (0, ignore_enoent_js_1.ignoreENOENTSync)(() => (0, fs_js_1.unlinkSync)(path));
        return true;
    }
    let removedAll = true;
    for (const entry of entries) {
        removedAll = (0, exports.rimrafPosixSync)((0, path_1.resolve)(path, entry), opt) && removedAll;
    }
    if (opt.preserveRoot === false && path === (0, path_1.parse)(path).root) {
        return false;
    }
    if (!removedAll) {
        return false;
    }
    if (opt.filter && !opt.filter(path)) {
        return false;
    }
    (0, ignore_enoent_js_1.ignoreENOENTSync)(() => (0, fs_js_1.rmdirSync)(path));
    return true;
};
exports.rimrafPosixSync = rimrafPosixSync;
//# sourceMappingURL=rimraf-posix.js.map