"""
Constant values for lifecycle of Apk.
"""

component_class = [
    "android.app.Activity",
    "android.app.Service",
    "android.content.BroadcastReceiver",
    "android.content.ContentProvider",
    "com.google.android.gcm.GCMBaseIntentService",
    "com.google.android.gms.gcm.GcmListenerService",
    "android.app.Application",
    "android.app.Fragment",
    "android.support.v4.app.Fragment",
    "androidx.fragment.app.Fragment",
    "android.content.ServiceConnection",
    "com.google.android.maps.MapActivity",
    "android.support.v4.app.AppCompatActivity",
    "android.support.v7.app.AppCompatActivity",
    "androidx.appcompat.app.AppCompatActivity",
    "android.content.ComponentCallbacks",
    "android.content.ComponentCallbacks2",
]
callback = {
    'activity': [
        "onCreate(android.os.Bundle)",
        "onStart()",
        "onRestoreInstanceState(android.os.Bundle)",
        "onPostCreate(android.os.Bundle)",
        "onResume()",
        "onPostResume()",
        "onCreateDescription()",
        "onSaveInstanceState(android.os.Bundle)",
        "onPause()",
        "onStop()",
        "onRestart()",
        "onDestroy()",
        "onAttachFragment(android.app.Fragment)",
    ],
    'service': [
        "onCreate()",
        "onStart(android.content.Intent,int)",
        "onStartCommand(android.content.Intent,int,int)",
        "onBind(android.content.Intent)",
        "onRebind(android.content.Intent)",
        "onUnbind(android.content.Intent)",
        "onDestroy()",
    ],
    'receiver': [
        "onReceive(android.content.Context,android.content.Intent)",
    ],
    'provider': [
        "onCreate()",
        "insert(android.net.Uri,android.content.ContentValues)",
        "query(android.net.Uri,java.lang.String[],java.lang.String,java.lang.String[],java.lang.String)",
        "update(android.net.Uri,android.content.ContentValues,java.lang.String,java.lang.String[])",
        "delete(android.net.Uri,java.lang.String,java.lang.String[])",
        "getType(android.net.Uri)",
    ],
    'gcmintentservice': [
        "onDeletedMessages(android.content.Context,int)",
        "onError(android.content.Context,java.lang.String)",
        "onMessage(android.content.Context,android.content.Intent)",
        "onRecoverableError(android.content.Context,java.lang.String)",
        "onRegistered(android.content.Context,java.lang.String)",
        "onUnregistered(android.content.Context,java.lang.String)",
    ],
    'gcmlistenerservice': [
        "onDeletedMessages()",
        "onMessageReceived(java.lang.String,android.os.Bundle)",
        "onMessageSent(java.lang.String)",
        "onSendError(java.lang.String,java.lang.String)",
    ],
    'application': [
        "onCreate()",
        "onTerminate()",
        "onServiceConnected(android.content.ComponentName,android.os.IBinder)",
        "onServiceDisconnected(android.content.ComponentName)",
        "android.app.Application$ActivityLifecycleCallbacks",
        "onActivityStarted(android.app.Activity)",
        "onActivityStopped(android.app.Activity)",
        "onActivitySaveInstanceState(android.app.Activity,android.os.Bundle)",
        "onActivityResumed(android.app.Activity)",
        "onActivityPaused(android.app.Activity)",
        "onActivityDestroyed(android.app.Activity)",
        "onActivityCreated(android.app.Activity,android.os.Bundle)",
        "onLowMemory()",
        "onConfigurationChanged(android.content.res.Configuration)",
        "onTrimMemory(int)",
    ],
    'fragment': [
        "onCreate(android.os.Bundle)",
        "onAttach(android.app.Activity)",
        "onCreateView(android.view.LayoutInflater,android.view.ViewGroup,android.os.Bundle)",
        "onViewCreated(android.view.View,android.os.Bundle)",
        "onStart()",
        "onActivityCreated(android.os.Bundle)",
        "onViewStateRestored(android.app.Activity)",
        "onResume()",
        "onPause()",
        "onStop()",
        "onDestroyView()",
        "onDestroy()",
        "onDetach()",
        "onSaveInstanceState(android.os.Bundle)",
    ]
}
