/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class BigIntToFixedConverter
extends AbstractArrowVectorConverter {
    protected BigIntVector bigIntVector;
    protected int sfScale;
    protected ByteBuffer byteBuf = ByteBuffer.allocate(8);

    public BigIntToFixedConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(String.format("%s(%s,%s)", new Object[]{SnowflakeType.FIXED, fieldVector.getField().getMetadata().get("precision"), fieldVector.getField().getMetadata().get("scale")}), fieldVector, columnIndex, context);
        this.bigIntVector = (BigIntVector)fieldVector;
    }

    @Override
    public byte[] toBytes(int index) {
        if (this.isNull(index)) {
            return null;
        }
        this.byteBuf.putLong(0, this.getLong(index));
        return this.byteBuf.array();
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        long longVal = this.toLong(index);
        if (longVal == 0L) {
            return false;
        }
        if (longVal == 1L) {
            return true;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "boolean", longVal);
    }

    @Override
    public byte toByte(int index) throws SFException {
        long longVal = this.toLong(index);
        byte byteVal = (byte)longVal;
        if ((long)byteVal == longVal) {
            return byteVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte", longVal);
    }

    @Override
    public short toShort(int index) throws SFException {
        long longVal = this.toLong(index);
        short shortVal = (short)longVal;
        if ((long)shortVal == longVal) {
            return shortVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "short", longVal);
    }

    @Override
    public int toInt(int index) throws SFException {
        long longVal = this.toLong(index);
        int intVal = (int)longVal;
        if ((long)intVal == longVal) {
            return intVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "int", longVal);
    }

    protected long getLong(int index) {
        return this.bigIntVector.getDataBuffer().getLong(index * 8);
    }

    @Override
    public long toLong(int index) throws SFException {
        if (this.bigIntVector.isNull(index)) {
            return 0L;
        }
        return this.getLong(index);
    }

    @Override
    public float toFloat(int index) throws SFException {
        return this.toLong(index);
    }

    @Override
    public double toDouble(int index) throws SFException {
        return this.toLong(index);
    }

    @Override
    public BigDecimal toBigDecimal(int index) {
        if (this.bigIntVector.isNull(index)) {
            return null;
        }
        return BigDecimal.valueOf(this.getLong(index), this.sfScale);
    }

    @Override
    public Object toObject(int index) throws SFException {
        if (this.bigIntVector.isNull(index)) {
            return null;
        }
        return this.getLong(index);
    }

    @Override
    public String toString(int index) {
        return this.isNull(index) ? null : Long.toString(this.getLong(index));
    }
}

