/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jpountz.lz4.LZ4UnknownSizeDecompressor;

public abstract class LZ4SafeDecompressor
implements LZ4UnknownSizeDecompressor {
    @Override
    public abstract int decompress(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    public abstract int decompress(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    @Override
    public final int decompress(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        return this.decompress(byArray, n2, n3, byArray2, n4, byArray2.length - n4);
    }

    public final int decompress(byte[] byArray, byte[] byArray2) {
        return this.decompress(byArray, 0, byArray.length, byArray2, 0);
    }

    public final byte[] decompress(byte[] byArray, int n2, int n3, int n4) {
        byte[] byArray2 = new byte[n4];
        int n5 = this.decompress(byArray, n2, n3, byArray2, 0, n4);
        if (n5 != byArray2.length) {
            byArray2 = Arrays.copyOf(byArray2, n5);
        }
        return byArray2;
    }

    public final byte[] decompress(byte[] byArray, int n2) {
        return this.decompress(byArray, 0, byArray.length, n2);
    }

    public final void decompress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n2 = this.decompress(byteBuffer, byteBuffer.position(), byteBuffer.remaining(), byteBuffer2, byteBuffer2.position(), byteBuffer2.remaining());
        byteBuffer.position(byteBuffer.limit());
        byteBuffer2.position(byteBuffer2.position() + n2);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

