/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.s3;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.apache.lucene.store.BufferedIndexInput;

class S3IndexInput
extends BufferedIndexInput {
    static final int LOCAL_BUFFER_SIZE = 16384;
    private final InputStream inputStream;
    private final long length;
    private long position;

    S3IndexInput(InputStream inputStream, String path, long length) {
        super(path);
        this.inputStream = inputStream;
        this.length = length;
    }

    protected void readInternal(ByteBuffer b) throws IOException {
        int read;
        int expectedLength = b.remaining();
        byte[] localBuffer = b.hasArray() ? b.array() : new byte[16384];
        while (b.hasRemaining() && (read = b.hasArray() ? this.inputStream.read(localBuffer, b.arrayOffset() + b.position(), b.remaining()) : this.inputStream.read(localBuffer, 0, Math.min(b.remaining(), 16384))) >= 0) {
            if (b.hasArray()) {
                b.position(b.position() + read);
                continue;
            }
            b.put(localBuffer, 0, read);
        }
        if (b.remaining() > 0) {
            throw new IOException(String.format(Locale.ROOT, "Failed to read %d bytes; only %d available", expectedLength, expectedLength - b.remaining()));
        }
        this.position += (long)expectedLength;
    }

    protected void seekInternal(long toPosition) throws IOException {
        if (toPosition > this.length()) {
            throw new EOFException("read past EOF: pos=" + toPosition + " vs length=" + this.length() + ": " + (Object)((Object)this));
        }
        while (this.position < toPosition) {
            long skipped = this.inputStream.skip(toPosition - this.position);
            if (skipped == 0L) {
                if (this.inputStream.read() == -1) break;
                skipped = 1L;
            }
            this.position += skipped;
        }
        if (this.position > toPosition) {
            throw new IOException("Cannot seek backward");
        }
    }

    public final long length() {
        return this.length;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

