/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.BinaryDocValuesWriter;
import org.apache.lucene.index.DocConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesLeafReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexSorter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.NormValuesWriter;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.NumericDocValuesWriter;
import org.apache.lucene.index.PointValuesWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedDocValuesWriter;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedNumericDocValuesWriter;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.SortedSetDocValuesWriter;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.SortingStoredFieldsConsumer;
import org.apache.lucene.index.SortingTermVectorsConsumer;
import org.apache.lucene.index.StoredFieldsConsumer;
import org.apache.lucene.index.TermVectorsConsumer;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.IntBlockPool;
import org.apache.lucene.util.RamUsageEstimator;

final class DefaultIndexingChain
extends DocConsumer {
    final Counter bytesUsed = Counter.newCounter();
    final FieldInfos.Builder fieldInfos;
    final TermsHash termsHash;
    final ByteBlockPool docValuesBytePool;
    final StoredFieldsConsumer storedFieldsConsumer;
    final TermVectorsConsumer termVectorsWriter;
    private PerField[] fieldHash = new PerField[2];
    private int hashMask = 1;
    private int totalFieldCount;
    private long nextFieldGen;
    private PerField[] fields = new PerField[1];
    private final InfoStream infoStream;
    private final ByteBlockPool.Allocator byteBlockAllocator;
    private final LiveIndexWriterConfig indexWriterConfig;
    private final int indexCreatedVersionMajor;
    private final Consumer<Throwable> abortingExceptionConsumer;
    private boolean hasHitAbortingException;

    DefaultIndexingChain(int indexCreatedVersionMajor, SegmentInfo segmentInfo, Directory directory, FieldInfos.Builder fieldInfos, LiveIndexWriterConfig indexWriterConfig, Consumer<Throwable> abortingExceptionConsumer) {
        this.indexCreatedVersionMajor = indexCreatedVersionMajor;
        this.byteBlockAllocator = new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed);
        IntBlockAllocator intBlockAllocator = new IntBlockAllocator(this.bytesUsed);
        this.indexWriterConfig = indexWriterConfig;
        assert (segmentInfo.getIndexSort() == indexWriterConfig.getIndexSort());
        this.fieldInfos = fieldInfos;
        this.infoStream = indexWriterConfig.getInfoStream();
        this.abortingExceptionConsumer = abortingExceptionConsumer;
        if (segmentInfo.getIndexSort() == null) {
            this.storedFieldsConsumer = new StoredFieldsConsumer(indexWriterConfig.getCodec(), directory, segmentInfo);
            this.termVectorsWriter = new TermVectorsConsumer(intBlockAllocator, this.byteBlockAllocator, directory, segmentInfo, indexWriterConfig.getCodec());
        } else {
            this.storedFieldsConsumer = new SortingStoredFieldsConsumer(indexWriterConfig.getCodec(), directory, segmentInfo);
            this.termVectorsWriter = new SortingTermVectorsConsumer(intBlockAllocator, this.byteBlockAllocator, directory, segmentInfo, indexWriterConfig.getCodec());
        }
        this.termsHash = new FreqProxTermsWriter(intBlockAllocator, this.byteBlockAllocator, this.bytesUsed, this.termVectorsWriter);
        this.docValuesBytePool = new ByteBlockPool(this.byteBlockAllocator);
    }

    private void onAbortingException(Throwable th) {
        assert (th != null);
        this.hasHitAbortingException = true;
        this.abortingExceptionConsumer.accept(th);
    }

    private LeafReader getDocValuesLeafReader() {
        return new DocValuesLeafReader(){

            @Override
            public NumericDocValues getNumericDocValues(String field) {
                PerField pf = DefaultIndexingChain.this.getPerField(field);
                if (pf == null) {
                    return null;
                }
                if (pf.fieldInfo.getDocValuesType() == DocValuesType.NUMERIC) {
                    return (NumericDocValues)pf.docValuesWriter.getDocValues();
                }
                return null;
            }

            @Override
            public BinaryDocValues getBinaryDocValues(String field) {
                PerField pf = DefaultIndexingChain.this.getPerField(field);
                if (pf == null) {
                    return null;
                }
                if (pf.fieldInfo.getDocValuesType() == DocValuesType.BINARY) {
                    return (BinaryDocValues)pf.docValuesWriter.getDocValues();
                }
                return null;
            }

            @Override
            public SortedDocValues getSortedDocValues(String field) throws IOException {
                PerField pf = DefaultIndexingChain.this.getPerField(field);
                if (pf == null) {
                    return null;
                }
                if (pf.fieldInfo.getDocValuesType() == DocValuesType.SORTED) {
                    return (SortedDocValues)pf.docValuesWriter.getDocValues();
                }
                return null;
            }

            @Override
            public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
                PerField pf = DefaultIndexingChain.this.getPerField(field);
                if (pf == null) {
                    return null;
                }
                if (pf.fieldInfo.getDocValuesType() == DocValuesType.SORTED_NUMERIC) {
                    return (SortedNumericDocValues)pf.docValuesWriter.getDocValues();
                }
                return null;
            }

            @Override
            public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
                PerField pf = DefaultIndexingChain.this.getPerField(field);
                if (pf == null) {
                    return null;
                }
                if (pf.fieldInfo.getDocValuesType() == DocValuesType.SORTED_SET) {
                    return (SortedSetDocValues)pf.docValuesWriter.getDocValues();
                }
                return null;
            }

            @Override
            public FieldInfos getFieldInfos() {
                return DefaultIndexingChain.this.fieldInfos.finish();
            }
        };
    }

    private Sorter.DocMap maybeSortSegment(SegmentWriteState state) throws IOException {
        Sort indexSort = state.segmentInfo.getIndexSort();
        if (indexSort == null) {
            return null;
        }
        LeafReader docValuesReader = this.getDocValuesLeafReader();
        ArrayList<IndexSorter.DocComparator> comparators = new ArrayList<IndexSorter.DocComparator>();
        for (int i = 0; i < indexSort.getSort().length; ++i) {
            SortField sortField = indexSort.getSort()[i];
            IndexSorter sorter = sortField.getIndexSorter();
            if (sorter == null) {
                throw new UnsupportedOperationException("Cannot sort index using sort field " + sortField);
            }
            comparators.add(sorter.getDocComparator(docValuesReader, state.segmentInfo.maxDoc()));
        }
        Sorter sorter = new Sorter(indexSort);
        return sorter.sort(state.segmentInfo.maxDoc(), comparators.toArray(new IndexSorter.DocComparator[0]));
    }

    @Override
    public Sorter.DocMap flush(SegmentWriteState state) throws IOException {
        Sorter.DocMap sortMap = this.maybeSortSegment(state);
        int maxDoc = state.segmentInfo.maxDoc();
        long t0 = System.nanoTime();
        this.writeNorms(state, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to write norms");
        }
        SegmentReadState readState = new SegmentReadState(state.directory, state.segmentInfo, state.fieldInfos, IOContext.READ, state.segmentSuffix);
        t0 = System.nanoTime();
        this.writeDocValues(state, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to write docValues");
        }
        t0 = System.nanoTime();
        this.writePoints(state, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to write points");
        }
        t0 = System.nanoTime();
        this.storedFieldsConsumer.finish(maxDoc);
        this.storedFieldsConsumer.flush(state, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to finish stored fields");
        }
        t0 = System.nanoTime();
        HashMap<String, TermsHashPerField> fieldsToFlush = new HashMap<String, TermsHashPerField>();
        for (int i = 0; i < this.fieldHash.length; ++i) {
            PerField perField = this.fieldHash[i];
            while (perField != null) {
                if (perField.invertState != null) {
                    fieldsToFlush.put(perField.fieldInfo.name, perField.termsHashPerField);
                }
                perField = perField.next;
            }
        }
        try (NormsProducer norms = readState.fieldInfos.hasNorms() ? state.segmentInfo.getCodec().normsFormat().normsProducer(readState) : null;){
            NormsProducer normsMergeInstance = null;
            if (norms != null) {
                normsMergeInstance = norms.getMergeInstance();
            }
            this.termsHash.flush(fieldsToFlush, state, sortMap, normsMergeInstance);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to write postings and finish vectors");
        }
        t0 = System.nanoTime();
        this.indexWriterConfig.getCodec().fieldInfosFormat().write(state.directory, state.segmentInfo, "", state.fieldInfos, IOContext.DEFAULT);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", (System.nanoTime() - t0) / 1000000L + " msec to write fieldInfos");
        }
        return sortMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePoints(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        block14: {
            PointsWriter pointsWriter;
            block13: {
                pointsWriter = null;
                boolean success = false;
                try {
                    for (int i = 0; i < this.fieldHash.length; ++i) {
                        PerField perField = this.fieldHash[i];
                        while (perField != null) {
                            if (perField.pointValuesWriter != null) {
                                if (perField.fieldInfo.getPointDimensionCount() == 0) {
                                    throw new AssertionError((Object)("segment=" + state.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has no points but wrote them"));
                                }
                                if (pointsWriter == null) {
                                    PointsFormat fmt = state.segmentInfo.getCodec().pointsFormat();
                                    if (fmt == null) {
                                        throw new IllegalStateException("field=\"" + perField.fieldInfo.name + "\" was indexed as points but codec does not support points");
                                    }
                                    pointsWriter = fmt.fieldsWriter(state);
                                }
                                perField.pointValuesWriter.flush(state, sortMap, pointsWriter);
                                perField.pointValuesWriter = null;
                            } else if (perField.fieldInfo.getPointDimensionCount() != 0) {
                                throw new AssertionError((Object)("segment=" + state.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has points but did not write them"));
                            }
                            perField = perField.next;
                        }
                    }
                    if (pointsWriter != null) {
                        pointsWriter.finish();
                    }
                    if (!(success = true)) break block13;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(pointsWriter);
                    } else {
                        IOUtils.closeWhileHandlingException(pointsWriter);
                    }
                    throw throwable;
                }
                IOUtils.close(pointsWriter);
                break block14;
            }
            IOUtils.closeWhileHandlingException(pointsWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocValues(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        DocValuesConsumer dvConsumer;
        block16: {
            block15: {
                dvConsumer = null;
                boolean success = false;
                try {
                    for (int i = 0; i < this.fieldHash.length; ++i) {
                        PerField perField = this.fieldHash[i];
                        while (perField != null) {
                            if (perField.docValuesWriter != null) {
                                if (perField.fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                                    throw new AssertionError((Object)("segment=" + state.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has no docValues but wrote them"));
                                }
                                if (dvConsumer == null) {
                                    DocValuesFormat fmt = state.segmentInfo.getCodec().docValuesFormat();
                                    dvConsumer = fmt.fieldsConsumer(state);
                                }
                                perField.docValuesWriter.flush(state, sortMap, dvConsumer);
                                perField.docValuesWriter = null;
                            } else if (perField.fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                                throw new AssertionError((Object)("segment=" + state.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has docValues but did not write them"));
                            }
                            perField = perField.next;
                        }
                    }
                    success = true;
                    if (!success) break block15;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(dvConsumer);
                    } else {
                        IOUtils.closeWhileHandlingException(dvConsumer);
                    }
                    throw throwable;
                }
                IOUtils.close(dvConsumer);
                break block16;
            }
            IOUtils.closeWhileHandlingException(dvConsumer);
        }
        if (!state.fieldInfos.hasDocValues()) {
            if (dvConsumer != null) {
                throw new AssertionError((Object)("segment=" + state.segmentInfo + ": fieldInfos has no docValues but wrote them"));
            }
        } else if (dvConsumer == null) {
            throw new AssertionError((Object)("segment=" + state.segmentInfo + ": fieldInfos has docValues but did not wrote them"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNorms(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        block10: {
            NormsConsumer normsConsumer;
            block9: {
                boolean success = false;
                normsConsumer = null;
                try {
                    if (state.fieldInfos.hasNorms()) {
                        NormsFormat normsFormat = state.segmentInfo.getCodec().normsFormat();
                        assert (normsFormat != null);
                        normsConsumer = normsFormat.normsConsumer(state);
                        for (FieldInfo fi : state.fieldInfos) {
                            PerField perField = this.getPerField(fi.name);
                            assert (perField != null);
                            if (fi.omitsNorms() || fi.getIndexOptions() == IndexOptions.NONE) continue;
                            assert (perField.norms != null) : "field=" + fi.name;
                            perField.norms.finish(state.segmentInfo.maxDoc());
                            perField.norms.flush(state, sortMap, normsConsumer);
                        }
                    }
                    if (!(success = true)) break block9;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(normsConsumer);
                    } else {
                        IOUtils.closeWhileHandlingException(normsConsumer);
                    }
                    throw throwable;
                }
                IOUtils.close(normsConsumer);
                break block10;
            }
            IOUtils.closeWhileHandlingException(normsConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws IOException {
        try (Closeable finalizer = this.termsHash::abort;){
            this.storedFieldsConsumer.abort();
        }
        finally {
            Arrays.fill(this.fieldHash, null);
        }
    }

    private void rehash() {
        int newHashSize = this.fieldHash.length * 2;
        assert (newHashSize > this.fieldHash.length);
        PerField[] newHashArray = new PerField[newHashSize];
        int newHashMask = newHashSize - 1;
        for (int j = 0; j < this.fieldHash.length; ++j) {
            PerField fp0 = this.fieldHash[j];
            while (fp0 != null) {
                int hashPos2 = fp0.fieldInfo.name.hashCode() & newHashMask;
                PerField nextFP0 = fp0.next;
                fp0.next = newHashArray[hashPos2];
                newHashArray[hashPos2] = fp0;
                fp0 = nextFP0;
            }
        }
        this.fieldHash = newHashArray;
        this.hashMask = newHashMask;
    }

    private void startStoredFields(int docID) throws IOException {
        try {
            this.storedFieldsConsumer.startDocument(docID);
        }
        catch (Throwable th) {
            this.onAbortingException(th);
            throw th;
        }
    }

    private void finishStoredFields() throws IOException {
        try {
            this.storedFieldsConsumer.finishDocument();
        }
        catch (Throwable th) {
            this.onAbortingException(th);
            throw th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDocument(int docID, Iterable<? extends IndexableField> document) throws IOException {
        int fieldCount = 0;
        long fieldGen = this.nextFieldGen++;
        this.termsHash.startDocument();
        this.startStoredFields(docID);
        try {
            for (IndexableField indexableField : document) {
                fieldCount = this.processField(docID, indexableField, fieldGen, fieldCount);
            }
        }
        finally {
            if (!this.hasHitAbortingException) {
                for (int i = 0; i < fieldCount; ++i) {
                    this.fields[i].finish(docID);
                }
                this.finishStoredFields();
            }
        }
        try {
            this.termsHash.finishDocument(docID);
        }
        catch (Throwable th) {
            this.abortingExceptionConsumer.accept(th);
            throw th;
        }
    }

    private int processField(int docID, IndexableField field, long fieldGen, int fieldCount) throws IOException {
        DocValuesType dvType;
        String fieldName = field.name();
        IndexableFieldType fieldType = field.fieldType();
        PerField fp = null;
        if (fieldType.indexOptions() == null) {
            throw new NullPointerException("IndexOptions must not be null (field: \"" + field.name() + "\")");
        }
        if (fieldType.indexOptions() != IndexOptions.NONE) {
            fp = this.getOrAddField(fieldName, fieldType, true);
            boolean first = fp.fieldGen != fieldGen;
            fp.invert(docID, field, first);
            if (first) {
                this.fields[fieldCount++] = fp;
                fp.fieldGen = fieldGen;
            }
        } else {
            DefaultIndexingChain.verifyUnIndexedFieldType(fieldName, fieldType);
        }
        if (fieldType.stored()) {
            if (fp == null) {
                fp = this.getOrAddField(fieldName, fieldType, false);
            }
            if (fieldType.stored()) {
                String value = field.stringValue();
                if (value != null && value.length() > IndexWriter.MAX_STORED_STRING_LENGTH) {
                    throw new IllegalArgumentException("stored field \"" + field.name() + "\" is too large (" + value.length() + " characters) to store");
                }
                try {
                    this.storedFieldsConsumer.writeField(fp.fieldInfo, field);
                }
                catch (Throwable th) {
                    this.onAbortingException(th);
                    throw th;
                }
            }
        }
        if ((dvType = fieldType.docValuesType()) == null) {
            throw new NullPointerException("docValuesType must not be null (field: \"" + fieldName + "\")");
        }
        if (dvType != DocValuesType.NONE) {
            if (fp == null) {
                fp = this.getOrAddField(fieldName, fieldType, false);
            }
            this.indexDocValue(docID, fp, dvType, field);
        }
        if (fieldType.pointDimensionCount() != 0) {
            if (fp == null) {
                fp = this.getOrAddField(fieldName, fieldType, false);
            }
            this.indexPoint(docID, fp, field);
        }
        return fieldCount;
    }

    private static void verifyUnIndexedFieldType(String name, IndexableFieldType ft) {
        if (ft.storeTermVectors()) {
            throw new IllegalArgumentException("cannot store term vectors for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorPositions()) {
            throw new IllegalArgumentException("cannot store term vector positions for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorOffsets()) {
            throw new IllegalArgumentException("cannot store term vector offsets for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorPayloads()) {
            throw new IllegalArgumentException("cannot store term vector payloads for a field that is not indexed (field=\"" + name + "\")");
        }
    }

    private void indexPoint(int docID, PerField fp, IndexableField field) throws IOException {
        int pointDimensionCount = field.fieldType().pointDimensionCount();
        int pointIndexDimensionCount = field.fieldType().pointIndexDimensionCount();
        int dimensionNumBytes = field.fieldType().pointNumBytes();
        if (fp.fieldInfo.getPointDimensionCount() == 0) {
            this.fieldInfos.globalFieldNumbers.setDimensions(fp.fieldInfo.number, fp.fieldInfo.name, pointDimensionCount, pointIndexDimensionCount, dimensionNumBytes);
        }
        fp.fieldInfo.setPointDimensions(pointDimensionCount, pointIndexDimensionCount, dimensionNumBytes);
        if (fp.pointValuesWriter == null) {
            fp.pointValuesWriter = new PointValuesWriter(this.bytesUsed, fp.fieldInfo);
        }
        fp.pointValuesWriter.addPackedValue(docID, field.binaryValue());
    }

    private void validateIndexSortDVType(Sort indexSort, final String fieldToValidate, final DocValuesType dvType) throws IOException {
        for (final SortField sortField : indexSort.getSort()) {
            IndexSorter sorter = sortField.getIndexSorter();
            if (sorter == null) {
                throw new IllegalStateException("Cannot sort index with sort order " + sortField);
            }
            sorter.getDocComparator(new DocValuesLeafReader(){

                @Override
                public NumericDocValues getNumericDocValues(String field) {
                    if (Objects.equals(field, fieldToValidate) && dvType != DocValuesType.NUMERIC) {
                        throw new IllegalArgumentException("SortField " + sortField + " expected field [" + field + "] to be NUMERIC but it is [" + (Object)((Object)dvType) + "]");
                    }
                    return DocValues.emptyNumeric();
                }

                @Override
                public BinaryDocValues getBinaryDocValues(String field) {
                    if (Objects.equals(field, fieldToValidate) && dvType != DocValuesType.BINARY) {
                        throw new IllegalArgumentException("SortField " + sortField + " expected field [" + field + "] to be BINARY but it is [" + (Object)((Object)dvType) + "]");
                    }
                    return DocValues.emptyBinary();
                }

                @Override
                public SortedDocValues getSortedDocValues(String field) {
                    if (Objects.equals(field, fieldToValidate) && dvType != DocValuesType.SORTED) {
                        throw new IllegalArgumentException("SortField " + sortField + " expected field [" + field + "] to be SORTED but it is [" + (Object)((Object)dvType) + "]");
                    }
                    return DocValues.emptySorted();
                }

                @Override
                public SortedNumericDocValues getSortedNumericDocValues(String field) {
                    if (Objects.equals(field, fieldToValidate) && dvType != DocValuesType.SORTED_NUMERIC) {
                        throw new IllegalArgumentException("SortField " + sortField + " expected field [" + field + "] to be SORTED_NUMERIC but it is [" + (Object)((Object)dvType) + "]");
                    }
                    return DocValues.emptySortedNumeric();
                }

                @Override
                public SortedSetDocValues getSortedSetDocValues(String field) {
                    if (Objects.equals(field, fieldToValidate) && dvType != DocValuesType.SORTED_SET) {
                        throw new IllegalArgumentException("SortField " + sortField + " expected field [" + field + "] to be SORTED_SET but it is [" + (Object)((Object)dvType) + "]");
                    }
                    return DocValues.emptySortedSet();
                }

                @Override
                public FieldInfos getFieldInfos() {
                    throw new UnsupportedOperationException();
                }
            }, 0);
        }
    }

    private void indexDocValue(int docID, PerField fp, DocValuesType dvType, IndexableField field) throws IOException {
        if (fp.fieldInfo.getDocValuesType() == DocValuesType.NONE) {
            if (this.indexWriterConfig.getIndexSort() != null) {
                Sort indexSort = this.indexWriterConfig.getIndexSort();
                this.validateIndexSortDVType(indexSort, fp.fieldInfo.name, dvType);
            }
            this.fieldInfos.globalFieldNumbers.setDocValuesType(fp.fieldInfo.number, fp.fieldInfo.name, dvType);
        }
        fp.fieldInfo.setDocValuesType(dvType);
        switch (dvType) {
            case NUMERIC: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new NumericDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                if (field.numericValue() == null) {
                    throw new IllegalArgumentException("field=\"" + fp.fieldInfo.name + "\": null value not allowed");
                }
                ((NumericDocValuesWriter)fp.docValuesWriter).addValue(docID, field.numericValue().longValue());
                break;
            }
            case BINARY: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new BinaryDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((BinaryDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            case SORTED: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new SortedDocValuesWriter(fp.fieldInfo, this.bytesUsed, this.docValuesBytePool);
                }
                ((SortedDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            case SORTED_NUMERIC: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new SortedNumericDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((SortedNumericDocValuesWriter)fp.docValuesWriter).addValue(docID, field.numericValue().longValue());
                break;
            }
            case SORTED_SET: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new SortedSetDocValuesWriter(fp.fieldInfo, this.bytesUsed, this.docValuesBytePool);
                }
                ((SortedSetDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            default: {
                throw new AssertionError((Object)("unrecognized DocValues.Type: " + (Object)((Object)dvType)));
            }
        }
    }

    private PerField getPerField(String name) {
        int hashPos = name.hashCode() & this.hashMask;
        PerField fp = this.fieldHash[hashPos];
        while (fp != null && !fp.fieldInfo.name.equals(name)) {
            fp = fp.next;
        }
        return fp;
    }

    private PerField getOrAddField(String name, IndexableFieldType fieldType, boolean invert) {
        int hashPos = name.hashCode() & this.hashMask;
        PerField fp = this.fieldHash[hashPos];
        while (fp != null && !fp.fieldInfo.name.equals(name)) {
            fp = fp.next;
        }
        if (fp == null) {
            FieldInfo fi = this.fieldInfos.getOrAdd(name);
            this.initIndexOptions(fi, fieldType.indexOptions());
            Map<String, String> attributes = fieldType.getAttributes();
            if (attributes != null) {
                attributes.forEach((k, v) -> fi.putAttribute((String)k, (String)v));
            }
            fp = new PerField(this.indexCreatedVersionMajor, fi, invert, this.indexWriterConfig.getSimilarity(), this.indexWriterConfig.getInfoStream(), this.indexWriterConfig.getAnalyzer());
            fp.next = this.fieldHash[hashPos];
            this.fieldHash[hashPos] = fp;
            ++this.totalFieldCount;
            if (this.totalFieldCount >= this.fieldHash.length / 2) {
                this.rehash();
            }
            if (this.totalFieldCount > this.fields.length) {
                PerField[] newFields = new PerField[ArrayUtil.oversize(this.totalFieldCount, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.fields, 0, newFields, 0, this.fields.length);
                this.fields = newFields;
            }
        } else if (invert && fp.invertState == null) {
            this.initIndexOptions(fp.fieldInfo, fieldType.indexOptions());
            fp.setInvertState();
        }
        return fp;
    }

    private void initIndexOptions(FieldInfo info, IndexOptions indexOptions) {
        assert (info.getIndexOptions() == IndexOptions.NONE);
        this.fieldInfos.globalFieldNumbers.setIndexOptions(info.number, info.name, indexOptions);
        info.setIndexOptions(indexOptions);
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get() + this.storedFieldsConsumer.accountable.ramBytesUsed() + this.termVectorsWriter.accountable.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Arrays.asList(this.storedFieldsConsumer.accountable, this.termVectorsWriter.accountable);
    }

    @Override
    DocIdSetIterator getHasDocValues(String field) {
        PerField perField = this.getPerField(field);
        if (perField != null && perField.docValuesWriter != null) {
            if (perField.fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                return null;
            }
            return perField.docValuesWriter.getDocValues();
        }
        return null;
    }

    private final class PerField
    implements Comparable<PerField> {
        final int indexCreatedVersionMajor;
        final FieldInfo fieldInfo;
        final Similarity similarity;
        FieldInvertState invertState;
        TermsHashPerField termsHashPerField;
        DocValuesWriter<?> docValuesWriter;
        PointValuesWriter pointValuesWriter;
        long fieldGen = -1L;
        PerField next;
        NormValuesWriter norms;
        TokenStream tokenStream;
        private final InfoStream infoStream;
        private final Analyzer analyzer;

        PerField(int indexCreatedVersionMajor, FieldInfo fieldInfo, boolean invert, Similarity similarity, InfoStream infoStream, Analyzer analyzer) {
            this.indexCreatedVersionMajor = indexCreatedVersionMajor;
            this.fieldInfo = fieldInfo;
            this.similarity = similarity;
            this.infoStream = infoStream;
            this.analyzer = analyzer;
            if (invert) {
                this.setInvertState();
            }
        }

        void setInvertState() {
            this.invertState = new FieldInvertState(this.indexCreatedVersionMajor, this.fieldInfo.name, this.fieldInfo.getIndexOptions());
            this.termsHashPerField = DefaultIndexingChain.this.termsHash.addField(this.invertState, this.fieldInfo);
            if (!this.fieldInfo.omitsNorms()) {
                assert (this.norms == null);
                this.norms = new NormValuesWriter(this.fieldInfo, DefaultIndexingChain.this.bytesUsed);
            }
        }

        @Override
        public int compareTo(PerField other) {
            return this.fieldInfo.name.compareTo(other.fieldInfo.name);
        }

        public void finish(int docID) throws IOException {
            if (!this.fieldInfo.omitsNorms()) {
                long normValue;
                if (this.invertState.length == 0) {
                    normValue = 0L;
                } else {
                    normValue = this.similarity.computeNorm(this.invertState);
                    if (normValue == 0L) {
                        throw new IllegalStateException("Similarity " + this.similarity + " return 0 for non-empty field");
                    }
                }
                this.norms.addValue(docID, normValue);
            }
            this.termsHashPerField.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invert(int docID, IndexableField field, boolean first) throws IOException {
            if (first) {
                this.invertState.reset();
            }
            IndexableFieldType fieldType = field.fieldType();
            IndexOptions indexOptions = fieldType.indexOptions();
            this.fieldInfo.setIndexOptions(indexOptions);
            if (fieldType.omitNorms()) {
                this.fieldInfo.setOmitsNorms();
            }
            boolean analyzed = fieldType.tokenized() && this.analyzer != null;
            boolean succeededInProcessingField = false;
            try (TokenStream stream = this.tokenStream = field.tokenStream(this.analyzer, this.tokenStream);){
                stream.reset();
                this.invertState.setAttributeSource(stream);
                this.termsHashPerField.start(field, first);
                while (stream.incrementToken()) {
                    int posIncr = this.invertState.posIncrAttribute.getPositionIncrement();
                    this.invertState.position += posIncr;
                    if (this.invertState.position < this.invertState.lastPosition) {
                        if (posIncr == 0) {
                            throw new IllegalArgumentException("first position increment must be > 0 (got 0) for field '" + field.name() + "'");
                        }
                        if (posIncr < 0) {
                            throw new IllegalArgumentException("position increment must be >= 0 (got " + posIncr + ") for field '" + field.name() + "'");
                        }
                        throw new IllegalArgumentException("position overflowed Integer.MAX_VALUE (got posIncr=" + posIncr + " lastPosition=" + this.invertState.lastPosition + " position=" + this.invertState.position + ") for field '" + field.name() + "'");
                    }
                    if (this.invertState.position > 0x7FFFFF7F) {
                        throw new IllegalArgumentException("position " + this.invertState.position + " is too large for field '" + field.name() + "': max allowed position is " + 0x7FFFFF7F);
                    }
                    this.invertState.lastPosition = this.invertState.position;
                    if (posIncr == 0) {
                        ++this.invertState.numOverlap;
                    }
                    int startOffset = this.invertState.offset + this.invertState.offsetAttribute.startOffset();
                    int endOffset = this.invertState.offset + this.invertState.offsetAttribute.endOffset();
                    if (startOffset < this.invertState.lastStartOffset || endOffset < startOffset) {
                        throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset, and offsets must not go backwards startOffset=" + startOffset + ",endOffset=" + endOffset + ",lastStartOffset=" + this.invertState.lastStartOffset + " for field '" + field.name() + "'");
                    }
                    this.invertState.lastStartOffset = startOffset;
                    try {
                        this.invertState.length = Math.addExact(this.invertState.length, this.invertState.termFreqAttribute.getTermFrequency());
                    }
                    catch (ArithmeticException ae) {
                        throw new IllegalArgumentException("too many tokens for field \"" + field.name() + "\"");
                    }
                    try {
                        this.termsHashPerField.add(this.invertState.termAttribute.getBytesRef(), docID);
                    }
                    catch (BytesRefHash.MaxBytesLengthExceededException e) {
                        byte[] prefix = new byte[30];
                        BytesRef bigTerm = this.invertState.termAttribute.getBytesRef();
                        System.arraycopy(bigTerm.bytes, bigTerm.offset, prefix, 0, 30);
                        String msg = "Document contains at least one immense term in field=\"" + this.fieldInfo.name + "\" (whose UTF8 encoding is longer than the max length " + 32766 + "), all of which were skipped.  Please correct the analyzer to not produce such terms.  The prefix of the first immense term is: '" + Arrays.toString(prefix) + "...', original message: " + e.getMessage();
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "ERROR: " + msg);
                        }
                        throw new IllegalArgumentException(msg, e);
                    }
                    catch (Throwable th) {
                        DefaultIndexingChain.this.onAbortingException(th);
                        throw th;
                    }
                }
                stream.end();
                this.invertState.position += this.invertState.posIncrAttribute.getPositionIncrement();
                this.invertState.offset += this.invertState.offsetAttribute.endOffset();
                succeededInProcessingField = true;
            }
            finally {
                if (!succeededInProcessingField && this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", "An exception was thrown while processing field " + this.fieldInfo.name);
                }
            }
            if (analyzed) {
                this.invertState.position += this.analyzer.getPositionIncrementGap(this.fieldInfo.name);
                this.invertState.offset += this.analyzer.getOffsetGap(this.fieldInfo.name);
            }
        }
    }

    private static class IntBlockAllocator
    extends IntBlockPool.Allocator {
        private final Counter bytesUsed;

        IntBlockAllocator(Counter bytesUsed) {
            super(8192);
            this.bytesUsed = bytesUsed;
        }

        @Override
        public int[] getIntBlock() {
            int[] b = new int[8192];
            this.bytesUsed.addAndGet(32768L);
            return b;
        }

        @Override
        public void recycleIntBlocks(int[][] blocks, int offset, int length) {
            this.bytesUsed.addAndGet(-(length * 32768));
        }
    }
}

