/* application-client.c generated by valac 0.56.3, the Vala compiler
 * generated from application-client.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2019-2021 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */
/* Defined by CMake build script.*/

#include "geary-client-43.0.h"
#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <webkit2/webkit2.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <handy.h>
#include <gdk/gdk.h>

#define APPLICATION_CLIENT_OPTION_VERSION "version"
#define APPLICATION_CLIENT_OPTION_DEBUG "debug"
#define APPLICATION_CLIENT_OPTION_INSPECTOR "inspector"
#define APPLICATION_CLIENT_OPTION_LOG_CONVERSATIONS "log-conversations"
#define APPLICATION_CLIENT_OPTION_LOG_DESERIALIZER "log-deserializer"
#define APPLICATION_CLIENT_OPTION_LOG_FOLDER_NORM "log-folder-normalization"
#define APPLICATION_CLIENT_OPTION_LOG_IMAP "log-imap"
#define APPLICATION_CLIENT_OPTION_LOG_REPLAY_QUEUE "log-replay-queue"
#define APPLICATION_CLIENT_OPTION_LOG_SMTP "log-smtp"
#define APPLICATION_CLIENT_OPTION_LOG_SQL "log-sql"
#define APPLICATION_CLIENT_OPTION_NEW_WINDOW "new-window"
#define APPLICATION_CLIENT_OPTION_QUIT "quit"
#define APPLICATION_CLIENT_OPTION_REVOKE_CERTS "revoke-certs"
#define APPLICATION_CLIENT_MAILTO_URI_SCHEME_PREFIX "mailto:"
#define APPLICATION_CLIENT_USEC_PER_SEC ((gint64) 1000000)
#define APPLICATION_CLIENT_FORCE_SHUTDOWN_USEC (5 * APPLICATION_CLIENT_USEC_PER_SEC)
#define APPLICATION_CLIENT_ERROR_NOTIFICATION_ID "error"

#define APPLICATION_TYPE_CONTROLLER (application_controller_get_type ())
#define APPLICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationController))
#define APPLICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))
#define APPLICATION_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))

typedef struct _ApplicationController ApplicationController;
typedef struct _ApplicationControllerClass ApplicationControllerClass;
enum  {
	APPLICATION_CLIENT_0_PROPERTY,
	APPLICATION_CLIENT_ENGINE_PROPERTY,
	APPLICATION_CLIENT_CONFIG_PROPERTY,
	APPLICATION_CLIENT_LAST_ACTIVE_MAIN_WINDOW_PROPERTY,
	APPLICATION_CLIENT_AUTOSTART_PROPERTY,
	APPLICATION_CLIENT_IS_BACKGROUND_SERVICE_PROPERTY,
	APPLICATION_CLIENT_IS_FLATPAK_SANDBOXED_PROPERTY,
	APPLICATION_CLIENT_CONTROLLER_PROPERTY,
	APPLICATION_CLIENT_IS_INSTALLED_PROPERTY,
	APPLICATION_CLIENT_INSTALL_PREFIX_PROPERTY,
	APPLICATION_CLIENT_NUM_PROPERTIES
};
static GParamSpec* application_client_properties[APPLICATION_CLIENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _ApplicationClientShowAboutData ApplicationClientShowAboutData;
typedef struct _ApplicationClientShowAccountsData ApplicationClientShowAccountsData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define APPLICATION_TYPE_EMAIL_STORE_FACTORY (application_email_store_factory_get_type ())
#define APPLICATION_EMAIL_STORE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_EMAIL_STORE_FACTORY, ApplicationEmailStoreFactory))
#define APPLICATION_EMAIL_STORE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_EMAIL_STORE_FACTORY, ApplicationEmailStoreFactoryClass))
#define APPLICATION_IS_EMAIL_STORE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_EMAIL_STORE_FACTORY))
#define APPLICATION_IS_EMAIL_STORE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_EMAIL_STORE_FACTORY))
#define APPLICATION_EMAIL_STORE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_EMAIL_STORE_FACTORY, ApplicationEmailStoreFactoryClass))

typedef struct _ApplicationEmailStoreFactory ApplicationEmailStoreFactory;
typedef struct _ApplicationEmailStoreFactoryClass ApplicationEmailStoreFactoryClass;

#define APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS (application_plugin_manager_plugin_globals_get_type ())
#define APPLICATION_PLUGIN_MANAGER_PLUGIN_GLOBALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS, ApplicationPluginManagerPluginGlobals))
#define APPLICATION_PLUGIN_MANAGER_PLUGIN_GLOBALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS, ApplicationPluginManagerPluginGlobalsClass))
#define APPLICATION_PLUGIN_MANAGER_IS_PLUGIN_GLOBALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS))
#define APPLICATION_PLUGIN_MANAGER_IS_PLUGIN_GLOBALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS))
#define APPLICATION_PLUGIN_MANAGER_PLUGIN_GLOBALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS, ApplicationPluginManagerPluginGlobalsClass))

typedef struct _ApplicationPluginManagerPluginGlobals ApplicationPluginManagerPluginGlobals;
typedef struct _ApplicationPluginManagerPluginGlobalsClass ApplicationPluginManagerPluginGlobalsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ApplicationClientShowEmailData ApplicationClientShowEmailData;

#define APPLICATION_TYPE_FOLDER_STORE_FACTORY (application_folder_store_factory_get_type ())
#define APPLICATION_FOLDER_STORE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_FOLDER_STORE_FACTORY, ApplicationFolderStoreFactory))
#define APPLICATION_FOLDER_STORE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_FOLDER_STORE_FACTORY, ApplicationFolderStoreFactoryClass))
#define APPLICATION_IS_FOLDER_STORE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_FOLDER_STORE_FACTORY))
#define APPLICATION_IS_FOLDER_STORE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_FOLDER_STORE_FACTORY))
#define APPLICATION_FOLDER_STORE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_FOLDER_STORE_FACTORY, ApplicationFolderStoreFactoryClass))

typedef struct _ApplicationFolderStoreFactory ApplicationFolderStoreFactory;
typedef struct _ApplicationFolderStoreFactoryClass ApplicationFolderStoreFactoryClass;
typedef struct _ApplicationClientShowFolderData ApplicationClientShowFolderData;
typedef struct _ApplicationClientShowInspectorData ApplicationClientShowInspectorData;
typedef struct _ApplicationClientShowPreferencesData ApplicationClientShowPreferencesData;

#define APPLICATION_TYPE_ACCOUNT_INTERFACE (application_account_interface_get_type ())
#define APPLICATION_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface))
#define APPLICATION_IS_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE))
#define APPLICATION_ACCOUNT_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterfaceIface))

typedef struct _ApplicationAccountInterface ApplicationAccountInterface;
typedef struct _ApplicationAccountInterfaceIface ApplicationAccountInterfaceIface;
typedef struct _ApplicationClientNewComposerData ApplicationClientNewComposerData;
typedef struct _ApplicationClientNewComposerMailtoData ApplicationClientNewComposerMailtoData;
typedef struct _ApplicationClientNewWindowData ApplicationClientNewWindowData;

#define COMPOSER_TYPE_APPLICATION_INTERFACE (composer_application_interface_get_type ())
#define COMPOSER_APPLICATION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterface))
#define COMPOSER_IS_APPLICATION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE))
#define COMPOSER_APPLICATION_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterfaceIface))

typedef struct _ComposerApplicationInterface ComposerApplicationInterface;
typedef struct _ComposerApplicationInterfaceIface ComposerApplicationInterfaceIface;
typedef struct _ApplicationClientShowUriData ApplicationClientShowUriData;
typedef struct _ApplicationClientPresentData ApplicationClientPresentData;
typedef struct _ApplicationClientCreateControllerData ApplicationClientCreateControllerData;
typedef struct _ApplicationClientDestroyControllerData ApplicationClientDestroyControllerData;
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
typedef struct _Block6Data Block6Data;

struct _ApplicationClientPrivate {
	GearyEngine* _engine;
	ApplicationConfiguration* _config;
	ApplicationMainWindow* _last_active_main_window;
	ApplicationStartupManager* _autostart;
	gboolean _is_flatpak_sandboxed;
	ApplicationController* _controller;
	GFile* _install_prefix;
	GFile* exec_dir;
	gchar* binary;
	GtkCssProvider* single_key_shortcuts;
	GCancellable* controller_cancellable;
	ComponentsInspector* inspector;
	GearyNonblockingMutex* controller_mutex;
	GNotification* error_notification;
};

struct _Block5Data {
	int _ref_count_;
	ApplicationClient* self;
	gboolean controller_closed;
};

struct _ApplicationClientShowAboutData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	ApplicationMainWindow* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkWindow* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
};

struct _ApplicationClientShowAccountsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	ApplicationMainWindow* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	AccountsEditor* editor;
	ApplicationMainWindow* _tmp2_;
	ApplicationMainWindow* _tmp3_;
	AccountsEditor* _tmp4_;
	AccountsEditor* _tmp5_;
	ApplicationController* _tmp6_;
};

struct _ApplicationClientShowEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	GVariant* id;
	ApplicationMainWindow* main;
	ApplicationMainWindow* _tmp0_;
	ApplicationEmailStoreFactory* email;
	ApplicationController* _tmp1_;
	ApplicationPluginManager* _tmp2_;
	ApplicationPluginManager* _tmp3_;
	ApplicationPluginManagerPluginGlobals* _tmp4_;
	ApplicationPluginManagerPluginGlobals* _tmp5_;
	ApplicationEmailStoreFactory* _tmp6_;
	ApplicationEmailStoreFactory* _tmp7_;
	ApplicationEmailStoreFactory* _tmp8_;
	ApplicationAccountContext* context;
	ApplicationEmailStoreFactory* _tmp9_;
	ApplicationAccountContext* _tmp10_;
	GearyEmailIdentifier* email_id;
	ApplicationEmailStoreFactory* _tmp11_;
	GearyEmailIdentifier* _tmp12_;
	gboolean _tmp13_;
	ApplicationAccountContext* _tmp14_;
	GearyEmailIdentifier* _tmp15_;
	GeeMultiMap* folders;
	GeeMultiMap* _tmp16_;
	ApplicationAccountContext* _tmp17_;
	GearyAccount* _tmp18_;
	GearyAccount* _tmp19_;
	GearyEmailIdentifier* _tmp20_;
	GeeCollection* _tmp21_;
	GeeCollection* _tmp22_;
	ApplicationAccountContext* _tmp23_;
	GCancellable* _tmp24_;
	GCancellable* _tmp25_;
	GeeMultiMap* _tmp26_;
	GeeMultiMap* _tmp27_;
	GeeMultiMap* _tmp28_;
	GError* err;
	GError* _tmp29_;
	const gchar* _tmp30_;
	GeeMultiMap* _tmp31_;
	GeeCollection* paths;
	GeeMultiMap* _tmp32_;
	GearyEmailIdentifier* _tmp33_;
	GeeCollection* _tmp34_;
	GearyFolder* selected;
	ApplicationMainWindow* _tmp35_;
	GearyFolder* _tmp36_;
	GearyFolder* _tmp37_;
	GearyFolder* _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	GearyFolder* _tmp41_;
	GearyFolder* _tmp42_;
	GearyAccount* _tmp43_;
	GearyAccount* _tmp44_;
	ApplicationAccountContext* _tmp45_;
	GearyAccount* _tmp46_;
	GearyAccount* _tmp47_;
	GeeCollection* _tmp48_;
	GearyFolder* _tmp49_;
	GearyFolderPath* _tmp50_;
	GearyFolderPath* _tmp51_;
	GeeIterator* _path_it;
	GeeCollection* _tmp52_;
	GeeIterator* _tmp53_;
	GeeIterator* _tmp54_;
	GearyFolderPath* path;
	GeeIterator* _tmp55_;
	gpointer _tmp56_;
	GearyFolder* folder;
	ApplicationAccountContext* _tmp57_;
	GearyAccount* _tmp58_;
	GearyAccount* _tmp59_;
	GearyFolderPath* _tmp60_;
	GearyFolder* _tmp61_;
	GearyFolder* _tmp62_;
	GearyFolderSpecialUse _tmp63_;
	GearyFolderSpecialUse _tmp64_;
	GearyFolder* _tmp65_;
	GearyFolder* _tmp66_;
	GError* _vala1_err;
	GError* _tmp67_;
	const gchar* _tmp68_;
	gboolean _tmp69_;
	GearyFolder* _tmp70_;
	GeeCollection* _tmp71_;
	gboolean _tmp72_;
	gboolean _tmp73_;
	GearyFolder* _tmp74_;
	ApplicationAccountContext* _tmp75_;
	GearyAccount* _tmp76_;
	GearyAccount* _tmp77_;
	GeeCollection* _tmp78_;
	gpointer _tmp79_;
	GearyFolderPath* _tmp80_;
	GearyFolder* _tmp81_;
	GearyFolder* _tmp82_;
	GearyFolder* _tmp83_;
	GError* _vala2_err;
	GError* _tmp84_;
	const gchar* _tmp85_;
	GearyFolder* _tmp86_;
	ApplicationMainWindow* _tmp87_;
	GearyFolder* _tmp88_;
	GearyEmailIdentifier* _tmp89_;
	GeeCollection* _tmp90_;
	GeeCollection* _tmp91_;
	GError* _inner_error0_;
};

struct _ApplicationClientShowFolderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	GVariant* id;
	ApplicationMainWindow* main;
	ApplicationMainWindow* _tmp0_;
	GearyFolder* folder;
	ApplicationController* _tmp1_;
	ApplicationPluginManager* _tmp2_;
	ApplicationPluginManager* _tmp3_;
	ApplicationPluginManagerPluginGlobals* _tmp4_;
	ApplicationPluginManagerPluginGlobals* _tmp5_;
	ApplicationFolderStoreFactory* _tmp6_;
	ApplicationFolderStoreFactory* _tmp7_;
	GearyFolder* _tmp8_;
	GearyFolder* _tmp9_;
	ApplicationMainWindow* _tmp10_;
	GearyFolder* _tmp11_;
};

struct _ApplicationClientShowInspectorData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	ApplicationMainWindow* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	ComponentsInspector* _tmp2_;
	ComponentsInspector* _tmp3_;
	ComponentsInspector* _tmp4_;
	GtkWindowGroup* group;
	GtkWindowGroup* _tmp5_;
	GtkWindowGroup* _tmp6_;
	ComponentsInspector* _tmp7_;
	ComponentsInspector* _tmp8_;
	ComponentsInspector* _tmp9_;
};

struct _ApplicationClientShowPreferencesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	ApplicationMainWindow* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	ComponentsPreferencesWindow* prefs;
	ApplicationMainWindow* _tmp2_;
	ApplicationMainWindow* _tmp3_;
	ApplicationController* _tmp4_;
	ApplicationPluginManager* _tmp5_;
	ApplicationPluginManager* _tmp6_;
	ComponentsPreferencesWindow* _tmp7_;
	ComponentsPreferencesWindow* _tmp8_;
};

struct _ApplicationAccountInterfaceIface {
	GTypeInterface parent_iface;
	ApplicationAccountContext* (*get_context_for_account) (ApplicationAccountInterface* self, GearyAccountInformation* account);
	GeeCollection* (*get_account_contexts) (ApplicationAccountInterface* self);
};

struct _ApplicationClientNewComposerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	GearyRFC822MailboxAddress* to;
	ApplicationMainWindow* main;
	ApplicationMainWindow* _tmp0_;
	ApplicationAccountContext* account;
	ApplicationMainWindow* _tmp1_;
	GearyAccount* _tmp2_;
	GearyAccount* _tmp3_;
	ApplicationController* _tmp4_;
	ApplicationMainWindow* _tmp5_;
	GearyAccount* _tmp6_;
	GearyAccount* _tmp7_;
	GearyAccountInformation* _tmp8_;
	GearyAccountInformation* _tmp9_;
	ApplicationAccountContext* _tmp10_;
	ApplicationAccountContext* _tmp11_;
	ApplicationController* _tmp12_;
	GeeCollection* _tmp13_;
	GeeCollection* _tmp14_;
	gpointer _tmp15_;
	ApplicationAccountContext* _tmp16_;
	ComposerWidget* composer;
	ApplicationController* _tmp17_;
	ApplicationAccountContext* _tmp18_;
	ComposerWidget* _tmp19_;
	ApplicationController* _tmp20_;
	ComposerWidget* _tmp21_;
};

struct _ApplicationClientNewComposerMailtoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	gchar* mailto;
	ApplicationMainWindow* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	ApplicationController* _tmp2_;
};

struct _ApplicationClientNewWindowData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	GearyFolder* select_folder;
	GeeCollection* select_conversations;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean do_select;
	ApplicationMainWindow* main;
	ApplicationMainWindow* _tmp4_;
	ApplicationMainWindow* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	ApplicationMainWindow* _tmp9_;
	ApplicationMainWindow* _tmp10_;
};

struct _ComposerApplicationInterfaceIface {
	GTypeInterface parent_iface;
	void (*report_problem) (ComposerApplicationInterface* self, GearyProblemReport* report);
	void (*send_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*send_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
	void (*save_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*save_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
	void (*discard_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*discard_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
};

struct _ApplicationClientShowUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	gchar* uri;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* uri_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkWindow* _tmp5_;
	const gchar* _tmp6_;
	GError* err;
	ApplicationController* _tmp7_;
	GError* _tmp8_;
	GearyProblemReport* _tmp9_;
	GearyProblemReport* _tmp10_;
	GError* _inner_error0_;
};

struct _ApplicationClientPresentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	ApplicationMainWindow* result;
	ApplicationMainWindow* main;
	ApplicationMainWindow* _tmp0_;
};

struct _ApplicationClientCreateControllerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	gboolean first_run;
	gboolean open_failed;
	gint mutex_token;
	gint _tmp0_;
	GearyNonblockingMutex* _tmp1_;
	ApplicationController* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	ApplicationController* _tmp13_;
	GCancellable* _tmp14_;
	ApplicationController* _tmp15_;
	GearyEngine* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GError* err;
	GError* _tmp19_;
	const gchar* _tmp20_;
	DialogsProblemDetailsDialog* dialog;
	GError* _tmp21_;
	GearyProblemReport* _tmp22_;
	GearyProblemReport* _tmp23_;
	DialogsProblemDetailsDialog* _tmp24_;
	DialogsProblemDetailsDialog* _tmp25_;
	DialogsProblemDetailsDialog* _tmp26_;
	GearyNonblockingMutex* _tmp27_;
	GError* _error_;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GearyEngine* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	GError* _inner_error0_;
};

struct _ApplicationClientDestroyControllerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationClient* self;
	gint mutex_token;
	GearyNonblockingMutex* _tmp0_;
	ApplicationController* _tmp1_;
	ApplicationController* _tmp2_;
	GearyNonblockingMutex* _tmp3_;
	GError* err;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GearyEngine* _tmp6_;
	GError* _error_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	ApplicationClient* self;
	GtkDialog* dialog;
};

static gint ApplicationClient_private_offset;
static gpointer application_client_parent_class = NULL;

VALA_EXTERN GType application_controller_get_type (void) G_GNUC_CONST ;
static void application_client_on_activate_about (ApplicationClient* self);
static void _application_client_on_activate_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void application_client_on_activate_accounts (ApplicationClient* self);
static void _application_client_on_activate_accounts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void application_client_on_activate_compose (ApplicationClient* self);
static void _application_client_on_activate_compose_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void application_client_on_activate_help (ApplicationClient* self);
static void _application_client_on_activate_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void application_client_on_activate_inspect (ApplicationClient* self);
static void _application_client_on_activate_inspect_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void application_client_on_activate_mailto (ApplicationClient* self,
                                            GSimpleAction* action,
                                            GVariant* param);
static void _application_client_on_activate_mailto_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void application_client_on_activate_new_window (ApplicationClient* self);
static void _application_client_on_activate_new_window_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void application_client_on_activate_preferences (ApplicationClient* self);
static void _application_client_on_activate_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self);
static void application_client_on_activate_quit (ApplicationClient* self);
static void _application_client_on_activate_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void application_client_on_activate_show_email (ApplicationClient* self,
                                                GSimpleAction* action,
                                                GVariant* target);
static void _application_client_on_activate_show_email_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void application_client_on_activate_show_folder (ApplicationClient* self,
                                                 GSimpleAction* action,
                                                 GVariant* target);
static void _application_client_on_activate_show_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self);
static void application_client_set_engine (ApplicationClient* self,
                                    GearyEngine* value);
static void application_client_set_config (ApplicationClient* self,
                                    ApplicationConfiguration* value);
static void application_client_set_last_active_main_window (ApplicationClient* self,
                                                     ApplicationMainWindow* value);
static void application_client_set_autostart (ApplicationClient* self,
                                       ApplicationStartupManager* value);
static void application_client_set_is_flatpak_sandboxed (ApplicationClient* self,
                                                  gboolean value);
VALA_EXTERN ApplicationController* application_client_get_controller (ApplicationClient* self);
static void application_client_set_controller (ApplicationClient* self,
                                        ApplicationController* value);
VALA_EXTERN gboolean application_client_get_is_installed (ApplicationClient* self);
VALA_EXTERN GFile* application_client_get_install_prefix (ApplicationClient* self);
static void application_client_set_install_prefix (ApplicationClient* self,
                                            GFile* value);
static void application_client_on_window_removed (ApplicationClient* self,
                                           GtkWindow* window);
static void _application_client_on_window_removed_gtk_application_window_removed (GtkApplication* _sender,
                                                                           GtkWindow* window,
                                                                           gpointer self);
static gboolean application_client_real_local_command_line (GApplication* base,
                                                     gchar*** args,
                                                     gint* exit_status);
static gint application_client_real_handle_local_options (GApplication* base,
                                                   GVariantDict* options);
static void application_client_real_startup (GApplication* base);
VALA_EXTERN void util_i18n_init (const gchar* package_name,
                     const gchar* program_path,
                     const gchar* locale);
static void application_client_add_app_accelerators (ApplicationClient* self,
                                              const gchar* action,
                                              gchar** accelerators,
                                              gint accelerators_length1,
                                              GVariant* param);
static void application_client_load_css (ApplicationClient* self,
                                  GtkCssProvider* provider,
                                  const gchar* resource_uri);
static void application_client_update_single_key_shortcuts (ApplicationClient* self);
static void application_client_on_single_key_shortcuts_toggled (ApplicationClient* self);
static void _application_client_on_single_key_shortcuts_toggled_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self);
static void application_client_create_controller (ApplicationClient* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void application_client_create_controller_finish (ApplicationClient* self,
                                                  GAsyncResult* _res_);
static gint application_client_real_command_line (GApplication* base,
                                           GApplicationCommandLine* command_line);
static gint application_client_handle_general_options (ApplicationClient* self,
                                                GApplicationCommandLine* command_line);
static void application_client_real_shutdown (GApplication* base);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void application_client_destroy_controller (ApplicationClient* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static void application_client_destroy_controller_finish (ApplicationClient* self,
                                                   GAsyncResult* _res_);
static void __lambda182_ (Block5Data* _data5_,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda182__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN void util_date_terminate (void);
static void application_client_real_activate (GApplication* base);
static void application_client_present (ApplicationClient* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static ApplicationMainWindow* application_client_present_finish (ApplicationClient* self,
                                                          GAsyncResult* _res_);
static void application_client_real_open (GApplication* base,
                                   GFile** targets,
                                   gint targets_length1,
                                   const gchar* hint);
static ApplicationMainWindow* application_client_new_main_window (ApplicationClient* self,
                                                           gboolean select_first_inbox);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void application_client_show_about_data_free (gpointer _data);
static gboolean application_client_show_about_co (ApplicationClientShowAboutData* _data_);
static void application_client_show_about_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void application_client_show_accounts_data_free (gpointer _data);
static gboolean application_client_show_accounts_co (ApplicationClientShowAccountsData* _data_);
static void application_client_show_accounts_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN void application_controller_expunge_accounts (ApplicationController* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN void application_controller_expunge_accounts_finish (ApplicationController* self,
                                                     GAsyncResult* _res_);
static void application_client_show_email_data_free (gpointer _data);
static gboolean application_client_show_email_co (ApplicationClientShowEmailData* _data_);
static void application_client_show_email_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
VALA_EXTERN GType application_email_store_factory_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationPluginManager* application_controller_get_plugins (ApplicationController* self);
VALA_EXTERN gpointer application_plugin_manager_plugin_globals_ref (gpointer instance);
VALA_EXTERN void application_plugin_manager_plugin_globals_unref (gpointer instance);
VALA_EXTERN GParamSpec* application_plugin_manager_param_spec_plugin_globals (const gchar* name,
                                                                  const gchar* nick,
                                                                  const gchar* blurb,
                                                                  GType object_type,
                                                                  GParamFlags flags);
VALA_EXTERN void application_plugin_manager_value_set_plugin_globals (GValue* value,
                                                          gpointer v_object);
VALA_EXTERN void application_plugin_manager_value_take_plugin_globals (GValue* value,
                                                           gpointer v_object);
VALA_EXTERN gpointer application_plugin_manager_value_get_plugin_globals (const GValue* value);
VALA_EXTERN GType application_plugin_manager_plugin_globals_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationPluginManagerPluginGlobals* application_plugin_manager_get_globals (ApplicationPluginManager* self);
VALA_EXTERN ApplicationEmailStoreFactory* application_plugin_manager_plugin_globals_get_email (ApplicationPluginManagerPluginGlobals* self);
VALA_EXTERN ApplicationAccountContext* application_email_store_factory_get_account_for_variant (ApplicationEmailStoreFactory* self,
                                                                                    GVariant* target);
VALA_EXTERN GearyEmailIdentifier* application_email_store_factory_get_email_identifier_for_variant (ApplicationEmailStoreFactory* self,
                                                                                        GVariant* target);
static void application_client_show_folder_data_free (gpointer _data);
static gboolean application_client_show_folder_co (ApplicationClientShowFolderData* _data_);
static void application_client_show_folder_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
VALA_EXTERN GType application_folder_store_factory_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationFolderStoreFactory* application_plugin_manager_plugin_globals_get_folders (ApplicationPluginManagerPluginGlobals* self);
VALA_EXTERN GearyFolder* application_folder_store_factory_get_folder_for_variant (ApplicationFolderStoreFactory* self,
                                                                      GVariant* target);
static void application_client_show_inspector_data_free (gpointer _data);
static gboolean application_client_show_inspector_co (ApplicationClientShowInspectorData* _data_);
static void application_client_show_inspector_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void ___lambda177_ (ApplicationClient* self);
static void ____lambda177__gtk_widget_destroy (GtkWidget* _sender,
                                        gpointer self);
static void application_client_show_preferences_data_free (gpointer _data);
static gboolean application_client_show_preferences_co (ApplicationClientShowPreferencesData* _data_);
static void application_client_show_preferences_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void application_client_new_composer_data_free (gpointer _data);
static gboolean application_client_new_composer_co (ApplicationClientNewComposerData* _data_);
static void application_client_new_composer_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
VALA_EXTERN GType application_account_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationAccountContext* application_account_interface_get_context_for_account (ApplicationAccountInterface* self,
                                                                                  GearyAccountInformation* account);
VALA_EXTERN GeeCollection* application_account_interface_get_account_contexts (ApplicationAccountInterface* self);
VALA_EXTERN void application_controller_compose_blank (ApplicationController* self,
                                           ApplicationAccountContext* send_context,
                                           GearyRFC822MailboxAddress* to,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN ComposerWidget* application_controller_compose_blank_finish (ApplicationController* self,
                                                             GAsyncResult* _res_);
VALA_EXTERN void application_controller_present_composer (ApplicationController* self,
                                              ComposerWidget* composer);
static void application_client_new_composer_mailto_data_free (gpointer _data);
static gboolean application_client_new_composer_mailto_co (ApplicationClientNewComposerMailtoData* _data_);
static void application_client_new_composer_mailto_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
VALA_EXTERN void application_controller_compose_mailto (ApplicationController* self,
                                            const gchar* mailto,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
VALA_EXTERN void application_controller_compose_mailto_finish (ApplicationController* self,
                                                   GAsyncResult* _res_);
static void application_client_new_window_data_free (gpointer _data);
static gboolean application_client_new_window_co (ApplicationClientNewWindowData* _data_);
static void application_client_new_window_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static gchar* application_client_get_geary_home_dir_name (ApplicationClient* self);
static void application_client_show_uri_data_free (gpointer _data);
static gboolean application_client_show_uri_co (ApplicationClientShowUriData* _data_);
static void application_client_show_uri_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
VALA_EXTERN GType composer_application_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void composer_application_interface_report_problem (ComposerApplicationInterface* self,
                                                    GearyProblemReport* report);
VALA_EXTERN gboolean application_controller_check_open_composers (ApplicationController* self);
VALA_EXTERN GFile** application_client_get_config_search_path (ApplicationClient* self,
                                                   gint* result_length1);
static void _vala_array_add3 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void _vala_array_add4 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
VALA_EXTERN void application_client_send_error_notification (ApplicationClient* self,
                                                 const gchar* summary,
                                                 const gchar* body);
VALA_EXTERN void application_client_clear_error_notification (ApplicationClient* self);
static void application_client_present_data_free (gpointer _data);
static gboolean application_client_present_co (ApplicationClientPresentData* _data_);
static void application_client_present_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
VALA_EXTERN ApplicationMainWindow* application_main_window_new (ApplicationClient* application);
VALA_EXTERN ApplicationMainWindow* application_main_window_construct (GType object_type,
                                                          ApplicationClient* application);
VALA_EXTERN void application_controller_register_window (ApplicationController* self,
                                             ApplicationMainWindow* window);
static gboolean application_client_on_main_window_focus_in (ApplicationClient* self,
                                                     GtkWidget* widget,
                                                     GdkEventFocus* event);
static gboolean _application_client_on_main_window_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                                GdkEventFocus* event,
                                                                                gpointer self);
VALA_EXTERN gboolean application_main_window_select_first_inbox (ApplicationMainWindow* self,
                                                     gboolean is_interactive);
static void application_client_on_folders_first_available (ApplicationClient* self,
                                                    GearyAccount* account,
                                                    GeeBidirSortedSet* available,
                                                    GeeBidirSortedSet* unavailable);
static void _application_client_on_folders_first_available_geary_account_folders_available_unavailable (GearyAccount* _sender,
                                                                                                 GeeBidirSortedSet* available,
                                                                                                 GeeBidirSortedSet* unavailable,
                                                                                                 gpointer self);
static void application_client_create_controller_data_free (gpointer _data);
static gboolean application_client_create_controller_co (ApplicationClientCreateControllerData* _data_);
static void application_client_create_controller_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
VALA_EXTERN void application_controller_new (ApplicationClient* application,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN ApplicationController* application_controller_new_finish (GAsyncResult* _res_,
                                                          GError** error);
VALA_EXTERN void application_controller_construct (GType object_type,
                                       ApplicationClient* application,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN ApplicationController* application_controller_construct_finish (GAsyncResult* _res_,
                                                                GError** error);
static void application_client_destroy_controller_data_free (gpointer _data);
static gboolean application_client_destroy_controller_co (ApplicationClientDestroyControllerData* _data_);
static void application_client_destroy_controller_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
VALA_EXTERN void application_controller_close (ApplicationController* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void application_controller_close_finish (ApplicationController* self,
                                          GAsyncResult* _res_);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void application_client_on_css_parse_error (ApplicationClient* self,
                                            GtkCssSection* section,
                                            GError* _error_);
static void _application_client_on_css_parse_error_gtk_css_provider_parsing_error (GtkCssProvider* _sender,
                                                                            GtkCssSection* section,
                                                                            GError* _error_,
                                                                            gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda176_ (Block6Data* _data6_);
static void ____lambda176__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
VALA_EXTERN void application_controller_unregister_window (ApplicationController* self,
                                               ApplicationMainWindow* window);
static void application_client_finalize (GObject * obj);
static GType application_client_get_type_once (void);
static void _vala_application_client_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_application_client_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const gchar* APPLICATION_CLIENT_AUTHORS[8] = {"Jim Nelson <jim@yorba.org>", "Eric Gregory <eric@yorba.org>", "Nate Lillich <nate@yorba.org>", "Matthew Pirocchi <matthew@yorba.org>", "Charles Lindsay <chaz@yorba.org>", "Robert Schroll <rschroll@gmail.com>", "Michael Gratton <mike@vee.net>", NULL};
static const GActionEntry APPLICATION_CLIENT_ACTION_ENTRIES[11] = {{ACTION_APPLICATION_ABOUT, _application_client_on_activate_about_gsimple_action_activate_callback}, {ACTION_APPLICATION_ACCOUNTS, _application_client_on_activate_accounts_gsimple_action_activate_callback}, {ACTION_APPLICATION_COMPOSE, _application_client_on_activate_compose_gsimple_action_activate_callback}, {ACTION_APPLICATION_HELP, _application_client_on_activate_help_gsimple_action_activate_callback}, {ACTION_APPLICATION_INSPECT, _application_client_on_activate_inspect_gsimple_action_activate_callback}, {ACTION_APPLICATION_MAILTO, _application_client_on_activate_mailto_gsimple_action_activate_callback, "s"}, {ACTION_APPLICATION_NEW_WINDOW, _application_client_on_activate_new_window_gsimple_action_activate_callback}, {ACTION_APPLICATION_PREFERENCES, _application_client_on_activate_preferences_gsimple_action_activate_callback}, {ACTION_APPLICATION_QUIT, _application_client_on_activate_quit_gsimple_action_activate_callback}, {ACTION_APPLICATION_SHOW_EMAIL, _application_client_on_activate_show_email_gsimple_action_activate_callback, "(sv)"}, {ACTION_APPLICATION_SHOW_FOLDER, _application_client_on_activate_show_folder_gsimple_action_activate_callback, "(sv)"}};
static const GOptionEntry APPLICATION_CLIENT_OPTION_ENTRIES[15] = {{APPLICATION_CLIENT_OPTION_DEBUG, 'd', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Print debug logging"), NULL}, {APPLICATION_CLIENT_OPTION_INSPECTOR, 'i', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Enable WebKitGTK Inspector in web views"), NULL}, {APPLICATION_CLIENT_OPTION_LOG_CONVERSATIONS, (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Log conversation monitoring"), NULL}, {APPLICATION_CLIENT_OPTION_LOG_DESERIALIZER, (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Log IMAP network deserialization"), NULL}, {APPLICATION_CLIENT_OPTION_LOG_FOLDER_NORM, (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Log folder normalization"), NULL}, {APPLICATION_CLIENT_OPTION_LOG_IMAP, (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Log IMAP network activity"), NULL}, {APPLICATION_CLIENT_OPTION_LOG_REPLAY_QUEUE, (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Log IMAP replay queue"), NULL}, {APPLICATION_CLIENT_OPTION_LOG_SMTP, (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Log SMTP network activity"), NULL}, {APPLICATION_CLIENT_OPTION_LOG_SQL, (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Log database queries (generates lots of messages)"), NULL}, {APPLICATION_CLIENT_OPTION_QUIT, 'q', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Perform a graceful quit"), NULL}, {APPLICATION_CLIENT_OPTION_NEW_WINDOW, 'n', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Open a new window"), NULL}, {APPLICATION_CLIENT_OPTION_REVOKE_CERTS, (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Revoke all pinned TLS server certificates"), NULL}, {APPLICATION_CLIENT_OPTION_VERSION, 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Display program version"), NULL}, {G_OPTION_REMAINING, (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, NULL, NULL, "[mailto:[...]]"}, {NULL}};

static inline gpointer
application_client_get_instance_private (ApplicationClient* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationClient_private_offset);
}

static void
_application_client_on_activate_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	application_client_on_activate_about ((ApplicationClient*) self);
}

static void
_application_client_on_activate_accounts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	application_client_on_activate_accounts ((ApplicationClient*) self);
}

static void
_application_client_on_activate_compose_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	application_client_on_activate_compose ((ApplicationClient*) self);
}

static void
_application_client_on_activate_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	application_client_on_activate_help ((ApplicationClient*) self);
}

static void
_application_client_on_activate_inspect_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	application_client_on_activate_inspect ((ApplicationClient*) self);
}

static void
_application_client_on_activate_mailto_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	application_client_on_activate_mailto ((ApplicationClient*) self, action, parameter);
}

static void
_application_client_on_activate_new_window_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	application_client_on_activate_new_window ((ApplicationClient*) self);
}

static void
_application_client_on_activate_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self)
{
	application_client_on_activate_preferences ((ApplicationClient*) self);
}

static void
_application_client_on_activate_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	application_client_on_activate_quit ((ApplicationClient*) self);
}

static void
_application_client_on_activate_show_email_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	application_client_on_activate_show_email ((ApplicationClient*) self, action, parameter);
}

static void
_application_client_on_activate_show_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self)
{
	application_client_on_activate_show_folder ((ApplicationClient*) self, action, parameter);
}

GearyEngine*
application_client_get_engine (ApplicationClient* self)
{
	GearyEngine* result;
	GearyEngine* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = self->priv->_engine;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
application_client_set_engine (ApplicationClient* self,
                               GearyEngine* value)
{
	GearyEngine* old_value;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	old_value = application_client_get_engine (self);
	if (old_value != value) {
		GearyEngine* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_engine);
		self->priv->_engine = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_client_properties[APPLICATION_CLIENT_ENGINE_PROPERTY]);
	}
}

ApplicationConfiguration*
application_client_get_config (ApplicationClient* self)
{
	ApplicationConfiguration* result;
	ApplicationConfiguration* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = self->priv->_config;
	result = _tmp0_;
	return result;
}

static void
application_client_set_config (ApplicationClient* self,
                               ApplicationConfiguration* value)
{
	ApplicationConfiguration* old_value;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	old_value = application_client_get_config (self);
	if (old_value != value) {
		ApplicationConfiguration* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_config);
		self->priv->_config = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_client_properties[APPLICATION_CLIENT_CONFIG_PROPERTY]);
	}
}

ApplicationMainWindow*
application_client_get_last_active_main_window (ApplicationClient* self)
{
	ApplicationMainWindow* result;
	ApplicationMainWindow* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = self->priv->_last_active_main_window;
	result = _tmp0_;
	return result;
}

static void
application_client_set_last_active_main_window (ApplicationClient* self,
                                                ApplicationMainWindow* value)
{
	ApplicationMainWindow* old_value;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	old_value = application_client_get_last_active_main_window (self);
	if (old_value != value) {
		ApplicationMainWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_last_active_main_window);
		self->priv->_last_active_main_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_client_properties[APPLICATION_CLIENT_LAST_ACTIVE_MAIN_WINDOW_PROPERTY]);
	}
}

ApplicationStartupManager*
application_client_get_autostart (ApplicationClient* self)
{
	ApplicationStartupManager* result;
	ApplicationStartupManager* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = self->priv->_autostart;
	result = _tmp0_;
	return result;
}

static void
application_client_set_autostart (ApplicationClient* self,
                                  ApplicationStartupManager* value)
{
	ApplicationStartupManager* old_value;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	old_value = application_client_get_autostart (self);
	if (old_value != value) {
		ApplicationStartupManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_autostart);
		self->priv->_autostart = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_client_properties[APPLICATION_CLIENT_AUTOSTART_PROPERTY]);
	}
}

gboolean
application_client_get_is_background_service (ApplicationClient* self)
{
	gboolean result;
	ApplicationConfiguration* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), FALSE);
	_tmp0_ = self->priv->_config;
	_tmp1_ = application_configuration_get_run_in_background (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
application_client_get_is_flatpak_sandboxed (ApplicationClient* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), FALSE);
	result = self->priv->_is_flatpak_sandboxed;
	return result;
}

static void
application_client_set_is_flatpak_sandboxed (ApplicationClient* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	old_value = application_client_get_is_flatpak_sandboxed (self);
	if (old_value != value) {
		self->priv->_is_flatpak_sandboxed = value;
		g_object_notify_by_pspec ((GObject *) self, application_client_properties[APPLICATION_CLIENT_IS_FLATPAK_SANDBOXED_PROPERTY]);
	}
}

ApplicationController*
application_client_get_controller (ApplicationClient* self)
{
	ApplicationController* result;
	ApplicationController* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = self->priv->_controller;
	result = _tmp0_;
	return result;
}

static void
application_client_set_controller (ApplicationClient* self,
                                   ApplicationController* value)
{
	ApplicationController* old_value;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	old_value = application_client_get_controller (self);
	if (old_value != value) {
		ApplicationController* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_controller);
		self->priv->_controller = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_client_properties[APPLICATION_CLIENT_CONTROLLER_PROPERTY]);
	}
}

gboolean
application_client_get_is_installed (ApplicationClient* self)
{
	gboolean result;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), FALSE);
	_tmp0_ = self->priv->exec_dir;
	_tmp1_ = self->priv->_install_prefix;
	result = g_file_has_prefix (_tmp0_, _tmp1_);
	return result;
}

GFile*
application_client_get_install_prefix (ApplicationClient* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = self->priv->_install_prefix;
	result = _tmp0_;
	return result;
}

static void
application_client_set_install_prefix (ApplicationClient* self,
                                       GFile* value)
{
	GFile* old_value;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	old_value = application_client_get_install_prefix (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_install_prefix);
		self->priv->_install_prefix = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_client_properties[APPLICATION_CLIENT_INSTALL_PREFIX_PROPERTY]);
	}
}

/**
     * Returns name/value pairs of application information.
     *
     * This includes Geary library version information, the current
     * desktop, and so on.
     */
GeeCollection*
application_client_get_runtime_information (ApplicationClient* self)
{
	GeeLinkedList* info = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	ApplicationClientRuntimeDetail _tmp2_ = {0};
	GeeLinkedList* _tmp3_;
	ApplicationClientRuntimeDetail _tmp4_ = {0};
	GeeLinkedList* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ApplicationClientRuntimeDetail _tmp8_ = {0};
	GeeLinkedList* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ApplicationClientRuntimeDetail _tmp12_ = {0};
	GeeLinkedList* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	ApplicationClientRuntimeDetail _tmp16_ = {0};
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_;
	GeeLinkedList* _tmp19_;
	ApplicationClientRuntimeDetail _tmp20_ = {0};
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	GeeLinkedList* _tmp24_;
	ApplicationClientRuntimeDetail _tmp25_ = {0};
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	GeeLinkedList* _tmp29_;
	ApplicationClientRuntimeDetail _tmp30_ = {0};
	GeeLinkedList* _tmp31_;
	ApplicationClientRuntimeDetail _tmp32_ = {0};
	GeeCollection* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = gee_linked_list_new (APPLICATION_CLIENT_TYPE_RUNTIME_DETAIL, (GBoxedCopyFunc) application_client_runtime_detail_dup, (GDestroyNotify) application_client_runtime_detail_free, NULL, NULL, NULL);
	info = _tmp0_;
	_tmp1_ = info;
	_g_free0 (_tmp2_.name);
	_tmp2_.name = _ ("Geary version");
	_g_free0 (_tmp2_.value);
	_tmp2_.value = APPLICATION_CLIENT_VERSION;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp2_);
	_tmp3_ = info;
	_g_free0 (_tmp4_.name);
	_tmp4_.name = _ ("Geary revision");
	_g_free0 (_tmp4_.value);
	_tmp4_.value = _REVNO;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp4_);
	_tmp5_ = info;
	_tmp6_ = g_strdup_printf ("%u.%u.%u", gtk_get_major_version (), gtk_get_minor_version (), gtk_get_micro_version ());
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp8_.name);
	_tmp8_.name = _ ("GTK version");
	_g_free0 (_tmp8_.value);
	_tmp8_.value = _tmp7_;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp8_);
	_g_free0 (_tmp7_);
	_tmp9_ = info;
	_tmp10_ = g_strdup_printf ("%u.%u.%u", glib_major_version, glib_minor_version, glib_micro_version);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp12_.name);
	_tmp12_.name = _ ("GLib version");
	_g_free0 (_tmp12_.value);
	_tmp12_.value = _tmp11_;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp12_);
	_g_free0 (_tmp11_);
	_tmp13_ = info;
	_tmp14_ = g_strdup_printf ("%u.%u.%u", webkit_get_major_version (), webkit_get_minor_version (), webkit_get_micro_version ());
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp16_.name);
	_tmp16_.name = _ ("WebKitGTK version");
	_g_free0 (_tmp16_.value);
	_tmp16_.value = _tmp15_;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp16_);
	_g_free0 (_tmp15_);
	_tmp18_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp17_ = _tmp18_;
	if (_tmp17_ == NULL) {
		_tmp17_ = _ ("Unknown");
	}
	_tmp19_ = info;
	_g_free0 (_tmp20_.name);
	_tmp20_.name = _ ("Desktop environment");
	_g_free0 (_tmp20_.value);
	_tmp20_.value = _tmp17_;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp20_);
	_tmp22_ = g_get_os_info (G_OS_INFO_KEY_NAME);
	_tmp21_ = _tmp22_;
	if (_tmp21_ == NULL) {
		gchar* _tmp23_;
		_tmp23_ = g_strdup (_ ("Unknown"));
		_g_free0 (_tmp21_);
		_tmp21_ = _tmp23_;
	}
	_tmp24_ = info;
	_g_free0 (_tmp25_.name);
	_tmp25_.name = _ ("Distribution name");
	_g_free0 (_tmp25_.value);
	_tmp25_.value = _tmp21_;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp25_);
	_tmp27_ = g_get_os_info (G_OS_INFO_KEY_VERSION);
	_tmp26_ = _tmp27_;
	if (_tmp26_ == NULL) {
		gchar* _tmp28_;
		_tmp28_ = g_strdup (_ ("Unknown"));
		_g_free0 (_tmp26_);
		_tmp26_ = _tmp28_;
	}
	_tmp29_ = info;
	_g_free0 (_tmp30_.name);
	_tmp30_.name = _ ("Distribution release");
	_g_free0 (_tmp30_.value);
	_tmp30_.value = _tmp26_;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp30_);
	_tmp31_ = info;
	_g_free0 (_tmp32_.name);
	_tmp32_.name = _ ("Installation prefix");
	_g_free0 (_tmp32_.value);
	_tmp32_.value = APPLICATION_CLIENT_INSTALL_PREFIX;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp32_);
	result = G_TYPE_CHECK_INSTANCE_CAST (info, GEE_TYPE_COLLECTION, GeeCollection);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp21_);
	return result;
}

static void
_application_client_on_window_removed_gtk_application_window_removed (GtkApplication* _sender,
                                                                      GtkWindow* window,
                                                                      gpointer self)
{
	application_client_on_window_removed ((ApplicationClient*) self, window);
}

ApplicationClient*
application_client_construct (GType object_type)
{
	ApplicationClient * self = NULL;
	self = (ApplicationClient*) g_object_new (object_type, "application-id", APPLICATION_CLIENT_APP_ID, "resource-base-path", APPLICATION_CLIENT_RESOURCE_BASE_PATH, "flags", G_APPLICATION_HANDLES_OPEN | G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	g_application_add_main_option_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication), APPLICATION_CLIENT_OPTION_ENTRIES);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "window-removed", (GCallback) _application_client_on_window_removed_gtk_application_window_removed, self, G_CONNECT_AFTER);
	application_client_set_is_flatpak_sandboxed (self, g_file_test ("/.flatpak-info", G_FILE_TEST_EXISTS));
	return self;
}

ApplicationClient*
application_client_new (void)
{
	return application_client_construct (APPLICATION_TYPE_CLIENT);
}

static gboolean
application_client_real_local_command_line (GApplication* base,
                                            gchar*** args,
                                            gint* exit_status)
{
	ApplicationClient * self;
	gint _vala_exit_status = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* current_path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gint _tmp14_ = 0;
	gboolean _tmp15_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_CLIENT, ApplicationClient);
	_tmp0_ = (*args)[0];
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->binary);
	self->priv->binary = _tmp1_;
	_tmp2_ = self->priv->binary;
	_tmp3_ = g_find_program_in_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = realpath (_tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	current_path = _tmp6_;
	_tmp7_ = current_path;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->binary;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (current_path);
		current_path = _tmp9_;
	}
	_tmp10_ = current_path;
	_tmp11_ = g_file_new_for_path (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_file_get_parent (_tmp12_);
	_g_object_unref0 (self->priv->exec_dir);
	self->priv->exec_dir = _tmp13_;
	_g_object_unref0 (_tmp12_);
	_tmp15_ = G_APPLICATION_CLASS (application_client_parent_class)->local_command_line (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication), args, &_tmp14_);
	_vala_exit_status = _tmp14_;
	result = _tmp15_;
	_g_free0 (current_path);
	if (exit_status) {
		*exit_status = _vala_exit_status;
	}
	return result;
}

static gint
application_client_real_handle_local_options (GApplication* base,
                                              GVariantDict* options)
{
	ApplicationClient * self;
	gint ret = 0;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_CLIENT, ApplicationClient);
	g_return_val_if_fail (options != NULL, 0);
	ret = -1;
	if (g_variant_dict_contains (options, APPLICATION_CLIENT_OPTION_DEBUG)) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		geary_logging_log_to (_tmp0_);
	}
	if (g_variant_dict_contains (options, APPLICATION_CLIENT_OPTION_VERSION)) {
		FILE* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = stdout;
		_tmp2_ = self->priv->binary;
		fprintf (_tmp1_, "%s: %s\n", _tmp2_, APPLICATION_CLIENT_VERSION);
		ret = 0;
	}
	result = ret;
	return result;
}

static void
_application_client_on_single_key_shortcuts_toggled_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self)
{
	application_client_on_single_key_shortcuts_toggled ((ApplicationClient*) self);
}

static void
application_client_real_startup (GApplication* base)
{
	ApplicationClient * self;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GearyEngine* _tmp5_;
	GearyEngine* _tmp6_;
	ApplicationConfiguration* _tmp7_;
	ApplicationConfiguration* _tmp8_;
	ApplicationStartupManager* _tmp9_;
	ApplicationStartupManager* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	gchar* _tmp36_;
	gchar** _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	gchar* _tmp39_;
	gchar** _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar* _tmp42_;
	gchar** _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	GtkBindingSet* bindings = NULL;
	GTypeClass* _tmp45_;
	GObjectClass* _tmp46_;
	GtkBindingSet* _tmp47_;
	GtkBindingSet* _tmp48_;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp49_;
	GdkDisplay* _tmp50_;
	GdkScreen* _tmp51_;
	GtkCssProvider* _tmp52_;
	ApplicationConfiguration* _tmp53_;
	gchar* _tmp54_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_CLIENT, ApplicationClient);
	g_set_application_name (APPLICATION_CLIENT_NAME);
	_tmp0_ = self->priv->binary;
	util_i18n_init (GETTEXT_PACKAGE, _tmp0_, UTIL_I18N_SYSTEM_LOCALE);
	util_date_init ();
	_tmp1_ = application_client_get_is_installed (self);
	_tmp2_ = _tmp1_;
	application_configuration_init (_tmp2_, APPLICATION_CLIENT_GSETTINGS_DIR);
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), APPLICATION_CLIENT_ACTION_ENTRIES, (gint) G_N_ELEMENTS (APPLICATION_CLIENT_ACTION_ENTRIES), self);
	G_APPLICATION_CLASS (application_client_parent_class)->startup (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	hdy_init ();
	_tmp3_ = application_client_get_resource_directory (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_engine_new (_tmp4_);
	_tmp6_ = _tmp5_;
	application_client_set_engine (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_tmp7_ = application_configuration_new (APPLICATION_CLIENT_SCHEMA_ID);
	_tmp8_ = _tmp7_;
	application_client_set_config (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = application_startup_manager_new (self);
	_tmp10_ = _tmp9_;
	application_client_set_autostart (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	gtk_window_set_default_icon_name (APPLICATION_CLIENT_APP_ID);
	_tmp11_ = g_strdup ("<Ctrl>N");
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	application_client_add_app_accelerators (self, ACTION_APPLICATION_COMPOSE, _tmp13_, (gint) 1, NULL);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = g_strdup ("F1");
	_tmp15_ = g_new0 (gchar*, 1 + 1);
	_tmp15_[0] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 1;
	application_client_add_app_accelerators (self, ACTION_APPLICATION_HELP, _tmp16_, (gint) 1, NULL);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_tmp17_ = g_strdup ("<Alt><Shift>I");
	_tmp18_ = g_new0 (gchar*, 1 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 1;
	application_client_add_app_accelerators (self, ACTION_APPLICATION_INSPECT, _tmp19_, (gint) 1, NULL);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_tmp20_ = g_strdup ("<Ctrl><Shift>N");
	_tmp21_ = g_new0 (gchar*, 1 + 1);
	_tmp21_[0] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 1;
	application_client_add_app_accelerators (self, ACTION_APPLICATION_NEW_WINDOW, _tmp22_, (gint) 1, NULL);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = g_strdup ("<Ctrl>Q");
	_tmp24_ = g_new0 (gchar*, 1 + 1);
	_tmp24_[0] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 1;
	application_client_add_app_accelerators (self, ACTION_APPLICATION_QUIT, _tmp25_, (gint) 1, NULL);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = g_strdup ("<Ctrl>W");
	_tmp27_ = g_new0 (gchar*, 1 + 1);
	_tmp27_[0] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	application_client_add_window_accelerators (self, ACTION_WINDOW_CLOSE, _tmp28_, (gint) 1, NULL);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = g_strdup ("<Ctrl>F1");
	_tmp30_ = g_strdup ("<Ctrl>question");
	_tmp31_ = g_new0 (gchar*, 2 + 1);
	_tmp31_[0] = _tmp29_;
	_tmp31_[1] = _tmp30_;
	_tmp32_ = _tmp31_;
	_tmp32__length1 = 2;
	application_client_add_window_accelerators (self, ACTION_WINDOW_SHORTCUT_HELP, _tmp32_, (gint) 2, NULL);
	_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
	_tmp33_ = g_strdup ("F10");
	_tmp34_ = g_new0 (gchar*, 1 + 1);
	_tmp34_[0] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 1;
	application_client_add_window_accelerators (self, ACTION_WINDOW_SHOW_MENU, _tmp35_, (gint) 1, NULL);
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
	_tmp36_ = g_strdup ("<Ctrl>C");
	_tmp37_ = g_new0 (gchar*, 1 + 1);
	_tmp37_[0] = _tmp36_;
	_tmp38_ = _tmp37_;
	_tmp38__length1 = 1;
	application_client_add_edit_accelerators (self, ACTION_EDIT_COPY, _tmp38_, (gint) 1, NULL);
	_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
	_tmp39_ = g_strdup ("<Ctrl><Shift>Z");
	_tmp40_ = g_new0 (gchar*, 1 + 1);
	_tmp40_[0] = _tmp39_;
	_tmp41_ = _tmp40_;
	_tmp41__length1 = 1;
	application_client_add_edit_accelerators (self, ACTION_EDIT_REDO, _tmp41_, (gint) 1, NULL);
	_tmp41_ = (_vala_array_free (_tmp41_, _tmp41__length1, (GDestroyNotify) g_free), NULL);
	_tmp42_ = g_strdup ("<Ctrl>Z");
	_tmp43_ = g_new0 (gchar*, 1 + 1);
	_tmp43_[0] = _tmp42_;
	_tmp44_ = _tmp43_;
	_tmp44__length1 = 1;
	application_client_add_edit_accelerators (self, ACTION_EDIT_UNDO, _tmp44_, (gint) 1, NULL);
	_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
	_tmp45_ = g_type_class_ref (gtk_list_box_row_get_type ());
	_tmp46_ = (GObjectClass*) _tmp45_;
	_tmp47_ = gtk_binding_set_by_class ((gpointer) _tmp46_);
	_tmp48_ = _tmp47_;
	_g_type_class_unref0 (_tmp46_);
	bindings = _tmp48_;
	gtk_binding_entry_add_signal (bindings, GDK_KEY_Right, GDK_MOD1_MASK, "activate", (guint) 0, NULL);
	gtk_binding_entry_add_signal (bindings, GDK_KEY_Forward, 0, "activate", (guint) 0, NULL);
	_tmp49_ = gtk_css_provider_new ();
	provider = _tmp49_;
	_tmp50_ = gdk_display_get_default ();
	_tmp51_ = gdk_display_get_default_screen (_tmp50_);
	gtk_style_context_add_provider_for_screen (_tmp51_, G_TYPE_CHECK_INSTANCE_CAST (provider, gtk_style_provider_get_type (), GtkStyleProvider), (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	application_client_load_css (self, provider, "resource:///org/gnome/Geary/geary.css");
	_tmp52_ = self->priv->single_key_shortcuts;
	application_client_load_css (self, _tmp52_, "resource:///org/gnome/Geary/single-key-shortcuts.css");
	application_client_update_single_key_shortcuts (self);
	_tmp53_ = self->priv->_config;
	_tmp54_ = g_strconcat ("notify::", APPLICATION_CONFIGURATION_SINGLE_KEY_SHORTCUTS, NULL);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, G_TYPE_OBJECT, GObject), _tmp54_, (GCallback) _application_client_on_single_key_shortcuts_toggled_g_object_notify, self, 0);
	_g_free0 (_tmp54_);
	application_main_window_add_accelerators (self);
	composer_editor_add_accelerators (self);
	composer_widget_add_accelerators (self);
	components_inspector_add_accelerators (self);
	components_preferences_window_add_accelerators (self);
	dialogs_problem_details_dialog_add_accelerators (self);
	g_application_hold (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
	application_client_create_controller (self, NULL, NULL);
	_g_object_unref0 (provider);
}

static gint
application_client_real_command_line (GApplication* base,
                                      GApplicationCommandLine* command_line)
{
	ApplicationClient * self;
	gint exit_value = 0;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_CLIENT, ApplicationClient);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (command_line, g_application_command_line_get_type ()), 0);
	exit_value = application_client_handle_general_options (self, command_line);
	if (exit_value != -1) {
		result = exit_value;
		return result;
	}
	result = -1;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ApplicationClient* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda182_ (Block5Data* _data5_,
              GObject* obj,
              GAsyncResult* res)
{
	ApplicationClient* self;
	self = _data5_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	application_client_destroy_controller_finish (self, res);
	_data5_->controller_closed = TRUE;
}

static void
___lambda182__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda182_ (self, source_object, res);
	block5_data_unref (self);
}

static void
application_client_real_shutdown (GApplication* base)
{
	ApplicationClient * self;
	Block5Data* _data5_;
	gint64 start_usec = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_CLIENT, ApplicationClient);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->controller_closed = FALSE;
	application_client_destroy_controller (self, ___lambda182__gasync_ready_callback, block5_data_ref (_data5_));
	start_usec = g_get_monotonic_time ();
	while (TRUE) {
		gint64 delta_usec = 0LL;
		if (!(!_data5_->controller_closed)) {
			break;
		}
		gtk_main_iteration ();
		delta_usec = g_get_monotonic_time () - start_usec;
		if (delta_usec >= APPLICATION_CLIENT_FORCE_SHUTDOWN_USEC) {
			gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, delta_usec / APPLICATION_CLIENT_USEC_PER_SEC);
			_tmp1_ = _tmp0_;
			g_warning ("application-client.vala:475: Forcing shutdown of Geary, %ss passed...", _tmp1_);
			_g_free0 (_tmp1_);
			exit (2);
		}
	}
	application_client_set_engine (self, NULL);
	application_client_set_config (self, NULL);
	application_client_set_autostart (self, NULL);
	util_date_terminate ();
	geary_logging_clear ();
	G_APPLICATION_CLASS (application_client_parent_class)->shutdown (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
application_client_real_activate (GApplication* base)
{
	ApplicationClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_CLIENT, ApplicationClient);
	G_APPLICATION_CLASS (application_client_parent_class)->activate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	application_client_present (self, NULL, NULL);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
application_client_real_open (GApplication* base,
                              GFile** targets,
                              gint targets_length1,
                              const gchar* hint)
{
	ApplicationClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_CLIENT, ApplicationClient);
	g_return_if_fail (hint != NULL);
	{
		GFile** target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
		target_collection = targets;
		target_collection_length1 = targets_length1;
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
			GFile* _tmp0_;
			GFile* target = NULL;
			_tmp0_ = _g_object_ref0 (target_collection[target_it]);
			target = _tmp0_;
			{
				GFile* _tmp1_;
				gchar* _tmp2_;
				gchar* _tmp3_;
				gboolean _tmp4_;
				_tmp1_ = target;
				_tmp2_ = g_file_get_uri_scheme (_tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strcmp0 (_tmp3_, "mailto") == 0;
				_g_free0 (_tmp3_);
				if (_tmp4_) {
					gchar* mailto = NULL;
					GFile* _tmp5_;
					gchar* _tmp6_;
					static const char B0RKED_GLIB_MAILTO_PREFIX[] = "mailto:///";
					const gchar* _tmp7_;
					const gchar* _tmp14_;
					_tmp5_ = target;
					_tmp6_ = g_file_get_uri (_tmp5_);
					mailto = _tmp6_;
					_tmp7_ = mailto;
					if (g_str_has_prefix (_tmp7_, B0RKED_GLIB_MAILTO_PREFIX)) {
						const gchar* _tmp8_;
						gint _tmp9_;
						gint _tmp10_;
						gchar* _tmp11_;
						gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp8_ = mailto;
						_tmp9_ = strlen (B0RKED_GLIB_MAILTO_PREFIX);
						_tmp10_ = _tmp9_;
						_tmp11_ = string_substring (_tmp8_, (glong) _tmp10_, (glong) -1);
						_tmp12_ = _tmp11_;
						_tmp13_ = g_strconcat (APPLICATION_CLIENT_MAILTO_URI_SCHEME_PREFIX, _tmp12_, NULL);
						_g_free0 (mailto);
						mailto = _tmp13_;
						_g_free0 (_tmp12_);
					}
					_tmp14_ = mailto;
					application_client_new_composer_mailto (self, _tmp14_, NULL, NULL);
					_g_free0 (mailto);
				}
				_g_object_unref0 (target);
			}
		}
	}
}

/**
     * Returns a collection of open main windows.
     */
GeeCollection*
application_client_get_main_windows (ApplicationClient* self)
{
	GeeLinkedList* windows = NULL;
	GeeLinkedList* _tmp0_;
	GList* _tmp1_;
	GeeCollection* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = gee_linked_list_new (APPLICATION_TYPE_MAIN_WINDOW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	windows = _tmp0_;
	_tmp1_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp2_;
			{
				ApplicationMainWindow* main = NULL;
				GtkWindow* _tmp3_;
				ApplicationMainWindow* _tmp4_;
				ApplicationMainWindow* _tmp5_;
				_tmp3_ = window;
				_tmp4_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp3_) ? ((ApplicationMainWindow*) _tmp3_) : NULL);
				main = _tmp4_;
				_tmp5_ = main;
				if (_tmp5_ != NULL) {
					GeeLinkedList* _tmp6_;
					ApplicationMainWindow* _tmp7_;
					_tmp6_ = windows;
					_tmp7_ = main;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp7_);
				}
				_g_object_unref0 (main);
				_g_object_unref0 (window);
			}
		}
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (windows, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

/**
     * Returns the mostly recently active main window or a new instance.
     *
     * This returns the value of {@link last_active_main_window} if
     * not null, else it constructs a new MainWindow instance and
     * shows it.
     */
ApplicationMainWindow*
application_client_get_active_main_window (ApplicationClient* self)
{
	ApplicationMainWindow* _tmp0_;
	ApplicationMainWindow* _tmp3_;
	ApplicationMainWindow* _tmp4_;
	ApplicationMainWindow* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = self->priv->_last_active_main_window;
	if (_tmp0_ == NULL) {
		ApplicationMainWindow* _tmp1_;
		ApplicationMainWindow* _tmp2_;
		_tmp1_ = application_client_new_main_window (self, TRUE);
		_tmp2_ = _tmp1_;
		application_client_set_last_active_main_window (self, _tmp2_);
		_g_object_unref0 (_tmp2_);
	}
	_tmp3_ = self->priv->_last_active_main_window;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
application_client_add_window_accelerators (ApplicationClient* self,
                                            const gchar* action,
                                            gchar** accelerators,
                                            gint accelerators_length1,
                                            GVariant* param)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	gchar** all_accel = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint all_accel_length1;
	gint _all_accel_size_;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (action != NULL);
	_tmp0_ = action_window_prefix (action);
	name = _tmp0_;
	_tmp1_ = name;
	_tmp3_ = _tmp2_ = gtk_application_get_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp1_);
	all_accel = _tmp3_;
	all_accel_length1 = _vala_array_length (_tmp2_);
	_all_accel_size_ = all_accel_length1;
	{
		gchar** accel_collection = NULL;
		gint accel_collection_length1 = 0;
		gint _accel_collection_size_ = 0;
		gint accel_it = 0;
		accel_collection = accelerators;
		accel_collection_length1 = accelerators_length1;
		for (accel_it = 0; accel_it < accel_collection_length1; accel_it = accel_it + 1) {
			gchar* _tmp4_;
			gchar* accel = NULL;
			_tmp4_ = g_strdup (accel_collection[accel_it]);
			accel = _tmp4_;
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = accel;
				_tmp6_ = g_strdup (_tmp5_);
				_vala_array_add1 (&all_accel, &all_accel_length1, &_all_accel_size_, _tmp6_);
				_g_free0 (accel);
			}
		}
	}
	_tmp7_ = name;
	_tmp8_ = all_accel;
	_tmp8__length1 = all_accel_length1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp7_, _tmp8_);
	all_accel = (_vala_array_free (all_accel, all_accel_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
application_client_add_edit_accelerators (ApplicationClient* self,
                                          const gchar* action,
                                          gchar** accelerators,
                                          gint accelerators_length1,
                                          GVariant* param)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	gchar** all_accel = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint all_accel_length1;
	gint _all_accel_size_;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (action != NULL);
	_tmp0_ = action_edit_prefix (action);
	name = _tmp0_;
	_tmp1_ = name;
	_tmp3_ = _tmp2_ = gtk_application_get_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp1_);
	all_accel = _tmp3_;
	all_accel_length1 = _vala_array_length (_tmp2_);
	_all_accel_size_ = all_accel_length1;
	{
		gchar** accel_collection = NULL;
		gint accel_collection_length1 = 0;
		gint _accel_collection_size_ = 0;
		gint accel_it = 0;
		accel_collection = accelerators;
		accel_collection_length1 = accelerators_length1;
		for (accel_it = 0; accel_it < accel_collection_length1; accel_it = accel_it + 1) {
			gchar* _tmp4_;
			gchar* accel = NULL;
			_tmp4_ = g_strdup (accel_collection[accel_it]);
			accel = _tmp4_;
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = accel;
				_tmp6_ = g_strdup (_tmp5_);
				_vala_array_add2 (&all_accel, &all_accel_length1, &_all_accel_size_, _tmp6_);
				_g_free0 (accel);
			}
		}
	}
	_tmp7_ = name;
	_tmp8_ = all_accel;
	_tmp8__length1 = all_accel_length1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp7_, _tmp8_);
	all_accel = (_vala_array_free (all_accel, all_accel_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
}

static void
application_client_show_about_data_free (gpointer _data)
{
	ApplicationClientShowAboutData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientShowAboutData, _data_);
}

void
application_client_show_about (ApplicationClient* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	ApplicationClientShowAboutData* _data_;
	ApplicationClient* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_data_ = g_slice_new0 (ApplicationClientShowAboutData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_show_about_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	application_client_show_about_co (_data_);
}

void
application_client_show_about_finish (ApplicationClient* self,
                                      GAsyncResult* _res_)
{
	ApplicationClientShowAboutData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_client_show_about_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	ApplicationClientShowAboutData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_show_about_co (_data_);
}

static gboolean
application_client_show_about_co (ApplicationClientShowAboutData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_client_present (_data_->self, application_client_show_about_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = application_client_present_finish (_data_->self, _data_->_res_);
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_object_unref0 (_data_->_tmp1_);
	if (g_strcmp0 (_REVNO, "") == 0) {
		_data_->_tmp3_ = g_strdup (APPLICATION_CLIENT_VERSION);
		_g_free0 (_data_->_tmp2_);
		_data_->_tmp2_ = _data_->_tmp3_;
	} else {
		_data_->_tmp4_ = g_strdup_printf ("%s (%s)", APPLICATION_CLIENT_VERSION, _REVNO);
		_g_free0 (_data_->_tmp2_);
		_data_->_tmp2_ = _data_->_tmp4_;
	}
	_data_->_tmp5_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_application_get_type (), GtkApplication));
	_data_->_tmp6_ = g_strjoin ("\n", APPLICATION_CLIENT_COPYRIGHT_1, APPLICATION_CLIENT_COPYRIGHT_2, NULL);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = g_strdup_printf (_ ("About %s"), APPLICATION_CLIENT_NAME);
	_data_->_tmp9_ = _data_->_tmp8_;
	gtk_show_about_dialog (_data_->_tmp5_, "program-name", APPLICATION_CLIENT_NAME, "comments", APPLICATION_CLIENT_DESCRIPTION, "authors", APPLICATION_CLIENT_AUTHORS, "copyright", _data_->_tmp7_, "license-type", GTK_LICENSE_LGPL_2_1, "logo-icon-name", APPLICATION_CLIENT_APP_ID, "version", _data_->_tmp2_, "website", APPLICATION_CLIENT_WEBSITE, "website-label", APPLICATION_CLIENT_WEBSITE_LABEL, "title", _data_->_tmp9_, "translator-credits", _ ("translator-credits"), NULL);
	_g_free0 (_data_->_tmp9_);
	_g_free0 (_data_->_tmp7_);
	_g_free0 (_data_->_tmp2_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_client_show_accounts_data_free (gpointer _data)
{
	ApplicationClientShowAccountsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientShowAccountsData, _data_);
}

void
application_client_show_accounts (ApplicationClient* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	ApplicationClientShowAccountsData* _data_;
	ApplicationClient* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_data_ = g_slice_new0 (ApplicationClientShowAccountsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_show_accounts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	application_client_show_accounts_co (_data_);
}

void
application_client_show_accounts_finish (ApplicationClient* self,
                                         GAsyncResult* _res_)
{
	ApplicationClientShowAccountsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_client_show_accounts_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	ApplicationClientShowAccountsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_show_accounts_co (_data_);
}

static gboolean
application_client_show_accounts_co (ApplicationClientShowAccountsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_client_present (_data_->self, application_client_show_accounts_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = application_client_present_finish (_data_->self, _data_->_res_);
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->_tmp2_ = application_client_get_active_main_window (_data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = accounts_editor_new (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, gtk_window_get_type (), GtkWindow));
	g_object_ref_sink (_data_->_tmp4_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp3_);
	_data_->editor = _data_->_tmp5_;
	gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_data_->editor, gtk_dialog_get_type (), GtkDialog));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_data_->editor, gtk_widget_get_type (), GtkWidget));
	_data_->_tmp6_ = _data_->self->priv->_controller;
	application_controller_expunge_accounts (_data_->_tmp6_, NULL, NULL);
	_g_object_unref0 (_data_->editor);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_client_show_email_data_free (gpointer _data)
{
	ApplicationClientShowEmailData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientShowEmailData, _data_);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

void
application_client_show_email (ApplicationClient* self,
                               GVariant* id,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	ApplicationClientShowEmailData* _data_;
	ApplicationClient* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_data_ = g_slice_new0 (ApplicationClientShowEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_show_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_variant_ref0 (id);
	_g_variant_unref0 (_data_->id);
	_data_->id = _tmp1_;
	application_client_show_email_co (_data_);
}

void
application_client_show_email_finish (ApplicationClient* self,
                                      GAsyncResult* _res_)
{
	ApplicationClientShowEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Displays a specific email in a main window.
     *
     * This method is invoked by the application `show-email`
     * action. A folder containing the email will be selected if the
     * current folder does not select it.
     *
     * The email is identified by the given variant, which can be
     * obtained by calling {@link Plugin.EmailIdentifier.to_variant}.
     */
static void
application_client_show_email_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	ApplicationClientShowEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_show_email_co (_data_);
}

static gboolean
application_client_show_email_co (ApplicationClientShowEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_client_present (_data_->self, application_client_show_email_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = application_client_present_finish (_data_->self, _data_->_res_);
	_data_->main = _data_->_tmp0_;
	if (_data_->id != NULL) {
		_data_->_tmp1_ = _data_->self->priv->_controller;
		_data_->_tmp2_ = application_controller_get_plugins (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = application_plugin_manager_get_globals (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = application_plugin_manager_plugin_globals_get_email (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
		_data_->email = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->email;
		_data_->_tmp10_ = application_email_store_factory_get_account_for_variant (_data_->_tmp9_, _data_->id);
		_data_->context = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->email;
		_data_->_tmp12_ = application_email_store_factory_get_email_identifier_for_variant (_data_->_tmp11_, _data_->id);
		_data_->email_id = _data_->_tmp12_;
		_data_->_tmp14_ = _data_->context;
		if (_data_->_tmp14_ != NULL) {
			_data_->_tmp15_ = _data_->email_id;
			_data_->_tmp13_ = _data_->_tmp15_ != NULL;
		} else {
			_data_->_tmp13_ = FALSE;
		}
		if (_data_->_tmp13_) {
			_data_->folders = NULL;
			{
				_data_->_tmp17_ = _data_->context;
				_data_->_tmp18_ = application_account_context_get_account (_data_->_tmp17_);
				_data_->_tmp19_ = _data_->_tmp18_;
				_data_->_tmp20_ = _data_->email_id;
				_data_->_tmp21_ = geary_collection_single (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp20_);
				_data_->_tmp22_ = _data_->_tmp21_;
				_data_->_tmp23_ = _data_->context;
				_data_->_tmp24_ = application_account_context_get_cancellable (_data_->_tmp23_);
				_data_->_tmp25_ = _data_->_tmp24_;
				_data_->_state_ = 2;
				geary_account_get_containing_folders_async (_data_->_tmp19_, _data_->_tmp22_, _data_->_tmp25_, application_client_show_email_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp26_ = geary_account_get_containing_folders_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp27_ = _data_->_tmp26_;
				_g_object_unref0 (_data_->_tmp22_);
				_data_->_tmp16_ = _data_->_tmp27_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_data_->_tmp28_ = _data_->_tmp16_;
				_data_->_tmp16_ = NULL;
				_g_object_unref0 (_data_->folders);
				_data_->folders = _data_->_tmp28_;
				_g_object_unref0 (_data_->_tmp16_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->err = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp29_ = _data_->err;
				_data_->_tmp30_ = _data_->_tmp29_->message;
				g_warning ("application-client.vala:622: Error listing folders for email: %s", _data_->_tmp30_);
				_g_error_free0 (_data_->err);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->folders);
				_g_object_unref0 (_data_->email_id);
				_g_object_unref0 (_data_->context);
				_g_object_unref0 (_data_->email);
				_g_object_unref0 (_data_->main);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp31_ = _data_->folders;
			if (_data_->_tmp31_ != NULL) {
				_data_->_tmp32_ = _data_->folders;
				_data_->_tmp33_ = _data_->email_id;
				_data_->_tmp34_ = gee_multi_map_get (_data_->_tmp32_, _data_->_tmp33_);
				_data_->paths = _data_->_tmp34_;
				_data_->_tmp35_ = _data_->main;
				_data_->_tmp36_ = application_main_window_get_selected_folder (_data_->_tmp35_);
				_data_->_tmp37_ = _data_->_tmp36_;
				_data_->_tmp38_ = _g_object_ref0 (_data_->_tmp37_);
				_data_->selected = _data_->_tmp38_;
				_data_->_tmp41_ = _data_->selected;
				if (_data_->_tmp41_ == NULL) {
					_data_->_tmp40_ = TRUE;
				} else {
					_data_->_tmp42_ = _data_->selected;
					_data_->_tmp43_ = geary_folder_get_account (_data_->_tmp42_);
					_data_->_tmp44_ = _data_->_tmp43_;
					_data_->_tmp45_ = _data_->context;
					_data_->_tmp46_ = application_account_context_get_account (_data_->_tmp45_);
					_data_->_tmp47_ = _data_->_tmp46_;
					_data_->_tmp40_ = _data_->_tmp44_ != _data_->_tmp47_;
				}
				if (_data_->_tmp40_) {
					_data_->_tmp39_ = TRUE;
				} else {
					_data_->_tmp48_ = _data_->paths;
					_data_->_tmp49_ = _data_->selected;
					_data_->_tmp50_ = geary_folder_get_path (_data_->_tmp49_);
					_data_->_tmp51_ = _data_->_tmp50_;
					_data_->_tmp39_ = !gee_collection_contains (_data_->_tmp48_, _data_->_tmp51_);
				}
				if (_data_->_tmp39_) {
					_g_object_unref0 (_data_->selected);
					_data_->selected = NULL;
					{
						_data_->_tmp52_ = _data_->paths;
						_data_->_tmp53_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp52_, GEE_TYPE_ITERABLE, GeeIterable));
						_data_->_path_it = _data_->_tmp53_;
						while (TRUE) {
							_data_->_tmp54_ = _data_->_path_it;
							if (!gee_iterator_next (_data_->_tmp54_)) {
								break;
							}
							_data_->_tmp55_ = _data_->_path_it;
							_data_->_tmp56_ = gee_iterator_get (_data_->_tmp55_);
							_data_->path = (GearyFolderPath*) _data_->_tmp56_;
							{
								_data_->_tmp57_ = _data_->context;
								_data_->_tmp58_ = application_account_context_get_account (_data_->_tmp57_);
								_data_->_tmp59_ = _data_->_tmp58_;
								_data_->_tmp60_ = _data_->path;
								_data_->_tmp61_ = geary_account_get_folder (_data_->_tmp59_, _data_->_tmp60_, &_data_->_inner_error0_);
								_data_->folder = _data_->_tmp61_;
								if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
									goto __catch1_g_error;
								}
								_data_->_tmp62_ = _data_->folder;
								_data_->_tmp63_ = geary_folder_get_used_as (_data_->_tmp62_);
								_data_->_tmp64_ = _data_->_tmp63_;
								if (_data_->_tmp64_ == GEARY_FOLDER_SPECIAL_USE_INBOX) {
									_data_->_tmp65_ = _data_->folder;
									_data_->_tmp66_ = _g_object_ref0 (_data_->_tmp65_);
									_g_object_unref0 (_data_->selected);
									_data_->selected = _data_->_tmp66_;
									_g_object_unref0 (_data_->folder);
									_g_object_unref0 (_data_->path);
									break;
								}
								_g_object_unref0 (_data_->folder);
							}
							goto __finally1;
							__catch1_g_error:
							{
								_data_->_vala1_err = _data_->_inner_error0_;
								_data_->_inner_error0_ = NULL;
								_data_->_tmp67_ = _data_->_vala1_err;
								_data_->_tmp68_ = _data_->_tmp67_->message;
								g_warning ("application-client.vala:645: Error getting folder for email: %s", _data_->_tmp68_);
								_g_error_free0 (_data_->_vala1_err);
							}
							__finally1:
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								_g_object_unref0 (_data_->path);
								_g_object_unref0 (_data_->_path_it);
								_g_object_unref0 (_data_->selected);
								_g_object_unref0 (_data_->paths);
								_g_object_unref0 (_data_->folders);
								_g_object_unref0 (_data_->email_id);
								_g_object_unref0 (_data_->context);
								_g_object_unref0 (_data_->email);
								_g_object_unref0 (_data_->main);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
								g_clear_error (&_data_->_inner_error0_);
								g_object_unref (_data_->_async_result);
								return FALSE;
							}
							_g_object_unref0 (_data_->path);
						}
						_g_object_unref0 (_data_->_path_it);
					}
					_data_->_tmp70_ = _data_->selected;
					if (_data_->_tmp70_ == NULL) {
						_data_->_tmp71_ = _data_->paths;
						_data_->_tmp72_ = gee_collection_get_is_empty (_data_->_tmp71_);
						_data_->_tmp73_ = _data_->_tmp72_;
						_data_->_tmp69_ = !_data_->_tmp73_;
					} else {
						_data_->_tmp69_ = FALSE;
					}
					if (_data_->_tmp69_) {
						{
							_data_->_tmp75_ = _data_->context;
							_data_->_tmp76_ = application_account_context_get_account (_data_->_tmp75_);
							_data_->_tmp77_ = _data_->_tmp76_;
							_data_->_tmp78_ = _data_->paths;
							_data_->_tmp79_ = geary_collection_first (GEARY_TYPE_FOLDER_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp78_);
							_data_->_tmp80_ = (GearyFolderPath*) _data_->_tmp79_;
							_data_->_tmp81_ = geary_account_get_folder (_data_->_tmp77_, _data_->_tmp80_, &_data_->_inner_error0_);
							_data_->_tmp82_ = _data_->_tmp81_;
							_g_object_unref0 (_data_->_tmp80_);
							_data_->_tmp74_ = _data_->_tmp82_;
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								goto __catch2_g_error;
							}
							_data_->_tmp83_ = _data_->_tmp74_;
							_data_->_tmp74_ = NULL;
							_g_object_unref0 (_data_->selected);
							_data_->selected = _data_->_tmp83_;
							_g_object_unref0 (_data_->_tmp74_);
						}
						goto __finally2;
						__catch2_g_error:
						{
							_data_->_vala2_err = _data_->_inner_error0_;
							_data_->_inner_error0_ = NULL;
							_data_->_tmp84_ = _data_->_vala2_err;
							_data_->_tmp85_ = _data_->_tmp84_->message;
							g_warning ("application-client.vala:658: Error getting folder for email: %s", _data_->_tmp85_);
							_g_error_free0 (_data_->_vala2_err);
						}
						__finally2:
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							_g_object_unref0 (_data_->selected);
							_g_object_unref0 (_data_->paths);
							_g_object_unref0 (_data_->folders);
							_g_object_unref0 (_data_->email_id);
							_g_object_unref0 (_data_->context);
							_g_object_unref0 (_data_->email);
							_g_object_unref0 (_data_->main);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
							g_clear_error (&_data_->_inner_error0_);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
					}
				}
				_data_->_tmp86_ = _data_->selected;
				if (_data_->_tmp86_ != NULL) {
					_data_->_tmp87_ = _data_->main;
					_data_->_tmp88_ = _data_->selected;
					_data_->_tmp89_ = _data_->email_id;
					_data_->_tmp90_ = geary_collection_single (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp89_);
					_data_->_tmp91_ = _data_->_tmp90_;
					_data_->_state_ = 3;
					application_main_window_show_email (_data_->_tmp87_, _data_->_tmp88_, _data_->_tmp91_, TRUE, application_client_show_email_ready, _data_);
					return FALSE;
					_state_3:
					application_main_window_show_email_finish (_data_->_tmp87_, _data_->_res_);
					_g_object_unref0 (_data_->_tmp91_);
				}
				_g_object_unref0 (_data_->selected);
				_g_object_unref0 (_data_->paths);
			}
			_g_object_unref0 (_data_->folders);
		}
		_g_object_unref0 (_data_->email_id);
		_g_object_unref0 (_data_->context);
		_g_object_unref0 (_data_->email);
	}
	_g_object_unref0 (_data_->main);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_client_show_folder_data_free (gpointer _data)
{
	ApplicationClientShowFolderData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientShowFolderData, _data_);
}

void
application_client_show_folder (ApplicationClient* self,
                                GVariant* id,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	ApplicationClientShowFolderData* _data_;
	ApplicationClient* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_data_ = g_slice_new0 (ApplicationClientShowFolderData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_show_folder_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_variant_ref0 (id);
	_g_variant_unref0 (_data_->id);
	_data_->id = _tmp1_;
	application_client_show_folder_co (_data_);
}

void
application_client_show_folder_finish (ApplicationClient* self,
                                       GAsyncResult* _res_)
{
	ApplicationClientShowFolderData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Selects a specific folder in a main window.
     *
     * This method is invoked by the application `show-folder` action.
     *
     * The folder is identified by the given variant, which can be
     * obtained by calling {@link Plugin.Folder.to_variant}.
     */
static void
application_client_show_folder_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	ApplicationClientShowFolderData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_show_folder_co (_data_);
}

static gboolean
application_client_show_folder_co (ApplicationClientShowFolderData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_client_present (_data_->self, application_client_show_folder_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = application_client_present_finish (_data_->self, _data_->_res_);
	_data_->main = _data_->_tmp0_;
	if (_data_->id != NULL) {
		_data_->_tmp1_ = _data_->self->priv->_controller;
		_data_->_tmp2_ = application_controller_get_plugins (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = application_plugin_manager_get_globals (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = application_plugin_manager_plugin_globals_get_folders (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = application_folder_store_factory_get_folder_for_variant (_data_->_tmp7_, _data_->id);
		_data_->folder = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->folder;
		if (_data_->_tmp9_ != NULL) {
			_data_->_tmp10_ = _data_->main;
			_data_->_tmp11_ = _data_->folder;
			_data_->_state_ = 2;
			application_main_window_select_folder (_data_->_tmp10_, _data_->_tmp11_, TRUE, FALSE, application_client_show_folder_ready, _data_);
			return FALSE;
			_state_2:
			application_main_window_select_folder_finish (_data_->_tmp10_, _data_->_res_);
		}
		_g_object_unref0 (_data_->folder);
	}
	_g_object_unref0 (_data_->main);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_client_show_inspector_data_free (gpointer _data)
{
	ApplicationClientShowInspectorData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientShowInspectorData, _data_);
}

void
application_client_show_inspector (ApplicationClient* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	ApplicationClientShowInspectorData* _data_;
	ApplicationClient* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_data_ = g_slice_new0 (ApplicationClientShowInspectorData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_show_inspector_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	application_client_show_inspector_co (_data_);
}

void
application_client_show_inspector_finish (ApplicationClient* self,
                                          GAsyncResult* _res_)
{
	ApplicationClientShowInspectorData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_client_show_inspector_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ApplicationClientShowInspectorData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_show_inspector_co (_data_);
}

static void
___lambda177_ (ApplicationClient* self)
{
	_g_object_unref0 (self->priv->inspector);
	self->priv->inspector = NULL;
}

static void
____lambda177__gtk_widget_destroy (GtkWidget* _sender,
                                   gpointer self)
{
	___lambda177_ ((ApplicationClient*) self);
}

static gboolean
application_client_show_inspector_co (ApplicationClientShowInspectorData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_client_present (_data_->self, application_client_show_inspector_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = application_client_present_finish (_data_->self, _data_->_res_);
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->_tmp2_ = _data_->self->priv->inspector;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp3_ = components_inspector_new (_data_->self);
		g_object_ref_sink (_data_->_tmp3_);
		_g_object_unref0 (_data_->self->priv->inspector);
		_data_->self->priv->inspector = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->self->priv->inspector;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, gtk_widget_get_type (), GtkWidget), "destroy", (GCallback) ____lambda177__gtk_widget_destroy, _data_->self, 0);
		_data_->_tmp5_ = gtk_window_group_new ();
		_data_->group = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->group;
		_data_->_tmp7_ = _data_->self->priv->inspector;
		gtk_window_group_add_window (_data_->_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, gtk_window_get_type (), GtkWindow));
		_data_->_tmp8_ = _data_->self->priv->inspector;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (_data_->group);
	} else {
		_data_->_tmp9_ = _data_->self->priv->inspector;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, gtk_window_get_type (), GtkWindow));
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_client_show_preferences_data_free (gpointer _data)
{
	ApplicationClientShowPreferencesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientShowPreferencesData, _data_);
}

void
application_client_show_preferences (ApplicationClient* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ApplicationClientShowPreferencesData* _data_;
	ApplicationClient* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_data_ = g_slice_new0 (ApplicationClientShowPreferencesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_show_preferences_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	application_client_show_preferences_co (_data_);
}

void
application_client_show_preferences_finish (ApplicationClient* self,
                                            GAsyncResult* _res_)
{
	ApplicationClientShowPreferencesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_client_show_preferences_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ApplicationClientShowPreferencesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_show_preferences_co (_data_);
}

static gboolean
application_client_show_preferences_co (ApplicationClientShowPreferencesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_client_present (_data_->self, application_client_show_preferences_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = application_client_present_finish (_data_->self, _data_->_res_);
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->_tmp2_ = application_client_get_active_main_window (_data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->self->priv->_controller;
	_data_->_tmp5_ = application_controller_get_plugins (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = components_preferences_window_new (_data_->_tmp3_, _data_->_tmp6_);
	g_object_ref_sink (_data_->_tmp7_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_g_object_unref0 (_data_->_tmp3_);
	_data_->prefs = _data_->_tmp8_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_data_->prefs, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_data_->prefs);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_client_new_composer_data_free (gpointer _data)
{
	ApplicationClientNewComposerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->to);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientNewComposerData, _data_);
}

void
application_client_new_composer (ApplicationClient* self,
                                 GearyRFC822MailboxAddress* to,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	ApplicationClientNewComposerData* _data_;
	ApplicationClient* _tmp0_;
	GearyRFC822MailboxAddress* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail ((to == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (to, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS));
	_data_ = g_slice_new0 (ApplicationClientNewComposerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_new_composer_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (to);
	_g_object_unref0 (_data_->to);
	_data_->to = _tmp1_;
	application_client_new_composer_co (_data_);
}

void
application_client_new_composer_finish (ApplicationClient* self,
                                        GAsyncResult* _res_)
{
	ApplicationClientNewComposerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_client_new_composer_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	ApplicationClientNewComposerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_new_composer_co (_data_);
}

static gboolean
application_client_new_composer_co (ApplicationClientNewComposerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_client_present (_data_->self, application_client_new_composer_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = application_client_present_finish (_data_->self, _data_->_res_);
	_data_->main = _data_->_tmp0_;
	_data_->account = NULL;
	_data_->_tmp1_ = _data_->main;
	_data_->_tmp2_ = application_main_window_get_selected_account (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->self->priv->_controller;
		_data_->_tmp5_ = _data_->main;
		_data_->_tmp6_ = application_main_window_get_selected_account (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = geary_account_get_information (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = application_account_interface_get_context_for_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), _data_->_tmp9_);
		_g_object_unref0 (_data_->account);
		_data_->account = _data_->_tmp10_;
	}
	_data_->_tmp11_ = _data_->account;
	if (_data_->_tmp11_ == NULL) {
		_data_->_tmp12_ = _data_->self->priv->_controller;
		_data_->_tmp13_ = application_account_interface_get_account_contexts (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface));
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = geary_collection_first (APPLICATION_TYPE_ACCOUNT_CONTEXT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp14_);
		_g_object_unref0 (_data_->account);
		_data_->account = (ApplicationAccountContext*) _data_->_tmp15_;
		_g_object_unref0 (_data_->_tmp14_);
	}
	_data_->_tmp16_ = _data_->account;
	if (_data_->_tmp16_ != NULL) {
		_data_->_tmp17_ = _data_->self->priv->_controller;
		_data_->_tmp18_ = _data_->account;
		_data_->_state_ = 2;
		application_controller_compose_blank (_data_->_tmp17_, _data_->_tmp18_, _data_->to, application_client_new_composer_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp19_ = application_controller_compose_blank_finish (_data_->_tmp17_, _data_->_res_);
		_data_->composer = _data_->_tmp19_;
		_data_->_tmp20_ = _data_->self->priv->_controller;
		_data_->_tmp21_ = _data_->composer;
		application_controller_present_composer (_data_->_tmp20_, _data_->_tmp21_);
		_g_object_unref0 (_data_->composer);
	}
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->main);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_client_new_composer_mailto_data_free (gpointer _data)
{
	ApplicationClientNewComposerMailtoData* _data_;
	_data_ = _data;
	_g_free0 (_data_->mailto);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientNewComposerMailtoData, _data_);
}

void
application_client_new_composer_mailto (ApplicationClient* self,
                                        const gchar* mailto,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ApplicationClientNewComposerMailtoData* _data_;
	ApplicationClient* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_data_ = g_slice_new0 (ApplicationClientNewComposerMailtoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_new_composer_mailto_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (mailto);
	_g_free0 (_data_->mailto);
	_data_->mailto = _tmp1_;
	application_client_new_composer_mailto_co (_data_);
}

void
application_client_new_composer_mailto_finish (ApplicationClient* self,
                                               GAsyncResult* _res_)
{
	ApplicationClientNewComposerMailtoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_client_new_composer_mailto_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	ApplicationClientNewComposerMailtoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_new_composer_mailto_co (_data_);
}

static gboolean
application_client_new_composer_mailto_co (ApplicationClientNewComposerMailtoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_client_present (_data_->self, application_client_new_composer_mailto_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = application_client_present_finish (_data_->self, _data_->_res_);
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->_tmp2_ = _data_->self->priv->_controller;
	_data_->_state_ = 2;
	application_controller_compose_mailto (_data_->_tmp2_, _data_->mailto, application_client_new_composer_mailto_ready, _data_);
	return FALSE;
	_state_2:
	application_controller_compose_mailto_finish (_data_->_tmp2_, _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_client_new_window_data_free (gpointer _data)
{
	ApplicationClientNewWindowData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->select_folder);
	_g_object_unref0 (_data_->select_conversations);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientNewWindowData, _data_);
}

void
application_client_new_window (ApplicationClient* self,
                               GearyFolder* select_folder,
                               GeeCollection* select_conversations,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	ApplicationClientNewWindowData* _data_;
	ApplicationClient* _tmp0_;
	GearyFolder* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail ((select_folder == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (select_folder, GEARY_TYPE_FOLDER));
	g_return_if_fail ((select_conversations == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (select_conversations, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (ApplicationClientNewWindowData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_new_window_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (select_folder);
	_g_object_unref0 (_data_->select_folder);
	_data_->select_folder = _tmp1_;
	_tmp2_ = _g_object_ref0 (select_conversations);
	_g_object_unref0 (_data_->select_conversations);
	_data_->select_conversations = _tmp2_;
	application_client_new_window_co (_data_);
}

void
application_client_new_window_finish (ApplicationClient* self,
                                      GAsyncResult* _res_)
{
	ApplicationClientNewWindowData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_client_new_window_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	ApplicationClientNewWindowData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_new_window_co (_data_);
}

static gboolean
application_client_new_window_co (ApplicationClientNewWindowData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_client_create_controller (_data_->self, application_client_new_window_ready, _data_);
	return FALSE;
	_state_1:
	application_client_create_controller_finish (_data_->self, _data_->_res_);
	if (_data_->select_folder != NULL) {
		_data_->_tmp1_ = _data_->select_conversations != NULL;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = gee_collection_get_is_empty (_data_->select_conversations);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp0_ = !_data_->_tmp3_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	_data_->do_select = _data_->_tmp0_;
	_data_->_tmp4_ = application_client_new_main_window (_data_->self, !_data_->do_select);
	_data_->main = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->main;
	gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, gtk_window_get_type (), GtkWindow));
	if (_data_->do_select) {
		if (_data_->select_conversations == NULL) {
			_data_->_tmp6_ = TRUE;
		} else {
			_data_->_tmp7_ = gee_collection_get_is_empty (_data_->select_conversations);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp6_ = _data_->_tmp8_;
		}
		if (_data_->_tmp6_) {
			_data_->_tmp9_ = _data_->main;
			application_main_window_select_folder (_data_->_tmp9_, _data_->select_folder, TRUE, FALSE, NULL, NULL);
		} else {
			_data_->_tmp10_ = _data_->main;
			application_main_window_show_conversations (_data_->_tmp10_, _data_->select_folder, _data_->select_conversations, TRUE, NULL, NULL);
		}
	}
	_g_object_unref0 (_data_->main);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/** Returns the application's base home configuration directory. */
GFile*
application_client_get_home_config_directory (ApplicationClient* self)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = application_client_get_geary_home_dir_name (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_child (_tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}

/** Returns the application's base home cache directory. */
GFile*
application_client_get_home_cache_directory (ApplicationClient* self)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = application_client_get_geary_home_dir_name (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_child (_tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}

/** Returns the application's base home data directory. */
GFile*
application_client_get_home_data_directory (ApplicationClient* self)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = application_client_get_geary_home_dir_name (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_child (_tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}

/** Returns the application's base static resources directory. */
GFile*
application_client_get_resource_directory (ApplicationClient* self)
{
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GFile* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp1_ = application_client_get_is_installed (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp3_ = self->priv->_install_prefix;
		_tmp4_ = g_file_get_child (_tmp3_, "share");
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_child (_tmp5_, "geary");
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	} else {
		GFile* _tmp7_;
		_tmp7_ = g_file_new_for_path (APPLICATION_CLIENT_SOURCE_ROOT_DIR);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp7_;
	}
	result = _tmp0_;
	return result;
}

/** Returns the location of the application's desktop files. */
GFile*
application_client_get_desktop_directory (ApplicationClient* self)
{
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GFile* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp1_ = application_client_get_is_installed (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp3_ = self->priv->_install_prefix;
		_tmp4_ = g_file_get_child (_tmp3_, "share");
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_child (_tmp5_, "applications");
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	} else {
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		_tmp7_ = g_file_new_for_path (APPLICATION_CLIENT_BUILD_ROOT_DIR);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_file_get_child (_tmp8_, "desktop");
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns the directory containing the application's WebExtension libs.
     *
     * When running from the installation prefix, this will be based
     * on the Meson `libdir` option, and can be set by invoking `meson
     * configure` as appropriate.
     */
GFile*
application_client_get_web_extensions_dir (ApplicationClient* self)
{
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GFile* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp1_ = application_client_get_is_installed (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GFile* _tmp3_;
		_tmp3_ = g_file_new_for_path (_WEB_EXTENSIONS_DIR);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp4_ = g_file_new_for_path (APPLICATION_CLIENT_BUILD_ROOT_DIR);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_child (_tmp5_, "src");
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns the directory containing the application's plugins.
     *
     * When running from the installation prefix, this will be based
     * on the Meson `libdir` option, and can be set by invoking `meson
     * configure` as appropriate.
     */
GFile*
application_client_get_app_plugins_dir (ApplicationClient* self)
{
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GFile* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp1_ = application_client_get_is_installed (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GFile* _tmp3_;
		_tmp3_ = g_file_new_for_path (_PLUGINS_DIR);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		_tmp4_ = g_file_new_for_path (APPLICATION_CLIENT_BUILD_ROOT_DIR);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_child (_tmp5_, "src");
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_get_child (_tmp7_, "client");
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_get_child (_tmp9_, "plugin");
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp5_);
	}
	result = _tmp0_;
	return result;
}

static void
application_client_show_uri_data_free (gpointer _data)
{
	ApplicationClientShowUriData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientShowUriData, _data_);
}

void
application_client_show_uri (ApplicationClient* self,
                             const gchar* uri,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	ApplicationClientShowUriData* _data_;
	ApplicationClient* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (ApplicationClientShowUriData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_show_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	application_client_show_uri_co (_data_);
}

void
application_client_show_uri_finish (ApplicationClient* self,
                                    GAsyncResult* _res_)
{
	ApplicationClientShowUriData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/** Displays a URI on the current active window, if any. */
static void
application_client_show_uri_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	ApplicationClientShowUriData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_show_uri_co (_data_);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
application_client_show_uri_co (ApplicationClientShowUriData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_client_create_controller (_data_->self, application_client_show_uri_ready, _data_);
	return FALSE;
	_state_1:
	application_client_create_controller_finish (_data_->self, _data_->_res_);
	_data_->_tmp0_ = g_utf8_strdown (_data_->uri, (gssize) -1);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_str_has_prefix (_data_->_tmp1_, APPLICATION_CLIENT_MAILTO_URI_SCHEME_PREFIX);
	_g_free0 (_data_->_tmp1_);
	if (_data_->_tmp2_) {
		_data_->_state_ = 2;
		application_client_new_composer_mailto (_data_->self, _data_->uri, application_client_show_uri_ready, _data_);
		return FALSE;
		_state_2:
		application_client_new_composer_mailto_finish (_data_->self, _data_->_res_);
	} else {
		_data_->_tmp3_ = g_strdup (_data_->uri);
		_data_->uri_ = _data_->_tmp3_;
		if (!string_contains (_data_->uri, ":")) {
			_data_->_tmp4_ = g_strconcat ("http://", _data_->uri, NULL);
			_g_free0 (_data_->uri_);
			_data_->uri_ = _data_->_tmp4_;
		}
		{
			_data_->_tmp5_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_application_get_type (), GtkApplication));
			_data_->_tmp6_ = _data_->uri_;
			gtk_show_uri_on_window (_data_->_tmp5_, _data_->_tmp6_, (guint32) GDK_CURRENT_TIME, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp7_ = _data_->self->priv->_controller;
			_data_->_tmp8_ = _data_->err;
			_data_->_tmp9_ = geary_problem_report_new (_data_->_tmp8_);
			_data_->_tmp10_ = _data_->_tmp9_;
			composer_application_interface_report_problem (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterface), _data_->_tmp10_);
			_g_object_unref0 (_data_->_tmp10_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->uri_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->uri_);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Closes the controller and all open windows, exiting if possible.
     *
     * Any open composers with unsaved or un-savable changes will be
     * prompted about and if cancelled, will cancel shut-down here.
     */
void
application_client_quit (ApplicationClient* self)
{
	gboolean _tmp0_ = FALSE;
	ApplicationController* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_tmp1_ = self->priv->_controller;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ApplicationController* _tmp2_;
		_tmp2_ = self->priv->_controller;
		_tmp0_ = application_controller_check_open_composers (_tmp2_);
	}
	if (_tmp0_) {
		application_client_set_last_active_main_window (self, NULL);
		g_application_quit (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	}
}

/**
     * Returns a set of paths of possible config locations.
     *
     * This is useful only for migrating configuration from
     * non-Flatpak to Flatpak or release-builds to non-release builds.
     */
static void
_vala_array_add3 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GFile**
application_client_get_config_search_path (ApplicationClient* self,
                                           gint* result_length1)
{
	GFile** paths = NULL;
	GFile** _tmp0_;
	gint paths_length1;
	gint _paths_size_;
	GFile* home = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile** _tmp15_;
	gint _tmp15__length1;
	GFile** result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	paths = _tmp0_;
	paths_length1 = 0;
	_paths_size_ = paths_length1;
	_tmp1_ = g_get_home_dir ();
	_tmp2_ = g_file_new_for_path (_tmp1_);
	home = _tmp2_;
	_tmp3_ = g_file_get_child (home, ".config");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_child (_tmp4_, "geary");
	_vala_array_add3 (&paths, &paths_length1, &_paths_size_, _tmp5_);
	_g_object_unref0 (_tmp4_);
	_tmp6_ = g_file_get_child (home, ".var");
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_get_child (_tmp7_, "app");
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_get_child (_tmp9_, "org.gnome.Geary");
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_get_child (_tmp11_, "config");
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_get_child (_tmp13_, "geary");
	_vala_array_add4 (&paths, &paths_length1, &_paths_size_, _tmp14_);
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp7_);
	_tmp15_ = paths;
	_tmp15__length1 = paths_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_object_unref0 (home);
	return result;
}

/**
     * Displays an error notification.
     *
     * Use _very_ sparingly.
     */
void
application_client_send_error_notification (ApplicationClient* self,
                                            const gchar* summary,
                                            const gchar* body)
{
	GNotification* _tmp0_;
	GNotification* _error_ = NULL;
	GNotification* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GThemedIcon* _tmp4_;
	GThemedIcon* _tmp5_;
	GNotification* _tmp6_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (summary != NULL);
	g_return_if_fail (body != NULL);
	_tmp0_ = self->priv->error_notification;
	if (_tmp0_ != NULL) {
		application_client_clear_error_notification (self);
	}
	_tmp1_ = g_notification_new (summary);
	_error_ = _tmp1_;
	g_notification_set_body (_error_, body);
	_tmp2_ = g_strdup_printf ("%s-symbolic", APPLICATION_CLIENT_APP_ID);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GThemedIcon*) g_themed_icon_new (_tmp3_);
	_tmp5_ = _tmp4_;
	g_notification_set_icon (_error_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_icon_get_type (), GIcon));
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	g_application_send_notification (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication), APPLICATION_CLIENT_ERROR_NOTIFICATION_ID, _error_);
	_tmp6_ = _g_object_ref0 (_error_);
	_g_object_unref0 (self->priv->error_notification);
	self->priv->error_notification = _tmp6_;
	_g_object_unref0 (_error_);
}

void
application_client_clear_error_notification (ApplicationClient* self)
{
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_g_object_unref0 (self->priv->error_notification);
	self->priv->error_notification = NULL;
	g_application_withdraw_notification (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication), APPLICATION_CLIENT_ERROR_NOTIFICATION_ID);
}

static void
application_client_present_data_free (gpointer _data)
{
	ApplicationClientPresentData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientPresentData, _data_);
}

static void
application_client_present (ApplicationClient* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	ApplicationClientPresentData* _data_;
	ApplicationClient* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_data_ = g_slice_new0 (ApplicationClientPresentData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_present_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	application_client_present_co (_data_);
}

static ApplicationMainWindow*
application_client_present_finish (ApplicationClient* self,
                                   GAsyncResult* _res_)
{
	ApplicationMainWindow* result;
	ApplicationClientPresentData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_client_present_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	ApplicationClientPresentData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_present_co (_data_);
}

static gboolean
application_client_present_co (ApplicationClientPresentData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	application_client_create_controller (_data_->self, application_client_present_ready, _data_);
	return FALSE;
	_state_1:
	application_client_create_controller_finish (_data_->self, _data_->_res_);
	_data_->_tmp0_ = application_client_get_active_main_window (_data_->self);
	_data_->main = _data_->_tmp0_;
	gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_data_->main, gtk_window_get_type (), GtkWindow));
	_data_->result = _data_->main;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
_application_client_on_main_window_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                       GdkEventFocus* event,
                                                                       gpointer self)
{
	gboolean result;
	result = application_client_on_main_window_focus_in ((ApplicationClient*) self, _sender, event);
	return result;
}

static void
_application_client_on_folders_first_available_geary_account_folders_available_unavailable (GearyAccount* _sender,
                                                                                            GeeBidirSortedSet* available,
                                                                                            GeeBidirSortedSet* unavailable,
                                                                                            gpointer self)
{
	application_client_on_folders_first_available ((ApplicationClient*) self, _sender, available, unavailable);
}

static ApplicationMainWindow*
application_client_new_main_window (ApplicationClient* self,
                                    gboolean select_first_inbox)
{
	ApplicationMainWindow* window = NULL;
	ApplicationMainWindow* _tmp0_;
	ApplicationController* _tmp1_;
	ApplicationMainWindow* _tmp2_;
	ApplicationMainWindow* _tmp3_;
	GError* _inner_error0_ = NULL;
	ApplicationMainWindow* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	_tmp0_ = application_main_window_new (self);
	g_object_ref_sink (_tmp0_);
	window = _tmp0_;
	_tmp1_ = self->priv->_controller;
	_tmp2_ = window;
	application_controller_register_window (_tmp1_, _tmp2_);
	_tmp3_ = window;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), "focus-in-event", (GCallback) _application_client_on_main_window_focus_in_gtk_widget_focus_in_event, self, 0);
	if (select_first_inbox) {
		ApplicationMainWindow* _tmp4_;
		_tmp4_ = window;
		if (!application_main_window_select_first_inbox (_tmp4_, TRUE)) {
			{
				GeeCollection* _tmp5_ = NULL;
				GearyEngine* _tmp6_;
				GeeCollection* _tmp7_;
				GearyAccount* first = NULL;
				gpointer _tmp8_;
				GearyAccount* _tmp9_;
				_tmp6_ = self->priv->_engine;
				_tmp7_ = geary_engine_get_accounts (_tmp6_, &_inner_error0_);
				_tmp5_ = _tmp7_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp8_ = geary_collection_first (GEARY_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp5_);
				first = (GearyAccount*) _tmp8_;
				_tmp9_ = first;
				if (_tmp9_ != NULL) {
					GearyAccount* _tmp10_;
					_tmp10_ = first;
					g_signal_connect_object (_tmp10_, "folders-available-unavailable", (GCallback) _application_client_on_folders_first_available_geary_account_folders_available_unavailable, self, G_CONNECT_AFTER);
				}
				_g_object_unref0 (first);
				_g_object_unref0 (_tmp5_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
				g_debug ("application-client.vala:959: Error getting Inbox for first account");
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (window);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	result = window;
	return result;
}

static void
application_client_create_controller_data_free (gpointer _data)
{
	ApplicationClientCreateControllerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientCreateControllerData, _data_);
}

static void
application_client_create_controller (ApplicationClient* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	ApplicationClientCreateControllerData* _data_;
	ApplicationClient* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_data_ = g_slice_new0 (ApplicationClientCreateControllerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_create_controller_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	application_client_create_controller_co (_data_);
}

static void
application_client_create_controller_finish (ApplicationClient* self,
                                             GAsyncResult* _res_)
{
	ApplicationClientCreateControllerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_client_create_controller_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	ApplicationClientCreateControllerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_create_controller_co (_data_);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static gboolean
application_client_create_controller_co (ApplicationClientCreateControllerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->first_run = FALSE;
	_data_->open_failed = FALSE;
	_data_->mutex_token = GEARY_NONBLOCKING_MUTEX_INVALID_TOKEN;
	{
		_data_->_tmp1_ = _data_->self->priv->controller_mutex;
		_data_->_state_ = 1;
		geary_nonblocking_mutex_claim_async (_data_->_tmp1_, NULL, application_client_create_controller_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = geary_nonblocking_mutex_claim_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->mutex_token = _data_->_tmp0_;
		_data_->_tmp2_ = _data_->self->priv->_controller;
		if (_data_->_tmp2_ == NULL) {
			if (g_strcmp0 (_REVNO, "") != 0) {
				_data_->_tmp4_ = g_strdup_printf (" (%s)", _REVNO);
				_g_free0 (_data_->_tmp3_);
				_data_->_tmp3_ = _data_->_tmp4_;
			} else {
				_data_->_tmp5_ = g_strdup ("");
				_g_free0 (_data_->_tmp3_);
				_data_->_tmp3_ = _data_->_tmp5_;
			}
			_data_->_tmp6_ = _data_->self->priv->exec_dir;
			_data_->_tmp7_ = g_file_get_path (_data_->_tmp6_);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp9_ = application_client_get_is_installed (_data_->self);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = bool_to_string (_data_->_tmp10_);
			_data_->_tmp12_ = _data_->_tmp11_;
			g_message ("application-client.vala:974: %s %s%s prefix=%s exec_dir=%s is_installe" \
"d=%s", APPLICATION_CLIENT_NAME, APPLICATION_CLIENT_VERSION, _data_->_tmp3_, APPLICATION_CLIENT_INSTALL_PREFIX, _data_->_tmp8_, _data_->_tmp12_);
			_g_free0 (_data_->_tmp12_);
			_g_free0 (_data_->_tmp8_);
			_data_->_tmp14_ = _data_->self->priv->controller_cancellable;
			_data_->_state_ = 2;
			application_controller_new (_data_->self, _data_->_tmp14_, application_client_create_controller_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp15_ = application_controller_new_finish (_data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp13_ = _data_->_tmp15_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->_tmp3_);
				goto __catch0_g_error;
			}
			application_client_set_controller (_data_->self, _data_->_tmp13_);
			_data_->_tmp16_ = _data_->self->priv->_engine;
			_data_->_tmp17_ = geary_engine_get_has_accounts (_data_->_tmp16_);
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->first_run = !_data_->_tmp18_;
			_g_object_unref0 (_data_->_tmp13_);
			_g_free0 (_data_->_tmp3_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->open_failed = TRUE;
		_data_->_tmp19_ = _data_->err;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning ("application-client.vala:991: Error creating controller: %s", _data_->_tmp20_);
		_data_->_tmp21_ = _data_->err;
		_data_->_tmp22_ = geary_problem_report_new (_data_->_tmp21_);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp24_ = dialogs_problem_details_dialog_new (NULL, _data_->self, _data_->_tmp23_);
		g_object_ref_sink (_data_->_tmp24_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_g_object_unref0 (_data_->_tmp23_);
		_data_->dialog = _data_->_tmp25_;
		_data_->_tmp26_ = _data_->dialog;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp26_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (_data_->dialog);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->mutex_token != GEARY_NONBLOCKING_MUTEX_INVALID_TOKEN) {
		{
			_data_->_tmp27_ = _data_->self->priv->controller_mutex;
			geary_nonblocking_mutex_release (_data_->_tmp27_, &_data_->mutex_token, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp28_ = _data_->_error_;
			_data_->_tmp29_ = _data_->_tmp28_->message;
			g_warning ("application-client.vala:1004: Failed to release controller mutex: %s", _data_->_tmp29_);
			_g_error_free0 (_data_->_error_);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->open_failed) {
		application_client_quit (_data_->self);
	}
	if (_data_->first_run) {
		_data_->_state_ = 3;
		application_client_show_accounts (_data_->self, application_client_create_controller_ready, _data_);
		return FALSE;
		_state_3:
		application_client_show_accounts_finish (_data_->self, _data_->_res_);
		_data_->_tmp30_ = _data_->self->priv->_engine;
		_data_->_tmp31_ = geary_engine_get_has_accounts (_data_->_tmp30_);
		_data_->_tmp32_ = _data_->_tmp31_;
		if (!_data_->_tmp32_) {
			application_client_quit (_data_->self);
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_client_destroy_controller_data_free (gpointer _data)
{
	ApplicationClientDestroyControllerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationClientDestroyControllerData, _data_);
}

static void
application_client_destroy_controller (ApplicationClient* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	ApplicationClientDestroyControllerData* _data_;
	ApplicationClient* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_data_ = g_slice_new0 (ApplicationClientDestroyControllerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_client_destroy_controller_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	application_client_destroy_controller_co (_data_);
}

static void
application_client_destroy_controller_finish (ApplicationClient* self,
                                              GAsyncResult* _res_)
{
	ApplicationClientDestroyControllerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_client_destroy_controller_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	ApplicationClientDestroyControllerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_client_destroy_controller_co (_data_);
}

static gboolean
application_client_destroy_controller_co (ApplicationClientDestroyControllerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->controller_mutex;
		_data_->_state_ = 1;
		geary_nonblocking_mutex_claim_async (_data_->_tmp0_, NULL, application_client_destroy_controller_ready, _data_);
		return FALSE;
		_state_1:
		_data_->mutex_token = geary_nonblocking_mutex_claim_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->self->priv->_controller;
		if (_data_->_tmp1_ != NULL) {
			_data_->_tmp2_ = _data_->self->priv->_controller;
			_data_->_state_ = 2;
			application_controller_close (_data_->_tmp2_, application_client_destroy_controller_ready, _data_);
			return FALSE;
			_state_2:
			application_controller_close_finish (_data_->_tmp2_, _data_->_res_);
			application_client_set_controller (_data_->self, NULL);
		}
		_data_->_tmp3_ = _data_->self->priv->controller_mutex;
		geary_nonblocking_mutex_release (_data_->_tmp3_, &_data_->mutex_token, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("application-client.vala:1033: Error destroying controller: %s", _data_->_tmp5_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp6_ = _data_->self->priv->_engine;
		geary_engine_close (_data_->_tmp6_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->_error_;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		g_warning ("application-client.vala:1039: Error shutting down the engine: %s", _data_->_tmp8_);
		_g_error_free0 (_data_->_error_);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gint
application_client_handle_general_options (ApplicationClient* self,
                                           GApplicationCommandLine* command_line)
{
	GVariantDict* options = NULL;
	GVariantDict* _tmp0_;
	GVariantDict* _tmp1_;
	GVariantDict* _tmp2_;
	gboolean activated = FALSE;
	GVariantDict* _tmp3_;
	GVariantDict* _tmp4_;
	GVariantDict* _tmp5_;
	GVariantDict* _tmp6_;
	GVariantDict* _tmp7_;
	GVariantDict* _tmp8_;
	GVariantDict* _tmp9_;
	GVariantDict* _tmp10_;
	ApplicationConfiguration* _tmp31_;
	GVariantDict* _tmp32_;
	ApplicationConfiguration* _tmp33_;
	GVariantDict* _tmp34_;
	ApplicationConfiguration* _tmp35_;
	GVariantDict* _tmp36_;
	gint result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (command_line, g_application_command_line_get_type ()), 0);
	_tmp0_ = g_application_command_line_get_options_dict (command_line);
	_tmp1_ = _g_variant_dict_ref0 (_tmp0_);
	options = _tmp1_;
	_tmp2_ = options;
	if (g_variant_dict_contains (_tmp2_, APPLICATION_CLIENT_OPTION_QUIT)) {
		application_client_quit (self);
		result = 0;
		_g_variant_dict_unref0 (options);
		return result;
	}
	activated = FALSE;
	geary_logging_suppress_domain ("GdkPixbuf");
	geary_logging_suppress_domain ("GLib-Net");
	_tmp3_ = options;
	if (!g_variant_dict_contains (_tmp3_, APPLICATION_CLIENT_OPTION_LOG_CONVERSATIONS)) {
		geary_logging_suppress_domain (GEARY_APP_CONVERSATION_MONITOR_LOGGING_DOMAIN);
	}
	_tmp4_ = options;
	if (!g_variant_dict_contains (_tmp4_, APPLICATION_CLIENT_OPTION_LOG_DESERIALIZER)) {
		geary_logging_suppress_domain (GEARY_IMAP_CLIENT_SERVICE_DESERIALISATION_LOGGING_DOMAIN);
	}
	_tmp5_ = options;
	if (!g_variant_dict_contains (_tmp5_, APPLICATION_CLIENT_OPTION_LOG_IMAP)) {
		geary_logging_suppress_domain (GEARY_IMAP_CLIENT_SERVICE_PROTOCOL_LOGGING_DOMAIN);
	}
	_tmp6_ = options;
	if (!g_variant_dict_contains (_tmp6_, APPLICATION_CLIENT_OPTION_LOG_REPLAY_QUEUE)) {
		geary_logging_suppress_domain (GEARY_IMAP_CLIENT_SERVICE_REPLAY_QUEUE_LOGGING_DOMAIN);
	}
	_tmp7_ = options;
	if (!g_variant_dict_contains (_tmp7_, APPLICATION_CLIENT_OPTION_LOG_SMTP)) {
		geary_logging_suppress_domain (GEARY_SMTP_CLIENT_SERVICE_PROTOCOL_LOGGING_DOMAIN);
	}
	_tmp8_ = options;
	if (g_variant_dict_contains (_tmp8_, APPLICATION_CLIENT_OPTION_LOG_SQL)) {
		geary_db_context_enable_sql_logging = TRUE;
	}
	_tmp9_ = options;
	if (g_variant_dict_contains (_tmp9_, APPLICATION_CLIENT_OPTION_NEW_WINDOW)) {
		g_action_group_activate_action (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_group_get_type (), GActionGroup), ACTION_APPLICATION_NEW_WINDOW, NULL);
		activated = TRUE;
	}
	_tmp10_ = options;
	if (g_variant_dict_contains (_tmp10_, G_OPTION_REMAINING)) {
		gchar** args = NULL;
		GVariantDict* _tmp11_;
		const GVariantType* _tmp12_;
		GVariant* _tmp13_;
		GVariant* _tmp14_;
		gsize _tmp15_ = 0;
		const gchar** _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar** _tmp18_;
		gint _tmp18__length1;
		gint args_length1;
		gint _args_size_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		_tmp11_ = options;
		_tmp12_ = G_VARIANT_TYPE_STRING_ARRAY;
		_tmp13_ = g_variant_dict_lookup_value (_tmp11_, G_OPTION_REMAINING, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp16_ = g_variant_get_strv (_tmp14_, &_tmp15_);
		_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup1 (_tmp16_, _tmp15_) : _tmp16_;
		_tmp17__length1 = _tmp15_;
		_tmp16_ = (g_free (_tmp16_), NULL);
		_tmp18_ = _tmp17_;
		_tmp18__length1 = _tmp17__length1;
		_g_variant_unref0 (_tmp14_);
		args = _tmp18_;
		args_length1 = _tmp18__length1;
		_args_size_ = args_length1;
		_tmp19_ = args;
		_tmp19__length1 = args_length1;
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
			arg_collection = _tmp19_;
			arg_collection_length1 = _tmp19__length1;
			for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
				gchar* _tmp20_;
				gchar* arg = NULL;
				_tmp20_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp20_;
				{
					const gchar* _tmp21_;
					_tmp21_ = arg;
					if (g_strcmp0 (_tmp21_, APPLICATION_CLIENT_MAILTO_URI_SCHEME_PREFIX) == 0) {
						g_action_group_activate_action (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_group_get_type (), GActionGroup), ACTION_APPLICATION_COMPOSE, NULL);
						activated = TRUE;
					} else {
						const gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gboolean _tmp25_;
						_tmp22_ = arg;
						_tmp23_ = g_utf8_strdown (_tmp22_, (gssize) -1);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_str_has_prefix (_tmp24_, APPLICATION_CLIENT_MAILTO_URI_SCHEME_PREFIX);
						_g_free0 (_tmp24_);
						if (_tmp25_) {
							const gchar* _tmp26_;
							GVariant* _tmp27_;
							GVariant* _tmp28_;
							_tmp26_ = arg;
							_tmp27_ = g_variant_new_string (_tmp26_);
							g_variant_ref_sink (_tmp27_);
							_tmp28_ = _tmp27_;
							g_action_group_activate_action (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_group_get_type (), GActionGroup), ACTION_APPLICATION_MAILTO, _tmp28_);
							_g_variant_unref0 (_tmp28_);
							activated = TRUE;
						} else {
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							_tmp29_ = self->priv->binary;
							g_application_command_line_printerr (command_line, "%s: ", _tmp29_);
							_tmp30_ = arg;
							g_application_command_line_printerr (command_line, _ ("Unrecognised program argument: “%s”"), _tmp30_);
							g_application_command_line_printerr (command_line, "\n");
							result = 1;
							_g_free0 (arg);
							args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
							_g_variant_dict_unref0 (options);
							return result;
						}
					}
					_g_free0 (arg);
				}
			}
		}
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp31_ = self->priv->_config;
	_tmp32_ = options;
	application_configuration_set_enable_debug (_tmp31_, g_variant_dict_contains (_tmp32_, APPLICATION_CLIENT_OPTION_DEBUG));
	_tmp33_ = self->priv->_config;
	_tmp34_ = options;
	application_configuration_set_enable_inspector (_tmp33_, g_variant_dict_contains (_tmp34_, APPLICATION_CLIENT_OPTION_INSPECTOR));
	_tmp35_ = self->priv->_config;
	_tmp36_ = options;
	application_configuration_set_revoke_certs (_tmp35_, g_variant_dict_contains (_tmp36_, APPLICATION_CLIENT_OPTION_REVOKE_CERTS));
	if (!activated) {
		g_application_activate (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
	}
	result = -1;
	_g_variant_dict_unref0 (options);
	return result;
}

static void
application_client_add_app_accelerators (ApplicationClient* self,
                                         const gchar* action,
                                         gchar** accelerators,
                                         gint accelerators_length1,
                                         GVariant* param)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (action != NULL);
	_tmp0_ = g_strconcat ("app.", action, NULL);
	_tmp1_ = _tmp0_;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp1_, accelerators);
	_g_free0 (_tmp1_);
}

static void
application_client_update_single_key_shortcuts (ApplicationClient* self)
{
	ApplicationConfiguration* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	_tmp0_ = self->priv->_config;
	_tmp1_ = application_configuration_get_single_key_shortcuts (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GdkDisplay* _tmp3_;
		GdkScreen* _tmp4_;
		GtkCssProvider* _tmp5_;
		_tmp3_ = gdk_display_get_default ();
		_tmp4_ = gdk_display_get_default_screen (_tmp3_);
		_tmp5_ = self->priv->single_key_shortcuts;
		gtk_style_context_add_provider_for_screen (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_style_provider_get_type (), GtkStyleProvider), (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	} else {
		GdkDisplay* _tmp6_;
		GdkScreen* _tmp7_;
		GtkCssProvider* _tmp8_;
		_tmp6_ = gdk_display_get_default ();
		_tmp7_ = gdk_display_get_default_screen (_tmp6_);
		_tmp8_ = self->priv->single_key_shortcuts;
		gtk_style_context_remove_provider_for_screen (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_style_provider_get_type (), GtkStyleProvider));
	}
}

static void
_application_client_on_css_parse_error_gtk_css_provider_parsing_error (GtkCssProvider* _sender,
                                                                       GtkCssSection* section,
                                                                       GError* _error_,
                                                                       gpointer self)
{
	application_client_on_css_parse_error ((ApplicationClient*) self, section, _error_);
}

static void
application_client_load_css (ApplicationClient* self,
                             GtkCssProvider* provider,
                             const gchar* resource_uri)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (provider, gtk_css_provider_get_type ()));
	g_return_if_fail (resource_uri != NULL);
	g_signal_connect_object (provider, "parsing-error", (GCallback) _application_client_on_css_parse_error_gtk_css_provider_parsing_error, self, 0);
	{
		GFile* file = NULL;
		GFile* _tmp0_;
		_tmp0_ = g_file_new_for_uri (resource_uri);
		file = _tmp0_;
		gtk_css_provider_load_from_file (provider, file, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning ("application-client.vala:1156: Could not load CSS: %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
application_client_get_geary_home_dir_name (ApplicationClient* self)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), NULL);
	if (g_strcmp0 (_PROFILE, APPLICATION_CLIENT_PROFILE_RELEASE) == 0) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_is_flatpak_sandboxed;
		_tmp1_ = _tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = "geary";
	} else {
		_tmp0_ = "geary-" _PROFILE;
	}
	_tmp3_ = g_strdup (_tmp0_);
	result = _tmp3_;
	return result;
}

static void
application_client_on_activate_about (ApplicationClient* self)
{
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	application_client_show_about (self, NULL, NULL);
}

static void
application_client_on_activate_accounts (ApplicationClient* self)
{
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	application_client_show_accounts (self, NULL, NULL);
}

static void
application_client_on_activate_compose (ApplicationClient* self)
{
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	application_client_new_composer (self, NULL, NULL, NULL);
}

static void
application_client_on_activate_inspect (ApplicationClient* self)
{
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	application_client_show_inspector (self, NULL, NULL);
}

static void
application_client_on_activate_mailto (ApplicationClient* self,
                                       GSimpleAction* action,
                                       GVariant* param)
{
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	if (param != NULL) {
		const gchar* _tmp0_;
		_tmp0_ = g_variant_get_string (param, NULL);
		application_client_new_composer_mailto (self, _tmp0_, NULL, NULL);
	}
}

static void
application_client_on_activate_new_window (ApplicationClient* self)
{
	GearyFolder* folder = NULL;
	GeeCollection* conversations = NULL;
	ApplicationMainWindow* current = NULL;
	ApplicationMainWindow* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	ApplicationMainWindow* _tmp2_;
	GearyFolder* _tmp11_;
	GeeCollection* _tmp12_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	folder = NULL;
	conversations = NULL;
	_tmp0_ = self->priv->_last_active_main_window;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	current = _tmp1_;
	_tmp2_ = current;
	if (_tmp2_ != NULL) {
		ApplicationMainWindow* _tmp3_;
		GearyFolder* _tmp4_;
		GearyFolder* _tmp5_;
		GearyFolder* _tmp6_;
		ApplicationMainWindow* _tmp7_;
		ConversationListView* _tmp8_;
		ConversationListView* _tmp9_;
		GeeSet* _tmp10_;
		_tmp3_ = current;
		_tmp4_ = application_main_window_get_selected_folder (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (folder);
		folder = _tmp6_;
		_tmp7_ = current;
		_tmp8_ = application_main_window_get_conversation_list_view (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = conversation_list_view_copy_selected (_tmp9_);
		_g_object_unref0 (conversations);
		conversations = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection);
	}
	_tmp11_ = folder;
	_tmp12_ = conversations;
	application_client_new_window (self, _tmp11_, _tmp12_, NULL, NULL);
	_g_object_unref0 (current);
	_g_object_unref0 (conversations);
	_g_object_unref0 (folder);
}

static void
application_client_on_activate_preferences (ApplicationClient* self)
{
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	application_client_show_preferences (self, NULL, NULL);
}

static void
application_client_on_activate_quit (ApplicationClient* self)
{
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	application_client_quit (self);
}

static void
application_client_on_activate_show_email (ApplicationClient* self,
                                           GSimpleAction* action,
                                           GVariant* target)
{
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	application_client_show_email (self, target, NULL, NULL);
}

static void
application_client_on_activate_show_folder (ApplicationClient* self,
                                            GSimpleAction* action,
                                            GVariant* target)
{
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	application_client_show_folder (self, target, NULL, NULL);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ApplicationClient* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
___lambda176_ (Block6Data* _data6_)
{
	ApplicationClient* self;
	GtkDialog* _tmp0_;
	self = _data6_->self;
	_tmp0_ = _data6_->dialog;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}

static void
____lambda176__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	___lambda176_ (self);
}

static void
application_client_on_activate_help (ApplicationClient* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	{
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = application_client_get_is_installed (self);
		_tmp1_ = _tmp0_;
		if (_tmp1_) {
			application_client_show_uri (self, "help:geary", NULL, NULL);
		} else {
			GPid pid = 0;
			GFile* exec_dir = NULL;
			GFile* _tmp2_;
			GFile* _tmp3_;
			gchar** argv = NULL;
			gchar** _tmp4_;
			gint argv_length1;
			gint _argv_size_;
			gchar** _tmp5_;
			gint _tmp5__length1;
			gchar* _tmp6_;
			gchar** _tmp7_;
			gint _tmp7__length1;
			gchar* _tmp8_;
			gchar** _tmp9_;
			gint _tmp9__length1;
			gboolean _tmp10_ = FALSE;
			GFile* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar** _tmp14_;
			gint _tmp14__length1;
			GPid _tmp15_ = 0;
			gboolean _tmp16_;
			gboolean _tmp17_;
			_tmp2_ = self->priv->exec_dir;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			exec_dir = _tmp3_;
			_tmp4_ = g_new0 (gchar*, 3 + 1);
			argv = _tmp4_;
			argv_length1 = 3;
			_argv_size_ = argv_length1;
			_tmp5_ = argv;
			_tmp5__length1 = argv_length1;
			_tmp6_ = g_strdup ("yelp");
			_g_free0 (_tmp5_[0]);
			_tmp5_[0] = _tmp6_;
			_tmp7_ = argv;
			_tmp7__length1 = argv_length1;
			_tmp8_ = g_strdup (APPLICATION_CLIENT_SOURCE_ROOT_DIR "/help/C/");
			_g_free0 (_tmp7_[1]);
			_tmp7_[1] = _tmp8_;
			_tmp9_ = argv;
			_tmp9__length1 = argv_length1;
			_g_free0 (_tmp9_[2]);
			_tmp9_[2] = NULL;
			_tmp11_ = exec_dir;
			_tmp12_ = g_file_get_path (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = argv;
			_tmp14__length1 = argv_length1;
			_tmp16_ = g_spawn_async (_tmp13_, _tmp14_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &_tmp15_, &_inner_error0_);
			pid = _tmp15_;
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp13_);
			_tmp10_ = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (exec_dir);
				goto __catch0_g_error;
			}
			if (!_tmp10_) {
				g_debug ("application-client.vala:1247: Failed to launch help locally.");
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (exec_dir);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		Block6Data* _data6_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		GtkWindow* _tmp20_;
		GtkDialog* _tmp21_;
		GtkDialog* _tmp22_;
		GtkDialog* _tmp23_;
		GtkBox* _tmp24_;
		GError* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		GtkLabel* _tmp29_;
		GtkLabel* _tmp30_;
		GtkDialog* _tmp31_;
		GtkDialog* _tmp32_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->self = g_object_ref (self);
		_tmp18_ = _error_;
		_tmp19_ = _tmp18_->message;
		g_debug ("application-client.vala:1251: Error showing help: %s", _tmp19_);
		_tmp20_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
		_tmp21_ = (GtkDialog*) gtk_dialog_new_with_buttons ("Error", _tmp20_, GTK_DIALOG_DESTROY_WITH_PARENT, STOCK__CLOSE, GTK_RESPONSE_CLOSE, NULL, NULL);
		g_object_ref_sink (_tmp21_);
		_data6_->dialog = _tmp21_;
		_tmp22_ = _data6_->dialog;
		g_signal_connect_data (_tmp22_, "response", (GCallback) ____lambda176__gtk_dialog_response, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_tmp23_ = _data6_->dialog;
		_tmp24_ = gtk_dialog_get_content_area (_tmp23_);
		_tmp25_ = _error_;
		_tmp26_ = _tmp25_->message;
		_tmp27_ = g_strdup_printf ("Error showing help: %s", _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = (GtkLabel*) gtk_label_new (_tmp28_);
		g_object_ref_sink (_tmp29_);
		_tmp30_ = _tmp29_;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (_tmp30_);
		_g_free0 (_tmp28_);
		_tmp31_ = _data6_->dialog;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget));
		_tmp32_ = _data6_->dialog;
		gtk_dialog_run (_tmp32_);
		_g_error_free0 (_error_);
		block6_data_unref (_data6_);
		_data6_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
application_client_on_folders_first_available (ApplicationClient* self,
                                               GearyAccount* account,
                                               GeeBidirSortedSet* available,
                                               GeeBidirSortedSet* unavailable)
{
	ApplicationMainWindow* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT));
	g_return_if_fail ((available == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (available, GEE_TYPE_BIDIR_SORTED_SET));
	g_return_if_fail ((unavailable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (unavailable, GEE_TYPE_BIDIR_SORTED_SET));
	_tmp0_ = application_client_get_active_main_window (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = application_main_window_select_first_inbox (_tmp1_, TRUE);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		guint _tmp3_;
		g_signal_parse_name ("folders-available-unavailable", GEARY_TYPE_ACCOUNT, &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (account, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _application_client_on_folders_first_available_geary_account_folders_available_unavailable, self);
	}
}

static gboolean
application_client_on_main_window_focus_in (ApplicationClient* self,
                                            GtkWidget* widget,
                                            GdkEventFocus* event)
{
	ApplicationMainWindow* main = NULL;
	ApplicationMainWindow* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (widget) ? ((ApplicationMainWindow*) widget) : NULL);
	main = _tmp0_;
	_tmp1_ = main;
	if (_tmp1_ != NULL) {
		ApplicationMainWindow* _tmp2_;
		_tmp2_ = main;
		application_client_set_last_active_main_window (self, _tmp2_);
	}
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (main);
	return result;
}

static void
application_client_on_window_removed (ApplicationClient* self,
                                      GtkWindow* window)
{
	ApplicationMainWindow* main = NULL;
	ApplicationMainWindow* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (window, gtk_window_get_type ()));
	_tmp0_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (window) ? ((ApplicationMainWindow*) window) : NULL);
	main = _tmp0_;
	_tmp1_ = main;
	if (_tmp1_ != NULL) {
		ApplicationController* _tmp2_;
		ApplicationMainWindow* _tmp3_;
		ApplicationMainWindow* _tmp4_;
		ApplicationMainWindow* _tmp5_;
		_tmp2_ = self->priv->_controller;
		_tmp3_ = main;
		application_controller_unregister_window (_tmp2_, _tmp3_);
		_tmp4_ = self->priv->_last_active_main_window;
		_tmp5_ = main;
		if (_tmp4_ == _tmp5_) {
			GeeCollection* _tmp6_;
			GeeCollection* _tmp7_;
			gpointer _tmp8_;
			ApplicationMainWindow* _tmp9_;
			_tmp6_ = application_client_get_main_windows (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = geary_collection_first (APPLICATION_TYPE_MAIN_WINDOW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp7_);
			_tmp9_ = (ApplicationMainWindow*) _tmp8_;
			application_client_set_last_active_main_window (self, _tmp9_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp7_);
		}
	}
	_tmp11_ = application_client_get_is_background_service (self);
	_tmp12_ = _tmp11_;
	if (!_tmp12_) {
		GList* _tmp13_;
		_tmp13_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
		_tmp10_ = g_list_length (_tmp13_) == ((guint) 0);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		application_client_quit (self);
	}
	_g_object_unref0 (main);
}

static void
application_client_on_single_key_shortcuts_toggled (ApplicationClient* self)
{
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	application_client_update_single_key_shortcuts (self);
}

static void
application_client_on_css_parse_error (ApplicationClient* self,
                                       GtkCssSection* section,
                                       GError* _error_)
{
	guint start = 0U;
	guint end = 0U;
	g_return_if_fail (APPLICATION_IS_CLIENT (self));
	g_return_if_fail (section != NULL);
	g_return_if_fail (_error_ != NULL);
	start = gtk_css_section_get_start_line (section);
	end = gtk_css_section_get_end_line (section);
	if (start == end) {
		GFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp0_ = gtk_css_section_get_file (section);
		_tmp1_ = g_file_get_uri (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _error_->message;
		g_warning ("application-client.vala:1314: Error parsing %s:%u: %s", _tmp2_, start, _tmp3_);
		_g_free0 (_tmp2_);
	} else {
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = gtk_css_section_get_file (section);
		_tmp5_ = g_file_get_uri (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _error_->message;
		g_warning ("application-client.vala:1319: Error parsing %s:%u-%u: %s", _tmp6_, start, end, _tmp7_);
		_g_free0 (_tmp6_);
	}
}

void
application_client_runtime_detail_copy (const ApplicationClientRuntimeDetail* self,
                                        ApplicationClientRuntimeDetail* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).value);
	(*dest).value = _tmp3_;
}

void
application_client_runtime_detail_destroy (ApplicationClientRuntimeDetail* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).value);
}

ApplicationClientRuntimeDetail*
application_client_runtime_detail_dup (const ApplicationClientRuntimeDetail* self)
{
	ApplicationClientRuntimeDetail* dup;
	dup = g_new0 (ApplicationClientRuntimeDetail, 1);
	application_client_runtime_detail_copy (self, dup);
	return dup;
}

void
application_client_runtime_detail_free (ApplicationClientRuntimeDetail* self)
{
	application_client_runtime_detail_destroy (self);
	g_free (self);
}

static GType
application_client_runtime_detail_get_type_once (void)
{
	GType application_client_runtime_detail_type_id;
	application_client_runtime_detail_type_id = g_boxed_type_register_static ("ApplicationClientRuntimeDetail", (GBoxedCopyFunc) application_client_runtime_detail_dup, (GBoxedFreeFunc) application_client_runtime_detail_free);
	return application_client_runtime_detail_type_id;
}

GType
application_client_runtime_detail_get_type (void)
{
	static volatile gsize application_client_runtime_detail_type_id__once = 0;
	if (g_once_init_enter (&application_client_runtime_detail_type_id__once)) {
		GType application_client_runtime_detail_type_id;
		application_client_runtime_detail_type_id = application_client_runtime_detail_get_type_once ();
		g_once_init_leave (&application_client_runtime_detail_type_id__once, application_client_runtime_detail_type_id);
	}
	return application_client_runtime_detail_type_id__once;
}

static void
application_client_class_init (ApplicationClientClass * klass,
                               gpointer klass_data)
{
	application_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationClient_private_offset);
	((GApplicationClass *) klass)->local_command_line = (gboolean (*) (GApplication*, gchar***, gint*)) application_client_real_local_command_line;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) application_client_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) application_client_real_startup;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) application_client_real_command_line;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) application_client_real_shutdown;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) application_client_real_activate;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) application_client_real_open;
	G_OBJECT_CLASS (klass)->get_property = _vala_application_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_client_finalize;
	/**
	     * The global email subsystem controller for this app instance.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CLIENT_ENGINE_PROPERTY, application_client_properties[APPLICATION_CLIENT_ENGINE_PROPERTY] = g_param_spec_object ("engine", "engine", "engine", GEARY_TYPE_ENGINE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The user's desktop settings for the application.
	     *
	     * This will be null until {@link startup} has been called, and
	     * hence will only ever become non-null for the primary instance.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CLIENT_CONFIG_PROPERTY, application_client_properties[APPLICATION_CLIENT_CONFIG_PROPERTY] = g_param_spec_object ("config", "config", "config", APPLICATION_TYPE_CONFIGURATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The last active main window.
	     *
	     * This will be null if no main windows exist, see {@link
	     * get_active_main_window} if you want to be guaranteed an
	     * instance.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CLIENT_LAST_ACTIVE_MAIN_WINDOW_PROPERTY, application_client_properties[APPLICATION_CLIENT_LAST_ACTIVE_MAIN_WINDOW_PROPERTY] = g_param_spec_object ("last-active-main-window", "last-active-main-window", "last-active-main-window", APPLICATION_TYPE_MAIN_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Manages the autostart desktop file.
	     *
	     * This will be null until {@link startup} has been called, and
	     * hence will only ever become non-null for the primary instance.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CLIENT_AUTOSTART_PROPERTY, application_client_properties[APPLICATION_CLIENT_AUTOSTART_PROPERTY] = g_param_spec_object ("autostart", "autostart", "autostart", APPLICATION_TYPE_STARTUP_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines if Geary configured to run as as a background service.
	     *
	     * If this returns `true`, then the primary application instance
	     * will continue to run in the background after the last window is
	     * closed, instead of exiting as usual.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CLIENT_IS_BACKGROUND_SERVICE_PROPERTY, application_client_properties[APPLICATION_CLIENT_IS_BACKGROUND_SERVICE_PROPERTY] = g_param_spec_boolean ("is-background-service", "is-background-service", "is-background-service", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines if Geary appears to be running under Flatpak.
	     *
	     * If this returns `true`, then the application instance
	     * appears to be running inside a Flatpak sandbox.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CLIENT_IS_FLATPAK_SANDBOXED_PROPERTY, application_client_properties[APPLICATION_CLIENT_IS_FLATPAK_SANDBOXED_PROPERTY] = g_param_spec_boolean ("is-flatpak-sandboxed", "is-flatpak-sandboxed", "is-flatpak-sandboxed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The global controller for this application instance.
	     *
	     * This will be non-null in the primary application instance, only
	     * after initial activation, or after startup if {@link
	     * is_background_service} is true.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CLIENT_CONTROLLER_PROPERTY, application_client_properties[APPLICATION_CLIENT_CONTROLLER_PROPERTY] = g_param_spec_object ("controller", "controller", "controller", APPLICATION_TYPE_CONTROLLER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines if this instance is running from the install directory.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CLIENT_IS_INSTALLED_PROPERTY, application_client_properties[APPLICATION_CLIENT_IS_INSTALLED_PROPERTY] = g_param_spec_boolean ("is-installed", "is-installed", "is-installed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns the compile-time configured installation directory. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CLIENT_INSTALL_PREFIX_PROPERTY, application_client_properties[APPLICATION_CLIENT_INSTALL_PREFIX_PROPERTY] = g_param_spec_object ("install-prefix", "install-prefix", "install-prefix", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
application_client_instance_init (ApplicationClient * self,
                                  gpointer klass)
{
	GFile* _tmp0_;
	GtkCssProvider* _tmp1_;
	GCancellable* _tmp2_;
	GearyNonblockingMutex* _tmp3_;
	self->priv = application_client_get_instance_private (self);
	self->priv->_engine = NULL;
	self->priv->_config = NULL;
	self->priv->_last_active_main_window = NULL;
	self->priv->_autostart = NULL;
	self->priv->_controller = NULL;
	_tmp0_ = g_file_new_for_path (APPLICATION_CLIENT_INSTALL_PREFIX);
	self->priv->_install_prefix = _tmp0_;
	_tmp1_ = gtk_css_provider_new ();
	self->priv->single_key_shortcuts = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	self->priv->controller_cancellable = _tmp2_;
	self->priv->inspector = NULL;
	_tmp3_ = geary_nonblocking_mutex_new ();
	self->priv->controller_mutex = _tmp3_;
	self->priv->error_notification = NULL;
}

static void
application_client_finalize (GObject * obj)
{
	ApplicationClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_CLIENT, ApplicationClient);
	_g_object_unref0 (self->priv->_engine);
	_g_object_unref0 (self->priv->_config);
	_g_object_unref0 (self->priv->_last_active_main_window);
	_g_object_unref0 (self->priv->_autostart);
	_g_object_unref0 (self->priv->_controller);
	_g_object_unref0 (self->priv->_install_prefix);
	_g_object_unref0 (self->priv->exec_dir);
	_g_free0 (self->priv->binary);
	_g_object_unref0 (self->priv->single_key_shortcuts);
	_g_object_unref0 (self->priv->controller_cancellable);
	_g_object_unref0 (self->priv->inspector);
	_g_object_unref0 (self->priv->controller_mutex);
	_g_object_unref0 (self->priv->error_notification);
	G_OBJECT_CLASS (application_client_parent_class)->finalize (obj);
}

/**
 * The client application's main point of entry and desktop integration.
 */
static GType
application_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationClient), 0, (GInstanceInitFunc) application_client_instance_init, NULL };
	GType application_client_type_id;
	application_client_type_id = g_type_register_static (gtk_application_get_type (), "ApplicationClient", &g_define_type_info, 0);
	ApplicationClient_private_offset = g_type_add_instance_private (application_client_type_id, sizeof (ApplicationClientPrivate));
	return application_client_type_id;
}

GType
application_client_get_type (void)
{
	static volatile gsize application_client_type_id__once = 0;
	if (g_once_init_enter (&application_client_type_id__once)) {
		GType application_client_type_id;
		application_client_type_id = application_client_get_type_once ();
		g_once_init_leave (&application_client_type_id__once, application_client_type_id);
	}
	return application_client_type_id__once;
}

static void
_vala_application_client_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	ApplicationClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_CLIENT, ApplicationClient);
	switch (property_id) {
		case APPLICATION_CLIENT_ENGINE_PROPERTY:
		g_value_set_object (value, application_client_get_engine (self));
		break;
		case APPLICATION_CLIENT_CONFIG_PROPERTY:
		g_value_set_object (value, application_client_get_config (self));
		break;
		case APPLICATION_CLIENT_LAST_ACTIVE_MAIN_WINDOW_PROPERTY:
		g_value_set_object (value, application_client_get_last_active_main_window (self));
		break;
		case APPLICATION_CLIENT_AUTOSTART_PROPERTY:
		g_value_set_object (value, application_client_get_autostart (self));
		break;
		case APPLICATION_CLIENT_IS_BACKGROUND_SERVICE_PROPERTY:
		g_value_set_boolean (value, application_client_get_is_background_service (self));
		break;
		case APPLICATION_CLIENT_IS_FLATPAK_SANDBOXED_PROPERTY:
		g_value_set_boolean (value, application_client_get_is_flatpak_sandboxed (self));
		break;
		case APPLICATION_CLIENT_CONTROLLER_PROPERTY:
		g_value_set_object (value, application_client_get_controller (self));
		break;
		case APPLICATION_CLIENT_IS_INSTALLED_PROPERTY:
		g_value_set_boolean (value, application_client_get_is_installed (self));
		break;
		case APPLICATION_CLIENT_INSTALL_PREFIX_PROPERTY:
		g_value_set_object (value, application_client_get_install_prefix (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_client_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	ApplicationClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_CLIENT, ApplicationClient);
	switch (property_id) {
		case APPLICATION_CLIENT_ENGINE_PROPERTY:
		application_client_set_engine (self, g_value_get_object (value));
		break;
		case APPLICATION_CLIENT_CONFIG_PROPERTY:
		application_client_set_config (self, g_value_get_object (value));
		break;
		case APPLICATION_CLIENT_LAST_ACTIVE_MAIN_WINDOW_PROPERTY:
		application_client_set_last_active_main_window (self, g_value_get_object (value));
		break;
		case APPLICATION_CLIENT_AUTOSTART_PROPERTY:
		application_client_set_autostart (self, g_value_get_object (value));
		break;
		case APPLICATION_CLIENT_IS_FLATPAK_SANDBOXED_PROPERTY:
		application_client_set_is_flatpak_sandboxed (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CLIENT_CONTROLLER_PROPERTY:
		application_client_set_controller (self, g_value_get_object (value));
		break;
		case APPLICATION_CLIENT_INSTALL_PREFIX_PROPERTY:
		application_client_set_install_prefix (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

