/* conversation-list-store.c generated by valac 0.56.3, the Vala compiler
 * generated from conversation-list-store.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#define CONVERSATION_LIST_STORE_TYPE_ROW_WRAPPER (conversation_list_store_row_wrapper_get_type ())
#define CONVERSATION_LIST_STORE_ROW_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONVERSATION_LIST_STORE_TYPE_ROW_WRAPPER, ConversationListStoreRowWrapper))
#define CONVERSATION_LIST_STORE_ROW_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONVERSATION_LIST_STORE_TYPE_ROW_WRAPPER, ConversationListStoreRowWrapperClass))
#define CONVERSATION_LIST_STORE_IS_ROW_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONVERSATION_LIST_STORE_TYPE_ROW_WRAPPER))
#define CONVERSATION_LIST_STORE_IS_ROW_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONVERSATION_LIST_STORE_TYPE_ROW_WRAPPER))
#define CONVERSATION_LIST_STORE_ROW_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONVERSATION_LIST_STORE_TYPE_ROW_WRAPPER, ConversationListStoreRowWrapperClass))

typedef struct _ConversationListStoreRowWrapper ConversationListStoreRowWrapper;
typedef struct _ConversationListStoreRowWrapperClass ConversationListStoreRowWrapperClass;
enum  {
	CONVERSATION_LIST_STORE_0_PROPERTY,
	CONVERSATION_LIST_STORE_CONVERSATIONS_PROPERTY,
	CONVERSATION_LIST_STORE_PREVIEW_MONITOR_PROPERTY,
	CONVERSATION_LIST_STORE_NUM_PROPERTIES
};
static GParamSpec* conversation_list_store_properties[CONVERSATION_LIST_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ConversationListStoreRefreshPreviewsAsyncData ConversationListStoreRefreshPreviewsAsyncData;
typedef struct _ConversationListStoreDoRefreshPreviewsAsyncData ConversationListStoreDoRefreshPreviewsAsyncData;
typedef struct _ConversationListStoreDoGetPreviewsAsyncData ConversationListStoreDoGetPreviewsAsyncData;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
typedef struct _ConversationListStoreRowWrapperPrivate ConversationListStoreRowWrapperPrivate;
enum  {
	CONVERSATION_LIST_STORE_ROW_WRAPPER_0_PROPERTY,
	CONVERSATION_LIST_STORE_ROW_WRAPPER_NUM_PROPERTIES
};
static GParamSpec* conversation_list_store_row_wrapper_properties[CONVERSATION_LIST_STORE_ROW_WRAPPER_NUM_PROPERTIES];
#define __vala_GtkTreeRowReference_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeRowReference_free (var), NULL)))
enum  {
	CONVERSATION_LIST_STORE_CONVERSATIONS_ADDED_SIGNAL,
	CONVERSATION_LIST_STORE_CONVERSATIONS_REMOVED_SIGNAL,
	CONVERSATION_LIST_STORE_NUM_SIGNALS
};
static guint conversation_list_store_signals[CONVERSATION_LIST_STORE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ConversationListStorePrivate {
	GearyAppConversationMonitor* _conversations;
	GearyProgressMonitor* _preview_monitor;
	ApplicationConfiguration* config;
	GeeHashMap* row_map;
	GearyAppEmailStore* email_store;
	GCancellable* cancellable;
	gboolean loading_local_only;
	GearyNonblockingMutex* refresh_mutex;
};

struct _ConversationListStoreRefreshPreviewsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationListStore* self;
	GearyAppConversationMonitor* conversation_monitor;
	gint token;
	gint _tmp0_;
	GearyNonblockingMutex* _tmp1_;
	GCancellable* _tmp2_;
	GError* err;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GearyProgressMonitor* _tmp5_;
	GearyProgressMonitor* _tmp6_;
	GearyNonblockingMutex* _tmp7_;
	GError* _vala1_err;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_;
};

struct _ConversationListStoreDoRefreshPreviewsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationListStore* self;
	GearyAppConversationMonitor* conversation_monitor;
	gboolean _tmp0_;
	ApplicationConfiguration* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeSet* needing_previews;
	GeeSet* _tmp4_;
	GeeArrayList* emails;
	GeeArrayList* _tmp5_;
	GeeSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp9_;
	GeeSet* _tmp10_;
	GeeCollection* _tmp11_;
	GeeCollection* _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeArrayList* _email_list;
	GeeArrayList* _tmp16_;
	gint _email_size;
	GeeArrayList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _email_index;
	gint _tmp20_;
	gint _tmp21_;
	GearyEmail* email;
	GeeArrayList* _tmp22_;
	gpointer _tmp23_;
	GearyAppConversation* conversation;
	GearyEmail* _tmp24_;
	GearyEmailIdentifier* _tmp25_;
	GearyEmailIdentifier* _tmp26_;
	GearyAppConversation* _tmp27_;
	GearyAppConversation* _tmp28_;
	GearyAppConversation* _tmp29_;
	GearyEmail* _tmp30_;
};

struct _ConversationListStoreDoGetPreviewsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationListStore* self;
	GeeCollection* emails_needing_previews;
	GeeCollection* result;
	GearyFolderListFlags _tmp0_;
	GearyFolderListFlags flags;
	GeeCollection* emails;
	GeeCollection* _tmp1_;
	GearyAppEmailStore* _tmp2_;
	GCancellable* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GError* err;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	GeeCollection* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeCollection* _tmp12_;
	GError* _inner_error0_;
};

struct _ConversationListStoreRowWrapper {
	GearyBaseObject parent_instance;
	GearyAppConversation* conversation;
	GtkTreeRowReference* row;
	ConversationListStoreRowWrapperPrivate * priv;
};

struct _ConversationListStoreRowWrapperClass {
	GearyBaseObjectClass parent_class;
};

static gint ConversationListStore_private_offset;
static gpointer conversation_list_store_parent_class = NULL;
static gpointer conversation_list_store_row_wrapper_parent_class = NULL;

static GType conversation_list_store_row_wrapper_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gint conversation_list_store_sort_by_date (GtkTreeModel* model,
                                           GtkTreeIter* aiter,
                                           GtkTreeIter* biter);
static void conversation_list_store_set_preview_monitor (ConversationListStore* self,
                                                  GearyProgressMonitor* value);
static gint _conversation_list_store_sort_by_date_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                       GtkTreeIter* a,
                                                                       GtkTreeIter* b,
                                                                       gpointer self);
static void conversation_list_store_on_display_preview_changed (ConversationListStore* self);
static void _conversation_list_store_on_display_preview_changed_g_settings_changed (GSettings* _sender,
                                                                             const gchar* key,
                                                                             gpointer self);
static void conversation_list_store_on_scan_completed (ConversationListStore* self,
                                                GearyAppConversationMonitor* sender);
static void _conversation_list_store_on_scan_completed_geary_app_conversation_monitor_scan_completed (GearyAppConversationMonitor* _sender,
                                                                                               gpointer self);
static void conversation_list_store_on_conversations_added (ConversationListStore* self,
                                                     GeeCollection* conversations);
static void _conversation_list_store_on_conversations_added_geary_app_conversation_monitor_conversations_added (GearyAppConversationMonitor* _sender,
                                                                                                         GeeCollection* conversations,
                                                                                                         gpointer self);
static void conversation_list_store_on_conversations_removed (ConversationListStore* self,
                                                       GeeCollection* conversations);
static void _conversation_list_store_on_conversations_removed_geary_app_conversation_monitor_conversations_removed (GearyAppConversationMonitor* _sender,
                                                                                                             GeeCollection* conversations,
                                                                                                             gpointer self);
static void conversation_list_store_on_conversation_appended (ConversationListStore* self,
                                                       GearyAppConversation* conversation);
static void _conversation_list_store_on_conversation_appended_geary_app_conversation_monitor_conversation_appended (GearyAppConversationMonitor* _sender,
                                                                                                             GearyAppConversation* conversation,
                                                                                                             GeeCollection* email,
                                                                                                             gpointer self);
static void conversation_list_store_on_conversation_trimmed (ConversationListStore* self,
                                                      GearyAppConversation* conversation);
static void _conversation_list_store_on_conversation_trimmed_geary_app_conversation_monitor_conversation_trimmed (GearyAppConversationMonitor* _sender,
                                                                                                           GearyAppConversation* conversation,
                                                                                                           GeeCollection* email,
                                                                                                           gpointer self);
static void conversation_list_store_on_email_flags_changed (ConversationListStore* self,
                                                     GearyAppConversation* conversation);
static void _conversation_list_store_on_email_flags_changed_geary_app_conversation_monitor_email_flags_changed (GearyAppConversationMonitor* _sender,
                                                                                                         GearyAppConversation* conversation,
                                                                                                         GearyEmail* email,
                                                                                                         gpointer self);
static gboolean conversation_list_store_update_date_string (ConversationListStore* self,
                                                     GtkTreeModel* model,
                                                     GtkTreePath* path,
                                                     GtkTreeIter* iter);
static gboolean _conversation_list_store_update_date_string_gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                                                  GtkTreePath* path,
                                                                                  GtkTreeIter* iter,
                                                                                  gpointer self);
static GearyAppConversation* conversation_list_store_get_conversation_at_iter (ConversationListStore* self,
                                                                        GtkTreeIter* iter);
static void conversation_list_store_refresh_previews_async_data_free (gpointer _data);
static void conversation_list_store_refresh_previews_async (ConversationListStore* self,
                                                     GearyAppConversationMonitor* conversation_monitor,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void conversation_list_store_refresh_previews_finish (ConversationListStore* self,
                                                      GAsyncResult* _res_);
static gboolean conversation_list_store_refresh_previews_async_co (ConversationListStoreRefreshPreviewsAsyncData* _data_);
static void conversation_list_store_refresh_previews_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void conversation_list_store_do_refresh_previews_async (ConversationListStore* self,
                                                        GearyAppConversationMonitor* conversation_monitor,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void conversation_list_store_do_refresh_previews_finish (ConversationListStore* self,
                                                         GAsyncResult* _res_);
static void conversation_list_store_do_refresh_previews_async_data_free (gpointer _data);
static gboolean conversation_list_store_do_refresh_previews_async_co (ConversationListStoreDoRefreshPreviewsAsyncData* _data_);
static GeeSet* conversation_list_store_get_emails_needing_previews (ConversationListStore* self);
static void conversation_list_store_do_get_previews_async (ConversationListStore* self,
                                                    GeeCollection* emails_needing_previews,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static GeeCollection* conversation_list_store_do_get_previews_finish (ConversationListStore* self,
                                                               GAsyncResult* _res_);
static void conversation_list_store_do_refresh_previews_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void conversation_list_store_set_preview_for_conversation (ConversationListStore* self,
                                                           GearyAppConversation* conversation,
                                                           GearyEmail* preview);
static void conversation_list_store_do_get_previews_async_data_free (gpointer _data);
static gboolean conversation_list_store_do_get_previews_async_co (ConversationListStoreDoGetPreviewsAsyncData* _data_);
static void conversation_list_store_do_get_previews_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static gint _util_email_compare_conversation_descending_gcompare_data_func (gconstpointer a,
                                                                     gconstpointer b,
                                                                     gpointer self);
static GearyEmail* conversation_list_store_get_preview_for_conversation (ConversationListStore* self,
                                                                  GearyAppConversation* conversation);
static gboolean conversation_list_store_get_iter_for_conversation (ConversationListStore* self,
                                                            GearyAppConversation* conversation,
                                                            GtkTreeIter* iter);
static FormattedConversationData* conversation_list_store_get_message_data_at_iter (ConversationListStore* self,
                                                                             GtkTreeIter* iter);
static void conversation_list_store_set_row (ConversationListStore* self,
                                      GtkTreeIter* iter,
                                      GearyAppConversation* conversation,
                                      GearyEmail* preview);
static ConversationListStoreRowWrapper* conversation_list_store_row_wrapper_new (GtkTreeModel* model,
                                                                          GearyAppConversation* conversation,
                                                                          GtkTreePath* path);
static ConversationListStoreRowWrapper* conversation_list_store_row_wrapper_construct (GType object_type,
                                                                                GtkTreeModel* model,
                                                                                GearyAppConversation* conversation,
                                                                                GtkTreePath* path);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void conversation_list_store_refresh_conversation (ConversationListStore* self,
                                                   GearyAppConversation* conversation);
static gboolean conversation_list_store_add_conversation (ConversationListStore* self,
                                                   GearyAppConversation* conversation);
static void conversation_list_store_refresh_flags (ConversationListStore* self,
                                            GearyAppConversation* conversation);
static GtkTreePath* conversation_list_store_row_wrapper_get_path (ConversationListStoreRowWrapper* self);
static gboolean conversation_list_store_row_wrapper_get_iter (ConversationListStoreRowWrapper* self,
                                                       GtkTreeIter* iter);
static gboolean conversation_list_store_has_conversation (ConversationListStore* self,
                                                   GearyAppConversation* conversation);
static void conversation_list_store_remove_conversation (ConversationListStore* self,
                                                  GearyAppConversation* conversation);
static void _vala_GtkTreeRowReference_free (GtkTreeRowReference* self);
static void conversation_list_store_row_wrapper_finalize (GObject * obj);
static GType conversation_list_store_row_wrapper_get_type_once (void);
static void conversation_list_store_finalize (GObject * obj);
static GType conversation_list_store_get_type_once (void);
static void _vala_conversation_list_store_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_conversation_list_store_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
conversation_list_store_get_instance_private (ConversationListStore* self)
{
	return G_STRUCT_MEMBER_P (self, ConversationListStore_private_offset);
}

GType*
conversation_list_store_column_get_types (gint* result_length1)
{
	GType* _tmp0_;
	GType* _tmp1_;
	gint _tmp1__length1;
	GType* result;
	_tmp0_ = g_new0 (GType, 3);
	_tmp0_[0] = TYPE_FORMATTED_CONVERSATION_DATA;
	_tmp0_[1] = GEARY_APP_TYPE_CONVERSATION;
	_tmp0_[2] = CONVERSATION_LIST_STORE_TYPE_ROW_WRAPPER;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

gchar*
conversation_list_store_column_to_string (ConversationListStoreColumn self)
{
	gchar* result;
	switch (self) {
		case CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_DATA:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("data");
			result = _tmp0_;
			return result;
		}
		case CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_OBJECT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("envelope");
			result = _tmp1_;
			return result;
		}
		case CONVERSATION_LIST_STORE_COLUMN_ROW_WRAPPER:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("wrapper");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
conversation_list_store_column_get_type_once (void)
{
	static const GEnumValue values[] = {{CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_DATA, "CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_DATA", "conversation-data"}, {CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_OBJECT, "CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_OBJECT", "conversation-object"}, {CONVERSATION_LIST_STORE_COLUMN_ROW_WRAPPER, "CONVERSATION_LIST_STORE_COLUMN_ROW_WRAPPER", "row-wrapper"}, {0, NULL, NULL}};
	GType conversation_list_store_column_type_id;
	conversation_list_store_column_type_id = g_enum_register_static ("ConversationListStoreColumn", values);
	return conversation_list_store_column_type_id;
}

GType
conversation_list_store_column_get_type (void)
{
	static volatile gsize conversation_list_store_column_type_id__once = 0;
	if (g_once_init_enter (&conversation_list_store_column_type_id__once)) {
		GType conversation_list_store_column_type_id;
		conversation_list_store_column_type_id = conversation_list_store_column_get_type_once ();
		g_once_init_leave (&conversation_list_store_column_type_id__once, conversation_list_store_column_type_id);
	}
	return conversation_list_store_column_type_id__once;
}

static gint
conversation_list_store_sort_by_date (GtkTreeModel* model,
                                      GtkTreeIter* aiter,
                                      GtkTreeIter* biter)
{
	GearyAppConversation* a = NULL;
	GearyAppConversation* b = NULL;
	GtkTreeIter _tmp0_;
	GearyAppConversation* _tmp1_ = NULL;
	GtkTreeIter _tmp2_;
	GearyAppConversation* _tmp3_ = NULL;
	gint result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()), 0);
	g_return_val_if_fail (aiter != NULL, 0);
	g_return_val_if_fail (biter != NULL, 0);
	_tmp0_ = *aiter;
	gtk_tree_model_get (model, &_tmp0_, CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_OBJECT, &_tmp1_, -1);
	_g_object_unref0 (a);
	a = _tmp1_;
	_tmp2_ = *biter;
	gtk_tree_model_get (model, &_tmp2_, CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_OBJECT, &_tmp3_, -1);
	_g_object_unref0 (b);
	b = _tmp3_;
	result = util_email_compare_conversation_ascending (a, b);
	_g_object_unref0 (b);
	_g_object_unref0 (a);
	return result;
}

GearyAppConversationMonitor*
conversation_list_store_get_conversations (ConversationListStore* self)
{
	GearyAppConversationMonitor* result;
	GearyAppConversationMonitor* _tmp0_;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), NULL);
	_tmp0_ = self->priv->_conversations;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
conversation_list_store_set_conversations (ConversationListStore* self,
                                           GearyAppConversationMonitor* value)
{
	GearyAppConversationMonitor* old_value;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	old_value = conversation_list_store_get_conversations (self);
	if (old_value != value) {
		GearyAppConversationMonitor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_conversations);
		self->priv->_conversations = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_list_store_properties[CONVERSATION_LIST_STORE_CONVERSATIONS_PROPERTY]);
	}
}

GearyProgressMonitor*
conversation_list_store_get_preview_monitor (ConversationListStore* self)
{
	GearyProgressMonitor* result;
	GearyProgressMonitor* _tmp0_;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), NULL);
	_tmp0_ = self->priv->_preview_monitor;
	result = _tmp0_;
	return result;
}

static void
conversation_list_store_set_preview_monitor (ConversationListStore* self,
                                             GearyProgressMonitor* value)
{
	GearyProgressMonitor* old_value;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	old_value = conversation_list_store_get_preview_monitor (self);
	if (old_value != value) {
		GearyProgressMonitor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_preview_monitor);
		self->priv->_preview_monitor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_list_store_properties[CONVERSATION_LIST_STORE_PREVIEW_MONITOR_PROPERTY]);
	}
}

static gint
_conversation_list_store_sort_by_date_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                  GtkTreeIter* a,
                                                                  GtkTreeIter* b,
                                                                  gpointer self)
{
	gint result;
	result = conversation_list_store_sort_by_date (model, a, b);
	return result;
}

static void
_conversation_list_store_on_display_preview_changed_g_settings_changed (GSettings* _sender,
                                                                        const gchar* key,
                                                                        gpointer self)
{
	conversation_list_store_on_display_preview_changed ((ConversationListStore*) self);
}

static void
_conversation_list_store_on_scan_completed_geary_app_conversation_monitor_scan_completed (GearyAppConversationMonitor* _sender,
                                                                                          gpointer self)
{
	conversation_list_store_on_scan_completed ((ConversationListStore*) self, _sender);
}

static void
_conversation_list_store_on_conversations_added_geary_app_conversation_monitor_conversations_added (GearyAppConversationMonitor* _sender,
                                                                                                    GeeCollection* conversations,
                                                                                                    gpointer self)
{
	conversation_list_store_on_conversations_added ((ConversationListStore*) self, conversations);
}

static void
_conversation_list_store_on_conversations_removed_geary_app_conversation_monitor_conversations_removed (GearyAppConversationMonitor* _sender,
                                                                                                        GeeCollection* conversations,
                                                                                                        gpointer self)
{
	conversation_list_store_on_conversations_removed ((ConversationListStore*) self, conversations);
}

static void
_conversation_list_store_on_conversation_appended_geary_app_conversation_monitor_conversation_appended (GearyAppConversationMonitor* _sender,
                                                                                                        GearyAppConversation* conversation,
                                                                                                        GeeCollection* email,
                                                                                                        gpointer self)
{
	conversation_list_store_on_conversation_appended ((ConversationListStore*) self, conversation);
}

static void
_conversation_list_store_on_conversation_trimmed_geary_app_conversation_monitor_conversation_trimmed (GearyAppConversationMonitor* _sender,
                                                                                                      GearyAppConversation* conversation,
                                                                                                      GeeCollection* email,
                                                                                                      gpointer self)
{
	conversation_list_store_on_conversation_trimmed ((ConversationListStore*) self, conversation);
}

static void
_conversation_list_store_on_email_flags_changed_geary_app_conversation_monitor_email_flags_changed (GearyAppConversationMonitor* _sender,
                                                                                                    GearyAppConversation* conversation,
                                                                                                    GearyEmail* email,
                                                                                                    gpointer self)
{
	conversation_list_store_on_email_flags_changed ((ConversationListStore*) self, conversation);
}

ConversationListStore*
conversation_list_store_construct (GType object_type,
                                   GearyAppConversationMonitor* conversations,
                                   ApplicationConfiguration* config)
{
	ConversationListStore * self = NULL;
	gint _tmp0_ = 0;
	GType* _tmp1_;
	GType* _tmp2_;
	gint _tmp2__length1;
	GearyFolder* _tmp3_;
	GearyFolder* _tmp4_;
	GearyAccount* _tmp5_;
	GearyAccount* _tmp6_;
	GearyAppEmailStore* _tmp7_;
	ApplicationConfiguration* _tmp8_;
	ApplicationConfiguration* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	gchar* _tmp12_;
	GeeSet* _tmp13_;
	GeeSet* _tmp14_;
	GeeSet* _tmp15_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversations, GEARY_APP_TYPE_CONVERSATION_MONITOR), NULL);
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	self = (ConversationListStore*) g_object_new (object_type, NULL);
	_tmp1_ = conversation_list_store_column_get_types (&_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	gtk_list_store_set_column_types (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_store_get_type (), GtkListStore), (gint) _tmp0_, _tmp2_);
	_tmp2_ = (g_free (_tmp2_), NULL);
	gtk_tree_sortable_set_default_sort_func (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_sortable_get_type (), GtkTreeSortable), _conversation_list_store_sort_by_date_gtk_tree_iter_compare_func, NULL, NULL);
	gtk_tree_sortable_set_sort_column_id (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_sortable_get_type (), GtkTreeSortable), GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID, GTK_SORT_DESCENDING);
	conversation_list_store_set_conversations (self, conversations);
	_tmp3_ = geary_app_conversation_monitor_get_base_folder (conversations);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_folder_get_account (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = geary_app_email_store_new (_tmp6_);
	_g_object_unref0 (self->priv->email_store);
	self->priv->email_store = _tmp7_;
	_tmp8_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp8_;
	_tmp9_ = self->priv->config;
	_tmp10_ = application_configuration_get_settings (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat ("changed::", APPLICATION_CONFIGURATION_DISPLAY_PREVIEW_KEY, NULL);
	g_signal_connect_object (_tmp11_, _tmp12_, (GCallback) _conversation_list_store_on_display_preview_changed_g_settings_changed, self, 0);
	_g_free0 (_tmp12_);
	g_signal_connect_object (conversations, "scan-completed", (GCallback) _conversation_list_store_on_scan_completed_geary_app_conversation_monitor_scan_completed, self, 0);
	g_signal_connect_object (conversations, "conversations-added", (GCallback) _conversation_list_store_on_conversations_added_geary_app_conversation_monitor_conversations_added, self, 0);
	g_signal_connect_object (conversations, "conversations-removed", (GCallback) _conversation_list_store_on_conversations_removed_geary_app_conversation_monitor_conversations_removed, self, 0);
	g_signal_connect_object (conversations, "conversation-appended", (GCallback) _conversation_list_store_on_conversation_appended_geary_app_conversation_monitor_conversation_appended, self, 0);
	g_signal_connect_object (conversations, "conversation-trimmed", (GCallback) _conversation_list_store_on_conversation_trimmed_geary_app_conversation_monitor_conversation_trimmed, self, 0);
	g_signal_connect_object (conversations, "email-flags-changed", (GCallback) _conversation_list_store_on_email_flags_changed_geary_app_conversation_monitor_email_flags_changed, self, 0);
	_tmp13_ = geary_app_conversation_monitor_get_read_only_view (conversations);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	conversation_list_store_on_conversations_added (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (_tmp15_);
	return self;
}

ConversationListStore*
conversation_list_store_new (GearyAppConversationMonitor* conversations,
                             ApplicationConfiguration* config)
{
	return conversation_list_store_construct (TYPE_CONVERSATION_LIST_STORE, conversations, config);
}

void
conversation_list_store_destroy (ConversationListStore* self)
{
	GCancellable* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	_g_object_unref0 (self->priv->email_store);
	self->priv->email_store = NULL;
	gtk_list_store_clear (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_store_get_type (), GtkListStore));
	_tmp1_ = self->priv->row_map;
	gee_abstract_map_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
}

static gboolean
_conversation_list_store_update_date_string_gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                                         GtkTreePath* path,
                                                                         GtkTreeIter* iter,
                                                                         gpointer self)
{
	gboolean result;
	result = conversation_list_store_update_date_string ((ConversationListStore*) self, model, path, iter);
	return result;
}

void
conversation_list_store_update_display (ConversationListStore* self)
{
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	gtk_tree_model_foreach (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), _conversation_list_store_update_date_string_gtk_tree_model_foreach_func, self);
}

GearyAppConversation*
conversation_list_store_get_conversation_at_path (ConversationListStore* self,
                                                  GtkTreePath* path)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTreeIter _tmp2_;
	GearyAppConversation* _tmp3_;
	GearyAppConversation* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp1_ = gtk_tree_model_get_iter (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), &_tmp0_, path);
	iter = _tmp0_;
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = iter;
	_tmp3_ = conversation_list_store_get_conversation_at_iter (self, &_tmp2_);
	result = _tmp3_;
	return result;
}

static void
conversation_list_store_refresh_previews_async_data_free (gpointer _data)
{
	ConversationListStoreRefreshPreviewsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->conversation_monitor);
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationListStoreRefreshPreviewsAsyncData, _data_);
}

static void
conversation_list_store_refresh_previews_async (ConversationListStore* self,
                                                GearyAppConversationMonitor* conversation_monitor,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	ConversationListStoreRefreshPreviewsAsyncData* _data_;
	ConversationListStore* _tmp0_;
	GearyAppConversationMonitor* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation_monitor, GEARY_APP_TYPE_CONVERSATION_MONITOR));
	_data_ = g_slice_new0 (ConversationListStoreRefreshPreviewsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_list_store_refresh_previews_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (conversation_monitor);
	_g_object_unref0 (_data_->conversation_monitor);
	_data_->conversation_monitor = _tmp1_;
	conversation_list_store_refresh_previews_async_co (_data_);
}

static void
conversation_list_store_refresh_previews_finish (ConversationListStore* self,
                                                 GAsyncResult* _res_)
{
	ConversationListStoreRefreshPreviewsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
conversation_list_store_refresh_previews_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	ConversationListStoreRefreshPreviewsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_list_store_refresh_previews_async_co (_data_);
}

static gboolean
conversation_list_store_refresh_previews_async_co (ConversationListStoreRefreshPreviewsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = _data_->self->priv->refresh_mutex;
		_data_->_tmp2_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		geary_nonblocking_mutex_claim_async (_data_->_tmp1_, _data_->_tmp2_, conversation_list_store_refresh_previews_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = geary_nonblocking_mutex_claim_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->token = _data_->_tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->err;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_debug ("conversation-list-store.vala:162: Unable to claim refresh mutex: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->err);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->_preview_monitor;
	geary_progress_monitor_notify_start (_data_->_tmp5_);
	_data_->_state_ = 2;
	conversation_list_store_do_refresh_previews_async (_data_->self, _data_->conversation_monitor, conversation_list_store_refresh_previews_async_ready, _data_);
	return FALSE;
	_state_2:
	conversation_list_store_do_refresh_previews_finish (_data_->self, _data_->_res_);
	_data_->_tmp6_ = _data_->self->priv->_preview_monitor;
	geary_progress_monitor_notify_finish (_data_->_tmp6_);
	{
		_data_->_tmp7_ = _data_->self->priv->refresh_mutex;
		geary_nonblocking_mutex_release (_data_->_tmp7_, &_data_->token, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->_vala1_err;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_debug ("conversation-list-store.vala:176: Unable to release refresh mutex: %s", _data_->_tmp9_);
		_g_error_free0 (_data_->_vala1_err);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_list_store_do_refresh_previews_async_data_free (gpointer _data)
{
	ConversationListStoreDoRefreshPreviewsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->conversation_monitor);
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationListStoreDoRefreshPreviewsAsyncData, _data_);
}

static void
conversation_list_store_do_refresh_previews_async (ConversationListStore* self,
                                                   GearyAppConversationMonitor* conversation_monitor,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	ConversationListStoreDoRefreshPreviewsAsyncData* _data_;
	ConversationListStore* _tmp0_;
	GearyAppConversationMonitor* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation_monitor, GEARY_APP_TYPE_CONVERSATION_MONITOR));
	_data_ = g_slice_new0 (ConversationListStoreDoRefreshPreviewsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_list_store_do_refresh_previews_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (conversation_monitor);
	_g_object_unref0 (_data_->conversation_monitor);
	_data_->conversation_monitor = _tmp1_;
	conversation_list_store_do_refresh_previews_async_co (_data_);
}

static void
conversation_list_store_do_refresh_previews_finish (ConversationListStore* self,
                                                    GAsyncResult* _res_)
{
	ConversationListStoreDoRefreshPreviewsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
conversation_list_store_do_refresh_previews_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	ConversationListStoreDoRefreshPreviewsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_list_store_do_refresh_previews_async_co (_data_);
}

static gboolean
conversation_list_store_do_refresh_previews_async_co (ConversationListStoreDoRefreshPreviewsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->conversation_monitor == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp1_ = _data_->self->priv->config;
		_data_->_tmp2_ = application_configuration_get_display_preview (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp0_ = !_data_->_tmp3_;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = conversation_list_store_get_emails_needing_previews (_data_->self);
	_data_->needing_previews = _data_->_tmp4_;
	_data_->_tmp5_ = gee_array_list_new (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->emails = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->needing_previews;
	_data_->_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp8_ = _data_->_tmp7_;
	if (_data_->_tmp8_ > 0) {
		_data_->_tmp9_ = _data_->emails;
		_data_->_tmp10_ = _data_->needing_previews;
		_data_->_state_ = 1;
		conversation_list_store_do_get_previews_async (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), conversation_list_store_do_refresh_previews_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp11_ = conversation_list_store_do_get_previews_finish (_data_->self, _data_->_res_);
		_data_->_tmp12_ = _data_->_tmp11_;
		gee_array_list_add_all (_data_->_tmp9_, _data_->_tmp12_);
		_g_object_unref0 (_data_->_tmp12_);
	}
	_data_->_tmp13_ = _data_->emails;
	_data_->_tmp14_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_data_->_tmp15_ = _data_->_tmp14_;
	if (_data_->_tmp15_ < 1) {
		_g_object_unref0 (_data_->emails);
		_g_object_unref0 (_data_->needing_previews);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp16_ = _data_->emails;
		_data_->_email_list = _data_->_tmp16_;
		_data_->_tmp17_ = _data_->_email_list;
		_data_->_tmp18_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_email_size = _data_->_tmp19_;
		_data_->_email_index = -1;
		while (TRUE) {
			_data_->_email_index = _data_->_email_index + 1;
			_data_->_tmp20_ = _data_->_email_index;
			_data_->_tmp21_ = _data_->_email_size;
			if (!(_data_->_tmp20_ < _data_->_tmp21_)) {
				break;
			}
			_data_->_tmp22_ = _data_->_email_list;
			_data_->_tmp23_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_email_index);
			_data_->email = (GearyEmail*) _data_->_tmp23_;
			_data_->_tmp24_ = _data_->email;
			_data_->_tmp25_ = geary_email_get_id (_data_->_tmp24_);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp27_ = geary_app_conversation_monitor_get_by_email_identifier (_data_->conversation_monitor, _data_->_tmp26_);
			_data_->conversation = _data_->_tmp27_;
			_data_->_tmp28_ = _data_->conversation;
			if (_data_->_tmp28_ != NULL) {
				_data_->_tmp29_ = _data_->conversation;
				_data_->_tmp30_ = _data_->email;
				conversation_list_store_set_preview_for_conversation (_data_->self, _data_->_tmp29_, _data_->_tmp30_);
			}
			_g_object_unref0 (_data_->conversation);
			_g_object_unref0 (_data_->email);
		}
	}
	_g_object_unref0 (_data_->emails);
	_g_object_unref0 (_data_->needing_previews);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_list_store_do_get_previews_async_data_free (gpointer _data)
{
	ConversationListStoreDoGetPreviewsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->emails_needing_previews);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationListStoreDoGetPreviewsAsyncData, _data_);
}

static void
conversation_list_store_do_get_previews_async (ConversationListStore* self,
                                               GeeCollection* emails_needing_previews,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	ConversationListStoreDoGetPreviewsAsyncData* _data_;
	ConversationListStore* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emails_needing_previews, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (ConversationListStoreDoGetPreviewsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_list_store_do_get_previews_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (emails_needing_previews);
	_g_object_unref0 (_data_->emails_needing_previews);
	_data_->emails_needing_previews = _tmp1_;
	conversation_list_store_do_get_previews_async_co (_data_);
}

static GeeCollection*
conversation_list_store_do_get_previews_finish (ConversationListStore* self,
                                                GAsyncResult* _res_)
{
	GeeCollection* result;
	ConversationListStoreDoGetPreviewsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
conversation_list_store_do_get_previews_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	ConversationListStoreDoGetPreviewsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_list_store_do_get_previews_async_co (_data_);
}

static gboolean
conversation_list_store_do_get_previews_async_co (ConversationListStoreDoGetPreviewsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->loading_local_only) {
		_data_->_tmp0_ = GEARY_FOLDER_LIST_FLAGS_LOCAL_ONLY;
	} else {
		_data_->_tmp0_ = GEARY_FOLDER_LIST_FLAGS_NONE;
	}
	_data_->flags = _data_->_tmp0_;
	_data_->emails = NULL;
	{
		_data_->_tmp2_ = _data_->self->priv->email_store;
		_data_->_tmp3_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		geary_app_email_store_list_email_by_sparse_id_async (_data_->_tmp2_, _data_->emails_needing_previews, CONVERSATION_LIST_STORE_WITH_PREVIEW_FIELDS, _data_->flags, _data_->_tmp3_, conversation_list_store_do_get_previews_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = geary_app_email_store_list_email_by_sparse_id_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			if (g_error_matches (_data_->_inner_error0_, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND)) {
				goto __catch0_geary_engine_error_not_found;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_object_unref0 (_data_->emails);
		_data_->emails = _data_->_tmp5_;
		_g_object_unref0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_geary_engine_error_not_found:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->err;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("conversation-list-store.vala:218: Unable to fetch preview: %s", _data_->_tmp7_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->emails);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->emails;
	_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
	_data_->_tmp8_ = _data_->_tmp10_;
	if (_data_->_tmp8_ == NULL) {
		_data_->_tmp11_ = gee_array_list_new (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (_data_->_tmp8_);
		_data_->_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, GEE_TYPE_COLLECTION, GeeCollection);
	}
	_data_->_tmp12_ = _data_->_tmp8_;
	_data_->_tmp8_ = NULL;
	_data_->result = _data_->_tmp12_;
	_g_object_unref0 (_data_->_tmp8_);
	_g_object_unref0 (_data_->emails);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
_util_email_compare_conversation_descending_gcompare_data_func (gconstpointer a,
                                                                gconstpointer b,
                                                                gpointer self)
{
	gint result;
	result = util_email_compare_conversation_descending ((GearyAppConversation*) a, (GearyAppConversation*) b);
	return result;
}

static GeeSet*
conversation_list_store_get_emails_needing_previews (ConversationListStore* self)
{
	GeeSet* needing = NULL;
	GeeHashSet* _tmp0_;
	GeeArrayList* sorted_conversations = NULL;
	GearyAppConversationMonitor* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GearyIterable* _tmp5_;
	GearyIterable* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeSet* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), NULL);
	_tmp0_ = gee_hash_set_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	needing = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
	_tmp1_ = self->priv->_conversations;
	_tmp2_ = geary_app_conversation_monitor_get_read_only_view (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_traverse (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp6_ = _tmp5_;
	_tmp7_ = geary_iterable_to_sorted_list (_tmp6_, _util_email_compare_conversation_descending_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	sorted_conversations = _tmp8_;
	{
		GeeArrayList* _conversation_list = NULL;
		GeeArrayList* _tmp9_;
		gint _conversation_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _conversation_index = 0;
		_tmp9_ = sorted_conversations;
		_conversation_list = _tmp9_;
		_tmp10_ = _conversation_list;
		_tmp11_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp12_ = _tmp11_;
		_conversation_size = _tmp12_;
		_conversation_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			GearyAppConversation* conversation = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			GearyEmail* need_preview = NULL;
			GearyEmail* _tmp31_;
			GearyEmail* current_preview = NULL;
			GearyAppConversation* _tmp35_;
			GearyEmail* _tmp36_;
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			GearyEmail* _tmp39_;
			GeeSet* _tmp49_;
			GearyEmail* _tmp50_;
			GearyEmailIdentifier* _tmp51_;
			GearyEmailIdentifier* _tmp52_;
			_conversation_index = _conversation_index + 1;
			_tmp13_ = _conversation_index;
			_tmp14_ = _conversation_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _conversation_list;
			_tmp16_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _conversation_index);
			conversation = (GearyAppConversation*) _tmp16_;
			need_preview = NULL;
			{
				GeeList* _email_list = NULL;
				GearyAppConversation* _tmp17_;
				GeeList* _tmp18_;
				gint _email_size = 0;
				GeeList* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gint _email_index = 0;
				_tmp17_ = conversation;
				_tmp18_ = geary_app_conversation_get_emails (_tmp17_, GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_ASCENDING, GEARY_APP_CONVERSATION_LOCATION_ANYWHERE, NULL, TRUE);
				_email_list = _tmp18_;
				_tmp19_ = _email_list;
				_tmp20_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp21_ = _tmp20_;
				_email_size = _tmp21_;
				_email_index = -1;
				while (TRUE) {
					gint _tmp22_;
					gint _tmp23_;
					GearyEmail* email = NULL;
					GeeList* _tmp24_;
					gpointer _tmp25_;
					GearyEmail* _tmp26_;
					GearyEmailFlags* _tmp27_;
					GearyEmailFlags* _tmp28_;
					_email_index = _email_index + 1;
					_tmp22_ = _email_index;
					_tmp23_ = _email_size;
					if (!(_tmp22_ < _tmp23_)) {
						break;
					}
					_tmp24_ = _email_list;
					_tmp25_ = gee_list_get (_tmp24_, _email_index);
					email = (GearyEmail*) _tmp25_;
					_tmp26_ = email;
					_tmp27_ = geary_email_get_email_flags (_tmp26_);
					_tmp28_ = _tmp27_;
					if (geary_email_flags_is_unread (_tmp28_)) {
						GearyEmail* _tmp29_;
						GearyEmail* _tmp30_;
						_tmp29_ = email;
						_tmp30_ = _g_object_ref0 (_tmp29_);
						_g_object_unref0 (need_preview);
						need_preview = _tmp30_;
						_g_object_unref0 (email);
						break;
					}
					_g_object_unref0 (email);
				}
				_g_object_unref0 (_email_list);
			}
			_tmp31_ = need_preview;
			if (_tmp31_ == NULL) {
				GearyAppConversation* _tmp32_;
				GearyEmail* _tmp33_;
				GearyEmail* _tmp34_;
				_tmp32_ = conversation;
				_tmp33_ = geary_app_conversation_get_latest_recv_email (_tmp32_, GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER_OUT_OF_FOLDER, NULL);
				_g_object_unref0 (need_preview);
				need_preview = _tmp33_;
				_tmp34_ = need_preview;
				if (_tmp34_ == NULL) {
					_g_object_unref0 (need_preview);
					_g_object_unref0 (conversation);
					continue;
				}
			}
			_tmp35_ = conversation;
			_tmp36_ = conversation_list_store_get_preview_for_conversation (self, _tmp35_);
			current_preview = _tmp36_;
			_tmp39_ = current_preview;
			if (_tmp39_ != NULL) {
				GearyEmail* _tmp40_;
				GearyEmailIdentifier* _tmp41_;
				GearyEmailIdentifier* _tmp42_;
				GearyEmail* _tmp43_;
				GearyEmailIdentifier* _tmp44_;
				GearyEmailIdentifier* _tmp45_;
				_tmp40_ = need_preview;
				_tmp41_ = geary_email_get_id (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = current_preview;
				_tmp44_ = geary_email_get_id (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp38_ = geary_email_identifier_equal_to (_tmp42_, _tmp45_);
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				GearyEmail* _tmp46_;
				GearyEmailField _tmp47_;
				GearyEmailField _tmp48_;
				_tmp46_ = current_preview;
				_tmp47_ = geary_email_get_fields (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp37_ = geary_email_field_is_all_set (_tmp48_, CONVERSATION_LIST_STORE_WITH_PREVIEW_FIELDS);
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				_g_object_unref0 (current_preview);
				_g_object_unref0 (need_preview);
				_g_object_unref0 (conversation);
				continue;
			}
			_tmp49_ = needing;
			_tmp50_ = need_preview;
			_tmp51_ = geary_email_get_id (_tmp50_);
			_tmp52_ = _tmp51_;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_COLLECTION, GeeCollection), _tmp52_);
			_g_object_unref0 (current_preview);
			_g_object_unref0 (need_preview);
			_g_object_unref0 (conversation);
		}
	}
	result = needing;
	_g_object_unref0 (sorted_conversations);
	return result;
}

static GearyEmail*
conversation_list_store_get_preview_for_conversation (ConversationListStore* self,
                                                      GearyAppConversation* conversation)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	FormattedConversationData* message_data = NULL;
	GtkTreeIter _tmp2_;
	FormattedConversationData* _tmp3_;
	GearyEmail* _tmp4_ = NULL;
	FormattedConversationData* _tmp5_;
	GearyEmail* _tmp9_;
	GearyEmail* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION), NULL);
	_tmp1_ = conversation_list_store_get_iter_for_conversation (self, conversation, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		g_debug ("conversation-list-store.vala:271: Unable to find preview for conversat" \
"ion");
		result = NULL;
		return result;
	}
	_tmp2_ = iter;
	_tmp3_ = conversation_list_store_get_message_data_at_iter (self, &_tmp2_);
	message_data = _tmp3_;
	_tmp5_ = message_data;
	if (_tmp5_ == NULL) {
		_tmp4_ = NULL;
	} else {
		FormattedConversationData* _tmp6_;
		GearyEmail* _tmp7_;
		GearyEmail* _tmp8_;
		_tmp6_ = message_data;
		_tmp7_ = formatted_conversation_data_get_preview (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	}
	_tmp9_ = _g_object_ref0 (_tmp4_);
	result = _tmp9_;
	_g_object_unref0 (message_data);
	return result;
}

static void
conversation_list_store_set_preview_for_conversation (ConversationListStore* self,
                                                      GearyAppConversation* conversation,
                                                      GearyEmail* preview)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (preview, GEARY_TYPE_EMAIL));
	_tmp1_ = conversation_list_store_get_iter_for_conversation (self, conversation, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		GtkTreeIter _tmp2_;
		_tmp2_ = iter;
		conversation_list_store_set_row (self, &_tmp2_, conversation, preview);
	} else {
		g_debug ("conversation-list-store.vala:285: Unable to find preview for conversat" \
"ion");
	}
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
conversation_list_store_set_row (ConversationListStore* self,
                                 GtkTreeIter* iter,
                                 GearyAppConversation* conversation,
                                 GearyEmail* preview)
{
	FormattedConversationData* conversation_data = NULL;
	ApplicationConfiguration* _tmp0_;
	GearyAppConversationMonitor* _tmp1_;
	GearyFolder* _tmp2_;
	GearyFolder* _tmp3_;
	GearyAccount* _tmp4_;
	GearyAccount* _tmp5_;
	GearyAccountInformation* _tmp6_;
	GearyAccountInformation* _tmp7_;
	GeeList* _tmp8_;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
	FormattedConversationData* _tmp11_;
	FormattedConversationData* _tmp12_;
	GtkTreePath* path = NULL;
	GtkTreeIter _tmp13_;
	GtkTreePath* _tmp14_;
	ConversationListStoreRowWrapper* wrapper = NULL;
	ConversationListStoreRowWrapper* _tmp15_;
	GtkTreeIter _tmp16_;
	GeeHashMap* _tmp17_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (iter != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (preview, GEARY_TYPE_EMAIL));
	_tmp0_ = self->priv->config;
	_tmp1_ = self->priv->_conversations;
	_tmp2_ = geary_app_conversation_monitor_get_base_folder (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_folder_get_account (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_account_get_information (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = geary_account_information_get_sender_mailboxes (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = formatted_conversation_data_new (_tmp0_, conversation, preview, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	conversation_data = _tmp12_;
	_tmp13_ = *iter;
	_tmp14_ = gtk_tree_model_get_path (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), &_tmp13_);
	path = _tmp14_;
	_vala_assert (path != NULL, "path != null");
	_tmp15_ = conversation_list_store_row_wrapper_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), conversation, path);
	wrapper = _tmp15_;
	_tmp16_ = *iter;
	gtk_list_store_set (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_store_get_type (), GtkListStore), &_tmp16_, CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_DATA, conversation_data, CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_OBJECT, conversation, CONVERSATION_LIST_STORE_COLUMN_ROW_WRAPPER, wrapper, -1);
	_tmp17_ = self->priv->row_map;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), conversation, wrapper);
	_g_object_unref0 (wrapper);
	__vala_GtkTreePath_free0 (path);
	_g_object_unref0 (conversation_data);
}

static void
conversation_list_store_refresh_conversation (ConversationListStore* self,
                                              GearyAppConversation* conversation)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GearyEmail* last_email = NULL;
	GearyEmail* _tmp2_;
	GearyEmail* _tmp3_;
	GtkTreeIter _tmp4_;
	GearyEmail* _tmp5_;
	GtkTreePath* path = NULL;
	GtkTreeIter _tmp6_;
	GtkTreePath* _tmp7_;
	GtkTreePath* _tmp8_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION));
	_tmp1_ = conversation_list_store_get_iter_for_conversation (self, conversation, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		conversation_list_store_add_conversation (self, conversation);
		return;
	}
	_tmp2_ = geary_app_conversation_get_latest_recv_email (conversation, GEARY_APP_CONVERSATION_LOCATION_ANYWHERE, NULL);
	last_email = _tmp2_;
	_tmp3_ = last_email;
	if (_tmp3_ == NULL) {
		g_debug ("conversation-list-store.vala:319: Cannot refresh conversation: last em" \
"ail is null");
		gtk_list_store_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_store_get_type (), GtkListStore), &iter);
		_g_object_unref0 (last_email);
		return;
	}
	_tmp4_ = iter;
	_tmp5_ = last_email;
	conversation_list_store_set_row (self, &_tmp4_, conversation, _tmp5_);
	_tmp6_ = iter;
	_tmp7_ = gtk_tree_model_get_path (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), &_tmp6_);
	path = _tmp7_;
	_tmp8_ = path;
	if (_tmp8_ != NULL) {
		GtkTreePath* _tmp9_;
		GtkTreeIter _tmp10_;
		_tmp9_ = path;
		_tmp10_ = iter;
		gtk_tree_model_row_changed (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), _tmp9_, &_tmp10_);
	} else {
		g_debug ("conversation-list-store.vala:335: Cannot refresh conversation: no path" \
" for iterator");
	}
	__vala_GtkTreePath_free0 (path);
	_g_object_unref0 (last_email);
}

static void
conversation_list_store_refresh_flags (ConversationListStore* self,
                                       GearyAppConversation* conversation)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	FormattedConversationData* existing_message_data = NULL;
	GtkTreeIter _tmp2_;
	FormattedConversationData* _tmp3_;
	FormattedConversationData* _tmp4_;
	FormattedConversationData* _tmp5_;
	FormattedConversationData* _tmp6_;
	GtkTreePath* path = NULL;
	GtkTreeIter _tmp7_;
	GtkTreePath* _tmp8_;
	GtkTreePath* _tmp9_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION));
	_tmp1_ = conversation_list_store_get_iter_for_conversation (self, conversation, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		conversation_list_store_add_conversation (self, conversation);
		return;
	}
	_tmp2_ = iter;
	_tmp3_ = conversation_list_store_get_message_data_at_iter (self, &_tmp2_);
	existing_message_data = _tmp3_;
	_tmp4_ = existing_message_data;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (existing_message_data);
		return;
	}
	_tmp5_ = existing_message_data;
	formatted_conversation_data_set_is_unread (_tmp5_, geary_app_conversation_is_unread (conversation));
	_tmp6_ = existing_message_data;
	formatted_conversation_data_set_is_flagged (_tmp6_, geary_app_conversation_is_flagged (conversation));
	_tmp7_ = iter;
	_tmp8_ = gtk_tree_model_get_path (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), &_tmp7_);
	path = _tmp8_;
	_tmp9_ = path;
	if (_tmp9_ != NULL) {
		GtkTreePath* _tmp10_;
		GtkTreeIter _tmp11_;
		_tmp10_ = path;
		_tmp11_ = iter;
		gtk_tree_model_row_changed (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), _tmp10_, &_tmp11_);
	}
	__vala_GtkTreePath_free0 (path);
	_g_object_unref0 (existing_message_data);
}

GtkTreePath*
conversation_list_store_get_path_for_conversation (ConversationListStore* self,
                                                   GearyAppConversation* conversation)
{
	ConversationListStoreRowWrapper* wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GtkTreePath* _tmp2_ = NULL;
	ConversationListStoreRowWrapper* _tmp3_;
	GtkTreePath* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION), NULL);
	_tmp0_ = self->priv->row_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), conversation);
	wrapper = (ConversationListStoreRowWrapper*) _tmp1_;
	_tmp3_ = wrapper;
	if (_tmp3_ != NULL) {
		ConversationListStoreRowWrapper* _tmp4_;
		GtkTreePath* _tmp5_;
		_tmp4_ = wrapper;
		_tmp5_ = conversation_list_store_row_wrapper_get_path (_tmp4_);
		__vala_GtkTreePath_free0 (_tmp2_);
		_tmp2_ = _tmp5_;
	} else {
		__vala_GtkTreePath_free0 (_tmp2_);
		_tmp2_ = NULL;
	}
	result = _tmp2_;
	_g_object_unref0 (wrapper);
	return result;
}

static gboolean
conversation_list_store_get_iter_for_conversation (ConversationListStore* self,
                                                   GearyAppConversation* conversation,
                                                   GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	ConversationListStoreRowWrapper* wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	ConversationListStoreRowWrapper* _tmp2_;
	GtkTreeIter _tmp6_ = {0};
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION), FALSE);
	_tmp0_ = self->priv->row_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), conversation);
	wrapper = (ConversationListStoreRowWrapper*) _tmp1_;
	_tmp2_ = wrapper;
	if (_tmp2_ != NULL) {
		ConversationListStoreRowWrapper* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_;
		_tmp3_ = wrapper;
		_tmp5_ = conversation_list_store_row_wrapper_get_iter (_tmp3_, &_tmp4_);
		_vala_iter = _tmp4_;
		result = _tmp5_;
		_g_object_unref0 (wrapper);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	gtk_tree_model_get_iter_first (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), &_tmp6_);
	_vala_iter = _tmp6_;
	result = FALSE;
	_g_object_unref0 (wrapper);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
conversation_list_store_has_conversation (ConversationListStore* self,
                                          GearyAppConversation* conversation)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION), FALSE);
	_tmp0_ = self->priv->row_map;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), conversation);
	return result;
}

static GearyAppConversation*
conversation_list_store_get_conversation_at_iter (ConversationListStore* self,
                                                  GtkTreeIter* iter)
{
	GearyAppConversation* conversation = NULL;
	GtkTreeIter _tmp0_;
	GearyAppConversation* _tmp1_ = NULL;
	GearyAppConversation* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), &_tmp0_, CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_OBJECT, &_tmp1_, -1);
	_g_object_unref0 (conversation);
	conversation = _tmp1_;
	result = conversation;
	return result;
}

static FormattedConversationData*
conversation_list_store_get_message_data_at_iter (ConversationListStore* self,
                                                  GtkTreeIter* iter)
{
	FormattedConversationData* message_data = NULL;
	GtkTreeIter _tmp0_;
	FormattedConversationData* _tmp1_ = NULL;
	FormattedConversationData* result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), &_tmp0_, CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_DATA, &_tmp1_, -1);
	_g_object_unref0 (message_data);
	message_data = _tmp1_;
	result = message_data;
	return result;
}

static void
conversation_list_store_remove_conversation (ConversationListStore* self,
                                             GearyAppConversation* conversation)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION));
	_tmp1_ = conversation_list_store_get_iter_for_conversation (self, conversation, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		gtk_list_store_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_store_get_type (), GtkListStore), &iter);
	}
	_tmp2_ = self->priv->row_map;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), conversation, NULL);
}

static gboolean
conversation_list_store_add_conversation (ConversationListStore* self,
                                          GearyAppConversation* conversation)
{
	GearyEmail* last_email = NULL;
	GearyEmail* _tmp0_;
	GearyEmail* _tmp1_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp2_ = {0};
	GtkTreeIter _tmp3_;
	GearyEmail* _tmp4_;
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION), FALSE);
	_tmp0_ = geary_app_conversation_get_latest_recv_email (conversation, GEARY_APP_CONVERSATION_LOCATION_ANYWHERE, NULL);
	last_email = _tmp0_;
	_tmp1_ = last_email;
	if (_tmp1_ == NULL) {
		g_debug ("conversation-list-store.vala:409: Cannot add conversation: last email " \
"is null");
		result = FALSE;
		_g_object_unref0 (last_email);
		return result;
	}
	if (conversation_list_store_has_conversation (self, conversation)) {
		g_debug ("conversation-list-store.vala:415: Conversation already present; not ad" \
"ding");
		result = FALSE;
		_g_object_unref0 (last_email);
		return result;
	}
	gtk_list_store_append (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_store_get_type (), GtkListStore), &_tmp2_);
	iter = _tmp2_;
	_tmp3_ = iter;
	_tmp4_ = last_email;
	conversation_list_store_set_row (self, &_tmp3_, conversation, _tmp4_);
	result = TRUE;
	_g_object_unref0 (last_email);
	return result;
}

static void
conversation_list_store_on_scan_completed (ConversationListStore* self,
                                           GearyAppConversationMonitor* sender)
{
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sender, GEARY_APP_TYPE_CONVERSATION_MONITOR));
	conversation_list_store_refresh_previews_async (self, sender, NULL, NULL);
	self->priv->loading_local_only = FALSE;
}

static void
conversation_list_store_on_conversations_added (ConversationListStore* self,
                                                GeeCollection* conversations)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint added = 0;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversations, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_collection_get_size (conversations);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	g_signal_emit (self, conversation_list_store_signals[CONVERSATION_LIST_STORE_CONVERSATIONS_ADDED_SIGNAL], 0, TRUE);
	_tmp2_ = gee_collection_get_size (conversations);
	_tmp3_ = _tmp2_;
	g_debug ("conversation-list-store.vala:440: Adding %d conversations.", _tmp3_);
	added = 0;
	{
		GeeIterator* _conversation_it = NULL;
		GeeIterator* _tmp4_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (conversations, GEE_TYPE_ITERABLE, GeeIterable));
		_conversation_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GearyAppConversation* conversation = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GearyAppConversation* _tmp8_;
			_tmp5_ = _conversation_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _conversation_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			conversation = (GearyAppConversation*) _tmp7_;
			_tmp8_ = conversation;
			if (conversation_list_store_add_conversation (self, _tmp8_)) {
				gint _tmp9_;
				_tmp9_ = added;
				added = _tmp9_ + 1;
			}
			_g_object_unref0 (conversation);
		}
		_g_object_unref0 (_conversation_it);
	}
	_tmp10_ = gee_collection_get_size (conversations);
	_tmp11_ = _tmp10_;
	g_debug ("conversation-list-store.vala:446: Added %d/%d conversations.", added, _tmp11_);
	g_signal_emit (self, conversation_list_store_signals[CONVERSATION_LIST_STORE_CONVERSATIONS_ADDED_SIGNAL], 0, FALSE);
}

static void
conversation_list_store_on_conversations_removed (ConversationListStore* self,
                                                  GeeCollection* conversations)
{
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversations, GEE_TYPE_COLLECTION));
	g_signal_emit (self, conversation_list_store_signals[CONVERSATION_LIST_STORE_CONVERSATIONS_REMOVED_SIGNAL], 0, TRUE);
	{
		GeeIterator* _removed_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (conversations, GEE_TYPE_ITERABLE, GeeIterable));
		_removed_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			GearyAppConversation* removed = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GearyAppConversation* _tmp4_;
			_tmp1_ = _removed_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _removed_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			removed = (GearyAppConversation*) _tmp3_;
			_tmp4_ = removed;
			conversation_list_store_remove_conversation (self, _tmp4_);
			_g_object_unref0 (removed);
		}
		_g_object_unref0 (_removed_it);
	}
	g_signal_emit (self, conversation_list_store_signals[CONVERSATION_LIST_STORE_CONVERSATIONS_REMOVED_SIGNAL], 0, FALSE);
}

static void
conversation_list_store_on_conversation_appended (ConversationListStore* self,
                                                  GearyAppConversation* conversation)
{
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION));
	if (conversation_list_store_has_conversation (self, conversation)) {
		conversation_list_store_refresh_conversation (self, conversation);
	} else {
		conversation_list_store_add_conversation (self, conversation);
	}
}

static void
conversation_list_store_on_conversation_trimmed (ConversationListStore* self,
                                                 GearyAppConversation* conversation)
{
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION));
	conversation_list_store_refresh_conversation (self, conversation);
}

static void
conversation_list_store_on_display_preview_changed (ConversationListStore* self)
{
	GearyAppConversationMonitor* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	_tmp0_ = self->priv->_conversations;
	conversation_list_store_refresh_previews_async (self, _tmp0_, NULL, NULL);
}

static void
conversation_list_store_on_email_flags_changed (ConversationListStore* self,
                                                GearyAppConversation* conversation)
{
	GearyAppConversationMonitor* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_LIST_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION));
	conversation_list_store_refresh_flags (self, conversation);
	_tmp0_ = self->priv->_conversations;
	conversation_list_store_refresh_previews_async (self, _tmp0_, NULL, NULL);
}

static gboolean
conversation_list_store_update_date_string (ConversationListStore* self,
                                            GtkTreeModel* model,
                                            GtkTreePath* path,
                                            GtkTreeIter* iter)
{
	FormattedConversationData* message_data = NULL;
	GtkTreeIter _tmp0_;
	FormattedConversationData* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	FormattedConversationData* _tmp3_;
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_LIST_STORE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()), FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, CONVERSATION_LIST_STORE_COLUMN_CONVERSATION_DATA, &_tmp1_, -1);
	_g_object_unref0 (message_data);
	message_data = _tmp1_;
	_tmp3_ = message_data;
	if (_tmp3_ != NULL) {
		FormattedConversationData* _tmp4_;
		_tmp4_ = message_data;
		_tmp2_ = formatted_conversation_data_update_date_string (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkTreeIter _tmp5_;
		_tmp5_ = *iter;
		gtk_tree_model_row_changed (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_get_type (), GtkTreeModel), path, &_tmp5_);
	}
	result = FALSE;
	_g_object_unref0 (message_data);
	return result;
}

static void
_vala_GtkTreeRowReference_free (GtkTreeRowReference* self)
{
	g_boxed_free (gtk_tree_row_reference_get_type (), self);
}

static ConversationListStoreRowWrapper*
conversation_list_store_row_wrapper_construct (GType object_type,
                                               GtkTreeModel* model,
                                               GearyAppConversation* conversation,
                                               GtkTreePath* path)
{
	ConversationListStoreRowWrapper * self = NULL;
	GearyAppConversation* _tmp0_;
	GtkTreeRowReference* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION), NULL);
	g_return_val_if_fail (path != NULL, NULL);
	self = (ConversationListStoreRowWrapper*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (conversation);
	_g_object_unref0 (self->conversation);
	self->conversation = _tmp0_;
	_tmp1_ = gtk_tree_row_reference_new (model, path);
	__vala_GtkTreeRowReference_free0 (self->row);
	self->row = _tmp1_;
	return self;
}

static ConversationListStoreRowWrapper*
conversation_list_store_row_wrapper_new (GtkTreeModel* model,
                                         GearyAppConversation* conversation,
                                         GtkTreePath* path)
{
	return conversation_list_store_row_wrapper_construct (CONVERSATION_LIST_STORE_TYPE_ROW_WRAPPER, model, conversation, path);
}

static GtkTreePath*
conversation_list_store_row_wrapper_get_path (ConversationListStoreRowWrapper* self)
{
	GtkTreeRowReference* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* result;
	g_return_val_if_fail (CONVERSATION_LIST_STORE_IS_ROW_WRAPPER (self), NULL);
	_tmp0_ = self->row;
	_tmp1_ = gtk_tree_row_reference_get_path (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
conversation_list_store_row_wrapper_get_iter (ConversationListStoreRowWrapper* self,
                                              GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	GtkTreeRowReference* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (CONVERSATION_LIST_STORE_IS_ROW_WRAPPER (self), FALSE);
	_tmp0_ = self->row;
	_tmp1_ = gtk_tree_row_reference_get_model (_tmp0_);
	_tmp2_ = conversation_list_store_row_wrapper_get_path (self);
	_tmp3_ = _tmp2_;
	_tmp5_ = gtk_tree_model_get_iter (_tmp1_, &_tmp4_, _tmp3_);
	_vala_iter = _tmp4_;
	_tmp6_ = _tmp5_;
	__vala_GtkTreePath_free0 (_tmp3_);
	result = _tmp6_;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static void
conversation_list_store_row_wrapper_class_init (ConversationListStoreRowWrapperClass * klass,
                                                gpointer klass_data)
{
	conversation_list_store_row_wrapper_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = conversation_list_store_row_wrapper_finalize;
}

static void
conversation_list_store_row_wrapper_instance_init (ConversationListStoreRowWrapper * self,
                                                   gpointer klass)
{
}

static void
conversation_list_store_row_wrapper_finalize (GObject * obj)
{
	ConversationListStoreRowWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONVERSATION_LIST_STORE_TYPE_ROW_WRAPPER, ConversationListStoreRowWrapper);
	_g_object_unref0 (self->conversation);
	__vala_GtkTreeRowReference_free0 (self->row);
	G_OBJECT_CLASS (conversation_list_store_row_wrapper_parent_class)->finalize (obj);
}

static GType
conversation_list_store_row_wrapper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationListStoreRowWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_list_store_row_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationListStoreRowWrapper), 0, (GInstanceInitFunc) conversation_list_store_row_wrapper_instance_init, NULL };
	GType conversation_list_store_row_wrapper_type_id;
	conversation_list_store_row_wrapper_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ConversationListStoreRowWrapper", &g_define_type_info, 0);
	return conversation_list_store_row_wrapper_type_id;
}

static GType
conversation_list_store_row_wrapper_get_type (void)
{
	static volatile gsize conversation_list_store_row_wrapper_type_id__once = 0;
	if (g_once_init_enter (&conversation_list_store_row_wrapper_type_id__once)) {
		GType conversation_list_store_row_wrapper_type_id;
		conversation_list_store_row_wrapper_type_id = conversation_list_store_row_wrapper_get_type_once ();
		g_once_init_leave (&conversation_list_store_row_wrapper_type_id__once, conversation_list_store_row_wrapper_type_id);
	}
	return conversation_list_store_row_wrapper_type_id__once;
}

static void
conversation_list_store_class_init (ConversationListStoreClass * klass,
                                    gpointer klass_data)
{
	conversation_list_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConversationListStore_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_conversation_list_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_conversation_list_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = conversation_list_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_LIST_STORE_CONVERSATIONS_PROPERTY, conversation_list_store_properties[CONVERSATION_LIST_STORE_CONVERSATIONS_PROPERTY] = g_param_spec_object ("conversations", "conversations", "conversations", GEARY_APP_TYPE_CONVERSATION_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_LIST_STORE_PREVIEW_MONITOR_PROPERTY, conversation_list_store_properties[CONVERSATION_LIST_STORE_PREVIEW_MONITOR_PROPERTY] = g_param_spec_object ("preview-monitor", "preview-monitor", "preview-monitor", GEARY_TYPE_PROGRESS_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	conversation_list_store_signals[CONVERSATION_LIST_STORE_CONVERSATIONS_ADDED_SIGNAL] = g_signal_new ("conversations-added", TYPE_CONVERSATION_LIST_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	conversation_list_store_signals[CONVERSATION_LIST_STORE_CONVERSATIONS_REMOVED_SIGNAL] = g_signal_new ("conversations-removed", TYPE_CONVERSATION_LIST_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
conversation_list_store_instance_init (ConversationListStore * self,
                                       gpointer klass)
{
	GearySimpleProgressMonitor* _tmp0_;
	GeeHashMap* _tmp1_;
	GCancellable* _tmp2_;
	GearyNonblockingMutex* _tmp3_;
	self->priv = conversation_list_store_get_instance_private (self);
	_tmp0_ = geary_simple_progress_monitor_new (GEARY_PROGRESS_TYPE_ACTIVITY);
	self->priv->_preview_monitor = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor);
	_tmp1_ = gee_hash_map_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, CONVERSATION_LIST_STORE_TYPE_ROW_WRAPPER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->row_map = _tmp1_;
	self->priv->email_store = NULL;
	_tmp2_ = g_cancellable_new ();
	self->priv->cancellable = _tmp2_;
	self->priv->loading_local_only = TRUE;
	_tmp3_ = geary_nonblocking_mutex_new ();
	self->priv->refresh_mutex = _tmp3_;
}

static void
conversation_list_store_finalize (GObject * obj)
{
	ConversationListStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONVERSATION_LIST_STORE, ConversationListStore);
	_g_object_unref0 (self->priv->_conversations);
	_g_object_unref0 (self->priv->_preview_monitor);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->row_map);
	_g_object_unref0 (self->priv->email_store);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->refresh_mutex);
	G_OBJECT_CLASS (conversation_list_store_parent_class)->finalize (obj);
}

/**
 * A Gtk.ListStore of sorted {@link Geary.App.Conversation}s.
 *
 * Conversations are sorted by {@link Geary.EmailProperties.date_received} (IMAP's INTERNALDATE)
 * rather than the Date: header, as that ensures newly received email sort to the top where the
 * user expects to see them.  The ConversationViewer sorts by the Date: header, as that presents
 * better to the user.
 */
static GType
conversation_list_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationListStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_list_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationListStore), 0, (GInstanceInitFunc) conversation_list_store_instance_init, NULL };
	GType conversation_list_store_type_id;
	conversation_list_store_type_id = g_type_register_static (gtk_list_store_get_type (), "ConversationListStore", &g_define_type_info, 0);
	ConversationListStore_private_offset = g_type_add_instance_private (conversation_list_store_type_id, sizeof (ConversationListStorePrivate));
	return conversation_list_store_type_id;
}

GType
conversation_list_store_get_type (void)
{
	static volatile gsize conversation_list_store_type_id__once = 0;
	if (g_once_init_enter (&conversation_list_store_type_id__once)) {
		GType conversation_list_store_type_id;
		conversation_list_store_type_id = conversation_list_store_get_type_once ();
		g_once_init_leave (&conversation_list_store_type_id__once, conversation_list_store_type_id);
	}
	return conversation_list_store_type_id__once;
}

static void
_vala_conversation_list_store_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ConversationListStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CONVERSATION_LIST_STORE, ConversationListStore);
	switch (property_id) {
		case CONVERSATION_LIST_STORE_CONVERSATIONS_PROPERTY:
		g_value_set_object (value, conversation_list_store_get_conversations (self));
		break;
		case CONVERSATION_LIST_STORE_PREVIEW_MONITOR_PROPERTY:
		g_value_set_object (value, conversation_list_store_get_preview_monitor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_conversation_list_store_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ConversationListStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CONVERSATION_LIST_STORE, ConversationListStore);
	switch (property_id) {
		case CONVERSATION_LIST_STORE_CONVERSATIONS_PROPERTY:
		conversation_list_store_set_conversations (self, g_value_get_object (value));
		break;
		case CONVERSATION_LIST_STORE_PREVIEW_MONITOR_PROPERTY:
		conversation_list_store_set_preview_monitor (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

