/* formatted-conversation-data.c generated by valac 0.56.3, the Vala compiler
 * generated from formatted-conversation-data.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* Stores formatted data for a message.*/

#include "geary-client-43.0.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "geary-engine.h"
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pangocairo.h>

#define FORMATTED_CONVERSATION_DATA_ME _ ("Me")
#define FORMATTED_CONVERSATION_DATA_STYLE_EXAMPLE "Gg"
#define FORMATTED_CONVERSATION_DATA_TEXT_LEFT ((FORMATTED_CONVERSATION_DATA_SPACING * 2) + ICON_FACTORY_UNREAD_ICON_SIZE)
#define FORMATTED_CONVERSATION_DATA_DIM_TEXT_AMOUNT 0.05
#define FORMATTED_CONVERSATION_DATA_DIM_PREVIEW_TEXT_AMOUNT 0.25

#define FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANTS (formatted_conversation_data_participants_get_type ())
typedef struct _FormattedConversationDataParticipants FormattedConversationDataParticipants;
enum  {
	FORMATTED_CONVERSATION_DATA_0_PROPERTY,
	FORMATTED_CONVERSATION_DATA_IS_UNREAD_PROPERTY,
	FORMATTED_CONVERSATION_DATA_IS_FLAGGED_PROPERTY,
	FORMATTED_CONVERSATION_DATA_DATE_PROPERTY,
	FORMATTED_CONVERSATION_DATA_BODY_PROPERTY,
	FORMATTED_CONVERSATION_DATA_NUM_EMAILS_PROPERTY,
	FORMATTED_CONVERSATION_DATA_PREVIEW_PROPERTY,
	FORMATTED_CONVERSATION_DATA_NUM_PROPERTIES
};
static GParamSpec* formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANT_DISPLAY (formatted_conversation_data_participant_display_get_type ())
#define FORMATTED_CONVERSATION_DATA_PARTICIPANT_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANT_DISPLAY, FormattedConversationDataParticipantDisplay))
#define FORMATTED_CONVERSATION_DATA_PARTICIPANT_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANT_DISPLAY, FormattedConversationDataParticipantDisplayClass))
#define FORMATTED_CONVERSATION_DATA_IS_PARTICIPANT_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANT_DISPLAY))
#define FORMATTED_CONVERSATION_DATA_IS_PARTICIPANT_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANT_DISPLAY))
#define FORMATTED_CONVERSATION_DATA_PARTICIPANT_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANT_DISPLAY, FormattedConversationDataParticipantDisplayClass))

typedef struct _FormattedConversationDataParticipantDisplay FormattedConversationDataParticipantDisplay;
typedef struct _FormattedConversationDataParticipantDisplayClass FormattedConversationDataParticipantDisplayClass;
typedef struct _FormattedConversationDataParticipantDisplayPrivate FormattedConversationDataParticipantDisplayPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	FORMATTED_CONVERSATION_DATA_PARTICIPANT_DISPLAY_0_PROPERTY,
	FORMATTED_CONVERSATION_DATA_PARTICIPANT_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* formatted_conversation_data_participant_display_properties[FORMATTED_CONVERSATION_DATA_PARTICIPANT_DISPLAY_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FormattedConversationDataParticipants {
	gchar* markup;
	gboolean was_widget_selected;
};

struct _FormattedConversationDataPrivate {
	gboolean _is_unread;
	gboolean _is_flagged;
	gchar* _date;
	gchar* _body;
	gint _num_emails;
	GearyEmail* _preview;
	ApplicationConfiguration* config;
	GtkSettings* gtk;
	PangoFontDescription* font;
	GearyAppConversation* conversation;
	GeeList* account_owner_emails;
	gboolean use_to;
	CountBadge* count_badge;
	gchar* subject_html_escaped;
	FormattedConversationDataParticipants participants;
};

struct _FormattedConversationDataParticipantDisplay {
	GearyBaseObject parent_instance;
	GearyRFC822MailboxAddress* address;
	gboolean is_unread;
	FormattedConversationDataParticipantDisplayPrivate * priv;
};

struct _FormattedConversationDataParticipantDisplayClass {
	GearyBaseObjectClass parent_class;
};

static gint FormattedConversationData_private_offset;
static gpointer formatted_conversation_data_parent_class = NULL;
static gint formatted_conversation_data_cell_height;
static gint formatted_conversation_data_cell_height = -1;
static gint formatted_conversation_data_preview_height;
static gint formatted_conversation_data_preview_height = -1;
static gpointer formatted_conversation_data_participant_display_parent_class = NULL;
static GeeHashableIface * formatted_conversation_data_participant_display_gee_hashable_parent_iface = NULL;

static GType formatted_conversation_data_participants_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static FormattedConversationDataParticipants* formatted_conversation_data_participants_dup (const FormattedConversationDataParticipants* self);
static void formatted_conversation_data_participants_free (FormattedConversationDataParticipants* self);
static void formatted_conversation_data_participants_copy (const FormattedConversationDataParticipants* self,
                                                    FormattedConversationDataParticipants* dest);
static void formatted_conversation_data_participants_destroy (FormattedConversationDataParticipants* self);
static void formatted_conversation_data_set_date (FormattedConversationData* self,
                                           const gchar* value);
static void formatted_conversation_data_set_body (FormattedConversationData* self,
                                           const gchar* value);
static void formatted_conversation_data_set_preview (FormattedConversationData* self,
                                              GearyEmail* value);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void formatted_conversation_data_update_font (FormattedConversationData* self);
static void _formatted_conversation_data_update_font_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void formatted_conversation_data_clear_participants_cache (FormattedConversationData* self,
                                                           GearyEmail* email);
static void _formatted_conversation_data_clear_participants_cache_geary_app_conversation_appended (GearyAppConversation* _sender,
                                                                                            GearyEmail* email,
                                                                                            gpointer self);
static void _formatted_conversation_data_clear_participants_cache_geary_app_conversation_trimmed (GearyAppConversation* _sender,
                                                                                           GearyEmail* email,
                                                                                           gpointer self);
static void _formatted_conversation_data_clear_participants_cache_geary_app_conversation_email_flags_changed (GearyAppConversation* _sender,
                                                                                                       GearyEmail* email,
                                                                                                       gpointer self);
static guint8 formatted_conversation_data_gdk_to_rgb (FormattedConversationData* self,
                                               gdouble gdk);
static void formatted_conversation_data_dim_rgba (FormattedConversationData* self,
                                           GdkRGBA* rgba,
                                           gdouble amount,
                                           GdkRGBA* result);
static gchar* formatted_conversation_data_rgba_to_markup (FormattedConversationData* self,
                                                   GdkRGBA* rgba);
static void formatted_conversation_data_get_foreground_rgba (FormattedConversationData* self,
                                                      GtkWidget* widget,
                                                      gboolean selected,
                                                      GdkRGBA* result);
static gchar* formatted_conversation_data_get_participants_markup (FormattedConversationData* self,
                                                            GtkWidget* widget,
                                                            gboolean selected);
static GType formatted_conversation_data_participant_display_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static FormattedConversationDataParticipantDisplay* formatted_conversation_data_participant_display_new (GearyRFC822MailboxAddress* address,
                                                                                                  gboolean is_unread);
static FormattedConversationDataParticipantDisplay* formatted_conversation_data_participant_display_construct (GType object_type,
                                                                                                        GearyRFC822MailboxAddress* address,
                                                                                                        gboolean is_unread);
static gchar* formatted_conversation_data_participant_display_get_full_markup (FormattedConversationDataParticipantDisplay* self,
                                                                        GeeList* account_mailboxes);
static gchar* formatted_conversation_data_participant_display_get_short_markup (FormattedConversationDataParticipantDisplay* self,
                                                                         GeeList* account_mailboxes);
static void formatted_conversation_data_render_internal (FormattedConversationData* self,
                                                  GtkWidget* widget,
                                                  GdkRectangle* cell_area,
                                                  cairo_t* ctx,
                                                  GtkCellRendererState flags,
                                                  gboolean recalc_dims,
                                                  gboolean hover_select);
static void formatted_conversation_data_render_date (FormattedConversationData* self,
                                              GtkWidget* widget,
                                              GdkRectangle* cell_area,
                                              cairo_t* ctx,
                                              gint y,
                                              gboolean selected,
                                              PangoRectangle* result);
static void formatted_conversation_data_render_from (FormattedConversationData* self,
                                              GtkWidget* widget,
                                              GdkRectangle* cell_area,
                                              cairo_t* ctx,
                                              gint y,
                                              gboolean selected,
                                              PangoRectangle* ink_rect,
                                              PangoRectangle* result);
static void formatted_conversation_data_render_subject (FormattedConversationData* self,
                                                 GtkWidget* widget,
                                                 GdkRectangle* cell_area,
                                                 cairo_t* ctx,
                                                 gint y,
                                                 gboolean selected,
                                                 gint counter_width);
static void formatted_conversation_data_render_preview (FormattedConversationData* self,
                                                 GtkWidget* widget,
                                                 GdkRectangle* cell_area,
                                                 cairo_t* ctx,
                                                 gint y,
                                                 gboolean selected,
                                                 gint counter_width,
                                                 PangoRectangle* result);
static PangoRectangle* _pango_rectangle_dup (PangoRectangle* self);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static gchar* formatted_conversation_data_participant_display_get_as_markup (FormattedConversationDataParticipantDisplay* self,
                                                                      const gchar* participant);
static gboolean formatted_conversation_data_participant_display_real_equal_to (GeeHashable* base,
                                                                        FormattedConversationDataParticipantDisplay* other);
static guint formatted_conversation_data_participant_display_real_hash (GeeHashable* base);
static void formatted_conversation_data_participant_display_finalize (GObject * obj);
static GType formatted_conversation_data_participant_display_get_type_once (void);
static void formatted_conversation_data_finalize (GObject * obj);
static GType formatted_conversation_data_get_type_once (void);
static void _vala_formatted_conversation_data_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_formatted_conversation_data_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
formatted_conversation_data_get_instance_private (FormattedConversationData* self)
{
	return G_STRUCT_MEMBER_P (self, FormattedConversationData_private_offset);
}

gboolean
formatted_conversation_data_get_is_unread (FormattedConversationData* self)
{
	gboolean result;
	g_return_val_if_fail (IS_FORMATTED_CONVERSATION_DATA (self), FALSE);
	result = self->priv->_is_unread;
	return result;
}

void
formatted_conversation_data_set_is_unread (FormattedConversationData* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	old_value = formatted_conversation_data_get_is_unread (self);
	if (old_value != value) {
		self->priv->_is_unread = value;
		g_object_notify_by_pspec ((GObject *) self, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_IS_UNREAD_PROPERTY]);
	}
}

gboolean
formatted_conversation_data_get_is_flagged (FormattedConversationData* self)
{
	gboolean result;
	g_return_val_if_fail (IS_FORMATTED_CONVERSATION_DATA (self), FALSE);
	result = self->priv->_is_flagged;
	return result;
}

void
formatted_conversation_data_set_is_flagged (FormattedConversationData* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	old_value = formatted_conversation_data_get_is_flagged (self);
	if (old_value != value) {
		self->priv->_is_flagged = value;
		g_object_notify_by_pspec ((GObject *) self, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_IS_FLAGGED_PROPERTY]);
	}
}

const gchar*
formatted_conversation_data_get_date (FormattedConversationData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (IS_FORMATTED_CONVERSATION_DATA (self), NULL);
	_tmp0_ = self->priv->_date;
	result = _tmp0_;
	return result;
}

static void
formatted_conversation_data_set_date (FormattedConversationData* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	old_value = formatted_conversation_data_get_date (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_date);
		self->priv->_date = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_DATE_PROPERTY]);
	}
}

const gchar*
formatted_conversation_data_get_body (FormattedConversationData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (IS_FORMATTED_CONVERSATION_DATA (self), NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

static void
formatted_conversation_data_set_body (FormattedConversationData* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	old_value = formatted_conversation_data_get_body (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_body);
		self->priv->_body = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_BODY_PROPERTY]);
	}
}

gint
formatted_conversation_data_get_num_emails (FormattedConversationData* self)
{
	gint result;
	g_return_val_if_fail (IS_FORMATTED_CONVERSATION_DATA (self), 0);
	result = self->priv->_num_emails;
	return result;
}

void
formatted_conversation_data_set_num_emails (FormattedConversationData* self,
                                            gint value)
{
	gint old_value;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	old_value = formatted_conversation_data_get_num_emails (self);
	if (old_value != value) {
		self->priv->_num_emails = value;
		g_object_notify_by_pspec ((GObject *) self, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_NUM_EMAILS_PROPERTY]);
	}
}

GearyEmail*
formatted_conversation_data_get_preview (FormattedConversationData* self)
{
	GearyEmail* result;
	GearyEmail* _tmp0_;
	g_return_val_if_fail (IS_FORMATTED_CONVERSATION_DATA (self), NULL);
	_tmp0_ = self->priv->_preview;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
formatted_conversation_data_set_preview (FormattedConversationData* self,
                                         GearyEmail* value)
{
	GearyEmail* old_value;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	old_value = formatted_conversation_data_get_preview (self);
	if (old_value != value) {
		GearyEmail* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_preview);
		self->priv->_preview = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_PREVIEW_PROPERTY]);
	}
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
_formatted_conversation_data_update_font_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	formatted_conversation_data_update_font ((FormattedConversationData*) self);
}

static void
_formatted_conversation_data_clear_participants_cache_geary_app_conversation_appended (GearyAppConversation* _sender,
                                                                                       GearyEmail* email,
                                                                                       gpointer self)
{
	formatted_conversation_data_clear_participants_cache ((FormattedConversationData*) self, email);
}

static void
_formatted_conversation_data_clear_participants_cache_geary_app_conversation_trimmed (GearyAppConversation* _sender,
                                                                                      GearyEmail* email,
                                                                                      gpointer self)
{
	formatted_conversation_data_clear_participants_cache ((FormattedConversationData*) self, email);
}

static void
_formatted_conversation_data_clear_participants_cache_geary_app_conversation_email_flags_changed (GearyAppConversation* _sender,
                                                                                                  GearyEmail* email,
                                                                                                  gpointer self)
{
	formatted_conversation_data_clear_participants_cache ((FormattedConversationData*) self, email);
}

FormattedConversationData*
formatted_conversation_data_construct (GType object_type,
                                       ApplicationConfiguration* config,
                                       GearyAppConversation* conversation,
                                       GearyEmail* preview,
                                       GeeList* account_owner_emails)
{
	FormattedConversationData * self = NULL;
	ApplicationConfiguration* _tmp0_;
	GtkSettings* _tmp1_;
	GtkSettings* _tmp2_;
	GearyAppConversation* _tmp3_;
	GeeList* _tmp4_;
	GearyFolder* _tmp5_;
	GearyFolder* _tmp6_;
	GearyFolderSpecialUse _tmp7_;
	GearyFolderSpecialUse _tmp8_;
	GtkSettings* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GearyAppConversation* _tmp17_;
	GearyAppConversation* _tmp18_;
	GearyAppConversation* _tmp19_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (preview, GEARY_TYPE_EMAIL), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account_owner_emails, GEE_TYPE_LIST), NULL);
	self = (FormattedConversationData*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp0_;
	_tmp1_ = gtk_settings_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->gtk);
	self->priv->gtk = _tmp2_;
	_tmp3_ = _g_object_ref0 (conversation);
	_g_object_unref0 (self->priv->conversation);
	self->priv->conversation = _tmp3_;
	_tmp4_ = _g_object_ref0 (account_owner_emails);
	_g_object_unref0 (self->priv->account_owner_emails);
	self->priv->account_owner_emails = _tmp4_;
	_tmp5_ = geary_app_conversation_get_base_folder (conversation);
	_tmp6_ = _tmp5_;
	_tmp7_ = geary_folder_get_used_as (_tmp6_);
	_tmp8_ = _tmp7_;
	self->priv->use_to = geary_folder_special_use_is_outgoing (_tmp8_);
	_tmp9_ = self->priv->gtk;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, G_TYPE_OBJECT, GObject), "notify::gtk-font-name", (GCallback) _formatted_conversation_data_update_font_g_object_notify, self, 0);
	formatted_conversation_data_update_font (self);
	formatted_conversation_data_update_date_string (self);
	_tmp10_ = util_email_strip_subject_prefixes (G_TYPE_CHECK_INSTANCE_CAST (preview, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp11_ = _tmp10_;
	_tmp12_ = geary_html_escape_markup (_tmp11_);
	_g_free0 (self->priv->subject_html_escaped);
	self->priv->subject_html_escaped = _tmp12_;
	_g_free0 (_tmp11_);
	_tmp13_ = geary_email_get_preview_as_string (preview);
	_tmp14_ = _tmp13_;
	_tmp15_ = geary_string_reduce_whitespace (_tmp14_);
	_tmp16_ = _tmp15_;
	formatted_conversation_data_set_body (self, _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	formatted_conversation_data_set_preview (self, preview);
	formatted_conversation_data_set_is_unread (self, geary_app_conversation_is_unread (conversation));
	formatted_conversation_data_set_is_flagged (self, geary_app_conversation_is_flagged (conversation));
	formatted_conversation_data_set_num_emails (self, geary_app_conversation_get_count (conversation));
	_tmp17_ = self->priv->conversation;
	g_signal_connect_object (_tmp17_, "appended", (GCallback) _formatted_conversation_data_clear_participants_cache_geary_app_conversation_appended, self, 0);
	_tmp18_ = self->priv->conversation;
	g_signal_connect_object (_tmp18_, "trimmed", (GCallback) _formatted_conversation_data_clear_participants_cache_geary_app_conversation_trimmed, self, 0);
	_tmp19_ = self->priv->conversation;
	g_signal_connect_object (_tmp19_, "email-flags-changed", (GCallback) _formatted_conversation_data_clear_participants_cache_geary_app_conversation_email_flags_changed, self, 0);
	return self;
}

FormattedConversationData*
formatted_conversation_data_new (ApplicationConfiguration* config,
                                 GearyAppConversation* conversation,
                                 GearyEmail* preview,
                                 GeeList* account_owner_emails)
{
	return formatted_conversation_data_construct (TYPE_FORMATTED_CONVERSATION_DATA, config, conversation, preview, account_owner_emails);
}

FormattedConversationData*
formatted_conversation_data_construct_create_example (GType object_type,
                                                      ApplicationConfiguration* config)
{
	FormattedConversationData * self = NULL;
	ApplicationConfiguration* _tmp0_;
	gchar* _tmp1_;
	ApplicationConfiguration* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	PangoFontDescription* _tmp7_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	self = (FormattedConversationData*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp0_;
	formatted_conversation_data_set_is_unread (self, FALSE);
	formatted_conversation_data_set_is_flagged (self, FALSE);
	formatted_conversation_data_set_date (self, FORMATTED_CONVERSATION_DATA_STYLE_EXAMPLE);
	_tmp1_ = g_strdup (FORMATTED_CONVERSATION_DATA_STYLE_EXAMPLE);
	_g_free0 (self->priv->subject_html_escaped);
	self->priv->subject_html_escaped = _tmp1_;
	formatted_conversation_data_set_body (self, FORMATTED_CONVERSATION_DATA_STYLE_EXAMPLE "\n" FORMATTED_CONVERSATION_DATA_STYLE_EXAMPLE);
	formatted_conversation_data_set_num_emails (self, 1);
	_tmp2_ = self->priv->config;
	_tmp3_ = application_configuration_get_gnome_interface (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_settings_get_string (_tmp4_, "font-name");
	_tmp6_ = _tmp5_;
	_tmp7_ = pango_font_description_from_string (_tmp6_);
	__vala_PangoFontDescription_free0 (self->priv->font);
	self->priv->font = _tmp7_;
	_g_free0 (_tmp6_);
	return self;
}

FormattedConversationData*
formatted_conversation_data_new_create_example (ApplicationConfiguration* config)
{
	return formatted_conversation_data_construct_create_example (TYPE_FORMATTED_CONVERSATION_DATA, config);
}

static void
formatted_conversation_data_clear_participants_cache (FormattedConversationData* self,
                                                      GearyEmail* email)
{
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, GEARY_TYPE_EMAIL));
	_g_free0 (self->priv->participants.markup);
	self->priv->participants.markup = NULL;
}

gboolean
formatted_conversation_data_update_date_string (FormattedConversationData* self)
{
	GearyEmail* latest = NULL;
	GearyAppConversation* _tmp0_;
	GearyEmail* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GearyEmail* _tmp3_;
	gchar* new_date = NULL;
	GearyEmail* _tmp7_;
	GearyEmailProperties* _tmp8_;
	GearyEmailProperties* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	ApplicationConfiguration* _tmp14_;
	UtilDateClockFormat _tmp15_;
	UtilDateClockFormat _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gboolean result;
	g_return_val_if_fail (IS_FORMATTED_CONVERSATION_DATA (self), FALSE);
	_tmp0_ = self->priv->conversation;
	_tmp1_ = geary_app_conversation_get_latest_recv_email (_tmp0_, GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER_OUT_OF_FOLDER, NULL);
	latest = _tmp1_;
	_tmp3_ = latest;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GearyEmail* _tmp4_;
		GearyEmailProperties* _tmp5_;
		GearyEmailProperties* _tmp6_;
		_tmp4_ = latest;
		_tmp5_ = geary_email_get_properties (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == NULL;
	}
	if (_tmp2_) {
		result = FALSE;
		_g_object_unref0 (latest);
		return result;
	}
	_tmp7_ = latest;
	_tmp8_ = geary_email_get_properties (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = geary_email_properties_get_date_received (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_date_time_to_local (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->config;
	_tmp15_ = application_configuration_get_clock_format (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = util_date_pretty_print (_tmp13_, _tmp16_);
	_tmp18_ = _tmp17_;
	_g_date_time_unref0 (_tmp13_);
	new_date = _tmp18_;
	_tmp19_ = new_date;
	_tmp20_ = self->priv->_date;
	if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
		result = FALSE;
		_g_free0 (new_date);
		_g_object_unref0 (latest);
		return result;
	}
	_tmp21_ = new_date;
	formatted_conversation_data_set_date (self, _tmp21_);
	result = TRUE;
	_g_free0 (new_date);
	_g_object_unref0 (latest);
	return result;
}

static guint8
formatted_conversation_data_gdk_to_rgb (FormattedConversationData* self,
                                        gdouble gdk)
{
	guint8 result;
	g_return_val_if_fail (IS_FORMATTED_CONVERSATION_DATA (self), 0U);
	result = (guint8) (CLAMP (gdk, 0.0, 1.0) * 255.0);
	return result;
}

static void
formatted_conversation_data_dim_rgba (FormattedConversationData* self,
                                      GdkRGBA* rgba,
                                      gdouble amount,
                                      GdkRGBA* result)
{
	gdouble _tmp0_ = 0.0;
	GdkRGBA _tmp1_;
	gdouble dim_red = 0.0;
	gdouble _tmp2_ = 0.0;
	GdkRGBA _tmp3_;
	gdouble dim_green = 0.0;
	gdouble _tmp4_ = 0.0;
	GdkRGBA _tmp5_;
	gdouble dim_blue = 0.0;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	GdkRGBA _tmp9_;
	GdkRGBA _tmp10_ = {0};
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	g_return_if_fail (rgba != NULL);
	amount = CLAMP (amount, 0.0, 1.0);
	_tmp1_ = *rgba;
	if (_tmp1_.red >= 0.5) {
		_tmp0_ = -amount;
	} else {
		_tmp0_ = amount;
	}
	dim_red = _tmp0_;
	_tmp3_ = *rgba;
	if (_tmp3_.green >= 0.5) {
		_tmp2_ = -amount;
	} else {
		_tmp2_ = amount;
	}
	dim_green = _tmp2_;
	_tmp5_ = *rgba;
	if (_tmp5_.blue >= 0.5) {
		_tmp4_ = -amount;
	} else {
		_tmp4_ = amount;
	}
	dim_blue = _tmp4_;
	_tmp6_ = *rgba;
	_tmp7_ = *rgba;
	_tmp8_ = *rgba;
	_tmp9_ = *rgba;
	memset (&_tmp10_, 0, sizeof (GdkRGBA));
	_tmp10_.red = CLAMP (_tmp6_.red + dim_red, 0.0, 1.0);
	_tmp10_.green = CLAMP (_tmp7_.green + dim_green, 0.0, 1.0);
	_tmp10_.blue = CLAMP (_tmp8_.blue + dim_blue, 0.0, 1.0);
	_tmp10_.alpha = _tmp9_.alpha;
	*result = _tmp10_;
	return;
}

static gchar*
formatted_conversation_data_rgba_to_markup (FormattedConversationData* self,
                                            GdkRGBA* rgba)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (IS_FORMATTED_CONVERSATION_DATA (self), NULL);
	g_return_val_if_fail (rgba != NULL, NULL);
	_tmp0_ = *rgba;
	_tmp1_ = *rgba;
	_tmp2_ = *rgba;
	_tmp3_ = g_strdup_printf ("#%02x%02x%02x", (guint) formatted_conversation_data_gdk_to_rgb (self, _tmp0_.red), (guint) formatted_conversation_data_gdk_to_rgb (self, _tmp1_.green), (guint) formatted_conversation_data_gdk_to_rgb (self, _tmp2_.blue));
	result = _tmp3_;
	return result;
}

static void
formatted_conversation_data_get_foreground_rgba (FormattedConversationData* self,
                                                 GtkWidget* widget,
                                                 gboolean selected,
                                                 GdkRGBA* result)
{
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStateFlags _tmp3_ = 0U;
	GtkStyleContext* _tmp4_;
	GdkRGBA colour = {0};
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GdkRGBA _tmp7_ = {0};
	GtkStyleContext* _tmp8_;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	_tmp0_ = gtk_widget_get_style_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = context;
	gtk_style_context_save (_tmp2_);
	if (selected) {
		_tmp3_ = GTK_STATE_FLAG_SELECTED;
	} else {
		_tmp3_ = GTK_STATE_FLAG_NORMAL;
	}
	_tmp4_ = context;
	gtk_style_context_set_state (_tmp4_, _tmp3_);
	_tmp5_ = context;
	_tmp6_ = context;
	gtk_style_context_get_color (_tmp5_, gtk_style_context_get_state (_tmp6_), &_tmp7_);
	colour = _tmp7_;
	_tmp8_ = context;
	gtk_style_context_restore (_tmp8_);
	*result = colour;
	_g_object_unref0 (context);
	return;
}

static gchar*
formatted_conversation_data_get_participants_markup (FormattedConversationData* self,
                                                     GtkWidget* widget,
                                                     gboolean selected)
{
	gboolean _tmp0_ = FALSE;
	FormattedConversationDataParticipants _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GearyAppConversation* _tmp9_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	FormattedConversationDataParticipants _tmp101_;
	const gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* result;
	g_return_val_if_fail (IS_FORMATTED_CONVERSATION_DATA (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), NULL);
	_tmp1_ = self->priv->participants;
	_tmp2_ = _tmp1_.markup;
	if (_tmp2_ != NULL) {
		FormattedConversationDataParticipants _tmp3_;
		_tmp3_ = self->priv->participants;
		_tmp0_ = _tmp3_.was_widget_selected == selected;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FormattedConversationDataParticipants _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->participants;
		_tmp5_ = _tmp4_.markup;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		return result;
	}
	_tmp9_ = self->priv->conversation;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		GeeList* _tmp10_;
		_tmp10_ = self->priv->account_owner_emails;
		_tmp8_ = _tmp10_ == NULL;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = self->priv->account_owner_emails;
		_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp13_ = _tmp12_;
		_tmp7_ = _tmp13_ == 0;
	}
	if (_tmp7_) {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("");
		result = _tmp14_;
		return result;
	}
	_tmp15_ = gee_array_list_new (FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANT_DISPLAY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp15_;
	{
		GeeList* _message_list = NULL;
		GearyAppConversation* _tmp16_;
		GeeList* _tmp17_;
		gint _message_size = 0;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _message_index = 0;
		_tmp16_ = self->priv->conversation;
		_tmp17_ = geary_app_conversation_get_emails (_tmp16_, GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_ASCENDING, GEARY_APP_CONVERSATION_LOCATION_ANYWHERE, NULL, TRUE);
		_message_list = _tmp17_;
		_tmp18_ = _message_list;
		_tmp19_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp20_ = _tmp19_;
		_message_size = _tmp20_;
		_message_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			GearyEmail* message = NULL;
			GeeList* _tmp23_;
			gpointer _tmp24_;
			GearyRFC822MailboxAddresses* _tmp25_ = NULL;
			GearyRFC822MailboxAddresses* addresses = NULL;
			GearyRFC822MailboxAddresses* _tmp34_;
			gboolean _tmp35_ = FALSE;
			GearyRFC822MailboxAddresses* _tmp36_;
			_message_index = _message_index + 1;
			_tmp21_ = _message_index;
			_tmp22_ = _message_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _message_list;
			_tmp24_ = gee_list_get (_tmp23_, _message_index);
			message = (GearyEmail*) _tmp24_;
			if (self->priv->use_to) {
				GearyEmail* _tmp26_;
				GearyRFC822MailboxAddress* _tmp27_;
				GearyRFC822MailboxAddress* _tmp28_;
				GearyRFC822MailboxAddresses* _tmp29_;
				_tmp26_ = message;
				_tmp27_ = util_email_get_primary_originator (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
				_tmp28_ = _tmp27_;
				_tmp29_ = geary_rf_c822_mailbox_addresses_new_single (_tmp28_);
				_g_object_unref0 (_tmp25_);
				_tmp25_ = _tmp29_;
				_g_object_unref0 (_tmp28_);
			} else {
				GearyEmail* _tmp30_;
				GearyRFC822MailboxAddresses* _tmp31_;
				GearyRFC822MailboxAddresses* _tmp32_;
				GearyRFC822MailboxAddresses* _tmp33_;
				_tmp30_ = message;
				_tmp31_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
				_tmp32_ = _tmp31_;
				_tmp33_ = _g_object_ref0 (_tmp32_);
				_g_object_unref0 (_tmp25_);
				_tmp25_ = _tmp33_;
			}
			_tmp34_ = _g_object_ref0 (_tmp25_);
			addresses = _tmp34_;
			_tmp36_ = addresses;
			if (_tmp36_ == NULL) {
				_tmp35_ = TRUE;
			} else {
				GearyRFC822MailboxAddresses* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				_tmp37_ = addresses;
				_tmp38_ = geary_rf_c822_mailbox_addresses_get_size (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp35_ = _tmp39_ < 1;
			}
			if (_tmp35_) {
				_g_object_unref0 (addresses);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (message);
				continue;
			}
			{
				GearyRFC822MailboxAddresses* _address_list = NULL;
				GearyRFC822MailboxAddresses* _tmp40_;
				gint _address_size = 0;
				GearyRFC822MailboxAddresses* _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				gint _address_index = 0;
				_tmp40_ = addresses;
				_address_list = _tmp40_;
				_tmp41_ = _address_list;
				_tmp42_ = geary_rf_c822_mailbox_addresses_get_size (_tmp41_);
				_tmp43_ = _tmp42_;
				_address_size = _tmp43_;
				_address_index = -1;
				while (TRUE) {
					gint _tmp44_;
					gint _tmp45_;
					GearyRFC822MailboxAddress* address = NULL;
					GearyRFC822MailboxAddresses* _tmp46_;
					GearyRFC822MailboxAddress* _tmp47_;
					FormattedConversationDataParticipantDisplay* participant_display = NULL;
					GearyRFC822MailboxAddress* _tmp48_;
					GearyEmail* _tmp49_;
					GearyEmailFlags* _tmp50_;
					GearyEmailFlags* _tmp51_;
					FormattedConversationDataParticipantDisplay* _tmp52_;
					gint existing_index = 0;
					GeeArrayList* _tmp53_;
					FormattedConversationDataParticipantDisplay* _tmp54_;
					GearyEmail* _tmp57_;
					GearyEmailFlags* _tmp58_;
					GearyEmailFlags* _tmp59_;
					_address_index = _address_index + 1;
					_tmp44_ = _address_index;
					_tmp45_ = _address_size;
					if (!(_tmp44_ < _tmp45_)) {
						break;
					}
					_tmp46_ = _address_list;
					_tmp47_ = geary_rf_c822_mailbox_addresses_get (_tmp46_, _address_index);
					address = _tmp47_;
					_tmp48_ = address;
					_tmp49_ = message;
					_tmp50_ = geary_email_get_email_flags (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = formatted_conversation_data_participant_display_new (_tmp48_, geary_email_flags_is_unread (_tmp51_));
					participant_display = _tmp52_;
					_tmp53_ = list;
					_tmp54_ = participant_display;
					existing_index = gee_abstract_list_index_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp54_);
					if (existing_index < 0) {
						GeeArrayList* _tmp55_;
						FormattedConversationDataParticipantDisplay* _tmp56_;
						_tmp55_ = list;
						_tmp56_ = participant_display;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp56_);
						_g_object_unref0 (participant_display);
						_g_object_unref0 (address);
						continue;
					}
					_tmp57_ = message;
					_tmp58_ = geary_email_get_email_flags (_tmp57_);
					_tmp59_ = _tmp58_;
					if (geary_email_flags_is_unread (_tmp59_)) {
						GeeArrayList* _tmp60_;
						gpointer _tmp61_;
						FormattedConversationDataParticipantDisplay* _tmp62_;
						_tmp60_ = list;
						_tmp61_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), existing_index);
						_tmp62_ = (FormattedConversationDataParticipantDisplay*) _tmp61_;
						_tmp62_->is_unread = TRUE;
						_g_object_unref0 (_tmp62_);
					}
					_g_object_unref0 (participant_display);
					_g_object_unref0 (address);
				}
			}
			_g_object_unref0 (addresses);
			_g_object_unref0 (_tmp25_);
			_g_object_unref0 (message);
		}
		_g_object_unref0 (_message_list);
	}
	_tmp63_ = list;
	_tmp64_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp65_ = _tmp64_;
	if (_tmp65_ == 1) {
		GdkRGBA _tmp66_ = {0};
		gchar* _tmp67_;
		gchar* _tmp68_;
		GeeArrayList* _tmp69_;
		gpointer _tmp70_;
		FormattedConversationDataParticipantDisplay* _tmp71_;
		GeeList* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		formatted_conversation_data_get_foreground_rgba (self, widget, selected, &_tmp66_);
		_tmp67_ = formatted_conversation_data_rgba_to_markup (self, &_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = list;
		_tmp70_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
		_tmp71_ = (FormattedConversationDataParticipantDisplay*) _tmp70_;
		_tmp72_ = self->priv->account_owner_emails;
		_tmp73_ = formatted_conversation_data_participant_display_get_full_markup (_tmp71_, _tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_strdup_printf ("<span foreground='%s'>%s</span>", _tmp68_, _tmp74_);
		_g_free0 (self->priv->participants.markup);
		self->priv->participants.markup = _tmp75_;
		_g_free0 (_tmp74_);
		_g_object_unref0 (_tmp71_);
		_g_free0 (_tmp68_);
	} else {
		GString* builder = NULL;
		GdkRGBA _tmp76_ = {0};
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		GString* _tmp81_;
		GString* _tmp82_;
		gboolean first = FALSE;
		GString* _tmp97_;
		GString* _tmp98_;
		const gchar* _tmp99_;
		gchar* _tmp100_;
		formatted_conversation_data_get_foreground_rgba (self, widget, selected, &_tmp76_);
		_tmp77_ = formatted_conversation_data_rgba_to_markup (self, &_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_strdup_printf ("<span foreground='%s'>", _tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_string_new (_tmp80_);
		_tmp82_ = _tmp81_;
		_g_free0 (_tmp80_);
		_g_free0 (_tmp78_);
		builder = _tmp82_;
		first = TRUE;
		{
			GeeArrayList* _participant_list = NULL;
			GeeArrayList* _tmp83_;
			gint _participant_size = 0;
			GeeArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _participant_index = 0;
			_tmp83_ = list;
			_participant_list = _tmp83_;
			_tmp84_ = _participant_list;
			_tmp85_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp86_ = _tmp85_;
			_participant_size = _tmp86_;
			_participant_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				FormattedConversationDataParticipantDisplay* participant = NULL;
				GeeArrayList* _tmp89_;
				gpointer _tmp90_;
				GString* _tmp92_;
				FormattedConversationDataParticipantDisplay* _tmp93_;
				GeeList* _tmp94_;
				gchar* _tmp95_;
				gchar* _tmp96_;
				_participant_index = _participant_index + 1;
				_tmp87_ = _participant_index;
				_tmp88_ = _participant_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _participant_list;
				_tmp90_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _participant_index);
				participant = (FormattedConversationDataParticipantDisplay*) _tmp90_;
				if (!first) {
					GString* _tmp91_;
					_tmp91_ = builder;
					g_string_append (_tmp91_, ", ");
				}
				_tmp92_ = builder;
				_tmp93_ = participant;
				_tmp94_ = self->priv->account_owner_emails;
				_tmp95_ = formatted_conversation_data_participant_display_get_short_markup (_tmp93_, _tmp94_);
				_tmp96_ = _tmp95_;
				g_string_append (_tmp92_, _tmp96_);
				_g_free0 (_tmp96_);
				first = FALSE;
				_g_object_unref0 (participant);
			}
		}
		_tmp97_ = builder;
		g_string_append (_tmp97_, "</span>");
		_tmp98_ = builder;
		_tmp99_ = _tmp98_->str;
		_tmp100_ = g_strdup (_tmp99_);
		_g_free0 (self->priv->participants.markup);
		self->priv->participants.markup = _tmp100_;
		_g_string_free0 (builder);
	}
	self->priv->participants.was_widget_selected = selected;
	_tmp101_ = self->priv->participants;
	_tmp102_ = _tmp101_.markup;
	_tmp103_ = g_strdup (_tmp102_);
	result = _tmp103_;
	_g_object_unref0 (list);
	return result;
}

void
formatted_conversation_data_render (FormattedConversationData* self,
                                    cairo_t* ctx,
                                    GtkWidget* widget,
                                    GdkRectangle* background_area,
                                    GdkRectangle* cell_area,
                                    GtkCellRendererState flags,
                                    gboolean hover_select)
{
	GdkRectangle _tmp0_;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = *cell_area;
	formatted_conversation_data_render_internal (self, widget, &_tmp0_, ctx, flags, FALSE, hover_select);
}

void
formatted_conversation_data_calculate_sizes (FormattedConversationData* self,
                                             GtkWidget* widget)
{
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	formatted_conversation_data_render_internal (self, widget, NULL, NULL, 0, TRUE, FALSE);
}

gint
formatted_conversation_data_get_height (FormattedConversationData* self)
{
	gint result;
	g_return_val_if_fail (IS_FORMATTED_CONVERSATION_DATA (self), 0);
	_vala_assert (formatted_conversation_data_cell_height != -1, "cell_height != -1");
	result = formatted_conversation_data_cell_height;
	return result;
}

static void
formatted_conversation_data_render_internal (FormattedConversationData* self,
                                             GtkWidget* widget,
                                             GdkRectangle* cell_area,
                                             cairo_t* ctx,
                                             GtkCellRendererState flags,
                                             gboolean recalc_dims,
                                             gboolean hover_select)
{
	gboolean display_preview = FALSE;
	ApplicationConfiguration* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_ = 0;
	gint y = 0;
	gboolean selected = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean hover = FALSE;
	PangoRectangle ink_rect = {0};
	PangoRectangle _tmp6_ = {0};
	PangoRectangle _tmp7_;
	PangoRectangle _tmp8_ = {0};
	PangoRectangle _tmp9_;
	PangoRectangle _tmp10_;
	gint preview_height = 0;
	CountBadge* _tmp11_;
	gint _tmp12_;
	gint counter_width = 0;
	CountBadge* _tmp13_;
	gint _tmp14_ = 0;
	gint counter_x = 0;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	_tmp0_ = self->priv->config;
	_tmp1_ = application_configuration_get_display_preview (_tmp0_);
	_tmp2_ = _tmp1_;
	display_preview = _tmp2_;
	if (cell_area != NULL) {
		_tmp3_ = (*cell_area).y;
	} else {
		_tmp3_ = 0;
	}
	y = FORMATTED_CONVERSATION_DATA_SPACING + _tmp3_;
	selected = (flags & GTK_CELL_RENDERER_SELECTED) != 0;
	if ((flags & GTK_CELL_RENDERER_PRELIT) != 0) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (selected) {
			_tmp5_ = hover_select;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp4_ = _tmp5_;
	}
	hover = _tmp4_;
	formatted_conversation_data_render_date (self, widget, cell_area, ctx, y, selected, &_tmp6_);
	ink_rect = _tmp6_;
	_tmp7_ = ink_rect;
	formatted_conversation_data_render_from (self, widget, cell_area, ctx, y, selected, &_tmp7_, &_tmp8_);
	ink_rect = _tmp8_;
	_tmp9_ = ink_rect;
	_tmp10_ = ink_rect;
	y += (_tmp9_.height + _tmp10_.y) + FORMATTED_CONVERSATION_DATA_SPACING;
	preview_height = 0;
	_tmp11_ = self->priv->count_badge;
	_tmp12_ = self->priv->_num_emails;
	count_badge_set_count (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->count_badge;
	counter_width = count_badge_get_width (_tmp13_, widget) + FORMATTED_CONVERSATION_DATA_SPACING;
	if (cell_area != NULL) {
		_tmp14_ = (((*cell_area).width - (*cell_area).x) - counter_width) + (FORMATTED_CONVERSATION_DATA_SPACING / 2);
	} else {
		_tmp14_ = 0;
	}
	counter_x = _tmp14_;
	if (display_preview) {
		PangoRectangle _tmp15_;
		PangoRectangle _tmp16_;
		CountBadge* _tmp17_;
		PangoRectangle _tmp18_ = {0};
		PangoRectangle _tmp19_;
		PangoRectangle _tmp20_;
		formatted_conversation_data_render_subject (self, widget, cell_area, ctx, y, selected, 0);
		_tmp15_ = ink_rect;
		_tmp16_ = ink_rect;
		y += (_tmp15_.height + _tmp16_.y) + (FORMATTED_CONVERSATION_DATA_SPACING / 2);
		_tmp17_ = self->priv->count_badge;
		count_badge_render (_tmp17_, widget, ctx, counter_x, y + (FORMATTED_CONVERSATION_DATA_SPACING / 2), selected);
		formatted_conversation_data_render_preview (self, widget, cell_area, ctx, y, selected, counter_width, &_tmp18_);
		ink_rect = _tmp18_;
		_tmp19_ = ink_rect;
		_tmp20_ = ink_rect;
		preview_height = (_tmp19_.height + _tmp20_.y) + ((gint) (FORMATTED_CONVERSATION_DATA_SPACING * 1.2));
	} else {
		CountBadge* _tmp21_;
		PangoRectangle _tmp22_;
		PangoRectangle _tmp23_;
		_tmp21_ = self->priv->count_badge;
		count_badge_render (_tmp21_, widget, ctx, counter_x, y, selected);
		formatted_conversation_data_render_subject (self, widget, cell_area, ctx, y, selected, counter_width);
		_tmp22_ = ink_rect;
		_tmp23_ = ink_rect;
		y += (_tmp22_.height + _tmp23_.y) + ((gint) (FORMATTED_CONVERSATION_DATA_SPACING * 1.2));
	}
	if (recalc_dims) {
		formatted_conversation_data_preview_height = preview_height;
		formatted_conversation_data_cell_height = y + preview_height;
	} else {
		gint _tmp24_ = 0;
		gint unread_y = 0;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_;
		if (display_preview) {
			_tmp24_ = (*cell_area).y + (FORMATTED_CONVERSATION_DATA_SPACING * 2);
		} else {
			_tmp24_ = (*cell_area).y + FORMATTED_CONVERSATION_DATA_SPACING;
		}
		unread_y = _tmp24_;
		_tmp26_ = self->priv->_is_unread;
		if (_tmp26_) {
			_tmp25_ = TRUE;
		} else {
			_tmp25_ = hover;
		}
		if (_tmp25_) {
			const gchar* _tmp27_ = NULL;
			gboolean _tmp28_;
			GdkPixbuf* read_icon = NULL;
			IconFactory* _tmp29_;
			IconFactory* _tmp30_;
			GtkStyleContext* _tmp31_;
			GdkPixbuf* _tmp32_;
			GdkPixbuf* _tmp33_;
			_tmp28_ = self->priv->_is_unread;
			if (_tmp28_) {
				_tmp27_ = "mail-unread-symbolic";
			} else {
				_tmp27_ = "mail-read-symbolic";
			}
			_tmp29_ = icon_factory_get_instance ();
			_tmp30_ = _tmp29_;
			_tmp31_ = gtk_widget_get_style_context (widget);
			_tmp32_ = icon_factory_load_symbolic (_tmp30_, _tmp27_, ICON_FACTORY_UNREAD_ICON_SIZE, _tmp31_, 0);
			read_icon = _tmp32_;
			_tmp33_ = read_icon;
			gdk_cairo_set_source_pixbuf (ctx, _tmp33_, (gdouble) ((*cell_area).x + FORMATTED_CONVERSATION_DATA_SPACING), (gdouble) unread_y);
			cairo_paint (ctx);
			_g_object_unref0 (read_icon);
		}
		_tmp35_ = self->priv->_is_flagged;
		if (_tmp35_) {
			_tmp34_ = TRUE;
		} else {
			_tmp34_ = hover;
		}
		if (_tmp34_) {
			gint _tmp36_ = 0;
			gint star_y = 0;
			const gchar* _tmp37_ = NULL;
			gboolean _tmp38_;
			GdkPixbuf* starred_icon = NULL;
			IconFactory* _tmp39_;
			IconFactory* _tmp40_;
			GtkStyleContext* _tmp41_;
			GdkPixbuf* _tmp42_;
			GdkPixbuf* _tmp43_;
			if (display_preview) {
				_tmp36_ = FORMATTED_CONVERSATION_DATA_SPACING;
			} else {
				_tmp36_ = 0;
			}
			star_y = ((*cell_area).y + ((*cell_area).height / 2)) + _tmp36_;
			_tmp38_ = self->priv->_is_flagged;
			if (_tmp38_) {
				_tmp37_ = "starred-symbolic";
			} else {
				_tmp37_ = "non-starred-symbolic";
			}
			_tmp39_ = icon_factory_get_instance ();
			_tmp40_ = _tmp39_;
			_tmp41_ = gtk_widget_get_style_context (widget);
			_tmp42_ = icon_factory_load_symbolic (_tmp40_, _tmp37_, ICON_FACTORY_STAR_ICON_SIZE, _tmp41_, 0);
			starred_icon = _tmp42_;
			_tmp43_ = starred_icon;
			gdk_cairo_set_source_pixbuf (ctx, _tmp43_, (gdouble) ((*cell_area).x + FORMATTED_CONVERSATION_DATA_SPACING), (gdouble) star_y);
			cairo_paint (ctx);
			_g_object_unref0 (starred_icon);
		}
	}
}

static PangoRectangle*
_pango_rectangle_dup (PangoRectangle* self)
{
	PangoRectangle* dup;
	dup = g_new0 (PangoRectangle, 1);
	memcpy (dup, self, sizeof (PangoRectangle));
	return dup;
}

static gpointer
__pango_rectangle_dup0 (gpointer self)
{
	return self ? _pango_rectangle_dup (self) : NULL;
}

static void
formatted_conversation_data_render_date (FormattedConversationData* self,
                                         GtkWidget* widget,
                                         GdkRectangle* cell_area,
                                         cairo_t* ctx,
                                         gint y,
                                         gboolean selected,
                                         PangoRectangle* result)
{
	gchar* date_markup = NULL;
	GdkRGBA _tmp0_ = {0};
	GdkRGBA _tmp1_ = {0};
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	PangoRectangle* ink_rect = NULL;
	PangoRectangle* logical_rect = NULL;
	PangoLayout* layout_date = NULL;
	PangoLayout* _tmp9_;
	PangoLayout* _tmp10_;
	PangoFontDescription* _tmp11_;
	PangoLayout* _tmp12_;
	const gchar* _tmp13_;
	PangoLayout* _tmp14_;
	PangoLayout* _tmp15_;
	PangoRectangle _tmp16_ = {0};
	PangoRectangle _tmp17_ = {0};
	PangoRectangle _tmp18_;
	PangoRectangle* _tmp19_;
	PangoRectangle _tmp20_;
	PangoRectangle* _tmp21_;
	gboolean _tmp22_ = FALSE;
	PangoRectangle* _tmp26_;
	PangoRectangle _tmp27_;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	formatted_conversation_data_get_foreground_rgba (self, widget, selected, &_tmp0_);
	formatted_conversation_data_dim_rgba (self, &_tmp0_, FORMATTED_CONVERSATION_DATA_DIM_TEXT_AMOUNT, &_tmp1_);
	_tmp2_ = formatted_conversation_data_rgba_to_markup (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_date;
	_tmp5_ = geary_html_escape_markup (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("<span size='smaller' foreground='%s'>%s</span>", _tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	date_markup = _tmp8_;
	_tmp9_ = gtk_widget_create_pango_layout (widget, NULL);
	layout_date = _tmp9_;
	_tmp10_ = layout_date;
	_tmp11_ = self->priv->font;
	pango_layout_set_font_description (_tmp10_, _tmp11_);
	_tmp12_ = layout_date;
	_tmp13_ = date_markup;
	pango_layout_set_markup (_tmp12_, _tmp13_, -1);
	_tmp14_ = layout_date;
	pango_layout_set_alignment (_tmp14_, PANGO_ALIGN_RIGHT);
	_tmp15_ = layout_date;
	pango_layout_get_pixel_extents (_tmp15_, &_tmp16_, &_tmp17_);
	_g_free0 (ink_rect);
	_tmp18_ = _tmp16_;
	_tmp19_ = __pango_rectangle_dup0 (&_tmp18_);
	ink_rect = _tmp19_;
	_g_free0 (logical_rect);
	_tmp20_ = _tmp17_;
	_tmp21_ = __pango_rectangle_dup0 (&_tmp20_);
	logical_rect = _tmp21_;
	if (ctx != NULL) {
		_tmp22_ = cell_area != NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		PangoRectangle* _tmp23_;
		PangoRectangle* _tmp24_;
		PangoLayout* _tmp25_;
		_tmp23_ = ink_rect;
		_tmp24_ = ink_rect;
		cairo_move_to (ctx, (gdouble) (((((*cell_area).width - (*cell_area).x) - (*_tmp23_).width) - (*_tmp24_).x) - FORMATTED_CONVERSATION_DATA_SPACING), (gdouble) y);
		_tmp25_ = layout_date;
		pango_cairo_show_layout (ctx, _tmp25_);
	}
	_tmp26_ = ink_rect;
	_tmp27_ = *_tmp26_;
	_g_free0 (_tmp26_);
	*result = _tmp27_;
	_g_object_unref0 (layout_date);
	_g_free0 (logical_rect);
	_g_free0 (date_markup);
	return;
}

static PangoFontDescription*
_vala_PangoFontDescription_copy (PangoFontDescription* self)
{
	return g_boxed_copy (pango_font_description_get_type (), self);
}

static gpointer
__vala_PangoFontDescription_copy0 (gpointer self)
{
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}

static void
formatted_conversation_data_render_from (FormattedConversationData* self,
                                         GtkWidget* widget,
                                         GdkRectangle* cell_area,
                                         cairo_t* ctx,
                                         gint y,
                                         gboolean selected,
                                         PangoRectangle* ink_rect,
                                         PangoRectangle* result)
{
	gchar* _tmp0_ = NULL;
	GearyAppConversation* _tmp1_;
	gchar* from_markup = NULL;
	gchar* _tmp4_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp5_;
	PangoFontDescription* _tmp6_;
	gboolean _tmp7_;
	PangoLayout* layout_from = NULL;
	PangoLayout* _tmp11_;
	PangoLayout* _tmp12_;
	PangoFontDescription* _tmp13_;
	PangoLayout* _tmp14_;
	const gchar* _tmp15_;
	PangoLayout* _tmp16_;
	gboolean _tmp17_ = FALSE;
	PangoRectangle _tmp22_;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	g_return_if_fail (ink_rect != NULL);
	_tmp1_ = self->priv->conversation;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = formatted_conversation_data_get_participants_markup (self, widget, selected);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (FORMATTED_CONVERSATION_DATA_STYLE_EXAMPLE);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = g_strdup (_tmp0_);
	from_markup = _tmp4_;
	_tmp5_ = self->priv->font;
	_tmp6_ = __vala_PangoFontDescription_copy0 (_tmp5_);
	font = _tmp6_;
	_tmp7_ = self->priv->_is_unread;
	if (_tmp7_) {
		PangoFontDescription* _tmp8_;
		PangoFontDescription* _tmp9_;
		PangoFontDescription* _tmp10_;
		_tmp8_ = font;
		_tmp9_ = pango_font_description_copy (_tmp8_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp9_;
		_tmp10_ = font;
		pango_font_description_set_weight (_tmp10_, PANGO_WEIGHT_BOLD);
	}
	_tmp11_ = gtk_widget_create_pango_layout (widget, NULL);
	layout_from = _tmp11_;
	_tmp12_ = layout_from;
	_tmp13_ = font;
	pango_layout_set_font_description (_tmp12_, _tmp13_);
	_tmp14_ = layout_from;
	_tmp15_ = from_markup;
	pango_layout_set_markup (_tmp14_, _tmp15_, -1);
	_tmp16_ = layout_from;
	pango_layout_set_ellipsize (_tmp16_, PANGO_ELLIPSIZE_END);
	if (ctx != NULL) {
		_tmp17_ = cell_area != NULL;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		PangoLayout* _tmp18_;
		PangoRectangle _tmp19_;
		PangoRectangle _tmp20_;
		PangoLayout* _tmp21_;
		_tmp18_ = layout_from;
		_tmp19_ = *ink_rect;
		_tmp20_ = *ink_rect;
		pango_layout_set_width (_tmp18_, (((((*cell_area).width - _tmp19_.width) - _tmp20_.x) - (FORMATTED_CONVERSATION_DATA_SPACING * 3)) - FORMATTED_CONVERSATION_DATA_TEXT_LEFT) * PANGO_SCALE);
		cairo_move_to (ctx, (gdouble) ((*cell_area).x + FORMATTED_CONVERSATION_DATA_TEXT_LEFT), (gdouble) y);
		_tmp21_ = layout_from;
		pango_cairo_show_layout (ctx, _tmp21_);
	}
	_tmp22_ = *ink_rect;
	*result = _tmp22_;
	_g_object_unref0 (layout_from);
	__vala_PangoFontDescription_free0 (font);
	_g_free0 (from_markup);
	_g_free0 (_tmp0_);
	return;
}

static void
formatted_conversation_data_render_subject (FormattedConversationData* self,
                                            GtkWidget* widget,
                                            GdkRectangle* cell_area,
                                            cairo_t* ctx,
                                            gint y,
                                            gboolean selected,
                                            gint counter_width)
{
	gchar* subject_markup = NULL;
	GdkRGBA _tmp0_ = {0};
	GdkRGBA _tmp1_ = {0};
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp7_;
	PangoFontDescription* _tmp8_;
	gboolean _tmp9_;
	PangoLayout* layout_subject = NULL;
	PangoLayout* _tmp13_;
	PangoLayout* _tmp14_;
	PangoFontDescription* _tmp15_;
	PangoLayout* _tmp16_;
	const gchar* _tmp17_;
	PangoLayout* _tmp19_;
	gboolean _tmp20_ = FALSE;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	formatted_conversation_data_get_foreground_rgba (self, widget, selected, &_tmp0_);
	formatted_conversation_data_dim_rgba (self, &_tmp0_, FORMATTED_CONVERSATION_DATA_DIM_TEXT_AMOUNT, &_tmp1_);
	_tmp2_ = formatted_conversation_data_rgba_to_markup (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->subject_html_escaped;
	_tmp5_ = g_strdup_printf ("<span size='smaller' foreground='%s'>%s</span>", _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp3_);
	subject_markup = _tmp6_;
	_tmp7_ = self->priv->font;
	_tmp8_ = __vala_PangoFontDescription_copy0 (_tmp7_);
	font = _tmp8_;
	_tmp9_ = self->priv->_is_unread;
	if (_tmp9_) {
		PangoFontDescription* _tmp10_;
		PangoFontDescription* _tmp11_;
		PangoFontDescription* _tmp12_;
		_tmp10_ = font;
		_tmp11_ = pango_font_description_copy (_tmp10_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp11_;
		_tmp12_ = font;
		pango_font_description_set_weight (_tmp12_, PANGO_WEIGHT_BOLD);
	}
	_tmp13_ = gtk_widget_create_pango_layout (widget, NULL);
	layout_subject = _tmp13_;
	_tmp14_ = layout_subject;
	_tmp15_ = font;
	pango_layout_set_font_description (_tmp14_, _tmp15_);
	_tmp16_ = layout_subject;
	_tmp17_ = subject_markup;
	pango_layout_set_markup (_tmp16_, _tmp17_, -1);
	if (cell_area != NULL) {
		PangoLayout* _tmp18_;
		_tmp18_ = layout_subject;
		pango_layout_set_width (_tmp18_, (((*cell_area).width - FORMATTED_CONVERSATION_DATA_TEXT_LEFT) - counter_width) * PANGO_SCALE);
	}
	_tmp19_ = layout_subject;
	pango_layout_set_ellipsize (_tmp19_, PANGO_ELLIPSIZE_END);
	if (ctx != NULL) {
		_tmp20_ = cell_area != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		PangoLayout* _tmp21_;
		cairo_move_to (ctx, (gdouble) ((*cell_area).x + FORMATTED_CONVERSATION_DATA_TEXT_LEFT), (gdouble) y);
		_tmp21_ = layout_subject;
		pango_cairo_show_layout (ctx, _tmp21_);
	}
	_g_object_unref0 (layout_subject);
	__vala_PangoFontDescription_free0 (font);
	_g_free0 (subject_markup);
}

static void
formatted_conversation_data_render_preview (FormattedConversationData* self,
                                            GtkWidget* widget,
                                            GdkRectangle* cell_area,
                                            cairo_t* ctx,
                                            gint y,
                                            gboolean selected,
                                            gint counter_width,
                                            PangoRectangle* result)
{
	gdouble _tmp0_ = 0.0;
	gdouble dim = 0.0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* preview_markup = NULL;
	GdkRGBA _tmp6_ = {0};
	GdkRGBA _tmp7_ = {0};
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	PangoLayout* layout_preview = NULL;
	PangoLayout* _tmp12_;
	PangoLayout* _tmp13_;
	PangoFontDescription* _tmp14_;
	PangoLayout* _tmp15_;
	const gchar* _tmp16_;
	PangoLayout* _tmp17_;
	PangoLayout* _tmp18_;
	gboolean _tmp19_ = FALSE;
	PangoRectangle* ink_rect = NULL;
	PangoRectangle* logical_rect = NULL;
	PangoLayout* _tmp25_;
	PangoRectangle _tmp26_ = {0};
	PangoRectangle _tmp27_ = {0};
	PangoRectangle _tmp28_;
	PangoRectangle* _tmp29_;
	PangoRectangle _tmp30_;
	PangoRectangle* _tmp31_;
	PangoRectangle* _tmp32_;
	PangoRectangle _tmp33_;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	if (selected) {
		_tmp0_ = FORMATTED_CONVERSATION_DATA_DIM_TEXT_AMOUNT;
	} else {
		_tmp0_ = FORMATTED_CONVERSATION_DATA_DIM_PREVIEW_TEXT_AMOUNT;
	}
	dim = _tmp0_;
	_tmp2_ = self->priv->_body;
	if (geary_string_is_empty (_tmp2_)) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp3_;
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->_body;
		_tmp5_ = geary_html_escape_markup (_tmp4_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	formatted_conversation_data_get_foreground_rgba (self, widget, selected, &_tmp6_);
	formatted_conversation_data_dim_rgba (self, &_tmp6_, dim, &_tmp7_);
	_tmp8_ = formatted_conversation_data_rgba_to_markup (self, &_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("<span size='smaller' foreground='%s'>%s</span>", _tmp9_, _tmp1_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	preview_markup = _tmp11_;
	_tmp12_ = gtk_widget_create_pango_layout (widget, NULL);
	layout_preview = _tmp12_;
	_tmp13_ = layout_preview;
	_tmp14_ = self->priv->font;
	pango_layout_set_font_description (_tmp13_, _tmp14_);
	_tmp15_ = layout_preview;
	_tmp16_ = preview_markup;
	pango_layout_set_markup (_tmp15_, _tmp16_, -1);
	_tmp17_ = layout_preview;
	pango_layout_set_wrap (_tmp17_, PANGO_WRAP_WORD);
	_tmp18_ = layout_preview;
	pango_layout_set_ellipsize (_tmp18_, PANGO_ELLIPSIZE_END);
	if (ctx != NULL) {
		_tmp19_ = cell_area != NULL;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		PangoLayout* _tmp20_;
		PangoLayout* _tmp21_;
		PangoLayout* _tmp22_;
		_tmp20_ = layout_preview;
		pango_layout_set_width (_tmp20_, ((((*cell_area).width - FORMATTED_CONVERSATION_DATA_TEXT_LEFT) - counter_width) - FORMATTED_CONVERSATION_DATA_SPACING) * PANGO_SCALE);
		_tmp21_ = layout_preview;
		pango_layout_set_height (_tmp21_, formatted_conversation_data_preview_height * PANGO_SCALE);
		cairo_move_to (ctx, (gdouble) ((*cell_area).x + FORMATTED_CONVERSATION_DATA_TEXT_LEFT), (gdouble) y);
		_tmp22_ = layout_preview;
		pango_cairo_show_layout (ctx, _tmp22_);
	} else {
		PangoLayout* _tmp23_;
		PangoLayout* _tmp24_;
		_tmp23_ = layout_preview;
		pango_layout_set_width (_tmp23_, G_MAXINT);
		_tmp24_ = layout_preview;
		pango_layout_set_height (_tmp24_, G_MAXINT);
	}
	_tmp25_ = layout_preview;
	pango_layout_get_pixel_extents (_tmp25_, &_tmp26_, &_tmp27_);
	_g_free0 (ink_rect);
	_tmp28_ = _tmp26_;
	_tmp29_ = __pango_rectangle_dup0 (&_tmp28_);
	ink_rect = _tmp29_;
	_g_free0 (logical_rect);
	_tmp30_ = _tmp27_;
	_tmp31_ = __pango_rectangle_dup0 (&_tmp30_);
	logical_rect = _tmp31_;
	_tmp32_ = ink_rect;
	_tmp33_ = *_tmp32_;
	_g_free0 (_tmp32_);
	*result = _tmp33_;
	_g_free0 (logical_rect);
	_g_object_unref0 (layout_preview);
	_g_free0 (preview_markup);
	_g_free0 (_tmp1_);
	return;
}

static void
formatted_conversation_data_update_font (FormattedConversationData* self)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	GtkSettings* _tmp1_;
	const gchar* _tmp5_;
	PangoFontDescription* _tmp6_;
	g_return_if_fail (IS_FORMATTED_CONVERSATION_DATA (self));
	_tmp0_ = g_strdup ("Cantarell 11");
	name = _tmp0_;
	_tmp1_ = self->priv->gtk;
	if (_tmp1_ != NULL) {
		GtkSettings* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->gtk;
		g_object_get (_tmp2_, "gtk-font-name", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_g_free0 (name);
		name = _tmp4_;
	}
	_tmp5_ = name;
	_tmp6_ = pango_font_description_from_string (_tmp5_);
	__vala_PangoFontDescription_free0 (self->priv->font);
	self->priv->font = _tmp6_;
	_g_free0 (name);
}

static FormattedConversationDataParticipantDisplay*
formatted_conversation_data_participant_display_construct (GType object_type,
                                                           GearyRFC822MailboxAddress* address,
                                                           gboolean is_unread)
{
	FormattedConversationDataParticipantDisplay * self = NULL;
	GearyRFC822MailboxAddress* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (address, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS), NULL);
	self = (FormattedConversationDataParticipantDisplay*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (address);
	_g_object_unref0 (self->address);
	self->address = _tmp0_;
	self->is_unread = is_unread;
	return self;
}

static FormattedConversationDataParticipantDisplay*
formatted_conversation_data_participant_display_new (GearyRFC822MailboxAddress* address,
                                                     gboolean is_unread)
{
	return formatted_conversation_data_participant_display_construct (FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANT_DISPLAY, address, is_unread);
}

static gchar*
formatted_conversation_data_participant_display_get_full_markup (FormattedConversationDataParticipantDisplay* self,
                                                                 GeeList* account_mailboxes)
{
	gchar* _tmp0_ = NULL;
	GearyRFC822MailboxAddress* _tmp1_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (FORMATTED_CONVERSATION_DATA_IS_PARTICIPANT_DISPLAY (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account_mailboxes, GEE_TYPE_LIST), NULL);
	_tmp1_ = self->address;
	if (gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (account_mailboxes, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_)) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (FORMATTED_CONVERSATION_DATA_ME);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		GearyRFC822MailboxAddress* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->address;
		_tmp4_ = geary_rf_c822_mailbox_address_to_short_display (_tmp3_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = formatted_conversation_data_participant_display_get_as_markup (self, _tmp0_);
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
formatted_conversation_data_participant_display_get_short_markup (FormattedConversationDataParticipantDisplay* self,
                                                                  GeeList* account_mailboxes)
{
	GearyRFC822MailboxAddress* _tmp0_;
	GearyRFC822MailboxAddress* _tmp2_;
	gchar* short_address = NULL;
	GearyRFC822MailboxAddress* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar** tokens = NULL;
	const gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* first_name = NULL;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* result;
	g_return_val_if_fail (FORMATTED_CONVERSATION_DATA_IS_PARTICIPANT_DISPLAY (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account_mailboxes, GEE_TYPE_LIST), NULL);
	_tmp0_ = self->address;
	if (gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (account_mailboxes, GEE_TYPE_COLLECTION, GeeCollection), _tmp0_)) {
		gchar* _tmp1_;
		_tmp1_ = formatted_conversation_data_participant_display_get_as_markup (self, FORMATTED_CONVERSATION_DATA_ME);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->address;
	if (geary_rf_c822_mailbox_address_is_spoofed (_tmp2_)) {
		gchar* _tmp3_;
		_tmp3_ = formatted_conversation_data_participant_display_get_full_markup (self, account_mailboxes);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->address;
	_tmp5_ = geary_rf_c822_mailbox_address_to_short_display (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	short_address = _tmp8_;
	_tmp9_ = short_address;
	if (string_contains (_tmp9_, ", ")) {
		gchar** tokens = NULL;
		const gchar* _tmp10_;
		gchar** _tmp11_;
		gchar** _tmp12_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp10_ = short_address;
		_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, ", ", 2);
		tokens = _tmp12_;
		tokens_length1 = _vala_array_length (_tmp11_);
		_tokens_size_ = tokens_length1;
		_tmp13_ = tokens;
		_tmp13__length1 = tokens_length1;
		_tmp14_ = _tmp13_[1];
		_tmp15_ = string_strip (_tmp14_);
		_g_free0 (short_address);
		short_address = _tmp15_;
		_tmp16_ = short_address;
		if (geary_string_is_empty (_tmp16_)) {
			gchar* _tmp17_;
			_tmp17_ = formatted_conversation_data_participant_display_get_full_markup (self, account_mailboxes);
			result = _tmp17_;
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (short_address);
			return result;
		}
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp18_ = short_address;
	_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, " ", 2);
	tokens = _tmp20_;
	tokens_length1 = _vala_array_length (_tmp19_);
	_tokens_size_ = tokens_length1;
	_tmp21_ = tokens;
	_tmp21__length1 = tokens_length1;
	if (_tmp21__length1 < 1) {
		gchar* _tmp22_;
		_tmp22_ = formatted_conversation_data_participant_display_get_full_markup (self, account_mailboxes);
		result = _tmp22_;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (short_address);
		return result;
	}
	_tmp23_ = tokens;
	_tmp23__length1 = tokens_length1;
	_tmp24_ = _tmp23_[0];
	_tmp25_ = string_strip (_tmp24_);
	first_name = _tmp25_;
	_tmp26_ = first_name;
	if (geary_string_is_empty_or_whitespace (_tmp26_)) {
		gchar* _tmp27_;
		_tmp27_ = formatted_conversation_data_participant_display_get_full_markup (self, account_mailboxes);
		result = _tmp27_;
		_g_free0 (first_name);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (short_address);
		return result;
	}
	_tmp28_ = first_name;
	_tmp29_ = formatted_conversation_data_participant_display_get_as_markup (self, _tmp28_);
	result = _tmp29_;
	_g_free0 (first_name);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (short_address);
	return result;
}

static gchar*
formatted_conversation_data_participant_display_get_as_markup (FormattedConversationDataParticipantDisplay* self,
                                                               const gchar* participant)
{
	gchar* markup = NULL;
	gchar* _tmp0_;
	GearyRFC822MailboxAddress* _tmp3_;
	gchar* result;
	g_return_val_if_fail (FORMATTED_CONVERSATION_DATA_IS_PARTICIPANT_DISPLAY (self), NULL);
	g_return_val_if_fail (participant != NULL, NULL);
	_tmp0_ = geary_html_escape_markup (participant);
	markup = _tmp0_;
	if (self->is_unread) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = markup;
		_tmp2_ = g_strdup_printf ("<b>%s</b>", _tmp1_);
		_g_free0 (markup);
		markup = _tmp2_;
	}
	_tmp3_ = self->address;
	if (geary_rf_c822_mailbox_address_is_spoofed (_tmp3_)) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = markup;
		_tmp5_ = g_strdup_printf ("<s>%s</s>", _tmp4_);
		_g_free0 (markup);
		markup = _tmp5_;
	}
	result = markup;
	return result;
}

static gboolean
formatted_conversation_data_participant_display_real_equal_to (GeeHashable* base,
                                                               FormattedConversationDataParticipantDisplay* other)
{
	FormattedConversationDataParticipantDisplay * self;
	gboolean _tmp0_ = FALSE;
	GearyRFC822MailboxAddress* _tmp1_;
	GearyRFC822MailboxAddress* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANT_DISPLAY, FormattedConversationDataParticipantDisplay);
	g_return_val_if_fail (FORMATTED_CONVERSATION_DATA_IS_PARTICIPANT_DISPLAY (other), FALSE);
	_tmp1_ = self->address;
	_tmp2_ = other->address;
	if (gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_HASHABLE, GeeHashable), _tmp2_)) {
		GearyRFC822MailboxAddress* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GearyRFC822MailboxAddress* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp3_ = self->address;
		_tmp4_ = geary_rf_c822_mailbox_address_get_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = other->address;
		_tmp7_ = geary_rf_c822_mailbox_address_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = g_strcmp0 (_tmp5_, _tmp8_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static guint
formatted_conversation_data_participant_display_real_hash (GeeHashable* base)
{
	FormattedConversationDataParticipantDisplay * self;
	GearyRFC822MailboxAddress* _tmp0_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANT_DISPLAY, FormattedConversationDataParticipantDisplay);
	_tmp0_ = self->address;
	result = gee_hashable_hash (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_HASHABLE, GeeHashable));
	return result;
}

static void
formatted_conversation_data_participant_display_class_init (FormattedConversationDataParticipantDisplayClass * klass,
                                                            gpointer klass_data)
{
	formatted_conversation_data_participant_display_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = formatted_conversation_data_participant_display_finalize;
}

static void
formatted_conversation_data_participant_display_gee_hashable_interface_init (GeeHashableIface * iface,
                                                                             gpointer iface_data)
{
	formatted_conversation_data_participant_display_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) formatted_conversation_data_participant_display_real_equal_to;
	iface->hash = (guint (*) (GeeHashable*)) formatted_conversation_data_participant_display_real_hash;
}

static void
formatted_conversation_data_participant_display_instance_init (FormattedConversationDataParticipantDisplay * self,
                                                               gpointer klass)
{
}

static void
formatted_conversation_data_participant_display_finalize (GObject * obj)
{
	FormattedConversationDataParticipantDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FORMATTED_CONVERSATION_DATA_TYPE_PARTICIPANT_DISPLAY, FormattedConversationDataParticipantDisplay);
	_g_object_unref0 (self->address);
	G_OBJECT_CLASS (formatted_conversation_data_participant_display_parent_class)->finalize (obj);
}

static GType
formatted_conversation_data_participant_display_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedConversationDataParticipantDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_conversation_data_participant_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedConversationDataParticipantDisplay), 0, (GInstanceInitFunc) formatted_conversation_data_participant_display_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) formatted_conversation_data_participant_display_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType formatted_conversation_data_participant_display_type_id;
	formatted_conversation_data_participant_display_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "FormattedConversationDataParticipantDisplay", &g_define_type_info, 0);
	g_type_add_interface_static (formatted_conversation_data_participant_display_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	return formatted_conversation_data_participant_display_type_id;
}

static GType
formatted_conversation_data_participant_display_get_type (void)
{
	static volatile gsize formatted_conversation_data_participant_display_type_id__once = 0;
	if (g_once_init_enter (&formatted_conversation_data_participant_display_type_id__once)) {
		GType formatted_conversation_data_participant_display_type_id;
		formatted_conversation_data_participant_display_type_id = formatted_conversation_data_participant_display_get_type_once ();
		g_once_init_leave (&formatted_conversation_data_participant_display_type_id__once, formatted_conversation_data_participant_display_type_id);
	}
	return formatted_conversation_data_participant_display_type_id__once;
}

static void
formatted_conversation_data_participants_copy (const FormattedConversationDataParticipants* self,
                                               FormattedConversationDataParticipants* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).markup;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).markup);
	(*dest).markup = _tmp1_;
	(*dest).was_widget_selected = (*self).was_widget_selected;
}

static void
formatted_conversation_data_participants_destroy (FormattedConversationDataParticipants* self)
{
	_g_free0 ((*self).markup);
}

static FormattedConversationDataParticipants*
formatted_conversation_data_participants_dup (const FormattedConversationDataParticipants* self)
{
	FormattedConversationDataParticipants* dup;
	dup = g_new0 (FormattedConversationDataParticipants, 1);
	formatted_conversation_data_participants_copy (self, dup);
	return dup;
}

static void
formatted_conversation_data_participants_free (FormattedConversationDataParticipants* self)
{
	formatted_conversation_data_participants_destroy (self);
	g_free (self);
}

static GType
formatted_conversation_data_participants_get_type_once (void)
{
	GType formatted_conversation_data_participants_type_id;
	formatted_conversation_data_participants_type_id = g_boxed_type_register_static ("FormattedConversationDataParticipants", (GBoxedCopyFunc) formatted_conversation_data_participants_dup, (GBoxedFreeFunc) formatted_conversation_data_participants_free);
	return formatted_conversation_data_participants_type_id;
}

static GType
formatted_conversation_data_participants_get_type (void)
{
	static volatile gsize formatted_conversation_data_participants_type_id__once = 0;
	if (g_once_init_enter (&formatted_conversation_data_participants_type_id__once)) {
		GType formatted_conversation_data_participants_type_id;
		formatted_conversation_data_participants_type_id = formatted_conversation_data_participants_get_type_once ();
		g_once_init_leave (&formatted_conversation_data_participants_type_id__once, formatted_conversation_data_participants_type_id);
	}
	return formatted_conversation_data_participants_type_id__once;
}

static void
formatted_conversation_data_class_init (FormattedConversationDataClass * klass,
                                        gpointer klass_data)
{
	formatted_conversation_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FormattedConversationData_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_formatted_conversation_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_formatted_conversation_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = formatted_conversation_data_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FORMATTED_CONVERSATION_DATA_IS_UNREAD_PROPERTY, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_IS_UNREAD_PROPERTY] = g_param_spec_boolean ("is-unread", "is-unread", "is-unread", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FORMATTED_CONVERSATION_DATA_IS_FLAGGED_PROPERTY, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_IS_FLAGGED_PROPERTY] = g_param_spec_boolean ("is-flagged", "is-flagged", "is-flagged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FORMATTED_CONVERSATION_DATA_DATE_PROPERTY, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_DATE_PROPERTY] = g_param_spec_string ("date", "date", "date", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FORMATTED_CONVERSATION_DATA_BODY_PROPERTY, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_BODY_PROPERTY] = g_param_spec_string ("body", "body", "body", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FORMATTED_CONVERSATION_DATA_NUM_EMAILS_PROPERTY, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_NUM_EMAILS_PROPERTY] = g_param_spec_int ("num-emails", "num-emails", "num-emails", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FORMATTED_CONVERSATION_DATA_PREVIEW_PROPERTY, formatted_conversation_data_properties[FORMATTED_CONVERSATION_DATA_PREVIEW_PROPERTY] = g_param_spec_object ("preview", "preview", "preview", GEARY_TYPE_EMAIL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
formatted_conversation_data_instance_init (FormattedConversationData * self,
                                           gpointer klass)
{
	CountBadge* _tmp0_;
	FormattedConversationDataParticipants _tmp1_ = {0};
	self->priv = formatted_conversation_data_get_instance_private (self);
	self->priv->_body = NULL;
	self->priv->_preview = NULL;
	self->priv->conversation = NULL;
	self->priv->account_owner_emails = NULL;
	self->priv->use_to = TRUE;
	_tmp0_ = count_badge_new (2);
	self->priv->count_badge = _tmp0_;
	memset (&_tmp1_, 0, sizeof (FormattedConversationDataParticipants));
	_g_free0 (_tmp1_.markup);
	_tmp1_.markup = NULL;
	self->priv->participants = _tmp1_;
}

static void
formatted_conversation_data_finalize (GObject * obj)
{
	FormattedConversationData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FORMATTED_CONVERSATION_DATA, FormattedConversationData);
	_g_free0 (self->priv->_date);
	_g_free0 (self->priv->_body);
	_g_object_unref0 (self->priv->_preview);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->gtk);
	__vala_PangoFontDescription_free0 (self->priv->font);
	_g_object_unref0 (self->priv->conversation);
	_g_object_unref0 (self->priv->account_owner_emails);
	_g_object_unref0 (self->priv->count_badge);
	_g_free0 (self->priv->subject_html_escaped);
	formatted_conversation_data_participants_destroy (&self->priv->participants);
	G_OBJECT_CLASS (formatted_conversation_data_parent_class)->finalize (obj);
}

static GType
formatted_conversation_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedConversationDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_conversation_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedConversationData), 0, (GInstanceInitFunc) formatted_conversation_data_instance_init, NULL };
	GType formatted_conversation_data_type_id;
	formatted_conversation_data_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "FormattedConversationData", &g_define_type_info, 0);
	FormattedConversationData_private_offset = g_type_add_instance_private (formatted_conversation_data_type_id, sizeof (FormattedConversationDataPrivate));
	return formatted_conversation_data_type_id;
}

GType
formatted_conversation_data_get_type (void)
{
	static volatile gsize formatted_conversation_data_type_id__once = 0;
	if (g_once_init_enter (&formatted_conversation_data_type_id__once)) {
		GType formatted_conversation_data_type_id;
		formatted_conversation_data_type_id = formatted_conversation_data_get_type_once ();
		g_once_init_leave (&formatted_conversation_data_type_id__once, formatted_conversation_data_type_id);
	}
	return formatted_conversation_data_type_id__once;
}

static void
_vala_formatted_conversation_data_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	FormattedConversationData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FORMATTED_CONVERSATION_DATA, FormattedConversationData);
	switch (property_id) {
		case FORMATTED_CONVERSATION_DATA_IS_UNREAD_PROPERTY:
		g_value_set_boolean (value, formatted_conversation_data_get_is_unread (self));
		break;
		case FORMATTED_CONVERSATION_DATA_IS_FLAGGED_PROPERTY:
		g_value_set_boolean (value, formatted_conversation_data_get_is_flagged (self));
		break;
		case FORMATTED_CONVERSATION_DATA_DATE_PROPERTY:
		g_value_set_string (value, formatted_conversation_data_get_date (self));
		break;
		case FORMATTED_CONVERSATION_DATA_BODY_PROPERTY:
		g_value_set_string (value, formatted_conversation_data_get_body (self));
		break;
		case FORMATTED_CONVERSATION_DATA_NUM_EMAILS_PROPERTY:
		g_value_set_int (value, formatted_conversation_data_get_num_emails (self));
		break;
		case FORMATTED_CONVERSATION_DATA_PREVIEW_PROPERTY:
		g_value_set_object (value, formatted_conversation_data_get_preview (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_formatted_conversation_data_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	FormattedConversationData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FORMATTED_CONVERSATION_DATA, FormattedConversationData);
	switch (property_id) {
		case FORMATTED_CONVERSATION_DATA_IS_UNREAD_PROPERTY:
		formatted_conversation_data_set_is_unread (self, g_value_get_boolean (value));
		break;
		case FORMATTED_CONVERSATION_DATA_IS_FLAGGED_PROPERTY:
		formatted_conversation_data_set_is_flagged (self, g_value_get_boolean (value));
		break;
		case FORMATTED_CONVERSATION_DATA_DATE_PROPERTY:
		formatted_conversation_data_set_date (self, g_value_get_string (value));
		break;
		case FORMATTED_CONVERSATION_DATA_BODY_PROPERTY:
		formatted_conversation_data_set_body (self, g_value_get_string (value));
		break;
		case FORMATTED_CONVERSATION_DATA_NUM_EMAILS_PROPERTY:
		formatted_conversation_data_set_num_emails (self, g_value_get_int (value));
		break;
		case FORMATTED_CONVERSATION_DATA_PREVIEW_PROPERTY:
		formatted_conversation_data_set_preview (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

