/* plugin-composer.c generated by valac 0.56.3, the Vala compiler
 * generated from plugin-composer.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

static GType plugin_composer_get_type_once (void);

/**
     * Determines the type of the context email passed to the composer
     *
     * @see Application.compose_with_context
     */
static GType
plugin_composer_context_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PLUGIN_COMPOSER_CONTEXT_TYPE_NONE, "PLUGIN_COMPOSER_CONTEXT_TYPE_NONE", "none"}, {PLUGIN_COMPOSER_CONTEXT_TYPE_EDIT, "PLUGIN_COMPOSER_CONTEXT_TYPE_EDIT", "edit"}, {PLUGIN_COMPOSER_CONTEXT_TYPE_REPLY_SENDER, "PLUGIN_COMPOSER_CONTEXT_TYPE_REPLY_SENDER", "reply-sender"}, {PLUGIN_COMPOSER_CONTEXT_TYPE_REPLY_ALL, "PLUGIN_COMPOSER_CONTEXT_TYPE_REPLY_ALL", "reply-all"}, {PLUGIN_COMPOSER_CONTEXT_TYPE_FORWARD, "PLUGIN_COMPOSER_CONTEXT_TYPE_FORWARD", "forward"}, {0, NULL, NULL}};
	GType plugin_composer_context_type_type_id;
	plugin_composer_context_type_type_id = g_enum_register_static ("PluginComposerContextType", values);
	return plugin_composer_context_type_type_id;
}

GType
plugin_composer_context_type_get_type (void)
{
	static volatile gsize plugin_composer_context_type_type_id__once = 0;
	if (g_once_init_enter (&plugin_composer_context_type_type_id__once)) {
		GType plugin_composer_context_type_type_id;
		plugin_composer_context_type_type_id = plugin_composer_context_type_get_type_once ();
		g_once_init_leave (&plugin_composer_context_type_type_id__once, plugin_composer_context_type_type_id);
	}
	return plugin_composer_context_type_type_id__once;
}

PluginAccount*
plugin_composer_get_sender_context (PluginComposer* self)
{
	PluginComposerIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_COMPOSER (self), NULL);
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->get_sender_context) {
		return _iface_->get_sender_context (self);
	}
	return NULL;
}

gboolean
plugin_composer_get_can_send (PluginComposer* self)
{
	PluginComposerIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_COMPOSER (self), FALSE);
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->get_can_send) {
		return _iface_->get_can_send (self);
	}
	return FALSE;
}

void
plugin_composer_set_can_send (PluginComposer* self,
                              gboolean value)
{
	PluginComposerIface* _iface_;
	g_return_if_fail (PLUGIN_IS_COMPOSER (self));
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->set_can_send) {
		_iface_->set_can_send (self, value);
	}
}

const gchar*
plugin_composer_get_action_group_name (PluginComposer* self)
{
	PluginComposerIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_COMPOSER (self), NULL);
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->get_action_group_name) {
		return _iface_->get_action_group_name (self);
	}
	return NULL;
}

PluginFolder*
plugin_composer_get_save_to (PluginComposer* self)
{
	PluginComposerIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_COMPOSER (self), NULL);
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->get_save_to) {
		return _iface_->get_save_to (self);
	}
	return NULL;
}

/**
     * Presents the composer on screen.
     *
     * The composer is made visible if this has not yet been done so,
     * and the application attempts to ensure that it is presented on
     * the active display.
     */
void
plugin_composer_present (PluginComposer* self)
{
	PluginComposerIface* _iface_;
	g_return_if_fail (PLUGIN_IS_COMPOSER (self));
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->present) {
		_iface_->present (self);
	}
}

/**
     * Inserts text at the current cursor position.
     *
     * The given text is inserted at the current cursor position in
     * the composer. Note that this may be in an address field,
     * subject line, or message body, depending on which component is
     * focused.
     *
     * If the text is inserted into the message body, any HTML markup
     * present in the string will appear as-is.
     */
void
plugin_composer_insert_text (PluginComposer* self,
                             const gchar* plain_text)
{
	PluginComposerIface* _iface_;
	g_return_if_fail (PLUGIN_IS_COMPOSER (self));
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->insert_text) {
		_iface_->insert_text (self, plain_text);
	}
}

/**
     * Sets the folder used to save the message being composed.
     *
     * Ensures email for both automatic and manual saving of the email
     * in the composer is saved to the given folder. This disables
     * changing accounts in the composer's UI since email cannot be
     * saved across accounts.
     */
void
plugin_composer_save_to_folder (PluginComposer* self,
                                PluginFolder* location)
{
	PluginComposerIface* _iface_;
	g_return_if_fail (PLUGIN_IS_COMPOSER (self));
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->save_to_folder) {
		_iface_->save_to_folder (self, location);
	}
}

/**
     * Registers a plugin action with this specific composer.
     *
     * Once registered, the action will be available for use in user
     * interface elements such as {@link Actionable}.
     *
     * @see deregister_action
     */
void
plugin_composer_register_action (PluginComposer* self,
                                 GAction* action)
{
	PluginComposerIface* _iface_;
	g_return_if_fail (PLUGIN_IS_COMPOSER (self));
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->register_action) {
		_iface_->register_action (self, action);
	}
}

/**
     * De-registers a plugin action, removing it from this composer.
     *
     * Makes a previously registered no longer available.
     *
     * @see register_action
     */
void
plugin_composer_deregister_action (PluginComposer* self,
                                   GAction* action)
{
	PluginComposerIface* _iface_;
	g_return_if_fail (PLUGIN_IS_COMPOSER (self));
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->deregister_action) {
		_iface_->deregister_action (self, action);
	}
}

/**
     * Adds a menu item to the composer's menu.
     *
     * The menu item will be added to a section unique to this plugin
     * on the composer's menu. The item's action must be registered
     * either with the application via {@link
     * Application.register_action} if it is a global action, or with
     * the composer via {@link register_action} if it is
     * composer-specific for it to be successfully activated.
     *
     * @see register_action
     * @see Application.register_action
     */
void
plugin_composer_append_menu_item (PluginComposer* self,
                                  PluginActionable* menu_item)
{
	PluginComposerIface* _iface_;
	g_return_if_fail (PLUGIN_IS_COMPOSER (self));
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->append_menu_item) {
		_iface_->append_menu_item (self, menu_item);
	}
}

/**
     * Sets an action bar for the plugin on this composer.
     *
     * If any existing action bar for this plugin has previously been
     * set, it is first removed.
     */
void
plugin_composer_set_action_bar (PluginComposer* self,
                                PluginActionBar* action_bar)
{
	PluginComposerIface* _iface_;
	g_return_if_fail (PLUGIN_IS_COMPOSER (self));
	_iface_ = PLUGIN_COMPOSER_GET_INTERFACE (self);
	if (_iface_->set_action_bar) {
		_iface_->set_action_bar (self, action_bar);
	}
}

static void
plugin_composer_default_init (PluginComposerIface * iface,
                              gpointer iface_data)
{
	/**
	     * Denotes the account the composed email will be sent from.
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("sender-context", "sender-context", "sender-context", PLUGIN_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines if the email in the composer can be sent.
	     */
	g_object_interface_install_property (iface, g_param_spec_boolean ("can-send", "can-send", "can-send", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The group name for GLib actions registered against this object.
	     *
	     * All actions are registered via {@link register_action} will be
	     * added to an action group with the name returned by this
	     * property.
	     *
	     * This must be used when using actions with GLib MenuModel items.
	     */
	g_object_interface_install_property (iface, g_param_spec_string ("action-group-name", "action-group-name", "action-group-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Denotes the folder that the email will be saved to.
	     *
	     * If non-null, fixes the folder used by the composer for saving
	     * the email. If null, the current account's Draft folder will be
	     * used.
	     *
	     * @see save_to_folder
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("save-to", "save-to", "save-to", PLUGIN_TYPE_FOLDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

/**
 * An object representing a composer for use by plugins.
 *
 * Instances of this interface can be obtained by calling {@link
 * Application.compose_blank} or {@link
 * Application.compose_with_context}. A composer instance may not be
 * visible until {@link present} is called, allowing it to be
 * configured via calls to this interface first, if required.
 */
static GType
plugin_composer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginComposerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_composer_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_composer_type_id;
	plugin_composer_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginComposer", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_composer_type_id, GEARY_TYPE_BASE_OBJECT);
	return plugin_composer_type_id;
}

GType
plugin_composer_get_type (void)
{
	static volatile gsize plugin_composer_type_id__once = 0;
	if (g_once_init_enter (&plugin_composer_type_id__once)) {
		GType plugin_composer_type_id;
		plugin_composer_type_id = plugin_composer_get_type_once ();
		g_once_init_leave (&plugin_composer_type_id__once, plugin_composer_type_id);
	}
	return plugin_composer_type_id__once;
}

