/* util-gio.c generated by valac 0.56.3, the Vala compiler
 * generated from util-gio.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

/**
     * Creates a GTK builder given the name of a GResource.
     *
     * The given `name` will automatically have
     * `GEARY_RESOURCE_PREFIX` pre-pended to it.
     */
GtkBuilder*
gio_util_create_builder (const gchar* name)
{
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GError* _inner_error0_ = NULL;
	GtkBuilder* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_strconcat (GIO_UTIL_GEARY_RESOURCE_PREFIX, name, NULL);
		_tmp2_ = _tmp1_;
		gtk_builder_add_from_resource (builder, _tmp2_, &_inner_error0_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_strdup_printf ("Unable load GResource \"%s\" for Gtk.Builder: %s", name, _tmp4_);
		_tmp6_ = _tmp5_;
		g_critical ("util-gio.vala:25: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = builder;
	return result;
}

/**
     * Loads a GResource file as a string.
     *
     * The given `name` will automatically have
     * `GEARY_RESOURCE_PREFIX` pre-pended to it.
     */
gchar*
gio_util_read_resource (const gchar* name,
                        GError** error)
{
	GInputStream* input_stream = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GInputStream* _tmp2_;
	GInputStream* _tmp3_;
	GDataInputStream* data_stream = NULL;
	GInputStream* _tmp4_;
	GDataInputStream* _tmp5_;
	gsize length = 0UL;
	gchar* _tmp6_ = NULL;
	GDataInputStream* _tmp7_;
	gsize _tmp8_ = 0UL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strconcat (GIO_UTIL_GEARY_RESOURCE_PREFIX, name, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_resources_open_stream (_tmp1_, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	input_stream = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = input_stream;
	_tmp5_ = g_data_input_stream_new (_tmp4_);
	data_stream = _tmp5_;
	_tmp7_ = data_stream;
	_tmp9_ = g_data_input_stream_read_upto (_tmp7_, "\0", (gssize) 1, &_tmp8_, NULL, &_inner_error0_);
	length = _tmp8_;
	_tmp6_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (data_stream);
		_g_object_unref0 (input_stream);
		return NULL;
	}
	_tmp10_ = _tmp6_;
	_tmp6_ = NULL;
	result = _tmp10_;
	_g_free0 (_tmp6_);
	_g_object_unref0 (data_stream);
	_g_object_unref0 (input_stream);
	return result;
}

