/* geary-engine.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-engine.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018-2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define GEARY_ENGINE_VALIDATION_TIMEOUT ((guint) 15)
#define GEARY_SMTP_CLIENT_CONNECTION_DEFAULT_TIMEOUT_SEC ((guint) 20)

#define GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF (geary_engine_endpoint_weak_ref_get_type ())
#define GEARY_ENGINE_ENDPOINT_WEAK_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF, GearyEngineEndpointWeakRef))
#define GEARY_ENGINE_ENDPOINT_WEAK_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF, GearyEngineEndpointWeakRefClass))
#define GEARY_ENGINE_IS_ENDPOINT_WEAK_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF))
#define GEARY_ENGINE_IS_ENDPOINT_WEAK_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF))
#define GEARY_ENGINE_ENDPOINT_WEAK_REF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF, GearyEngineEndpointWeakRefClass))

typedef struct _GearyEngineEndpointWeakRef GearyEngineEndpointWeakRef;
typedef struct _GearyEngineEndpointWeakRefClass GearyEngineEndpointWeakRefClass;
enum  {
	GEARY_ENGINE_0_PROPERTY,
	GEARY_ENGINE_HAS_ACCOUNTS_PROPERTY,
	GEARY_ENGINE_ACCOUNTS_COUNT_PROPERTY,
	GEARY_ENGINE_RESOURCE_DIR_PROPERTY,
	GEARY_ENGINE_NUM_PROPERTIES
};
static GParamSpec* geary_engine_properties[GEARY_ENGINE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block7Data Block7Data;

#define GEARY_IMAP_DB_TYPE_ACCOUNT (geary_imap_db_account_get_type ())
#define GEARY_IMAP_DB_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_ACCOUNT, GearyImapDBAccount))
#define GEARY_IMAP_DB_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_ACCOUNT, GearyImapDBAccountClass))
#define GEARY_IMAP_DB_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_ACCOUNT))
#define GEARY_IMAP_DB_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_ACCOUNT))
#define GEARY_IMAP_DB_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_ACCOUNT, GearyImapDBAccountClass))

typedef struct _GearyImapDBAccount GearyImapDBAccount;
typedef struct _GearyImapDBAccountClass GearyImapDBAccountClass;

#define GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT (geary_imap_engine_generic_account_get_type ())
#define GEARY_IMAP_ENGINE_GENERIC_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT, GearyImapEngineGenericAccount))
#define GEARY_IMAP_ENGINE_GENERIC_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT, GearyImapEngineGenericAccountClass))
#define GEARY_IMAP_ENGINE_IS_GENERIC_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT))
#define GEARY_IMAP_ENGINE_IS_GENERIC_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT))
#define GEARY_IMAP_ENGINE_GENERIC_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT, GearyImapEngineGenericAccountClass))

typedef struct _GearyImapEngineGenericAccount GearyImapEngineGenericAccount;
typedef struct _GearyImapEngineGenericAccountClass GearyImapEngineGenericAccountClass;

#define GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT (geary_imap_engine_gmail_account_get_type ())
#define GEARY_IMAP_ENGINE_GMAIL_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT, GearyImapEngineGmailAccount))
#define GEARY_IMAP_ENGINE_GMAIL_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT, GearyImapEngineGmailAccountClass))
#define GEARY_IMAP_ENGINE_IS_GMAIL_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT))
#define GEARY_IMAP_ENGINE_IS_GMAIL_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT))
#define GEARY_IMAP_ENGINE_GMAIL_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT, GearyImapEngineGmailAccountClass))

typedef struct _GearyImapEngineGmailAccount GearyImapEngineGmailAccount;
typedef struct _GearyImapEngineGmailAccountClass GearyImapEngineGmailAccountClass;

#define GEARY_IMAP_ENGINE_TYPE_OUTLOOK_ACCOUNT (geary_imap_engine_outlook_account_get_type ())
#define GEARY_IMAP_ENGINE_OUTLOOK_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_OUTLOOK_ACCOUNT, GearyImapEngineOutlookAccount))
#define GEARY_IMAP_ENGINE_OUTLOOK_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_OUTLOOK_ACCOUNT, GearyImapEngineOutlookAccountClass))
#define GEARY_IMAP_ENGINE_IS_OUTLOOK_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_OUTLOOK_ACCOUNT))
#define GEARY_IMAP_ENGINE_IS_OUTLOOK_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_OUTLOOK_ACCOUNT))
#define GEARY_IMAP_ENGINE_OUTLOOK_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_OUTLOOK_ACCOUNT, GearyImapEngineOutlookAccountClass))

typedef struct _GearyImapEngineOutlookAccount GearyImapEngineOutlookAccount;
typedef struct _GearyImapEngineOutlookAccountClass GearyImapEngineOutlookAccountClass;

#define GEARY_IMAP_ENGINE_TYPE_OTHER_ACCOUNT (geary_imap_engine_other_account_get_type ())
#define GEARY_IMAP_ENGINE_OTHER_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_OTHER_ACCOUNT, GearyImapEngineOtherAccount))
#define GEARY_IMAP_ENGINE_OTHER_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_OTHER_ACCOUNT, GearyImapEngineOtherAccountClass))
#define GEARY_IMAP_ENGINE_IS_OTHER_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_OTHER_ACCOUNT))
#define GEARY_IMAP_ENGINE_IS_OTHER_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_OTHER_ACCOUNT))
#define GEARY_IMAP_ENGINE_OTHER_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_OTHER_ACCOUNT, GearyImapEngineOtherAccountClass))

typedef struct _GearyImapEngineOtherAccount GearyImapEngineOtherAccount;
typedef struct _GearyImapEngineOtherAccountClass GearyImapEngineOtherAccountClass;
typedef struct _Block8Data Block8Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyEngineValidateImapData GearyEngineValidateImapData;
typedef struct _Block9Data Block9Data;
#define _geary_smtp_response_unref0(var) ((var == NULL) ? NULL : (var = (geary_smtp_response_unref (var), NULL)))
typedef struct _GearyEngineValidateSmtpData GearyEngineValidateSmtpData;
typedef struct _GearyEngineUpdateAccountServiceData GearyEngineUpdateAccountServiceData;
#define _geary_engine_endpoint_weak_ref_unref0(var) ((var == NULL) ? NULL : (var = (geary_engine_endpoint_weak_ref_unref (var), NULL)))
typedef struct _GearyEngineEndpointWeakRefPrivate GearyEngineEndpointWeakRefPrivate;
typedef struct _GearyEngineParamSpecEndpointWeakRef GearyEngineParamSpecEndpointWeakRef;
enum  {
	GEARY_ENGINE_ACCOUNT_AVAILABLE_SIGNAL,
	GEARY_ENGINE_ACCOUNT_UNAVAILABLE_SIGNAL,
	GEARY_ENGINE_NUM_SIGNALS
};
static guint geary_engine_signals[GEARY_ENGINE_NUM_SIGNALS] = {0};

struct _GearyEnginePrivate {
	GFile* _resource_dir;
	gboolean is_open;
	GeeList* accounts;
	GeeMap* shared_endpoints;
};

struct _Block5Data {
	int _ref_count_;
	GearyEngine* self;
	GearyAccountInformation* config;
};

struct _Block6Data {
	int _ref_count_;
	GearyEngine* self;
	GearyAccountInformation* config;
};

struct _Block7Data {
	int _ref_count_;
	GearyEngine* self;
	gchar* id;
};

struct _Block8Data {
	int _ref_count_;
	GearyEngine* self;
	GearyAccountInformation* account;
	GearyServiceInformation* service;
	gpointer _async_data_;
};

struct _GearyEngineValidateImapData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyEngine* self;
	GearyAccountInformation* account;
	GearyServiceInformation* service;
	GCancellable* cancellable;
	Block8Data* _data8_;
	GearyEndpoint* endpoint;
	GearyServiceProvider _tmp0_;
	GearyServiceProvider _tmp1_;
	GearyEndpoint* _tmp2_;
	gulong untrusted_id;
	GearyEndpoint* _tmp3_;
	gulong _tmp4_;
	GearyImapClientSession* client;
	GearyEndpoint* _tmp5_;
	GearyImapQuirks* _tmp6_;
	GearyImapQuirks* _tmp7_;
	GearyImapClientSession* _tmp8_;
	GearyImapClientSession* _tmp9_;
	GError* imap_err;
	GearyImapClientSession* _tmp10_;
	GError* err;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GearyImapClientSession* _tmp14_;
	GearyCredentials* _tmp15_;
	GearyCredentials* _tmp16_;
	GError* _vala1_err;
	GError* _tmp17_;
	GError* _tmp18_;
	GearyImapClientSession* _tmp19_;
	GearyEndpoint* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	GError* _tmp23_;
	GError* _inner_error0_;
};

struct _Block9Data {
	int _ref_count_;
	GearyEngine* self;
	GearyAccountInformation* account;
	GearyServiceInformation* service;
	gpointer _async_data_;
};

struct _GearyEngineValidateSmtpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyEngine* self;
	GearyAccountInformation* account;
	GearyServiceInformation* service;
	GearyCredentials* incoming_credentials;
	GCancellable* cancellable;
	Block9Data* _data9_;
	GearyEndpoint* endpoint;
	GearyServiceProvider _tmp0_;
	GearyServiceProvider _tmp1_;
	GearyEndpoint* _tmp2_;
	gulong untrusted_id;
	GearyEndpoint* _tmp3_;
	gulong _tmp4_;
	GearyCredentials* credentials;
	GearyCredentialsRequirement _tmp5_;
	GearyCredentialsRequirement _tmp6_;
	GearyCredentials* _tmp7_;
	GearyCredentials* _tmp8_;
	GearyCredentials* _tmp9_;
	GearyCredentials* _tmp10_;
	GearySmtpClientSession* client;
	GearyEndpoint* _tmp11_;
	GearySmtpClientSession* _tmp12_;
	GError* login_err;
	GearySmtpClientSession* _tmp13_;
	GearyCredentials* _tmp14_;
	GearySmtpGreeting* _tmp15_;
	GearySmtpGreeting* _tmp16_;
	GError* err;
	GError* _tmp17_;
	GError* _tmp18_;
	GearySmtpClientSession* _tmp19_;
	GearySmtpResponse* _tmp20_;
	GearySmtpResponse* _tmp21_;
	GearyEndpoint* _tmp22_;
	GError* _tmp23_;
	GError* _tmp24_;
	GError* _tmp25_;
	GError* _inner_error0_;
};

struct _GearyEngineUpdateAccountServiceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyEngine* self;
	GearyAccountInformation* config;
	GearyServiceInformation* updated;
	GCancellable* cancellable;
	GearyAccount* account;
	GearyAccount* _tmp0_;
	GearyClientService* service;
	GearyProtocol _tmp1_;
	GearyProtocol _tmp2_;
	GearyAccount* _tmp3_;
	GearyClientService* _tmp4_;
	GearyClientService* _tmp5_;
	GearyClientService* _tmp6_;
	GearyAccount* _tmp7_;
	GearyClientService* _tmp8_;
	GearyClientService* _tmp9_;
	GearyClientService* _tmp10_;
	GearyEndpoint* remote;
	GearyServiceProvider _tmp11_;
	GearyServiceProvider _tmp12_;
	GearyEndpoint* _tmp13_;
	GearyClientService* _tmp14_;
	GearyEndpoint* _tmp15_;
	GError* _inner_error0_;
};

struct _GearyEngineEndpointWeakRef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GearyEngineEndpointWeakRefPrivate * priv;
};

struct _GearyEngineEndpointWeakRefClass {
	GTypeClass parent_class;
	void (*finalize) (GearyEngineEndpointWeakRef *self);
};

struct _GearyEngineEndpointWeakRefPrivate {
	GWeakRef weak_ref;
};

struct _GearyEngineParamSpecEndpointWeakRef {
	GParamSpec parent_instance;
};

static gint GearyEngine_private_offset;
static gpointer geary_engine_parent_class = NULL;
static gboolean geary_engine_is_initialized;
static gboolean geary_engine_is_initialized = FALSE;
static gint GearyEngineEndpointWeakRef_private_offset;
static gpointer geary_engine_endpoint_weak_ref_parent_class = NULL;

static gpointer geary_engine_endpoint_weak_ref_ref (gpointer instance);
static void geary_engine_endpoint_weak_ref_unref (gpointer instance);
static GParamSpec* geary_engine_param_spec_endpoint_weak_ref (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED ;
static void geary_engine_value_set_endpoint_weak_ref (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static void geary_engine_value_take_endpoint_weak_ref (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static gpointer geary_engine_value_get_endpoint_weak_ref (const GValue* value) G_GNUC_UNUSED ;
static GType geary_engine_endpoint_weak_ref_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void geary_engine_initialize_library (void);
VALA_EXTERN void geary_imap_init (void);
static void geary_engine_set_resource_dir (GearyEngine* self,
                                    GFile* value);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda150_ (Block5Data* _data5_,
                       GearyAccount* account);
static gboolean ___lambda150__gee_predicate (gconstpointer g,
                                      gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void geary_engine_check_opened (GearyEngine* self,
                                GError** error);
static gboolean __lambda148_ (Block6Data* _data6_,
                       GearyAccount* account);
static gboolean ___lambda148__gee_predicate (gconstpointer g,
                                      gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean __lambda151_ (Block7Data* _data7_,
                       GearyAccount* account);
static gboolean ___lambda151__gee_predicate (gconstpointer g,
                                      gpointer self);
VALA_EXTERN GType geary_imap_db_account_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapDBAccount* geary_imap_db_account_new (GearyAccountInformation* config,
                                               GFile* data_dir,
                                               GFile* schema_dir);
VALA_EXTERN GearyImapDBAccount* geary_imap_db_account_construct (GType object_type,
                                                     GearyAccountInformation* config,
                                                     GFile* data_dir,
                                                     GFile* schema_dir);
static GearyEndpoint* geary_engine_get_shared_endpoint (GearyEngine* self,
                                                 GearyServiceProvider provider,
                                                 GearyServiceInformation* service);
VALA_EXTERN GearyImapEngineGmailAccount* geary_imap_engine_gmail_account_new (GearyAccountInformation* config,
                                                                  GearyImapDBAccount* local,
                                                                  GearyEndpoint* incoming_remote,
                                                                  GearyEndpoint* outgoing_remote);
VALA_EXTERN GearyImapEngineGmailAccount* geary_imap_engine_gmail_account_construct (GType object_type,
                                                                        GearyAccountInformation* config,
                                                                        GearyImapDBAccount* local,
                                                                        GearyEndpoint* incoming_remote,
                                                                        GearyEndpoint* outgoing_remote);
VALA_EXTERN GType geary_imap_engine_generic_account_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_gmail_account_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapEngineOutlookAccount* geary_imap_engine_outlook_account_new (GearyAccountInformation* config,
                                                                      GearyImapDBAccount* local,
                                                                      GearyEndpoint* incoming_remote,
                                                                      GearyEndpoint* outgoing_remote);
VALA_EXTERN GearyImapEngineOutlookAccount* geary_imap_engine_outlook_account_construct (GType object_type,
                                                                            GearyAccountInformation* config,
                                                                            GearyImapDBAccount* local,
                                                                            GearyEndpoint* incoming_remote,
                                                                            GearyEndpoint* outgoing_remote);
VALA_EXTERN GType geary_imap_engine_outlook_account_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapEngineOtherAccount* geary_imap_engine_other_account_new (GearyAccountInformation* config,
                                                                  GearyImapDBAccount* local,
                                                                  GearyEndpoint* incoming_remote,
                                                                  GearyEndpoint* outgoing_remote);
VALA_EXTERN GearyImapEngineOtherAccount* geary_imap_engine_other_account_construct (GType object_type,
                                                                        GearyAccountInformation* config,
                                                                        GearyImapDBAccount* local,
                                                                        GearyEndpoint* incoming_remote,
                                                                        GearyEndpoint* outgoing_remote);
VALA_EXTERN GType geary_imap_engine_other_account_get_type (void) G_GNUC_CONST ;
static void geary_engine_on_account_ordinal_changed (GearyEngine* self);
static void _geary_engine_on_account_ordinal_changed_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void geary_engine_sort_accounts (GearyEngine* self);
static void geary_engine_validate_imap_data_free (gpointer _data);
static gboolean geary_engine_validate_imap_co (GearyEngineValidateImapData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static inline GearyEndpoint* geary_engine_new_endpoint (GearyEngine* self,
                                          GearyServiceProvider provider,
                                          GearyServiceInformation* service,
                                          guint timeout);
static void __lambda152_ (Block8Data* _data8_,
                   GearyEndpoint* security,
                   GTlsConnection* cx);
static void ___lambda152__geary_endpoint_untrusted_host (GearyEndpoint* _sender,
                                                  GTlsConnection* cx,
                                                  gpointer self);
static void geary_engine_validate_imap_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void geary_engine_validate_smtp_data_free (gpointer _data);
static gboolean geary_engine_validate_smtp_co (GearyEngineValidateSmtpData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda153_ (Block9Data* _data9_,
                   GearyEndpoint* security,
                   GTlsConnection* cx);
static void ___lambda153__geary_endpoint_untrusted_host (GearyEndpoint* _sender,
                                                  GTlsConnection* cx,
                                                  gpointer self);
static void geary_engine_validate_smtp_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void geary_engine_update_account_service_data_free (gpointer _data);
static gboolean geary_engine_update_account_service_co (GearyEngineUpdateAccountServiceData* _data_);
static void geary_engine_update_account_service_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static GearyEndpoint* geary_engine_endpoint_weak_ref_get (GearyEngineEndpointWeakRef* self);
static GearyEngineEndpointWeakRef* geary_engine_endpoint_weak_ref_new (GearyEndpoint* endpoint);
static GearyEngineEndpointWeakRef* geary_engine_endpoint_weak_ref_construct (GType object_type,
                                                                      GearyEndpoint* endpoint);
static gint __lambda149_ (GearyEngine* self,
                   GearyAccount* a,
                   GearyAccount* b);
static gint ___lambda149__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static void geary_engine_endpoint_weak_ref_finalize (GearyEngineEndpointWeakRef * obj);
static GType geary_engine_endpoint_weak_ref_get_type_once (void);
static void geary_engine_finalize (GObject * obj);
static GType geary_engine_get_type_once (void);
static void _vala_geary_engine_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_geary_engine_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
geary_engine_get_instance_private (GearyEngine* self)
{
	return G_STRUCT_MEMBER_P (self, GearyEngine_private_offset);
}

static void
geary_engine_initialize_library (void)
{
	if (!geary_engine_is_initialized) {
		geary_engine_is_initialized = TRUE;
		geary_logging_init ();
		geary_rf_c822_init ();
		geary_imap_init ();
		geary_html_init ();
	}
}

gboolean
geary_engine_get_has_accounts (GearyEngine* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (GEARY_IS_ENGINE (self), FALSE);
	if (self->priv->is_open) {
		GeeList* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->accounts;
		_tmp2_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

guint
geary_engine_get_accounts_count (GearyEngine* self)
{
	guint result;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (GEARY_IS_ENGINE (self), 0U);
	_tmp0_ = self->priv->accounts;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

GFile*
geary_engine_get_resource_dir (GearyEngine* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ENGINE (self), NULL);
	_tmp0_ = self->priv->_resource_dir;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_engine_set_resource_dir (GearyEngine* self,
                               GFile* value)
{
	GFile* old_value;
	g_return_if_fail (GEARY_IS_ENGINE (self));
	old_value = geary_engine_get_resource_dir (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_resource_dir);
		self->priv->_resource_dir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_engine_properties[GEARY_ENGINE_RESOURCE_DIR_PROPERTY]);
	}
}

/** Constructs a new engine instance. */
GearyEngine*
geary_engine_construct (GType object_type,
                        GFile* resource_dir)
{
	GearyEngine * self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (resource_dir, g_file_get_type ()), NULL);
	self = (GearyEngine*) geary_base_object_construct (object_type);
	geary_engine_initialize_library ();
	geary_engine_set_resource_dir (self, resource_dir);
	return self;
}

GearyEngine*
geary_engine_new (GFile* resource_dir)
{
	return geary_engine_construct (GEARY_TYPE_ENGINE, resource_dir);
}

/**
     * Uninitializes the engine, and removes all known accounts.
     */
void
geary_engine_close (GearyEngine* self,
                    GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IS_ENGINE (self));
	if (self->priv->is_open) {
		GeeList* _tmp15_;
		{
			GeeLinkedList* _account_list = NULL;
			GeeList* _tmp0_;
			GearyIterable* _tmp1_;
			GearyIterable* _tmp2_;
			GeeLinkedList* _tmp3_;
			GeeLinkedList* _tmp4_;
			gint _account_size = 0;
			GeeLinkedList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _account_index = 0;
			_tmp0_ = self->priv->accounts;
			_tmp1_ = geary_traverse (GEARY_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp2_ = _tmp1_;
			_tmp3_ = geary_iterable_to_linked_list (_tmp2_, NULL, NULL, NULL);
			_tmp4_ = _tmp3_;
			_g_object_unref0 (_tmp2_);
			_account_list = _tmp4_;
			_tmp5_ = _account_list;
			_tmp6_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp7_ = _tmp6_;
			_account_size = _tmp7_;
			_account_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				GearyAccount* account = NULL;
				GeeLinkedList* _tmp10_;
				gpointer _tmp11_;
				GearyAccount* _tmp12_;
				GearyAccountInformation* _tmp13_;
				GearyAccountInformation* _tmp14_;
				_account_index = _account_index + 1;
				_tmp8_ = _account_index;
				_tmp9_ = _account_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _account_list;
				_tmp11_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _account_index);
				account = (GearyAccount*) _tmp11_;
				_tmp12_ = account;
				_tmp13_ = geary_account_get_information (_tmp12_);
				_tmp14_ = _tmp13_;
				geary_engine_remove_account (self, _tmp14_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (account);
					_g_object_unref0 (_account_list);
					return;
				}
				_g_object_unref0 (account);
			}
			_g_object_unref0 (_account_list);
		}
		_tmp15_ = self->priv->accounts;
		gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection));
		self->priv->is_open = FALSE;
	}
}

/**
     * Determines if an account with a specific configuration has been added.
     */
static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GearyEngine* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->config);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda150_ (Block5Data* _data5_,
              GearyAccount* account)
{
	GearyEngine* self;
	GearyAccountInformation* _tmp0_;
	GearyAccountInformation* _tmp1_;
	gboolean result;
	self = _data5_->self;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (account), FALSE);
	_tmp0_ = geary_account_get_information (account);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == _data5_->config;
	return result;
}

static gboolean
___lambda150__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda150_ (self, (GearyAccount*) g);
	return result;
}

gboolean
geary_engine_has_account (GearyEngine* self,
                          GearyAccountInformation* config)
{
	Block5Data* _data5_;
	GearyAccountInformation* _tmp0_;
	GeeList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_ENGINE (self), FALSE);
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (config), FALSE);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (_data5_->config);
	_data5_->config = _tmp0_;
	_tmp1_ = self->priv->accounts;
	result = gee_traversable_any_match (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_TRAVERSABLE, GeeTraversable), ___lambda150__gee_predicate, block5_data_ref (_data5_), block5_data_unref);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

/**
     * Returns the account for the given configuration, if present.
     *
     * Throws an error if the engine has not been opened or if the
     * requested account does not exist.
     */
static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GearyEngine* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->config);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
__lambda148_ (Block6Data* _data6_,
              GearyAccount* account)
{
	GearyEngine* self;
	GearyAccountInformation* _tmp0_;
	GearyAccountInformation* _tmp1_;
	gboolean result;
	self = _data6_->self;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (account), FALSE);
	_tmp0_ = geary_account_get_information (account);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == _data6_->config;
	return result;
}

static gboolean
___lambda148__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda148_ (self, (GearyAccount*) g);
	return result;
}

GearyAccount*
geary_engine_get_account (GearyEngine* self,
                          GearyAccountInformation* config,
                          GError** error)
{
	Block6Data* _data6_;
	GearyAccountInformation* _tmp0_;
	GearyAccount* account = NULL;
	GeeList* _tmp1_;
	gpointer _tmp2_;
	GearyAccount* _tmp3_;
	GError* _inner_error0_ = NULL;
	GearyAccount* result;
	g_return_val_if_fail (GEARY_IS_ENGINE (self), NULL);
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (config), NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (_data6_->config);
	_data6_->config = _tmp0_;
	geary_engine_check_opened (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return NULL;
	}
	_tmp1_ = self->priv->accounts;
	_tmp2_ = gee_traversable_first_match (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_TRAVERSABLE, GeeTraversable), ___lambda148__gee_predicate, block6_data_ref (_data6_), block6_data_unref);
	account = (GearyAccount*) _tmp2_;
	_tmp3_ = account;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "No such account");
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (account);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return NULL;
	}
	result = account;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}

/**
     * Returns the account for the given configuration id, if present.
     *
     * Throws an error if the engine has not been opened or if the
     * requested account does not exist.
     */
static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GearyEngine* self;
		self = _data7_->self;
		_g_free0 (_data7_->id);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
__lambda151_ (Block7Data* _data7_,
              GearyAccount* account)
{
	GearyEngine* self;
	GearyAccountInformation* _tmp0_;
	GearyAccountInformation* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	self = _data7_->self;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (account), FALSE);
	_tmp0_ = geary_account_get_information (account);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_account_information_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	result = g_strcmp0 (_tmp3_, _data7_->id) == 0;
	return result;
}

static gboolean
___lambda151__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda151_ (self, (GearyAccount*) g);
	return result;
}

GearyAccount*
geary_engine_get_account_for_id (GearyEngine* self,
                                 const gchar* id,
                                 GError** error)
{
	Block7Data* _data7_;
	gchar* _tmp0_;
	GearyAccount* account = NULL;
	GeeList* _tmp1_;
	gpointer _tmp2_;
	GearyAccount* _tmp3_;
	GError* _inner_error0_ = NULL;
	GearyAccount* result;
	g_return_val_if_fail (GEARY_IS_ENGINE (self), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = g_strdup (id);
	_g_free0 (_data7_->id);
	_data7_->id = _tmp0_;
	geary_engine_check_opened (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return NULL;
	}
	_tmp1_ = self->priv->accounts;
	_tmp2_ = gee_traversable_first_match (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_TRAVERSABLE, GeeTraversable), ___lambda151__gee_predicate, block7_data_ref (_data7_), block7_data_unref);
	account = (GearyAccount*) _tmp2_;
	_tmp3_ = account;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "No such account");
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (account);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return NULL;
	}
	result = account;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}

/**
     * Returns a read-only collection of current accounts.
     *
     * The collection is guaranteed to be ordered by {@link
     * AccountInformation.compare_ascending}.
     *
     * Throws an error if the engine has not been opened.
     */
GeeCollection*
geary_engine_get_accounts (GearyEngine* self,
                           GError** error)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GError* _inner_error0_ = NULL;
	GeeCollection* result;
	g_return_val_if_fail (GEARY_IS_ENGINE (self), NULL);
	geary_engine_check_opened (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = self->priv->accounts;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

/**
     * Adds the account to the engine.
     *
     * The account will not be automatically opened, this must be done
     * once added.
     */
static void
_geary_engine_on_account_ordinal_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	geary_engine_on_account_ordinal_changed ((GearyEngine*) self);
}

void
geary_engine_add_account (GearyEngine* self,
                          GearyAccountInformation* config,
                          GError** error)
{
	GearyImapDBAccount* local = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GearyImapDBAccount* _tmp6_;
	GearyImapDBAccount* _tmp7_;
	GearyEndpoint* incoming_remote = NULL;
	GearyServiceProvider _tmp8_;
	GearyServiceProvider _tmp9_;
	GearyServiceInformation* _tmp10_;
	GearyServiceInformation* _tmp11_;
	GearyEndpoint* _tmp12_;
	GearyEndpoint* outgoing_remote = NULL;
	GearyServiceProvider _tmp13_;
	GearyServiceProvider _tmp14_;
	GearyServiceInformation* _tmp15_;
	GearyServiceInformation* _tmp16_;
	GearyEndpoint* _tmp17_;
	GearyAccount* account = NULL;
	GearyServiceProvider _tmp18_;
	GearyServiceProvider _tmp19_;
	GeeList* _tmp32_;
	GearyAccount* _tmp33_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IS_ENGINE (self));
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (config));
	geary_engine_check_opened (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (geary_engine_has_account (self, config)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_ALREADY_EXISTS, "Account already exists");
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = geary_account_information_get_data_dir (config);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_resource_dir;
	_tmp4_ = g_file_get_child (_tmp3_, "sql");
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_imap_db_account_new (config, _tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	local = _tmp7_;
	_tmp8_ = geary_account_information_get_service_provider (config);
	_tmp9_ = _tmp8_;
	_tmp10_ = geary_account_information_get_incoming (config);
	_tmp11_ = _tmp10_;
	_tmp12_ = geary_engine_get_shared_endpoint (self, _tmp9_, _tmp11_);
	incoming_remote = _tmp12_;
	_tmp13_ = geary_account_information_get_service_provider (config);
	_tmp14_ = _tmp13_;
	_tmp15_ = geary_account_information_get_outgoing (config);
	_tmp16_ = _tmp15_;
	_tmp17_ = geary_engine_get_shared_endpoint (self, _tmp14_, _tmp16_);
	outgoing_remote = _tmp17_;
	_tmp18_ = geary_account_information_get_service_provider (config);
	_tmp19_ = _tmp18_;
	switch (_tmp19_) {
		case GEARY_SERVICE_PROVIDER_GMAIL:
		{
			GearyImapDBAccount* _tmp20_;
			GearyEndpoint* _tmp21_;
			GearyEndpoint* _tmp22_;
			GearyImapEngineGmailAccount* _tmp23_;
			_tmp20_ = local;
			_tmp21_ = incoming_remote;
			_tmp22_ = outgoing_remote;
			_tmp23_ = geary_imap_engine_gmail_account_new (config, _tmp20_, _tmp21_, _tmp22_);
			_g_object_unref0 (account);
			account = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEARY_TYPE_ACCOUNT, GearyAccount);
			break;
		}
		case GEARY_SERVICE_PROVIDER_OUTLOOK:
		{
			GearyImapDBAccount* _tmp24_;
			GearyEndpoint* _tmp25_;
			GearyEndpoint* _tmp26_;
			GearyImapEngineOutlookAccount* _tmp27_;
			_tmp24_ = local;
			_tmp25_ = incoming_remote;
			_tmp26_ = outgoing_remote;
			_tmp27_ = geary_imap_engine_outlook_account_new (config, _tmp24_, _tmp25_, _tmp26_);
			_g_object_unref0 (account);
			account = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEARY_TYPE_ACCOUNT, GearyAccount);
			break;
		}
		default:
		{
			GearyImapDBAccount* _tmp28_;
			GearyEndpoint* _tmp29_;
			GearyEndpoint* _tmp30_;
			GearyImapEngineOtherAccount* _tmp31_;
			_tmp28_ = local;
			_tmp29_ = incoming_remote;
			_tmp30_ = outgoing_remote;
			_tmp31_ = geary_imap_engine_other_account_new (config, _tmp28_, _tmp29_, _tmp30_);
			_g_object_unref0 (account);
			account = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEARY_TYPE_ACCOUNT, GearyAccount);
			break;
		}
	}
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (config, G_TYPE_OBJECT, GObject), "notify::ordinal", (GCallback) _geary_engine_on_account_ordinal_changed_g_object_notify, self, 0);
	_tmp32_ = self->priv->accounts;
	_tmp33_ = account;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COLLECTION, GeeCollection), _tmp33_);
	geary_engine_sort_accounts (self);
	g_signal_emit (self, geary_engine_signals[GEARY_ENGINE_ACCOUNT_AVAILABLE_SIGNAL], 0, config);
	_g_object_unref0 (account);
	_g_object_unref0 (outgoing_remote);
	_g_object_unref0 (incoming_remote);
	_g_object_unref0 (local);
}

/**
     * Removes an account from the engine.
     *
     * The account must be closed before removing it.
     */
void
geary_engine_remove_account (GearyEngine* self,
                             GearyAccountInformation* config,
                             GError** error)
{
	GearyAccount* account = NULL;
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	guint _tmp3_;
	GQuark _tmp4_;
	GeeList* _tmp5_;
	GearyAccount* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IS_ENGINE (self));
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (config));
	geary_engine_check_opened (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp0_ = geary_engine_get_account (self, config, &_inner_error0_);
	account = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = account;
	if (geary_account_is_open (_tmp1_)) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_CLOSE_REQUIRED, "Account must be closed before removal");
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (account);
		return;
	}
	g_signal_parse_name ("notify::ordinal", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (config, G_TYPE_OBJECT, GObject), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _geary_engine_on_account_ordinal_changed_g_object_notify, self);
	_tmp5_ = self->priv->accounts;
	_tmp6_ = account;
	gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection), _tmp6_);
	g_signal_emit (self, geary_engine_signals[GEARY_ENGINE_ACCOUNT_UNAVAILABLE_SIGNAL], 0, config);
	_g_object_unref0 (account);
}

static void
geary_engine_validate_imap_data_free (gpointer _data)
{
	GearyEngineValidateImapData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyEngineValidateImapData, _data_);
}

void
geary_engine_validate_imap (GearyEngine* self,
                            GearyAccountInformation* account,
                            GearyServiceInformation* service,
                            GCancellable* cancellable,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	GearyEngineValidateImapData* _data_;
	GearyEngine* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyServiceInformation* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_IS_ENGINE (self));
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (account));
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (service));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyEngineValidateImapData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_engine_validate_imap_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (service);
	_g_object_unref0 (_data_->service);
	_data_->service = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_engine_validate_imap_co (_data_);
}

void
geary_engine_validate_imap_finish (GearyEngine* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	GearyEngineValidateImapData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Determines if an account's IMAP service can be connected to.
     */
static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		GearyEngine* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->account);
		_g_object_unref0 (_data8_->service);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda152_ (Block8Data* _data8_,
              GearyEndpoint* security,
              GTlsConnection* cx)
{
	GearyEngine* self;
	self = _data8_->self;
	g_return_if_fail (GEARY_IS_ENDPOINT (security));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cx, g_tls_connection_get_type ()));
	g_signal_emit_by_name (_data8_->account, "untrusted-host", _data8_->service, security, cx);
}

static void
___lambda152__geary_endpoint_untrusted_host (GearyEndpoint* _sender,
                                             GTlsConnection* cx,
                                             gpointer self)
{
	__lambda152_ (self, _sender, cx);
}

static void
geary_engine_validate_imap_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	GearyEngineValidateImapData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_engine_validate_imap_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
geary_engine_validate_imap_co (GearyEngineValidateImapData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data8_->account);
	_data_->_data8_->account = _data_->account;
	_g_object_unref0 (_data_->_data8_->service);
	_data_->_data8_->service = _data_->service;
	_data_->_data8_->_async_data_ = _data_;
	geary_engine_check_opened (_data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = geary_account_information_get_service_provider (_data_->_data8_->account);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = geary_engine_new_endpoint (_data_->self, _data_->_tmp1_, _data_->_data8_->service, GEARY_ENGINE_VALIDATION_TIMEOUT);
	_data_->endpoint = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->endpoint;
	_data_->_tmp4_ = g_signal_connect_data (_data_->_tmp3_, "untrusted-host", (GCallback) ___lambda152__geary_endpoint_untrusted_host, block8_data_ref (_data_->_data8_), (GClosureNotify) block8_data_unref, 0);
	_data_->untrusted_id = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->endpoint;
	_data_->_tmp6_ = geary_imap_quirks_new ();
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = geary_imap_client_session_new (_data_->_tmp5_, _data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_g_object_unref0 (_data_->_tmp7_);
	_data_->client = _data_->_tmp9_;
	_data_->imap_err = NULL;
	{
		_data_->_tmp10_ = _data_->client;
		_data_->_state_ = 1;
		geary_imap_client_session_connect_async (_data_->_tmp10_, GEARY_IMAP_CLIENT_SESSION_DEFAULT_GREETING_TIMEOUT_SEC, _data_->cancellable, geary_engine_validate_imap_ready, _data_);
		return FALSE;
		_state_1:
		geary_imap_client_session_connect_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->err;
		_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
		_g_error_free0 (_data_->imap_err);
		_data_->imap_err = _data_->_tmp12_;
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->imap_err);
		_g_object_unref0 (_data_->client);
		_g_object_unref0 (_data_->endpoint);
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->imap_err;
	if (_data_->_tmp13_ == NULL) {
		{
			_data_->_tmp14_ = _data_->client;
			_data_->_tmp15_ = geary_service_information_get_credentials (_data_->_data8_->service);
			_data_->_tmp16_ = _data_->_tmp15_;
			_data_->_state_ = 2;
			geary_imap_client_session_initiate_session_async (_data_->_tmp14_, _data_->_tmp16_, _data_->cancellable, geary_engine_validate_imap_ready, _data_);
			return FALSE;
			_state_2:
			geary_imap_client_session_initiate_session_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp17_ = _data_->_vala1_err;
			_data_->_tmp18_ = _g_error_copy0 (_data_->_tmp17_);
			_g_error_free0 (_data_->imap_err);
			_data_->imap_err = _data_->_tmp18_;
			_g_error_free0 (_data_->_vala1_err);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_error_free0 (_data_->imap_err);
			_g_object_unref0 (_data_->client);
			_g_object_unref0 (_data_->endpoint);
			block8_data_unref (_data_->_data8_);
			_data_->_data8_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp19_ = _data_->client;
			_data_->_state_ = 3;
			geary_imap_client_session_disconnect_async (_data_->_tmp19_, _data_->cancellable, geary_engine_validate_imap_ready, _data_);
			return FALSE;
			_state_3:
			geary_imap_client_session_disconnect_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_error_free0 (_data_->imap_err);
			_g_object_unref0 (_data_->client);
			_g_object_unref0 (_data_->endpoint);
			block8_data_unref (_data_->_data8_);
			_data_->_data8_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp20_ = _data_->endpoint;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp20_, G_TYPE_OBJECT, GObject), _data_->untrusted_id);
	_data_->_tmp21_ = _data_->imap_err;
	if (_data_->_tmp21_ != NULL) {
		_data_->_tmp22_ = _data_->imap_err;
		_data_->_tmp23_ = _g_error_copy0 (_data_->_tmp22_);
		_data_->_inner_error0_ = _data_->_tmp23_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->imap_err);
		_g_object_unref0 (_data_->client);
		_g_object_unref0 (_data_->endpoint);
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_error_free0 (_data_->imap_err);
	_g_object_unref0 (_data_->client);
	_g_object_unref0 (_data_->endpoint);
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_engine_validate_smtp_data_free (gpointer _data)
{
	GearyEngineValidateSmtpData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->incoming_credentials);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyEngineValidateSmtpData, _data_);
}

void
geary_engine_validate_smtp (GearyEngine* self,
                            GearyAccountInformation* account,
                            GearyServiceInformation* service,
                            GearyCredentials* incoming_credentials,
                            GCancellable* cancellable,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	GearyEngineValidateSmtpData* _data_;
	GearyEngine* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyServiceInformation* _tmp2_;
	GearyCredentials* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (GEARY_IS_ENGINE (self));
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (account));
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (service));
	g_return_if_fail ((incoming_credentials == NULL) || GEARY_IS_CREDENTIALS (incoming_credentials));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyEngineValidateSmtpData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_engine_validate_smtp_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (service);
	_g_object_unref0 (_data_->service);
	_data_->service = _tmp2_;
	_tmp3_ = _g_object_ref0 (incoming_credentials);
	_g_object_unref0 (_data_->incoming_credentials);
	_data_->incoming_credentials = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	geary_engine_validate_smtp_co (_data_);
}

void
geary_engine_validate_smtp_finish (GearyEngine* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	GearyEngineValidateSmtpData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Determines if an account's SMTP service can be connected to.
     */
static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		GearyEngine* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->account);
		_g_object_unref0 (_data9_->service);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda153_ (Block9Data* _data9_,
              GearyEndpoint* security,
              GTlsConnection* cx)
{
	GearyEngine* self;
	self = _data9_->self;
	g_return_if_fail (GEARY_IS_ENDPOINT (security));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cx, g_tls_connection_get_type ()));
	g_signal_emit_by_name (_data9_->account, "untrusted-host", _data9_->service, security, cx);
}

static void
___lambda153__geary_endpoint_untrusted_host (GearyEndpoint* _sender,
                                             GTlsConnection* cx,
                                             gpointer self)
{
	__lambda153_ (self, _sender, cx);
}

static void
geary_engine_validate_smtp_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	GearyEngineValidateSmtpData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_engine_validate_smtp_co (_data_);
}

static gboolean
geary_engine_validate_smtp_co (GearyEngineValidateSmtpData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data9_->account);
	_data_->_data9_->account = _data_->account;
	_g_object_unref0 (_data_->_data9_->service);
	_data_->_data9_->service = _data_->service;
	_data_->_data9_->_async_data_ = _data_;
	geary_engine_check_opened (_data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = geary_account_information_get_service_provider (_data_->_data9_->account);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = geary_engine_new_endpoint (_data_->self, _data_->_tmp1_, _data_->_data9_->service, GEARY_ENGINE_VALIDATION_TIMEOUT);
	_data_->endpoint = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->endpoint;
	_data_->_tmp4_ = g_signal_connect_data (_data_->_tmp3_, "untrusted-host", (GCallback) ___lambda153__geary_endpoint_untrusted_host, block9_data_ref (_data_->_data9_), (GClosureNotify) block9_data_unref, 0);
	_data_->untrusted_id = _data_->_tmp4_;
	_data_->credentials = NULL;
	_data_->_tmp5_ = geary_service_information_get_credentials_requirement (_data_->_data9_->service);
	_data_->_tmp6_ = _data_->_tmp5_;
	switch (_data_->_tmp6_) {
		case GEARY_CREDENTIALS_REQUIREMENT_USE_INCOMING:
		{
			_data_->_tmp7_ = _g_object_ref0 (_data_->incoming_credentials);
			_g_object_unref0 (_data_->credentials);
			_data_->credentials = _data_->_tmp7_;
			break;
		}
		case GEARY_CREDENTIALS_REQUIREMENT_CUSTOM:
		{
			_data_->_tmp8_ = geary_service_information_get_credentials (_data_->_data9_->service);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
			_g_object_unref0 (_data_->credentials);
			_data_->credentials = _data_->_tmp10_;
			break;
		}
		case GEARY_CREDENTIALS_REQUIREMENT_NONE:
		{
			break;
		}
		default:
		break;
	}
	_data_->_tmp11_ = _data_->endpoint;
	_data_->_tmp12_ = geary_smtp_client_session_new (_data_->_tmp11_);
	_data_->client = _data_->_tmp12_;
	_data_->login_err = NULL;
	{
		_data_->_tmp13_ = _data_->client;
		_data_->_tmp14_ = _data_->credentials;
		_data_->_state_ = 1;
		geary_smtp_client_session_login_async (_data_->_tmp13_, _data_->_tmp14_, _data_->cancellable, geary_engine_validate_smtp_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp15_ = geary_smtp_client_session_login_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_geary_smtp_response_unref0 (_data_->_tmp16_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp17_ = _data_->err;
		_data_->_tmp18_ = _g_error_copy0 (_data_->_tmp17_);
		_g_error_free0 (_data_->login_err);
		_data_->login_err = _data_->_tmp18_;
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->login_err);
		_g_object_unref0 (_data_->client);
		_g_object_unref0 (_data_->credentials);
		_g_object_unref0 (_data_->endpoint);
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp19_ = _data_->client;
		_data_->_state_ = 2;
		geary_smtp_client_session_logout_async (_data_->_tmp19_, TRUE, _data_->cancellable, geary_engine_validate_smtp_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp20_ = geary_smtp_client_session_logout_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp21_ = _data_->_tmp20_;
		_geary_smtp_response_unref0 (_data_->_tmp21_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->login_err);
		_g_object_unref0 (_data_->client);
		_g_object_unref0 (_data_->credentials);
		_g_object_unref0 (_data_->endpoint);
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp22_ = _data_->endpoint;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, G_TYPE_OBJECT, GObject), _data_->untrusted_id);
	_data_->_tmp23_ = _data_->login_err;
	if (_data_->_tmp23_ != NULL) {
		_data_->_tmp24_ = _data_->login_err;
		_data_->_tmp25_ = _g_error_copy0 (_data_->_tmp24_);
		_data_->_inner_error0_ = _data_->_tmp25_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->login_err);
		_g_object_unref0 (_data_->client);
		_g_object_unref0 (_data_->credentials);
		_g_object_unref0 (_data_->endpoint);
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_error_free0 (_data_->login_err);
	_g_object_unref0 (_data_->client);
	_g_object_unref0 (_data_->credentials);
	_g_object_unref0 (_data_->endpoint);
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_engine_update_account_service_data_free (gpointer _data)
{
	GearyEngineUpdateAccountServiceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->config);
	_g_object_unref0 (_data_->updated);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyEngineUpdateAccountServiceData, _data_);
}

void
geary_engine_update_account_service (GearyEngine* self,
                                     GearyAccountInformation* config,
                                     GearyServiceInformation* updated,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GearyEngineUpdateAccountServiceData* _data_;
	GearyEngine* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyServiceInformation* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_IS_ENGINE (self));
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (config));
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (updated));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyEngineUpdateAccountServiceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_engine_update_account_service_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (config);
	_g_object_unref0 (_data_->config);
	_data_->config = _tmp1_;
	_tmp2_ = _g_object_ref0 (updated);
	_g_object_unref0 (_data_->updated);
	_data_->updated = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_engine_update_account_service_co (_data_);
}

void
geary_engine_update_account_service_finish (GearyEngine* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GearyEngineUpdateAccountServiceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Changes the service configuration for an account.
     *
     * This updates an account's service configuration with the given
     * configuration, by replacing the account's existing
     * configuration for that service. The corresponding {@link
     * Account.incoming} or {@link Account.outgoing} client service
     * will also be updated so that the new configuration will start
     * taking effect immediately.
     */
static void
geary_engine_update_account_service_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GearyEngineUpdateAccountServiceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_engine_update_account_service_co (_data_);
}

static gboolean
geary_engine_update_account_service_co (GearyEngineUpdateAccountServiceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_engine_get_account (_data_->self, _data_->config, &_data_->_inner_error0_);
	_data_->account = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->service = NULL;
	_data_->_tmp1_ = geary_service_information_get_protocol (_data_->updated);
	_data_->_tmp2_ = _data_->_tmp1_;
	switch (_data_->_tmp2_) {
		case GEARY_PROTOCOL_IMAP:
		{
			geary_account_information_set_incoming (_data_->config, _data_->updated);
			_data_->_tmp3_ = _data_->account;
			_data_->_tmp4_ = geary_account_get_incoming (_data_->_tmp3_);
			_data_->_tmp5_ = _data_->_tmp4_;
			_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
			_g_object_unref0 (_data_->service);
			_data_->service = _data_->_tmp6_;
			break;
		}
		case GEARY_PROTOCOL_SMTP:
		{
			geary_account_information_set_outgoing (_data_->config, _data_->updated);
			_data_->_tmp7_ = _data_->account;
			_data_->_tmp8_ = geary_account_get_outgoing (_data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
			_g_object_unref0 (_data_->service);
			_data_->service = _data_->_tmp10_;
			break;
		}
		default:
		break;
	}
	_data_->_tmp11_ = geary_account_information_get_service_provider (_data_->config);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = geary_engine_get_shared_endpoint (_data_->self, _data_->_tmp12_, _data_->updated);
	_data_->remote = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->service;
	_data_->_tmp15_ = _data_->remote;
	_data_->_state_ = 1;
	geary_client_service_update_configuration (_data_->_tmp14_, _data_->updated, _data_->_tmp15_, _data_->cancellable, geary_engine_update_account_service_ready, _data_);
	return FALSE;
	_state_1:
	geary_client_service_update_configuration_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->remote);
		_g_object_unref0 (_data_->service);
		_g_object_unref0 (_data_->account);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_signal_emit_by_name (_data_->config, "changed");
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->service);
	_g_object_unref0 (_data_->account);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GearyEndpoint*
geary_engine_get_shared_endpoint (GearyEngine* self,
                                  GearyServiceProvider provider,
                                  GearyServiceInformation* service)
{
	gchar* key = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint16 _tmp2_;
	guint16 _tmp3_;
	GearyTlsNegotiationMethod _tmp4_;
	GearyTlsNegotiationMethod _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GearyEndpoint* shared = NULL;
	GearyEngineEndpointWeakRef* cached = NULL;
	GeeMap* _tmp10_;
	const gchar* _tmp11_;
	gpointer _tmp12_;
	GearyEngineEndpointWeakRef* _tmp13_;
	GearyEndpoint* _tmp17_;
	GearyEndpoint* result;
	g_return_val_if_fail (GEARY_IS_ENGINE (self), NULL);
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (service), NULL);
	_tmp0_ = geary_service_information_get_host (service);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_service_information_get_port (service);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_service_information_get_transport_security (service);
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_tls_negotiation_method_to_value (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%s:%u/%s", _tmp1_, (guint) _tmp3_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	key = _tmp9_;
	shared = NULL;
	_tmp10_ = self->priv->shared_endpoints;
	_tmp11_ = key;
	_tmp12_ = gee_map_get (_tmp10_, _tmp11_);
	cached = (GearyEngineEndpointWeakRef*) _tmp12_;
	_tmp13_ = cached;
	if (_tmp13_ != NULL) {
		GearyEngineEndpointWeakRef* _tmp14_;
		GearyEndpoint* _tmp15_;
		GearyEndpoint* _tmp16_;
		_tmp14_ = cached;
		_tmp15_ = geary_engine_endpoint_weak_ref_get (_tmp14_);
		_tmp16_ = GEARY_IS_ENDPOINT (_tmp15_) ? ((GearyEndpoint*) _tmp15_) : NULL;
		if (_tmp16_ == NULL) {
			_g_object_unref0 (_tmp15_);
		}
		_g_object_unref0 (shared);
		shared = _tmp16_;
	}
	_tmp17_ = shared;
	if (_tmp17_ == NULL) {
		guint _tmp18_ = 0U;
		GearyProtocol _tmp19_;
		GearyProtocol _tmp20_;
		guint timeout = 0U;
		GearyEndpoint* _tmp21_;
		GeeMap* _tmp22_;
		const gchar* _tmp23_;
		GearyEndpoint* _tmp24_;
		GearyEngineEndpointWeakRef* _tmp25_;
		GearyEngineEndpointWeakRef* _tmp26_;
		_tmp19_ = geary_service_information_get_protocol (service);
		_tmp20_ = _tmp19_;
		if (_tmp20_ == GEARY_PROTOCOL_IMAP) {
			_tmp18_ = GEARY_IMAP_CLIENT_CONNECTION_RECOMMENDED_TIMEOUT_SEC;
		} else {
			_tmp18_ = GEARY_SMTP_CLIENT_CONNECTION_DEFAULT_TIMEOUT_SEC;
		}
		timeout = _tmp18_;
		_tmp21_ = geary_engine_new_endpoint (self, provider, service, timeout);
		_g_object_unref0 (shared);
		shared = _tmp21_;
		_tmp22_ = self->priv->shared_endpoints;
		_tmp23_ = key;
		_tmp24_ = shared;
		_tmp25_ = geary_engine_endpoint_weak_ref_new (_tmp24_);
		_tmp26_ = _tmp25_;
		gee_map_set (_tmp22_, _tmp23_, _tmp26_);
		_geary_engine_endpoint_weak_ref_unref0 (_tmp26_);
	}
	result = shared;
	_geary_engine_endpoint_weak_ref_unref0 (cached);
	_g_free0 (key);
	return result;
}

static void
geary_engine_check_opened (GearyEngine* self,
                           GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IS_ENGINE (self));
	if (!self->priv->is_open) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_OPEN_REQUIRED, "Geary.Engine instance not open");
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static inline GearyEndpoint*
geary_engine_new_endpoint (GearyEngine* self,
                           GearyServiceProvider provider,
                           GearyServiceInformation* service,
                           guint timeout)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint16 _tmp2_;
	guint16 _tmp3_;
	GNetworkAddress* _tmp4_;
	GNetworkAddress* _tmp5_;
	GearyTlsNegotiationMethod _tmp6_;
	GearyTlsNegotiationMethod _tmp7_;
	GearyEndpoint* _tmp8_;
	GearyEndpoint* _tmp9_;
	GearyEndpoint* result;
	g_return_val_if_fail (GEARY_IS_ENGINE (self), NULL);
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (service), NULL);
	_tmp0_ = geary_service_information_get_host (service);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_service_information_get_port (service);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GNetworkAddress*) g_network_address_new (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_service_information_get_transport_security (service);
	_tmp7_ = _tmp6_;
	_tmp8_ = geary_endpoint_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_socket_connectable_get_type (), GSocketConnectable), _tmp7_, timeout);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp5_);
	result = _tmp9_;
	return result;
}

static gint
__lambda149_ (GearyEngine* self,
              GearyAccount* a,
              GearyAccount* b)
{
	GearyAccountInformation* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyAccountInformation* _tmp2_;
	GearyAccountInformation* _tmp3_;
	gint result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (a), 0);
	g_return_val_if_fail (GEARY_IS_ACCOUNT (b), 0);
	_tmp0_ = geary_account_get_information (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_account_get_information (b);
	_tmp3_ = _tmp2_;
	result = geary_account_information_compare_ascending (_tmp1_, _tmp3_);
	return result;
}

static gint
___lambda149__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = __lambda149_ ((GearyEngine*) self, (GearyAccount*) a, (GearyAccount*) b);
	return result;
}

static void
geary_engine_sort_accounts (GearyEngine* self)
{
	GeeList* _tmp0_;
	g_return_if_fail (GEARY_IS_ENGINE (self));
	_tmp0_ = self->priv->accounts;
	gee_list_sort (_tmp0_, ___lambda149__gcompare_data_func, g_object_ref (self), g_object_unref);
}

static void
geary_engine_on_account_ordinal_changed (GearyEngine* self)
{
	g_return_if_fail (GEARY_IS_ENGINE (self));
	geary_engine_sort_accounts (self);
}

static inline gpointer
geary_engine_endpoint_weak_ref_get_instance_private (GearyEngineEndpointWeakRef* self)
{
	return G_STRUCT_MEMBER_P (self, GearyEngineEndpointWeakRef_private_offset);
}

static GearyEngineEndpointWeakRef*
geary_engine_endpoint_weak_ref_construct (GType object_type,
                                          GearyEndpoint* endpoint)
{
	GearyEngineEndpointWeakRef* self = NULL;
	g_return_val_if_fail (GEARY_IS_ENDPOINT (endpoint), NULL);
	self = (GearyEngineEndpointWeakRef*) g_type_create_instance (object_type);
	g_weak_ref_clear (&self->priv->weak_ref);
	g_weak_ref_init (&self->priv->weak_ref, G_TYPE_CHECK_INSTANCE_CAST (endpoint, G_TYPE_OBJECT, GObject));
	return self;
}

static GearyEngineEndpointWeakRef*
geary_engine_endpoint_weak_ref_new (GearyEndpoint* endpoint)
{
	return geary_engine_endpoint_weak_ref_construct (GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF, endpoint);
}

static GearyEndpoint*
geary_engine_endpoint_weak_ref_get (GearyEngineEndpointWeakRef* self)
{
	GObject* _tmp0_;
	GearyEndpoint* _tmp1_;
	GearyEndpoint* result;
	g_return_val_if_fail (GEARY_ENGINE_IS_ENDPOINT_WEAK_REF (self), NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->weak_ref);
	_tmp1_ = GEARY_IS_ENDPOINT (_tmp0_) ? ((GearyEndpoint*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}

static void
geary_engine_value_endpoint_weak_ref_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_engine_value_endpoint_weak_ref_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_engine_endpoint_weak_ref_unref (value->data[0].v_pointer);
	}
}

static void
geary_engine_value_endpoint_weak_ref_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_engine_endpoint_weak_ref_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_engine_value_endpoint_weak_ref_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_engine_value_endpoint_weak_ref_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearyEngineEndpointWeakRef * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_engine_endpoint_weak_ref_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_engine_value_endpoint_weak_ref_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	GearyEngineEndpointWeakRef ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_engine_endpoint_weak_ref_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
geary_engine_param_spec_endpoint_weak_ref (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	GearyEngineParamSpecEndpointWeakRef* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
geary_engine_value_get_endpoint_weak_ref (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF), NULL);
	return value->data[0].v_pointer;
}

static void
geary_engine_value_set_endpoint_weak_ref (GValue* value,
                                          gpointer v_object)
{
	GearyEngineEndpointWeakRef * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_engine_endpoint_weak_ref_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_engine_endpoint_weak_ref_unref (old);
	}
}

static void
geary_engine_value_take_endpoint_weak_ref (GValue* value,
                                           gpointer v_object)
{
	GearyEngineEndpointWeakRef * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_engine_endpoint_weak_ref_unref (old);
	}
}

static void
geary_engine_endpoint_weak_ref_class_init (GearyEngineEndpointWeakRefClass * klass,
                                           gpointer klass_data)
{
	geary_engine_endpoint_weak_ref_parent_class = g_type_class_peek_parent (klass);
	((GearyEngineEndpointWeakRefClass *) klass)->finalize = geary_engine_endpoint_weak_ref_finalize;
	g_type_class_adjust_private_offset (klass, &GearyEngineEndpointWeakRef_private_offset);
}

static void
geary_engine_endpoint_weak_ref_instance_init (GearyEngineEndpointWeakRef * self,
                                              gpointer klass)
{
	self->priv = geary_engine_endpoint_weak_ref_get_instance_private (self);
	self->ref_count = 1;
}

static void
geary_engine_endpoint_weak_ref_finalize (GearyEngineEndpointWeakRef * obj)
{
	GearyEngineEndpointWeakRef * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF, GearyEngineEndpointWeakRef);
	g_signal_handlers_destroy (self);
	g_weak_ref_clear (&self->priv->weak_ref);
}

 G_GNUC_NO_INLINE static GType
geary_engine_endpoint_weak_ref_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_engine_value_endpoint_weak_ref_init, geary_engine_value_endpoint_weak_ref_free_value, geary_engine_value_endpoint_weak_ref_copy_value, geary_engine_value_endpoint_weak_ref_peek_pointer, "p", geary_engine_value_endpoint_weak_ref_collect_value, "p", geary_engine_value_endpoint_weak_ref_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearyEngineEndpointWeakRefClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_engine_endpoint_weak_ref_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyEngineEndpointWeakRef), 0, (GInstanceInitFunc) geary_engine_endpoint_weak_ref_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_engine_endpoint_weak_ref_type_id;
	geary_engine_endpoint_weak_ref_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearyEngineEndpointWeakRef", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GearyEngineEndpointWeakRef_private_offset = g_type_add_instance_private (geary_engine_endpoint_weak_ref_type_id, sizeof (GearyEngineEndpointWeakRefPrivate));
	return geary_engine_endpoint_weak_ref_type_id;
}

static GType
geary_engine_endpoint_weak_ref_get_type (void)
{
	static gsize geary_engine_endpoint_weak_ref_type_id__once = 0;
	if (g_once_init_enter (&geary_engine_endpoint_weak_ref_type_id__once)) {
		GType geary_engine_endpoint_weak_ref_type_id;
		geary_engine_endpoint_weak_ref_type_id = geary_engine_endpoint_weak_ref_get_type_once ();
		g_once_init_leave (&geary_engine_endpoint_weak_ref_type_id__once, geary_engine_endpoint_weak_ref_type_id);
	}
	return geary_engine_endpoint_weak_ref_type_id__once;
}

static gpointer
geary_engine_endpoint_weak_ref_ref (gpointer instance)
{
	GearyEngineEndpointWeakRef * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
geary_engine_endpoint_weak_ref_unref (gpointer instance)
{
	GearyEngineEndpointWeakRef * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_ENGINE_ENDPOINT_WEAK_REF_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
geary_engine_class_init (GearyEngineClass * klass,
                         gpointer klass_data)
{
	geary_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyEngine_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_engine_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_engine_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_engine_finalize;
	/** Determines if any accounts have been added to this instance. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ENGINE_HAS_ACCOUNTS_PROPERTY, geary_engine_properties[GEARY_ENGINE_HAS_ACCOUNTS_PROPERTY] = g_param_spec_boolean ("has-accounts", "has-accounts", "has-accounts", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines the number of accounts added to this instance. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ENGINE_ACCOUNTS_COUNT_PROPERTY, geary_engine_properties[GEARY_ENGINE_ACCOUNTS_COUNT_PROPERTY] = g_param_spec_uint ("accounts-count", "accounts-count", "accounts-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Location of the directory containing shared resource files. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ENGINE_RESOURCE_DIR_PROPERTY, geary_engine_properties[GEARY_ENGINE_RESOURCE_DIR_PROPERTY] = g_param_spec_object ("resource-dir", "resource-dir", "resource-dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Fired when an account becomes available in the engine.
	     *
	     * Accounts are made available as soon as they're added to the
	     * engine.
	     */
	geary_engine_signals[GEARY_ENGINE_ACCOUNT_AVAILABLE_SIGNAL] = g_signal_new ("account-available", GEARY_TYPE_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_ACCOUNT_INFORMATION);
	/**
	     * Fired when an account becomes unavailable in the engine.
	     *
	     * Accounts are become available as soon when they are removed from the
	     * engine or the engine is closed.
	     */
	geary_engine_signals[GEARY_ENGINE_ACCOUNT_UNAVAILABLE_SIGNAL] = g_signal_new ("account-unavailable", GEARY_TYPE_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_ACCOUNT_INFORMATION);
	g_type_name (GEARY_IMAP_TYPE_MAILBOX_ATTRIBUTES);
}

static void
geary_engine_instance_init (GearyEngine * self,
                            gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = geary_engine_get_instance_private (self);
	self->priv->is_open = TRUE;
	_tmp0_ = gee_array_list_new (GEARY_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->accounts = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEARY_ENGINE_TYPE_ENDPOINT_WEAK_REF, (GBoxedCopyFunc) geary_engine_endpoint_weak_ref_ref, (GDestroyNotify) geary_engine_endpoint_weak_ref_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->shared_endpoints = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MAP, GeeMap);
}

static void
geary_engine_finalize (GObject * obj)
{
	GearyEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_ENGINE, GearyEngine);
	_g_object_unref0 (self->priv->_resource_dir);
	_g_object_unref0 (self->priv->accounts);
	_g_object_unref0 (self->priv->shared_endpoints);
	G_OBJECT_CLASS (geary_engine_parent_class)->finalize (obj);
}

/**
 * Manages email account instances and their life-cycle.
 *
 * An engine represents and contains interfaces into the rest of the
 * email library. Instances are initialized by constructing them and
 * closed by calling {@link close}. Also use this class for verifying
 * and adding {@link AccountInformation} objects to check and start
 * using email accounts.
 */
 G_GNUC_NO_INLINE static GType
geary_engine_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyEngine), 0, (GInstanceInitFunc) geary_engine_instance_init, NULL };
	GType geary_engine_type_id;
	geary_engine_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyEngine", &g_define_type_info, 0);
	GearyEngine_private_offset = g_type_add_instance_private (geary_engine_type_id, sizeof (GearyEnginePrivate));
	return geary_engine_type_id;
}

GType
geary_engine_get_type (void)
{
	static gsize geary_engine_type_id__once = 0;
	if (g_once_init_enter (&geary_engine_type_id__once)) {
		GType geary_engine_type_id;
		geary_engine_type_id = geary_engine_get_type_once ();
		g_once_init_leave (&geary_engine_type_id__once, geary_engine_type_id);
	}
	return geary_engine_type_id__once;
}

static void
_vala_geary_engine_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	GearyEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ENGINE, GearyEngine);
	switch (property_id) {
		case GEARY_ENGINE_HAS_ACCOUNTS_PROPERTY:
		g_value_set_boolean (value, geary_engine_get_has_accounts (self));
		break;
		case GEARY_ENGINE_ACCOUNTS_COUNT_PROPERTY:
		g_value_set_uint (value, geary_engine_get_accounts_count (self));
		break;
		case GEARY_ENGINE_RESOURCE_DIR_PROPERTY:
		g_value_set_object (value, geary_engine_get_resource_dir (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_engine_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	GearyEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ENGINE, GearyEngine);
	switch (property_id) {
		case GEARY_ENGINE_RESOURCE_DIR_PROPERTY:
		geary_engine_set_resource_dir (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

