/* app-email-store.c generated by valac 0.56.3, the Vala compiler
 * generated from app-email-store.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_APP_EMAIL_STORE_0_PROPERTY,
	GEARY_APP_EMAIL_STORE_ACCOUNT_PROPERTY,
	GEARY_APP_EMAIL_STORE_NUM_PROPERTIES
};
static GParamSpec* geary_app_email_store_properties[GEARY_APP_EMAIL_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyAppEmailStoreGetSupportedOperationsAsyncData GearyAppEmailStoreGetSupportedOperationsAsyncData;

#define GEARY_APP_TYPE_ASYNC_FOLDER_OPERATION (geary_app_async_folder_operation_get_type ())
#define GEARY_APP_ASYNC_FOLDER_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_APP_TYPE_ASYNC_FOLDER_OPERATION, GearyAppAsyncFolderOperation))
#define GEARY_APP_ASYNC_FOLDER_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_APP_TYPE_ASYNC_FOLDER_OPERATION, GearyAppAsyncFolderOperationClass))
#define GEARY_APP_IS_ASYNC_FOLDER_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_APP_TYPE_ASYNC_FOLDER_OPERATION))
#define GEARY_APP_IS_ASYNC_FOLDER_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_APP_TYPE_ASYNC_FOLDER_OPERATION))
#define GEARY_APP_ASYNC_FOLDER_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_APP_TYPE_ASYNC_FOLDER_OPERATION, GearyAppAsyncFolderOperationClass))

typedef struct _GearyAppAsyncFolderOperation GearyAppAsyncFolderOperation;
typedef struct _GearyAppAsyncFolderOperationClass GearyAppAsyncFolderOperationClass;

#define GEARY_APP_TYPE_LIST_OPERATION (geary_app_list_operation_get_type ())
#define GEARY_APP_LIST_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_APP_TYPE_LIST_OPERATION, GearyAppListOperation))
#define GEARY_APP_LIST_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_APP_TYPE_LIST_OPERATION, GearyAppListOperationClass))
#define GEARY_APP_IS_LIST_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_APP_TYPE_LIST_OPERATION))
#define GEARY_APP_IS_LIST_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_APP_TYPE_LIST_OPERATION))
#define GEARY_APP_LIST_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_APP_TYPE_LIST_OPERATION, GearyAppListOperationClass))

typedef struct _GearyAppListOperation GearyAppListOperation;
typedef struct _GearyAppListOperationClass GearyAppListOperationClass;
typedef struct _GearyAppAsyncFolderOperationPrivate GearyAppAsyncFolderOperationPrivate;
typedef struct _GearyAppListOperationPrivate GearyAppListOperationPrivate;
typedef struct _GearyAppEmailStoreListEmailBySparseIdAsyncData GearyAppEmailStoreListEmailBySparseIdAsyncData;

#define GEARY_APP_TYPE_FETCH_OPERATION (geary_app_fetch_operation_get_type ())
#define GEARY_APP_FETCH_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_APP_TYPE_FETCH_OPERATION, GearyAppFetchOperation))
#define GEARY_APP_FETCH_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_APP_TYPE_FETCH_OPERATION, GearyAppFetchOperationClass))
#define GEARY_APP_IS_FETCH_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_APP_TYPE_FETCH_OPERATION))
#define GEARY_APP_IS_FETCH_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_APP_TYPE_FETCH_OPERATION))
#define GEARY_APP_FETCH_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_APP_TYPE_FETCH_OPERATION, GearyAppFetchOperationClass))

typedef struct _GearyAppFetchOperation GearyAppFetchOperation;
typedef struct _GearyAppFetchOperationClass GearyAppFetchOperationClass;
typedef struct _GearyAppFetchOperationPrivate GearyAppFetchOperationPrivate;
typedef struct _GearyAppEmailStoreFetchEmailAsyncData GearyAppEmailStoreFetchEmailAsyncData;

#define GEARY_APP_TYPE_MARK_OPERATION (geary_app_mark_operation_get_type ())
#define GEARY_APP_MARK_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_APP_TYPE_MARK_OPERATION, GearyAppMarkOperation))
#define GEARY_APP_MARK_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_APP_TYPE_MARK_OPERATION, GearyAppMarkOperationClass))
#define GEARY_APP_IS_MARK_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_APP_TYPE_MARK_OPERATION))
#define GEARY_APP_IS_MARK_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_APP_TYPE_MARK_OPERATION))
#define GEARY_APP_MARK_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_APP_TYPE_MARK_OPERATION, GearyAppMarkOperationClass))

typedef struct _GearyAppMarkOperation GearyAppMarkOperation;
typedef struct _GearyAppMarkOperationClass GearyAppMarkOperationClass;
typedef struct _GearyAppEmailStoreMarkEmailAsyncData GearyAppEmailStoreMarkEmailAsyncData;

#define GEARY_APP_TYPE_COPY_OPERATION (geary_app_copy_operation_get_type ())
#define GEARY_APP_COPY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_APP_TYPE_COPY_OPERATION, GearyAppCopyOperation))
#define GEARY_APP_COPY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_APP_TYPE_COPY_OPERATION, GearyAppCopyOperationClass))
#define GEARY_APP_IS_COPY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_APP_TYPE_COPY_OPERATION))
#define GEARY_APP_IS_COPY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_APP_TYPE_COPY_OPERATION))
#define GEARY_APP_COPY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_APP_TYPE_COPY_OPERATION, GearyAppCopyOperationClass))

typedef struct _GearyAppCopyOperation GearyAppCopyOperation;
typedef struct _GearyAppCopyOperationClass GearyAppCopyOperationClass;
typedef struct _GearyAppEmailStoreCopyEmailAsyncData GearyAppEmailStoreCopyEmailAsyncData;
typedef struct _GearyAppEmailStoreDoFolderOperationAsyncData GearyAppEmailStoreDoFolderOperationAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyAppEmailStorePrivate {
	GearyAccount* _account;
};

struct _GearyAppEmailStoreGetSupportedOperationsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppEmailStore* self;
	GeeCollection* emails;
	GCancellable* cancellable;
	GeeMultiMap* result;
	GeeMultiMap* folders;
	GearyAccount* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeHashSet* all_support;
	GeeHashSet* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* _tmp5_;
	GeeHashSet* _tmp6_;
	GeeHashSet* _tmp7_;
	GeeHashSet* _tmp8_;
	GeeHashMultiMap* map;
	GeeHashMultiMap* _tmp9_;
	GeeIterator* _email_it;
	GeeSet* _tmp10_;
	GeeSet* _tmp11_;
	GeeIterator* _tmp12_;
	GeeIterator* _tmp13_;
	GeeIterator* _tmp14_;
	GearyEmailIdentifier* email;
	GeeIterator* _tmp15_;
	gpointer _tmp16_;
	GeeHashSet* support;
	GeeHashSet* _tmp17_;
	GeeIterator* _path_it;
	GearyEmailIdentifier* _tmp18_;
	GeeCollection* _tmp19_;
	GeeCollection* _tmp20_;
	GeeIterator* _tmp21_;
	GeeIterator* _tmp22_;
	GeeIterator* _tmp23_;
	GearyFolderPath* path;
	GeeIterator* _tmp24_;
	gpointer _tmp25_;
	GearyFolder* folder;
	GearyFolder* _tmp26_;
	GearyAccount* _tmp27_;
	GearyFolderPath* _tmp28_;
	GearyFolder* _tmp29_;
	GearyFolder* _tmp30_;
	GError* e;
	GearyFolderPath* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GError* _tmp34_;
	const gchar* _tmp35_;
	GeeIterator* _type_it;
	GeeHashSet* _tmp36_;
	GeeIterator* _tmp37_;
	GeeIterator* _tmp38_;
	GType type;
	GeeIterator* _tmp39_;
	gpointer _tmp40_;
	GearyFolder* _tmp41_;
	GeeHashSet* _tmp42_;
	GeeHashSet* _tmp43_;
	GeeHashSet* _tmp44_;
	GeeHashMultiMap* _tmp45_;
	GearyEmailIdentifier* _tmp46_;
	GeeHashSet* _tmp47_;
	GeeHashMultiMap* _tmp48_;
	GeeHashMultiMap* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GeeHashMultiMap* _tmp52_;
	GeeMultiMap* _tmp53_;
	GError* _inner_error0_;
};

struct _GearyAppAsyncFolderOperation {
	GearyBaseObject parent_instance;
	GearyAppAsyncFolderOperationPrivate * priv;
};

struct _GearyAppAsyncFolderOperationClass {
	GearyBaseObjectClass parent_class;
	GType (*get_folder_type) (GearyAppAsyncFolderOperation* self);
	void (*execute_async) (GearyAppAsyncFolderOperation* self, GearyFolder* folder, GeeCollection* ids, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeCollection* (*execute_finish) (GearyAppAsyncFolderOperation* self, GAsyncResult* _res_, GError** error);
};

struct _GearyAppListOperation {
	GearyAppAsyncFolderOperation parent_instance;
	GeeHashSet* results;
	GearyEmailField required_fields;
	GearyFolderListFlags flags;
	GearyAppListOperationPrivate * priv;
};

struct _GearyAppListOperationClass {
	GearyAppAsyncFolderOperationClass parent_class;
};

struct _GearyAppEmailStoreListEmailBySparseIdAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppEmailStore* self;
	GeeCollection* emails;
	GearyEmailField required_fields;
	GearyFolderListFlags flags;
	GCancellable* cancellable;
	GeeCollection* result;
	GearyAppListOperation* op;
	GearyAppListOperation* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeHashSet* _tmp5_;
	GeeCollection* _tmp6_;
	GError* _inner_error0_;
};

struct _GearyAppFetchOperation {
	GearyAppAsyncFolderOperation parent_instance;
	GearyEmail* result;
	GearyEmailField required_fields;
	GearyFolderListFlags flags;
	GearyAppFetchOperationPrivate * priv;
};

struct _GearyAppFetchOperationClass {
	GearyAppAsyncFolderOperationClass parent_class;
};

struct _GearyAppEmailStoreFetchEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppEmailStore* self;
	GearyEmailIdentifier* email_id;
	GearyEmailField required_fields;
	GearyFolderListFlags flags;
	GCancellable* cancellable;
	GearyEmail* result;
	GearyAppFetchOperation* op;
	GearyAppFetchOperation* _tmp0_;
	GearyAppFetchOperation* _tmp1_;
	GearyIterable* _tmp2_;
	GearyIterable* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GearyAppFetchOperation* _tmp6_;
	GearyEmail* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GearyAppFetchOperation* _tmp12_;
	GearyEmail* _tmp13_;
	GearyEmail* _tmp14_;
	GError* _inner_error0_;
};

struct _GearyAppEmailStoreMarkEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppEmailStore* self;
	GeeCollection* emails;
	GearyEmailFlags* flags_to_add;
	GearyEmailFlags* flags_to_remove;
	GCancellable* cancellable;
	GearyAppMarkOperation* _tmp0_;
	GearyAppMarkOperation* _tmp1_;
	GError* _inner_error0_;
};

struct _GearyAppEmailStoreCopyEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppEmailStore* self;
	GeeCollection* emails;
	GearyFolderPath* destination;
	GCancellable* cancellable;
	GearyAppCopyOperation* _tmp0_;
	GearyAppCopyOperation* _tmp1_;
	GError* _inner_error0_;
};

struct _GearyAppEmailStoreDoFolderOperationAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppEmailStore* self;
	GearyAppAsyncFolderOperation* operation;
	GeeCollection* emails;
	GCancellable* cancellable;
	gint _tmp0_;
	gint _tmp1_;
	GearyAccount* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeMultiMap* ids_to_folders;
	GearyAccount* _tmp8_;
	GeeMultiMap* _tmp9_;
	GeeMultiMap* _tmp10_;
	GeeMultiMap* folders_to_ids;
	GeeMultiMap* _tmp11_;
	GeeMultiMap* _tmp12_;
	GearyFolderPath* path;
	GearyFolderPath* _tmp13_;
	GeeMultiMap* _tmp14_;
	GearyFolderPath* _tmp15_;
	GearyFolderPath* _tmp16_;
	GearyFolderPath* _tmp17_;
	GearyFolder* folder;
	GearyAccount* _tmp18_;
	GearyFolderPath* _tmp19_;
	GearyFolder* _tmp20_;
	GeeCollection* ids;
	GeeMultiMap* _tmp21_;
	GearyFolderPath* _tmp22_;
	GeeCollection* _tmp23_;
	GeeCollection* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gboolean open;
	GeeCollection* used_ids;
	GError* op_error;
	GearyFolder* _tmp27_;
	GeeCollection* _tmp28_;
	GearyFolder* _tmp29_;
	GeeCollection* _tmp30_;
	GeeCollection* _tmp31_;
	GeeCollection* _tmp32_;
	GError* err;
	GError* _tmp33_;
	GError* _tmp34_;
	GearyFolder* _tmp35_;
	GError* e;
	GearyFolder* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GError* _tmp39_;
	const gchar* _tmp40_;
	GError* _tmp41_;
	GError* _tmp42_;
	GError* _tmp43_;
	GeeCollection* _tmp44_;
	GeeCollection* _tmp45_;
	gint _tmp46_;
	gpointer* _tmp47_;
	GearyEmailIdentifier** id_collection;
	gint id_collection_length1;
	gint _id_collection_size_;
	gint id_it;
	GearyEmailIdentifier* _tmp48_;
	GearyEmailIdentifier* id;
	GeeIterator* _p_it;
	GeeMultiMap* _tmp49_;
	GearyEmailIdentifier* _tmp50_;
	GeeCollection* _tmp51_;
	GeeCollection* _tmp52_;
	GeeIterator* _tmp53_;
	GeeIterator* _tmp54_;
	GeeIterator* _tmp55_;
	GearyFolderPath* p;
	GeeIterator* _tmp56_;
	gpointer _tmp57_;
	GeeMultiMap* _tmp58_;
	GearyFolderPath* _tmp59_;
	GearyEmailIdentifier* _tmp60_;
	GeeMultiMap* _tmp61_;
	GearyFolderPath* _tmp62_;
	GeeMultiMap* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	const gchar* _tmp66_;
	GearyAccount* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	GError* _inner_error0_;
};

static gint GearyAppEmailStore_private_offset;
static gpointer geary_app_email_store_parent_class = NULL;

static void geary_app_email_store_set_account (GearyAppEmailStore* self,
                                        GearyAccount* value);
static void geary_app_email_store_get_supported_operations_async_data_free (gpointer _data);
static gboolean geary_app_email_store_get_supported_operations_async_co (GearyAppEmailStoreGetSupportedOperationsAsyncData* _data_);
static void geary_app_email_store_get_supported_operations_async_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static void geary_app_email_store_list_email_by_sparse_id_async_data_free (gpointer _data);
static gboolean geary_app_email_store_list_email_by_sparse_id_async_co (GearyAppEmailStoreListEmailBySparseIdAsyncData* _data_);
VALA_EXTERN GType geary_app_async_folder_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_app_list_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyAppListOperation* geary_app_list_operation_new (GearyEmailField required_fields,
                                                     GearyFolderListFlags flags);
VALA_EXTERN GearyAppListOperation* geary_app_list_operation_construct (GType object_type,
                                                           GearyEmailField required_fields,
                                                           GearyFolderListFlags flags);
static void geary_app_email_store_do_folder_operation_async (GearyAppEmailStore* self,
                                                      GearyAppAsyncFolderOperation* operation,
                                                      GeeCollection* emails,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void geary_app_email_store_do_folder_operation_finish (GearyAppEmailStore* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void geary_app_email_store_list_email_by_sparse_id_async_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static void geary_app_email_store_fetch_email_async_data_free (gpointer _data);
static gboolean geary_app_email_store_fetch_email_async_co (GearyAppEmailStoreFetchEmailAsyncData* _data_);
VALA_EXTERN GType geary_app_fetch_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyAppFetchOperation* geary_app_fetch_operation_new (GearyEmailField required_fields,
                                                       GearyFolderListFlags flags);
VALA_EXTERN GearyAppFetchOperation* geary_app_fetch_operation_construct (GType object_type,
                                                             GearyEmailField required_fields,
                                                             GearyFolderListFlags flags);
static void geary_app_email_store_fetch_email_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void geary_app_email_store_mark_email_async_data_free (gpointer _data);
static gboolean geary_app_email_store_mark_email_async_co (GearyAppEmailStoreMarkEmailAsyncData* _data_);
VALA_EXTERN GearyAppMarkOperation* geary_app_mark_operation_new (GearyEmailFlags* flags_to_add,
                                                     GearyEmailFlags* flags_to_remove);
VALA_EXTERN GearyAppMarkOperation* geary_app_mark_operation_construct (GType object_type,
                                                           GearyEmailFlags* flags_to_add,
                                                           GearyEmailFlags* flags_to_remove);
VALA_EXTERN GType geary_app_mark_operation_get_type (void) G_GNUC_CONST ;
static void geary_app_email_store_mark_email_async_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void geary_app_email_store_copy_email_async_data_free (gpointer _data);
static gboolean geary_app_email_store_copy_email_async_co (GearyAppEmailStoreCopyEmailAsyncData* _data_);
VALA_EXTERN GearyAppCopyOperation* geary_app_copy_operation_new (GearyFolderPath* destination);
VALA_EXTERN GearyAppCopyOperation* geary_app_copy_operation_construct (GType object_type,
                                                           GearyFolderPath* destination);
VALA_EXTERN GType geary_app_copy_operation_get_type (void) G_GNUC_CONST ;
static void geary_app_email_store_copy_email_async_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static GearyFolderPath* geary_app_email_store_next_folder_for_operation (GearyAppEmailStore* self,
                                                                  GearyAppAsyncFolderOperation* operation,
                                                                  GeeMultiMap* folders_to_ids,
                                                                  GError** error);
VALA_EXTERN GType geary_app_async_folder_operation_get_folder_type (GearyAppAsyncFolderOperation* self);
static void geary_app_email_store_do_folder_operation_async_data_free (gpointer _data);
static gboolean geary_app_email_store_do_folder_operation_async_co (GearyAppEmailStoreDoFolderOperationAsyncData* _data_);
static void geary_app_email_store_do_folder_operation_async_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
VALA_EXTERN void geary_app_async_folder_operation_execute_async (GearyAppAsyncFolderOperation* self,
                                                     GearyFolder* folder,
                                                     GeeCollection* ids,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN GeeCollection* geary_app_async_folder_operation_execute_finish (GearyAppAsyncFolderOperation* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static void geary_app_email_store_finalize (GObject * obj);
static GType geary_app_email_store_get_type_once (void);
static void _vala_geary_app_email_store_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_geary_app_email_store_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_app_email_store_get_instance_private (GearyAppEmailStore* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAppEmailStore_private_offset);
}

GearyAccount*
geary_app_email_store_get_account (GearyAppEmailStore* self)
{
	GearyAccount* result;
	GearyAccount* _tmp0_;
	g_return_val_if_fail (GEARY_APP_IS_EMAIL_STORE (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static void
geary_app_email_store_set_account (GearyAppEmailStore* self,
                                   GearyAccount* value)
{
	GearyAccount* old_value;
	g_return_if_fail (GEARY_APP_IS_EMAIL_STORE (self));
	old_value = geary_app_email_store_get_account (self);
	if (old_value != value) {
		self->priv->_account = value;
		g_object_notify_by_pspec ((GObject *) self, geary_app_email_store_properties[GEARY_APP_EMAIL_STORE_ACCOUNT_PROPERTY]);
	}
}

GearyAppEmailStore*
geary_app_email_store_construct (GType object_type,
                                 GearyAccount* account)
{
	GearyAppEmailStore * self = NULL;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (account), NULL);
	self = (GearyAppEmailStore*) geary_base_object_construct (object_type);
	geary_app_email_store_set_account (self, account);
	return self;
}

GearyAppEmailStore*
geary_app_email_store_new (GearyAccount* account)
{
	return geary_app_email_store_construct (GEARY_APP_TYPE_EMAIL_STORE, account);
}

static void
geary_app_email_store_get_supported_operations_async_data_free (gpointer _data)
{
	GearyAppEmailStoreGetSupportedOperationsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->emails);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppEmailStoreGetSupportedOperationsAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_app_email_store_get_supported_operations_async (GearyAppEmailStore* self,
                                                      GeeCollection* emails,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	GearyAppEmailStoreGetSupportedOperationsAsyncData* _data_;
	GearyAppEmailStore* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_APP_IS_EMAIL_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emails, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppEmailStoreGetSupportedOperationsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_email_store_get_supported_operations_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (emails);
	_g_object_unref0 (_data_->emails);
	_data_->emails = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_app_email_store_get_supported_operations_async_co (_data_);
}

GeeMultiMap*
geary_app_email_store_get_supported_operations_finish (GearyAppEmailStore* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	GeeMultiMap* result;
	GearyAppEmailStoreGetSupportedOperationsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Return a map of EmailIdentifiers to the special Geary.FolderSupport
     * interfaces each one supports.  For example, if an EmailIdentifier comes
     * back mapped to typeof(Geary.FolderSupport.Mark), it can be marked via
     * mark_email_async().  If an EmailIdentifier doesn't appear in the
     * returned map, no operations are supported on it.
     */
static void
geary_app_email_store_get_supported_operations_async_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	GearyAppEmailStoreGetSupportedOperationsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_email_store_get_supported_operations_async_co (_data_);
}

static gboolean
geary_app_email_store_get_supported_operations_async_co (GearyAppEmailStoreGetSupportedOperationsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_account;
	_data_->_state_ = 1;
	geary_account_get_containing_folders_async (_data_->_tmp0_, _data_->emails, _data_->cancellable, geary_app_email_store_get_supported_operations_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = geary_account_get_containing_folders_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	_data_->folders = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->folders == NULL) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->folders);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = gee_hash_set_new (G_TYPE_GTYPE, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->all_support = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->all_support;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), (gpointer) ((gintptr) GEARY_FOLDER_SUPPORT_TYPE_ARCHIVE));
	_data_->_tmp4_ = _data_->all_support;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), (gpointer) ((gintptr) GEARY_FOLDER_SUPPORT_TYPE_COPY));
	_data_->_tmp5_ = _data_->all_support;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), (gpointer) ((gintptr) GEARY_FOLDER_SUPPORT_TYPE_CREATE));
	_data_->_tmp6_ = _data_->all_support;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), (gpointer) ((gintptr) GEARY_FOLDER_SUPPORT_TYPE_MARK));
	_data_->_tmp7_ = _data_->all_support;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), (gpointer) ((gintptr) GEARY_FOLDER_SUPPORT_TYPE_MOVE));
	_data_->_tmp8_ = _data_->all_support;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), (gpointer) ((gintptr) GEARY_FOLDER_SUPPORT_TYPE_REMOVE));
	_data_->_tmp9_ = gee_hash_multi_map_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_GTYPE, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->map = _data_->_tmp9_;
	{
		_data_->_tmp10_ = gee_multi_map_get_keys (_data_->folders);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
		_data_->_tmp13_ = _data_->_tmp12_;
		_g_object_unref0 (_data_->_tmp11_);
		_data_->_email_it = _data_->_tmp13_;
		while (TRUE) {
			_data_->_tmp14_ = _data_->_email_it;
			if (!gee_iterator_next (_data_->_tmp14_)) {
				break;
			}
			_data_->_tmp15_ = _data_->_email_it;
			_data_->_tmp16_ = gee_iterator_get (_data_->_tmp15_);
			_data_->email = (GearyEmailIdentifier*) _data_->_tmp16_;
			_data_->_tmp17_ = gee_hash_set_new (G_TYPE_GTYPE, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			_data_->support = _data_->_tmp17_;
			{
				_data_->_tmp18_ = _data_->email;
				_data_->_tmp19_ = gee_multi_map_get (_data_->folders, _data_->_tmp18_);
				_data_->_tmp20_ = _data_->_tmp19_;
				_data_->_tmp21_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp20_, GEE_TYPE_ITERABLE, GeeIterable));
				_data_->_tmp22_ = _data_->_tmp21_;
				_g_object_unref0 (_data_->_tmp20_);
				_data_->_path_it = _data_->_tmp22_;
				while (TRUE) {
					_data_->_tmp23_ = _data_->_path_it;
					if (!gee_iterator_next (_data_->_tmp23_)) {
						break;
					}
					_data_->_tmp24_ = _data_->_path_it;
					_data_->_tmp25_ = gee_iterator_get (_data_->_tmp24_);
					_data_->path = (GearyFolderPath*) _data_->_tmp25_;
					{
						_data_->_tmp27_ = _data_->self->priv->_account;
						_data_->_tmp28_ = _data_->path;
						_data_->_tmp29_ = geary_account_get_folder (_data_->_tmp27_, _data_->_tmp28_, &_data_->_inner_error0_);
						_data_->_tmp26_ = _data_->_tmp29_;
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_data_->_tmp30_ = _data_->_tmp26_;
						_data_->_tmp26_ = NULL;
						_g_object_unref0 (_data_->folder);
						_data_->folder = _data_->_tmp30_;
						_g_object_unref0 (_data_->_tmp26_);
					}
					goto __finally0;
					__catch0_g_error:
					{
						_data_->e = _data_->_inner_error0_;
						_data_->_inner_error0_ = NULL;
						_data_->_tmp31_ = _data_->path;
						_data_->_tmp32_ = geary_folder_path_to_string (_data_->_tmp31_);
						_data_->_tmp33_ = _data_->_tmp32_;
						_data_->_tmp34_ = _data_->e;
						_data_->_tmp35_ = _data_->_tmp34_->message;
						g_debug ("app-email-store.vala:46: Error getting a folder from path %s: %s", _data_->_tmp33_, _data_->_tmp35_);
						_g_free0 (_data_->_tmp33_);
						_g_error_free0 (_data_->e);
						_g_object_unref0 (_data_->folder);
						_g_object_unref0 (_data_->path);
						continue;
					}
					__finally0:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->folder);
						_g_object_unref0 (_data_->path);
						_g_object_unref0 (_data_->_path_it);
						_g_object_unref0 (_data_->support);
						_g_object_unref0 (_data_->email);
						_g_object_unref0 (_data_->_email_it);
						_g_object_unref0 (_data_->map);
						_g_object_unref0 (_data_->all_support);
						_g_object_unref0 (_data_->folders);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					{
						_data_->_tmp36_ = _data_->all_support;
						_data_->_tmp37_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp36_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
						_data_->_type_it = _data_->_tmp37_;
						while (TRUE) {
							_data_->_tmp38_ = _data_->_type_it;
							if (!gee_iterator_next (_data_->_tmp38_)) {
								break;
							}
							_data_->_tmp39_ = _data_->_type_it;
							_data_->_tmp40_ = gee_iterator_get (_data_->_tmp39_);
							_data_->type = (GType) ((gintptr) _data_->_tmp40_);
							_data_->_tmp41_ = _data_->folder;
							if (g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp41_, G_TYPE_OBJECT, GObject)), _data_->type)) {
								_data_->_tmp42_ = _data_->support;
								gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp42_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), (gpointer) ((gintptr) _data_->type));
							}
						}
						_g_object_unref0 (_data_->_type_it);
					}
					_data_->_tmp43_ = _data_->support;
					_data_->_tmp44_ = _data_->all_support;
					if (gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp43_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp44_, GEE_TYPE_COLLECTION, GeeCollection))) {
						_g_object_unref0 (_data_->folder);
						_g_object_unref0 (_data_->path);
						break;
					}
					_g_object_unref0 (_data_->folder);
					_g_object_unref0 (_data_->path);
				}
				_g_object_unref0 (_data_->_path_it);
			}
			_data_->_tmp45_ = _data_->map;
			_data_->_tmp46_ = _data_->email;
			_data_->_tmp47_ = _data_->support;
			geary_collection_multi_map_set_all (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_GTYPE, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp45_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _data_->_tmp46_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp47_, GEE_TYPE_COLLECTION, GeeCollection));
			_g_object_unref0 (_data_->support);
			_g_object_unref0 (_data_->email);
		}
		_g_object_unref0 (_data_->_email_it);
	}
	_data_->_tmp49_ = _data_->map;
	_data_->_tmp50_ = gee_multi_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp49_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
	_data_->_tmp51_ = _data_->_tmp50_;
	if (_data_->_tmp51_ > 0) {
		_data_->_tmp52_ = _data_->map;
		_data_->_tmp48_ = _data_->_tmp52_;
	} else {
		_data_->_tmp48_ = NULL;
	}
	_data_->_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp48_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
	_data_->result = _data_->_tmp53_;
	_g_object_unref0 (_data_->map);
	_g_object_unref0 (_data_->all_support);
	_g_object_unref0 (_data_->folders);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_email_store_list_email_by_sparse_id_async_data_free (gpointer _data)
{
	GearyAppEmailStoreListEmailBySparseIdAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->emails);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppEmailStoreListEmailBySparseIdAsyncData, _data_);
}

void
geary_app_email_store_list_email_by_sparse_id_async (GearyAppEmailStore* self,
                                                     GeeCollection* emails,
                                                     GearyEmailField required_fields,
                                                     GearyFolderListFlags flags,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	GearyAppEmailStoreListEmailBySparseIdAsyncData* _data_;
	GearyAppEmailStore* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_APP_IS_EMAIL_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emails, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppEmailStoreListEmailBySparseIdAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_email_store_list_email_by_sparse_id_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (emails);
	_g_object_unref0 (_data_->emails);
	_data_->emails = _tmp1_;
	_data_->required_fields = required_fields;
	_data_->flags = flags;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_app_email_store_list_email_by_sparse_id_async_co (_data_);
}

GeeCollection*
geary_app_email_store_list_email_by_sparse_id_finish (GearyAppEmailStore* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	GeeCollection* result;
	GearyAppEmailStoreListEmailBySparseIdAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Lists any set of EmailIdentifiers as if they were all in one folder.
     */
static void
geary_app_email_store_list_email_by_sparse_id_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	GearyAppEmailStoreListEmailBySparseIdAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_email_store_list_email_by_sparse_id_async_co (_data_);
}

static gboolean
geary_app_email_store_list_email_by_sparse_id_async_co (GearyAppEmailStoreListEmailBySparseIdAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_app_list_operation_new (_data_->required_fields, _data_->flags);
	_data_->op = _data_->_tmp0_;
	_data_->_state_ = 1;
	geary_app_email_store_do_folder_operation_async (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->op, GEARY_APP_TYPE_ASYNC_FOLDER_OPERATION, GearyAppAsyncFolderOperation), _data_->emails, _data_->cancellable, geary_app_email_store_list_email_by_sparse_id_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_app_email_store_do_folder_operation_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->op);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->op->results;
	_data_->_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ > 0) {
		_data_->_tmp5_ = _data_->op->results;
		_data_->_tmp1_ = _data_->_tmp5_;
	} else {
		_data_->_tmp1_ = NULL;
	}
	_data_->_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->result = _data_->_tmp6_;
	_g_object_unref0 (_data_->op);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_email_store_fetch_email_async_data_free (gpointer _data)
{
	GearyAppEmailStoreFetchEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->email_id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppEmailStoreFetchEmailAsyncData, _data_);
}

void
geary_app_email_store_fetch_email_async (GearyAppEmailStore* self,
                                         GearyEmailIdentifier* email_id,
                                         GearyEmailField required_fields,
                                         GearyFolderListFlags flags,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GearyAppEmailStoreFetchEmailAsyncData* _data_;
	GearyAppEmailStore* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_APP_IS_EMAIL_STORE (self));
	g_return_if_fail (GEARY_IS_EMAIL_IDENTIFIER (email_id));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppEmailStoreFetchEmailAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_email_store_fetch_email_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (email_id);
	_g_object_unref0 (_data_->email_id);
	_data_->email_id = _tmp1_;
	_data_->required_fields = required_fields;
	_data_->flags = flags;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_app_email_store_fetch_email_async_co (_data_);
}

GearyEmail*
geary_app_email_store_fetch_email_finish (GearyAppEmailStore* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GearyEmail* result;
	GearyAppEmailStoreFetchEmailAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Fetches any EmailIdentifier regardless of what folder it's in.
     */
static void
geary_app_email_store_fetch_email_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GearyAppEmailStoreFetchEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_email_store_fetch_email_async_co (_data_);
}

static gboolean
geary_app_email_store_fetch_email_async_co (GearyAppEmailStoreFetchEmailAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_app_fetch_operation_new (_data_->required_fields, _data_->flags);
	_data_->op = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->op;
	_data_->_tmp2_ = geary_iterate (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->email_id, NULL);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = geary_iterable_to_array_list (_data_->_tmp3_, NULL, NULL, NULL);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_state_ = 1;
	geary_app_email_store_do_folder_operation_async (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEARY_APP_TYPE_ASYNC_FOLDER_OPERATION, GearyAppAsyncFolderOperation), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_COLLECTION, GeeCollection), _data_->cancellable, geary_app_email_store_fetch_email_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_app_email_store_do_folder_operation_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp5_);
	_g_object_unref0 (_data_->_tmp3_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->op);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->op;
	_data_->_tmp7_ = _data_->_tmp6_->result;
	if (_data_->_tmp7_ == NULL) {
		_data_->_tmp8_ = geary_email_identifier_to_string (_data_->email_id);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "Couldn't fetch email ID %s", _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_g_free0 (_data_->_tmp9_);
		_data_->_inner_error0_ = _data_->_tmp11_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->op);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->op;
	_data_->_tmp13_ = _data_->_tmp12_->result;
	_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
	_data_->result = _data_->_tmp14_;
	_g_object_unref0 (_data_->op);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_email_store_mark_email_async_data_free (gpointer _data)
{
	GearyAppEmailStoreMarkEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->emails);
	_g_object_unref0 (_data_->flags_to_add);
	_g_object_unref0 (_data_->flags_to_remove);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppEmailStoreMarkEmailAsyncData, _data_);
}

void
geary_app_email_store_mark_email_async (GearyAppEmailStore* self,
                                        GeeCollection* emails,
                                        GearyEmailFlags* flags_to_add,
                                        GearyEmailFlags* flags_to_remove,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GearyAppEmailStoreMarkEmailAsyncData* _data_;
	GearyAppEmailStore* _tmp0_;
	GeeCollection* _tmp1_;
	GearyEmailFlags* _tmp2_;
	GearyEmailFlags* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (GEARY_APP_IS_EMAIL_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emails, GEE_TYPE_COLLECTION));
	g_return_if_fail ((flags_to_add == NULL) || GEARY_IS_EMAIL_FLAGS (flags_to_add));
	g_return_if_fail ((flags_to_remove == NULL) || GEARY_IS_EMAIL_FLAGS (flags_to_remove));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppEmailStoreMarkEmailAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_email_store_mark_email_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (emails);
	_g_object_unref0 (_data_->emails);
	_data_->emails = _tmp1_;
	_tmp2_ = _g_object_ref0 (flags_to_add);
	_g_object_unref0 (_data_->flags_to_add);
	_data_->flags_to_add = _tmp2_;
	_tmp3_ = _g_object_ref0 (flags_to_remove);
	_g_object_unref0 (_data_->flags_to_remove);
	_data_->flags_to_remove = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	geary_app_email_store_mark_email_async_co (_data_);
}

void
geary_app_email_store_mark_email_finish (GearyAppEmailStore* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GearyAppEmailStoreMarkEmailAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Marks any set of EmailIdentifiers as if they were all in one
     * Geary.FolderSupport.Mark folder.
     */
static void
geary_app_email_store_mark_email_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GearyAppEmailStoreMarkEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_email_store_mark_email_async_co (_data_);
}

static gboolean
geary_app_email_store_mark_email_async_co (GearyAppEmailStoreMarkEmailAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_app_mark_operation_new (_data_->flags_to_add, _data_->flags_to_remove);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	geary_app_email_store_do_folder_operation_async (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEARY_APP_TYPE_ASYNC_FOLDER_OPERATION, GearyAppAsyncFolderOperation), _data_->emails, _data_->cancellable, geary_app_email_store_mark_email_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_app_email_store_do_folder_operation_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp1_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_email_store_copy_email_async_data_free (gpointer _data)
{
	GearyAppEmailStoreCopyEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->emails);
	_g_object_unref0 (_data_->destination);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppEmailStoreCopyEmailAsyncData, _data_);
}

void
geary_app_email_store_copy_email_async (GearyAppEmailStore* self,
                                        GeeCollection* emails,
                                        GearyFolderPath* destination,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GearyAppEmailStoreCopyEmailAsyncData* _data_;
	GearyAppEmailStore* _tmp0_;
	GeeCollection* _tmp1_;
	GearyFolderPath* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_APP_IS_EMAIL_STORE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emails, GEE_TYPE_COLLECTION));
	g_return_if_fail (GEARY_IS_FOLDER_PATH (destination));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppEmailStoreCopyEmailAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_email_store_copy_email_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (emails);
	_g_object_unref0 (_data_->emails);
	_data_->emails = _tmp1_;
	_tmp2_ = _g_object_ref0 (destination);
	_g_object_unref0 (_data_->destination);
	_data_->destination = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_app_email_store_copy_email_async_co (_data_);
}

void
geary_app_email_store_copy_email_finish (GearyAppEmailStore* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GearyAppEmailStoreCopyEmailAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Copies any set of EmailIdentifiers as if they were all in one
     * Geary.FolderSupport.Copy folder.
     */
static void
geary_app_email_store_copy_email_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GearyAppEmailStoreCopyEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_email_store_copy_email_async_co (_data_);
}

static gboolean
geary_app_email_store_copy_email_async_co (GearyAppEmailStoreCopyEmailAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_app_copy_operation_new (_data_->destination);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	geary_app_email_store_do_folder_operation_async (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEARY_APP_TYPE_ASYNC_FOLDER_OPERATION, GearyAppAsyncFolderOperation), _data_->emails, _data_->cancellable, geary_app_email_store_copy_email_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_app_email_store_do_folder_operation_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp1_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GearyFolderPath*
geary_app_email_store_next_folder_for_operation (GearyAppEmailStore* self,
                                                 GearyAppAsyncFolderOperation* operation,
                                                 GeeMultiMap* folders_to_ids,
                                                 GError** error)
{
	gboolean best_is_open = FALSE;
	gint best_count = 0;
	GearyFolderPath* best = NULL;
	GError* _inner_error0_ = NULL;
	GearyFolderPath* result;
	g_return_val_if_fail (GEARY_APP_IS_EMAIL_STORE (self), NULL);
	g_return_val_if_fail (GEARY_APP_IS_ASYNC_FOLDER_OPERATION (operation), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folders_to_ids, GEE_TYPE_MULTI_MAP), NULL);
	best_is_open = FALSE;
	best_count = 0;
	best = NULL;
	{
		GeeIterator* _path_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = gee_multi_map_get_keys (folders_to_ids);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_path_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			GearyFolderPath* path = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GearyFolder* folder = NULL;
			GearyAccount* _tmp7_;
			GearyFolderPath* _tmp8_;
			GearyFolder* _tmp9_;
			GearyFolder* _tmp10_;
			GType _tmp11_;
			GType _tmp12_;
			gint count = 0;
			GearyFolderPath* _tmp13_;
			GeeCollection* _tmp14_;
			GeeCollection* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			GearyFolder* _tmp19_;
			_tmp4_ = _path_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _path_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			path = (GearyFolderPath*) _tmp6_;
			_tmp7_ = self->priv->_account;
			_tmp8_ = path;
			_tmp9_ = geary_account_get_folder (_tmp7_, _tmp8_, &_inner_error0_);
			folder = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (path);
				_g_object_unref0 (_path_it);
				_g_object_unref0 (best);
				return NULL;
			}
			_tmp10_ = folder;
			_tmp11_ = geary_app_async_folder_operation_get_folder_type (operation);
			_tmp12_ = _tmp11_;
			if (!g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject)), _tmp12_)) {
				_g_object_unref0 (folder);
				_g_object_unref0 (path);
				continue;
			}
			_tmp13_ = path;
			_tmp14_ = gee_multi_map_get (folders_to_ids, _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = gee_collection_get_size (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_;
			_g_object_unref0 (_tmp15_);
			count = _tmp18_;
			if (count == 0) {
				_g_object_unref0 (folder);
				_g_object_unref0 (path);
				continue;
			}
			_tmp19_ = folder;
			if (geary_folder_get_open_state (_tmp19_) == GEARY_FOLDER_OPEN_STATE_REMOTE) {
				if (!best_is_open) {
					best_is_open = TRUE;
					best_count = 0;
				}
			} else {
				if (best_is_open) {
					_g_object_unref0 (folder);
					_g_object_unref0 (path);
					continue;
				}
			}
			if (count > best_count) {
				GearyFolderPath* _tmp20_;
				GearyFolderPath* _tmp21_;
				best_count = count;
				_tmp20_ = path;
				_tmp21_ = _g_object_ref0 (_tmp20_);
				_g_object_unref0 (best);
				best = _tmp21_;
			}
			_g_object_unref0 (folder);
			_g_object_unref0 (path);
		}
		_g_object_unref0 (_path_it);
	}
	result = best;
	return result;
}

static void
geary_app_email_store_do_folder_operation_async_data_free (gpointer _data)
{
	GearyAppEmailStoreDoFolderOperationAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->operation);
	_g_object_unref0 (_data_->emails);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppEmailStoreDoFolderOperationAsyncData, _data_);
}

static void
geary_app_email_store_do_folder_operation_async (GearyAppEmailStore* self,
                                                 GearyAppAsyncFolderOperation* operation,
                                                 GeeCollection* emails,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	GearyAppEmailStoreDoFolderOperationAsyncData* _data_;
	GearyAppEmailStore* _tmp0_;
	GearyAppAsyncFolderOperation* _tmp1_;
	GeeCollection* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_APP_IS_EMAIL_STORE (self));
	g_return_if_fail (GEARY_APP_IS_ASYNC_FOLDER_OPERATION (operation));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emails, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppEmailStoreDoFolderOperationAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_email_store_do_folder_operation_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (operation);
	_g_object_unref0 (_data_->operation);
	_data_->operation = _tmp1_;
	_tmp2_ = _g_object_ref0 (emails);
	_g_object_unref0 (_data_->emails);
	_data_->emails = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_app_email_store_do_folder_operation_async_co (_data_);
}

static void
geary_app_email_store_do_folder_operation_finish (GearyAppEmailStore* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GearyAppEmailStoreDoFolderOperationAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_app_email_store_do_folder_operation_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	GearyAppEmailStoreDoFolderOperationAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_email_store_do_folder_operation_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
geary_app_email_store_do_folder_operation_async_co (GearyAppEmailStoreDoFolderOperationAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_collection_get_size (_data_->emails);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ == 0) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_account;
	_data_->_tmp3_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_data_->operation, G_TYPE_OBJECT, GObject)));
	_data_->_tmp6_ = gee_collection_get_size (_data_->emails);
	_data_->_tmp7_ = _data_->_tmp6_;
	g_debug ("app-email-store.vala:150: EmailStore %s running %s on %d emails", _data_->_tmp4_, _data_->_tmp5_, _data_->_tmp7_);
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp8_ = _data_->self->priv->_account;
	_data_->_state_ = 1;
	geary_account_get_containing_folders_async (_data_->_tmp8_, _data_->emails, _data_->cancellable, geary_app_email_store_do_folder_operation_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp9_ = geary_account_get_containing_folders_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
	_data_->ids_to_folders = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->ids_to_folders;
	if (_data_->_tmp10_ == NULL) {
		_g_object_unref0 (_data_->ids_to_folders);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->ids_to_folders;
	_data_->_tmp12_ = geary_collection_reverse_multi_map (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_TYPE_FOLDER_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp11_);
	_data_->folders_to_ids = _data_->_tmp12_;
	while (TRUE) {
		_data_->_tmp14_ = _data_->folders_to_ids;
		_data_->_tmp15_ = geary_app_email_store_next_folder_for_operation (_data_->self, _data_->operation, _data_->_tmp14_, &_data_->_inner_error0_);
		_data_->_tmp13_ = _data_->_tmp15_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->path);
			_g_object_unref0 (_data_->folders_to_ids);
			_g_object_unref0 (_data_->ids_to_folders);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp16_ = _data_->_tmp13_;
		_data_->_tmp13_ = NULL;
		_g_object_unref0 (_data_->path);
		_data_->path = _data_->_tmp16_;
		_data_->_tmp17_ = _data_->path;
		if (!(_data_->_tmp17_ != NULL)) {
			_g_object_unref0 (_data_->_tmp13_);
			break;
		}
		_data_->_tmp18_ = _data_->self->priv->_account;
		_data_->_tmp19_ = _data_->path;
		_data_->_tmp20_ = geary_account_get_folder (_data_->_tmp18_, _data_->_tmp19_, &_data_->_inner_error0_);
		_data_->folder = _data_->_tmp20_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->_tmp13_);
			_g_object_unref0 (_data_->path);
			_g_object_unref0 (_data_->folders_to_ids);
			_g_object_unref0 (_data_->ids_to_folders);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp21_ = _data_->folders_to_ids;
		_data_->_tmp22_ = _data_->path;
		_data_->_tmp23_ = gee_multi_map_get (_data_->_tmp21_, _data_->_tmp22_);
		_data_->ids = _data_->_tmp23_;
		_data_->_tmp24_ = _data_->ids;
		_data_->_tmp25_ = gee_collection_get_size (_data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_vala_assert (_data_->_tmp26_ > 0, "ids.size > 0");
		_data_->open = FALSE;
		_data_->used_ids = NULL;
		_data_->op_error = NULL;
		{
			_data_->_tmp27_ = _data_->folder;
			_data_->_state_ = 2;
			geary_folder_open_async (_data_->_tmp27_, GEARY_FOLDER_OPEN_FLAGS_NONE, _data_->cancellable, geary_app_email_store_do_folder_operation_async_ready, _data_);
			return FALSE;
			_state_2:
			geary_folder_open_finish (_data_->_tmp27_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->open = TRUE;
			_data_->_tmp29_ = _data_->folder;
			_data_->_tmp30_ = _data_->ids;
			_data_->_state_ = 3;
			geary_app_async_folder_operation_execute_async (_data_->operation, _data_->_tmp29_, _data_->_tmp30_, _data_->cancellable, geary_app_email_store_do_folder_operation_async_ready, _data_);
			return FALSE;
			_state_3:
			_data_->_tmp31_ = geary_app_async_folder_operation_execute_finish (_data_->operation, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp28_ = _data_->_tmp31_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp32_ = _data_->_tmp28_;
			_data_->_tmp28_ = NULL;
			_g_object_unref0 (_data_->used_ids);
			_data_->used_ids = _data_->_tmp32_;
			_g_object_unref0 (_data_->_tmp28_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp33_ = _data_->err;
			_data_->_tmp34_ = _g_error_copy0 (_data_->_tmp33_);
			_g_error_free0 (_data_->op_error);
			_data_->op_error = _data_->_tmp34_;
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_error_free0 (_data_->op_error);
			_g_object_unref0 (_data_->used_ids);
			_g_object_unref0 (_data_->ids);
			_g_object_unref0 (_data_->folder);
			_g_object_unref0 (_data_->_tmp13_);
			_g_object_unref0 (_data_->path);
			_g_object_unref0 (_data_->folders_to_ids);
			_g_object_unref0 (_data_->ids_to_folders);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (_data_->open) {
			{
				_data_->_tmp35_ = _data_->folder;
				_data_->_state_ = 4;
				geary_folder_close_async (_data_->_tmp35_, NULL, geary_app_email_store_do_folder_operation_async_ready, _data_);
				return FALSE;
				_state_4:
				geary_folder_close_finish (_data_->_tmp35_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp36_ = _data_->folder;
				_data_->_tmp37_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp36_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
				_data_->_tmp38_ = _data_->_tmp37_;
				_data_->_tmp39_ = _data_->e;
				_data_->_tmp40_ = _data_->_tmp39_->message;
				g_warning ("app-email-store.vala:183: Error closing folder %s: %s", _data_->_tmp38_, _data_->_tmp40_);
				_g_free0 (_data_->_tmp38_);
				_g_error_free0 (_data_->e);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_error_free0 (_data_->op_error);
				_g_object_unref0 (_data_->used_ids);
				_g_object_unref0 (_data_->ids);
				_g_object_unref0 (_data_->folder);
				_g_object_unref0 (_data_->_tmp13_);
				_g_object_unref0 (_data_->path);
				_g_object_unref0 (_data_->folders_to_ids);
				_g_object_unref0 (_data_->ids_to_folders);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp41_ = _data_->op_error;
		if (_data_->_tmp41_ != NULL) {
			_data_->_tmp42_ = _data_->op_error;
			_data_->_tmp43_ = _g_error_copy0 (_data_->_tmp42_);
			_data_->_inner_error0_ = _data_->_tmp43_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_error_free0 (_data_->op_error);
			_g_object_unref0 (_data_->used_ids);
			_g_object_unref0 (_data_->ids);
			_g_object_unref0 (_data_->folder);
			_g_object_unref0 (_data_->_tmp13_);
			_g_object_unref0 (_data_->path);
			_g_object_unref0 (_data_->folders_to_ids);
			_g_object_unref0 (_data_->ids_to_folders);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp44_ = _data_->used_ids;
		if (_data_->_tmp44_ != NULL) {
			_data_->_tmp45_ = _data_->used_ids;
			_data_->_tmp46_ = 0;
			_data_->_tmp47_ = gee_collection_to_array (_data_->_tmp45_, &_data_->_tmp46_);
			{
				_data_->id_collection_length1 = 0;
				_data_->_id_collection_size_ = 0;
				_data_->id_collection = _data_->_tmp47_;
				_data_->id_collection_length1 = _data_->_tmp46_;
				for (_data_->id_it = 0; _data_->id_it < _data_->id_collection_length1; _data_->id_it = _data_->id_it + 1) {
					_data_->_tmp48_ = _g_object_ref0 (_data_->id_collection[_data_->id_it]);
					_data_->id = _data_->_tmp48_;
					{
						{
							_data_->_tmp49_ = _data_->ids_to_folders;
							_data_->_tmp50_ = _data_->id;
							_data_->_tmp51_ = gee_multi_map_get (_data_->_tmp49_, _data_->_tmp50_);
							_data_->_tmp52_ = _data_->_tmp51_;
							_data_->_tmp53_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp52_, GEE_TYPE_ITERABLE, GeeIterable));
							_data_->_tmp54_ = _data_->_tmp53_;
							_g_object_unref0 (_data_->_tmp52_);
							_data_->_p_it = _data_->_tmp54_;
							while (TRUE) {
								_data_->_tmp55_ = _data_->_p_it;
								if (!gee_iterator_next (_data_->_tmp55_)) {
									break;
								}
								_data_->_tmp56_ = _data_->_p_it;
								_data_->_tmp57_ = gee_iterator_get (_data_->_tmp56_);
								_data_->p = (GearyFolderPath*) _data_->_tmp57_;
								_data_->_tmp58_ = _data_->folders_to_ids;
								_data_->_tmp59_ = _data_->p;
								_data_->_tmp60_ = _data_->id;
								gee_multi_map_remove (_data_->_tmp58_, _data_->_tmp59_, _data_->_tmp60_);
								_g_object_unref0 (_data_->p);
							}
							_g_object_unref0 (_data_->_p_it);
						}
						_g_object_unref0 (_data_->id);
					}
				}
				_data_->id_collection = (_vala_array_free (_data_->id_collection, _data_->id_collection_length1, (GDestroyNotify) g_object_unref), NULL);
			}
		}
		_data_->_tmp61_ = _data_->folders_to_ids;
		_data_->_tmp62_ = _data_->path;
		gee_multi_map_remove_all (_data_->_tmp61_, _data_->_tmp62_);
		_g_error_free0 (_data_->op_error);
		_g_object_unref0 (_data_->used_ids);
		_g_object_unref0 (_data_->ids);
		_g_object_unref0 (_data_->folder);
		_g_object_unref0 (_data_->_tmp13_);
	}
	_data_->_tmp63_ = _data_->folders_to_ids;
	_data_->_tmp64_ = gee_multi_map_get_size (_data_->_tmp63_);
	_data_->_tmp65_ = _data_->_tmp64_;
	if (_data_->_tmp65_ > 0) {
		_data_->_tmp66_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_data_->operation, G_TYPE_OBJECT, GObject)));
		_data_->_tmp67_ = _data_->self->priv->_account;
		_data_->_tmp68_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp67_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp69_ = _data_->_tmp68_;
		g_debug ("app-email-store.vala:204: Couldn't perform %s on some messages in %s", _data_->_tmp66_, _data_->_tmp69_);
		_g_free0 (_data_->_tmp69_);
	}
	_g_object_unref0 (_data_->path);
	_g_object_unref0 (_data_->folders_to_ids);
	_g_object_unref0 (_data_->ids_to_folders);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_email_store_class_init (GearyAppEmailStoreClass * klass,
                                  gpointer klass_data)
{
	geary_app_email_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAppEmailStore_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_app_email_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_app_email_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_app_email_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_EMAIL_STORE_ACCOUNT_PROPERTY, geary_app_email_store_properties[GEARY_APP_EMAIL_STORE_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_app_email_store_instance_init (GearyAppEmailStore * self,
                                     gpointer klass)
{
	self->priv = geary_app_email_store_get_instance_private (self);
}

static void
geary_app_email_store_finalize (GObject * obj)
{
	GearyAppEmailStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_APP_TYPE_EMAIL_STORE, GearyAppEmailStore);
	G_OBJECT_CLASS (geary_app_email_store_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_app_email_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAppEmailStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_app_email_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAppEmailStore), 0, (GInstanceInitFunc) geary_app_email_store_instance_init, NULL };
	GType geary_app_email_store_type_id;
	geary_app_email_store_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyAppEmailStore", &g_define_type_info, 0);
	GearyAppEmailStore_private_offset = g_type_add_instance_private (geary_app_email_store_type_id, sizeof (GearyAppEmailStorePrivate));
	return geary_app_email_store_type_id;
}

GType
geary_app_email_store_get_type (void)
{
	static gsize geary_app_email_store_type_id__once = 0;
	if (g_once_init_enter (&geary_app_email_store_type_id__once)) {
		GType geary_app_email_store_type_id;
		geary_app_email_store_type_id = geary_app_email_store_get_type_once ();
		g_once_init_leave (&geary_app_email_store_type_id__once, geary_app_email_store_type_id);
	}
	return geary_app_email_store_type_id__once;
}

static void
_vala_geary_app_email_store_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GearyAppEmailStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_EMAIL_STORE, GearyAppEmailStore);
	switch (property_id) {
		case GEARY_APP_EMAIL_STORE_ACCOUNT_PROPERTY:
		g_value_set_object (value, geary_app_email_store_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_app_email_store_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GearyAppEmailStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_EMAIL_STORE, GearyAppEmailStore);
	switch (property_id) {
		case GEARY_APP_EMAIL_STORE_ACCOUNT_PROPERTY:
		geary_app_email_store_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

