/* imap-list-command.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-list-command.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_LIST_COMMAND_0_PROPERTY,
	GEARY_IMAP_LIST_COMMAND_NUM_PROPERTIES
};
static GParamSpec* geary_imap_list_command_properties[GEARY_IMAP_LIST_COMMAND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer geary_imap_list_command_parent_class = NULL;

static void geary_imap_list_command_add_return_parameter (GearyImapListCommand* self,
                                                   GearyImapListReturnParameter* return_param);
static GType geary_imap_list_command_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

/**
     * LIST a particular mailbox by {@link MailboxSpecifier}.
     *
     * MailboxSpecifier may contain a wildcard ("%" or "*"), but since the reference field of the
     * LIST command will be empty, it will be listing from the root.
     *
     * Note that IceWarp has an issue where it returns a different MailboxSpecifier for the Spam
     * folder using this variant.  That is:
     *
     * LIST "" % -> "Spam"
     * LIST "" "Spam" -> "~spam"
     *
     * See [[http://redmine.yorba.org/issues/7624]] for more information.
     */
GearyImapListCommand*
geary_imap_list_command_construct (GType object_type,
                                   GearyImapMailboxSpecifier* mailbox,
                                   gboolean use_xlist,
                                   GearyImapListReturnParameter* return_param,
                                   GCancellable* should_send)
{
	GearyImapListCommand * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GearyImapListParameter* _tmp4_;
	GearyImapListParameter* _tmp5_;
	GearyImapParameter* _tmp6_;
	GearyImapParameter* _tmp7_;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (mailbox), NULL);
	g_return_val_if_fail ((return_param == NULL) || GEARY_IMAP_IS_LIST_RETURN_PARAMETER (return_param), NULL);
	g_return_val_if_fail ((should_send == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (should_send, g_cancellable_get_type ()), NULL);
	if (use_xlist) {
		_tmp0_ = GEARY_IMAP_LIST_COMMAND_XLIST_NAME;
	} else {
		_tmp0_ = GEARY_IMAP_LIST_COMMAND_NAME;
	}
	_tmp1_ = g_strdup ("");
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	self = (GearyImapListCommand*) geary_imap_command_construct (object_type, _tmp0_, _tmp3_, (gint) 1, should_send);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_imap_mailbox_specifier_to_parameter (mailbox);
	_tmp7_ = _tmp6_;
	geary_imap_list_parameter_add (_tmp5_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	geary_imap_list_command_add_return_parameter (self, return_param);
	return self;
}

GearyImapListCommand*
geary_imap_list_command_new (GearyImapMailboxSpecifier* mailbox,
                             gboolean use_xlist,
                             GearyImapListReturnParameter* return_param,
                             GCancellable* should_send)
{
	return geary_imap_list_command_construct (GEARY_IMAP_TYPE_LIST_COMMAND, mailbox, use_xlist, return_param, should_send);
}

GearyImapListCommand*
geary_imap_list_command_construct_wildcarded (GType object_type,
                                              const gchar* reference,
                                              GearyImapMailboxSpecifier* mailbox,
                                              gboolean use_xlist,
                                              GearyImapListReturnParameter* return_param,
                                              GCancellable* should_send)
{
	GearyImapListCommand * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GearyImapListParameter* _tmp4_;
	GearyImapListParameter* _tmp5_;
	GearyImapParameter* _tmp6_;
	GearyImapParameter* _tmp7_;
	g_return_val_if_fail (reference != NULL, NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (mailbox), NULL);
	g_return_val_if_fail ((return_param == NULL) || GEARY_IMAP_IS_LIST_RETURN_PARAMETER (return_param), NULL);
	g_return_val_if_fail ((should_send == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (should_send, g_cancellable_get_type ()), NULL);
	if (use_xlist) {
		_tmp0_ = GEARY_IMAP_LIST_COMMAND_XLIST_NAME;
	} else {
		_tmp0_ = GEARY_IMAP_LIST_COMMAND_NAME;
	}
	_tmp1_ = g_strdup (reference);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	self = (GearyImapListCommand*) geary_imap_command_construct (object_type, _tmp0_, _tmp3_, (gint) 1, should_send);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_imap_mailbox_specifier_to_parameter (mailbox);
	_tmp7_ = _tmp6_;
	geary_imap_list_parameter_add (_tmp5_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	geary_imap_list_command_add_return_parameter (self, return_param);
	return self;
}

GearyImapListCommand*
geary_imap_list_command_new_wildcarded (const gchar* reference,
                                        GearyImapMailboxSpecifier* mailbox,
                                        gboolean use_xlist,
                                        GearyImapListReturnParameter* return_param,
                                        GCancellable* should_send)
{
	return geary_imap_list_command_construct_wildcarded (GEARY_IMAP_TYPE_LIST_COMMAND, reference, mailbox, use_xlist, return_param, should_send);
}

static void
geary_imap_list_command_add_return_parameter (GearyImapListCommand* self,
                                              GearyImapListReturnParameter* return_param)
{
	gboolean _tmp0_ = FALSE;
	GearyImapListParameter* _tmp3_;
	GearyImapListParameter* _tmp4_;
	GearyImapStringParameter* _tmp5_;
	GearyImapStringParameter* _tmp6_;
	GearyImapListParameter* _tmp7_;
	GearyImapListParameter* _tmp8_;
	g_return_if_fail (GEARY_IMAP_IS_LIST_COMMAND (self));
	g_return_if_fail ((return_param == NULL) || GEARY_IMAP_IS_LIST_RETURN_PARAMETER (return_param));
	if (return_param == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (return_param, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_imap_string_parameter_get_best_for_unchecked ("return");
	_tmp6_ = _tmp5_;
	geary_imap_list_parameter_add (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_g_object_unref0 (_tmp6_);
	_tmp7_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp8_ = _tmp7_;
	geary_imap_list_parameter_add (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (return_param, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
}

static void
geary_imap_list_command_class_init (GearyImapListCommandClass * klass,
                                    gpointer klass_data)
{
	geary_imap_list_command_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_imap_list_command_instance_init (GearyImapListCommand * self,
                                       gpointer klass)
{
}

/**
 * The IMAP LIST and proprietary XLIST commands.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-6.3.8]]
 *
 * Some implementations may return the mailbox name itself when using wildcarding.  For example:
 * LIST "" "Parent/%"
 * may return "Parent/Child" on most systems, but some will return "Parent" as well.  Callers
 * should be aware of this when processing, especially if performing a recursive decent.
 *
 * @see MailboxInformation
 */
 G_GNUC_NO_INLINE static GType
geary_imap_list_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapListCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_list_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapListCommand), 0, (GInstanceInitFunc) geary_imap_list_command_instance_init, NULL };
	GType geary_imap_list_command_type_id;
	geary_imap_list_command_type_id = g_type_register_static (GEARY_IMAP_TYPE_COMMAND, "GearyImapListCommand", &g_define_type_info, 0);
	return geary_imap_list_command_type_id;
}

GType
geary_imap_list_command_get_type (void)
{
	static gsize geary_imap_list_command_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_list_command_type_id__once)) {
		GType geary_imap_list_command_type_id;
		geary_imap_list_command_type_id = geary_imap_list_command_get_type_once ();
		g_once_init_leave (&geary_imap_list_command_type_id__once, geary_imap_list_command_type_id);
	}
	return geary_imap_list_command_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

