/* imap-tag.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-tag.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	GEARY_IMAP_TAG_0_PROPERTY,
	GEARY_IMAP_TAG_NUM_PROPERTIES
};
static GParamSpec* geary_imap_tag_properties[GEARY_IMAP_TAG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer geary_imap_tag_parent_class = NULL;
static GearyImapTag* geary_imap_tag_untagged;
static GearyImapTag* geary_imap_tag_untagged = NULL;
static GearyImapTag* geary_imap_tag_unassigned;
static GearyImapTag* geary_imap_tag_unassigned = NULL;
static GearyImapTag* geary_imap_tag_continuation;
static GearyImapTag* geary_imap_tag_continuation = NULL;
static GeeHashableIface * geary_imap_tag_gee_hashable_parent_iface = NULL;

VALA_EXTERN void geary_imap_tag_init (void);
static guint geary_imap_tag_real_hash (GeeHashable* base);
static gboolean geary_imap_tag_real_equal_to (GeeHashable* base,
                                       GearyImapTag* tag);
static void geary_imap_tag_finalize (GObject * obj);
static GType geary_imap_tag_get_type_once (void);

GearyImapTag*
geary_imap_tag_construct (GType object_type,
                          const gchar* ascii)
{
	GearyImapTag * self = NULL;
	g_return_val_if_fail (ascii != NULL, NULL);
	self = (GearyImapTag*) geary_imap_atom_parameter_construct (object_type, ascii);
	return self;
}

GearyImapTag*
geary_imap_tag_new (const gchar* ascii)
{
	return geary_imap_tag_construct (GEARY_IMAP_TYPE_TAG, ascii);
}

GearyImapTag*
geary_imap_tag_construct_from_parameter (GType object_type,
                                         GearyImapStringParameter* strparam)
{
	GearyImapTag * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (strparam), NULL);
	_tmp0_ = geary_imap_string_parameter_get_ascii (strparam);
	_tmp1_ = _tmp0_;
	self = (GearyImapTag*) geary_imap_atom_parameter_construct (object_type, _tmp1_);
	return self;
}

GearyImapTag*
geary_imap_tag_new_from_parameter (GearyImapStringParameter* strparam)
{
	return geary_imap_tag_construct_from_parameter (GEARY_IMAP_TYPE_TAG, strparam);
}

void
geary_imap_tag_init (void)
{
	GearyImapTag* _tmp0_;
	GearyImapTag* _tmp1_;
	GearyImapTag* _tmp2_;
	GearyImapTag* _tmp3_;
	GearyImapTag* _tmp4_;
	GearyImapTag* _tmp5_;
	_tmp0_ = geary_imap_tag_get_untagged ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	_tmp2_ = geary_imap_tag_get_continuation ();
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_tmp4_ = geary_imap_tag_get_unassigned ();
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapTag*
geary_imap_tag_get_untagged (void)
{
	GearyImapTag* _tmp0_;
	GearyImapTag* _tmp2_;
	GearyImapTag* _tmp3_;
	GearyImapTag* result;
	_tmp0_ = geary_imap_tag_untagged;
	if (_tmp0_ == NULL) {
		GearyImapTag* _tmp1_;
		_tmp1_ = geary_imap_tag_new (GEARY_IMAP_TAG_UNTAGGED_VALUE);
		_g_object_unref0 (geary_imap_tag_untagged);
		geary_imap_tag_untagged = _tmp1_;
	}
	_tmp2_ = geary_imap_tag_untagged;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

GearyImapTag*
geary_imap_tag_get_continuation (void)
{
	GearyImapTag* _tmp0_;
	GearyImapTag* _tmp2_;
	GearyImapTag* _tmp3_;
	GearyImapTag* result;
	_tmp0_ = geary_imap_tag_continuation;
	if (_tmp0_ == NULL) {
		GearyImapTag* _tmp1_;
		_tmp1_ = geary_imap_tag_new (GEARY_IMAP_TAG_CONTINUATION_VALUE);
		_g_object_unref0 (geary_imap_tag_continuation);
		geary_imap_tag_continuation = _tmp1_;
	}
	_tmp2_ = geary_imap_tag_continuation;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

GearyImapTag*
geary_imap_tag_get_unassigned (void)
{
	GearyImapTag* _tmp0_;
	GearyImapTag* _tmp2_;
	GearyImapTag* _tmp3_;
	GearyImapTag* result;
	_tmp0_ = geary_imap_tag_unassigned;
	if (_tmp0_ == NULL) {
		GearyImapTag* _tmp1_;
		_tmp1_ = geary_imap_tag_new (GEARY_IMAP_TAG_UNASSIGNED_VALUE);
		_g_object_unref0 (geary_imap_tag_unassigned);
		geary_imap_tag_unassigned = _tmp1_;
	}
	_tmp2_ = geary_imap_tag_unassigned;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

/**
     * Returns true if the StringParameter resembles a tag token: an unquoted non-empty string
     * that either matches the untagged or continuation special tags or
     */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
geary_imap_tag_is_tag (GearyImapStringParameter* stringp)
{
	gboolean _tmp0_ = FALSE;
	gint index = 0;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (stringp), FALSE);
	if (GEARY_IMAP_IS_QUOTED_STRING_PARAMETER (stringp)) {
		result = FALSE;
		return result;
	}
	if (geary_imap_string_parameter_is_empty (stringp)) {
		result = FALSE;
		return result;
	}
	if (geary_imap_string_parameter_equals_cs (stringp, GEARY_IMAP_TAG_UNTAGGED_VALUE)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = geary_imap_string_parameter_equals_cs (stringp, GEARY_IMAP_TAG_CONTINUATION_VALUE);
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	index = 0;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			gchar ch = '\0';
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gint _tmp4_;
			if (!_tmp1_) {
			}
			_tmp1_ = FALSE;
			_tmp2_ = geary_imap_string_parameter_get_ascii (stringp);
			_tmp3_ = _tmp2_;
			_tmp4_ = index;
			index = _tmp4_ + 1;
			ch = string_get (_tmp3_, (glong) _tmp4_);
			if (ch == GEARY_STRING_EOS) {
				break;
			}
			if (geary_imap_data_format_is_tag_special (ch, NULL)) {
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}

gboolean
geary_imap_tag_is_tagged (GearyImapTag* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_TAG (self), FALSE);
	if (!geary_imap_string_parameter_equals_cs (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter), GEARY_IMAP_TAG_UNTAGGED_VALUE)) {
		_tmp1_ = !geary_imap_string_parameter_equals_cs (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter), GEARY_IMAP_TAG_CONTINUATION_VALUE);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !geary_imap_string_parameter_equals_cs (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter), GEARY_IMAP_TAG_UNASSIGNED_VALUE);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
geary_imap_tag_is_continuation (GearyImapTag* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_TAG (self), FALSE);
	result = geary_imap_string_parameter_equals_cs (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter), GEARY_IMAP_TAG_CONTINUATION_VALUE);
	return result;
}

gboolean
geary_imap_tag_is_assigned (GearyImapTag* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_TAG (self), FALSE);
	if (!geary_imap_string_parameter_equals_cs (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter), GEARY_IMAP_TAG_UNASSIGNED_VALUE)) {
		_tmp0_ = !geary_imap_string_parameter_equals_cs (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter), GEARY_IMAP_TAG_CONTINUATION_VALUE);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static guint
geary_imap_tag_real_hash (GeeHashable* base)
{
	GearyImapTag * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_TAG, GearyImapTag);
	_tmp0_ = geary_imap_string_parameter_get_ascii (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter));
	_tmp1_ = _tmp0_;
	result = geary_ascii_str_hash (_tmp1_);
	return result;
}

static gboolean
geary_imap_tag_real_equal_to (GeeHashable* base,
                              GearyImapTag* tag)
{
	GearyImapTag * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_TAG, GearyImapTag);
	g_return_val_if_fail (GEARY_IMAP_IS_TAG (tag), FALSE);
	if (self == tag) {
		result = TRUE;
		return result;
	}
	_tmp0_ = geary_imap_string_parameter_get_ascii (G_TYPE_CHECK_INSTANCE_CAST (tag, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter));
	_tmp1_ = _tmp0_;
	result = geary_imap_string_parameter_equals_cs (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter), _tmp1_);
	return result;
}

static void
geary_imap_tag_class_init (GearyImapTagClass * klass,
                           gpointer klass_data)
{
	geary_imap_tag_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = geary_imap_tag_finalize;
}

static void
geary_imap_tag_gee_hashable_interface_init (GeeHashableIface * iface,
                                            gpointer iface_data)
{
	geary_imap_tag_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->hash = (guint (*) (GeeHashable*)) geary_imap_tag_real_hash;
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_imap_tag_real_equal_to;
}

static void
geary_imap_tag_instance_init (GearyImapTag * self,
                              gpointer klass)
{
}

static void
geary_imap_tag_finalize (GObject * obj)
{
	GearyImapTag * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_TAG, GearyImapTag);
	G_OBJECT_CLASS (geary_imap_tag_parent_class)->finalize (obj);
}

/**
 * A representation of an IMAP command tag.
 *
 * Tags are assigned by the client for each {@link Command} it sends to the server.  Tags have
 * a general form of <a-z><000-999>, although that's only by convention and is not required.
 *
 * Special tags exist, namely to indicated an untagged response and continuations.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-2.2.1]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_tag_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapTagClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_tag_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapTag), 0, (GInstanceInitFunc) geary_imap_tag_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_imap_tag_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_tag_type_id;
	geary_imap_tag_type_id = g_type_register_static (GEARY_IMAP_TYPE_ATOM_PARAMETER, "GearyImapTag", &g_define_type_info, 0);
	g_type_add_interface_static (geary_imap_tag_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	return geary_imap_tag_type_id;
}

GType
geary_imap_tag_get_type (void)
{
	static gsize geary_imap_tag_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_tag_type_id__once)) {
		GType geary_imap_tag_type_id;
		geary_imap_tag_type_id = geary_imap_tag_get_type_once ();
		g_once_init_leave (&geary_imap_tag_type_id__once, geary_imap_tag_type_id);
	}
	return geary_imap_tag_type_id__once;
}

