/* memory-growable-buffer.c generated by valac 0.56.3, the Vala compiler
 * generated from memory-growable-buffer.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_MEMORY_GROWABLE_BUFFER_0_PROPERTY,
	GEARY_MEMORY_GROWABLE_BUFFER_SIZE_PROPERTY,
	GEARY_MEMORY_GROWABLE_BUFFER_ALLOCATED_SIZE_PROPERTY,
	GEARY_MEMORY_GROWABLE_BUFFER_NUM_PROPERTIES
};
static GParamSpec* geary_memory_growable_buffer_properties[GEARY_MEMORY_GROWABLE_BUFFER_NUM_PROPERTIES];
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyMemoryGrowableBufferPrivate {
	GByteArray* byte_array;
	GBytes* bytes;
};

static gint GearyMemoryGrowableBuffer_private_offset;
static gpointer geary_memory_growable_buffer_parent_class = NULL;
static guint8* geary_memory_growable_buffer_NUL_ARRAY;
static gint geary_memory_growable_buffer_NUL_ARRAY_length1;
static guint8* geary_memory_growable_buffer_NUL_ARRAY = NULL;
static gint geary_memory_growable_buffer_NUL_ARRAY_length1 = 0;
static gint _geary_memory_growable_buffer_NUL_ARRAY_size_ = 0;
static GearyMemoryUnownedBytesBufferIface * geary_memory_growable_buffer_geary_memory_unowned_bytes_buffer_parent_iface = NULL;
static GearyMemoryUnownedStringBufferIface * geary_memory_growable_buffer_geary_memory_unowned_string_buffer_parent_iface = NULL;

static GBytes* geary_memory_growable_buffer_to_bytes (GearyMemoryGrowableBuffer* self);
static guint8* geary_memory_growable_buffer_get_bytes_no_nul (GearyMemoryGrowableBuffer* self,
                                                       gint* result_length1);
static GByteArray* geary_memory_growable_buffer_to_byte_array (GearyMemoryGrowableBuffer* self);
static guint8* geary_memory_growable_buffer_get_byte_array_no_nul (GearyMemoryGrowableBuffer* self,
                                                            gint* result_length1);
static GBytes* geary_memory_growable_buffer_real_get_bytes (GearyMemoryBuffer* base);
static GByteArray* geary_memory_growable_buffer_real_get_byte_array (GearyMemoryBuffer* base);
static guint8* geary_memory_growable_buffer_real_get_uint8_array (GearyMemoryBuffer* base,
                                                           gint* result_length1);
static guint8* _vala_array_dup10 (guint8* self,
                           gssize length);
static guint8* geary_memory_growable_buffer_real_to_unowned_uint8_array (GearyMemoryUnownedBytesBuffer* base,
                                                                  gint* result_length1);
static gchar* geary_memory_growable_buffer_real_to_string (GearyMemoryBuffer* base);
static const gchar* geary_memory_growable_buffer_real_to_unowned_string (GearyMemoryUnownedStringBuffer* base);
static void geary_memory_growable_buffer_finalize (GObject * obj);
static GType geary_memory_growable_buffer_get_type_once (void);
static void _vala_geary_memory_growable_buffer_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
geary_memory_growable_buffer_get_instance_private (GearyMemoryGrowableBuffer* self)
{
	return G_STRUCT_MEMBER_P (self, GearyMemoryGrowableBuffer_private_offset);
}

static gint
_vala_g_bytes_get_length (GBytes* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) g_bytes_get_size (self);
	return result;
}

static gsize
geary_memory_growable_buffer_real_get_size (GearyMemoryBuffer* base)
{
	gsize result;
	GearyMemoryGrowableBuffer* self;
	GBytes* _tmp0_;
	GByteArray* _tmp4_;
	GByteArray* _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_GROWABLE_BUFFER, GearyMemoryGrowableBuffer);
	_tmp0_ = self->priv->bytes;
	if (_tmp0_ != NULL) {
		GBytes* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->bytes;
		_tmp2_ = _vala_g_bytes_get_length (_tmp1_);
		_tmp3_ = _tmp2_;
		result = (gsize) (_tmp3_ - 1);
		return result;
	}
	_tmp4_ = self->priv->byte_array;
	_vala_assert (_tmp4_ != NULL, "byte_array != null");
	_tmp5_ = self->priv->byte_array;
	result = (gsize) (_tmp5_->len - 1);
	return result;
}

static gsize
geary_memory_growable_buffer_real_get_allocated_size (GearyMemoryBuffer* base)
{
	gsize result;
	GearyMemoryGrowableBuffer* self;
	gsize _tmp0_;
	gsize _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_GROWABLE_BUFFER, GearyMemoryGrowableBuffer);
	_tmp0_ = geary_memory_buffer_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

GearyMemoryGrowableBuffer*
geary_memory_growable_buffer_construct (GType object_type)
{
	GearyMemoryGrowableBuffer * self = NULL;
	GByteArray* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	self = (GearyMemoryGrowableBuffer*) geary_memory_buffer_construct (object_type);
	_tmp0_ = self->priv->byte_array;
	_tmp1_ = geary_memory_growable_buffer_NUL_ARRAY;
	_tmp1__length1 = geary_memory_growable_buffer_NUL_ARRAY_length1;
	g_byte_array_append (_tmp0_, _tmp1_, (gint) _tmp1__length1);
	return self;
}

GearyMemoryGrowableBuffer*
geary_memory_growable_buffer_new (void)
{
	return geary_memory_growable_buffer_construct (GEARY_MEMORY_TYPE_GROWABLE_BUFFER);
}

static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

static gpointer
_g_byte_array_ref0 (gpointer self)
{
	return self ? g_byte_array_ref (self) : NULL;
}

static GBytes*
geary_memory_growable_buffer_to_bytes (GearyMemoryGrowableBuffer* self)
{
	GBytes* _tmp0_;
	GByteArray* _tmp4_;
	GByteArray* _tmp5_;
	GByteArray* _tmp6_;
	GBytes* _tmp7_;
	GBytes* _tmp8_;
	GBytes* _tmp9_;
	GBytes* result;
	g_return_val_if_fail (GEARY_MEMORY_IS_GROWABLE_BUFFER (self), NULL);
	_tmp0_ = self->priv->bytes;
	if (_tmp0_ != NULL) {
		GByteArray* _tmp1_;
		GBytes* _tmp2_;
		GBytes* _tmp3_;
		_tmp1_ = self->priv->byte_array;
		_vala_assert (_tmp1_ == NULL, "byte_array == null");
		_tmp2_ = self->priv->bytes;
		_tmp3_ = _g_bytes_ref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->byte_array;
	_vala_assert (_tmp4_ != NULL, "byte_array != null");
	_tmp5_ = self->priv->byte_array;
	_tmp6_ = _g_byte_array_ref0 (_tmp5_);
	_tmp7_ = g_byte_array_free_to_bytes (_tmp6_);
	_g_bytes_unref0 (self->priv->bytes);
	self->priv->bytes = _tmp7_;
	_g_byte_array_unref0 (self->priv->byte_array);
	self->priv->byte_array = NULL;
	_tmp8_ = self->priv->bytes;
	_tmp9_ = _g_bytes_ref0 (_tmp8_);
	result = _tmp9_;
	return result;
}

static guint8*
geary_memory_growable_buffer_get_bytes_no_nul (GearyMemoryGrowableBuffer* self,
                                               gint* result_length1)
{
	GBytes* _tmp0_;
	GBytes* _tmp1_;
	GBytes* _tmp2_;
	gsize _tmp3_ = 0;
	guint8* _tmp4_;
	GBytes* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* result;
	g_return_val_if_fail (GEARY_MEMORY_IS_GROWABLE_BUFFER (self), NULL);
	_tmp0_ = self->priv->bytes;
	_vala_assert (_tmp0_ != NULL, "bytes != null");
	_tmp1_ = self->priv->bytes;
	_vala_assert (g_bytes_get_size (_tmp1_) > ((gsize) 0), "bytes.get_size() > 0");
	_tmp2_ = self->priv->bytes;
	_tmp4_ = g_bytes_get_data (_tmp2_, &_tmp3_);
	_tmp5_ = self->priv->bytes;
	_tmp6_ = _tmp4_ + 0;
	_tmp6__length1 = ((gint) (g_bytes_get_size (_tmp5_) - 1)) - 0;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static GByteArray*
geary_memory_growable_buffer_to_byte_array (GearyMemoryGrowableBuffer* self)
{
	GByteArray* _tmp0_;
	GBytes* _tmp4_;
	GBytes* _tmp5_;
	GBytes* _tmp6_;
	GByteArray* _tmp7_;
	GByteArray* _tmp8_;
	GByteArray* _tmp9_;
	GByteArray* result;
	g_return_val_if_fail (GEARY_MEMORY_IS_GROWABLE_BUFFER (self), NULL);
	_tmp0_ = self->priv->byte_array;
	if (_tmp0_ != NULL) {
		GBytes* _tmp1_;
		GByteArray* _tmp2_;
		GByteArray* _tmp3_;
		_tmp1_ = self->priv->bytes;
		_vala_assert (_tmp1_ == NULL, "bytes == null");
		_tmp2_ = self->priv->byte_array;
		_tmp3_ = _g_byte_array_ref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->bytes;
	_vala_assert (_tmp4_ != NULL, "bytes != null");
	_tmp5_ = self->priv->bytes;
	_tmp6_ = _g_bytes_ref0 (_tmp5_);
	_tmp7_ = g_bytes_unref_to_array (_tmp6_);
	_g_byte_array_unref0 (self->priv->byte_array);
	self->priv->byte_array = _tmp7_;
	_g_bytes_unref0 (self->priv->bytes);
	self->priv->bytes = NULL;
	_tmp8_ = self->priv->byte_array;
	_tmp9_ = _g_byte_array_ref0 (_tmp8_);
	result = _tmp9_;
	return result;
}

static guint8*
geary_memory_growable_buffer_get_byte_array_no_nul (GearyMemoryGrowableBuffer* self,
                                                    gint* result_length1)
{
	GByteArray* _tmp0_;
	GByteArray* _tmp1_;
	GByteArray* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GByteArray* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* result;
	g_return_val_if_fail (GEARY_MEMORY_IS_GROWABLE_BUFFER (self), NULL);
	_tmp0_ = self->priv->byte_array;
	_vala_assert (_tmp0_ != NULL, "byte_array != null");
	_tmp1_ = self->priv->byte_array;
	_vala_assert (_tmp1_->len > ((guint) 0), "byte_array.len > 0");
	_tmp2_ = self->priv->byte_array;
	_tmp3_ = _tmp2_->data;
	_tmp3__length1 = _tmp2_->len;
	_tmp4_ = self->priv->byte_array;
	_tmp5_ = _tmp3_ + 0;
	_tmp5__length1 = ((gint) (_tmp4_->len - 1)) - 0;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

/**
     * Appends the data to the existing GrowableBuffer.
     *
     * It's unwise to append to a GrowableBuffer while outstanding ByteArrays and InputStreams
     * (from {@link get_byte_array} or {@link Buffer.get_input_stream}) are outstanding.
     */
void
geary_memory_growable_buffer_append (GearyMemoryGrowableBuffer* self,
                                     guint8* buffer,
                                     gint buffer_length1)
{
	GByteArray* _tmp0_;
	GByteArray* _tmp1_;
	GByteArray* _tmp2_;
	GByteArray* _tmp3_;
	GByteArray* _tmp4_;
	GByteArray* _tmp5_;
	GByteArray* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (GEARY_MEMORY_IS_GROWABLE_BUFFER (self));
	if (buffer_length1 <= 0) {
		return;
	}
	_tmp0_ = geary_memory_growable_buffer_to_byte_array (self);
	_tmp1_ = _tmp0_;
	_g_byte_array_unref0 (_tmp1_);
	_tmp2_ = self->priv->byte_array;
	_vala_assert (_tmp2_->len > ((guint) 0), "byte_array.len > 0");
	_tmp3_ = self->priv->byte_array;
	_tmp4_ = self->priv->byte_array;
	g_byte_array_set_size (_tmp3_, _tmp4_->len - 1);
	_tmp5_ = self->priv->byte_array;
	g_byte_array_append (_tmp5_, buffer, (gint) buffer_length1);
	_tmp6_ = self->priv->byte_array;
	_tmp7_ = geary_memory_growable_buffer_NUL_ARRAY;
	_tmp7__length1 = geary_memory_growable_buffer_NUL_ARRAY_length1;
	g_byte_array_append (_tmp6_, _tmp7_, (gint) _tmp7__length1);
}

/**
     * Allocate data within the backing buffer for writing.
     *
     * Any usused bytes in the returned buffer should be returned to the {@link GrowableBuffer}
     * via {@link trim}.
     *
     * It's unwise to write to a GrowableBuffer while outstanding ByteArrays and InputStreams
     * (from {@link get_byte_array} or {@link Buffer.get_input_stream}) are outstanding.  Likewise,
     * it's dangerous to be writing to a GrowableBuffer and in the process call get_bytes() and
     * such.
     */
guint8*
geary_memory_growable_buffer_allocate (GearyMemoryGrowableBuffer* self,
                                       gsize requested_bytes,
                                       gint* result_length1)
{
	GByteArray* _tmp0_;
	GByteArray* _tmp1_;
	GByteArray* _tmp2_;
	guint original_bytes = 0U;
	GByteArray* _tmp3_;
	guint new_size = 0U;
	GByteArray* _tmp4_;
	GByteArray* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* buffer = NULL;
	GByteArray* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	gint buffer_length1;
	gint _buffer_size_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* result;
	g_return_val_if_fail (GEARY_MEMORY_IS_GROWABLE_BUFFER (self), NULL);
	_tmp0_ = geary_memory_growable_buffer_to_byte_array (self);
	_tmp1_ = _tmp0_;
	_g_byte_array_unref0 (_tmp1_);
	_tmp2_ = self->priv->byte_array;
	_vala_assert (_tmp2_->len > ((guint) 0), "byte_array.len > 0");
	_tmp3_ = self->priv->byte_array;
	original_bytes = _tmp3_->len;
	new_size = original_bytes + ((guint) requested_bytes);
	_tmp4_ = self->priv->byte_array;
	g_byte_array_set_size (_tmp4_, new_size);
	_tmp5_ = self->priv->byte_array;
	_tmp6_ = _tmp5_->data;
	_tmp6__length1 = _tmp5_->len;
	_tmp6_[new_size - 1] = (guint8) GEARY_STRING_EOS;
	_tmp7_ = self->priv->byte_array;
	_tmp8_ = _tmp7_->data;
	_tmp8__length1 = _tmp7_->len;
	buffer = _tmp8_ + ((gint) (original_bytes - 1));
	buffer_length1 = ((gint) (new_size - 1)) - ((gint) (original_bytes - 1));
	_buffer_size_ = buffer_length1;
	_vala_assert (((gsize) buffer_length1) == requested_bytes, "buffer.length == requested_bytes");
	_tmp9_ = buffer;
	_tmp9__length1 = buffer_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}

/**
     * Trim a previously allocated buffer.
     *
     * {@link allocate} returns an internal buffer that may be used for writing.  If the entire
     * buffer is not filled, it should be trimmed with this call.
     *
     * filled_bytes is the number of bytes in the supplied buffer that are used (filled).  The
     * remainder are to be trimmed.
     *
     * trim() can only trim back the last allocation; there is no facility for having multiple
     * outstanding allocations and trimming each back randomly.
     *
     * WARNING: No other call to the GrowableBuffer should be made between allocate() and trim().
     * Requesting {@link get_bytes} and other calls may shift the buffer in memory.
     */
void
geary_memory_growable_buffer_trim (GearyMemoryGrowableBuffer* self,
                                   guint8* allocation,
                                   gint allocation_length1,
                                   gsize filled_bytes)
{
	GByteArray* _tmp0_;
	GByteArray* _tmp1_;
	GByteArray* _tmp2_;
	g_return_if_fail (GEARY_MEMORY_IS_GROWABLE_BUFFER (self));
	_tmp0_ = self->priv->byte_array;
	_vala_assert (_tmp0_ != NULL, "byte_array != null");
	_vala_assert (filled_bytes <= ((gsize) allocation_length1), "filled_bytes <= allocation.length");
	_tmp1_ = self->priv->byte_array;
	_tmp2_ = self->priv->byte_array;
	g_byte_array_set_size (_tmp1_, _tmp2_->len - ((guint) (allocation_length1 - filled_bytes)));
}

/**
     * {@inheritDoc}
     */
static GBytes*
geary_memory_growable_buffer_real_get_bytes (GearyMemoryBuffer* base)
{
	GearyMemoryGrowableBuffer * self;
	GBytes* _tmp0_;
	GBytes* _tmp1_;
	GBytes* _tmp2_;
	GBytes* _tmp3_;
	GBytes* _tmp4_;
	GBytes* _tmp5_;
	GBytes* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_GROWABLE_BUFFER, GearyMemoryGrowableBuffer);
	_tmp0_ = geary_memory_growable_buffer_to_bytes (self);
	_tmp1_ = _tmp0_;
	_g_bytes_unref0 (_tmp1_);
	_tmp2_ = self->priv->bytes;
	_vala_assert (g_bytes_get_size (_tmp2_) > ((gsize) 0), "bytes.get_size() > 0");
	_tmp3_ = self->priv->bytes;
	_tmp4_ = self->priv->bytes;
	_tmp5_ = g_bytes_new_from_bytes (_tmp3_, (gsize) 0, g_bytes_get_size (_tmp4_) - 1);
	result = _tmp5_;
	return result;
}

/**
     * {@inheritDoc}
     */
static GByteArray*
geary_memory_growable_buffer_real_get_byte_array (GearyMemoryBuffer* base)
{
	GearyMemoryGrowableBuffer * self;
	GByteArray* copy = NULL;
	GByteArray* _tmp0_;
	GBytes* _tmp1_;
	GByteArray* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_GROWABLE_BUFFER, GearyMemoryGrowableBuffer);
	_tmp0_ = g_byte_array_new ();
	copy = _tmp0_;
	_tmp1_ = self->priv->bytes;
	if (_tmp1_ != NULL) {
		GByteArray* _tmp2_;
		gint _tmp3_ = 0;
		guint8* _tmp4_;
		_tmp2_ = copy;
		_tmp4_ = geary_memory_growable_buffer_get_bytes_no_nul (self, &_tmp3_);
		g_byte_array_append (_tmp2_, _tmp4_, (gint) _tmp3_);
	} else {
		GByteArray* _tmp5_;
		GByteArray* _tmp6_;
		gint _tmp7_ = 0;
		guint8* _tmp8_;
		_tmp5_ = self->priv->byte_array;
		_vala_assert (_tmp5_ != NULL, "byte_array != null");
		_tmp6_ = copy;
		_tmp8_ = geary_memory_growable_buffer_get_byte_array_no_nul (self, &_tmp7_);
		g_byte_array_append (_tmp6_, _tmp8_, (gint) _tmp7_);
	}
	result = copy;
	return result;
}

/**
     * {@inheritDoc}
     */
static guint8*
_vala_array_dup10 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
geary_memory_growable_buffer_real_get_uint8_array (GearyMemoryBuffer* base,
                                                   gint* result_length1)
{
	GearyMemoryGrowableBuffer * self;
	gint _tmp0_ = 0;
	guint8* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_GROWABLE_BUFFER, GearyMemoryGrowableBuffer);
	_tmp1_ = geary_memory_unowned_bytes_buffer_to_unowned_uint8_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_UNOWNED_BYTES_BUFFER, GearyMemoryUnownedBytesBuffer), &_tmp0_);
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup10 (_tmp1_, _tmp0_) : _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

/**
     * {@inheritDoc}
     */
static guint8*
geary_memory_growable_buffer_real_to_unowned_uint8_array (GearyMemoryUnownedBytesBuffer* base,
                                                          gint* result_length1)
{
	GearyMemoryGrowableBuffer * self;
	GBytes* _tmp0_;
	GByteArray* _tmp4_;
	gint _tmp5_ = 0;
	guint8* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	guint8* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_GROWABLE_BUFFER, GearyMemoryGrowableBuffer);
	_tmp0_ = self->priv->bytes;
	if (_tmp0_ != NULL) {
		gint _tmp1_ = 0;
		guint8* _tmp2_;
		guint8* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = geary_memory_growable_buffer_get_bytes_no_nul (self, &_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = _tmp1_;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->byte_array;
	_vala_assert (_tmp4_ != NULL, "byte_array != null");
	_tmp6_ = geary_memory_growable_buffer_get_byte_array_no_nul (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

/**
     * {@inheritDoc}
     */
static gchar*
geary_memory_growable_buffer_real_to_string (GearyMemoryBuffer* base)
{
	GearyMemoryGrowableBuffer * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_GROWABLE_BUFFER, GearyMemoryGrowableBuffer);
	_tmp0_ = geary_memory_unowned_string_buffer_to_unowned_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_UNOWNED_STRING_BUFFER, GearyMemoryUnownedStringBuffer));
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * {@inheritDoc}
     */
static const gchar*
geary_memory_growable_buffer_real_to_unowned_string (GearyMemoryUnownedStringBuffer* base)
{
	GearyMemoryGrowableBuffer * self;
	GBytes* _tmp0_;
	GByteArray* _tmp4_;
	GByteArray* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_GROWABLE_BUFFER, GearyMemoryGrowableBuffer);
	_tmp0_ = self->priv->bytes;
	if (_tmp0_ != NULL) {
		GBytes* _tmp1_;
		gsize _tmp2_ = 0;
		guint8* _tmp3_;
		_tmp1_ = self->priv->bytes;
		_tmp3_ = g_bytes_get_data (_tmp1_, &_tmp2_);
		result = (const gchar*) _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->byte_array;
	_vala_assert (_tmp4_ != NULL, "byte_array != null");
	_tmp5_ = self->priv->byte_array;
	_tmp6_ = _tmp5_->data;
	_tmp6__length1 = _tmp5_->len;
	result = (const gchar*) _tmp6_;
	return result;
}

static void
geary_memory_growable_buffer_class_init (GearyMemoryGrowableBufferClass * klass,
                                         gpointer klass_data)
{
	guint8* _tmp0_;
	geary_memory_growable_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyMemoryGrowableBuffer_private_offset);
	((GearyMemoryBufferClass *) klass)->get_bytes = (GBytes* (*) (GearyMemoryBuffer*)) geary_memory_growable_buffer_real_get_bytes;
	((GearyMemoryBufferClass *) klass)->get_byte_array = (GByteArray* (*) (GearyMemoryBuffer*)) geary_memory_growable_buffer_real_get_byte_array;
	((GearyMemoryBufferClass *) klass)->get_uint8_array = (guint8* (*) (GearyMemoryBuffer*, gint*)) geary_memory_growable_buffer_real_get_uint8_array;
	((GearyMemoryBufferClass *) klass)->to_string = (gchar* (*) (GearyMemoryBuffer*)) geary_memory_growable_buffer_real_to_string;
	GEARY_MEMORY_BUFFER_CLASS (klass)->get_size = geary_memory_growable_buffer_real_get_size;
	GEARY_MEMORY_BUFFER_CLASS (klass)->get_allocated_size = geary_memory_growable_buffer_real_get_allocated_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_memory_growable_buffer_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_memory_growable_buffer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MEMORY_GROWABLE_BUFFER_SIZE_PROPERTY, geary_memory_growable_buffer_properties[GEARY_MEMORY_GROWABLE_BUFFER_SIZE_PROPERTY] = g_param_spec_ulong ("size", "size", "size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MEMORY_GROWABLE_BUFFER_ALLOCATED_SIZE_PROPERTY, geary_memory_growable_buffer_properties[GEARY_MEMORY_GROWABLE_BUFFER_ALLOCATED_SIZE_PROPERTY] = g_param_spec_ulong ("allocated-size", "allocated-size", "allocated-size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = g_new0 (guint8, 1);
	_tmp0_[0] = (guint8) '\0';
	geary_memory_growable_buffer_NUL_ARRAY = _tmp0_;
	geary_memory_growable_buffer_NUL_ARRAY_length1 = 1;
}

static void
geary_memory_growable_buffer_geary_memory_unowned_bytes_buffer_interface_init (GearyMemoryUnownedBytesBufferIface * iface,
                                                                               gpointer iface_data)
{
	geary_memory_growable_buffer_geary_memory_unowned_bytes_buffer_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_unowned_uint8_array = (guint8* (*) (GearyMemoryUnownedBytesBuffer*, gint*)) geary_memory_growable_buffer_real_to_unowned_uint8_array;
}

static void
geary_memory_growable_buffer_geary_memory_unowned_string_buffer_interface_init (GearyMemoryUnownedStringBufferIface * iface,
                                                                                gpointer iface_data)
{
	geary_memory_growable_buffer_geary_memory_unowned_string_buffer_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_unowned_string = (const gchar* (*) (GearyMemoryUnownedStringBuffer*)) geary_memory_growable_buffer_real_to_unowned_string;
}

static void
geary_memory_growable_buffer_instance_init (GearyMemoryGrowableBuffer * self,
                                            gpointer klass)
{
	GByteArray* _tmp0_;
	self->priv = geary_memory_growable_buffer_get_instance_private (self);
	_tmp0_ = g_byte_array_new ();
	self->priv->byte_array = _tmp0_;
	self->priv->bytes = NULL;
}

static void
geary_memory_growable_buffer_finalize (GObject * obj)
{
	GearyMemoryGrowableBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_MEMORY_TYPE_GROWABLE_BUFFER, GearyMemoryGrowableBuffer);
	_g_byte_array_unref0 (self->priv->byte_array);
	_g_bytes_unref0 (self->priv->bytes);
	G_OBJECT_CLASS (geary_memory_growable_buffer_parent_class)->finalize (obj);
}

/**
 * An {@link Buffer} that can be grown by appending additional buffer fragments.
 *
 * A buffer can be grown by appending data to it ({@link append}), or by allocating additional space
 * in the internal buffer ({@link allocate}) which can then be trimmed back if not entirely used
 * ({@link trim}).
 */
 G_GNUC_NO_INLINE static GType
geary_memory_growable_buffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMemoryGrowableBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_memory_growable_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMemoryGrowableBuffer), 0, (GInstanceInitFunc) geary_memory_growable_buffer_instance_init, NULL };
	static const GInterfaceInfo geary_memory_unowned_bytes_buffer_info = { (GInterfaceInitFunc) geary_memory_growable_buffer_geary_memory_unowned_bytes_buffer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo geary_memory_unowned_string_buffer_info = { (GInterfaceInitFunc) geary_memory_growable_buffer_geary_memory_unowned_string_buffer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_memory_growable_buffer_type_id;
	geary_memory_growable_buffer_type_id = g_type_register_static (GEARY_MEMORY_TYPE_BUFFER, "GearyMemoryGrowableBuffer", &g_define_type_info, 0);
	g_type_add_interface_static (geary_memory_growable_buffer_type_id, GEARY_MEMORY_TYPE_UNOWNED_BYTES_BUFFER, &geary_memory_unowned_bytes_buffer_info);
	g_type_add_interface_static (geary_memory_growable_buffer_type_id, GEARY_MEMORY_TYPE_UNOWNED_STRING_BUFFER, &geary_memory_unowned_string_buffer_info);
	GearyMemoryGrowableBuffer_private_offset = g_type_add_instance_private (geary_memory_growable_buffer_type_id, sizeof (GearyMemoryGrowableBufferPrivate));
	return geary_memory_growable_buffer_type_id;
}

GType
geary_memory_growable_buffer_get_type (void)
{
	static gsize geary_memory_growable_buffer_type_id__once = 0;
	if (g_once_init_enter (&geary_memory_growable_buffer_type_id__once)) {
		GType geary_memory_growable_buffer_type_id;
		geary_memory_growable_buffer_type_id = geary_memory_growable_buffer_get_type_once ();
		g_once_init_leave (&geary_memory_growable_buffer_type_id__once, geary_memory_growable_buffer_type_id);
	}
	return geary_memory_growable_buffer_type_id__once;
}

static void
_vala_geary_memory_growable_buffer_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	GearyMemoryGrowableBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MEMORY_TYPE_GROWABLE_BUFFER, GearyMemoryGrowableBuffer);
	switch (property_id) {
		case GEARY_MEMORY_GROWABLE_BUFFER_SIZE_PROPERTY:
		g_value_set_ulong (value, geary_memory_buffer_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer)));
		break;
		case GEARY_MEMORY_GROWABLE_BUFFER_ALLOCATED_SIZE_PROPERTY:
		g_value_set_ulong (value, geary_memory_buffer_get_allocated_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

