/* memory-unowned-string-buffer.c generated by valac 0.56.3, the Vala compiler
 * generated from memory-unowned-string-buffer.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

static GType geary_memory_unowned_string_buffer_get_type_once (void);

/**
     * Returns an unowned string version of the backing buffer.
     *
     * The returned string should not be modified or freed.
     */
const gchar*
geary_memory_unowned_string_buffer_to_unowned_string (GearyMemoryUnownedStringBuffer* self)
{
	GearyMemoryUnownedStringBufferIface* _iface_;
	g_return_val_if_fail (GEARY_MEMORY_IS_UNOWNED_STRING_BUFFER (self), NULL);
	_iface_ = GEARY_MEMORY_UNOWNED_STRING_BUFFER_GET_INTERFACE (self);
	if (_iface_->to_unowned_string) {
		return _iface_->to_unowned_string (self);
	}
	return NULL;
}

static void
geary_memory_unowned_string_buffer_default_init (GearyMemoryUnownedStringBufferIface * iface,
                                                 gpointer iface_data)
{
}

/**
 * Interface which allows access to backing string of {@link Memory.Buffer} without transferring
 * ownership, i.e. copying the string.
 *
 * The presence of this interface indicates that obtaining access to the backing string is cheap.
 *
 * Not all AbstractBuffers can support this call, but if they can, this interface allows for it.
 * The buffers that are returned should ''not'' be modified or freed by the caller.
 */
 G_GNUC_NO_INLINE static GType
geary_memory_unowned_string_buffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMemoryUnownedStringBufferIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_memory_unowned_string_buffer_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType geary_memory_unowned_string_buffer_type_id;
	geary_memory_unowned_string_buffer_type_id = g_type_register_static (G_TYPE_INTERFACE, "GearyMemoryUnownedStringBuffer", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (geary_memory_unowned_string_buffer_type_id, GEARY_MEMORY_TYPE_BUFFER);
	return geary_memory_unowned_string_buffer_type_id;
}

GType
geary_memory_unowned_string_buffer_get_type (void)
{
	static gsize geary_memory_unowned_string_buffer_type_id__once = 0;
	if (g_once_init_enter (&geary_memory_unowned_string_buffer_type_id__once)) {
		GType geary_memory_unowned_string_buffer_type_id;
		geary_memory_unowned_string_buffer_type_id = geary_memory_unowned_string_buffer_get_type_once ();
		g_once_init_leave (&geary_memory_unowned_string_buffer_type_id__once, geary_memory_unowned_string_buffer_type_id);
	}
	return geary_memory_unowned_string_buffer_type_id__once;
}

