/* mime-content-parameters.c generated by valac 0.56.3, the Vala compiler
 * generated from mime-content-parameters.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gmime/gmime.h>

enum  {
	GEARY_MIME_CONTENT_PARAMETERS_0_PROPERTY,
	GEARY_MIME_CONTENT_PARAMETERS_SIZE_PROPERTY,
	GEARY_MIME_CONTENT_PARAMETERS_ATTRIBUTES_PROPERTY,
	GEARY_MIME_CONTENT_PARAMETERS_NUM_PROPERTIES
};
static GParamSpec* geary_mime_content_parameters_properties[GEARY_MIME_CONTENT_PARAMETERS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyMimeContentParametersPrivate {
	GeeHashMap* params;
};

static gint GearyMimeContentParameters_private_offset;
static gpointer geary_mime_content_parameters_parent_class = NULL;

static guint _geary_ascii_stri_hash_gee_hash_data_func (gconstpointer v,
                                                 gpointer self);
static gboolean _geary_ascii_stri_equal_gee_equal_data_func (gconstpointer a,
                                                      gconstpointer b,
                                                      gpointer self);
VALA_EXTERN GearyMimeContentParameters* geary_mime_content_parameters_new_from_gmime (GMimeParamList* gmime);
VALA_EXTERN GearyMimeContentParameters* geary_mime_content_parameters_construct_from_gmime (GType object_type,
                                                                                GMimeParamList* gmime);
static void geary_mime_content_parameters_finalize (GObject * obj);
static GType geary_mime_content_parameters_get_type_once (void);
static void _vala_geary_mime_content_parameters_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
geary_mime_content_parameters_get_instance_private (GearyMimeContentParameters* self)
{
	return G_STRUCT_MEMBER_P (self, GearyMimeContentParameters_private_offset);
}

gint
geary_mime_content_parameters_get_size (GearyMimeContentParameters* self)
{
	gint result;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_PARAMETERS (self), 0);
	_tmp0_ = self->priv->params;
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

GeeCollection*
geary_mime_content_parameters_get_attributes (GearyMimeContentParameters* self)
{
	GeeCollection* result;
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_PARAMETERS (self), NULL);
	_tmp0_ = self->priv->params;
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

static guint
_geary_ascii_stri_hash_gee_hash_data_func (gconstpointer v,
                                           gpointer self)
{
	guint result;
	result = geary_ascii_stri_hash ((const gchar*) v);
	return result;
}

static gboolean
_geary_ascii_stri_equal_gee_equal_data_func (gconstpointer a,
                                             gconstpointer b,
                                             gpointer self)
{
	gboolean result;
	result = geary_ascii_stri_equal ((const gchar*) a, (const gchar*) b);
	return result;
}

/**
     * Create a mapping of content parameters.
     *
     * A Gee.Map may be supplied to initialize the parameter attributes (names) and values.
     *
     * Note that params may be any kind of Map, but they will be stored internally in a Map that
     * uses case-insensitive keys.  See {@link get_parameters} for more details.
     */
GearyMimeContentParameters*
geary_mime_content_parameters_construct (GType object_type,
                                         GeeMap* params)
{
	GearyMimeContentParameters * self = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail ((params == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (params, GEE_TYPE_MAP), NULL);
	self = (GearyMimeContentParameters*) geary_base_object_construct (object_type);
	if (params != NULL) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = gee_map_get_size (params);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeHashMap* _tmp3_;
		_tmp3_ = self->priv->params;
		geary_collection_map_set_all (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_MAP, GeeMap), params);
	}
	return self;
}

GearyMimeContentParameters*
geary_mime_content_parameters_new (GeeMap* params)
{
	return geary_mime_content_parameters_construct (GEARY_MIME_TYPE_CONTENT_PARAMETERS, params);
}

/**
     * Create a mapping of content parameters.
     *
     * Note that the given params must be a two-dimensional array,
     * where each element contains a key/value pair.
     */
GearyMimeContentParameters*
geary_mime_content_parameters_construct_from_array (GType object_type,
                                                    gchar** params,
                                                    gint params_length1,
                                                    gint params_length2)
{
	GearyMimeContentParameters * self = NULL;
	self = (GearyMimeContentParameters*) geary_base_object_construct (object_type);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GeeHashMap* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = params_length1;
				if (!(i < _tmp2_)) {
					break;
				}
				_tmp3_ = self->priv->params;
				_tmp4_ = params[(i * params_length2) + 0];
				_tmp5_ = params[(i * params_length2) + 1];
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_, _tmp5_);
			}
		}
	}
	return self;
}

GearyMimeContentParameters*
geary_mime_content_parameters_new_from_array (gchar** params,
                                              gint params_length1,
                                              gint params_length2)
{
	return geary_mime_content_parameters_construct_from_array (GEARY_MIME_TYPE_CONTENT_PARAMETERS, params, params_length1, params_length2);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyMimeContentParameters*
geary_mime_content_parameters_construct_from_gmime (GType object_type,
                                                    GMimeParamList* gmime)
{
	GearyMimeContentParameters * self = NULL;
	GeeHashMap* parameters = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp10_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (gmime, g_mime_param_list_get_type ()), NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	parameters = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GMimeParam* param = NULL;
				GMimeParam* _tmp3_;
				GMimeParam* _tmp4_;
				GeeHashMap* _tmp5_;
				GMimeParam* _tmp6_;
				const gchar* _tmp7_;
				GMimeParam* _tmp8_;
				const gchar* _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < g_mime_param_list_length (gmime))) {
					break;
				}
				_tmp3_ = g_mime_param_list_get_parameter_at (gmime, i);
				_tmp4_ = _g_object_ref0 (_tmp3_);
				param = _tmp4_;
				_tmp5_ = parameters;
				_tmp6_ = param;
				_tmp7_ = _tmp6_->name;
				_tmp8_ = param;
				_tmp9_ = _tmp8_->value;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_, _tmp9_);
				_g_object_unref0 (param);
			}
		}
	}
	_tmp10_ = parameters;
	self = (GearyMimeContentParameters*) geary_mime_content_parameters_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_MAP, GeeMap));
	_g_object_unref0 (parameters);
	return self;
}

GearyMimeContentParameters*
geary_mime_content_parameters_new_from_gmime (GMimeParamList* gmime)
{
	return geary_mime_content_parameters_construct_from_gmime (GEARY_MIME_TYPE_CONTENT_PARAMETERS, gmime);
}

/**
     * A read-only mapping of parameter attributes (names) and values.
     *
     * Note that names are stored as case-insensitive tokens.  The MIME specification does allow
     * for some parameter values to be case-sensitive and so they are stored as such.  It is up
     * to the caller to use the right comparison method.
     *
     * @see has_value_ci
     * @see has_value_cs
     */
GeeMap*
geary_mime_content_parameters_get_parameters (GearyMimeContentParameters* self)
{
	GeeHashMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_PARAMETERS (self), NULL);
	_tmp0_ = self->priv->params;
	_tmp1_ = gee_abstract_map_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
     * Returns the parameter value for the attribute name.
     *
     * Returns null if not present.
     */
gchar*
geary_mime_content_parameters_get_value (GearyMimeContentParameters* self,
                                         const gchar* attribute)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_PARAMETERS (self), NULL);
	g_return_val_if_fail (attribute != NULL, NULL);
	_tmp0_ = self->priv->params;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), attribute);
	result = (gchar*) _tmp1_;
	return result;
}

/**
     * Returns true if the attribute has the supplied value (case-insensitive comparison).
     *
     * @see has_value_cs
     */
gboolean
geary_mime_content_parameters_has_value_ci (GearyMimeContentParameters* self,
                                            const gchar* attribute,
                                            const gchar* value)
{
	gchar* stored = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_PARAMETERS (self), FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = self->priv->params;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), attribute);
	stored = (gchar*) _tmp1_;
	_tmp3_ = stored;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = stored;
		_tmp2_ = geary_ascii_stri_equal (_tmp4_, value);
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_free0 (stored);
	return result;
}

/**
     * Returns true if the attribute has the supplied value (case-sensitive comparison).
     *
     * @see has_value_ci
     */
gboolean
geary_mime_content_parameters_has_value_cs (GearyMimeContentParameters* self,
                                            const gchar* attribute,
                                            const gchar* value)
{
	gchar* stored = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_PARAMETERS (self), FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = self->priv->params;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), attribute);
	stored = (gchar*) _tmp1_;
	_tmp3_ = stored;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = stored;
		_tmp2_ = geary_ascii_str_equal (_tmp4_, value);
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_free0 (stored);
	return result;
}

static void
geary_mime_content_parameters_class_init (GearyMimeContentParametersClass * klass,
                                          gpointer klass_data)
{
	geary_mime_content_parameters_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyMimeContentParameters_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_mime_content_parameters_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_mime_content_parameters_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MIME_CONTENT_PARAMETERS_SIZE_PROPERTY, geary_mime_content_parameters_properties[GEARY_MIME_CONTENT_PARAMETERS_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MIME_CONTENT_PARAMETERS_ATTRIBUTES_PROPERTY, geary_mime_content_parameters_properties[GEARY_MIME_CONTENT_PARAMETERS_ATTRIBUTES_PROPERTY] = g_param_spec_object ("attributes", "attributes", "attributes", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_mime_content_parameters_instance_init (GearyMimeContentParameters * self,
                                             gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = geary_mime_content_parameters_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _geary_ascii_stri_hash_gee_hash_data_func, NULL, NULL, _geary_ascii_stri_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->params = _tmp0_;
}

static void
geary_mime_content_parameters_finalize (GObject * obj)
{
	GearyMimeContentParameters * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_MIME_TYPE_CONTENT_PARAMETERS, GearyMimeContentParameters);
	_g_object_unref0 (self->priv->params);
	G_OBJECT_CLASS (geary_mime_content_parameters_parent_class)->finalize (obj);
}

/**
 * Content parameters (for {@link ContentType} and {@link ContentDisposition}).
 *
 * This class is immutable.
 */
 G_GNUC_NO_INLINE static GType
geary_mime_content_parameters_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMimeContentParametersClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_mime_content_parameters_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMimeContentParameters), 0, (GInstanceInitFunc) geary_mime_content_parameters_instance_init, NULL };
	GType geary_mime_content_parameters_type_id;
	geary_mime_content_parameters_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyMimeContentParameters", &g_define_type_info, 0);
	GearyMimeContentParameters_private_offset = g_type_add_instance_private (geary_mime_content_parameters_type_id, sizeof (GearyMimeContentParametersPrivate));
	return geary_mime_content_parameters_type_id;
}

GType
geary_mime_content_parameters_get_type (void)
{
	static gsize geary_mime_content_parameters_type_id__once = 0;
	if (g_once_init_enter (&geary_mime_content_parameters_type_id__once)) {
		GType geary_mime_content_parameters_type_id;
		geary_mime_content_parameters_type_id = geary_mime_content_parameters_get_type_once ();
		g_once_init_leave (&geary_mime_content_parameters_type_id__once, geary_mime_content_parameters_type_id);
	}
	return geary_mime_content_parameters_type_id__once;
}

static void
_vala_geary_mime_content_parameters_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GearyMimeContentParameters * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MIME_TYPE_CONTENT_PARAMETERS, GearyMimeContentParameters);
	switch (property_id) {
		case GEARY_MIME_CONTENT_PARAMETERS_SIZE_PROPERTY:
		g_value_set_int (value, geary_mime_content_parameters_get_size (self));
		break;
		case GEARY_MIME_CONTENT_PARAMETERS_ATTRIBUTES_PROPERTY:
		g_value_take_object (value, geary_mime_content_parameters_get_attributes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

