/* smtp-response-code.c generated by valac 0.56.3, the Vala compiler
 * generated from smtp-response-code.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _geary_smtp_response_code_unref0(var) ((var == NULL) ? NULL : (var = (geary_smtp_response_code_unref (var), NULL)))
typedef struct _GearySmtpParamSpecResponseCode GearySmtpParamSpecResponseCode;

struct _GearySmtpResponseCodePrivate {
	gchar* str;
};

struct _GearySmtpParamSpecResponseCode {
	GParamSpec parent_instance;
};

static gint GearySmtpResponseCode_private_offset;
static gpointer geary_smtp_response_code_parent_class = NULL;

static void geary_smtp_response_code_finalize (GearySmtpResponseCode * obj);
static GType geary_smtp_response_code_get_type_once (void);

static inline gpointer
geary_smtp_response_code_get_instance_private (GearySmtpResponseCode* self)
{
	return G_STRUCT_MEMBER_P (self, GearySmtpResponseCode_private_offset);
}

 G_GNUC_NO_INLINE static GType
geary_smtp_response_code_status_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_SMTP_RESPONSE_CODE_STATUS_POSITIVE_PRELIMINARY, "GEARY_SMTP_RESPONSE_CODE_STATUS_POSITIVE_PRELIMINARY", "positive-preliminary"}, {GEARY_SMTP_RESPONSE_CODE_STATUS_POSITIVE_COMPLETION, "GEARY_SMTP_RESPONSE_CODE_STATUS_POSITIVE_COMPLETION", "positive-completion"}, {GEARY_SMTP_RESPONSE_CODE_STATUS_POSITIVE_INTERMEDIATE, "GEARY_SMTP_RESPONSE_CODE_STATUS_POSITIVE_INTERMEDIATE", "positive-intermediate"}, {GEARY_SMTP_RESPONSE_CODE_STATUS_TRANSIENT_NEGATIVE, "GEARY_SMTP_RESPONSE_CODE_STATUS_TRANSIENT_NEGATIVE", "transient-negative"}, {GEARY_SMTP_RESPONSE_CODE_STATUS_PERMANENT_FAILURE, "GEARY_SMTP_RESPONSE_CODE_STATUS_PERMANENT_FAILURE", "permanent-failure"}, {GEARY_SMTP_RESPONSE_CODE_STATUS_UNKNOWN, "GEARY_SMTP_RESPONSE_CODE_STATUS_UNKNOWN", "unknown"}, {0, NULL, NULL}};
	GType geary_smtp_response_code_status_type_id;
	geary_smtp_response_code_status_type_id = g_enum_register_static ("GearySmtpResponseCodeStatus", values);
	return geary_smtp_response_code_status_type_id;
}

GType
geary_smtp_response_code_status_get_type (void)
{
	static gsize geary_smtp_response_code_status_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_response_code_status_type_id__once)) {
		GType geary_smtp_response_code_status_type_id;
		geary_smtp_response_code_status_type_id = geary_smtp_response_code_status_get_type_once ();
		g_once_init_leave (&geary_smtp_response_code_status_type_id__once, geary_smtp_response_code_status_type_id);
	}
	return geary_smtp_response_code_status_type_id__once;
}

 G_GNUC_NO_INLINE static GType
geary_smtp_response_code_condition_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_SMTP_RESPONSE_CODE_CONDITION_SYNTAX, "GEARY_SMTP_RESPONSE_CODE_CONDITION_SYNTAX", "syntax"}, {GEARY_SMTP_RESPONSE_CODE_CONDITION_ADDITIONAL_INFO, "GEARY_SMTP_RESPONSE_CODE_CONDITION_ADDITIONAL_INFO", "additional-info"}, {GEARY_SMTP_RESPONSE_CODE_CONDITION_COMM_CHANNEL, "GEARY_SMTP_RESPONSE_CODE_CONDITION_COMM_CHANNEL", "comm-channel"}, {GEARY_SMTP_RESPONSE_CODE_CONDITION_MAIL_SYSTEM, "GEARY_SMTP_RESPONSE_CODE_CONDITION_MAIL_SYSTEM", "mail-system"}, {GEARY_SMTP_RESPONSE_CODE_CONDITION_UNKNOWN, "GEARY_SMTP_RESPONSE_CODE_CONDITION_UNKNOWN", "unknown"}, {0, NULL, NULL}};
	GType geary_smtp_response_code_condition_type_id;
	geary_smtp_response_code_condition_type_id = g_enum_register_static ("GearySmtpResponseCodeCondition", values);
	return geary_smtp_response_code_condition_type_id;
}

GType
geary_smtp_response_code_condition_get_type (void)
{
	static gsize geary_smtp_response_code_condition_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_response_code_condition_type_id__once)) {
		GType geary_smtp_response_code_condition_type_id;
		geary_smtp_response_code_condition_type_id = geary_smtp_response_code_condition_get_type_once ();
		g_once_init_leave (&geary_smtp_response_code_condition_type_id__once, geary_smtp_response_code_condition_type_id);
	}
	return geary_smtp_response_code_condition_type_id__once;
}

GearySmtpResponseCode*
geary_smtp_response_code_construct (GType object_type,
                                    const gchar* str,
                                    GError** error)
{
	GearySmtpResponseCode* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint as_int = 0;
	gboolean _tmp5_ = FALSE;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	self = (GearySmtpResponseCode*) g_type_create_instance (object_type);
	_tmp0_ = strlen (str);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != GEARY_SMTP_RESPONSE_CODE_STRLEN) {
		gint _tmp2_;
		gint _tmp3_;
		GError* _tmp4_;
		_tmp2_ = strlen (str);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_PARSE_ERROR, "Reply code wrong length: %s (%d)", str, _tmp3_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_SMTP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_geary_smtp_response_code_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	as_int = atoi (str);
	if (as_int < GEARY_SMTP_RESPONSE_CODE_MIN) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = as_int > GEARY_SMTP_RESPONSE_CODE_MAX;
	}
	if (_tmp5_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_PARSE_ERROR, "Reply code out of range: %s", str);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == GEARY_SMTP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_geary_smtp_response_code_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = g_strdup (str);
	_g_free0 (self->priv->str);
	self->priv->str = _tmp7_;
	return self;
}

GearySmtpResponseCode*
geary_smtp_response_code_new (const gchar* str,
                              GError** error)
{
	return geary_smtp_response_code_construct (GEARY_SMTP_TYPE_RESPONSE_CODE, str, error);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

GearySmtpResponseCodeStatus
geary_smtp_response_code_get_status (GearySmtpResponseCode* self)
{
	gint i = 0;
	const gchar* _tmp0_;
	GearySmtpResponseCodeStatus _tmp1_ = 0;
	GearySmtpResponseCodeStatus result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (self), 0);
	_tmp0_ = self->priv->str;
	i = geary_ascii_digit_to_int (string_get (_tmp0_, (glong) 0));
	if (i != -1) {
		_tmp1_ = (GearySmtpResponseCodeStatus) i;
	} else {
		_tmp1_ = GEARY_SMTP_RESPONSE_CODE_STATUS_UNKNOWN;
	}
	result = _tmp1_;
	return result;
}

GearySmtpResponseCodeCondition
geary_smtp_response_code_get_condition (GearySmtpResponseCode* self)
{
	const gchar* _tmp0_;
	GearySmtpResponseCodeCondition result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (self), 0);
	_tmp0_ = self->priv->str;
	switch (geary_ascii_digit_to_int (string_get (_tmp0_, (glong) 1))) {
		case GEARY_SMTP_RESPONSE_CODE_CONDITION_SYNTAX:
		{
			result = GEARY_SMTP_RESPONSE_CODE_CONDITION_SYNTAX;
			return result;
		}
		case GEARY_SMTP_RESPONSE_CODE_CONDITION_ADDITIONAL_INFO:
		{
			result = GEARY_SMTP_RESPONSE_CODE_CONDITION_ADDITIONAL_INFO;
			return result;
		}
		case GEARY_SMTP_RESPONSE_CODE_CONDITION_COMM_CHANNEL:
		{
			result = GEARY_SMTP_RESPONSE_CODE_CONDITION_COMM_CHANNEL;
			return result;
		}
		case GEARY_SMTP_RESPONSE_CODE_CONDITION_MAIL_SYSTEM:
		{
			result = GEARY_SMTP_RESPONSE_CODE_CONDITION_MAIL_SYSTEM;
			return result;
		}
		default:
		{
			result = GEARY_SMTP_RESPONSE_CODE_CONDITION_UNKNOWN;
			return result;
		}
	}
}

gboolean
geary_smtp_response_code_is_success_completed (GearySmtpResponseCode* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (self), FALSE);
	result = geary_smtp_response_code_get_status (self) == GEARY_SMTP_RESPONSE_CODE_STATUS_POSITIVE_COMPLETION;
	return result;
}

gboolean
geary_smtp_response_code_is_success_intermediate (GearySmtpResponseCode* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (self), FALSE);
	switch (geary_smtp_response_code_get_status (self)) {
		case GEARY_SMTP_RESPONSE_CODE_STATUS_POSITIVE_PRELIMINARY:
		case GEARY_SMTP_RESPONSE_CODE_STATUS_POSITIVE_INTERMEDIATE:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

gboolean
geary_smtp_response_code_is_failure (GearySmtpResponseCode* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (self), FALSE);
	switch (geary_smtp_response_code_get_status (self)) {
		case GEARY_SMTP_RESPONSE_CODE_STATUS_PERMANENT_FAILURE:
		case GEARY_SMTP_RESPONSE_CODE_STATUS_TRANSIENT_NEGATIVE:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

gboolean
geary_smtp_response_code_is_start_data (GearySmtpResponseCode* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (self), FALSE);
	_tmp0_ = self->priv->str;
	result = g_strcmp0 (_tmp0_, GEARY_SMTP_RESPONSE_CODE_START_DATA_CODE) == 0;
	return result;
}

gboolean
geary_smtp_response_code_is_starttls_ready (GearySmtpResponseCode* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (self), FALSE);
	_tmp0_ = self->priv->str;
	result = g_strcmp0 (_tmp0_, GEARY_SMTP_RESPONSE_CODE_STARTTLS_READY_CODE) == 0;
	return result;
}

gboolean
geary_smtp_response_code_is_denied (GearySmtpResponseCode* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (self), FALSE);
	_tmp0_ = self->priv->str;
	result = g_strcmp0 (_tmp0_, GEARY_SMTP_RESPONSE_CODE_DENIED_CODE) == 0;
	return result;
}

/**
     * Returns true for [@link Status.PERMANENT_FAILURE} {@link Condition.SYNTAX} errors.
     *
     * Generally this means the command (or sequence of commands) was unknown or unimplemented,
     * i.e. "500 Syntax error", "502 Command not implemented", etc.
     *
     * See [[http://tools.ietf.org/html/rfc5321#section-4.2.2]]
     */
gboolean
geary_smtp_response_code_is_syntax_error (GearySmtpResponseCode* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (self), FALSE);
	if (geary_smtp_response_code_get_status (self) == GEARY_SMTP_RESPONSE_CODE_STATUS_PERMANENT_FAILURE) {
		_tmp0_ = geary_smtp_response_code_get_condition (self) == GEARY_SMTP_RESPONSE_CODE_CONDITION_SYNTAX;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
geary_smtp_response_code_serialize (GearySmtpResponseCode* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (self), NULL);
	_tmp0_ = self->priv->str;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
geary_smtp_response_code_to_string (GearySmtpResponseCode* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (self), NULL);
	_tmp0_ = self->priv->str;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
geary_smtp_value_response_code_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_smtp_value_response_code_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_smtp_response_code_unref (value->data[0].v_pointer);
	}
}

static void
geary_smtp_value_response_code_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_smtp_response_code_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_smtp_value_response_code_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_smtp_value_response_code_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearySmtpResponseCode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_smtp_response_code_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_smtp_value_response_code_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	GearySmtpResponseCode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_smtp_response_code_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
geary_smtp_param_spec_response_code (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	GearySmtpParamSpecResponseCode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_SMTP_TYPE_RESPONSE_CODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
geary_smtp_value_get_response_code (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_SMTP_TYPE_RESPONSE_CODE), NULL);
	return value->data[0].v_pointer;
}

void
geary_smtp_value_set_response_code (GValue* value,
                                    gpointer v_object)
{
	GearySmtpResponseCode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_SMTP_TYPE_RESPONSE_CODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_SMTP_TYPE_RESPONSE_CODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_smtp_response_code_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_smtp_response_code_unref (old);
	}
}

void
geary_smtp_value_take_response_code (GValue* value,
                                     gpointer v_object)
{
	GearySmtpResponseCode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_SMTP_TYPE_RESPONSE_CODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_SMTP_TYPE_RESPONSE_CODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_smtp_response_code_unref (old);
	}
}

static void
geary_smtp_response_code_class_init (GearySmtpResponseCodeClass * klass,
                                     gpointer klass_data)
{
	geary_smtp_response_code_parent_class = g_type_class_peek_parent (klass);
	((GearySmtpResponseCodeClass *) klass)->finalize = geary_smtp_response_code_finalize;
	g_type_class_adjust_private_offset (klass, &GearySmtpResponseCode_private_offset);
}

static void
geary_smtp_response_code_instance_init (GearySmtpResponseCode * self,
                                        gpointer klass)
{
	self->priv = geary_smtp_response_code_get_instance_private (self);
	self->ref_count = 1;
}

static void
geary_smtp_response_code_finalize (GearySmtpResponseCode * obj)
{
	GearySmtpResponseCode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SMTP_TYPE_RESPONSE_CODE, GearySmtpResponseCode);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->str);
}

 G_GNUC_NO_INLINE static GType
geary_smtp_response_code_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_smtp_value_response_code_init, geary_smtp_value_response_code_free_value, geary_smtp_value_response_code_copy_value, geary_smtp_value_response_code_peek_pointer, "p", geary_smtp_value_response_code_collect_value, "p", geary_smtp_value_response_code_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpResponseCodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_response_code_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpResponseCode), 0, (GInstanceInitFunc) geary_smtp_response_code_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_smtp_response_code_type_id;
	geary_smtp_response_code_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearySmtpResponseCode", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GearySmtpResponseCode_private_offset = g_type_add_instance_private (geary_smtp_response_code_type_id, sizeof (GearySmtpResponseCodePrivate));
	return geary_smtp_response_code_type_id;
}

GType
geary_smtp_response_code_get_type (void)
{
	static gsize geary_smtp_response_code_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_response_code_type_id__once)) {
		GType geary_smtp_response_code_type_id;
		geary_smtp_response_code_type_id = geary_smtp_response_code_get_type_once ();
		g_once_init_leave (&geary_smtp_response_code_type_id__once, geary_smtp_response_code_type_id);
	}
	return geary_smtp_response_code_type_id__once;
}

gpointer
geary_smtp_response_code_ref (gpointer instance)
{
	GearySmtpResponseCode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
geary_smtp_response_code_unref (gpointer instance)
{
	GearySmtpResponseCode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_SMTP_RESPONSE_CODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

