/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public class AliasMethod
extends DynamicMethod {
    private final CacheEntry entry;
    private final boolean findImplementer;

    public AliasMethod(RubyModule implementationClass, CacheEntry entry, String oldName) {
        super(implementationClass, entry.method.getVisibility(), oldName);
        entry.method.getRealMethod().adjustAliasCount(1);
        this.entry = entry;
        boolean findImplementer = true;
        if (entry.method instanceof AbstractIRMethod) {
            findImplementer = ((AbstractIRMethod)entry.method).needsToFindImplementer();
        }
        this.findImplementer = findImplementer;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.name);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.name, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg1, IRubyObject arg2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.name, arg1, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.name, arg1, arg2, arg3);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject[] args2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.name, args2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.name, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg1, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.name, arg1, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.name, arg1, arg2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.name, arg1, arg2, arg3, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject[] args2, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.name, args2, block);
    }

    @Override
    public DynamicMethod dup() {
        return new AliasMethod(this.implementationClass, this.entry, this.name);
    }

    @Override
    @Deprecated
    public Arity getArity() {
        return this.entry.method.getArity();
    }

    @Override
    public Signature getSignature() {
        return this.entry.method.getSignature();
    }

    public String getOldName() {
        return this.entry.method.getName();
    }

    @Override
    public DynamicMethod getRealMethod() {
        return this.entry.method.getRealMethod();
    }

    @Override
    public long getSerialNumber() {
        return this.entry.method.getSerialNumber();
    }

    private RubyModule calculateSourceModule(IRubyObject self2, RubyModule incomingSourceModule) {
        if (this.findImplementer) {
            return Helpers.findImplementerIfNecessary(self2.getMetaClass(), this.entry.method.getImplementationClass());
        }
        return incomingSourceModule;
    }

    @Override
    public boolean isNative() {
        return this.entry.method.isNative();
    }

    @Override
    public void setRuby2Keywords() {
        this.entry.method.setRuby2Keywords();
    }
}

