/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.javafx;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.javafx.EventObservableList;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ListView;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class EventObservableListDemo
extends Application {
    public static void main(String[] args2) {
        Application.launch(EventObservableListDemo.class, (String[])args2);
    }

    public void start(Stage stage) throws Exception {
        stage.setTitle("List Backed by GlazedLists");
        final BasicEventList<String> base_list = new BasicEventList<String>();
        for (int i = 0; i < 10; ++i) {
            base_list.add(String.valueOf(i));
        }
        FilterList<String> filtered_list = new FilterList<String>(base_list, new Matcher<String>(){

            @Override
            public boolean matches(String item) {
                return !item.endsWith("5");
            }
        });
        SortedList<String> sorted_list = new SortedList<String>(filtered_list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i1 = Integer.parseInt(o1);
                int i2 = Integer.parseInt(o2);
                return i2 - i1;
            }
        });
        EventObservableList<String> model = new EventObservableList<String>(sorted_list);
        ListView listView = new ListView(model);
        listView.setPrefSize(200.0, 250.0);
        listView.setEditable(false);
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){
            int counter = 10;

            @Override
            public void run() {
                if (!Platform.isFxApplicationThread()) {
                    Platform.runLater((Runnable)this);
                    return;
                }
                String value = String.valueOf(this.counter++);
                base_list.add(value);
                System.out.println("Added " + value);
            }
        }, 1000L, 1000L);
        StackPane root = new StackPane();
        root.getChildren().add((Object)listView);
        stage.setScene(new Scene((Parent)root, 300.0, 250.0));
        stage.show();
    }
}

