/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox;

import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.ListChangeEvt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class ObservableList<T>
extends ArrayList<T>
implements List<T>,
RandomAccess,
Cloneable {
    private static final int DEFAULT_CAPACITY = 16;
    private final ArrayList<T> list;
    private Map<EvtType, List<EvtObserver<ListChangeEvt>>> observers;

    public ObservableList() {
        this(16);
    }

    public ObservableList(int capacity) {
        this.list = new ArrayList(capacity);
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ListChangeEvt>>>();
    }

    public ObservableList(List<T> list) {
        this.list = new ArrayList<T>(list);
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ListChangeEvt>>>();
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T element) {
        List<T> removedItems = List.of(this.list.get(index));
        List<T> addedItems = List.of(this.list.set(index, element));
        this.fireListChangeEvt(new ListChangeEvt<T>(this, ListChangeEvt.CHANGED, addedItems, removedItems));
        return addedItems.get(0);
    }

    @Override
    public boolean add(T element) {
        boolean result = this.list.add(element);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.ADDED, result ? List.of(element) : List.of(), List.of()));
        return result;
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
        this.fireListChangeEvt(new ListChangeEvt<T>(this, ListChangeEvt.ADDED, List.of(element), List.of()));
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean result = this.list.addAll(collection);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.ADDED, result ? new ArrayList<T>(collection) : List.of(), List.of()));
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        boolean result = this.list.addAll(index, collection);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.ADDED, result ? new ArrayList<T>(collection) : List.of(), List.of()));
        return result;
    }

    @Override
    public T remove(int index) {
        T e = this.list.remove(index);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, List.of(), List.of(e)));
        return e;
    }

    @Override
    public boolean remove(Object obj) {
        boolean result = this.list.remove(obj);
        ArrayList<Object> removedItems = new ArrayList<Object>();
        if (result) {
            removedItems.add(obj);
        }
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, List.of(), removedItems));
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = this.list.removeAll(collection);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, List.of(), result ? new ArrayList(collection) : List.of()));
        return result;
    }

    @Override
    public void clear() {
        Object clone = this.clone();
        this.list.clear();
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, List.of(), clone));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Object clone = this.clone();
        boolean result = this.list.retainAll(collection);
        List removedItems = clone.stream().filter(item -> !this.list.contains(item)).collect(Collectors.toList());
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, List.of(), removedItems));
        return result;
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    @Override
    public int indexOf(Object obj) {
        return this.list.indexOf(obj);
    }

    @Override
    public int lastIndexOf(Object obj) {
        return this.list.lastIndexOf(obj);
    }

    @Override
    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.list.ensureCapacity(minCapacity);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.list);
    }

    @Override
    public ObservableList<T> clone() {
        try {
            ObservableList<T> clone = new ObservableList<T>();
            clone.addAll((Collection<T>)this.list);
            return clone;
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.list.forEach((Consumer<T>)action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.list.spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        boolean result = this.list.removeIf(filter);
        if (result) {
            this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, null, null));
        }
        return this.list.removeIf(filter);
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        this.list.replaceAll(operator);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.CHANGED, null, null));
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        this.list.sort(comparator);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.CHANGED, List.of(), List.of()));
    }

    public void addListChangeObserver(EvtType type, EvtObserver<ListChangeEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeListChangeObserver(EvtType type, EvtObserver<ListChangeEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllListChangeObservers() {
        this.observers.clear();
    }

    public void fireListChangeEvt(ListChangeEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ListChangeEvt.ANY)).forEach((? super T entry) -> ((List)entry.getValue()).forEach((? super T observer) -> observer.handle(evt)));
        if (this.observers.containsKey(type) && !type.equals(ListChangeEvt.ANY)) {
            this.observers.get(type).forEach((? super T observer) -> observer.handle(evt));
        }
    }
}

