/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.alerting.model.BucketLevelTriggerRunResult;
import org.opensearch.alerting.model.DocumentLevelTriggerRunResult;
import org.opensearch.alerting.model.QueryLevelTriggerRunResult;
import org.opensearch.alerting.script.BucketLevelTriggerExecutionContext;
import org.opensearch.alerting.script.QueryLevelTriggerExecutionContext;
import org.opensearch.alerting.script.TriggerScript;
import org.opensearch.alerting.triggercondition.parsers.TriggerExpressionParser;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.commons.alerting.model.AggregationResultBucket;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.commons.alerting.model.DocumentLevelTrigger;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.QueryLevelTrigger;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.support.AggregationPath;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u001eJ0\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020!2\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0$0\u0011J\u001e\u0010%\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lorg/opensearch/alerting/TriggerService;", "", "scriptService", "Lorg/opensearch/script/ScriptService;", "(Lorg/opensearch/script/ScriptService;)V", "ALWAYS_RUN", "Lorg/opensearch/script/Script;", "NEVER_RUN", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getScriptService", "()Lorg/opensearch/script/ScriptService;", "getBucketKeyValuesList", "", "", "bucket", "", "isQueryLevelTriggerActionable", "", "ctx", "Lorg/opensearch/alerting/script/QueryLevelTriggerExecutionContext;", "result", "Lorg/opensearch/alerting/model/QueryLevelTriggerRunResult;", "runBucketLevelTrigger", "Lorg/opensearch/alerting/model/BucketLevelTriggerRunResult;", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "trigger", "Lorg/opensearch/commons/alerting/model/BucketLevelTrigger;", "Lorg/opensearch/alerting/script/BucketLevelTriggerExecutionContext;", "runDocLevelTrigger", "Lorg/opensearch/alerting/model/DocumentLevelTriggerRunResult;", "Lorg/opensearch/commons/alerting/model/DocumentLevelTrigger;", "queryToDocIds", "Lorg/opensearch/commons/alerting/model/DocLevelQuery;", "", "runQueryLevelTrigger", "Lorg/opensearch/commons/alerting/model/QueryLevelTrigger;", "opensearch-alerting"})
public final class TriggerService {
    @NotNull
    private final ScriptService scriptService;
    private final Logger logger;
    @NotNull
    private final Script ALWAYS_RUN;
    @NotNull
    private final Script NEVER_RUN;

    public TriggerService(@NotNull ScriptService scriptService) {
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        this.scriptService = scriptService;
        this.logger = LogManager.getLogger(TriggerService.class);
        this.ALWAYS_RUN = new Script("return true");
        this.NEVER_RUN = new Script("return false");
    }

    @NotNull
    public final ScriptService getScriptService() {
        return this.scriptService;
    }

    public final boolean isQueryLevelTriggerActionable(@NotNull QueryLevelTriggerExecutionContext ctx, @NotNull QueryLevelTriggerRunResult result) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Alert alert = ctx.getAlert();
        boolean suppress = (alert == null ? null : alert.getState()) == Alert.State.ACKNOWLEDGED && result.getError() == null && ctx.getError() == null;
        return result.getTriggered() && !suppress;
    }

    @NotNull
    public final QueryLevelTriggerRunResult runQueryLevelTrigger(@NotNull Monitor monitor, @NotNull QueryLevelTrigger trigger, @NotNull QueryLevelTriggerExecutionContext ctx) {
        QueryLevelTriggerRunResult queryLevelTriggerRunResult;
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        try {
            TriggerScript.Factory factory = (TriggerScript.Factory)this.scriptService.compile(trigger.getCondition(), TriggerScript.Companion.getCONTEXT());
            Map map = trigger.getCondition().getParams();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"trigger.condition.params");
            boolean triggered = factory.newInstance(map).execute(ctx);
            queryLevelTriggerRunResult = new QueryLevelTriggerRunResult(trigger.getName(), triggered, null, null, 8, null);
        }
        catch (Exception e) {
            this.logger.info("Error running script for monitor " + monitor.getId() + ", trigger: " + trigger.getId(), (Throwable)e);
            queryLevelTriggerRunResult = new QueryLevelTriggerRunResult(trigger.getName(), true, e, null, 8, null);
        }
        return queryLevelTriggerRunResult;
    }

    @NotNull
    public final DocumentLevelTriggerRunResult runDocLevelTrigger(@NotNull Monitor monitor, @NotNull DocumentLevelTrigger trigger, @NotNull Map<DocLevelQuery, ? extends Set<String>> queryToDocIds) {
        DocumentLevelTriggerRunResult documentLevelTriggerRunResult;
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter(queryToDocIds, (String)"queryToDocIds");
        try {
            List triggeredDocs = new ArrayList();
            if (trigger.getCondition().getIdOrCode().equals(this.ALWAYS_RUN.getIdOrCode())) {
                for (Set<String> set : queryToDocIds.values()) {
                    triggeredDocs.addAll((Collection)set);
                }
            } else if (!trigger.getCondition().getIdOrCode().equals(this.NEVER_RUN.getIdOrCode())) {
                String string = trigger.getCondition().getIdOrCode();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trigger.condition.idOrCode");
                triggeredDocs = CollectionsKt.toMutableList((Collection)new TriggerExpressionParser(string).parse().evaluate(queryToDocIds));
            }
            documentLevelTriggerRunResult = new DocumentLevelTriggerRunResult(trigger.getName(), triggeredDocs, null, null, 8, null);
        }
        catch (Exception e) {
            this.logger.info("Error running script for monitor " + monitor.getId() + ", trigger: " + trigger.getId(), (Throwable)e);
            documentLevelTriggerRunResult = new DocumentLevelTriggerRunResult(trigger.getName(), CollectionsKt.emptyList(), e, null, 8, null);
        }
        return documentLevelTriggerRunResult;
    }

    @NotNull
    public final BucketLevelTriggerRunResult runBucketLevelTrigger(@NotNull Monitor monitor, @NotNull BucketLevelTrigger trigger, @NotNull BucketLevelTriggerExecutionContext ctx) {
        BucketLevelTriggerRunResult bucketLevelTriggerRunResult;
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        try {
            Object element$iv2;
            Object object = ctx.getResults().get(0).get("aggregations");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<*, *>{ kotlin.collections.TypeAliasesKt.HashMap<*, *> }");
            }
            Object object2 = (HashMap)object;
            Object object3 = trigger.getId();
            Object v = object2.get(object3);
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<*, *>{ kotlin.collections.TypeAliasesKt.HashMap<*, *> }");
            }
            Map map = (HashMap)v;
            object2 = "bucket_indices";
            Object v2 = map.get(object2);
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
            }
            List bucketIndices = (List)v2;
            Object object4 = ctx.getResults().get(0).get("aggregations");
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<*, *>{ kotlin.collections.TypeAliasesKt.HashMap<*, *> }");
            }
            object3 = (HashMap)object4;
            String string = trigger.getId();
            Object v3 = object3.get(string);
            if (v3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<*, *>{ kotlin.collections.TypeAliasesKt.HashMap<*, *> }");
            }
            object2 = (HashMap)v3;
            object3 = "parent_bucket_path";
            Object v4 = object2.get(object3);
            if (v4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String parentBucketPath = (String)v4;
            AggregationPath aggregationPath = AggregationPath.parse((String)parentBucketPath);
            HashMap parentAgg = null;
            Object object5 = ctx.getResults().get(0).get("aggregations");
            if (object5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<*, *>{ kotlin.collections.TypeAliasesKt.HashMap<*, *> }");
            }
            parentAgg = (HashMap)object5;
            object3 = aggregationPath.getPathElementsAsStringList();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"aggregationPath.pathElementsAsStringList");
            Iterable $this$forEach$iv = (Iterable)object3;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                String sub_agg = (String)element$iv2;
                boolean bl = false;
                Object v5 = ((Map)parentAgg).get(sub_agg);
                if (v5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<*, *>{ kotlin.collections.TypeAliasesKt.HashMap<*, *> }");
                }
                parentAgg = (HashMap)v5;
            }
            Iterator iterator = parentAgg;
            element$iv2 = Aggregation.CommonFields.BUCKETS.getPreferredName();
            Object v6 = iterator.get(element$iv2);
            if (v6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
            }
            List buckets = (List)v6;
            Map selectedBuckets = new LinkedHashMap();
            iterator = bucketIndices.iterator();
            while (iterator.hasNext()) {
                Object bucketIndex;
                Object e = bucketIndex = iterator.next();
                if (e == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                Object e2 = buckets.get((Integer)e);
                if (e2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                Map bucketDict = (Map)e2;
                List<String> bucketKeyValuesList = this.getBucketKeyValuesList(bucketDict);
                AggregationResultBucket aggResultBucket = new AggregationResultBucket(parentBucketPath, bucketKeyValuesList, bucketDict);
                Map map2 = selectedBuckets;
                String string2 = AlertingUtilsKt.getBucketKeysHash(aggResultBucket);
                map2.put(string2, aggResultBucket);
            }
            bucketLevelTriggerRunResult = new BucketLevelTriggerRunResult(trigger.getName(), null, selectedBuckets, null, 8, null);
        }
        catch (Exception e) {
            this.logger.info("Error running trigger [" + trigger.getId() + "] for monitor [" + monitor.getId() + "]", (Throwable)e);
            bucketLevelTriggerRunResult = new BucketLevelTriggerRunResult(trigger.getName(), e, MapsKt.emptyMap(), null, 8, null);
        }
        return bucketLevelTriggerRunResult;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getBucketKeyValuesList(Map<String, ? extends Object> bucket) {
        String keyField = Aggregation.CommonFields.KEY.getPreferredName();
        List keyValuesList = new ArrayList();
        if (bucket.get(keyField) instanceof String) {
            Object object = bucket.get(keyField);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            keyValuesList.add((String)object);
        } else if (bucket.get(keyField) instanceof Integer) {
            keyValuesList.add(String.valueOf(bucket.get(keyField)));
        } else if (bucket.get(keyField) instanceof Map) {
            void $this$mapTo$iv$iv;
            Object object = bucket.get(keyField);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            Iterable $this$map$iv = ((Map)object).values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(keyValuesList.add(it.toString()));
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        } else {
            throw new IllegalArgumentException("Unexpected format for key in bucket [" + bucket + "]");
        }
        return keyValuesList;
    }
}

