/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.window.frame;

import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.expression.window.frame.WindowFrame;
import org.opensearch.sql.storage.bindingtuple.BindingTuple;

public class PeerRowsWindowFrame
implements WindowFrame {
    private final WindowDefinition windowDefinition;
    private final List<ExprValue> peers = new ArrayList<ExprValue>();
    private int position;
    private boolean isNewPartition = true;

    @Override
    public boolean hasNext() {
        return this.position < this.peers.size();
    }

    @Override
    public List<ExprValue> next() {
        this.isNewPartition = false;
        if (this.position++ == 0) {
            return this.peers;
        }
        return Collections.emptyList();
    }

    @Override
    public ExprValue current() {
        return this.peers.get(this.position);
    }

    @Override
    public void load(PeekingIterator<ExprValue> it) {
        if (this.hasNext()) {
            return;
        }
        this.isNewPartition = !this.isSamePartition((ExprValue)it.peek());
        this.position = 0;
        this.peers.clear();
        while (it.hasNext()) {
            ExprValue next = (ExprValue)it.peek();
            if (this.peers.isEmpty()) {
                this.peers.add((ExprValue)it.next());
                continue;
            }
            if (!this.isSamePartition(next) || !this.isPeer(next)) break;
            this.peers.add((ExprValue)it.next());
        }
    }

    @Override
    public boolean isNewPartition() {
        return this.isNewPartition;
    }

    private boolean isPeer(ExprValue next) {
        List<Expression> sortFields = this.windowDefinition.getSortList().stream().map(Pair::getRight).collect(Collectors.toList());
        ExprValue last = this.peers.get(this.peers.size() - 1);
        return this.resolve(sortFields, last).equals(this.resolve(sortFields, next));
    }

    private boolean isSamePartition(ExprValue next) {
        if (this.peers.isEmpty()) {
            return false;
        }
        List<Expression> partitionByList = this.windowDefinition.getPartitionByList();
        ExprValue last = this.peers.get(this.peers.size() - 1);
        return this.resolve(partitionByList, last).equals(this.resolve(partitionByList, next));
    }

    private List<ExprValue> resolve(List<Expression> expressions, ExprValue row) {
        BindingTuple valueEnv = row.bindingTuples();
        return expressions.stream().map(expr -> expr.valueOf(valueEnv)).collect(Collectors.toList());
    }

    @Generated
    public PeerRowsWindowFrame(WindowDefinition windowDefinition) {
        this.windowDefinition = windowDefinition;
    }
}

