from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopoDS import *
from OCC.Core.GeomAbs import *
from OCC.Core.Geom import *
from OCC.Core.TopLoc import *
from OCC.Core.Poly import *
from OCC.Core.gp import *
from OCC.Core.Geom2d import *
from OCC.Core.TopAbs import *


class BRep_ListOfCurveRepresentation:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class BRep_ListOfPointRepresentation:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class BRep_Builder(TopoDS_Builder):
    @overload
    def Continuity(self, E: TopoDS_Edge, F1: TopoDS_Face, F2: TopoDS_Face, C: GeomAbs_Shape) -> None: ...
    @overload
    def Continuity(self, E: TopoDS_Edge, S1: Geom_Surface, S2: Geom_Surface, L1: TopLoc_Location, L2: TopLoc_Location, C: GeomAbs_Shape) -> None: ...
    def Degenerated(self, E: TopoDS_Edge, D: bool) -> None: ...
    @overload
    def MakeEdge(self, E: TopoDS_Edge) -> None: ...
    @overload
    def MakeEdge(self, E: TopoDS_Edge, C: Geom_Curve, Tol: float) -> None: ...
    @overload
    def MakeEdge(self, E: TopoDS_Edge, C: Geom_Curve, L: TopLoc_Location, Tol: float) -> None: ...
    @overload
    def MakeEdge(self, E: TopoDS_Edge, P: Poly_Polygon3D) -> None: ...
    @overload
    def MakeEdge(self, E: TopoDS_Edge, N: Poly_PolygonOnTriangulation, T: Poly_Triangulation) -> None: ...
    @overload
    def MakeEdge(self, E: TopoDS_Edge, N: Poly_PolygonOnTriangulation, T: Poly_Triangulation, L: TopLoc_Location) -> None: ...
    @overload
    def MakeFace(self, F: TopoDS_Face) -> None: ...
    @overload
    def MakeFace(self, F: TopoDS_Face, S: Geom_Surface, Tol: float) -> None: ...
    @overload
    def MakeFace(self, F: TopoDS_Face, S: Geom_Surface, L: TopLoc_Location, Tol: float) -> None: ...
    @overload
    def MakeFace(self, theFace: TopoDS_Face, theTriangulation: Poly_Triangulation) -> None: ...
    @overload
    def MakeFace(self, theFace: TopoDS_Face, theTriangulations: Poly_ListOfTriangulation, theActiveTriangulation: Optional[Poly_Triangulation] = Poly_Triangulation()) -> None: ...
    @overload
    def MakeVertex(self, V: TopoDS_Vertex) -> None: ...
    @overload
    def MakeVertex(self, V: TopoDS_Vertex, P: gp_Pnt, Tol: float) -> None: ...
    def NaturalRestriction(self, F: TopoDS_Face, N: bool) -> None: ...
    @overload
    def Range(self, E: TopoDS_Edge, First: float, Last: float, Only3d: Optional[bool] = False) -> None: ...
    @overload
    def Range(self, E: TopoDS_Edge, S: Geom_Surface, L: TopLoc_Location, First: float, Last: float) -> None: ...
    @overload
    def Range(self, E: TopoDS_Edge, F: TopoDS_Face, First: float, Last: float) -> None: ...
    def SameParameter(self, E: TopoDS_Edge, S: bool) -> None: ...
    def SameRange(self, E: TopoDS_Edge, S: bool) -> None: ...
    @overload
    def Transfert(self, Ein: TopoDS_Edge, Eout: TopoDS_Edge) -> None: ...
    @overload
    def Transfert(self, Ein: TopoDS_Edge, Eout: TopoDS_Edge, Vin: TopoDS_Vertex, Vout: TopoDS_Vertex) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, C: Geom_Curve, Tol: float) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, C: Geom_Curve, L: TopLoc_Location, Tol: float) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, C: Geom2d_Curve, F: TopoDS_Face, Tol: float) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, C1: Geom2d_Curve, C2: Geom2d_Curve, F: TopoDS_Face, Tol: float) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, C: Geom2d_Curve, S: Geom_Surface, L: TopLoc_Location, Tol: float) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, C: Geom2d_Curve, S: Geom_Surface, L: TopLoc_Location, Tol: float, Pf: gp_Pnt2d, Pl: gp_Pnt2d) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, C1: Geom2d_Curve, C2: Geom2d_Curve, S: Geom_Surface, L: TopLoc_Location, Tol: float) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, C1: Geom2d_Curve, C2: Geom2d_Curve, S: Geom_Surface, L: TopLoc_Location, Tol: float, Pf: gp_Pnt2d, Pl: gp_Pnt2d) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, P: Poly_Polygon3D) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, P: Poly_Polygon3D, L: TopLoc_Location) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, N: Poly_PolygonOnTriangulation, T: Poly_Triangulation) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, N: Poly_PolygonOnTriangulation, T: Poly_Triangulation, L: TopLoc_Location) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, N1: Poly_PolygonOnTriangulation, N2: Poly_PolygonOnTriangulation, T: Poly_Triangulation) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, N1: Poly_PolygonOnTriangulation, N2: Poly_PolygonOnTriangulation, T: Poly_Triangulation, L: TopLoc_Location) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, P: Poly_Polygon2D, S: TopoDS_Face) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, P: Poly_Polygon2D, S: Geom_Surface, T: TopLoc_Location) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, P1: Poly_Polygon2D, P2: Poly_Polygon2D, S: TopoDS_Face) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, P1: Poly_Polygon2D, P2: Poly_Polygon2D, S: Geom_Surface, L: TopLoc_Location) -> None: ...
    @overload
    def UpdateEdge(self, E: TopoDS_Edge, Tol: float) -> None: ...
    @overload
    def UpdateFace(self, F: TopoDS_Face, S: Geom_Surface, L: TopLoc_Location, Tol: float) -> None: ...
    @overload
    def UpdateFace(self, theFace: TopoDS_Face, theTriangulation: Poly_Triangulation, theToReset: Optional[bool] = true) -> None: ...
    @overload
    def UpdateFace(self, F: TopoDS_Face, Tol: float) -> None: ...
    @overload
    def UpdateVertex(self, V: TopoDS_Vertex, P: gp_Pnt, Tol: float) -> None: ...
    @overload
    def UpdateVertex(self, V: TopoDS_Vertex, P: float, E: TopoDS_Edge, Tol: float) -> None: ...
    @overload
    def UpdateVertex(self, V: TopoDS_Vertex, P: float, E: TopoDS_Edge, F: TopoDS_Face, Tol: float) -> None: ...
    @overload
    def UpdateVertex(self, V: TopoDS_Vertex, P: float, E: TopoDS_Edge, S: Geom_Surface, L: TopLoc_Location, Tol: float) -> None: ...
    @overload
    def UpdateVertex(self, Ve: TopoDS_Vertex, U: float, V: float, F: TopoDS_Face, Tol: float) -> None: ...
    @overload
    def UpdateVertex(self, V: TopoDS_Vertex, Tol: float) -> None: ...

class BRep_CurveRepresentation(Standard_Transient):
    @overload
    def Continuity(self) -> GeomAbs_Shape: ...
    @overload
    def Continuity(self, C: GeomAbs_Shape) -> None: ...
    def Copy(self) -> BRep_CurveRepresentation: ...
    @overload
    def Curve3D(self) -> Geom_Curve: ...
    @overload
    def Curve3D(self, C: Geom_Curve) -> None: ...
    def IsCurve3D(self) -> bool: ...
    def IsCurveOnClosedSurface(self) -> bool: ...
    @overload
    def IsCurveOnSurface(self) -> bool: ...
    @overload
    def IsCurveOnSurface(self, S: Geom_Surface, L: TopLoc_Location) -> bool: ...
    def IsPolygon3D(self) -> bool: ...
    def IsPolygonOnClosedSurface(self) -> bool: ...
    def IsPolygonOnClosedTriangulation(self) -> bool: ...
    @overload
    def IsPolygonOnSurface(self) -> bool: ...
    @overload
    def IsPolygonOnSurface(self, S: Geom_Surface, L: TopLoc_Location) -> bool: ...
    @overload
    def IsPolygonOnTriangulation(self) -> bool: ...
    @overload
    def IsPolygonOnTriangulation(self, T: Poly_Triangulation, L: TopLoc_Location) -> bool: ...
    @overload
    def IsRegularity(self) -> bool: ...
    @overload
    def IsRegularity(self, S1: Geom_Surface, S2: Geom_Surface, L1: TopLoc_Location, L2: TopLoc_Location) -> bool: ...
    @overload
    def Location(self) -> TopLoc_Location: ...
    @overload
    def Location(self, L: TopLoc_Location) -> None: ...
    def Location2(self) -> TopLoc_Location: ...
    @overload
    def PCurve(self) -> Geom2d_Curve: ...
    @overload
    def PCurve(self, C: Geom2d_Curve) -> None: ...
    @overload
    def PCurve2(self) -> Geom2d_Curve: ...
    @overload
    def PCurve2(self, C: Geom2d_Curve) -> None: ...
    @overload
    def Polygon(self) -> Poly_Polygon2D: ...
    @overload
    def Polygon(self, P: Poly_Polygon2D) -> None: ...
    @overload
    def Polygon2(self) -> Poly_Polygon2D: ...
    @overload
    def Polygon2(self, P: Poly_Polygon2D) -> None: ...
    @overload
    def Polygon3D(self) -> Poly_Polygon3D: ...
    @overload
    def Polygon3D(self, P: Poly_Polygon3D) -> None: ...
    @overload
    def PolygonOnTriangulation(self) -> Poly_PolygonOnTriangulation: ...
    @overload
    def PolygonOnTriangulation(self, P: Poly_PolygonOnTriangulation) -> None: ...
    @overload
    def PolygonOnTriangulation2(self) -> Poly_PolygonOnTriangulation: ...
    @overload
    def PolygonOnTriangulation2(self, P2: Poly_PolygonOnTriangulation) -> None: ...
    def Surface(self) -> Geom_Surface: ...
    def Surface2(self) -> Geom_Surface: ...
    def Triangulation(self) -> Poly_Triangulation: ...

class BRep_PointRepresentation(Standard_Transient):
    @overload
    def Curve(self) -> Geom_Curve: ...
    @overload
    def Curve(self, C: Geom_Curve) -> None: ...
    @overload
    def IsPointOnCurve(self) -> bool: ...
    @overload
    def IsPointOnCurve(self, C: Geom_Curve, L: TopLoc_Location) -> bool: ...
    @overload
    def IsPointOnCurveOnSurface(self) -> bool: ...
    @overload
    def IsPointOnCurveOnSurface(self, PC: Geom2d_Curve, S: Geom_Surface, L: TopLoc_Location) -> bool: ...
    @overload
    def IsPointOnSurface(self) -> bool: ...
    @overload
    def IsPointOnSurface(self, S: Geom_Surface, L: TopLoc_Location) -> bool: ...
    @overload
    def Location(self) -> TopLoc_Location: ...
    @overload
    def Location(self, L: TopLoc_Location) -> None: ...
    @overload
    def PCurve(self) -> Geom2d_Curve: ...
    @overload
    def PCurve(self, C: Geom2d_Curve) -> None: ...
    @overload
    def Parameter(self) -> float: ...
    @overload
    def Parameter(self, P: float) -> None: ...
    @overload
    def Parameter2(self) -> float: ...
    @overload
    def Parameter2(self, P: float) -> None: ...
    @overload
    def Surface(self) -> Geom_Surface: ...
    @overload
    def Surface(self, S: Geom_Surface) -> None: ...

class BRep_TEdge(TopoDS_TEdge):
    def __init__(self) -> None: ...
    def ChangeCurves(self) -> BRep_ListOfCurveRepresentation: ...
    def Curves(self) -> BRep_ListOfCurveRepresentation: ...
    @overload
    def Degenerated(self) -> bool: ...
    @overload
    def Degenerated(self, S: bool) -> None: ...
    def EmptyCopy(self) -> TopoDS_TShape: ...
    @overload
    def SameParameter(self) -> bool: ...
    @overload
    def SameParameter(self, S: bool) -> None: ...
    @overload
    def SameRange(self) -> bool: ...
    @overload
    def SameRange(self, S: bool) -> None: ...
    @overload
    def Tolerance(self) -> float: ...
    @overload
    def Tolerance(self, T: float) -> None: ...
    def UpdateTolerance(self, T: float) -> None: ...

class BRep_TFace(TopoDS_TFace):
    def __init__(self) -> None: ...
    def ActiveTriangulation(self) -> Poly_Triangulation: ...
    def EmptyCopy(self) -> TopoDS_TShape: ...
    @overload
    def Location(self) -> TopLoc_Location: ...
    @overload
    def Location(self, theLocation: TopLoc_Location) -> None: ...
    @overload
    def NaturalRestriction(self) -> bool: ...
    @overload
    def NaturalRestriction(self, theRestriction: bool) -> None: ...
    def NbTriangulations(self) -> int: ...
    @overload
    def Surface(self) -> Geom_Surface: ...
    @overload
    def Surface(self, theSurface: Geom_Surface) -> None: ...
    @overload
    def Tolerance(self) -> float: ...
    @overload
    def Tolerance(self, theTolerance: float) -> None: ...
    @overload
    def Triangulation(self, thePurpose: Optional[Poly_MeshPurpose] = Poly_MeshPurpose_NONE) -> Poly_Triangulation: ...
    @overload
    def Triangulation(self, theTriangulation: Poly_Triangulation, theToReset: Optional[bool] = true) -> None: ...
    @overload
    def Triangulations(self) -> Poly_ListOfTriangulation: ...
    @overload
    def Triangulations(self, theTriangulations: Poly_ListOfTriangulation, theActiveTriangulation: Poly_Triangulation) -> None: ...

class BRep_TVertex(TopoDS_TVertex):
    def __init__(self) -> None: ...
    def ChangePoints(self) -> BRep_ListOfPointRepresentation: ...
    def EmptyCopy(self) -> TopoDS_TShape: ...
    @overload
    def Pnt(self) -> gp_Pnt: ...
    @overload
    def Pnt(self, P: gp_Pnt) -> None: ...
    def Points(self) -> BRep_ListOfPointRepresentation: ...
    @overload
    def Tolerance(self) -> float: ...
    @overload
    def Tolerance(self, T: float) -> None: ...
    def UpdateTolerance(self, T: float) -> None: ...

class BRep_Tool:
    @overload
    @staticmethod
    def Continuity(E: TopoDS_Edge, F1: TopoDS_Face, F2: TopoDS_Face) -> GeomAbs_Shape: ...
    @overload
    @staticmethod
    def Continuity(E: TopoDS_Edge, S1: Geom_Surface, S2: Geom_Surface, L1: TopLoc_Location, L2: TopLoc_Location) -> GeomAbs_Shape: ...
    @overload
    @staticmethod
    def Curve(E: TopoDS_Edge, L: TopLoc_Location) -> Tuple[Geom_Curve, float, float]: ...
    @overload
    @staticmethod
    def Curve(E: TopoDS_Edge) -> Tuple[Geom_Curve, float, float]: ...
    @staticmethod
    def CurveOnPlane(E: TopoDS_Edge, S: Geom_Surface, L: TopLoc_Location) -> Tuple[Geom2d_Curve, float, float]: ...
    @overload
    @staticmethod
    def CurveOnSurface(E: TopoDS_Edge, F: TopoDS_Face, theIsStored: Optional[bool] = None) -> Tuple[Geom2d_Curve, float, float]: ...
    @overload
    @staticmethod
    def CurveOnSurface(E: TopoDS_Edge, S: Geom_Surface, L: TopLoc_Location, theIsStored: Optional[bool] = None) -> Tuple[Geom2d_Curve, float, float]: ...
    @overload
    @staticmethod
    def CurveOnSurface(E: TopoDS_Edge, C: Geom2d_Curve, S: Geom_Surface, L: TopLoc_Location) -> Tuple[float, float]: ...
    @overload
    @staticmethod
    def CurveOnSurface(E: TopoDS_Edge, C: Geom2d_Curve, S: Geom_Surface, L: TopLoc_Location, Index: int) -> Tuple[float, float]: ...
    @staticmethod
    def Degenerated(E: TopoDS_Edge) -> bool: ...
    @overload
    @staticmethod
    def HasContinuity(E: TopoDS_Edge, F1: TopoDS_Face, F2: TopoDS_Face) -> bool: ...
    @overload
    @staticmethod
    def HasContinuity(E: TopoDS_Edge, S1: Geom_Surface, S2: Geom_Surface, L1: TopLoc_Location, L2: TopLoc_Location) -> bool: ...
    @overload
    @staticmethod
    def HasContinuity(E: TopoDS_Edge) -> bool: ...
    @overload
    @staticmethod
    def IsClosed(S: TopoDS_Shape) -> bool: ...
    @overload
    @staticmethod
    def IsClosed(E: TopoDS_Edge, F: TopoDS_Face) -> bool: ...
    @overload
    @staticmethod
    def IsClosed(E: TopoDS_Edge, S: Geom_Surface, L: TopLoc_Location) -> bool: ...
    @overload
    @staticmethod
    def IsClosed(E: TopoDS_Edge, T: Poly_Triangulation, L: TopLoc_Location) -> bool: ...
    @overload
    @staticmethod
    def IsGeometric(F: TopoDS_Face) -> bool: ...
    @overload
    @staticmethod
    def IsGeometric(E: TopoDS_Edge) -> bool: ...
    @staticmethod
    def MaxContinuity(theEdge: TopoDS_Edge) -> GeomAbs_Shape: ...
    @staticmethod
    def MaxTolerance(theShape: TopoDS_Shape, theSubShape: TopAbs_ShapeEnum) -> float: ...
    @staticmethod
    def NaturalRestriction(F: TopoDS_Face) -> bool: ...
    @overload
    @staticmethod
    def Parameter(theV: TopoDS_Vertex, theE: TopoDS_Edge) -> Tuple[bool, float]: ...
    @overload
    @staticmethod
    def Parameter(V: TopoDS_Vertex, E: TopoDS_Edge) -> float: ...
    @overload
    @staticmethod
    def Parameter(V: TopoDS_Vertex, E: TopoDS_Edge, F: TopoDS_Face) -> float: ...
    @overload
    @staticmethod
    def Parameter(V: TopoDS_Vertex, E: TopoDS_Edge, S: Geom_Surface, L: TopLoc_Location) -> float: ...
    @staticmethod
    def Parameters(V: TopoDS_Vertex, F: TopoDS_Face) -> gp_Pnt2d: ...
    @staticmethod
    def Pnt(V: TopoDS_Vertex) -> gp_Pnt: ...
    @staticmethod
    def Polygon3D(E: TopoDS_Edge, L: TopLoc_Location) -> Poly_Polygon3D: ...
    @overload
    @staticmethod
    def PolygonOnSurface(E: TopoDS_Edge, F: TopoDS_Face) -> Poly_Polygon2D: ...
    @overload
    @staticmethod
    def PolygonOnSurface(E: TopoDS_Edge, S: Geom_Surface, L: TopLoc_Location) -> Poly_Polygon2D: ...
    @overload
    @staticmethod
    def PolygonOnSurface(E: TopoDS_Edge, C: Poly_Polygon2D, S: Geom_Surface, L: TopLoc_Location) -> None: ...
    @overload
    @staticmethod
    def PolygonOnSurface(E: TopoDS_Edge, C: Poly_Polygon2D, S: Geom_Surface, L: TopLoc_Location, Index: int) -> None: ...
    @overload
    @staticmethod
    def PolygonOnTriangulation(E: TopoDS_Edge, T: Poly_Triangulation, L: TopLoc_Location) -> Poly_PolygonOnTriangulation: ...
    @overload
    @staticmethod
    def PolygonOnTriangulation(E: TopoDS_Edge, P: Poly_PolygonOnTriangulation, T: Poly_Triangulation, L: TopLoc_Location) -> None: ...
    @overload
    @staticmethod
    def PolygonOnTriangulation(E: TopoDS_Edge, P: Poly_PolygonOnTriangulation, T: Poly_Triangulation, L: TopLoc_Location, Index: int) -> None: ...
    @overload
    @staticmethod
    def Range(E: TopoDS_Edge) -> Tuple[float, float]: ...
    @overload
    @staticmethod
    def Range(E: TopoDS_Edge, S: Geom_Surface, L: TopLoc_Location) -> Tuple[float, float]: ...
    @overload
    @staticmethod
    def Range(E: TopoDS_Edge, F: TopoDS_Face) -> Tuple[float, float]: ...
    @staticmethod
    def SameParameter(E: TopoDS_Edge) -> bool: ...
    @staticmethod
    def SameRange(E: TopoDS_Edge) -> bool: ...
    @overload
    @staticmethod
    def SetUVPoints(E: TopoDS_Edge, S: Geom_Surface, L: TopLoc_Location, PFirst: gp_Pnt2d, PLast: gp_Pnt2d) -> None: ...
    @overload
    @staticmethod
    def SetUVPoints(E: TopoDS_Edge, F: TopoDS_Face, PFirst: gp_Pnt2d, PLast: gp_Pnt2d) -> None: ...
    @overload
    @staticmethod
    def Surface(F: TopoDS_Face, L: TopLoc_Location) -> Geom_Surface: ...
    @overload
    @staticmethod
    def Surface(F: TopoDS_Face) -> Geom_Surface: ...
    @overload
    @staticmethod
    def Tolerance(F: TopoDS_Face) -> float: ...
    @overload
    @staticmethod
    def Tolerance(E: TopoDS_Edge) -> float: ...
    @overload
    @staticmethod
    def Tolerance(V: TopoDS_Vertex) -> float: ...
    @staticmethod
    def Triangulation(theFace: TopoDS_Face, theLocation: TopLoc_Location, theMeshPurpose: Optional[Poly_MeshPurpose] = Poly_MeshPurpose_NONE) -> Poly_Triangulation: ...
    @staticmethod
    def Triangulations(theFace: TopoDS_Face, theLocation: TopLoc_Location) -> Poly_ListOfTriangulation: ...
    @overload
    @staticmethod
    def UVPoints(E: TopoDS_Edge, S: Geom_Surface, L: TopLoc_Location, PFirst: gp_Pnt2d, PLast: gp_Pnt2d) -> None: ...
    @overload
    @staticmethod
    def UVPoints(E: TopoDS_Edge, F: TopoDS_Face, PFirst: gp_Pnt2d, PLast: gp_Pnt2d) -> None: ...

class BRep_CurveOn2Surfaces(BRep_CurveRepresentation):
    def __init__(self, S1: Geom_Surface, S2: Geom_Surface, L1: TopLoc_Location, L2: TopLoc_Location, C: GeomAbs_Shape) -> None: ...
    @overload
    def Continuity(self) -> GeomAbs_Shape: ...
    @overload
    def Continuity(self, C: GeomAbs_Shape) -> None: ...
    def Copy(self) -> BRep_CurveRepresentation: ...
    def D0(self, U: float, P: gp_Pnt) -> None: ...
    @overload
    def IsRegularity(self) -> bool: ...
    @overload
    def IsRegularity(self, S1: Geom_Surface, S2: Geom_Surface, L1: TopLoc_Location, L2: TopLoc_Location) -> bool: ...
    def Location2(self) -> TopLoc_Location: ...
    def Surface(self) -> Geom_Surface: ...
    def Surface2(self) -> Geom_Surface: ...

class BRep_GCurve(BRep_CurveRepresentation):
    def D0(self, U: float, P: gp_Pnt) -> None: ...
    @overload
    def First(self) -> float: ...
    @overload
    def First(self, F: float) -> None: ...
    @overload
    def Last(self) -> float: ...
    @overload
    def Last(self, L: float) -> None: ...
    def Range(self) -> Tuple[float, float]: ...
    def SetRange(self, First: float, Last: float) -> None: ...
    def Update(self) -> None: ...

class BRep_PointOnCurve(BRep_PointRepresentation):
    def __init__(self, P: float, C: Geom_Curve, L: TopLoc_Location) -> None: ...
    @overload
    def Curve(self) -> Geom_Curve: ...
    @overload
    def Curve(self, C: Geom_Curve) -> None: ...
    @overload
    def IsPointOnCurve(self) -> bool: ...
    @overload
    def IsPointOnCurve(self, C: Geom_Curve, L: TopLoc_Location) -> bool: ...

class BRep_PointsOnSurface(BRep_PointRepresentation):
    @overload
    def Surface(self) -> Geom_Surface: ...
    @overload
    def Surface(self, S: Geom_Surface) -> None: ...

class BRep_Polygon3D(BRep_CurveRepresentation):
    def __init__(self, P: Poly_Polygon3D, L: TopLoc_Location) -> None: ...
    def Copy(self) -> BRep_CurveRepresentation: ...
    def IsPolygon3D(self) -> bool: ...
    @overload
    def Polygon3D(self) -> Poly_Polygon3D: ...
    @overload
    def Polygon3D(self, P: Poly_Polygon3D) -> None: ...

class BRep_PolygonOnSurface(BRep_CurveRepresentation):
    def __init__(self, P: Poly_Polygon2D, S: Geom_Surface, L: TopLoc_Location) -> None: ...
    def Copy(self) -> BRep_CurveRepresentation: ...
    @overload
    def IsPolygonOnSurface(self) -> bool: ...
    @overload
    def IsPolygonOnSurface(self, S: Geom_Surface, L: TopLoc_Location) -> bool: ...
    @overload
    def Polygon(self) -> Poly_Polygon2D: ...
    @overload
    def Polygon(self, P: Poly_Polygon2D) -> None: ...
    def Surface(self) -> Geom_Surface: ...

class BRep_PolygonOnTriangulation(BRep_CurveRepresentation):
    def __init__(self, P: Poly_PolygonOnTriangulation, T: Poly_Triangulation, L: TopLoc_Location) -> None: ...
    def Copy(self) -> BRep_CurveRepresentation: ...
    @overload
    def IsPolygonOnTriangulation(self) -> bool: ...
    @overload
    def IsPolygonOnTriangulation(self, T: Poly_Triangulation, L: TopLoc_Location) -> bool: ...
    @overload
    def PolygonOnTriangulation(self, P: Poly_PolygonOnTriangulation) -> None: ...
    @overload
    def PolygonOnTriangulation(self) -> Poly_PolygonOnTriangulation: ...
    def Triangulation(self) -> Poly_Triangulation: ...

class BRep_Curve3D(BRep_GCurve):
    def __init__(self, C: Geom_Curve, L: TopLoc_Location) -> None: ...
    def Copy(self) -> BRep_CurveRepresentation: ...
    @overload
    def Curve3D(self) -> Geom_Curve: ...
    @overload
    def Curve3D(self, C: Geom_Curve) -> None: ...
    def D0(self, U: float, P: gp_Pnt) -> None: ...
    def IsCurve3D(self) -> bool: ...

class BRep_CurveOnSurface(BRep_GCurve):
    def __init__(self, PC: Geom2d_Curve, S: Geom_Surface, L: TopLoc_Location) -> None: ...
    def Copy(self) -> BRep_CurveRepresentation: ...
    def D0(self, U: float, P: gp_Pnt) -> None: ...
    @overload
    def IsCurveOnSurface(self) -> bool: ...
    @overload
    def IsCurveOnSurface(self, S: Geom_Surface, L: TopLoc_Location) -> bool: ...
    @overload
    def PCurve(self) -> Geom2d_Curve: ...
    @overload
    def PCurve(self, C: Geom2d_Curve) -> None: ...
    def SetUVPoints(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> None: ...
    def Surface(self) -> Geom_Surface: ...
    def UVPoints(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> None: ...
    def Update(self) -> None: ...

class BRep_PointOnCurveOnSurface(BRep_PointsOnSurface):
    def __init__(self, P: float, C: Geom2d_Curve, S: Geom_Surface, L: TopLoc_Location) -> None: ...
    @overload
    def IsPointOnCurveOnSurface(self) -> bool: ...
    @overload
    def IsPointOnCurveOnSurface(self, PC: Geom2d_Curve, S: Geom_Surface, L: TopLoc_Location) -> bool: ...
    @overload
    def PCurve(self) -> Geom2d_Curve: ...
    @overload
    def PCurve(self, C: Geom2d_Curve) -> None: ...

class BRep_PointOnSurface(BRep_PointsOnSurface):
    def __init__(self, P1: float, P2: float, S: Geom_Surface, L: TopLoc_Location) -> None: ...
    @overload
    def IsPointOnSurface(self) -> bool: ...
    @overload
    def IsPointOnSurface(self, S: Geom_Surface, L: TopLoc_Location) -> bool: ...
    @overload
    def Parameter2(self) -> float: ...
    @overload
    def Parameter2(self, P: float) -> None: ...

class BRep_PolygonOnClosedSurface(BRep_PolygonOnSurface):
    def __init__(self, P1: Poly_Polygon2D, P2: Poly_Polygon2D, S: Geom_Surface, L: TopLoc_Location) -> None: ...
    def Copy(self) -> BRep_CurveRepresentation: ...
    def IsPolygonOnClosedSurface(self) -> bool: ...
    @overload
    def Polygon2(self) -> Poly_Polygon2D: ...
    @overload
    def Polygon2(self, P: Poly_Polygon2D) -> None: ...

class BRep_PolygonOnClosedTriangulation(BRep_PolygonOnTriangulation):
    def __init__(self, P1: Poly_PolygonOnTriangulation, P2: Poly_PolygonOnTriangulation, Tr: Poly_Triangulation, L: TopLoc_Location) -> None: ...
    def Copy(self) -> BRep_CurveRepresentation: ...
    def IsPolygonOnClosedTriangulation(self) -> bool: ...
    @overload
    def PolygonOnTriangulation2(self, P2: Poly_PolygonOnTriangulation) -> None: ...
    @overload
    def PolygonOnTriangulation2(self) -> Poly_PolygonOnTriangulation: ...

class BRep_CurveOnClosedSurface(BRep_CurveOnSurface):
    def __init__(self, PC1: Geom2d_Curve, PC2: Geom2d_Curve, S: Geom_Surface, L: TopLoc_Location, C: GeomAbs_Shape) -> None: ...
    @overload
    def Continuity(self) -> GeomAbs_Shape: ...
    @overload
    def Continuity(self, C: GeomAbs_Shape) -> None: ...
    def Copy(self) -> BRep_CurveRepresentation: ...
    def IsCurveOnClosedSurface(self) -> bool: ...
    @overload
    def IsRegularity(self) -> bool: ...
    @overload
    def IsRegularity(self, S1: Geom_Surface, S2: Geom_Surface, L1: TopLoc_Location, L2: TopLoc_Location) -> bool: ...
    def Location2(self) -> TopLoc_Location: ...
    @overload
    def PCurve2(self) -> Geom2d_Curve: ...
    @overload
    def PCurve2(self, C: Geom2d_Curve) -> None: ...
    def SetUVPoints2(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> None: ...
    def Surface2(self) -> Geom_Surface: ...
    def UVPoints2(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> None: ...
    def Update(self) -> None: ...

# harray1 classes
# harray2 classes
# hsequence classes

BRep_Tool_Continuity = BRep_Tool.Continuity
BRep_Tool_Continuity = BRep_Tool.Continuity
BRep_Tool_Curve = BRep_Tool.Curve
BRep_Tool_Curve = BRep_Tool.Curve
BRep_Tool_CurveOnPlane = BRep_Tool.CurveOnPlane
BRep_Tool_CurveOnSurface = BRep_Tool.CurveOnSurface
BRep_Tool_CurveOnSurface = BRep_Tool.CurveOnSurface
BRep_Tool_CurveOnSurface = BRep_Tool.CurveOnSurface
BRep_Tool_CurveOnSurface = BRep_Tool.CurveOnSurface
BRep_Tool_Degenerated = BRep_Tool.Degenerated
BRep_Tool_HasContinuity = BRep_Tool.HasContinuity
BRep_Tool_HasContinuity = BRep_Tool.HasContinuity
BRep_Tool_HasContinuity = BRep_Tool.HasContinuity
BRep_Tool_IsClosed = BRep_Tool.IsClosed
BRep_Tool_IsClosed = BRep_Tool.IsClosed
BRep_Tool_IsClosed = BRep_Tool.IsClosed
BRep_Tool_IsClosed = BRep_Tool.IsClosed
BRep_Tool_IsGeometric = BRep_Tool.IsGeometric
BRep_Tool_IsGeometric = BRep_Tool.IsGeometric
BRep_Tool_MaxContinuity = BRep_Tool.MaxContinuity
BRep_Tool_MaxTolerance = BRep_Tool.MaxTolerance
BRep_Tool_NaturalRestriction = BRep_Tool.NaturalRestriction
BRep_Tool_Parameter = BRep_Tool.Parameter
BRep_Tool_Parameter = BRep_Tool.Parameter
BRep_Tool_Parameter = BRep_Tool.Parameter
BRep_Tool_Parameter = BRep_Tool.Parameter
BRep_Tool_Parameters = BRep_Tool.Parameters
BRep_Tool_Pnt = BRep_Tool.Pnt
BRep_Tool_Polygon3D = BRep_Tool.Polygon3D
BRep_Tool_PolygonOnSurface = BRep_Tool.PolygonOnSurface
BRep_Tool_PolygonOnSurface = BRep_Tool.PolygonOnSurface
BRep_Tool_PolygonOnSurface = BRep_Tool.PolygonOnSurface
BRep_Tool_PolygonOnSurface = BRep_Tool.PolygonOnSurface
BRep_Tool_PolygonOnTriangulation = BRep_Tool.PolygonOnTriangulation
BRep_Tool_PolygonOnTriangulation = BRep_Tool.PolygonOnTriangulation
BRep_Tool_PolygonOnTriangulation = BRep_Tool.PolygonOnTriangulation
BRep_Tool_Range = BRep_Tool.Range
BRep_Tool_Range = BRep_Tool.Range
BRep_Tool_Range = BRep_Tool.Range
BRep_Tool_SameParameter = BRep_Tool.SameParameter
BRep_Tool_SameRange = BRep_Tool.SameRange
BRep_Tool_SetUVPoints = BRep_Tool.SetUVPoints
BRep_Tool_SetUVPoints = BRep_Tool.SetUVPoints
BRep_Tool_Surface = BRep_Tool.Surface
BRep_Tool_Surface = BRep_Tool.Surface
BRep_Tool_Tolerance = BRep_Tool.Tolerance
BRep_Tool_Tolerance = BRep_Tool.Tolerance
BRep_Tool_Tolerance = BRep_Tool.Tolerance
BRep_Tool_Triangulation = BRep_Tool.Triangulation
BRep_Tool_Triangulations = BRep_Tool.Triangulations
BRep_Tool_UVPoints = BRep_Tool.UVPoints
BRep_Tool_UVPoints = BRep_Tool.UVPoints
