/* baobab-ringschart.c generated by valac 0.56.3, the Vala compiler
 * generated from baobab-ringschart.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2008  Igalia
 * Copyright (C) 2013  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *
 * Authors of the original code:
 *   Felipe Erias <femorandeira@igalia.com>
 *   Pablo Santamaria <psantamaria@igalia.com>
 *   Jacobo Aragunde <jaragunde@igalia.com>
 *   Eduardo Lima <elima@igalia.com>
 *   Mario Sanchez <msanchez@igalia.com>
 *   Miguel Gomez <magomez@igalia.com>
 *   Henrique Ferreiro <hferreiro@igalia.com>
 *   Alejandro Pinheiro <apinheiro@igalia.com>
 *   Carlos Sanmartin <csanmartin@igalia.com>
 *   Alejandro Garcia <alex@igalia.com>
 */

#include "baobab.h"
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <pango/pango.h>
#include <stdlib.h>

#define BAOBAB_RINGSCHART_ITEM_BORDER_WIDTH 1
#define BAOBAB_RINGSCHART_ITEM_MIN_ANGLE 0.03
#define BAOBAB_RINGSCHART_EDGE_ANGLE 0.004
#define BAOBAB_RINGSCHART_SUBTIP_TIMEOUT 1000

#define BAOBAB_TYPE_RINGSCHART_ITEM (baobab_ringschart_item_get_type ())
#define BAOBAB_RINGSCHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItem))
#define BAOBAB_RINGSCHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItemClass))
#define BAOBAB_IS_RINGSCHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_RINGSCHART_ITEM))
#define BAOBAB_IS_RINGSCHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_RINGSCHART_ITEM))
#define BAOBAB_RINGSCHART_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItemClass))

typedef struct _BaobabRingschartItem BaobabRingschartItem;
typedef struct _BaobabRingschartItemClass BaobabRingschartItemClass;
typedef struct _BaobabRingschartItemPrivate BaobabRingschartItemPrivate;
enum  {
	BAOBAB_RINGSCHART_0_PROPERTY,
	BAOBAB_RINGSCHART_NUM_PROPERTIES
};
static GParamSpec* baobab_ringschart_properties[BAOBAB_RINGSCHART_NUM_PROPERTIES];
#define _baobab_chart_item_unref0(var) ((var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BaobabRingschartItem {
	BaobabChartItem parent_instance;
	BaobabRingschartItemPrivate * priv;
	gdouble min_radius;
	gdouble max_radius;
	gdouble start_angle;
	gdouble angle;
	gboolean continued;
};

struct _BaobabRingschartItemClass {
	BaobabChartItemClass parent_class;
};

struct _BaobabRingschartPrivate {
	guint tips_timeout_id;
	gboolean drawing_subtips;
	GList* subtip_items;
};

static gpointer baobab_ringschart_item_parent_class = NULL;
static gint BaobabRingschart_private_offset;
static gpointer baobab_ringschart_parent_class = NULL;

VALA_EXTERN GType baobab_ringschart_item_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BaobabRingschartItem* baobab_ringschart_item_new (void);
VALA_EXTERN BaobabRingschartItem* baobab_ringschart_item_construct (GType object_type);
static void baobab_ringschart_item_finalize (BaobabChartItem * obj);
static GType baobab_ringschart_item_get_type_once (void);
static void _baobab_chart_item_unref0_ (gpointer var);
static inline void _g_list_free__baobab_chart_item_unref0_ (GList* self);
static void baobab_ringschart_subtips_update (BaobabRingschart* self);
static gboolean ___lambda30_ (BaobabRingschart* self);
static gboolean ____lambda30__gsource_func (gpointer self);
static BaobabChartItem* baobab_ringschart_real_create_new_chartitem (BaobabChart* base);
static void baobab_ringschart_real_post_draw (BaobabChart* base,
                                       cairo_t* cr);
static void baobab_ringschart_real_draw_item (BaobabChart* base,
                                       cairo_t* cr,
                                       BaobabChartItem* item,
                                       gboolean highlighted);
static void baobab_ringschart_real_calculate_item_geometry (BaobabChart* base,
                                                     BaobabChartItem* item);
static void baobab_ringschart_get_point_min_rect (BaobabRingschart* self,
                                           gdouble cx,
                                           gdouble cy,
                                           gdouble radius,
                                           gdouble angle,
                                           GdkRectangle* r);
static void baobab_ringschart_real_get_item_rectangle (BaobabChart* base,
                                                BaobabChartItem* item);
static gboolean baobab_ringschart_real_is_point_over_item (BaobabChart* base,
                                                    BaobabChartItem* item,
                                                    gdouble x,
                                                    gdouble y);
static gboolean baobab_ringschart_real_can_zoom_out (BaobabChart* base);
static gboolean baobab_ringschart_real_can_zoom_in (BaobabChart* base);
static GObject * baobab_ringschart_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _baobab_ringschart_subtips_update_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void baobab_ringschart_finalize (GObject * obj);
static GType baobab_ringschart_get_type_once (void);

BaobabRingschartItem*
baobab_ringschart_item_construct (GType object_type)
{
	BaobabRingschartItem* self = NULL;
	self = (BaobabRingschartItem*) baobab_chart_item_construct (object_type);
	return self;
}

BaobabRingschartItem*
baobab_ringschart_item_new (void)
{
	return baobab_ringschart_item_construct (BAOBAB_TYPE_RINGSCHART_ITEM);
}

static void
baobab_ringschart_item_class_init (BaobabRingschartItemClass * klass,
                                   gpointer klass_data)
{
	baobab_ringschart_item_parent_class = g_type_class_peek_parent (klass);
	((BaobabChartItemClass *) klass)->finalize = baobab_ringschart_item_finalize;
}

static void
baobab_ringschart_item_instance_init (BaobabRingschartItem * self,
                                      gpointer klass)
{
}

static void
baobab_ringschart_item_finalize (BaobabChartItem * obj)
{
	BaobabRingschartItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItem);
	BAOBAB_CHART_ITEM_CLASS (baobab_ringschart_item_parent_class)->finalize (obj);
}

static GType
baobab_ringschart_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabRingschartItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_ringschart_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabRingschartItem), 0, (GInstanceInitFunc) baobab_ringschart_item_instance_init, NULL };
	GType baobab_ringschart_item_type_id;
	baobab_ringschart_item_type_id = g_type_register_static (BAOBAB_TYPE_CHART_ITEM, "BaobabRingschartItem", &g_define_type_info, 0);
	return baobab_ringschart_item_type_id;
}

GType
baobab_ringschart_item_get_type (void)
{
	static volatile gsize baobab_ringschart_item_type_id__once = 0;
	if (g_once_init_enter (&baobab_ringschart_item_type_id__once)) {
		GType baobab_ringschart_item_type_id;
		baobab_ringschart_item_type_id = baobab_ringschart_item_get_type_once ();
		g_once_init_leave (&baobab_ringschart_item_type_id__once, baobab_ringschart_item_type_id);
	}
	return baobab_ringschart_item_type_id__once;
}

static inline gpointer
baobab_ringschart_get_instance_private (BaobabRingschart* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabRingschart_private_offset);
}

static void
_baobab_chart_item_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL));
}

static inline void
_g_list_free__baobab_chart_item_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _baobab_chart_item_unref0_);
}

static gboolean
___lambda30_ (BaobabRingschart* self)
{
	gboolean result;
	self->priv->drawing_subtips = TRUE;
	self->priv->tips_timeout_id = (guint) 0;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
____lambda30__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda30_ ((BaobabRingschart*) self);
	return result;
}

static void
baobab_ringschart_subtips_update (BaobabRingschart* self)
{
	BaobabChartItem* _tmp0_;
	BaobabChartItem* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->drawing_subtips) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	self->priv->drawing_subtips = FALSE;
	if (self->priv->tips_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->tips_timeout_id);
		self->priv->tips_timeout_id = (guint) 0;
	}
	(self->priv->subtip_items == NULL) ? NULL : (self->priv->subtip_items = (_g_list_free__baobab_chart_item_unref0_ (self->priv->subtip_items), NULL));
	self->priv->subtip_items = NULL;
	_tmp0_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		self->priv->tips_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BAOBAB_RINGSCHART_SUBTIP_TIMEOUT, ____lambda30__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static BaobabChartItem*
baobab_ringschart_real_create_new_chartitem (BaobabChart* base)
{
	BaobabRingschart * self;
	BaobabRingschartItem* _tmp0_;
	BaobabChartItem* _tmp1_;
	BaobabChartItem* result;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_ringschart_item_new ();
	_tmp1_ = BAOBAB_IS_CHART_ITEM (_tmp0_) ? ((BaobabChartItem*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_baobab_chart_item_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_baobab_chart_item_ref0 (gpointer self)
{
	return self ? baobab_chart_item_ref (self) : NULL;
}

static void
baobab_ringschart_real_post_draw (BaobabChart* base,
                                  cairo_t* cr)
{
	BaobabRingschart * self;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp4_ = {0};
	gint q_width = 0;
	GtkAllocation _tmp5_;
	gint q_height = 0;
	GtkAllocation _tmp6_;
	gdouble q_angle = 0.0;
	GdkRectangle last_rect = {0};
	GtkBorder padding = {0};
	GtkStyleContext* _tmp7_;
	GtkBorder _tmp8_ = {0};
	gint16 vpadding = 0;
	GtkBorder _tmp9_;
	GtkBorder _tmp10_;
	gint16 hpadding = 0;
	GtkBorder _tmp11_;
	GtkBorder _tmp12_;
	GList* _tmp13_;
	GtkStyleContext* _tmp92_;
	self = (BaobabRingschart*) base;
	g_return_if_fail (cr != NULL);
	if (!self->priv->drawing_subtips) {
		return;
	}
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = context;
	gtk_style_context_save (_tmp2_);
	_tmp3_ = context;
	gtk_style_context_add_class (_tmp3_, "subfolder-tip");
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp4_);
	allocation = _tmp4_;
	_tmp5_ = allocation;
	q_width = _tmp5_.width / 2;
	_tmp6_ = allocation;
	q_height = _tmp6_.height / 2;
	q_angle = atan2 ((gdouble) q_height, (gdouble) q_width);
	memset (&last_rect, 0, sizeof (GdkRectangle));
	_tmp7_ = context;
	gtk_style_context_get_padding (_tmp7_, &_tmp8_);
	padding = _tmp8_;
	_tmp9_ = padding;
	_tmp10_ = padding;
	vpadding = _tmp9_.top + _tmp10_.bottom;
	_tmp11_ = padding;
	_tmp12_ = padding;
	hpadding = _tmp11_.left + _tmp12_.right;
	_tmp13_ = self->priv->subtip_items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp13_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			BaobabChartItem* _tmp14_;
			BaobabChartItem* item = NULL;
			_tmp14_ = _baobab_chart_item_ref0 ((BaobabChartItem*) item_it->data);
			item = _tmp14_;
			{
				BaobabRingschartItem* ringsitem = NULL;
				BaobabChartItem* _tmp15_;
				BaobabRingschartItem* _tmp16_;
				gdouble middle_angle = 0.0;
				BaobabRingschartItem* _tmp17_;
				BaobabRingschartItem* _tmp18_;
				gdouble middle_angle_n = 0.0;
				PangoLayout* layout = NULL;
				PangoLayout* _tmp19_;
				gchar* markup = NULL;
				BaobabChartItem* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				PangoLayout* _tmp28_;
				const gchar* _tmp29_;
				PangoLayout* _tmp30_;
				PangoLayout* _tmp31_;
				PangoLayout* _tmp32_;
				PangoLayout* _tmp33_;
				PangoRectangle layout_rect = {0};
				PangoLayout* _tmp34_;
				PangoRectangle _tmp35_ = {0};
				gdouble tip_x = 0.0;
				gdouble tip_y = 0.0;
				cairo_rectangle_t tooltip_rect = {0};
				PangoRectangle _tmp38_;
				GtkBorder _tmp39_;
				PangoRectangle _tmp40_;
				GtkBorder _tmp41_;
				PangoRectangle _tmp42_;
				PangoRectangle _tmp43_;
				gdouble a = 0.0;
				gint i = 0;
				GdkRectangle _rect = {0};
				cairo_rectangle_t _tmp51_;
				cairo_rectangle_t _tmp52_;
				cairo_rectangle_t _tmp53_;
				cairo_rectangle_t _tmp54_;
				GdkRectangle _tmp55_;
				_tmp15_ = item;
				_tmp16_ = _baobab_chart_item_ref0 (BAOBAB_IS_RINGSCHART_ITEM (_tmp15_) ? ((BaobabRingschartItem*) _tmp15_) : NULL);
				ringsitem = _tmp16_;
				_tmp17_ = ringsitem;
				_tmp18_ = ringsitem;
				middle_angle = _tmp17_->start_angle + (_tmp18_->angle / 2);
				middle_angle_n = middle_angle;
				while (TRUE) {
					if (!(middle_angle_n > (G_PI / 2))) {
						break;
					}
					middle_angle_n -= G_PI;
				}
				middle_angle_n = fabs (middle_angle_n);
				_tmp19_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
				layout = _tmp19_;
				_tmp20_ = item;
				_tmp21_ = _tmp20_->name;
				_tmp22_ = g_markup_escape_text (_tmp21_, (gssize) -1);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat ("<span size=\"small\">", _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strconcat (_tmp25_, "</span>", NULL);
				_tmp27_ = _tmp26_;
				_g_free0 (_tmp25_);
				_g_free0 (_tmp23_);
				markup = _tmp27_;
				_tmp28_ = layout;
				_tmp29_ = markup;
				pango_layout_set_markup (_tmp28_, _tmp29_, -1);
				_tmp30_ = layout;
				pango_layout_set_indent (_tmp30_, 0);
				_tmp31_ = layout;
				pango_layout_set_spacing (_tmp31_, 0);
				_tmp32_ = layout;
				pango_layout_set_width (_tmp32_, (PANGO_SCALE * q_width) / 2);
				_tmp33_ = layout;
				pango_layout_set_ellipsize (_tmp33_, PANGO_ELLIPSIZE_END);
				_tmp34_ = layout;
				pango_layout_get_pixel_extents (_tmp34_, NULL, &_tmp35_);
				layout_rect = _tmp35_;
				if (middle_angle_n < q_angle) {
					PangoRectangle _tmp36_;
					_tmp36_ = layout_rect;
					tip_x = (gdouble) ((q_width - (_tmp36_.width / 2)) - hpadding);
					tip_y = tan (middle_angle_n) * tip_x;
				} else {
					PangoRectangle _tmp37_;
					_tmp37_ = layout_rect;
					tip_y = (gdouble) ((q_height - (_tmp37_.height / 2)) - vpadding);
					tip_x = tip_y / tan (middle_angle_n);
				}
				memset (&tooltip_rect, 0, sizeof (cairo_rectangle_t));
				_tmp38_ = layout_rect;
				_tmp39_ = padding;
				tooltip_rect.x = ((q_width + tip_x) - (_tmp38_.width / 2)) - _tmp39_.left;
				_tmp40_ = layout_rect;
				_tmp41_ = padding;
				tooltip_rect.y = ((q_height + tip_y) - (_tmp40_.height / 2)) - _tmp41_.top;
				_tmp42_ = layout_rect;
				tooltip_rect.width = (gdouble) (_tmp42_.width + hpadding);
				_tmp43_ = layout_rect;
				tooltip_rect.height = (gdouble) (_tmp43_.height + vpadding);
				a = middle_angle;
				i = 0;
				while (TRUE) {
					gint _tmp50_;
					if (!(a > (G_PI / 2))) {
						break;
					}
					if ((i % 2) == 0) {
						GtkAllocation _tmp44_;
						cairo_rectangle_t _tmp45_;
						cairo_rectangle_t _tmp46_;
						_tmp44_ = allocation;
						_tmp45_ = tooltip_rect;
						_tmp46_ = tooltip_rect;
						tooltip_rect.x = (_tmp44_.width - _tmp45_.x) - _tmp46_.width;
					} else {
						GtkAllocation _tmp47_;
						cairo_rectangle_t _tmp48_;
						cairo_rectangle_t _tmp49_;
						_tmp47_ = allocation;
						_tmp48_ = tooltip_rect;
						_tmp49_ = tooltip_rect;
						tooltip_rect.y = (_tmp47_.height - _tmp48_.y) - _tmp49_.height;
					}
					_tmp50_ = i;
					i = _tmp50_ + 1;
					a -= G_PI / 2;
				}
				memset (&_rect, 0, sizeof (GdkRectangle));
				_tmp51_ = tooltip_rect;
				_rect.x = (gint) (_tmp51_.x - 1);
				_tmp52_ = tooltip_rect;
				_rect.y = (gint) (_tmp52_.y - 1);
				_tmp53_ = tooltip_rect;
				_rect.width = (gint) (_tmp53_.width + 2);
				_tmp54_ = tooltip_rect;
				_rect.height = (gint) (_tmp54_.height + 2);
				_tmp55_ = last_rect;
				if (!gdk_rectangle_intersect (&_rect, &_tmp55_, NULL)) {
					GdkRectangle _tmp56_;
					cairo_rectangle_t _tmp57_;
					cairo_rectangle_t _tmp58_;
					gdouble middle_radius = 0.0;
					BaobabRingschartItem* _tmp59_;
					BaobabRingschartItem* _tmp60_;
					BaobabRingschartItem* _tmp61_;
					gdouble sector_center_x = 0.0;
					gdouble sector_center_y = 0.0;
					GtkAllocation _tmp62_;
					GtkAllocation _tmp63_;
					cairo_rectangle_t _tmp64_;
					cairo_rectangle_t _tmp65_;
					cairo_rectangle_t _tmp66_;
					cairo_rectangle_t _tmp67_;
					cairo_rectangle_t _tmp68_;
					GdkRGBA bg_color = {0};
					GtkStyleContext* _tmp69_;
					GdkRGBA _tmp70_ = {0};
					GdkRGBA _tmp71_;
					cairo_rectangle_t _tmp72_;
					cairo_rectangle_t _tmp73_;
					cairo_rectangle_t _tmp74_;
					cairo_rectangle_t _tmp75_;
					GtkStyleContext* _tmp76_;
					cairo_rectangle_t _tmp77_;
					cairo_rectangle_t _tmp78_;
					cairo_rectangle_t _tmp79_;
					cairo_rectangle_t _tmp80_;
					GtkStyleContext* _tmp81_;
					cairo_rectangle_t _tmp82_;
					cairo_rectangle_t _tmp83_;
					cairo_rectangle_t _tmp84_;
					cairo_rectangle_t _tmp85_;
					GtkStyleContext* _tmp86_;
					cairo_rectangle_t _tmp87_;
					GtkBorder _tmp88_;
					cairo_rectangle_t _tmp89_;
					GtkBorder _tmp90_;
					PangoLayout* _tmp91_;
					_tmp56_ = _rect;
					last_rect = _tmp56_;
					_tmp57_ = tooltip_rect;
					tooltip_rect.x = floor (_tmp57_.x);
					_tmp58_ = tooltip_rect;
					tooltip_rect.y = floor (_tmp58_.y);
					_tmp59_ = ringsitem;
					_tmp60_ = ringsitem;
					_tmp61_ = ringsitem;
					middle_radius = _tmp59_->min_radius + ((_tmp60_->max_radius - _tmp61_->min_radius) / 2);
					sector_center_x = q_width + (middle_radius * cos (middle_angle));
					sector_center_y = q_height + (middle_radius * sin (middle_angle));
					cairo_save (cr);
					_tmp62_ = allocation;
					_tmp63_ = allocation;
					cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) _tmp62_.width, (gdouble) _tmp63_.height);
					_tmp64_ = tooltip_rect;
					_tmp65_ = tooltip_rect;
					_tmp66_ = tooltip_rect;
					_tmp67_ = tooltip_rect;
					_tmp68_ = tooltip_rect;
					cairo_rectangle (cr, _tmp64_.x + _tmp65_.width, _tmp66_.y, -_tmp67_.width, _tmp68_.height);
					cairo_clip (cr);
					_tmp69_ = context;
					gtk_style_context_lookup_color (_tmp69_, "tooltip_bg_color", &_tmp70_);
					bg_color = _tmp70_;
					cairo_set_line_width (cr, (gdouble) 1);
					cairo_move_to (cr, sector_center_x, sector_center_y);
					_tmp71_ = bg_color;
					gdk_cairo_set_source_rgba (cr, &_tmp71_);
					_tmp72_ = tooltip_rect;
					_tmp73_ = tooltip_rect;
					_tmp74_ = tooltip_rect;
					_tmp75_ = tooltip_rect;
					cairo_line_to (cr, _tmp72_.x + (_tmp73_.width / 2), _tmp74_.y + (_tmp75_.height / 2));
					cairo_stroke (cr);
					cairo_restore (cr);
					cairo_arc (cr, sector_center_x, sector_center_y, 1.0, (gdouble) 0, 2 * G_PI);
					cairo_stroke (cr);
					_tmp76_ = context;
					_tmp77_ = tooltip_rect;
					_tmp78_ = tooltip_rect;
					_tmp79_ = tooltip_rect;
					_tmp80_ = tooltip_rect;
					gtk_render_background (_tmp76_, cr, _tmp77_.x, _tmp78_.y, _tmp79_.width, _tmp80_.height);
					_tmp81_ = context;
					_tmp82_ = tooltip_rect;
					_tmp83_ = tooltip_rect;
					_tmp84_ = tooltip_rect;
					_tmp85_ = tooltip_rect;
					gtk_render_frame (_tmp81_, cr, _tmp82_.x, _tmp83_.y, _tmp84_.width, _tmp85_.height);
					_tmp86_ = context;
					_tmp87_ = tooltip_rect;
					_tmp88_ = padding;
					_tmp89_ = tooltip_rect;
					_tmp90_ = padding;
					_tmp91_ = layout;
					gtk_render_layout (_tmp86_, cr, _tmp87_.x + _tmp88_.left, _tmp89_.y + _tmp90_.top, _tmp91_);
				}
				_g_free0 (markup);
				_g_object_unref0 (layout);
				_baobab_chart_item_unref0 (ringsitem);
				_baobab_chart_item_unref0 (item);
			}
		}
	}
	_tmp92_ = context;
	gtk_style_context_restore (_tmp92_);
	_g_object_unref0 (context);
}

static void
baobab_ringschart_real_draw_item (BaobabChart* base,
                                  cairo_t* cr,
                                  BaobabChartItem* item,
                                  gboolean highlighted)
{
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabRingschartItem* _tmp0_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp11_ = {0};
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp12_;
	GtkStyleContext* _tmp13_;
	GdkRGBA border_color = {0};
	GdkRGBA bg_color = {0};
	GtkStyleContext* _tmp14_;
	GdkRGBA _tmp15_ = {0};
	GtkStyleContext* _tmp16_;
	GdkRGBA _tmp17_ = {0};
	gint center_x = 0;
	GtkAllocation _tmp18_;
	gint center_y = 0;
	GtkAllocation _tmp19_;
	gdouble final_angle = 0.0;
	BaobabRingschartItem* _tmp20_;
	BaobabRingschartItem* _tmp21_;
	self = (BaobabRingschart*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _baobab_chart_item_ref0 (BAOBAB_IS_RINGSCHART_ITEM (item) ? ((BaobabRingschartItem*) item) : NULL);
	ringsitem = _tmp0_;
	if (self->priv->drawing_subtips) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		BaobabChartItem* _tmp3_;
		BaobabChartItem* _tmp4_;
		_tmp3_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			GList* _tmp5_;
			_tmp5_ = item->parent;
			_tmp2_ = _tmp5_ != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GList* _tmp6_;
			gconstpointer _tmp7_;
			BaobabChartItem* _tmp8_;
			BaobabChartItem* _tmp9_;
			_tmp6_ = item->parent;
			_tmp7_ = _tmp6_->data;
			_tmp8_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
			_tmp9_ = _tmp8_;
			_tmp1_ = ((BaobabChartItem*) _tmp7_) == _tmp9_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			BaobabChartItem* _tmp10_;
			_tmp10_ = _baobab_chart_item_ref0 (item);
			self->priv->subtip_items = g_list_append (self->priv->subtip_items, _tmp10_);
		}
	}
	cairo_set_line_width (cr, (gdouble) BAOBAB_RINGSCHART_ITEM_BORDER_WIDTH);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp11_);
	allocation = _tmp11_;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	context = _tmp13_;
	_tmp14_ = context;
	gtk_style_context_lookup_color (_tmp14_, "chart_borders", &_tmp15_);
	border_color = _tmp15_;
	_tmp16_ = context;
	gtk_style_context_lookup_color (_tmp16_, "theme_bg_color", &_tmp17_);
	bg_color = _tmp17_;
	_tmp18_ = allocation;
	center_x = _tmp18_.width / 2;
	_tmp19_ = allocation;
	center_y = _tmp19_.height / 2;
	_tmp20_ = ringsitem;
	_tmp21_ = ringsitem;
	final_angle = _tmp20_->start_angle + _tmp21_->angle;
	if (item->depth == ((guint) 0)) {
		PangoLayout* layout = NULL;
		PangoLayout* _tmp22_;
		gchar* markup = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		PangoLayout* _tmp30_;
		const gchar* _tmp31_;
		PangoLayout* _tmp32_;
		PangoLayout* _tmp33_;
		PangoRectangle layout_rect = {0};
		PangoLayout* _tmp34_;
		PangoRectangle _tmp35_ = {0};
		PangoRectangle _tmp36_;
		BaobabRingschartItem* _tmp37_;
		BaobabRingschartItem* _tmp43_;
		GdkRGBA _tmp44_;
		_tmp22_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
		layout = _tmp22_;
		_tmp23_ = item->size;
		_tmp24_ = g_markup_escape_text (_tmp23_, (gssize) -1);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat ("<span size=\"small\">", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp27_, "</span>", NULL);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		markup = _tmp29_;
		_tmp30_ = layout;
		_tmp31_ = markup;
		pango_layout_set_markup (_tmp30_, _tmp31_, -1);
		_tmp32_ = layout;
		pango_layout_set_indent (_tmp32_, 0);
		_tmp33_ = layout;
		pango_layout_set_spacing (_tmp33_, 0);
		_tmp34_ = layout;
		pango_layout_get_pixel_extents (_tmp34_, NULL, &_tmp35_);
		layout_rect = _tmp35_;
		_tmp36_ = layout_rect;
		_tmp37_ = ringsitem;
		if (((gdouble) _tmp36_.width) < (2 * _tmp37_->max_radius)) {
			GtkStyleContext* _tmp38_;
			PangoRectangle _tmp39_;
			PangoRectangle _tmp40_;
			PangoLayout* _tmp41_;
			BaobabRingschartItem* _tmp42_;
			_tmp38_ = context;
			_tmp39_ = layout_rect;
			_tmp40_ = layout_rect;
			_tmp41_ = layout;
			gtk_render_layout (_tmp38_, cr, (gdouble) (center_x - (_tmp39_.width / 2)), (gdouble) (center_y - (_tmp40_.height / 2)), _tmp41_);
			_tmp42_ = ringsitem;
			cairo_move_to (cr, (center_x + _tmp42_->max_radius) + 1, (gdouble) center_y);
		}
		_tmp43_ = ringsitem;
		cairo_arc (cr, (gdouble) center_x, (gdouble) center_y, _tmp43_->max_radius + 1, (gdouble) 0, 2 * G_PI);
		_tmp44_ = border_color;
		gdk_cairo_set_source_rgba (cr, &_tmp44_);
		cairo_stroke (cr);
		_g_free0 (markup);
		_g_object_unref0 (layout);
	} else {
		GdkRGBA fill_color = {0};
		BaobabRingschartItem* _tmp45_;
		GdkRGBA _tmp46_ = {0};
		BaobabRingschartItem* _tmp47_;
		BaobabRingschartItem* _tmp48_;
		BaobabRingschartItem* _tmp49_;
		BaobabRingschartItem* _tmp50_;
		GdkRGBA _tmp51_;
		GdkRGBA _tmp52_;
		BaobabRingschartItem* _tmp53_;
		_tmp45_ = ringsitem;
		baobab_chart_get_item_color ((BaobabChart*) self, (_tmp45_->start_angle / G_PI) * 99, item->depth, highlighted, &_tmp46_);
		fill_color = _tmp46_;
		_tmp47_ = ringsitem;
		_tmp48_ = ringsitem;
		cairo_arc (cr, (gdouble) center_x, (gdouble) center_y, _tmp47_->min_radius, _tmp48_->start_angle, final_angle);
		_tmp49_ = ringsitem;
		_tmp50_ = ringsitem;
		cairo_arc_negative (cr, (gdouble) center_x, (gdouble) center_y, _tmp49_->max_radius, final_angle, _tmp50_->start_angle);
		cairo_close_path (cr);
		_tmp51_ = fill_color;
		gdk_cairo_set_source_rgba (cr, &_tmp51_);
		cairo_fill_preserve (cr);
		_tmp52_ = bg_color;
		gdk_cairo_set_source_rgba (cr, &_tmp52_);
		cairo_stroke (cr);
		_tmp53_ = ringsitem;
		if (_tmp53_->continued) {
			GdkRGBA _tmp54_;
			BaobabRingschartItem* _tmp55_;
			BaobabRingschartItem* _tmp56_;
			_tmp54_ = border_color;
			gdk_cairo_set_source_rgba (cr, &_tmp54_);
			cairo_set_line_width (cr, (gdouble) 3);
			_tmp55_ = ringsitem;
			_tmp56_ = ringsitem;
			cairo_arc (cr, (gdouble) center_x, (gdouble) center_y, _tmp55_->max_radius + 4, _tmp56_->start_angle + BAOBAB_RINGSCHART_EDGE_ANGLE, final_angle - BAOBAB_RINGSCHART_EDGE_ANGLE);
			cairo_stroke (cr);
		}
	}
	_g_object_unref0 (context);
	_baobab_chart_item_unref0 (ringsitem);
}

static void
baobab_ringschart_real_calculate_item_geometry (BaobabChart* base,
                                                BaobabChartItem* item)
{
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabRingschartItem* _tmp0_;
	BaobabRingschartItem* _tmp1_;
	BaobabRingschartItem* _tmp2_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp3_ = {0};
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkBorder padding = {0};
	GtkStyleContext* _tmp6_;
	GtkBorder _tmp7_ = {0};
	gint max_radius = 0;
	GtkAllocation _tmp8_;
	GtkAllocation _tmp9_;
	GtkBorder _tmp10_;
	guint thickness = 0U;
	guint _tmp11_;
	guint _tmp12_;
	BaobabRingschartItem* _tmp13_;
	GList* _tmp14_;
	BaobabRingschartItem* _tmp45_;
	self = (BaobabRingschart*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = _baobab_chart_item_ref0 (BAOBAB_IS_RINGSCHART_ITEM (item) ? ((BaobabRingschartItem*) item) : NULL);
	ringsitem = _tmp0_;
	_tmp1_ = ringsitem;
	_tmp1_->continued = FALSE;
	_tmp2_ = ringsitem;
	((BaobabChartItem*) _tmp2_)->visible = FALSE;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp3_);
	allocation = _tmp3_;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	context = _tmp5_;
	_tmp6_ = context;
	gtk_style_context_get_padding (_tmp6_, &_tmp7_);
	padding = _tmp7_;
	_tmp8_ = allocation;
	_tmp9_ = allocation;
	_tmp10_ = padding;
	max_radius = MIN (_tmp8_.width / 2, _tmp9_.height / 2) - _tmp10_.left;
	_tmp11_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp12_ = _tmp11_;
	thickness = max_radius / (_tmp12_ + 1);
	_tmp13_ = ringsitem;
	_tmp14_ = ((BaobabChartItem*) _tmp13_)->parent;
	if (_tmp14_ == NULL) {
		BaobabRingschartItem* _tmp15_;
		BaobabRingschartItem* _tmp16_;
		BaobabRingschartItem* _tmp17_;
		BaobabRingschartItem* _tmp18_;
		_tmp15_ = ringsitem;
		_tmp15_->min_radius = (gdouble) 0;
		_tmp16_ = ringsitem;
		_tmp16_->max_radius = (gdouble) thickness;
		_tmp17_ = ringsitem;
		_tmp17_->start_angle = (gdouble) 0;
		_tmp18_ = ringsitem;
		_tmp18_->angle = 2 * G_PI;
	} else {
		BaobabRingschartItem* parent = NULL;
		GList* _tmp19_;
		gconstpointer _tmp20_;
		BaobabChartItem* _tmp21_;
		BaobabRingschartItem* _tmp22_;
		BaobabRingschartItem* _tmp23_;
		BaobabRingschartItem* _tmp24_;
		BaobabRingschartItem* _tmp25_;
		guint _tmp26_;
		guint _tmp27_;
		BaobabRingschartItem* _tmp30_;
		BaobabRingschartItem* _tmp31_;
		BaobabRingschartItem* _tmp32_;
		BaobabRingschartItem* _tmp33_;
		BaobabRingschartItem* _tmp34_;
		BaobabRingschartItem* _tmp35_;
		BaobabRingschartItem* _tmp36_;
		BaobabRingschartItem* _tmp37_;
		gboolean _tmp38_ = FALSE;
		BaobabRingschartItem* _tmp39_;
		BaobabRingschartItem* _tmp43_;
		BaobabRingschartItem* _tmp44_;
		_tmp19_ = item->parent;
		_tmp20_ = _tmp19_->data;
		_tmp21_ = (BaobabChartItem*) _tmp20_;
		_tmp22_ = _baobab_chart_item_ref0 (BAOBAB_IS_RINGSCHART_ITEM (_tmp21_) ? ((BaobabRingschartItem*) _tmp21_) : NULL);
		parent = _tmp22_;
		_tmp23_ = ringsitem;
		_tmp24_ = ringsitem;
		_tmp23_->min_radius = (gdouble) (((BaobabChartItem*) _tmp24_)->depth * thickness);
		_tmp25_ = ringsitem;
		_tmp26_ = baobab_chart_get_max_depth ((BaobabChart*) self);
		_tmp27_ = _tmp26_;
		if (((BaobabChartItem*) _tmp25_)->depth > _tmp27_) {
			_baobab_chart_item_unref0 (parent);
			_g_object_unref0 (context);
			_baobab_chart_item_unref0 (ringsitem);
			return;
		} else {
			BaobabRingschartItem* _tmp28_;
			BaobabRingschartItem* _tmp29_;
			_tmp28_ = ringsitem;
			_tmp29_ = ringsitem;
			_tmp28_->max_radius = _tmp29_->min_radius + thickness;
		}
		_tmp30_ = ringsitem;
		_tmp31_ = parent;
		_tmp32_ = ringsitem;
		_tmp30_->angle = (_tmp31_->angle * ((BaobabChartItem*) _tmp32_)->rel_size) / 100;
		_tmp33_ = ringsitem;
		if (_tmp33_->angle < BAOBAB_RINGSCHART_ITEM_MIN_ANGLE) {
			_baobab_chart_item_unref0 (parent);
			_g_object_unref0 (context);
			_baobab_chart_item_unref0 (ringsitem);
			return;
		}
		_tmp34_ = ringsitem;
		_tmp35_ = parent;
		_tmp36_ = parent;
		_tmp37_ = ringsitem;
		_tmp34_->start_angle = _tmp35_->start_angle + ((_tmp36_->angle * ((BaobabChartItem*) _tmp37_)->rel_start) / 100);
		_tmp39_ = ringsitem;
		if (((BaobabChartItem*) _tmp39_)->has_any_child) {
			BaobabRingschartItem* _tmp40_;
			guint _tmp41_;
			guint _tmp42_;
			_tmp40_ = ringsitem;
			_tmp41_ = baobab_chart_get_max_depth ((BaobabChart*) self);
			_tmp42_ = _tmp41_;
			_tmp38_ = ((BaobabChartItem*) _tmp40_)->depth == _tmp42_;
		} else {
			_tmp38_ = FALSE;
		}
		_tmp43_ = ringsitem;
		_tmp43_->continued = _tmp38_;
		_tmp44_ = parent;
		((BaobabChartItem*) _tmp44_)->has_visible_children = TRUE;
		_baobab_chart_item_unref0 (parent);
	}
	_tmp45_ = ringsitem;
	((BaobabChartItem*) _tmp45_)->visible = TRUE;
	baobab_chart_get_item_rectangle ((BaobabChart*) self, item);
	_g_object_unref0 (context);
	_baobab_chart_item_unref0 (ringsitem);
}

static void
baobab_ringschart_get_point_min_rect (BaobabRingschart* self,
                                      gdouble cx,
                                      gdouble cy,
                                      gdouble radius,
                                      gdouble angle,
                                      GdkRectangle* r)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	x = cx + (cos (angle) * radius);
	y = cy + (sin (angle) * radius);
	_tmp0_ = *r;
	(*r).x = MIN (_tmp0_.x, (gint) x);
	_tmp1_ = *r;
	(*r).y = MIN (_tmp1_.y, (gint) y);
	_tmp2_ = *r;
	(*r).width = MAX (_tmp2_.width, (gint) x);
	_tmp3_ = *r;
	(*r).height = MAX (_tmp3_.height, (gint) y);
}

static void
baobab_ringschart_real_get_item_rectangle (BaobabChart* base,
                                           BaobabChartItem* item)
{
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabRingschartItem* _tmp0_;
	GdkRectangle rect = {0};
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	gdouble r1 = 0.0;
	gdouble r2 = 0.0;
	gdouble a1 = 0.0;
	gdouble a2 = 0.0;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	BaobabRingschartItem* _tmp4_;
	BaobabRingschartItem* _tmp5_;
	BaobabRingschartItem* _tmp6_;
	BaobabRingschartItem* _tmp7_;
	BaobabRingschartItem* _tmp8_;
	GtkAllocation _tmp9_;
	GtkAllocation _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp17_ = FALSE;
	GdkRectangle _tmp19_;
	GdkRectangle _tmp20_;
	BaobabRingschartItem* _tmp21_;
	GdkRectangle _tmp22_;
	self = (BaobabRingschart*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = _baobab_chart_item_ref0 (BAOBAB_IS_RINGSCHART_ITEM (item) ? ((BaobabRingschartItem*) item) : NULL);
	ringsitem = _tmp0_;
	memset (&rect, 0, sizeof (GdkRectangle));
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp1_);
	allocation = _tmp1_;
	_tmp2_ = allocation;
	cx = (gdouble) (_tmp2_.width / 2);
	_tmp3_ = allocation;
	cy = (gdouble) (_tmp3_.height / 2);
	_tmp4_ = ringsitem;
	r1 = _tmp4_->min_radius;
	_tmp5_ = ringsitem;
	r2 = _tmp5_->max_radius;
	_tmp6_ = ringsitem;
	a1 = _tmp6_->start_angle;
	_tmp7_ = ringsitem;
	_tmp8_ = ringsitem;
	a2 = _tmp7_->start_angle + _tmp8_->angle;
	_tmp9_ = allocation;
	rect.x = _tmp9_.width;
	_tmp10_ = allocation;
	rect.y = _tmp10_.height;
	rect.width = 0;
	rect.height = 0;
	baobab_ringschart_get_point_min_rect (self, cx, cy, r1, a1, &rect);
	baobab_ringschart_get_point_min_rect (self, cx, cy, r2, a1, &rect);
	baobab_ringschart_get_point_min_rect (self, cx, cy, r1, a2, &rect);
	baobab_ringschart_get_point_min_rect (self, cx, cy, r2, a2, &rect);
	if (a1 <= (G_PI / 2)) {
		_tmp11_ = a2 >= (G_PI / 2);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GdkRectangle _tmp12_;
		_tmp12_ = rect;
		rect.height = (gint) MAX ((gdouble) _tmp12_.height, cy + (sin (G_PI / 2) * r2));
	}
	if (a1 <= G_PI) {
		_tmp13_ = a2 >= G_PI;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GdkRectangle _tmp14_;
		_tmp14_ = rect;
		rect.x = (gint) MIN ((gdouble) _tmp14_.x, cx + (cos (G_PI) * r2));
	}
	if (a1 <= (G_PI * 1.5)) {
		_tmp15_ = a2 >= (G_PI * 1.5);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GdkRectangle _tmp16_;
		_tmp16_ = rect;
		rect.y = (gint) MIN ((gdouble) _tmp16_.y, cy + (sin (G_PI * 1.5) * r2));
	}
	if (a1 <= (G_PI * 2)) {
		_tmp17_ = a2 >= (G_PI * 2);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		GdkRectangle _tmp18_;
		_tmp18_ = rect;
		rect.width = (gint) MAX ((gdouble) _tmp18_.width, cx + (cos (G_PI * 2) * r2));
	}
	_tmp19_ = rect;
	rect.width = rect.width - _tmp19_.x;
	_tmp20_ = rect;
	rect.height = rect.height - _tmp20_.y;
	_tmp21_ = ringsitem;
	_tmp22_ = rect;
	((BaobabChartItem*) _tmp21_)->rect = _tmp22_;
	_baobab_chart_item_unref0 (ringsitem);
}

static gboolean
baobab_ringschart_real_is_point_over_item (BaobabChart* base,
                                           BaobabChartItem* item,
                                           gdouble x,
                                           gdouble y)
{
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabRingschartItem* _tmp0_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	gdouble radius = 0.0;
	gdouble angle = 0.0;
	gdouble _tmp4_ = 0.0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	BaobabRingschartItem* _tmp8_;
	gboolean result;
	self = (BaobabRingschart*) base;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = _baobab_chart_item_ref0 (BAOBAB_IS_RINGSCHART_ITEM (item) ? ((BaobabRingschartItem*) item) : NULL);
	ringsitem = _tmp0_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp1_);
	allocation = _tmp1_;
	_tmp2_ = allocation;
	x = x - (_tmp2_.width / 2);
	_tmp3_ = allocation;
	y = y - (_tmp3_.height / 2);
	radius = sqrt ((x * x) + (y * y));
	angle = atan2 (y, x);
	if (angle > ((gdouble) 0)) {
		_tmp4_ = angle;
	} else {
		_tmp4_ = angle + (2 * G_PI);
	}
	angle = _tmp4_;
	_tmp8_ = ringsitem;
	if (radius >= _tmp8_->min_radius) {
		BaobabRingschartItem* _tmp9_;
		_tmp9_ = ringsitem;
		_tmp7_ = radius <= _tmp9_->max_radius;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		BaobabRingschartItem* _tmp10_;
		_tmp10_ = ringsitem;
		_tmp6_ = angle >= _tmp10_->start_angle;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		BaobabRingschartItem* _tmp11_;
		BaobabRingschartItem* _tmp12_;
		_tmp11_ = ringsitem;
		_tmp12_ = ringsitem;
		_tmp5_ = angle <= (_tmp11_->start_angle + _tmp12_->angle);
	} else {
		_tmp5_ = FALSE;
	}
	result = _tmp5_;
	_baobab_chart_item_unref0 (ringsitem);
	return result;
}

static gboolean
baobab_ringschart_real_can_zoom_out (BaobabChart* base)
{
	BaobabRingschart * self;
	guint _tmp0_;
	guint _tmp1_;
	gboolean result;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ < BAOBAB_CHART_MAX_DEPTH;
	return result;
}

static gboolean
baobab_ringschart_real_can_zoom_in (BaobabChart* base)
{
	BaobabRingschart * self;
	guint _tmp0_;
	guint _tmp1_;
	gboolean result;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ > BAOBAB_CHART_MIN_DEPTH;
	return result;
}

BaobabRingschart*
baobab_ringschart_construct (GType object_type)
{
	BaobabRingschart * self = NULL;
	self = (BaobabRingschart*) baobab_chart_construct (object_type);
	return self;
}

BaobabRingschart*
baobab_ringschart_new (void)
{
	return baobab_ringschart_construct (BAOBAB_TYPE_RINGSCHART);
}

static void
_baobab_ringschart_subtips_update_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	baobab_ringschart_subtips_update ((BaobabRingschart*) self);
}

static GObject *
baobab_ringschart_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BaobabRingschart * self;
	parent_class = G_OBJECT_CLASS (baobab_ringschart_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART, BaobabRingschart);
	g_signal_connect_object ((GObject*) self, "notify::max-depth", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::highlighted-item", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::root", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	return obj;
}

static void
baobab_ringschart_class_init (BaobabRingschartClass * klass,
                              gpointer klass_data)
{
	baobab_ringschart_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabRingschart_private_offset);
	((BaobabChartClass *) klass)->create_new_chartitem = (BaobabChartItem* (*) (BaobabChart*)) baobab_ringschart_real_create_new_chartitem;
	((BaobabChartClass *) klass)->post_draw = (void (*) (BaobabChart*, cairo_t*)) baobab_ringschart_real_post_draw;
	((BaobabChartClass *) klass)->draw_item = (void (*) (BaobabChart*, cairo_t*, BaobabChartItem*, gboolean)) baobab_ringschart_real_draw_item;
	((BaobabChartClass *) klass)->calculate_item_geometry = (void (*) (BaobabChart*, BaobabChartItem*)) baobab_ringschart_real_calculate_item_geometry;
	((BaobabChartClass *) klass)->get_item_rectangle = (void (*) (BaobabChart*, BaobabChartItem*)) baobab_ringschart_real_get_item_rectangle;
	((BaobabChartClass *) klass)->is_point_over_item = (gboolean (*) (BaobabChart*, BaobabChartItem*, gdouble, gdouble)) baobab_ringschart_real_is_point_over_item;
	((BaobabChartClass *) klass)->can_zoom_out = (gboolean (*) (BaobabChart*)) baobab_ringschart_real_can_zoom_out;
	((BaobabChartClass *) klass)->can_zoom_in = (gboolean (*) (BaobabChart*)) baobab_ringschart_real_can_zoom_in;
	G_OBJECT_CLASS (klass)->constructor = baobab_ringschart_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_ringschart_finalize;
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "ringschart");
}

static void
baobab_ringschart_instance_init (BaobabRingschart * self,
                                 gpointer klass)
{
	self->priv = baobab_ringschart_get_instance_private (self);
	self->priv->tips_timeout_id = (guint) 0;
	self->priv->drawing_subtips = FALSE;
}

static void
baobab_ringschart_finalize (GObject * obj)
{
	BaobabRingschart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART, BaobabRingschart);
	(self->priv->subtip_items == NULL) ? NULL : (self->priv->subtip_items = (_g_list_free__baobab_chart_item_unref0_ (self->priv->subtip_items), NULL));
	G_OBJECT_CLASS (baobab_ringschart_parent_class)->finalize (obj);
}

static GType
baobab_ringschart_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabRingschartClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_ringschart_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabRingschart), 0, (GInstanceInitFunc) baobab_ringschart_instance_init, NULL };
	GType baobab_ringschart_type_id;
	baobab_ringschart_type_id = g_type_register_static (BAOBAB_TYPE_CHART, "BaobabRingschart", &g_define_type_info, 0);
	BaobabRingschart_private_offset = g_type_add_instance_private (baobab_ringschart_type_id, sizeof (BaobabRingschartPrivate));
	return baobab_ringschart_type_id;
}

GType
baobab_ringschart_get_type (void)
{
	static volatile gsize baobab_ringschart_type_id__once = 0;
	if (g_once_init_enter (&baobab_ringschart_type_id__once)) {
		GType baobab_ringschart_type_id;
		baobab_ringschart_type_id = baobab_ringschart_get_type_once ();
		g_once_init_leave (&baobab_ringschart_type_id__once, baobab_ringschart_type_id);
	}
	return baobab_ringschart_type_id__once;
}

