/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class CallContentMediaDescriptionInterface
 * \headerfile TelepathyQt/call-content-media-description.h <TelepathyQt/CallContentMediaDescriptionInterface>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Content.MediaDescription".
 */
class TP_QT_EXPORT CallContentMediaDescriptionInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Content.MediaDescription", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Content.MediaDescription");
    }

    /**
     * Creates a CallContentMediaDescriptionInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentMediaDescriptionInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentMediaDescriptionInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentMediaDescriptionInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentMediaDescriptionInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallContentMediaDescriptionInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c Interfaces of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>Extra interfaces provided by this media description. This SHOULD
     *   NOT include the Description interface itself.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInterfaces() const
    {
        return internalRequestProperty(QLatin1String("Interfaces"));
    }

    /**
     * Asynchronous getter for the remote object property \c FurtherNegotiationRequired of type \c bool.
     *
     * 
     * \htmlonly
     * <p> If this is set to True by the CM in a MediaDescriptionOffer, it
     *   means &quot;This is an offer under the SDP Offer/Answer model. Whatever
     *   you accept this offer with is what I will send to the other side in
     *   my answer.&quot;
     * 
     *   If this is set to False by the CM then it means &quot;This is an Answer
     *   under the SDP Offer/Answer model, and if it remains False in the
     *   Accept(), no further codec negotiation needs to happen.&quot;
     * 
     *   If this is set to True by the streaming implementation (e.g. in an
     *   Accept or UpdateLocalMediaDescription call) then a new SDP
     *   Offer/Answer round-trip will be initiated.
     * </p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyFurtherNegotiationRequired() const
    {
        return internalRequestProperty(QLatin1String("FurtherNegotiationRequired"));
    }

    /**
     * Asynchronous getter for the remote object property \c HasRemoteInformation of type \c bool.
     *
     * 
     * \htmlonly
     * <p> True if this offer contains information from the remote side:
     *     If False then the Accept response solely depends on the
     *     capabilities and preferences of the local side.
     * 
     *     In most protocols this property will be False for the initial
     *     DescriptionOffer on an outgoing call.
     * </p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHasRemoteInformation() const
    {
        return internalRequestProperty(QLatin1String("HasRemoteInformation"));
    }

    /**
     * Asynchronous getter for the remote object property \c Codecs of type \c Tp::CodecList.
     *
     * 
     * A list of codecs the remote contact supports. When used with Accept, it 
     * means the locally supported codecs.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCodecs() const
    {
        return internalRequestProperty(QLatin1String("Codecs"));
    }

    /**
     * Asynchronous getter for the remote object property \c RemoteContact of type \c uint.
     *
     * 
     * The contact handle that this description applies to. This property can 
     * be used as an opaque identifier, and searched for in RemoteMembers for 
     * each Stream in this Content, to determine which Stream this 
     * MediaDescription applies to. If multiple MediaDescriptions apply to the 
     * same Stream, the SSRCs property should be used to separate media before 
     * decoding. If this property is 0, this MediaDescription applies to all 
     * streams, so the above matching method is unneccesary (e.g. in 
     * conference calls with a mixer, media from all participants is mixed 
     * into one stream). When calling Accept or UpdateLocalMediaDescription, 
     * this should always be set to 0, or omitted, because it is assumed that 
     * you send the same MediaDescription to everyone (Encoding a stream 
     * separately for each contact in a call is inefficient, and should be 
     * avoided).
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRemoteContact() const
    {
        return internalRequestProperty(QLatin1String("RemoteContact"));
    }

    /**
     * Asynchronous getter for the remote object property \c SSRCs of type \c Tp::ContactSSRCsMap.
     *
     * 
     * \htmlonly
     * <p>A map from Handle to list of Synchronisation Sources, as defined by
     * RFC 3550.</p>
     * 
     * <p>Some protocols require the negotiation of SSRC identifiers for RTP
     * streams. If this is the case, then MediaDescription offers will appear
     * with this property set. The streaming implementation should then call
     *  \endhtmlonly Accept() \htmlonly  with a map from 0 to a
     * list containing a single SSRC (which does not collide with these,
     * or any previously seen SSRCs). If a new MediaDescription offer
     * appears with an SSRC the same as one in  \endhtmlonly \link CallContentInterfaceMediaInterface::requestPropertyLocalMediaDescriptions() CallContentInterfaceMediaInterface::LocalMediaDescriptions \endlink \htmlonly , then the streaming
     * implementation should pick a new SSRC to resolve the collision.</p>
     * 
     * <p>It is expected that this list will normally be at most one element long,
     * but it is kept as a list for extensibility. The concatenation of all
     * SSRCs associated with a Stream should contain no duplicate entries. If
     * there are collisions, then it is the responsibility of the protocol
     * implementation to resolve them and generate new offers.</p>
     * 
     * <p>If this property is omitted, then the streaming implementation can
     * assume that there is only one MediaDescription per Stream.</p>
     * 
     * <p>If there is a single multicast Call Stream with multiple
     * Remote Members, and all members are forced to use the same
     * MediaDescription, this map can be used by the streaming implementation
     * to determine which video sources belong to which contacts (e.g. in
     * order to put a name under each face in the call)</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySSRCs() const
    {
        return internalRequestProperty(QLatin1String("SSRCs"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Accept on the remote object.
     * 
     * Accepts the updated Description and update the corresponding local 
     * description. If FurtherNegotiationRequired is True, calling this method 
     * will generally cause a network round-trip and a new MediaDescription to 
     * be offered (hopefully with FurtherNegotiationRequired set to False).
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param localMediaDescription
     *     
     *     The local description to send to the remote contacts and to use in 
     *     the Content.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Accept(const QVariantMap& localMediaDescription, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Accept"));
        callMessage << QVariant::fromValue(localMediaDescription);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Reject on the remote object.
     * 
     * Reject the proposed update to the remote description.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param reason
     *     
     *     A structured reason for the rejection.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Reject(const Tp::CallStateReason& reason, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Reject"));
        callMessage << QVariant::fromValue(reason);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface
 * \headerfile TelepathyQt/call-content-media-description.h <TelepathyQt/CallContentMediaDescriptionInterface>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTCPExtendedReports".
 */
class TP_QT_EXPORT CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTCPExtendedReports", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTCPExtendedReports");
    }

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface);

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c LossRLEMaxSize of type \c uint.
     *
     * 
     * If non-zero, enable Loss Run Length Encoded Report Blocks. The value of 
     * this integer represents the max-size of report blocks, as specified in 
     * RFC 3611 section 5.1. MAXUINT32 is used to indicate that there is no 
     * limit.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyLossRLEMaxSize() const
    {
        return internalRequestProperty(QLatin1String("LossRLEMaxSize"));
    }

    /**
     * Asynchronous getter for the remote object property \c DuplicateRLEMaxSize of type \c uint.
     *
     * 
     * If non-zero, enable Duplicate Run-Length-Encoded Report Blocks. The 
     * value of this integer represents the max-size of report blocks, as 
     * specified in RFC 3611 section 5.1. MAXUINT32 is used to indicate that 
     * there is no limit.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDuplicateRLEMaxSize() const
    {
        return internalRequestProperty(QLatin1String("DuplicateRLEMaxSize"));
    }

    /**
     * Asynchronous getter for the remote object property \c PacketReceiptTimesMaxSize of type \c uint.
     *
     * 
     * If non-zero, enable Packet Receipt Times Report Blocks. The value of 
     * this integer represents the max-size of report blocks, as specified in 
     * RFC 3611 section 5.1. MAXUINT32 is used to indicate that there is no 
     * limit.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyPacketReceiptTimesMaxSize() const
    {
        return internalRequestProperty(QLatin1String("PacketReceiptTimesMaxSize"));
    }

    /**
     * Asynchronous getter for the remote object property \c DLRRMaxSize of type \c uint.
     *
     * 
     * If non-zero, enable Receiver Reference Time and Delay since Last 
     * Receiver Report Blocks (for estimating Round Trip Times between 
     * non-senders and other parties in the call. The value of this integer 
     * represents the max-size of report blocks, as specified in RFC 3611 
     * section 5.1. MAXUINT32 is used to indicate that there is no limit.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDLRRMaxSize() const
    {
        return internalRequestProperty(QLatin1String("DLRRMaxSize"));
    }

    /**
     * Asynchronous getter for the remote object property \c RTTMode of type \c uint.
     *
     * 
     * Who is allowed to send Delay since Last Receiver Reports.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRTTMode() const
    {
        return internalRequestProperty(QLatin1String("RTTMode"));
    }

    /**
     * Asynchronous getter for the remote object property \c StatisticsFlags of type \c uint.
     *
     * 
     * Which fields SHOULD be included in the statistics summary report blocks 
     * that are sent, and whether to send VoIP Metrics Report Blocks. There 
     * can be zero or more flags set.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyStatisticsFlags() const
    {
        return internalRequestProperty(QLatin1String("StatisticsFlags"));
    }

    /**
     * Asynchronous getter for the remote object property \c EnableMetrics of type \c bool.
     *
     * 
     * Whether to enable VoIP Metrics Report Blocks. These blocks are of a 
     * fixed size.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyEnableMetrics() const
    {
        return internalRequestProperty(QLatin1String("EnableMetrics"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class CallContentMediaDescriptionInterfaceRTCPFeedbackInterface
 * \headerfile TelepathyQt/call-content-media-description.h <TelepathyQt/CallContentMediaDescriptionInterface>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTCPFeedback".
 */
class TP_QT_EXPORT CallContentMediaDescriptionInterfaceRTCPFeedbackInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTCPFeedback", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTCPFeedback");
    }

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTCPFeedbackInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentMediaDescriptionInterfaceRTCPFeedbackInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTCPFeedbackInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentMediaDescriptionInterfaceRTCPFeedbackInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTCPFeedbackInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallContentMediaDescriptionInterfaceRTCPFeedbackInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTCPFeedbackInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit CallContentMediaDescriptionInterfaceRTCPFeedbackInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface);

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTCPFeedbackInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    CallContentMediaDescriptionInterfaceRTCPFeedbackInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c FeedbackMessages of type \c Tp::RTCPFeedbackMessageMap.
     *
     * 
     * A map of remote feedback codec properties that are supported.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyFeedbackMessages() const
    {
        return internalRequestProperty(QLatin1String("FeedbackMessages"));
    }

    /**
     * Asynchronous getter for the remote object property \c DoesAVPF of type \c bool.
     *
     * 
     * True if the remote contact supports Audio-Visual Profile Feedback 
     * (AVPF), otherwise False.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDoesAVPF() const
    {
        return internalRequestProperty(QLatin1String("DoesAVPF"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface
 * \headerfile TelepathyQt/call-content-media-description.h <TelepathyQt/CallContentMediaDescriptionInterface>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTPHeaderExtensions".
 */
class TP_QT_EXPORT CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTPHeaderExtensions", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTPHeaderExtensions");
    }

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface);

    /**
     * Creates a CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c HeaderExtensions of type \c Tp::RTPHeaderExtensionsList.
     *
     * 
     * A list of remote header extensions which are supported.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHeaderExtensions() const
    {
        return internalRequestProperty(QLatin1String("HeaderExtensions"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::CallContentMediaDescriptionInterface*)
Q_DECLARE_METATYPE(Tp::Client::CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface*)
Q_DECLARE_METATYPE(Tp::Client::CallContentMediaDescriptionInterfaceRTCPFeedbackInterface*)
Q_DECLARE_METATYPE(Tp::Client::CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface*)
