/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class PropertiesInterfaceInterface
 * \headerfile TelepathyQt/properties.h <TelepathyQt/Properties>
 * \ingroup clientprops
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Properties".
 */
class TP_QT_EXPORT PropertiesInterfaceInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Properties", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Properties");
    }

    /**
     * Creates a PropertiesInterfaceInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    PropertiesInterfaceInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a PropertiesInterfaceInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    PropertiesInterfaceInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a PropertiesInterfaceInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    PropertiesInterfaceInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a PropertiesInterfaceInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit PropertiesInterfaceInterface(const Tp::AbstractInterface& mainInterface);

    /**
     * Creates a PropertiesInterfaceInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    PropertiesInterfaceInterface(const Tp::AbstractInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetProperties on the remote object.
     * 
     * Returns an array of (identifier, value) pairs containing the current 
     * values of the given properties.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param properties
     *     
     *     An array of property identifiers
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>An array of structs containing:</p>
     *     <ul>
     *       <li>integer identifiers</li>
     *       <li>variant boxed values</li>
     *     </ul>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::PropertyValueList> GetProperties(const Tp::UIntList& properties, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::PropertyValueList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetProperties"));
        callMessage << QVariant::fromValue(properties);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ListProperties on the remote object.
     * 
     * Returns a dictionary of the properties available on this channel.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     An array of structs containing: an integer identifier a string 
     *     property name a string representing the D-Bus signature of this 
     *     property a bitwise OR of the flags applicable to this property
     */
    inline QDBusPendingReply<Tp::PropertySpecList> ListProperties(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::PropertySpecList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ListProperties"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetProperties on the remote object.
     * 
     * \htmlonly
     * <p>Takes an array of (identifier, value) pairs containing desired
     *   values to set the given properties. In the case of any errors, no
     *   properties will be changed. When the changes have been acknowledged
     *   by the server, the PropertiesChanged signal will be emitted.</p>
     * 
     * <p>All properties given must have the PROPERTY_FLAG_WRITE flag, or
     * PermissionDenied will be returned. If any variants are of the wrong
     * type, NotAvailable will be returned.  If any given property identifiers
     * are invalid, InvalidArgument will be returned.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param properties
     *     
     *     An array mapping integer property identifiers to boxed values
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetProperties(const Tp::PropertyValueList& properties, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetProperties"));
        callMessage << QVariant::fromValue(properties);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c PropertiesChanged on the remote object.
     * 
     * Emitted when the value of readable properties has changed.
     *
     * \param properties
     *     
     *     \htmlonly
     *     <p>An array of structs containing:</p>
     *     <ul>
     *       <li>integer identifiers</li>
     *       <li>variant boxed values</li>
     *     </ul>
     *     <p>The array should contain only properties whose values have
     *       actually changed.</p>
     *     \endhtmlonly
     */
    void PropertiesChanged(const Tp::PropertyValueList& properties);

    /**
     * Represents the signal \c PropertyFlagsChanged on the remote object.
     * 
     * Emitted when the flags of some room properties have changed.
     *
     * \param properties
     *     
     *     \htmlonly
     *     <p>An array of structs containing:</p>
     *     <ul>
     *       <li>integer identifiers</li>
     *       <li>a bitwise OR of the current flags</li>
     *     </ul>
     *     <p>The array should contain only properties whose flags have actually
     *       changed.</p>
     *     \endhtmlonly
     */
    void PropertyFlagsChanged(const Tp::PropertyFlagsChangeList& properties);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::PropertiesInterfaceInterface*)
