/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.apache.tomcat.util.res.StringManager;

public class ProxyErrorReportValve
extends ErrorReportValve {
    private static final Log log = LogFactory.getLog(ProxyErrorReportValve.class);
    protected boolean useRedirect = true;
    protected boolean usePropertiesFile = false;

    public boolean getUseRedirect() {
        return this.useRedirect;
    }

    public void setUseRedirect(boolean bl) {
        this.useRedirect = bl;
    }

    public boolean getUsePropertiesFile() {
        return this.usePropertiesFile;
    }

    public void setUsePropertiesFile(boolean bl) {
        this.usePropertiesFile = bl;
    }

    private String getRedirectUrl(Response response) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getClass().getSimpleName(), response.getLocale());
        String string = null;
        try {
            string = resourceBundle.getString(Integer.toString(response.getStatus()));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string == null) {
            try {
                string = resourceBundle.getString(Integer.toString(0));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void report(Request request, Response response, Throwable throwable) {
        Object object;
        int n = response.getStatus();
        if (n < 400 || response.getContentWritten() > 0L) {
            return;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, (Object)atomicBoolean);
        if (!atomicBoolean.get()) {
            return;
        }
        String string = null;
        if (this.usePropertiesFile) {
            string = this.getRedirectUrl(response);
        } else {
            object = this.findErrorPage(n, throwable);
            if (object != null) {
                string = object.getLocation();
            }
        }
        if (string == null) {
            super.report(request, response, throwable);
            return;
        }
        if (!response.setErrorReported()) {
            return;
        }
        object = new StringBuilder(string);
        if (string.indexOf("?") > -1) {
            ((StringBuilder)object).append('&');
        } else {
            ((StringBuilder)object).append('?');
        }
        ((StringBuilder)object).append("requestUri=");
        ((StringBuilder)object).append(URLEncoder.encode(request.getDecodedRequestURI(), request.getConnector().getURICharset()));
        ((StringBuilder)object).append("&statusCode=");
        ((StringBuilder)object).append(URLEncoder.encode(String.valueOf(n), StandardCharsets.UTF_8));
        String string2 = null;
        String string3 = null;
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.valves", request.getLocales());
        response.setLocale(stringManager.getLocale());
        try {
            string2 = stringManager.getString("http." + n + ".reason");
            string3 = stringManager.getString("http." + n + ".desc");
        }
        catch (Throwable throwable2) {
            ExceptionUtils.handleThrowable((Throwable)throwable2);
        }
        if (string2 == null || string3 == null) {
            string2 = stringManager.getString("errorReportValve.unknownReason");
            string3 = stringManager.getString("errorReportValve.noDescription");
        }
        ((StringBuilder)object).append("&statusDescription=");
        ((StringBuilder)object).append(URLEncoder.encode(string3, StandardCharsets.UTF_8));
        ((StringBuilder)object).append("&statusReason=");
        ((StringBuilder)object).append(URLEncoder.encode(string2, StandardCharsets.UTF_8));
        String string4 = response.getMessage();
        if (string4 != null) {
            ((StringBuilder)object).append("&message=");
            ((StringBuilder)object).append(URLEncoder.encode(string4, StandardCharsets.UTF_8));
        }
        if (throwable != null) {
            ((StringBuilder)object).append("&throwable=");
            ((StringBuilder)object).append(URLEncoder.encode(throwable.toString(), StandardCharsets.UTF_8));
        }
        string = ((StringBuilder)object).toString();
        if (this.useRedirect) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Redirecting error reporting to " + string));
            }
            try {
                response.sendRedirect(string);
            }
            catch (IOException iOException) {}
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Proxying error reporting to " + string));
            }
            HttpURLConnection httpURLConnection = null;
            try {
                URL uRL = new URI(string).toURL();
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.connect();
                response.setContentType(httpURLConnection.getContentType());
                response.setContentLength(httpURLConnection.getContentLength());
                ServletOutputStream servletOutputStream = response.getOutputStream();
                InputStream inputStream = uRL.openStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)servletOutputStream);
            }
            catch (IOException | URISyntaxException exception) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Proxy error to " + string), (Throwable)exception);
                }
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
    }
}

