"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAnsibleCommandExecPath = void 0;
// utils function to resolve executable path
const path = require("path");
/**
 * A method to return the path to the provided executable
 * @param name String representing the name of the ansible executable
 * @param settings The settings received from client
 * @returns Complete path of the ansible executable (string)
 */
function getAnsibleCommandExecPath(name, settings) {
    return name === "ansible-lint"
        ? settings.validation.lint.path
        : path.join(path.dirname(settings.ansible.path), name);
}
exports.getAnsibleCommandExecPath = getAnsibleCommandExecPath;
//# sourceMappingURL=execPath.js.map